/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.sun.security.ssl;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.crypto.SecretKey;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.openjsse.javax.net.ssl.ExtendedSSLSession;
import org.openjsse.sun.security.ssl.CipherSuite;
import org.openjsse.sun.security.ssl.HandshakeContext;
import org.openjsse.sun.security.ssl.ProtocolVersion;
import org.openjsse.sun.security.ssl.SSLExtension;
import org.openjsse.sun.security.ssl.SSLLogger;
import org.openjsse.sun.security.ssl.SSLSessionContextImpl;
import org.openjsse.sun.security.ssl.SecureKey;
import org.openjsse.sun.security.ssl.SessionId;
import org.openjsse.sun.security.ssl.SignatureScheme;
import org.openjsse.sun.security.ssl.Utilities;

final class SSLSessionImpl
extends ExtendedSSLSession {
    private final ProtocolVersion protocolVersion;
    private final SessionId sessionId;
    private java.security.cert.X509Certificate[] peerCerts;
    private CipherSuite cipherSuite;
    private SecretKey masterSecret;
    final boolean useExtendedMasterSecret;
    private final long creationTime;
    private long lastUsedTime = 0L;
    private final String host;
    private final int port;
    private SSLSessionContextImpl context;
    private boolean invalidated;
    private java.security.cert.X509Certificate[] localCerts;
    private PrivateKey localPrivateKey;
    private final Collection<SignatureScheme> localSupportedSignAlgs;
    private String[] peerSupportedSignAlgs;
    private boolean useDefaultPeerSignAlgs = false;
    private List<byte[]> statusResponses;
    private SecretKey resumptionMasterSecret;
    private SecretKey preSharedKey;
    private byte[] pskIdentity;
    private final long ticketCreationTime = System.currentTimeMillis();
    private int ticketAgeAdd;
    private int negotiatedMaxFragLen = -1;
    private int maximumPacketSize;
    private final Queue<SSLSessionImpl> childSessions = new ConcurrentLinkedQueue<SSLSessionImpl>();
    private boolean isSessionResumption = false;
    private static boolean defaultRejoinable = true;
    final SNIServerName serverNameIndication;
    private final List<SNIServerName> requestedServerNames;
    private BigInteger ticketNonceCounter = BigInteger.ONE;
    private final String identificationProtocol;
    private X500Principal[] certificateAuthorities;
    private final ConcurrentHashMap<SecureKey, Object> boundValues;
    private boolean acceptLargeFragments = Utilities.getBooleanProperty("jsse.SSLEngine.acceptLargeFragments", false);

    SSLSessionImpl() {
        this.protocolVersion = ProtocolVersion.NONE;
        this.cipherSuite = CipherSuite.C_NULL;
        this.sessionId = new SessionId(false, null);
        this.host = null;
        this.port = -1;
        this.localSupportedSignAlgs = Collections.emptySet();
        this.serverNameIndication = null;
        this.requestedServerNames = Collections.emptyList();
        this.useExtendedMasterSecret = false;
        this.creationTime = System.currentTimeMillis();
        this.identificationProtocol = null;
        this.boundValues = new ConcurrentHashMap();
    }

    SSLSessionImpl(HandshakeContext hc, CipherSuite cipherSuite) {
        this(hc, cipherSuite, new SessionId(defaultRejoinable, hc.sslContext.getSecureRandom()));
    }

    SSLSessionImpl(HandshakeContext hc, CipherSuite cipherSuite, SessionId id) {
        this(hc, cipherSuite, id, System.currentTimeMillis());
    }

    SSLSessionImpl(HandshakeContext hc, CipherSuite cipherSuite, SessionId id, long creationTime) {
        this.protocolVersion = hc.negotiatedProtocol;
        this.cipherSuite = cipherSuite;
        this.sessionId = id;
        this.host = hc.conContext.transport.getPeerHost();
        this.port = hc.conContext.transport.getPeerPort();
        this.localSupportedSignAlgs = hc.localSupportedSignAlgs == null ? Collections.emptySet() : Collections.unmodifiableCollection(new ArrayList<SignatureScheme>(hc.localSupportedSignAlgs));
        this.serverNameIndication = hc.negotiatedServerName;
        this.requestedServerNames = Collections.unmodifiableList(new ArrayList<SNIServerName>(hc.getRequestedServerNames()));
        this.useExtendedMasterSecret = hc.sslConfig.isClientMode ? hc.handshakeExtensions.get(SSLExtension.CH_EXTENDED_MASTER_SECRET) != null && hc.handshakeExtensions.get(SSLExtension.SH_EXTENDED_MASTER_SECRET) != null : hc.handshakeExtensions.get(SSLExtension.CH_EXTENDED_MASTER_SECRET) != null && !hc.negotiatedProtocol.useTLS13PlusSpec();
        this.creationTime = creationTime;
        this.identificationProtocol = hc.sslConfig.identificationProtocol;
        this.boundValues = new ConcurrentHashMap();
        if (SSLLogger.isOn && SSLLogger.isOn("session")) {
            SSLLogger.finest("Session initialized:  " + this, new Object[0]);
        }
    }

    SSLSessionImpl(SSLSessionImpl baseSession, SessionId newId) {
        this.protocolVersion = baseSession.getProtocolVersion();
        this.cipherSuite = baseSession.cipherSuite;
        this.sessionId = newId;
        this.host = baseSession.getPeerHost();
        this.port = baseSession.getPeerPort();
        this.localSupportedSignAlgs = baseSession.localSupportedSignAlgs == null ? Collections.emptySet() : baseSession.localSupportedSignAlgs;
        this.peerSupportedSignAlgs = baseSession.getPeerSupportedSignatureAlgorithms();
        this.serverNameIndication = baseSession.serverNameIndication;
        this.requestedServerNames = baseSession.getRequestedServerNames();
        this.masterSecret = baseSession.getMasterSecret();
        this.useExtendedMasterSecret = baseSession.useExtendedMasterSecret;
        this.creationTime = baseSession.getCreationTime();
        this.lastUsedTime = System.currentTimeMillis();
        this.identificationProtocol = baseSession.getIdentificationProtocol();
        this.localCerts = baseSession.localCerts;
        this.peerCerts = baseSession.peerCerts;
        this.statusResponses = baseSession.statusResponses;
        this.resumptionMasterSecret = baseSession.resumptionMasterSecret;
        this.context = baseSession.context;
        this.negotiatedMaxFragLen = baseSession.negotiatedMaxFragLen;
        this.maximumPacketSize = baseSession.maximumPacketSize;
        this.boundValues = baseSession.boundValues;
        if (SSLLogger.isOn && SSLLogger.isOn("session")) {
            SSLLogger.finest("Session initialized:  " + this, new Object[0]);
        }
    }

    void setMasterSecret(SecretKey secret) {
        this.masterSecret = secret;
    }

    void setResumptionMasterSecret(SecretKey secret) {
        this.resumptionMasterSecret = secret;
    }

    void setPreSharedKey(SecretKey key) {
        this.preSharedKey = key;
    }

    void addChild(SSLSessionImpl session) {
        this.childSessions.add(session);
    }

    void setTicketAgeAdd(int ticketAgeAdd) {
        this.ticketAgeAdd = ticketAgeAdd;
    }

    void setPskIdentity(byte[] pskIdentity) {
        this.pskIdentity = pskIdentity;
    }

    BigInteger incrTicketNonceCounter() {
        BigInteger result = this.ticketNonceCounter;
        this.ticketNonceCounter = this.ticketNonceCounter.add(BigInteger.valueOf(1L));
        return result;
    }

    SecretKey getMasterSecret() {
        return this.masterSecret;
    }

    SecretKey getResumptionMasterSecret() {
        return this.resumptionMasterSecret;
    }

    synchronized SecretKey getPreSharedKey() {
        return this.preSharedKey;
    }

    synchronized SecretKey consumePreSharedKey() {
        try {
            SecretKey secretKey = this.preSharedKey;
            return secretKey;
        }
        finally {
            this.preSharedKey = null;
        }
    }

    int getTicketAgeAdd() {
        return this.ticketAgeAdd;
    }

    String getIdentificationProtocol() {
        return this.identificationProtocol;
    }

    synchronized byte[] consumePskIdentity() {
        try {
            byte[] byArray = this.pskIdentity;
            return byArray;
        }
        finally {
            this.pskIdentity = null;
        }
    }

    void setPeerCertificates(java.security.cert.X509Certificate[] peer) {
        if (this.peerCerts == null) {
            this.peerCerts = peer;
        }
    }

    void setLocalCertificates(java.security.cert.X509Certificate[] local) {
        this.localCerts = local;
    }

    void setLocalPrivateKey(PrivateKey privateKey) {
        this.localPrivateKey = privateKey;
    }

    void setPeerSupportedSignatureAlgorithms(Collection<SignatureScheme> signatureSchemes) {
        this.peerSupportedSignAlgs = SignatureScheme.getAlgorithmNames(signatureSchemes);
    }

    void setUseDefaultPeerSignAlgs() {
        this.useDefaultPeerSignAlgs = true;
        this.peerSupportedSignAlgs = new String[]{"SHA1withRSA", "SHA1withDSA", "SHA1withECDSA"};
    }

    SSLSessionImpl finish() {
        if (this.useDefaultPeerSignAlgs) {
            this.peerSupportedSignAlgs = new String[0];
        }
        return this;
    }

    void setStatusResponses(List<byte[]> responses) {
        this.statusResponses = responses != null && !responses.isEmpty() ? responses : Collections.emptyList();
    }

    boolean isRejoinable() {
        return this.sessionId != null && this.sessionId.length() != 0 && !this.invalidated && this.isLocalAuthenticationValid();
    }

    @Override
    public synchronized boolean isValid() {
        return this.isRejoinable();
    }

    private boolean isLocalAuthenticationValid() {
        if (this.localPrivateKey != null) {
            try {
                this.localPrivateKey.getAlgorithm();
            }
            catch (Exception e) {
                this.invalidate();
                return false;
            }
        }
        return true;
    }

    @Override
    public byte[] getId() {
        return this.sessionId.getId();
    }

    @Override
    public SSLSessionContext getSessionContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.context;
    }

    SessionId getSessionId() {
        return this.sessionId;
    }

    CipherSuite getSuite() {
        return this.cipherSuite;
    }

    void setSuite(CipherSuite suite) {
        this.cipherSuite = suite;
        if (SSLLogger.isOn && SSLLogger.isOn("session")) {
            SSLLogger.finest("Negotiating session:  " + this, new Object[0]);
        }
    }

    boolean isSessionResumption() {
        return this.isSessionResumption;
    }

    void setAsSessionResumption(boolean flag) {
        this.isSessionResumption = flag;
    }

    @Override
    public String getCipherSuite() {
        return this.getSuite().name;
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public String getProtocol() {
        return this.getProtocolVersion().name;
    }

    public int hashCode() {
        return this.sessionId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SSLSessionImpl) {
            SSLSessionImpl sess = (SSLSessionImpl)obj;
            return this.sessionId != null && this.sessionId.equals(sess.getSessionId());
        }
        return false;
    }

    void setCertificateAuthorities(X500Principal[] certificateAuthorities) {
        this.certificateAuthorities = certificateAuthorities;
    }

    X500Principal[] getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        return (Certificate[])this.peerCerts.clone();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.localCerts == null ? null : (Certificate[])this.localCerts.clone();
    }

    @Override
    @Deprecated
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        X509Certificate[] certs = new X509Certificate[this.peerCerts.length];
        for (int i = 0; i < this.peerCerts.length; ++i) {
            byte[] der = null;
            try {
                der = this.peerCerts[i].getEncoded();
                certs[i] = X509Certificate.getInstance(der);
                continue;
            }
            catch (CertificateEncodingException e) {
                throw new SSLPeerUnverifiedException(e.getMessage());
            }
            catch (CertificateException e) {
                throw new SSLPeerUnverifiedException(e.getMessage());
            }
        }
        return certs;
    }

    public java.security.cert.X509Certificate[] getCertificateChain() throws SSLPeerUnverifiedException {
        if (this.peerCerts != null) {
            return (java.security.cert.X509Certificate[])this.peerCerts.clone();
        }
        throw new SSLPeerUnverifiedException("peer not authenticated");
    }

    @Override
    public List<byte[]> getStatusResponses() {
        if (this.statusResponses == null || this.statusResponses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> responses = new ArrayList<Object>(this.statusResponses.size());
        for (byte[] respBytes : this.statusResponses) {
            responses.add(respBytes.clone());
        }
        return Collections.unmodifiableList(responses);
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        return this.peerCerts[0].getSubjectX500Principal();
    }

    @Override
    public Principal getLocalPrincipal() {
        return this.localCerts == null || this.localCerts.length == 0 ? null : this.localCerts[0].getSubjectX500Principal();
    }

    public long getTicketCreationTime() {
        return this.ticketCreationTime;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastUsedTime != 0L ? this.lastUsedTime : this.creationTime;
    }

    void setLastAccessedTime(long time) {
        this.lastUsedTime = time;
    }

    public InetAddress getPeerAddress() {
        try {
            return InetAddress.getByName(this.host);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public String getPeerHost() {
        return this.host;
    }

    @Override
    public int getPeerPort() {
        return this.port;
    }

    void setContext(SSLSessionContextImpl ctx) {
        if (this.context == null) {
            this.context = ctx;
        }
    }

    @Override
    public synchronized void invalidate() {
        if (this.context != null) {
            this.context.remove(this.sessionId);
            this.context = null;
        }
        if (this.invalidated) {
            return;
        }
        this.invalidated = true;
        if (SSLLogger.isOn && SSLLogger.isOn("session")) {
            SSLLogger.finest("Invalidated session:  " + this, new Object[0]);
        }
        for (SSLSessionImpl child : this.childSessions) {
            child.invalidate();
        }
    }

    @Override
    public void putValue(String key, Object value) {
        SSLSessionBindingEvent e;
        if (key == null || value == null) {
            throw new IllegalArgumentException("arguments can not be null");
        }
        SecureKey secureKey = new SecureKey(key);
        Object oldValue = this.boundValues.put(secureKey, value);
        if (oldValue instanceof SSLSessionBindingListener) {
            e = new SSLSessionBindingEvent(this, key);
            ((SSLSessionBindingListener)oldValue).valueUnbound(e);
        }
        if (value instanceof SSLSessionBindingListener) {
            e = new SSLSessionBindingEvent(this, key);
            ((SSLSessionBindingListener)value).valueBound(e);
        }
    }

    @Override
    public Object getValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(key);
        return this.boundValues.get(secureKey);
    }

    @Override
    public void removeValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(key);
        Object value = this.boundValues.remove(secureKey);
        if (value instanceof SSLSessionBindingListener) {
            SSLSessionBindingEvent e = new SSLSessionBindingEvent(this, key);
            ((SSLSessionBindingListener)value).valueUnbound(e);
        }
    }

    @Override
    public String[] getValueNames() {
        ArrayList<Object> v = new ArrayList<Object>();
        Object securityCtx = SecureKey.getCurrentSecurityContext();
        Enumeration<SecureKey> e = this.boundValues.keys();
        while (e.hasMoreElements()) {
            SecureKey key = e.nextElement();
            if (!securityCtx.equals(key.getSecurityContext())) continue;
            v.add(key.getAppKey());
        }
        return v.toArray(new String[0]);
    }

    protected synchronized void expandBufferSizes() {
        this.acceptLargeFragments = true;
    }

    @Override
    public synchronized int getPacketBufferSize() {
        int packetSize = 0;
        if (this.negotiatedMaxFragLen > 0) {
            packetSize = this.cipherSuite.calculatePacketSize(this.negotiatedMaxFragLen, this.protocolVersion, this.protocolVersion.isDTLS);
        }
        if (this.maximumPacketSize > 0) {
            return this.maximumPacketSize > packetSize ? this.maximumPacketSize : packetSize;
        }
        if (packetSize != 0) {
            return packetSize;
        }
        if (this.protocolVersion.isDTLS) {
            return 16717;
        }
        return this.acceptLargeFragments ? 33093 : 16709;
    }

    @Override
    public synchronized int getApplicationBufferSize() {
        int fragmentSize = 0;
        if (this.maximumPacketSize > 0) {
            fragmentSize = this.cipherSuite.calculateFragSize(this.maximumPacketSize, this.protocolVersion, this.protocolVersion.isDTLS);
        }
        if (this.negotiatedMaxFragLen > 0) {
            return this.negotiatedMaxFragLen > fragmentSize ? this.negotiatedMaxFragLen : fragmentSize;
        }
        if (fragmentSize != 0) {
            return fragmentSize;
        }
        if (this.protocolVersion.isDTLS) {
            return 16384;
        }
        int maxPacketSize = this.acceptLargeFragments ? 33093 : 16709;
        return maxPacketSize - 5;
    }

    synchronized void setNegotiatedMaxFragSize(int negotiatedMaxFragLen) {
        this.negotiatedMaxFragLen = negotiatedMaxFragLen;
    }

    synchronized int getNegotiatedMaxFragSize() {
        return this.negotiatedMaxFragLen;
    }

    synchronized void setMaximumPacketSize(int maximumPacketSize) {
        this.maximumPacketSize = maximumPacketSize;
    }

    synchronized int getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        return SignatureScheme.getAlgorithmNames(this.localSupportedSignAlgs);
    }

    public Collection<SignatureScheme> getLocalSupportedSignatureSchemes() {
        return this.localSupportedSignAlgs;
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        if (this.peerSupportedSignAlgs != null) {
            return (String[])this.peerSupportedSignAlgs.clone();
        }
        return new String[0];
    }

    @Override
    public List<SNIServerName> getRequestedServerNames() {
        return this.requestedServerNames;
    }

    public String toString() {
        return "Session(" + this.creationTime + "|" + this.getCipherSuite() + ")";
    }
}

