import { SlashCommandConfigurator } from './base.js';
const NEW_FILE_PATHS = {
    proposal: '.roo/commands/openspec-proposal.md',
    apply: '.roo/commands/openspec-apply.md',
    archive: '.roo/commands/openspec-archive.md'
};
export class RooCodeSlashCommandConfigurator extends SlashCommandConfigurator {
    toolId = 'roocode';
    isAvailable = true;
    getRelativePath(id) {
        return NEW_FILE_PATHS[id];
    }
    getFrontmatter(id) {
        const descriptions = {
            proposal: 'Scaffold a new OpenSpec change and validate strictly.',
            apply: 'Implement an approved OpenSpec change and keep tasks in sync.',
            archive: 'Archive a deployed OpenSpec change and update specs.'
        };
        const description = descriptions[id];
        return `# OpenSpec: ${id.charAt(0).toUpperCase() + id.slice(1)}\n\n${description}`;
    }
}
//# sourceMappingURL=roocode.js.map