# ruamel.yaml

`ruamel.yaml` is a YAML 1.2 loader/dumper package for Python.

| | |
| - | - |
| version |0.19.0 |
| updated |2025-01-02 |
| documentation |https://yaml.dev/doc/ruamel.yaml |
| repository |https://sourceforge.net/projects/ruamel-yaml |
| pypi |https://pypi.org/project/ruamel.yaml |


## breaking changes, that may make future uploads to PyPI impossible

*If you are interested in future upgrades of `ruamel.yaml`
please check the [documentation on installing](https://yaml.dev/doc/ruamel.yaml/install/),
since at some point I might not be able to upload a new version to PyPI with updated information.*

`ruamel.yaml` was intentionally named as `yaml` in a namespace `ruamel`. The namespace allows the installation
name to correspond unchanged to how the package is imported, reduces the number of links I have to create
in site-packages of a Python install during development, as well as providing a recognisable set of packages
my company releases to the public. 

However, after uploading version 0.18.7, I got an email from PyPI, about having to change the project name
to `ruamel_yaml` to comply with PEP 625, sometime in the future. The email doesn't say if namespace packages are
no longer allowed, or how to deal with the very real clash with the pre-existing package `ruamel_yaml`.

I might not be able to adapt `ruamel.yaml`, in
a way that does not negatively affect the 0.5 million daily downloads (and my own usage of the package) in time. 
My experience with other such service downgrades (Bitbucket, Readthedocs), has not been entirely positive. 

-----



Starting with 0.19.1 `ruamel.yaml` no longer has a dependency on `ruamel.yaml.clibz`
nor on the old `ruamel.yaml.clib`.

Some deployment issues were reported on 0.19.0, due to the lack of proper pinning of the
`ruamel.yaml` version used. Most of these issues had to do with
the environment not having updated `setuptools` installed and the build
dependency `setuptools-zig` for `ruamel.yaml.clibz` not being invoked, with
Python falling back to invoking gcc (which was even less likely to be installed).

The already indicated simple solution of using:

```
    python -m pip install --no-deps ruamel.yaml ruamel.yaml.clib

```
turned out not to work for at least one setup.

As I am not aware that you can create an install requirement that removes
a dependency, the default (Cython) dependency is removed and you should
use `ruamel.yaml[libyaml]` resp. `ruamel.yaml[oldlibyaml]` as your requirements.
(this is the preferred way over using `ruamel.yaml.clibz` and `ruamel.yaml.clib`
directly).
If you are using `ruamel.yaml` in its default (round-trip, `YAML(typ='rt')`) mode,
there is currently no advantage of installing either optional extension.


The C sources are functionally unchanged,
but they are now always compiled (using `setuptools-zig` and `ziglang`) on your system,
instead of being downloaded as pre-compiled wheels (if available).
For this to function properly your Python (virtual) environment needs to have
an up-to-date version of `setuptools` and `wheels` pre-installed.

The code to load `ruamel.yaml.clib` has priority over `ruamel.yaml.clibz`
if both are installed.
This compatibility will at least be available during the 0.19 `ruamel.yaml` series
(so pin your usage of `ruamel.yaml` if necessary and report any problems).

The motivitation for this change is the availability,
and easy of use, of Zig as the toolchain
(in the form of `ziglang` on PyPi), so lenghty, non-optimized,
pre-compilation and uploading to PyPI,
is no longer necessary.
The time spent on creating ~60 wheels
and even more time wasted on dealing with CI providers (Appveyor
not being updated to support 3.14, Github CI being slow,
and charging for the use of your own computer,
etc).

The split out of `ruamel.yaml.clib` after the 0.15.100 release,
was also motivated by the time spent
on generating .whl files even if only Python code was changed.
The use of `ziglang` and `setuptools-zig` does make re-integration of the C sources
into `ruamel.yaml` feasable, but there are no plans yet to make this happen.

The test matrix for `ruamel.yaml.clibz`, of course still has many dimensions:
```
    Python versions: 3.9 - 3.14
    OS-es:           Linux, Alpine (musl), macOS, Windows
    Architectures:   Intel/AMD, Arm (and others), in 64 and some also in 32 bit versions
    Zig version:     ziglang < 0.16 is taken from PyPI
```

I try to test as much of the combinations as possible,
trying at least all supported Python versions,
including freethreading,
on macOS-arm64,
Linux arm64 (via docker containers),
Ubuntu Linux-Intel,
Linux musl intel (docker).
And at least one Python version along each of the indicated positions of the
dimensions above (e.g. Windows10 64bit was tested with Python 3.14, but I
could not test the RISC-V architecture).
As with generating .whl files previously
(which I could not all test myself)
I partly have to rely on the process of compilation/generation being likely correct,
and feedback from actual users,
of exotic (for me) platforms, is of course welcome.

There is new section,
in the documentation,
on the security of processing unchecked input.

-------

The potentially breaking change announced for the 0.18 series, in that `YAML(typ='unsafe')`
was going to be deprecated (now pending), has not yet  been implemented, but is still considered.
If you only use `unsafe` to dump, please use the new `YAML(typ='full')`, the result of that can be *safely*
loaded with a default  instance `YAML()`, as that will get you inspectable, tagged, scalars, instead of
executed Python functions/classes. (You should probably add constructors for what you actually need, 
but I do consider adding a `ruamel.yaml.unsafe` package that will re-add the `typ='unsafe'` option.
*Please adjust/pin your dependencies accordingly if necessary.*

-------

Version 0.18.16 was the last one tested to be working with Python 3.8.
Version 0.18.9 was the last one tested to be working with Python 3.7.
Version 0.17.21 was the last one tested to be working on Python 3.5 and 3.6.
The 0.16.13 release was the last that was tested to be working on Python 2.7.


There are two extra plug-in packages
(`ruamel.yaml.bytes` and `ruamel.yaml.string`)
for those not wanting to do the streaming to a
`io.BytesIO/StringIO` buffer themselves.

If your package uses `ruamel.yaml` and is not listed on PyPI, drop me an
email, preferably with some information on how you use the package (or a
link to the repository) and I'll keep you informed when the status of
the API is stable enough to make the transition.

For packaging purposes you can use a download of the [tar balls of tagged source](https://yaml.dev/ruamel-dl-tagged-releases)


<a href="https://bestpractices.coreinfrastructure.org/projects/1128"><img src="https://bestpractices.coreinfrastructure.org/projects/1128/badge"></a>
<a href="https://opensource.org/licenses/MIT"><img src="https://sourceforge.net/p/ruamel-yaml/code/ci/default/tree/_doc/_static/license.svg?format=raw"></a>
<a href="https://pypi.org/project/ruamel.yaml/"><img src="https://sourceforge.net/p/ruamel-yaml/code/ci/default/tree/_doc/_static/pypi.svg?format=raw"></a>
<a href="https://pypi.org/project/oitnb/"><img src="https://sourceforge.net/p/oitnb/code/ci/default/tree/_doc/_static/oitnb.svg?format=raw"></a>
<a href="http://mypy-lang.org/"><img src="http://www.mypy-lang.org/static/mypy_badge.svg"></a>
<a href="https://www.pepy.tech/projects/ruamel.yaml"><img src="https://img.shields.io/pepy/dt/ruamel.yaml.svg"></a>

0.19.0 (2025-01-02):

- removed dependency on `ruamel.yaml.clibz`

0.19.0 (2025-12-31):

- changed dependency on `ruamel.yaml.clib` to `ruamel.yaml.clibz` which includes support for free-threading (revisited after a bug report by [Ahmed Moustafa](https://sourceforge.net/u/aemous/profile/) and some insistance by [Nathan Goldbaum](https://sourceforge.net/u/ngoldbaum/profile/)
- added `.max_depth` to `YAML()` instance. If set to a (positive) number this limits the recursion, so loading does throw a `MaxDepthExceededError`. Based on comments by Benjamin Oberdorfer via email. This also triggered the new documenation section on processing unchecked input.

0.18.17 (2025-12-17):

- try to load C functions from `_ruamel_yaml_clibz` first.

0.18.16 (2025-10-22):

- root level block style scalars that started with a directives-end marker or a document-end marker, are now indented 2 spaces.
- merged fix for accessing end_marks on Tokens provided by [Toknak](https://sourceforge.net/u/taknok/)

0.18.15 (2025-08-19):

- duplicate merge keys are never allowed (not even with .allow_duplicate_keys = True
- merge keys now keep there position if a key before the merge key gets deleted (previously a key after the merge key would move before it)

0.18.14 (2025-06-09):

- Fix issue with constructing dataclasses that have a default factoryi attribute, but were missing a mapping value for that attribute. Reported by [Victor Prieto](https://sourceforge.net/u/vsprieto/profile/)
- the tagged release tar files can now also be downloaded from https://yaml.dev/ruamel-dl-tagged-releases/ please adjust if you use https://sourceforge.net/projects/ruamel-dl-tagged-releases/files/ as that repository in sourceforge will no longer be updated from some later date.

0.18.13 (2025-06-06):

- Fix line wrapping on plain scalars not observing width correctly. Issue 529, reported by [Sebastien Vermeille](https://sourceforge.net/u/svermeille/profile/)
- Fix sha256 and length in RECORD files. Reported by [Evan](https://sourceforge.net/u/bempelise/profile/)

0.18.12 (2025-05-30):

- fix additional issue with extra space in double quoted string. Reported by [Saugat Pachhai](https://sourceforge.net/u/skshetry/profile/)
- fix duplicate key url, now pointing to yaml.dev. Reported by [Hugo](https://sourceforge.net/u/hugovk/profile/)
- fix broken RECORD file, which was a problem for uv, not pip. Reported by [konstin](https://sourceforge.net/u/konstin/profile/)

0.18.11 (2025-05-19):

- function `load_yaml_guess_indent` now takes an option `yaml` argument so you can provide an already created/configured `YAML` instance
- Sequence item indicator with both comment/empty line before indicator **and** comment before sequence item, could not move comment and raise `NotImplementedError`. Reported by [Karsten Tessarzik](https://sourceforge.net/u/kars10/profile/).
- missing f for f-string (reported by π, via email)
- fixed issue with extra space in double quoted dump (reported by [Jan Möller](https://sourceforge.net/u/redfiredragon/profile/))

0.18.10 (2025-01-06):

- implemented changes to the setup.py for Python 3.14 as suggested by [Miro Hrončok](https://sourceforge.net/u/hroncok/profile/) in merge requests (MR not merged as those files are copied in from `develop` config)

0.18.9 (2025-01-05):

- fix issue with roundtripping 0 in YAML 1.1 reported by [Peter Law](https://sourceforge.net/u/peterjclaw/profile/)

0.18.8 (2025-01-02):

- added warning to README.md that PyPI might block updates due to breaking changes

0.18.7 (2024-12-30):

- fixes for README (reported by [Kees Bakker](https://sourceforge.net/u/keesb/profile/))
- fixes preserving anchor on scalar integer `0` (issue reported by (Mor Peled)[https://sourceforge.net/u/morp/profile/] and also in a question by [Ravi](https://stackoverflow.com/users/6550398/ravi) on [Stackoverflow](https://stackoverflow.com/a/79306830/1307905))
- fix for formatting of README suggested by [Michael R. Crusoe](https://sourceforge.net/u/crusoe/profile/)

0.18.6 (2024-02-07):

- fixed an issue with dataclass loading when the fields were collections (bug found as a result of a question by [FibroMyAlgebra](https://stackoverflow.com/users/6855070/fibromyalgebra) on [StackOverflow](https://stackoverflow.com/a/77485786/1307905))
- fixed an issue loading dataclasses with `InitVar` fields when `from __future__ import annotations` was used to delay evaluation of typing.

0.18.5 (2023-11-03):

- there is some indication that dependent packages have been pinned to use specific (tested) and just install the latest even in Python versions that have end-of-life

0.18.4 (2023-11-01):

- YAML() instance has a `doc_infos` attribute which is a cumulative list of DocInfo instances (one for `load()`, one per document for `load_all()`). DocInfo instances contain version information (requested, directive) and tag directive information
- fix issue that the YAML instance tags attribute was not reset between documents, resulting in mixing of tag directives of multiple documents. Now only provides tag directive information on latest document after loading. This means tags for dumping must be set **again** after a document is loaded with the same instance. (because of this tags will be removed in a favour of a different mechanism in the future)
- fix issue with multiple document intermixing YAML 1.2 and YAML 1.1, the VersionedResolver now resets
- fix issue with disappearing comment when next token was Tag (still can't have both a comment before a tag and after a tag, before node)

0.18.3 (2023-10-29):

- fix issue with spurious newline on first item after comment + nested block sequence
- additional links in the metadata on PyPI (Reported, with pointers how to fix, by [Sorin](https://sourceforge.net/u/ssbarnea/profile/)).

0.18.2 (2023-10-24):

- calling the deprecated functions now raises an `AttributeError` with the, somewhat more informative, orginal warning message. Instead of calling `sys.exit(1)`

0.18.1 (2023-10-24):

- calling the deprecated functions now always displays the warning message. (reported by [Trend Lloyd](https://sourceforge.net/u/lathiat2/profile/))

0.18.0 (2023-10-23):

- the **functions** `scan`, `parse`, `compose`, `load`, `emit`, `serialize`, `dump` and their variants (`_all`, `safe_`, `round_trip_`, etc) have been deprecated (the same named **methods** on `YAML()` instances are, of course, still there.
- `YAML(typ='unsafe')` now issues a `PendingDeprecationWarning`. This will become deprecated in the 0.18 series
(probably before the end of 2023).
You can use `YAML(typ='full')` to dump unregistered Python classes/functions. 
For loading you'll have to register your classes/functions
if you want the old, unsafe, functionality. You can still load any tag, like `!!python/name:posix.system', **safely** 
with the (default) round-trip parser.
- fix for `bytes-like object is required not 'str' while dumping binary streams`. This was reported, analysed and a fix provided by [Vit Zikmund](https://sourceforge.net/u/tlwhitec/profile/)


------------------------------------------------------------------------

For older changes see the file
[CHANGES](https://sourceforge.net/p/ruamel-yaml/code/ci/default/tree/CHANGES)
