# RamaLama Contributor Ladder
* [Contributor Ladder](#contributor-ladder)
    * [Contributor](#contributor)
    * [Reviewer](#reviewer)
    * [Maintainer](#maintainer)
* [Inactivity](#inactivity)
* [Involuntary Removal](#involuntary-removal-or-demotion)
* [Stepping Down/Emeritus Process](#stepping-downemeritus-process)
* [Contact](#contact)

## Contributor Ladder
This contributor ladder outlines the different contributor roles within RamaLama, along with the responsibilities and privileges that come with them. Community members generally start at the first levels of the "ladder" and advance up it as their involvement in RamaLama grows.  Our project members are happy to help you advance along the contributor ladder.

Each of the project member roles below is organized into lists of three types of things.

* **Responsibilities:** functions of a member
* **Requirements:** qualifications of a member
* **Privileges:** entitlements of member

### Contributor
Description: A Contributor contributes directly to RamaLama and adds value to it. Contributions need not be code. People at the Contributor level may be new contributors, or they may only contribute occasionally.

* **Responsibilities include:**
    * Must follow the [Containers Community Code of Conduct](https://github.com/containers/common/blob/main/CODE-OF-CONDUCT.md).
    * Must follow the [Contributing Guide](./CONTRIBUTING.md).
* **Requirements (one or several of the below):**
    * Report and sometimes resolve issues
    * Occasionally submit PRs
    * Contribute to the documentation
    * Answer questions from other community members
    * Assist in reviewing pull requests and issues, submit feedback when reasonable
    * Test releases and patches, and submit reviews
    * Promote RamaLama in public
* **Privileges:**
    * Eligible to become a Reviewer

### Reviewer
Description: A Reviewer has responsibility for the triage of issues and review of pull requests. They are collectively responsible, with other Reviewers, for reviewing all changes and indicating whether those changes are ready to merge. They have a track record of contributions and reviews in the project.

Reviewers have all the rights and responsibilities of a Contributor, plus:

* **Responsibilities include:**
    * Regular contributions to the project
    * Triaging GitHub issues
    * Assisting contributors in their interactions with RamaLama
    * Helping other contributors become reviewers
* **Requirements:**
    * Has a proven record of good-faith contributions to RamaLama as a Contributor for a period of at least 4 months
    * Has participated in some pull request reviews and/or issue triage on the project for at least 4 months
    * Is supportive of new and occasional contributors and helps get useful PRs in shape to merge
* **Additional privileges:**
    * Has GitHub or CI/CD rights to approve pull requests
    * Can nominate other contributors to become Reviewers

The process of becoming a Reviewer is:
1. The contributor must be sponsored by a Maintainer or Reviewer. That sponsor will open a PR, which adds the nominee to the [MAINTAINERS.md](./MAINTAINERS.md) file as a reviewer.
2. The contributor will add a comment to the pull request indicating their willingness to assume the responsibilities of a Reviewer.
3. At least one Maintainer must concur to merge the PR.

### Maintainer
Description: Maintainers are very established contributors who are responsible for the entire project. As such, they have the ability to approve PRs against any area of RamaLama, and are expected to participate in making decisions about the strategy and priorities of the project.

A Maintainer must meet the responsibilities and requirements of a Reviewer, plus:

* **Responsibilities include:**
    * Mentoring new Reviewers
    * Merging pull requests
    * Determining strategy and policy for RamaLama
* **Requirements:**
    * Experience as a Reviewer for at least 4 months
    * Demonstrates a broad knowledge of RamaLama
    * Is able to exercise judgment for the good of RamaLama, independent of their employer, friends, or team
    * Mentors contributors, reviewers, and new maintainers
* **Additional privileges:**
    * Merging pull requests
    * Represent RamaLama in public as a Maintainer
    * Have a vote in decision-making meetings
    
Process of becoming a maintainer:
1. Any current Maintainer may nominate a current Reviewer to become a new Maintainer, by opening a PR and adding the nominee as an Approver in the CODEOWNERS file and as a Maintainer in the [MAINTAINERS.md](./MAINTAINERS.md) file
2. The nominee will add a comment to the PR testifying that they agree to all requirements of becoming a Maintainer.
3. A majority of the current Maintainers must then approve the PR.

## Inactivity
It is important for contributors to be and stay active to set an example and show commitment to RamaLama. Inactivity is harmful as it may lead to unexpected delays, contributor attrition, and a loss of trust in the project.

* Inactivity is measured by:
    * Periods of no contributions for longer than 4 months
    * Periods of no communication for longer than 8 months
* Consequences of being inactive include:
    * Involuntary removal or demotion
    * Being asked to move to Emeritus status

## Involuntary Removal or Demotion
Involuntary removal/demotion of a contributor happens when responsibilities and requirements aren't being met. This may include repeated patterns of inactivity, extended period of inactivity, a period of failing to meet the requirements of your role, and/or a violation of the Code of Conduct. This process is important because it protects the community and its deliverables while also opens up opportunities for new contributors to step in.

Involuntary removal or demotion is handled through a vote by a majority of the current Maintainers.

## Stepping Down/Emeritus Process
If and when contributors' commitment levels change, contributors can consider stepping down (moving down the contributor ladder) vs moving to emeritus status (completely stepping away from the project).

Contact the Maintainers about changing to Emeritus status, or reducing your contributor level.

## Contact
* For inquiries, please reach out to a Maintainer.

## Credits
The structure of this document is based off these sources:
* [CNCF Contributor Ladder template](https://github.com/cncf/project-template/blob/main/CONTRIBUTOR_LADDER.md)
* [Podman GOVERNANCE.md](https://github.com/containers/podman/blob/main/GOVERNANCE.md#updates-to-this-document)