//@ui5-bundle sap/m/library-preload.js
/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/ColumnHeaderPopover',['sap/ui/core/Control','sap/m/Toolbar','sap/m/Button','sap/m/ResponsivePopover','sap/m/ToolbarSpacer','sap/ui/dom/containsOrEquals'],function(C,T,B,R,a,c){"use strict";
var b=C.extend("sap.m.ColumnHeaderPopover",{
metadata:{library:"sap.m",properties:{},aggregations:{items:{type:"sap.m.ColumnPopoverItem",multiple:true,singularName:"item",bindable:true},_popover:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},defaultAggregation:"items",associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}},
renderer:null
});
b.prototype.init=function(){this._bPopoverCreated=false;this._oShownCustomContent=null;var t=this;this._minWidthDelegate=function(){this.$().css("min-width",t.minWidth);};};
b.prototype.exit=function(){if(this._oToolbar){this._oToolbar.destroy();this._oToolbar=null;}this._closeBtn=null;this._spacer=null;this._aButtons=null;this._oShownCustomContent=null;};
b.prototype._createPopover=function(){var t=this;this._oShownCustomContent=null;var o=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s=o.getText("COLUMNHEADERPOPOVER_CLOSE_BUTTON");var p=new R(this.getId()+"-popover",{showArrow:false,showHeader:false,placement:"Bottom",verticalScrolling:true,horizontalScrolling:false,ariaLabelledBy:this.getAriaLabelledBy(),beforeClose:function(e){if(t._oShownCustomContent){t._oShownCustomContent.setVisible(false);t._oShownCustomContent=null;}t._cleanSelection();}});p._oControl.addDelegate({"onAfterRendering":this._minWidthDelegate},p._oControl);this.setAggregation("_popover",p);var d=new T(this.getId()+"-tb");this._spacer=new a();this._closeBtn=new B(d.getId()+"-closeBtn",{type:"Transparent",icon:"sap-icon://decline",tooltip:s,press:[p.close,p]});d.addContent(this._spacer);d.addContent(this._closeBtn);p.addContent(d);this._oToolbar=d;};
b.prototype._cleanSelection=function(o){var d=this._aButtons;if(d){d.forEach(function(e){if((!o||e!==o)&&e.getPressed&&e.getPressed()){e.setPressed(false);}});}};
b.prototype.openBy=function(o){if(!this._bPopoverCreated){this._createPopover();this._bPopoverCreated=true;}else{this._oToolbar.removeContent(this._spacer);this._oToolbar.removeContent(this._closeBtn);this._oToolbar.destroyContent();}var p=this.getAggregation("_popover");var d=[];var I=this.getItems();var m=5;for(var i=0;(i<I.length)&&(d.length<m);i++){var e=I[i];if(e.getVisible()){var f=e._createButton(this._oToolbar.getId()+"-btn_"+i,this);f._sContentId=e._sContentId;d.push(f);this._oToolbar.insertContent(f,i);}}if(d.length===0){return;}this._aButtons=d;this._oToolbar.addContent(this._spacer);this._oToolbar.addContent(this._closeBtn);if(!this._bAppendedToUIArea&&!this.getParent()){var s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);s.addContent(this,true);this._bAppendedToUIArea=true;}var O=o.getFocusDomRef();if(O){p.setOffsetY(-O.clientHeight);this.minWidth=O.clientWidth;}p.openBy(o);};
b.prototype.invalidate=function(o){var p=this.getAggregation("_popover");if(o===p){C.prototype.invalidate.apply(this,arguments);}return this;};
b.prototype.addAriaLabelledBy=function(i){var r=this.getAggregation("_popover");if(r){r.addAriaLabelledBy(i);}return this.addAssociation("ariaLabelledBy",i);};
b.prototype.removeAriaLabelledBy=function(o){var r=this.getAggregation("_popover");if(r){r.removeAriaLabelledBy(o);}return this.removeAssociation("ariaLabelledBy",o);};
b.prototype.removeAllAssociation=function(A,s){if(A==="ariaLabelledBy"){var r=this.getAggregation("_popover");if(r){r.removeAllAssociation(A,s);}}return C.prototype.removeAllAssociation.apply(this,arguments);};
return b;});
sap.ui.predefine('sap/m/ColumnPopoverActionItem',['./ColumnPopoverItem','sap/m/Button'],function(C,B){"use strict";
var a=C.extend("sap.m.ColumnPopoverActionItem",{metadata:{library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null}},events:{press:{}}}});
a.prototype._createButton=function(i,c){return new B(i,{icon:this.getIcon(),type:"Transparent",tooltip:this.getText(),visible:this.getVisible(),press:[function(e){if(c._oShownCustomContent){c._oShownCustomContent.setVisible(false);c._oShownCustomContent=null;c._cleanSelection(this);}var p=c.getAggregation("_popover");p.close();this.firePress();},this]});};
return a;});
sap.ui.predefine('sap/m/ColumnPopoverCustomItem',['./ColumnPopoverItem','sap/m/ToggleButton'],function(C,T){"use strict";
var a=C.extend("sap.m.ColumnPopoverCustomItem",{metadata:{library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false,singularName:"content"}},events:{beforeShowContent:{}}}});
a.prototype._createButton=function(i,c){var p=c.getAggregation("_popover");var o=this.getContent();if(o){o.setVisible(false);this._sContentId=o.sId;}p.addContent(o);var t=this;return new T(i,{icon:this.getIcon(),type:"Transparent",tooltip:this.getText(),visible:this.getVisible(),press:function(){if(c._oShownCustomContent){c._oShownCustomContent.setVisible(false);}if(this.getPressed()){c._cleanSelection(this);t.fireBeforeShowContent();if(o){o.setVisible(true);c._oShownCustomContent=o;}}else if(o){o.setVisible(false);c._oShownCustomContent=null;}}});};
return a;});
sap.ui.predefine('sap/m/ColumnPopoverItem',['sap/ui/core/Element'],function(E){"use strict";
var C=E.extend("sap.m.ColumnPopoverItem",{metadata:{library:"sap.m",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}}}});
C.prototype._createButton=function(){throw new Error('Abstract function _create Button must be implemented in your Item (that extends this abstract object).');};
return C;});
sap.ui.predefine('sap/m/ColumnPopoverSelectListItem',['sap/ui/core/Core','./ColumnPopoverItem','sap/m/ToggleButton','sap/m/Button','sap/m/StandardListItem','sap/m/List'],function(C,a,T,B,S,L){"use strict";
var b=a.extend("sap.m.ColumnPopoverSelectListItem",{
library:"sap.m",
metadata:{properties:{label:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null}},events:{action:{parameters:{property:{type:"string"}}}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:true}}}
});
b.prototype._createButton=function(I,c){var t=this.getLabel(),d=this.getItems(),e=this;if(d.length>1){var p=c.getAggregation("_popover");var l=new L();for(var i=0;i<d.length;i++){var o=new S({title:d[i].getText(),type:"Active"});l.addItem(o);o.data("key",d[i].getKey());}l.attachEvent("itemPress",function(E){p.close();var o=E.getParameter("listItem");e.fireAction({property:o.data("key")});});l.setVisible(false);p.addContent(l);return new T(I,{icon:this.getIcon(),type:"Transparent",tooltip:t,visible:this.getVisible(),press:function(){if(c._oShownCustomContent){c._oShownCustomContent.setVisible(false);}if(this.getPressed()){c._cleanSelection(this);if(l){l.setVisible(true);c._oShownCustomContent=l;}}else if(l){l.setVisible(false);c._oShownCustomContent=null;}}});}else{return new B(I,{icon:this.getIcon(),type:"Transparent",tooltip:t,visible:this.getVisible(),press:function(){var p=c.getAggregation("_popover");if(c._oShownCustomContent){c._oShownCustomContent.setVisible(false);c._oShownCustomContent=null;c._cleanSelection(this);}p.close();e.fireAction({property:d[0]?d[0].getKey():null});}});}};
return b;});
sap.ui.predefine('sap/m/ColumnPopoverSortItem',['sap/ui/core/Core','./ColumnPopoverItem','sap/m/ToggleButton','sap/m/Button','sap/m/StandardListItem','sap/m/List'],function(C,a,T,B,S,L){"use strict";
var b=a.extend("sap.m.ColumnPopoverSortItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null}},events:{sort:{parameters:{property:{type:"string"}}}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:true}}}});
b.prototype._createButton=function(I,c){var o=C.getLibraryResourceBundle("sap.m"),s=o.getText("COLUMNHEADERPOPOVER_SORT_BUTTON"),d=this.getItems(),t=this;if(d.length>1){var p=c.getAggregation("_popover");var l=new L();for(var i=0;i<d.length;i++){var e=new S({title:d[i].getText(),type:"Active"});l.addItem(e);e.data("key",d[i].getKey());}l.attachEvent("itemPress",function(E){p.close();var e=E.getParameter("listItem");t.fireSort({property:e.data("key")});});l.setVisible(false);p.addContent(l);return new T(I,{icon:"sap-icon://sort",type:"Transparent",tooltip:s,visible:this.getVisible(),press:function(){if(c._oShownCustomContent){c._oShownCustomContent.setVisible(false);}if(this.getPressed()){c._cleanSelection(this);if(l){l.setVisible(true);c._oShownCustomContent=l;}}else if(l){l.setVisible(false);c._oShownCustomContent=null;}}});}else{return new B(I,{icon:"sap-icon://sort",type:"Transparent",tooltip:s,visible:this.getVisible(),press:function(){var p=c.getAggregation("_popover");if(c._oShownCustomContent){c._oShownCustomContent.setVisible(false);c._oShownCustomContent=null;c._cleanSelection(this);}p.close();t.fireSort({property:d[0]?d[0].getKey():null});}});}};
return b;});
sap.ui.predefine('sap/m/CustomTreeItem',['./TreeItemBase','./ListItemBase','./library',"./CustomTreeItemRenderer"],function(T,L,l,C){"use strict";
var a=T.extend("sap.m.CustomTreeItem",{metadata:{library:"sap.m",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}}}});
a.prototype.getContentAnnouncement=function(){return this.getContent().map(function(c){return L.getAccessibilityText(c);}).join(" ").trim();};
return a;});
sap.ui.predefine('sap/m/CustomTreeItemRenderer',['./TreeItemBaseRenderer','sap/ui/core/Renderer'],function(T,R){"use strict";var C=R.extend(T);C.apiVersion=2;
C.renderLIAttributes=function(r,l){r.class("sapMCTI");T.renderLIAttributes.apply(this,arguments);};
C.renderLIContent=function(r,l){l.getContent().forEach(function(c){r.renderControl(c);});};
return C;},true);
sap.ui.predefine('sap/m/OverflowToolbarAssociativePopoverRenderer',['./PopoverRenderer','sap/ui/core/Renderer'],function(P,R){"use strict";var O=R.extend(P);O.apiVersion=2;return O;},true);
sap.ui.predefine('sap/m/P13nAnyFilterItem',['./library','sap/m/P13nFilterItem'],function(l,P){"use strict";
var a=P.extend("sap.m.P13nAnyFilterItem",{metadata:{library:"sap.m",properties:{value1:{type:"any",group:"Misc",defaultValue:null},value2:{type:"any",group:"Misc",defaultValue:null}}}});
return a;});
sap.ui.predefine('sap/m/P13nColumnsItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nColumnsItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",group:"Misc"},index:{type:"int",group:"Appearance"},visible:{type:"boolean",group:"Appearance"},width:{type:"string",group:"Misc"},total:{type:"boolean"}}}});
return P;});
sap.ui.predefine('sap/m/P13nColumnsPanel',['sap/ui/core/library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/IconPool','./library','./Table','./Column','./ColumnListItem','./P13nPanel','./P13nColumnsItem','./SearchField','./Text','./Button','./OverflowToolbar','./OverflowToolbarLayoutData','./OverflowToolbarButton','./ToolbarSpacer',"sap/ui/thirdparty/jquery"],function(C,c,J,B,I,l,T,d,e,P,f,S,g,h,O,i,j,k,q){"use strict";var m=l.OverflowToolbarPriority;var n=l.ButtonType;var o=l.ToolbarDesign;var L=l.ListType;var p=l.ListMode;var r=l.P13nPanelType;var s=l.Sticky;
var t=P.extend("sap.m.P13nColumnsPanel",{
metadata:{deprecated:true,library:"sap.m",properties:{visibleItemsThreshold:{type:"int",group:"Behavior",defaultValue:-1}},aggregations:{columnsItems:{type:"sap.m.P13nColumnsItem",multiple:true,singularName:"columnsItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{addColumnsItem:{deprecated:true,parameters:{newItem:{type:"sap.m.P13nColumnsItem"}}},changeColumnsItems:{parameters:{newItems:{type:"sap.m.P13nColumnsItem[]"},existingItems:{type:"sap.m.P13nColumnsItem[]"},items:{type:"object[]"}}},setData:{deprecated:true}}},
renderer:{apiVersion:2,render:function(R,a){R.openStart("div",a);R.class("sapMP13nColumnsPanel");R.openEnd();a.getAggregation("content").forEach(function(b){R.renderControl(b);});R.close("div");}}
});
t.prototype.init=function(){this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bTableItemsChanged=false;var M=new J({items:[],columnKeyOfMarkedItem:undefined,isMoveDownButtonEnabled:undefined,isMoveUpButtonEnabled:undefined,showOnlySelectedItems:undefined,countOfSelectedItems:0,countOfItems:0});M.setDefaultBindingMode(B.TwoWay);M.setSizeLimit(1000);this.setModel(M,"$sapmP13nColumnsPanel");this.setType(r.columns);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("COLUMSPANEL_TITLE"));this._createTable();this._oTable.setHeaderToolbar(this._createToolbar());this.addAggregation("content",this._oTable);};
t.prototype.reInitialize=function(){};
t.prototype.onBeforeRendering=function(){this._updateInternalModel();if(!this._getInternalModel().getProperty("/columnKeyOfMarkedItem")){this._setColumnKeyOfMarkedItem(this._getColumnKeyByTableItem(this._getVisibleTableItems()[0]));}this._switchMarkedTableItemTo(this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem")));this._updateControlLogic();};
t.prototype.getOkPayload=function(){this._updateInternalModel();var M=this._getInternalModel().getProperty("/items");return{tableItems:M.map(function(a){return{columnKey:a.columnKey,index:a.persistentIndex===-1?undefined:a.persistentIndex,visible:a.persistentSelected,width:a.width};}),tableItemsChanged:this._bTableItemsChanged,selectedItems:M.filter(function(a){return a.persistentSelected;}).map(function(a){return{columnKey:a.columnKey};})};};
t.prototype.getResetPayload=function(){return{oPanel:this};};
t.prototype.exit=function(){this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
t.prototype.addItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",a);return this;};
t.prototype.insertItem=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",a,b);return this;};
t.prototype.removeItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}a=this.removeAggregation("items",a);return a;};
t.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};
t.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};
t.prototype.addColumnsItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("columnsItems",a);return this;};
t.prototype.insertColumnsItem=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("columnsItems",a,b);return this;};
t.prototype.updateColumnsItems=function(R){this.updateAggregation("columnsItems");if(R===c.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};
t.prototype.removeColumnsItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("columnsItems",a);};
t.prototype.removeAllColumnsItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("columnsItems");};
t.prototype.destroyColumnsItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("columnsItems");return this;};
t.prototype.onBeforeNavigationFrom=function(){var M=this._getSelectedModelItems();var v=this.getVisibleItemsThreshold();return!(M&&v!==-1&&M.length>v);};
t.prototype._notifyChange=function(){this._bTableItemsChanged=true;var a=this.getChangeNotifier();if(a){a(this);}};
t.prototype._scrollToSelectedItem=function(a){if(!a){return;}sap.ui.getCore().applyChanges();};
t.prototype._getInternalModel=function(){return this.getModel("$sapmP13nColumnsPanel");};
t.prototype._createTable=function(){this._oTable=new T({mode:p.MultiSelect,rememberSelections:false,sticky:[s.ColumnHeaders,s.HeaderToolbar],itemPress:q.proxy(this._onItemPressed,this),selectionChange:q.proxy(this._onSelectionChange,this),columns:[new d({vAlign:C.VerticalAlign.Middle,header:new g({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(a,b){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[a,b]);}}})})],items:{path:"/items",templateShareable:false,template:new e({cells:[new g({text:"{text}"})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:L.Active})}});this._oTable.setModel(this._getInternalModel());};
t.prototype._createToolbar=function(){var a=this;var R=sap.ui.getCore().getLibraryResourceBundle("sap.m");var b=new O(this.getId()+"-toolbar",{design:o.Auto,content:[new k(),new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(a._iSearchTimer);if(D){a._iSearchTimer=window.setTimeout(function(){a._onExecuteSearch();},D);}else{a._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new i({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})}),new h(this.getId()+"-showSelected",{text:{path:'/showOnlySelectedItems',formatter:function(u){return u?R.getText('COLUMNSPANEL_SHOW_ALL'):R.getText('COLUMNSPANEL_SHOW_SELECTED');}},type:n.Transparent,press:q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new i({moveToOverflow:true,priority:m.High})}),new j({icon:I.getIconURI("collapse-group"),text:R.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:R.getText('COLUMNSPANEL_MOVE_TO_TOP'),type:n.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:q.proxy(this.onPressButtonMoveToTop,this),layoutData:new i({moveToOverflow:true,priority:m.Low,group:2})}),new j({icon:I.getIconURI("navigation-up-arrow"),text:R.getText('COLUMNSPANEL_MOVE_UP'),tooltip:R.getText('COLUMNSPANEL_MOVE_UP'),type:n.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:q.proxy(this.onPressButtonMoveUp,this),layoutData:new i({moveToOverflow:true,priority:m.High,group:1})}),new j({icon:I.getIconURI("navigation-down-arrow"),text:R.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:R.getText('COLUMNSPANEL_MOVE_DOWN'),type:n.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:q.proxy(this.onPressButtonMoveDown,this),layoutData:new i({moveToOverflow:true,priority:m.High,group:1})}),new j({icon:I.getIconURI("expand-group"),text:R.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:R.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),type:n.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:q.proxy(this.onPressButtonMoveToBottom,this),layoutData:new i({moveToOverflow:true,priority:m.Low,group:2})})]});b.setModel(this._getInternalModel());return b;};
t.prototype.onPressButtonMoveToTop=function(){this._moveMarkedTableItem(this._getMarkedTableItem(),this._getVisibleTableItems()[0]);};
t.prototype.onPressButtonMoveUp=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())-1]);};
t.prototype.onPressButtonMoveDown=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())+1]);};
t.prototype.onPressButtonMoveToBottom=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.length-1]);};
t.prototype._onSwitchButtonShowSelected=function(){this._getInternalModel().setProperty("/showOnlySelectedItems",!this._getInternalModel().getProperty("/showOnlySelectedItems"));this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();};
t.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};
t.prototype._switchVisibilityOfUnselectedModelItems=function(){var b=this._isFilteredByShowSelected();var M=this._getInternalModel().getProperty("/items");M.forEach(function(a){if(a.persistentSelected){a.visible=true;return;}a.visible=!b;});this._getInternalModel().setProperty("/items",M);};
t.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};
t.prototype._moveMarkedTableItem=function(a,b){var M=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(a));var u=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(b));var v=this._getModelItemIndexByColumnKey(M.columnKey);var w=this._getModelItemIndexByColumnKey(u.columnKey);this._moveModelItems(v,w);this._checkButtonFocus(w);this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fireChangeColumnsItems();this._fireSetData();this._notifyChange();};
t.prototype._checkButtonFocus=function(a){var M=this._oTable.getItems().length-1;if(a===0||a===M){sap.ui.getCore().byId(this.getId()+"-showSelected").focus();}};
t.prototype._moveModelItems=function(a,b){var M=this._getInternalModel().getProperty("/items");if(a<0||b<0||a>M.length-1||b>M.length-1){return false;}this._removeStyleOfMarkedTableItem();var u=M.splice(a,1);M.splice(b,0,u[0]);this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());return true;};
t.prototype._getModelItemByColumnKey=function(a){var M=this._getInternalModel().getProperty("/items").filter(function(b){return b.columnKey===a;});return M[0];};
t.prototype._updateCounts=function(M){var a=0;var b=0;M.forEach(function(u){a++;if(u.persistentSelected){b++;}});this._getInternalModel().setProperty("/countOfItems",a);this._getInternalModel().setProperty("/countOfSelectedItems",b);};
t.prototype._sortModelItemsByPersistentIndex=function(M){var u;var v;try{v=sap.ui.getCore().getConfiguration().getLocale().toString();if(typeof window.Intl!=='undefined'){u=window.Intl.Collator(v,{numeric:true});}}catch(E){}M.forEach(function(a,b){a.localIndex=b;});M.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex>-1&&a.persistentIndex<b.persistentIndex){return-1;}else if(b.persistentIndex>-1&&a.persistentIndex>b.persistentIndex){return 1;}else{return a.localIndex-b.localIndex;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){return u?u.compare(a.text,b.text):a.text.localeCompare(b.text,v,{numeric:true});}});M.forEach(function(a){delete a.localIndex;});};
t.prototype._getColumnKeyByTableItem=function(a){var b=this._oTable.indexOfItem(a);if(b<0){return null;}return this._oTable.getBinding("items").getContexts(undefined,undefined,undefined,true)[b].getObject().columnKey;};
t.prototype._getModelItemIndexByColumnKey=function(a){var b=-1;this._getInternalModel().getProperty("/items").some(function(M,u){if(M.columnKey===a){b=u;return true;}});return b;};
t.prototype._getSelectedModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return M.persistentSelected;});};
t.prototype._getVisibleTableItems=function(){return this._oTable.getItems().filter(function(a){return a.getVisible();});};
t.prototype._getTableItemByColumnKey=function(a){var b=this._oTable.getBinding("items").getContexts(undefined,undefined,undefined,true);var u=this._oTable.getItems().filter(function(v,w){return b[w].getObject().columnKey===a;});return u[0];};
t.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
t.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
t.prototype._getSearchText=function(){var a=this._getSearchField();return a?a.getValue():"";};
t.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
t.prototype._isFilteredByShowSelected=function(){return this._getInternalModel().getData().showOnlySelectedItems;};
t.prototype._updateControlLogic=function(){var b=this._isFilteredBySearchText();var a=this._isFilteredByShowSelected();var v=this._getVisibleTableItems();this._getInternalModel().setProperty("/isMoveUpButtonEnabled",v.indexOf(this._getMarkedTableItem())>0);this._getInternalModel().setProperty("/isMoveDownButtonEnabled",v.indexOf(this._getMarkedTableItem())>-1&&v.indexOf(this._getMarkedTableItem())<v.length-1);var u=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(u){u.setEnabled(!b&&!a);}};
t.prototype._updateModelItemsPersistentIndex=function(M){var a=-1;M.forEach(function(b){b.persistentIndex=-1;if(b.persistentSelected){a++;b.persistentIndex=a;}});};
t.prototype._fireSetData=function(){this._bIgnoreUpdateInternalModel=true;this.fireSetData();this._bIgnoreUpdateInternalModel=false;};
t.prototype._fireChangeColumnsItems=function(){this._bIgnoreUpdateInternalModel=true;var M=this._getInternalModel().getProperty("/items");var E={newItems:[],existingItems:[],items:M.map(function(a){return{columnKey:a.columnKey,visible:a.persistentSelected,index:a.persistentIndex===-1?undefined:a.persistentIndex,width:a.width,total:a.total};})};M.forEach(function(a){var b=this._getColumnsItemByColumnKey(a.columnKey);if(b){b.setVisible(a.persistentSelected);b.setIndex(a.persistentIndex===-1?undefined:a.persistentIndex);if(a.width!==undefined){b.setWidth(a.width);}if(a.total!==undefined){b.setTotal(a.total);}E.existingItems.push(b);}else{E.newItems.push(new f({columnKey:a.columnKey,visible:a.persistentSelected,index:a.persistentIndex===-1?undefined:a.persistentIndex,width:a.width,total:a.total}));}},this);this.fireChangeColumnsItems(E);this._bIgnoreUpdateInternalModel=false;};
t.prototype._getColumnsItemByColumnKey=function(a){var b=this.getColumnsItems().filter(function(u){return u.getColumnKey()===a;});return b[0];};
t.prototype._getMarkedTableItem=function(){return this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem"));};
t.prototype._setColumnKeyOfMarkedItem=function(a){this._getInternalModel().setProperty("/columnKeyOfMarkedItem",a);};
t.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));this._updateControlLogic();};
t.prototype._onSelectionChange=function(E){if(!E.getParameter("selectAll")&&E.getParameter("listItems").length===1){this._switchMarkedTableItemTo(E.getParameter("listItem"));}this._selectTableItem();};
t.prototype._selectTableItem=function(){this._updateControlLogic();var M=this._getInternalModel().getProperty("/items");this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._fireChangeColumnsItems();this._fireSetData();this._notifyChange();var v=this.getValidationExecutor();if(v){v();}};
t.prototype._switchMarkedTableItemTo=function(a){this._removeStyleOfMarkedTableItem();var b=this._getColumnKeyByTableItem(a);if(b){this._setColumnKeyOfMarkedItem(b);a.addStyleClass("sapMP13nColumnsPanelItemSelected");}};
t.prototype._removeStyleOfMarkedTableItem=function(){if(this._getMarkedTableItem()){this._getMarkedTableItem().removeStyleClass("sapMP13nColumnsPanelItemSelected");}};
t.prototype._filterModelItemsBySearchText=function(){var a=this._getSearchText();a=a.replace(/(^\s+)|(\s+$)/g,'');a=a.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var R=new RegExp(a,'igm');if(!R){return;}this._getVisibleModelItems().forEach(function(M){M.visible=false;if(typeof M.text==="string"&&M.text.match(R)){M.visible=true;}if(typeof M.tooltip==="string"&&M.tooltip.match(R)){M.visible=true;}});this._getInternalModel().refresh();};
t.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._removeStyleOfMarkedTableItem();var M=this._getInternalModel().getProperty("/items");this._getInternalModel().setProperty("/items",this.getItems().map(function(b){return{columnKey:b.getColumnKey(),visible:true,text:b.getText(),tooltip:b.getTooltip(),persistentIndex:-1,persistentSelected:b.getVisible(),width:undefined,total:undefined};},this));this.getColumnsItems().forEach(function(b){var u=this._getModelItemByColumnKey(b.getColumnKey());if(!u){return;}if(b.getIndex()!==undefined){u.persistentIndex=b.getIndex();}if(b.getVisible()!==undefined){u.persistentSelected=b.getVisible();}if(b.getWidth()!==undefined){u.width=b.getWidth();}if(b.getTotal()!==undefined){u.total=b.getTotal();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var a=this._getInternalModel().getProperty("/items");this._sortModelItemsByPersistentIndex(a);this._updateCounts(a);this._getInternalModel().setProperty("/items",a);this._switchMarkedTableItemTo(this._getMarkedTableItem());if(q(a).not(M).length!==0||q(M).not(a).length!==0){this._bTableItemsChanged=true;}};
return t;});
sap.ui.predefine('sap/m/P13nConditionPanel',['./library','sap/ui/core/library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/ListItem','sap/ui/model/odata/type/Boolean','sap/ui/model/type/String','sap/ui/model/odata/type/String','sap/ui/model/type/Date','sap/ui/model/type/Time','sap/ui/model/odata/type/DateTime','sap/ui/model/type/Float','sap/ui/layout/library','sap/ui/layout/Grid','sap/ui/layout/GridData','sap/ui/layout/HorizontalLayout','./Button','./OverflowToolbar','./OverflowToolbarLayoutData','./ToolbarSpacer','./Text','./SearchField','./CheckBox','./ComboBox','./Select','./Label','./Input','./DatePicker','./TimePicker','./DateTimePicker','sap/base/Log','sap/ui/thirdparty/jquery','./P13nOperationsHelper','sap/m/P13nConditionPanelRenderer'],function(a,c,C,I,D,b,R,d,L,B,S,e,f,T,g,F,h,G,k,H,m,O,o,q,r,s,t,u,v,x,y,z,A,E,J,Q,P,K){"use strict";var V=c.ValueState;var M=a.ButtonType;var N=a.ToolbarDesign;var U=c.TextAlign;var W=a.OverflowToolbarPriority;var X=a.P13nConditionOperation;
var Y=C.extend("sap.m.P13nConditionPanel",{
metadata:{library:"sap.m",properties:{maxConditions:{type:"string",group:"Misc",defaultValue:'-1'},exclude:{type:"boolean",group:"Misc",defaultValue:false},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},autoAddNewRow:{type:"boolean",group:"Misc",defaultValue:false},disableFirstRemoveIcon:{type:"boolean",group:"Misc",defaultValue:false},alwaysShowAddIcon:{type:"boolean",group:"Misc",defaultValue:true},usePrevConditionSetting:{type:"boolean",group:"Misc",defaultValue:true},autoReduceKeyFieldItems:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null},showLabel:{type:"boolean",group:"Misc",defaultValue:false},displayFormat:{type:"string",group:"Misc",defaultValue:null},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{dataChange:{}}},
renderer:K.renderer
});
Y.prototype.setConditions=function(j){if(!j){J.error("sap.m.P13nConditionPanel : aCondition is not defined");}if(this._bIgnoreSetConditions){return;}this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;for(var i=0;i<j.length;i++){this._addCondition2Map(j[i]);}this._clearConditions();this._fillConditions();};
Y.prototype.removeAllConditions=function(){this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._clearConditions();this._fillConditions();};
Y.prototype.addCondition=function(i){if(this._bIgnoreSetConditions){return;}i.index=this._iConditions;this._addCondition2Map(i);this._addCondition(i);};
Y.prototype.insertCondition=function(i,j){if(this._bIgnoreSetConditions){return;}if(j!==undefined){i.index=j;}this._addCondition2Map(i);this._addCondition(i);};
Y.prototype.removeCondition=function(i){this._clearConditions();if(typeof i=="string"){this._removeConditionFromMap(i);}if(typeof i=="object"){this._removeConditionFromMap(i.key);}this._fillConditions();};
Y.prototype._addCondition2Map=function(i){if(!i.key){i.key="condition_"+this._iConditions;if(this.getExclude()){i.key="x"+i.key;}}this._iConditions++;this._oConditionsMap[i.key]=i;this._aConditionKeys.push(i.key);};
Y.prototype._removeConditionFromMap=function(j){this._iConditions--;delete this._oConditionsMap[j];var i=this._aConditionKeys.indexOf(j);if(i>=0){this._aConditionKeys.splice(i,1);}};
Y.prototype.getConditions=function(){var i;var j=[];if(this._oConditionsMap){for(var l in this._oConditionsMap){i=this._oConditionsMap[l];var n=i.value;if(!n){n=this._getFormatedConditionText(i.operation,i.value1,i.value2,i.exclude,i.keyField,i.showIfGrouped);}if(!i._oGrid||i._oGrid.select.getSelected()){j.push({"key":l,"text":n,"exclude":i.exclude,"operation":i.operation,"keyField":i.keyField,"value1":i.value1,"value2":this._hasSecondValue(i.operation)?i.value2:null,"showIfGrouped":i.showIfGrouped});}}}return j;};
Y.prototype.setOperations=function(i,j){j=j||"default";this._oTypeOperations[j]=i;this._updateAllOperations();};
Y.prototype.setValues=function(i,j){j=j||"default";this._oTypeValues[j]=i;};
Y.prototype.addOperation=function(i,j){j=j||"default";this._oTypeOperations[j].push(i);this._updateAllOperations();};
Y.prototype.removeAllOperations=function(i){i=i||"default";this._oTypeOperations[i]=[];this._updateAllOperations();};
Y.prototype.getOperations=function(i){i=i||"default";return this._oTypeOperations[i];};
Y.prototype.setKeyFields=function(i){this._aKeyFields=i;this._aKeyFields.forEach(function(j){Y._createKeyFieldTypeInstance(j);},this);this._updateKeyFieldItems(this._oConditionsGrid,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};
Y.prototype.addKeyField=function(i){this._aKeyFields.push(i);Y._createKeyFieldTypeInstance(i);this._updateKeyFieldItems(this._oConditionsGrid,true,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};
Y._createKeyFieldTypeInstance=function(i){var j;if(!i.typeInstance){switch(i.type){case"boolean":i.typeInstance=new B();break;case"numc":if(!(i.formatSettings&&i.formatSettings.isDigitSequence)){J.error("sap.m.P13nConditionPanel","NUMC type support requires isDigitSequence==true!");i.formatSettings=Object.assign({},i.formatSettings,{isDigitSequence:true});}j=i.formatSettings;if(i.maxLength){j=Object.assign({},j,{maxLength:i.maxLength});}if(!j.maxLength){J.error("sap.m.P13nConditionPanel","NUMC type suppport requires maxLength!");}i.typeInstance=new e({},j);break;case"date":i.typeInstance=new f(Object.assign({},i.formatSettings,{strictParsing:true}),{});break;case"time":i.typeInstance=new T(Object.assign({},i.formatSettings,{strictParsing:true}),{});break;case"datetime":i.typeInstance=new g(Object.assign({},i.formatSettings,{strictParsing:true}),{displayFormat:"Date"});var n=i.typeInstance;if(!n.oFormat){n.formatValue(new Date(),"string");}if(n.oFormat){n.oFormat.oFormatOptions.UTC=false;}break;case"numeric":if(i.precision||i.scale){j={};if(i.precision){j["maxIntegerDigits"]=parseInt(i.precision);}if(i.scale){j["maxFractionDigits"]=parseInt(i.scale);}}i.typeInstance=new F(j);break;default:var l=i.formatSettings;if(i.maxLength){l=Object.assign({},l,{maxLength:i.maxLength});}i.typeInstance=new S({},l);break;}}};
Y.prototype.removeAllKeyFields=function(){this._aKeyFields=[];this._updateKeyFieldItems(this._oConditionsGrid,true);};
Y.prototype.getKeyFields=function(){return this._aKeyFields;};
Y.prototype.setAlwaysShowAddIcon=function(i){this.setProperty("alwaysShowAddIcon",i);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");}return this;};
Y.prototype.setLayoutMode=function(l){this.setProperty("layoutMode",l);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",l!=="Desktop");}this._updateConditionFieldSpans(l);this._clearConditions();this._fillConditions();return this;};
Y.prototype.setContainerQuery=function(i){this._unregisterResizeHandler();this.setProperty("containerQuery",i);this._registerResizeHandler();this._clearConditions();this._fillConditions();return this;};
Y.prototype._updateConditionFieldSpans=function(i){if(this._aConditionsFields){var j=i==="Desktop";if(j){this._aConditionsFields[2].SpanFilter="L3 M3 S3";this._aConditionsFields[4].SpanFilter="L2 M2 S2";this._aConditionsFields[5].SpanFilter="L3 M3 S3";this._aConditionsFields[6].SpanFilter="L2 M2 S2";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}var l=i==="Tablet";if(l){this._aConditionsFields[2].SpanFilter="L5 M5 S5";this._aConditionsFields[4].SpanFilter="L5 M5 S5";this._aConditionsFields[5].SpanFilter="L10 M10 S10";this._aConditionsFields[6].SpanFilter="L10 M10 S10";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}}};
Y.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sFromLabelText=this._oRb.getText("CONDITIONPANEL_LABELFROM");this._sToLabelText=this._oRb.getText("CONDITIONPANEL_LABELTO");this._sValueLabelText=this._oRb.getText("CONDITIONPANEL_LABELVALUE");this._sShowIfGroupedLabelText=this._oRb.getText("CONDITIONPANEL_LABELGROUPING");this._sValidationDialogFieldMessage=this._oRb.getText("CONDITIONPANEL_FIELDMESSAGE");this._oOperationsHelper=new P();this._oTypeOperations={"default":[]};this._oTypeValues={"default":[]};this._aKeyFields=[];this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._sLayoutMode="Desktop";this._sConditionType="Filter";this._sAddRemoveIconTooltip="FILTER";this._iBreakPointTablet=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD].points[0];this._iBreakPointDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD].points[1];this._oConditionsGrid=new G({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:0,vSpacing:0}).toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");this._oConditionsGrid.addStyleClass("sapUiRespGridOverflowHidden");this._iFirstConditionIndex=0;this._iConditionPageSize=10;this._oInvisibleTextField=new b({text:this._oRb.getText("CONDITIONPANEL_FIELD_LABEL")});this._oInvisibleTextOperatorInputValue=new b({text:this._oRb.getText("CONDITIONPANEL_FIELD_VALUE_ARIA_LABEL")});this._oInvisibleTextOperator=new b({text:this._oRb.getText("CONDITIONPANEL_OPERATOR_ARIA_LABEL")});this._oInvisibleTextOperatorAddButton=new b({text:this._oRb.getText("CONDITIONPANEL_ADD_SCREENREADER_DESCRIPTION")});this.addAggregation("content",this._oInvisibleTextField);this.addAggregation("content",this._oInvisibleTextOperatorInputValue);this.addAggregation("content",this._oInvisibleTextOperator);this.addAggregation("content",this._oInvisibleTextOperatorAddButton);this.addAggregation("content",this._oConditionsGrid);this._registerResizeHandler();this._aConditionsFields=this._createConditionsFields();this._oButtonGroupSpan={"SpanFilter":"L2 M2 S2","SpanSort":D.system.phone?"L2 M2 S4":"L2 M2 S3","SpanGroup":"L2 M2 S3"};this._updateConditionFieldSpans(this.getLayoutMode());this._fillConditions();};
Y.prototype._createPaginatorToolbar=function(){this._bPaginatorButtonsVisible=false;var i=this;this._oPrevButton=new m({icon:I.getIconURI("navigation-left-arrow"),tooltip:this._oRb.getText("WIZARD_FINISH"),visible:true,press:function(j){i._iFirstConditionIndex=Math.max(0,i._iFirstConditionIndex-i._iConditionPageSize);i._clearConditions();i._fillConditions();},layoutData:new o({priority:W.NeverOverflow})});this._oNextButton=new m({icon:I.getIconURI("navigation-right-arrow"),tooltip:this._oRb.getText("WIZARD_NEXT"),visible:true,press:function(j){i._iFirstConditionIndex+=i._iConditionPageSize;i._clearConditions();i._fillConditions();},layoutData:new o({priority:W.NeverOverflow})});this._oRemoveAllButton=new m({text:this._oRb.getText("CONDITIONPANEL_REMOVE_ALL"),visible:true,press:function(j){i._aConditionKeys.forEach(function(l,n){if(n>=0){this.fireDataChange({key:l,index:n,operation:"remove",newData:null});}},i);this._iFirstConditionIndex=0;i.removeAllConditions();},layoutData:new o({priority:W.Low})});this._oAddButton=new m({icon:I.getIconURI("add"),visible:true,press:function(j){var l=i._createConditionRow(i._oConditionsGrid,undefined,null,0);i._changeField(l);setTimeout(function(){l.keyField.focus();});i._updatePaginatorToolbar();},layoutData:new o({priority:W.Low}),ariaDescribedBy:this._oInvisibleTextOperatorAddButton});this._oHeaderText=new r({wrapping:false,layoutData:new o({priority:W.NeverOverflow})});this._oPageText=new r({wrapping:false,textAlign:U.Center,layoutData:new o({priority:W.NeverOverflow})});this._oFilterField=new s({width:"12rem",layoutData:new o({priority:W.High})});this._oPaginatorToolbar=new O({height:"3rem",design:N.Transparent,content:[this._oHeaderText,new q(),this._oFilterField,this._oPrevButton,this._oPageText,this._oNextButton,this._oRemoveAllButton,this._oAddButton]});};
Y.prototype._updatePaginatorToolbar=function(){if(this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"){return;}var i=this._aConditionKeys.length;var p=1+Math.floor(Math.max(0,i-1)/this._iConditionPageSize);var j=1+Math.floor(this._iFirstConditionIndex/this._iConditionPageSize);var l=this.getParent();if(!this._oPaginatorToolbar){if(i>this._iConditionPageSize){this._createPaginatorToolbar();this.insertAggregation("content",this._oPaginatorToolbar,0);this._onGridResize();}else{if(l&&l.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=l.getHeaderText();}l.setHeaderText(this._sOrgHeaderText+(i>0?" ("+i+")":""));}return;}}this._oPrevButton.setEnabled(this._iFirstConditionIndex>0);this._oNextButton.setEnabled(this._iFirstConditionIndex+this._iConditionPageSize<i);if(l&&l.setHeaderToolbar){if(!l.getHeaderToolbar()){this.removeAggregation("content",this._oPaginatorToolbar);l.setHeaderToolbar(this._oPaginatorToolbar);l.attachExpand(function(Z){this._setToolbarElementVisibility(Z.getSource().getExpanded()&&this._bPaginatorButtonsVisible);}.bind(this));}}if(l&&l.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=l.getHeaderText();}var n=this._sOrgHeaderText+(i>0?" ("+i+")":"");l.setHeaderText(n);this._oHeaderText.setText(n);}else{this._oHeaderText.setText(i+" Conditions");}this._oPageText.setText(j+"/"+p);this._bPaginatorButtonsVisible=this._bPaginatorButtonsVisible||p>1;this._setToolbarElementVisibility(this._bPaginatorButtonsVisible);if(j>p){this._iFirstConditionIndex-=Math.max(0,this._iConditionPageSize);this._clearConditions();this._fillConditions();}var w=0;this._oConditionsGrid.getContent().forEach(function(Z){if(Z.select.getSelected()){w++;}},this);if(p==j&&(i-this._iFirstConditionIndex)>w){this._clearConditions();this._fillConditions();}};
Y.prototype._setToolbarElementVisibility=function(i){this._oPrevButton.setVisible(i);this._oNextButton.setVisible(i);this._oPageText.setVisible(i);this._oFilterField.setVisible(false);this._oAddButton.setVisible(i);this._oRemoveAllButton.setVisible(i);};
Y.prototype.exit=function(){this._clearConditions();this._unregisterResizeHandler();this._aConditionsFields=null;this._aKeys=null;this._aKeyFields=null;this._oTypeOperations=null;this._oRb=null;this._sFromLabelText=null;this._sToLabelText=null;this._sValueLabelText=null;this._sValidationDialogFieldMessage=null;this._oConditionsMap=null;this._aConditionKeys=[];};
Y.prototype._clearConditions=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){for(var l in this._aConditionsFields){var n=this._aConditionsFields[l];if(j[n["ID"]]&&j.getContent().indexOf(j[n["ID"]])===-1){j[n["ID"]].destroy();}}},this);this._oConditionsGrid.destroyContent();};
Y.prototype._fillConditions=function(){var j,l;var i=0,p=this._getMaxConditionsAsNumber(),n=this._aConditionKeys.length;if(this._oConditionsMap){var w=this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"?9999:this._iConditionPageSize;n=Math.min(n,Math.min(p,this._iFirstConditionIndex+w));for(i=this._iFirstConditionIndex;i<n;i++){l=this._aConditionKeys[i];j=this._oConditionsMap[l];this._createConditionRow(this._oConditionsGrid,j,l);}}this._updatePaginatorToolbar();if((this.getAutoAddNewRow()||this._oConditionsGrid.getContent().length===0)&&this._oConditionsGrid.getContent().length<p){this._createConditionRow(this._oConditionsGrid);}};
Y.prototype._addCondition=function(j){var i=0;var l=this._getMaxConditionsAsNumber();if(this._oConditionsMap){for(var n in this._oConditionsMap){if(i<l&&j===this._oConditionsMap[n]){this._createConditionRow(this._oConditionsGrid,j,n,i);}i++;}}this._updatePaginatorToolbar();};
Y.prototype._getMaxConditionsAsNumber=function(){return this.getMaxConditions()==="-1"?9999:parseInt(this.getMaxConditions());};
Y.prototype.onAfterRendering=function(){if(this.getLayoutMode()){this._sLayoutMode=this.getLayoutMode();return;}};
Y.prototype._handleMediaChange=function(p){this._sLayoutMode=p.name;this._updateLayout(p);};
Y.prototype._unregisterResizeHandler=function(){if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}D.media.detachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);};
Y.prototype._registerResizeHandler=function(){if(this.getContainerQuery()){this._sContainerResizeListener=R.register(this._oConditionsGrid,this._onGridResize.bind(this));this._onGridResize();}else{D.media.attachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);}};
Y.prototype._getKeyFromConditionGrid=function(i){var j=i.data("_key");if(!j){j=this._createConditionKey();}return j;};
Y.prototype._createConditionKey=function(){var i=0;var j;do{j="condition_"+i;if(this.getExclude()){j="x"+j;}i++;}while(this._oConditionsMap[j]);return j;};
Y.prototype._createConditionRow=function(i,j,l,p,n){var w,Z=this;if(p===undefined){p=i.getContent().length;}var $=new G({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:1,vSpacing:0,containerQuery:this.getContainerQuery()}).data("_key",l);$.addStyleClass("sapUiRespGridOverflowHidden");for(var _ in this._aConditionsFields){var a1;var b1=this._aConditionsFields[_];switch(b1["Control"]){case"CheckBox":a1=new t({enabled:false,layoutData:new k({span:b1["Span"+this._sConditionType]})});this._setLayoutVisible(a1,false);if(b1["ID"]==="showIfGrouped"){a1.setEnabled(true);a1.setText(b1["Label"]);a1.attachSelect(function(){Z._changeField($);});a1.setSelected(j?j.showIfGrouped:true);}else{if(j){a1.setSelected(true);a1.setEnabled(true);}}break;case"ComboBox":if(b1["ID"]==="keyField"){a1=new u({width:"100%",ariaLabelledBy:this._oInvisibleTextField});var c1=a1.setSelectedKey.bind(a1);a1.setSelectedKey=function(l){c1(l);var o1=Z.getValidationExecutor();if(o1){o1();}};var d1=a1.setSelectedItem.bind(a1);a1.setSelectedItem=function(o1){d1(o1);var p1=Z.getValidationExecutor();if(p1){p1();}};a1.setLayoutData(new k({span:b1["Span"+this._sConditionType]}));this._fillKeyFieldListItems(a1,this._aKeyFields);if(a1.attachSelectionChange){a1.attachSelectionChange(function(o1){var p1=Z.getValidationExecutor();if(p1){p1();}Z._handleSelectionChangeOnKeyField(i,$);});}if(a1.attachChange){a1.attachChange(function(o1){$.keyField.close();Z._handleChangeOnKeyField(i,$);});}if(a1.setSelectedItem){if(j){a1.setSelectedKey(j.keyField);this._aKeyFields.forEach(function(e1,o1){var p1=e1.key;if(p1===undefined){p1=e1;}if(j.keyField===p1){a1.setSelectedItem(a1.getItems()[o1]);}},this);}else{if(this.getUsePrevConditionSetting()&&!this.getAutoReduceKeyFieldItems()){if(p>0&&!l&&n){w=i.getContent()[p-1];if(w.keyField.getSelectedKey()){a1.setSelectedKey(w.keyField.getSelectedKey());}else{if(!a1.getSelectedItem()&&a1.getItems().length>0){a1.setSelectedItem(a1.getItems()[0]);}}}else{this._aKeyFields.some(function(e1,o1){if(e1.isDefault){a1.setSelectedItem(a1.getItems()[o1]);return true;}if(!a1.getSelectedItem()&&e1.type!=="boolean"){a1.setSelectedItem(a1.getItems()[o1]);}},this);if(!a1.getSelectedItem()&&a1.getItems().length>0){a1.setSelectedItem(a1.getItems()[0]);}}}else{this._aKeyFields.forEach(function(e1,o1){if(e1.isDefault){a1.setSelectedItem(a1.getItems()[o1]);}},this);}}}}if(b1["ID"]==="operation"){a1=new v({width:"100%",ariaLabelledBy:this._oInvisibleTextOperator,layoutData:new k({span:b1["Span"+this._sConditionType]})});a1.attachChange(function(){Z._handleChangeOnOperationField(i,$);});$[b1["ID"]]=a1;this._updateOperationItems(i,$);if(j){var e1=this._getCurrentKeyFieldItem($.keyField),f1=this._getRelevantOperations(e1),g1=this.getCurrentOparation(j);f1.some(function(o1){if(g1===o1){a1.setSelectedKey(o1);return true;}},this);}else{if(this.getUsePrevConditionSetting()){if(p>0&&l===null){var w=i.getContent()[p-1];a1.setSelectedKey(w.operation.getSelectedKey());}}}}if(a1.getSelectedItem&&a1.getSelectedItem()&&a1.getMetadata()._sUIDToken!=="box"){a1.setTooltip(a1.getSelectedItem().getTooltip()||a1.getSelectedItem().getText());}break;case"TextField":var h1=this._getCurrentKeyFieldItem($.keyField);a1=this._createValueField(h1,b1,$);a1.oTargetGrid=i;if(j&&j[b1["ID"]]!==undefined){var i1=j[b1["ID"]];if(a1 instanceof v){if(typeof i1==="boolean"){a1.setSelectedIndex(i1?2:1);}}else if(i1!==null&&$.oType){if(typeof i1==="string"&&$.oType.getName()==="sap.ui.comp.odata.type.StringDate"){a1.setValue(i1);}else{if(typeof i1==="string"&&["String","sap.ui.model.odata.type.String","sap.ui.model.odata.type.Decimal"].indexOf($.oType.getName())==-1){try{i1=$.oType.parseValue(i1,"string");a1.setValue($.oType.formatValue(i1,"string"));}catch(j1){J.error("sap.m.P13nConditionPanel","Value '"+i1+"' does not have the expected type format for "+$.oType.getName()+".parseValue()");}}else{a1.setValue($.oType.formatValue(i1,"string"));}}}else{a1.setValue(i1);}}break;case"Label":a1=new x({text:b1["Text"]+":",visible:this.getShowLabel(),layoutData:new k({span:b1["Span"+this._sConditionType]})}).addStyleClass("conditionLabel");a1.oTargetGrid=i;break;}$[b1["ID"]]=a1;$.addContent(a1);}this._addButtons($,i);i.insertContent($,p);this._updateOperationItems(i,$);this._changeOperationValueFields(i,$);this._updateAllConditionsEnableStates();this._updateConditionButtons(i);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false);}if(this._sLayoutMode){this._updateLayout({name:this._sLayoutMode});}if(j){var k1=this._getFormatedConditionText(j.operation,j.value1,j.value2,j.exclude,j.keyField,j.showIfGrouped);j._oGrid=$;j.value=k1;this._oConditionsMap[l]=j;}var l1=$.operation.getSelectedKey();if(l1==="BT"&&$.value1.setMinDate&&$.value2.setMaxDate){var m1=$.value1.getDateValue();var n1=$.value2.getDateValue();this._updateMinMaxDate($,m1,n1);}else{this._updateMinMaxDate($,null,null);}return $;};
Y.prototype._handleRemoveCondition=function(i,j){var l=i.getContent().indexOf(j);this._removeCondition(i,j);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false);}if(l>=0){l=Math.min(l,i.getContent().length-1);var j=i.getContent()[l];setTimeout(function(){j.remove.focus();});}this._updatePaginatorToolbar();};
Y.prototype._handleAddCondition=function(i,j,l){var p=i.getContent().indexOf(j);var n=this._createConditionRow(i,undefined,null,p+1,l);this._changeField(n);setTimeout(function(){if(n.keyField.getVisible()){n.keyField.focus();return;}if(n.operation.getVisible()){n.operation.focus();}});this._updatePaginatorToolbar();};
Y.prototype._getCurrentKeyFieldItem=function(i){if(i.getSelectedKey&&i.getSelectedKey()){var j=i.getSelectedKey();var l=this._aKeyFields;for(var n in l){var p=l[n];if(p.key===j){return p;}}}return null;};
Y.prototype._createValueField=function(j,n,p){var w;var Z;var $=this;var _={value:n["Value"],width:"100%",placeholder:n["Label"],change:function(i){$._validateAndFormatFieldValue(i);$._changeField(p,i);},layoutData:new k({span:n["Span"+this._sConditionType]})};if(j&&j.typeInstance){var a1=j.typeInstance;Z=this._findConfig(a1,"ctrl");if(Z==="DateTimePicker"&&a1.getMetadata().getName()==="sap.ui.model.odata.type.DateTime"){if(!(a1.oConstraints&&a1.oConstraints.isDateOnly)){J.error("sap.m.P13nConditionPanel","sap.ui.model.odata.type.DateTime without displayFormat = Date is not supported!");a1.oConstraints=Object.assign({},a1.oConstraints,{isDateOnly:true});}Z="DatePicker";}p.oType=a1;if(Z=="select"){var b1=[];var c1=j.values||this._oTypeValues[Z]||["",a1.formatValue(false,"string"),a1.formatValue(true,"string")];c1.forEach(function(i,e1){b1.push(new d({key:e1.toString(),text:i.toString()}));});_={width:"100%",items:b1,change:function(){$._changeField(p);$._makeFieldValid(w,true);},layoutData:new k({span:n["Span"+this._sConditionType]})};w=new v(_);}else if(Z=="TimePicker"){if(a1.oFormatOptions&&a1.oFormatOptions.style){_.displayFormat=a1.oFormatOptions.style;}w=new A(_);}else if(Z=="DateTimePicker"){if(a1.oFormatOptions&&a1.oFormatOptions.style){_.displayFormat=a1.oFormatOptions.style;}w=new E(_);}else if(Z==="DatePicker"){if(a1.oFormatOptions){_.displayFormat=a1.oFormatOptions.style||a1.oFormatOptions.pattern;if(a1.isA("sap.ui.comp.odata.type.StringDate")){_.valueFormat="yyyyMMdd";}}w=new z(_);}else{w=new y(_);if(this._fSuggestCallback){j=this._getCurrentKeyFieldItem(p.keyField);if(j&&j.key){var d1=this._fSuggestCallback(w,j.key);if(d1){w._oSuggestProvider=d1;}}}}}else{p.oType=null;w=new y(_);}if(Z!=="boolean"&&Z!=="enum"&&w){w.onpaste=function(e1){var f1;if(window.clipboardData){f1=window.clipboardData.getData("Text");}else{f1=e1.originalEvent.clipboardData.getData('text/plain');}var p=e1.srcControl.getParent();var g1=f1.split(/\r\n|\r|\n/g);if(g1&&g1[g1.length-1].trim()===""){g1.pop();}var h1=p.operation;var op=h1.getSelectedKey();if(g1&&g1.length>1&&op!=="BT"){setTimeout(function(){var i1=g1?g1.length:0;var j1=$._getCurrentKeyFieldItem(p.keyField);var h1=p.operation;for(var i=0;i<i1;i++){if($._aConditionKeys.length>=$._getMaxConditionsAsNumber()){break;}var k1=g1[i].trim();if(k1){var l1;if(j1.typeInstance){try{l1=j1.typeInstance.parseValue(k1,"string");j1.typeInstance.validateValue(l1);}catch(m1){J.error("sap.m.P13nConditionPanel.onPaste","not able to parse value "+k1+" with type "+j1.typeInstance.getName());k1="";l1=null;}if(!l1){continue;}}var n1={"oOperation":h1.getSelectedKey(),"oKeyField":j1.key,"oPastedValue":l1},o1=$._getConditions(n1);$._addCondition2Map(o1);$.fireDataChange({key:o1.key,index:o1.index,operation:"add",newData:o1});}}$._clearConditions();$._fillConditions();},0);}};}if(j&&j.maxLength&&w.setMaxLength){var l=-1;if(typeof j.maxLength==="string"){l=parseInt(j.maxLength);}if(typeof j.maxLength==="number"){l=j.maxLength;}if(l>0&&(!w.getShowSuggestion||!w.getShowSuggestion())){w.setMaxLength(l);}}return w;};
Y.prototype._getConditions=function(i){return{"index":this._iConditions,"key":this._createConditionKey(),"exclude":this.getExclude(),"operation":i.oOperation,"keyField":i.oKeyField,"value1":i.oPastedValue,"value2":null};};
Y.prototype._fillOperationListItems=function(i,j,l){var n,p;if(l==="_STRING_"){l="";}if(l==="_TIME_"||l==="_DATETIME_"){l="_DATE_";}if(l==="_BOOLEAN_"||l==="_NUMC_"){l="";}i.destroyItems();j.forEach(function(w){p="CONDITIONPANEL_OPTION"+l+w;if(l&&this._oRb.hasText(p)){n=this._oRb.getText(p);}else{n=this._oRb.getText("CONDITIONPANEL_OPTION"+w);}i.addItem(new L({key:w,text:n,tooltip:n}));}.bind(this));};
Y.prototype._fillKeyFieldListItems=function(i,j){i.destroyItems();for(var l in j){var n=j[l];i.addItem(new L({key:n.key,text:n.text,tooltip:n.tooltip?n.tooltip:n.text}));}i.setEditable(i.getItems().length>1);};
Y.prototype._handleChangeOnOperationField=function(i,j){this._changeOperationValueFields(i,j);this._changeField(j);};
Y.prototype._handleSelectionChangeOnKeyField=function(i,j){if(this._sConditionType==="Filter"){this._updateOperationItems(i,j);this._createAndUpdateValueFields(i,j);this._changeOperationValueFields(i,j);}this._changeField(j);};
Y.prototype._handleChangeOnKeyField=function(i,j){if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false,false,j.keyField);}};
Y.prototype._createAndUpdateAllKeyFields=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){this._createAndUpdateValueFields(this._oConditionsGrid,j);this._changeOperationValueFields(this._oConditionsGrid,j);},this);};
Y.prototype._createAndUpdateValueFields=function(i,j){var l=this._getCurrentKeyFieldItem(j.keyField);var n=function(j,p,w){var Z=p.getValue?p.getValue():"";var $=j.indexOfContent(p);j.removeContent(p);if(p._oSuggestProvider){p._oSuggestProvider.destroy();p._oSuggestProvider=null;}p.destroy();var _=this._aConditionsFields[w];p=this._createValueField(l,_,j);j[_["ID"]]=p;j.insertContent(p,$===-1?j.indexOfContent(j.operation)+1:$);var a1,b1;if(j.oType&&Z){try{a1=j.oType.parseValue(Z,"string");j.oType.validateValue(a1);b1=j.oType.formatValue(a1,"string");p.setValue(b1);}catch(c1){var d1=c1.message;this._makeFieldValid(p,false,d1);p.setValue(Z);}}};n.bind(this)(j,j.value1,5);n.bind(this)(j,j.value2,6);};
Y.prototype._updateAllOperations=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){this._updateOperationItems(this._oConditionsGrid,j);this._changeOperationValueFields(this._oConditionsGrid,j);},this);};
Y.prototype._updateOperationItems=function(i,j){var l=this._getCurrentKeyFieldItem(j.keyField);var n=l&&l.type||"";var p=j.operation;var w=p.getSelectedItem();var Z=this._getRelevantOperations(l);this._fillOperationListItems(p,Z,n?"_"+n.toUpperCase()+"_":"");if(w&&p.getItemByKey(w.getKey())){p.setSelectedKey(w.getKey());}else{p.setSelectedItem(p.getItems()[0]);}this._sConditionType="Filter";if(Z[0]===X.Ascending||Z[0]===X.Descending){this._sConditionType="Sort";}if(Z[0]===X.GroupAscending||Z[0]===X.GroupDescending){this._sConditionType="Group";}this._adjustValue1Span(j);};
Y.prototype._updateKeyFieldItems=function(l,p,w,Z){var n=l.getContent().length;var i;var $={};if(!p){for(i=0;i<n;i++){var _=l.getContent()[i].keyField;var a1=_.getSelectedKey();if(a1!=null&&a1!==""){$[a1]=true;}}}for(i=0;i<n;i++){var _=l.getContent()[i].keyField;var b1=l.getContent()[i].select;var c1=_.getSelectedKey();var j=0;var d1=this._aKeyFields;if(_!==Z){if(w){j=d1.length-1;}else{_.destroyItems();}for(j;j<d1.length;j++){var e1=d1[j];if(e1.key==null||e1.key===""||!$[e1.key]||e1.key===c1){_.addItem(new L({key:e1.key,text:e1.text,tooltip:e1.tooltip?e1.tooltip:e1.text}));}}_.setEditable(_.getItems().length>1);}if(c1){_.setSelectedKey(c1);}else if(_.getItems().length>0){_.setSelectedItem(_.getItems()[0]);}if(!b1.getSelected()){this._aKeyFields.some(function(f1,g1){if(f1.isDefault){_.setSelectedItem(_.getItems()[g1]);return true;}if(!_.getSelectedItem()){if(f1.type!=="boolean"){_.setSelectedItem(_.getItems()[g1]);}}},this);}if(_.getSelectedItem()){_.setTooltip(_.getSelectedItem().getTooltip()||_.getSelectedItem().getText());}}};
Y.prototype._changeOperationValueFields=function(i,j){var l=j.operation;var n=l.getSelectedKey();var p=j.value1;var w=j.value2;var Z=j.showIfGrouped;if(!n){return;}if(this._hasSecondValue(n)){if(p.setPlaceholder&&p.getPlaceholder()!==this._sFromLabelText){p.setPlaceholder(this._sFromLabelText);}if(!p.getVisible()){p.setVisible(true);j.insertContent(p,j.getContent().length-1);}if(w.setPlaceholder&&w.getPlaceholder()!==this._sToLabelText){w.setPlaceholder(this._sToLabelText);}if(!w.getVisible()){w.setVisible(true);j.insertContent(w,j.getContent().length-this._getSecondValueNegativeIndex());}}else{if(n===X.GroupAscending||n===X.GroupDescending){if(p.getVisible()){p.setVisible(false);j.removeContent(p);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}if(l.getVisible()){l.setVisible(false);j.removeContent(l);}Z.setVisible(this._getMaxConditionsAsNumber()!=1);this._setLayoutVisible(Z,this._getMaxConditionsAsNumber()!=1);}else{if(this._hasNoValues(n)){if(p.getVisible()){p.setVisible(false);j.removeContent(p);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}j.removeContent(Z);}else{if(p.setPlaceholder&&p.getPlaceholder()!==this._sValueLabelText){p.setPlaceholder(this._sValueLabelText);}if(!p.getVisible()){p.setVisible(true);j.insertContent(p,j.getContent().length-1);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}}}}this._adjustValue1Span(j);};
Y.prototype._adjustValue1Span=function(i){if(this._sConditionType==="Filter"&&i.value1&&i.operation){var j=i.operation;var n=this._aConditionsFields[5]["Span"+this._sConditionType];if(j.getSelectedKey()!=="BT"){n="L5 M10 S10";}var l=i.value1.getLayoutData();if(l.getSpan()!==n){l.setSpan(n);}}};
Y.prototype._getIndexOfCondition=function(i){var j=-1;i.getParent().getContent().some(function(l){if(l.select.getSelected()){j++;}return(l===i);},this);return j+this._iFirstConditionIndex;};
Y.prototype._makeFieldValid=function(i,j,l){if(j){i.setValueState(V.None);i.setValueStateText("");}else{i.setValueState(V.Warning);i.setValueStateText(l?l:this._sValidationDialogFieldMessage);}};
Y.prototype._validateAndFormatFieldValue=function(i){var j=i.oSource;var l=j.getParent();var n;if(j.getDateValue&&i){n=i.getParameter("value");var p=i.getParameter("valid");this._makeFieldValid(j,p);return;}else{n=j.getValue&&j.getValue();}if(!l){return;}if(this.getDisplayFormat()==="UpperCase"&&n){n=n.toUpperCase();j.setValue(n);}if(l.oType&&n){try{var w=l.oType.parseValue(n,"string");l.oType.validateValue(w);this._makeFieldValid(j,true);n=l.oType.formatValue(w,"string");j.setValue(n);}catch(Z){var $=Z.message;this._makeFieldValid(j,false,$);}}else{this._makeFieldValid(j,true);}};
Y.prototype._updateMinMaxDate=function(i,j,l){if(i.value1.setMinDate&&i.value2.setMaxDate){if(i.value1&&i.value1.setMaxDate){i.value1.setMaxDate(l instanceof Date?l:null);}if(i.value2&&i.value2.setMinDate){i.value2.setMinDate(j instanceof Date?j:null);}}};
Y.prototype._changeField=function(i,j){var l=i.keyField.getSelectedKey();if(i.keyField.getSelectedItem()){i.keyField.setTooltip(i.keyField.getSelectedItem().getTooltip()||i.keyField.getSelectedItem().getText());}else{i.keyField.setTooltip(null);}var n=i.operation.getSelectedKey();if(i.operation.getSelectedItem()){i.operation.setTooltip(i.operation.getSelectedItem().getTooltip()||i.operation.getSelectedItem().getText());}else{i.operation.setTooltip(null);}var p=function(j1,k1){var f1;var l1;if(j1.getDateValue&&!(j1.isA("sap.m.TimePicker"))&&k1.getName()!=="sap.ui.comp.odata.type.StringDate"){l1=j1.getDateValue();if(k1&&l1){if((j&&j.getParameter("valid"))||j1.isValidValue()){f1=k1.formatValue(l1,"string");}else{f1="";}}}else{f1=this._getValueTextFromField(j1);l1=f1;if(k1&&k1.getName()==="sap.ui.comp.odata.type.StringDate"){f1=k1.formatValue(l1,"string");}else if(k1&&f1){try{l1=k1.parseValue(f1,"string");k1.validateValue(l1);}catch(m1){J.error("sap.m.P13nConditionPanel","not able to parse value "+f1+" with type "+k1.getName());f1="";}}}return[l1,f1];}.bind(this);var w=p(i.value1,i.oType);var Z=w[0],$=w[1];w=p(i.value2,i.oType);var _=w[0],a1=w[1];if(this._hasSecondValue(n)){this._updateMinMaxDate(i,Z,_);}else{this._updateMinMaxDate(i,null,null);}var b1=this._getCurrentKeyFieldItem(i.keyField);if(b1&&b1.type==="numc"){if([X.Contains,X.EndsWith].indexOf(n)!=-1){Z=i.oType.formatValue(Z,"string");}}var c1=i.showIfGrouped.getSelected();var d1=this.getExclude();var e1=i.select;var f1="";var g1;if(l===""||l==null){l=null;g1=this._getKeyFromConditionGrid(i);this._removeConditionFromMap(g1);this._enableCondition(i,false);var h1=this._getIndexOfCondition(i);if(e1.getSelected()){e1.setSelected(false);e1.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:g1,index:h1,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}return;}this._enableCondition(i,true);f1=this._getFormatedConditionText(n,$,a1,d1,l,c1);var i1={"value":f1,"exclude":d1,"operation":n,"keyField":l,"value1":Z,"value2":this._hasSecondValue(n)?_:null,"showIfGrouped":c1};g1=this._getKeyFromConditionGrid(i);if(f1!==""){e1.setSelected(true);e1.setEnabled(true);var n="update";if(!this._oConditionsMap[g1]){n="add";}this._oConditionsMap[g1]=i1;if(n==="add"){this._aConditionKeys.splice(this._getIndexOfCondition(i),0,g1);}i.data("_key",g1);this.fireDataChange({key:g1,index:this._getIndexOfCondition(i),operation:n,newData:i1});}else if(this._oConditionsMap[g1]!==undefined){this._removeConditionFromMap(g1);i.data("_key",null);var h1=this._getIndexOfCondition(i);if(e1.getSelected()){e1.setSelected(false);e1.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:g1,index:h1,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}}this._updatePaginatorToolbar();};
Y.prototype._getValueTextFromField=function(i){if(i instanceof v){return i.getSelectedItem()?i.getSelectedItem().getText():"";}return i.getValue();};
Y.prototype._updateAllConditionsEnableStates=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){var l=this._getCurrentKeyFieldItem(j.keyField);var n=l&&l.key!==undefined?l.key:l;var p=n!==""&&n!==null;this._enableCondition(j,p);},this);};
Y.prototype._enableCondition=function(i,j){i.operation.setEnabled(j);i.value1.setEnabled(j);i.value2.setEnabled(j);i.showIfGrouped.setEnabled(j);};
Y.prototype._removeCondition=function(i,j){var l=this._getKeyFromConditionGrid(j);var n=-1;if(j.select.getSelected()){n=this._getIndexOfCondition(j);}this._removeConditionFromMap(l);j.destroy();if(i.getContent().length<1){this._createConditionRow(i);}else{this._updateConditionButtons(i);}if(n>=0){this.fireDataChange({key:l,index:n,operation:"remove",newData:null});}};
Y.prototype._updateConditionButtons=function(j){var l=this._getMaxConditionsAsNumber();var n=j.getContent().length;for(var i=0;i<n;i++){var p=j.getContent()[i].add;if((this.getAlwaysShowAddIcon()&&(n<l))||(i===n-1&&i<l-1)){p.removeStyleClass("displayNone");}else{p.addStyleClass("displayNone");}var w=j.getContent()[i].remove;if(l===1||(i===0&&n===1&&this.getDisableFirstRemoveIcon())){w.addStyleClass("displayNone");}else{w.removeStyleClass("displayNone");}}};
Y.prototype.validateConditions=function(){var j=this;var l=function(n){var p=true;for(var i=0;i<n.length;i++){var w=n[i];var Z=j._checkCondition(w,i===n.length-1);p=p&&Z;}return p;};return l(this._oConditionsGrid.getContent());};
Y.prototype.removeValidationErrors=function(){this._oConditionsGrid.getContent().forEach(function(i){var j=i.value1;var l=i.value2;j.setValueState(V.None);j.setValueStateText("");l.setValueState(V.None);l.setValueStateText("");},this);};
Y.prototype.removeInvalidConditions=function(){var i=[];this._oConditionsGrid.getContent().forEach(function(j){if(j.value1.getValueState()!==V.None||j.value2.getValueState()!==V.None){i.push(j);}},this);i.forEach(function(j){this._removeCondition(this._oConditionsGrid,j);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(this._oConditionsGrid,false);}},this);};
Y.prototype._checkCondition=function(i,j){var l=true;var n=i.value1;var p=i.value2;var w=n&&(n.getVisible()&&!this._getValueTextFromField(n));var Z=n&&n.getVisible()&&n.getValueState?n.getValueState():V.None;var $=p&&(p.getVisible()&&!this._getValueTextFromField(p));var _=p&&p.getVisible()&&p.getValueState?p.getValueState():V.None;var a1=i.operation.getSelectedKey();if(this._hasSecondValue(a1)){if(!w?$:!$){if(w){n.setValueState(V.Warning);n.setValueStateText(this._sValidationDialogFieldMessage);}if($){p.setValueState(V.Warning);p.setValueStateText(this._sValidationDialogFieldMessage);}l=false;}else if(Z!==V.None||_!==V.None){l=false;}else{n.setValueState(V.None);n.setValueStateText("");p.setValueState(V.None);p.setValueStateText("");}}if((n.getVisible()&&n.getValueState&&n.getValueState()!==V.None)||(p.getVisible()&&p.getValueState&&p.getValueState()!==V.None)){l=false;}return l;};
Y.prototype._getFormatedConditionText=function(j,l,n,p,w,Z){var $=Y.getFormatedConditionText(j,l,n,p);if(!$){switch(j){case X.Initial:$="=''";break;case X.NotEmpty:$="!''";break;case X.Ascending:$="ascending";break;case X.GroupAscending:$="ascending";$+=" showIfGrouped:"+Z;break;case X.Descending:$="descending";break;case X.GroupDescending:$="descending";$+=" showIfGrouped:"+Z;break;case X.Total:$="total";break;case X.Average:$="average";break;case X.Minimum:$="minimum";break;case X.Maximum:$="maximum";break;}if(p&&$!==""){$="!("+$+")";}}if(this._aKeyFields&&this._aKeyFields.length>1){var _=null;for(var i=0;i<this._aKeyFields.length;i++){var a1=this._aKeyFields[i];if(typeof a1!=="string"){if(a1.key===w&&a1.text){_=a1.text;}}}if(_&&$!==""){$=_+": "+$;}}return $;};
Y._oConditionMap={"EQ":"=$0","GT":">$0","GE":">=$0","LT":"<$0","LE":"<=$0","Contains":"*$0*","StartsWith":"$0*","EndsWith":"*$0","BT":"$0...$1","Empty":"<$r>"};(function(){var _=sap.ui.getCore().getLibraryResourceBundle("sap.m");Y._oConditionMap[X.Empty]=Y._oConditionMap[X.Empty].replace("$r",_.getText("CONDITIONPANEL_OPTIONEmpty"));})();
Y._templateReplace=function(i,j){return i.replace(/\$\d/g,function(l){return j[parseInt(l.substr(1))];});};
Y.getFormatedConditionText=function(i,j,l,n){var p="";switch(i){case X.Empty:p=Y._templateReplace(Y._oConditionMap[i],[]);break;case X.EQ:case X.GT:case X.GE:case X.LT:case X.LE:case X.Contains:case X.StartsWith:case X.EndsWith:if(j!==""&&j!==undefined&&j!==null){p=Y._templateReplace(Y._oConditionMap[i],[j]);}break;case X.BT:if(j!==""&&j!==undefined&&j!==null){if(l!==""&&l!==undefined&&l!==null){p=Y._templateReplace(Y._oConditionMap[i],[j,l]);}}break;default:break;}if(n&&p!==""){p="!("+p+")";}return p;};
Y.prototype._updateLayout=function(j){if(!this._oConditionsGrid){return;}var l=this._oConditionsGrid.getContent();var n=this._aConditionsFields.length;var p=n;if(j.name==="Tablet"){p=5;}if(j.name==="Phone"){p=3;}if(this._sConditionType==="Filter"){for(var i=0;i<l.length;i++){var w=l[i];w.ButtonContainer.removeStyleClass("floatRight");w.removeContent(w.ButtonContainer);w.insertContent(w.ButtonContainer,p);if(!this.getAlwaysShowAddIcon()){if(p!==n){w.ButtonContainer.removeContent(w.add);w.addContent(w.add);}else{w.removeContent(w.add);w.ButtonContainer.addContent(w.add);}}}}};
Y.prototype._onGridResize=function(){var w;if(this._oPaginatorToolbar&&this._oConditionsGrid&&this._oConditionsGrid.getContent().length>0){var i=this._oConditionsGrid.getContent()[0];if(i.remove&&i.remove.$().position()){w=0;if(this._oPaginatorToolbar.getParent()&&this._oPaginatorToolbar.getParent().getExpandable&&this._oPaginatorToolbar.getParent().getExpandable()){w=48-4;}var j=i.remove.$().position().left-w+i.remove.$().width();this._oPaginatorToolbar.setWidth(j+"px");}}var l=this._oConditionsGrid.getDomRef();if(!l){return;}if(!Q(l).is(":visible")){return;}w=l.clientWidth;var n={};if(w<=this._iBreakPointTablet){n.name="Phone";}else if((w>this._iBreakPointTablet)&&(w<=this._iBreakPointDesktop)){n.name="Tablet";}else{n.name="Desktop";}if(n.name==="Phone"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}if(n.name==="Tablet"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}if(n.name==="Desktop"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}};
Y.prototype._findConfig=function(i,j){if(typeof i==="object"){i=i.getMetadata().getName();}var l;while(i&&!(l=this._getConfig(i,j))){i=this._getParentType(i);}return l;};
Y.prototype._getConfig=function(i,j){var l=this._mOpsForType[i];if(l){return l[j];}};
Y.prototype._getParentType=function(i){return this._mTypes[i];};
Y.prototype._getRelevantOperations=function(i){var j,l=i&&i.type&&this.getOperations(i.type);if(i&&i.operations){j=i.operations;}else if(Array.isArray(l)&&l.length>0){j=l;}else{j=this.getOperations("default");}return j;};
Y.prototype._addButtons=function(i,j){var l=this;var n=new H({layoutData:new k({span:this.getLayoutMode()==="Desktop"?"L2 M2 S2":this._oButtonGroupSpan["Span"+this._sConditionType]})}).addStyleClass("floatRight");i.addContent(n);i["ButtonContainer"]=n;var p=new m({type:M.Transparent,icon:I.getIconURI("decline"),tooltip:this._oRb.getText("CONDITIONPANEL_REMOVE"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){l._handleRemoveCondition(this.oTargetGrid,i);},layoutData:new k({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M2 S2"})});p.oTargetGrid=j;n.addContent(p);i["remove"]=p;var w=new m({type:M.Transparent,icon:I.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){l._handleAddCondition(this.oTargetGrid,i,true);},layoutData:new k({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M10 S10"})});w.oTargetGrid=j;w.addStyleClass("conditionAddBtnFloatRight");n.addContent(w);i["add"]=w;};
Y.prototype.getCurrentOparation=function(i){return i.operation;};
Y.prototype.setSuggestCallback=function(i){this._fSuggestCallback=i;};
Y.prototype._hasSecondValue=function(i){return i===X.BT;};
Y.prototype._getSecondValueNegativeIndex=function(){return 1;};
Y.prototype._createConditionsFields=function(){return[{"ID":"select","Label":"","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"CheckBox","Value":""},{"ID":"keyFieldLabel","Text":"Sort By","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"keyField","Label":"","SpanFilter":"L3 M5 S10","SpanSort":"L5 M5 S12","SpanGroup":"L4 M4 S12","Control":"ComboBox"},{"ID":"operationLabel","Text":"Sort Order","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"operation","Label":"","SpanFilter":"L2 M5 S10","SpanSort":D.system.phone?"L5 M5 S8":"L5 M5 S9","SpanGroup":"L2 M5 S10","Control":"ComboBox"},{"ID":"value1","Label":this._sFromLabelText,"SpanFilter":"L3 M10 S10","SpanSort":"L3 M10 S10","SpanGroup":"L3 M10 S10","Control":"TextField","Value":""},{"ID":"value2","Label":this._sToLabelText,"SpanFilter":"L2 M10 S10","SpanSort":"L2 M10 S10","SpanGroup":"L2 M10 S10","Control":"TextField","Value":""},{"ID":"showIfGrouped","Label":this._sShowIfGroupedLabelText,"SpanFilter":"L1 M10 S10","SpanSort":"L1 M10 S10","SpanGroup":"L3 M4 S9","Control":"CheckBox","Value":"false"}];};
Y.prototype._hasNoValues=function(i){return i===X.Empty||i===X.Initial||i===X.Ascending||i===X.Descending||i===X.Total||i===X.Average||i===X.Minimum||i===X.Maximum;};
Y.prototype._setLayoutVisible=function(i,j){var l;if(i.getLayoutData===undefined){return;}l=i.getLayoutData&&i.getLayoutData();if(l&&(l.getMetadata&&l.getMetadata().getName()==="sap.ui.layout.GridData")){l.setVisibleXL(j);l.setVisibleL(j);l.setVisibleM(j);l.setVisibleS(j);}else{i.setLayoutData(new k({visibleXL:j,visibleL:j,visibleM:j,visibleS:j}));}i.setVisible(j);};
Y.prototype._mTypes={"base":undefined,"string":"base","numeric":"base","date":"base","time":"base","boolean":"base","int":"numeric","float":"numeric","sap.ui.model.type.Boolean":"boolean","sap.ui.model.type.Date":"date","sap.ui.model.type.FileSize":"string","sap.ui.model.type.Float":"float","sap.ui.model.type.Integer":"int","sap.ui.model.type.String":"string","sap.ui.model.type.Time":"time","sap.ui.comp.odata.type.StringDate":"date","sap.ui.model.odata.type.Boolean":"boolean","sap.ui.model.odata.type.Byte":"int","sap.ui.model.odata.type.Date":"date","sap.ui.model.odata.type.DateTime":"datetime","sap.ui.model.odata.type.DateTimeOffset":"datetime","sap.ui.model.odata.type.Decimal":"float","sap.ui.model.odata.type.Double":"float","sap.ui.model.odata.type.Single":"float","sap.ui.model.odata.type.Guid":"string","sap.ui.model.odata.type.Int16":"int","sap.ui.model.odata.type.Int32":"int","sap.ui.model.odata.type.Int64":"int","sap.ui.model.odata.type.Raw":"string","sap.ui.model.odata.type.SByte":"int","sap.ui.model.odata.type.String":"string","sap.ui.model.odata.type.Time":"time","sap.ui.model.odata.type.TimeOfDay":"time","Edm.Boolean":"sap.ui.model.odata.type.Boolean","Edm.Byte":"sap.ui.model.odata.type.Byte","Edm.Date":"sap.ui.model.odata.type.Date","Edm.DateTime":"sap.ui.model.odata.type.DateTime","Edm.DateTimeOffset":"sap.ui.model.odata.type.DateTimeOffset","Edm.Decimal":"sap.ui.model.odata.type.Decimal","Edm.Double":"sap.ui.model.odata.type.Double","Edm.Single":"sap.ui.model.odata.type.Single","Edm.Guid":"sap.ui.model.odata.type.Guid","Edm.Int16":"sap.ui.model.odata.type.Int16","Edm.Int32":"sap.ui.model.odata.type.Int32","Edm.Int64":"sap.ui.model.odata.type.Int64","Edm.SByte":"sap.ui.model.odata.type.SByte","Edm.String":"sap.ui.model.odata.type.String","Edm.Time":"sap.ui.model.odata.type.Time","Edm.TimeOfDay":"sap.ui.model.odata.type.TimeOfDay"};Y.prototype._mOpsForType={"base":{ctrl:"input"},"string":{ctrl:"input"},"date":{ctrl:"DatePicker"},"datetime":{ctrl:"DateTimePicker"},"numeric":{ctrl:"input"},"time":{ctrl:"TimePicker"},"boolean":{ctrl:"select"}};return Y;});
sap.ui.predefine('sap/m/P13nDialog',['./Dialog','./library','sap/ui/core/EnabledPropagator','./DialogRenderer','sap/ui/core/library','sap/ui/Device','./Bar','./Button','./Title','sap/m/OverflowToolbarLayoutData','sap/ui/base/ManagedObjectObserver',"sap/ui/thirdparty/jquery","sap/base/Log","sap/base/util/isEmptyObject"],function(D,l,E,a,c,b,B,d,T,O,M,q,L,e){"use strict";var f=l.OverflowToolbarPriority;var g=l.ListType;var P=l.P13nPanelType;var h=l.ListMode;var j=c.MessageType;var k=l.ButtonType;var m=l.BackgroundDesign;var N;var n;var p={apiVersion:2,render:function(r,C){a.render.apply(this,arguments);var i=C._getVisiblePanelID();var s=C.getVisiblePanel();if(i&&s){r.openStart("div",i);r.openEnd();r.renderControl(s);r.close("div");}}};
var o=D.extend("sap.m.P13nDialog",{
metadata:{deprecated:true,library:"sap.m",properties:{initialVisiblePanelType:{type:"string",group:"Misc",defaultValue:null},showReset:{type:"boolean",group:"Appearance",defaultValue:false},showResetEnabled:{type:"boolean",group:"Appearance",defaultValue:false},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{panels:{type:"sap.m.P13nPanel",multiple:true,singularName:"panel",bindable:"bindable"}},events:{ok:{},cancel:{},reset:{}}},
renderer:p
});
E.apply(o.prototype,[true]);
o.prototype.init=function(i){this.addStyleClass("sapMP13nDialog");D.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._mValidationListener={};this._createDialog();this._bTabBarUsed=true;this._mVisibleNavigationItems={};this._bNavigationControlsPromiseResolved=false;this._oNavigationControlsPromise=this._requestRequiredNavigationControls();this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{properties:["showReset","showResetEnabled"],aggregations:["panels"]});};
o.prototype.setShowResetEnabled=function(i){return this.setProperty("showResetEnabled",i,true);};
o.prototype._createDialog=function(){if(b.system.phone){var t=this;this.setStretch(true);this.setVerticalScrolling(false);this.setHorizontalScrolling(false);this.setCustomHeader(new B(this.getId()+"-phoneHeader",{contentLeft:new d(this.getId()+"-backToList",{visible:false,type:k.Back,press:function(){t._backToList();}}),contentMiddle:new T(this.getId()+"-phoneTitle",{text:this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"),level:"H2"})}));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}else{this.setHorizontalScrolling(false);this.setContentWidth("65rem");this.setContentHeight("40rem");this.setDraggable(true);this.setResizable(true);this.setTitle(this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}};
o.prototype._showValidationDialog=function(C,F,v){var w=[];var i=[];this._prepareMessages(F,v,w,i);var t=this;return new Promise(function(r){sap.ui.require(["sap/m/MessageBox"],function(s){var u="";if(i.length){i.forEach(function(x,I,y){u=(y.length>1?"• ":"")+x.messageText+"\n"+u;});s.show(u,{icon:s.Icon.ERROR,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE_ERROR"),actions:[s.Action.CLOSE],styleClass:t.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}else if(w.length){w.forEach(function(x,I,y){u=(y.length>1?"• ":"")+x.messageText+"\n"+u;});u=u+sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE_QUESTION");s.show(u,{icon:s.Icon.WARNING,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE"),actions:[sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_FIX"),s.Action.IGNORE],onClose:function(A){if(A===s.Action.IGNORE){C();}},styleClass:t.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}r();});});};
o.prototype._prepareMessages=function(F,v,w,r){if(!F.length&&!v.length){return;}F.forEach(function(s){switch(s){case P.filter:v.push({messageType:j.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE")});break;case P.columns:v.push({messageType:j.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VISIBLE_ITEMS_THRESHOLD_MESSAGE")});break;default:L.error("Panel type '"+s+"' is not supported jet.");}});var u=v.filter(function(s,I,t){for(var i=++I;i<t.length;i++){if(s.messageText===t[i].messageText){return false;}}return true;});u.forEach(function(i){if(i.messageType===j.Warning){w.push(i);}else if(i.messageType===j.Error){r.push(i);}});};
o.prototype._mapPanelToNavigationItem=function(i){if(!i){return null;}return b.system.phone?new n(i.getId()+"-navItem",{type:g.Navigation,title:i.getTitle()}):new n(i.getId()+"-navItem",{text:i.getTitle()});};
o.prototype._switchPanel=function(i){var r=this._getPanelByNavigationItem(i);this.setVerticalScrolling(r.getVerticalScrolling());if(b.system.phone){var s=this._getNavigationControl();if(s){s.setVisible(false);r.beforeNavigationTo();r.setVisible(true);this.getCustomHeader().getContentMiddle()[0].setText(r.getTitle());this.getCustomHeader().getContentLeft()[0].setVisible(true);}}else{this.getPanels().forEach(function(t){if(t===r){t.beforeNavigationTo();t.setVisible(true);}else{t.setVisible(false);}},this);}this.invalidate();this.rerender();};
o.prototype._backToList=function(){var i=this._getNavigationControl();if(i){i.setVisible(true);var r=this.getVisiblePanel();r.setVisible(false);this._updateDialogTitle();this.getCustomHeader().getContentLeft()[0].setVisible(false);}};
o.prototype.getVisiblePanel=function(){var i=null;this.getPanels().some(function(r){if(r.getVisible()){i=r;return true;}});return i;};
o.prototype._getVisiblePanelID=function(){var i=this.getVisiblePanel();if(i){return this.getId()+"-panel_"+i.getId();}return null;};
o.prototype._getPanelByNavigationItem=function(r){for(var i=0,s=this.getPanels(),t=s.length;i<t;i++){if(this._getNavigationItemByPanel(s[i])===r){return s[i];}}return null;};
o.prototype._getNavigationItemByPanel=function(i){return i?i.data("sapMP13nDialogNavigationItem"):null;};
o.prototype.onAfterRendering=function(){D.prototype.onAfterRendering.apply(this,arguments);var C=q(this.getFocusDomRef()).find(".sapMDialogScrollCont");var i=this._getVisiblePanelID();if(i&&C){var $=q(document.getElementById(i));$.appendTo(q(C));}};
o.prototype._updateDialogTitle=function(){var i=this.getVisiblePanel();var t=this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");if(!this._isNavigationControlExpected()&&i){switch(i.getType()){case P.filter:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_FILTER");break;case P.sort:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_SORT");break;case P.group:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_GROUP");break;case P.columns:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_COLUMNS");break;case P.dimeasure:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_DIMEASURE");break;default:t=i.getTitleLarge()||this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");}}if(b.system.phone){this.getCustomHeader().getContentMiddle()[0].setText(t);}else{this.setTitle(t);}};
o.prototype._registerValidationListener=function(i,C){if(this.getPanels().indexOf(i)&&C&&this._mValidationListener[i.getType()]===undefined){this._mValidationListener[i.getType()]=C;}};
o.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v&&!e(this._mValidationListener)){var t=this;v(this._getPayloadOfPanels()).then(function(V){var r=t._distributeValidationResult(V);for(var s in t._mValidationListener){var C=t._mValidationListener[s];C(r[s]||[]);}});}};
o.prototype._distributeValidationResult=function(r){var i={};r.forEach(function(R){R.panelTypes.forEach(function(t){if(i[t]===undefined){i[t]=[];}i[t].push({columnKey:R.columnKey,messageType:R.messageType,messageText:R.messageText});});});return i;};
o.prototype._createOKButton=function(){var t=this;return new d(this.getId()+"-ok",{type:k.Emphasized,text:this._oResourceBundle.getText("P13NDIALOG_OK"),layoutData:new O({priority:f.NeverOverflow}),press:function(){t.setBusy(true);var i=t._getPayloadOfPanels();var F=function(){t.setBusy(false);t.fireOk({payload:i});};var r=[];var C=function(){t.getPanels().forEach(function(s){if(r.indexOf(s.getType())>-1){s.onAfterNavigationFrom();}});F();};t.getPanels().forEach(function(s){if(!s.onBeforeNavigationFrom()){r.push(s.getType());}});var v=[];var V=t.getValidationExecutor();if(V){V(i).then(function(v){if(r.length||v.length){t.setBusy(false);t._showValidationDialog(C,r,v);}else{F();}});}else{if(r.length||v.length){t.setBusy(false);t._showValidationDialog(C,r,v);}else{F();}}}});};
o.prototype._createCancelButton=function(){var t=this;return new d(this.getId()+"-cancel",{text:this._oResourceBundle.getText("P13NDIALOG_CANCEL"),layoutData:new O({priority:f.NeverOverflow}),press:function(){t.fireCancel();}});};
o.prototype._createResetButton=function(){var t=this;return new d(this.getId()+"-reset",{text:this._oResourceBundle.getText("P13NDIALOG_RESET"),layoutData:new O({priority:f.NeverOverflow}),visible:this.getShowReset(),enabled:this.getShowResetEnabled(),press:function(){sap.ui.getCore().byId(t.getId()+"-ok").focus();t.setShowResetEnabled(false);var i={};t.getPanels().forEach(function(r){i[r.getType()]=r.getResetPayload();});t.fireReset({payload:i});}});};
o.prototype._getPayloadOfPanels=function(){var i={};this.getPanels().forEach(function(r){i[r.getType()]=r.getOkPayload();});return i;};
o.prototype.exit=function(){D.prototype.exit.apply(this,arguments);this._oObserver.disconnect();this._oObserver=undefined;this._bTabBarUsed=false;this._mValidationListener={};this._mVisibleNavigationItems={};this._oNavigationControlsPromise=null;};
o.prototype._isInstanceOf=function(i,s){var C=sap.ui.require(s);return i&&typeof C==='function'&&(i instanceof C);};
function _(C){if(this._isInstanceOf(C.object,"sap/m/P13nDialog")){var i;switch(C.name){case"panels":var r=C.child?[C.child]:C.children;r.forEach(function(s){switch(C.mutation){case"insert":this._mVisibleNavigationItems[s.sId]=s.getVisible();s.setVisible(false);s.beforeNavigationTo();this._oObserver.observe(s,{properties:["title"]});s.setValidationExecutor(q.proxy(this._callValidationExecutor,this));s.setValidationListener(q.proxy(this._registerValidationListener,this));break;case"remove":delete this._mVisibleNavigationItems[s.sId];this._oObserver.unobserve(s);s.setValidationExecutor();s.setValidationListener();break;default:L.error("Mutation '"+C.mutation+"' is not supported jet.");}},this);if(this._bNavigationControlsPromiseResolved){this._updateDialog();}else{this._oNavigationControlsPromise.then(function(){this._updateDialog();}.bind(this));}break;case"showReset":i=this.getButtons();if(i.length>1){i[2].setVisible(C.current);}break;case"showResetEnabled":i=this.getButtons();if(i.length>1){i[2].setEnabled(C.current);i[2].invalidate();}break;default:L.error("The property or aggregation '"+C.name+"' has not been registered.");}}else if(this._isInstanceOf(C.object,"sap/m/P13nPanel")){if(C.name==="title"){var I=this._getNavigationItemByPanel(C.object);if(I){if(b.system.phone){I.setTitle(C.current);}else{I.setText(C.current);}}}}}
o.prototype._isNavigationControlExpected=function(){return this._getCountOfVisibleNavigationItems()>1;};
o.prototype._getCountOfVisibleNavigationItems=function(){var C=0;for(var i in this._mVisibleNavigationItems){C=this._mVisibleNavigationItems[i]?C+1:C;}return C;};
o.prototype._isNavigationControlExists=function(){return b.system.phone?this.getContent().length>0:(!!this.getSubHeader()&&this.getSubHeader().getContentLeft().length>0);};
o.prototype._getNavigationControl=function(){if(!this._isNavigationControlExists()){this._createNavigationControl();}return b.system.phone?this.getContent()[0]:this.getSubHeader().getContentLeft()[0];};
o.prototype._setVisibleOfNavigationControl=function(v){if(!this._isNavigationControlExists()){return;}return b.system.phone?this.getContent()[0].setVisible(v):this.getSubHeader().setVisible(v);};
o.prototype._createNavigationControl=function(){if(b.system.phone){this.addContent(new N(this.getId()+"-navigationItems",{mode:h.None,itemPress:function(i){this._switchPanel(i.getParameter("listItem"));}.bind(this)}));}else{this.setSubHeader(new B(this.getId()+"-navigationBar",{contentLeft:new N(this.getId()+"-navigationItems",{backgroundDesign:m.Transparent,expandable:false,select:function(i){this._switchPanel(i.getParameter("item"));}.bind(this)})}));}return this._getNavigationControl();};
o.prototype._updateDialog=function(){var i=this._getNavigationControl();i.destroyItems();var I=this._determineInitialVisiblePanel();this.getPanels().forEach(function(r){var s=this._mapPanelToNavigationItem(r);r.data("sapMP13nDialogNavigationItem",s);i.addItem(s);var v=b.system.phone?this._mVisibleNavigationItems[r.sId]&&this._getCountOfVisibleNavigationItems()===1:this._mVisibleNavigationItems[r.sId]&&I===r.sId;r.setVisible(v);if(v){this.setVerticalScrolling(r.getVerticalScrolling());}s.setVisible(this._mVisibleNavigationItems[r.sId]);if(v&&i.setSelectedItem){i.setSelectedItem(s);}}.bind(this));this._updateDialogTitle();this._setVisibleOfNavigationControl(this._isNavigationControlExpected());};
o.prototype._determineInitialVisiblePanel=function(){if(this.getInitialVisiblePanelType()){for(var i=0;i<this.getPanels().length;i++){if(this.getPanels()[i].getType()==this.getInitialVisiblePanelType()){return this.getPanels()[i].sId;}}}var I;this.getPanels().some(function(r){if(this._mVisibleNavigationItems[r.sId]){I=r.sId;return true;}}.bind(this));return I;};
o.prototype._requestRequiredNavigationControls=function(){var s=b.system.phone?"sap/m/List":"sap/m/IconTabBar";var i=b.system.phone?"sap/m/StandardListItem":"sap/m/IconTabFilter";N=sap.ui.require(s);n=sap.ui.require(i);if(N&&n){this._bNavigationControlsPromiseResolved=true;return Promise.resolve();}if(!this._oNavigationControlsPromise){this._oNavigationControlsPromise=new Promise(function(r){sap.ui.require([s,i],function(t,u){N=t;n=u;this._bNavigationControlsPromiseResolved=true;return r();}.bind(this));}.bind(this));}return this._oNavigationControlsPromise;};
return o;});
sap.ui.predefine('sap/m/P13nDimMeasureItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nDimMeasureItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string"},index:{type:"int",defaultValue:-1},visible:{type:"boolean"},role:{type:"string"}}}});
return P;});
sap.ui.predefine('sap/m/P13nDimMeasurePanel',['./library','./P13nPanel','./P13nDimMeasureItem','./SearchField','./Table','./Column','./ColumnListItem','./ScrollContainer','./Text','./Select','./ComboBox','./Button','./OverflowToolbar','./OverflowToolbarLayoutData','./OverflowToolbarButton','./ToolbarSpacer','sap/ui/core/library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/InvisibleText','sap/ui/core/IconPool',"sap/ui/thirdparty/jquery"],function(l,P,c,S,T,C,d,e,f,g,h,B,O,i,j,k,m,n,J,o,R,I,p,q,Q){"use strict";var r=l.OverflowToolbarPriority;var s=l.ButtonType;var t=l.ToolbarDesign;var L=l.ListType;var u=l.ListMode;var v=l.P13nPanelType;
var w=P.extend("sap.m.P13nDimMeasurePanel",{
metadata:{library:"sap.m",properties:{chartTypeKey:{type:"string",defaultValue:""}},aggregations:{dimMeasureItems:{type:"sap.m.P13nDimMeasureItem",multiple:true,singularName:"dimMeasureItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},availableChartTypes:{type:"sap.ui.core.Item",multiple:true,singularName:"availableChartType"}},events:{changeDimMeasureItems:{},changeChartType:{}}},
renderer:{apiVersion:2,render:function(a,b){a.openStart("div",b);a.class("sapMP13nColumnsPanel");a.openEnd();b.getAggregation("content").forEach(function(x){a.renderControl(x);});a.close("div");}}
});
w.prototype.init=function(){var a=this;this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bOnAfterRenderingFirstTimeExecuted=false;var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.oAvailableRoleTypes={Dimension:[{key:"category",text:b.getText('COLUMNSPANEL_CHARTROLE_CATEGORY')},{key:"category2",text:b.getText('COLUMNSPANEL_CHARTROLE_CATEGORY2')},{key:"series",text:b.getText('COLUMNSPANEL_CHARTROLE_SERIES')}],Measure:[{key:"axis1",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS1')},{key:"axis2",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS2')},{key:"axis3",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS3')},{key:"axis4",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS4')}]};var M=new J({availableChartTypes:[],selectedChartTypeKey:null,items:[],columnKeyOfMarkedItem:undefined,isMoveDownButtonEnabled:undefined,isMoveUpButtonEnabled:undefined,showOnlySelectedItems:undefined,countOfSelectedItems:0,countOfItems:0});M.setDefaultBindingMode(o.TwoWay);M.setSizeLimit(1000);this.setModel(M,"$sapmP13nDimMeasurePanel");this.setType(v.dimeasure);this.setTitle(b.getText("CHARTPANEL_TITLE"));this._createTable();this._createToolbar();this.setVerticalScrolling(false);var x=new e({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",x);this._fnHandleResize=function(){var y=false,z,A;if(a.getParent){var $=null,D,H;var E=a.getParent();var F=a._getToolbar();if(E&&E.$){$=E.$("cont");if($.children().length>0&&F.$().length>0){z=x.$()[0].clientHeight;D=$.children()[0].clientHeight;H=F?F.$()[0].clientHeight:0;A=D-H;if(z!==A){x.setHeight(A+'px');y=true;}}}}return y;};this._sContainerResizeListener=R.register(x,this._fnHandleResize);};
w.prototype.onBeforeRendering=function(){this._updateInternalModel();if(!this._getInternalModel().getProperty("/columnKeyOfMarkedItem")){this._setColumnKeyOfMarkedItem(this._getColumnKeyByTableItem(this._getVisibleTableItems()[0]));}this._switchMarkedTableItemTo(this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem")));this._updateControlLogic();};
w.prototype.onAfterRendering=function(){var a=this;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);this._iLiveChangeTimer=window.setTimeout(function(){a._fnHandleResize();a._getToolbar()._resetAndInvalidateToolbar();},0);}};
w.prototype.getOkPayload=function(){this._updateInternalModel();this._getInternalModel().getProperty("/items").forEach(function(M){if(this._getDimMeasureItemByColumnKey(M.columnKey)){return;}if(!M.persistentSelected){return;}this.addAggregation("dimMeasureItems",new c({columnKey:M.columnKey,visible:M.persistentSelected,index:M.persistentIndex===-1?undefined:M.persistentIndex,role:M.role}));},this);return{dimMeasureItems:this.getDimMeasureItems(),chartTypeKey:this.getChartTypeKey()};};
w.prototype.exit=function(){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}if(this.oInvisibleChartTypeText){this.oInvisibleChartTypeText.destroy();this.oInvisibleChartTypeText=null;}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
w.prototype.addItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",a);return this;};
w.prototype.insertItem=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",a,b);return this;};
w.prototype.removeItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}a=this.removeAggregation("items",a);return a;};
w.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};
w.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};
w.prototype.addDimMeasureItem=function(D){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("dimMeasureItems",D);return this;};
w.prototype.insertDimMeasureItem=function(D,a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("dimMeasureItems",D,a);return this;};
w.prototype.updateDimMeasureItems=function(a){this.updateAggregation("dimMeasureItems");if(a===n.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};
w.prototype.removeDimMeasureItem=function(D){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("dimMeasureItems",D);};
w.prototype.removeAllDimMeasureItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("dimMeasureItems");};
w.prototype.destroyDimMeasureItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("dimMeasureItems");return this;};
w.prototype.setChartTypeKey=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.setProperty("chartTypeKey",a);return this;};
w.prototype.addAvailableChartType=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("availableChartTypes",a);return this;};
w.prototype.insertAvailableChartType=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("availableChartTypes",a,b);return this;};
w.prototype.removeAvailableChartType=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("availableChartTypes",a);};
w.prototype.removeAllAvailableChartType=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("availableChartTypes");};
w.prototype.destroyAvailableChartType=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("availableChartTypes");return this;};
w.prototype._notifyChange=function(){var a=this.getChangeNotifier();if(a){a(this);}};
w.prototype._scrollToSelectedItem=function(a){if(!a){return;}sap.ui.getCore().applyChanges();if(a.getDomRef()){a.focus();}};
w.prototype._getInternalModel=function(){return this.getModel("$sapmP13nDimMeasurePanel");};
w.prototype._createTable=function(){var a=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oTable=new T({mode:u.MultiSelect,rememberSelections:false,itemPress:Q.proxy(this._onItemPressed,this),selectionChange:Q.proxy(this._onSelectionChange,this),columns:[new C({vAlign:m.VerticalAlign.Middle,header:new f({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(b,x){return a.getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[b,x]);}}})}),new C({vAlign:m.VerticalAlign.Middle,header:new f({text:a.getText('COLUMNSPANEL_COLUMN_TYPE')})}),new C({vAlign:m.VerticalAlign.Middle,header:new f({text:a.getText('COLUMNSPANEL_COLUMN_ROLE')})})],items:{path:"/items",templateShareable:false,template:new d({cells:[new f({text:"{text}"}),new f({text:{path:'',formatter:function(M){if(M.aggregationRole==="Dimension"){return a.getText('COLUMNSPANEL_TYPE_DIMENSION');}if(M.aggregationRole==="Measure"){return a.getText('COLUMNSPANEL_TYPE_MEASURE');}}}}),new g({selectedKey:"{role}",items:{path:'availableRoleTypes',factory:function(b,x){var A=x.getObject();return new I({key:A.key,text:A.text});}},change:Q.proxy(this._onRoleChange,this)})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:L.Active})}});this._oTable.setModel(this._getInternalModel());};
w.prototype._createToolbar=function(){var a=this;var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");var x=new p({text:b.getText('COLUMNSPANEL_CHARTTYPE')});this.oInvisibleChartTypeText=x;var y=new h({placeholder:x.getText(),selectedKey:{path:'/selectedChartTypeKey'},ariaLabelledBy:x,items:{path:'/availableChartTypes',templateShareable:false,template:new I({key:"{key}",text:"{text}"})},selectionChange:Q.proxy(this._onChartTypeChange,this),layoutData:new i({moveToOverflow:false,stayInOverflow:false})});var z=new O(this.getId()+"-toolbar",{design:t.Auto,content:[x,y,new k(),new S(this.getId()+"-searchField",{liveChange:function(E){var V=E.getSource().getValue(),D=(V?300:0);window.clearTimeout(a._iSearchTimer);if(D){a._iSearchTimer=window.setTimeout(function(){a._onExecuteSearch();},D);}else{a._onExecuteSearch();}},search:Q.proxy(this._onExecuteSearch,this),layoutData:new i({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})}),new B({text:{path:'/showOnlySelectedItems',formatter:function(A){return A?b.getText('COLUMNSPANEL_SHOW_ALL'):b.getText('COLUMNSPANEL_SHOW_SELECTED');}},tooltip:{path:'/showOnlySelectedItems',formatter:function(A){return A?b.getText('COLUMNSPANEL_SHOW_ALL'):b.getText('COLUMNSPANEL_SHOW_SELECTED');}},type:s.Transparent,press:Q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new i({moveToOverflow:true,priority:r.High})}),new j({icon:q.getIconURI("collapse-group"),text:b.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:b.getText('COLUMNSPANEL_MOVE_TO_TOP'),type:s.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:Q.proxy(this.onPressButtonMoveToTop,this),layoutData:new i({moveToOverflow:true,priority:r.Low,group:2})}),new j({icon:q.getIconURI("navigation-up-arrow"),text:b.getText('COLUMNSPANEL_MOVE_UP'),tooltip:b.getText('COLUMNSPANEL_MOVE_UP'),type:s.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:Q.proxy(this.onPressButtonMoveUp,this),layoutData:new i({moveToOverflow:true,priority:r.High,group:1})}),new j({icon:q.getIconURI("navigation-down-arrow"),text:b.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:b.getText('COLUMNSPANEL_MOVE_DOWN'),type:s.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:Q.proxy(this.onPressButtonMoveDown,this),layoutData:new i({moveToOverflow:true,priority:r.High,group:1})}),new j({icon:q.getIconURI("expand-group"),text:b.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:b.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),type:s.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:Q.proxy(this.onPressButtonMoveToBottom,this),layoutData:new i({moveToOverflow:true,priority:r.Low,group:2})})]});z.setModel(this._getInternalModel());this.addAggregation("content",z);};
w.prototype.onPressButtonMoveToTop=function(){this._moveMarkedTableItem(this._getMarkedTableItem(),this._getVisibleTableItems()[0]);};
w.prototype.onPressButtonMoveUp=function(){var V=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),V[V.indexOf(this._getMarkedTableItem())-1]);};
w.prototype.onPressButtonMoveDown=function(){var V=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),V[V.indexOf(this._getMarkedTableItem())+1]);};
w.prototype.onPressButtonMoveToBottom=function(){var V=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),V[V.length-1]);};
w.prototype._onSwitchButtonShowSelected=function(){this._getInternalModel().setProperty("/showOnlySelectedItems",!this._getInternalModel().getProperty("/showOnlySelectedItems"));this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fnHandleResize();};
w.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};
w.prototype._switchVisibilityOfUnselectedModelItems=function(){var b=this._isFilteredByShowSelected();var M=this._getInternalModel().getProperty("/items");M.forEach(function(a){if(a.persistentSelected){a.visible=true;return;}a.visible=!b;});this._getInternalModel().setProperty("/items",M);};
w.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};
w.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};
w.prototype._moveMarkedTableItem=function(a,b){var M=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(a));var x=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(b));var y=this._getModelItemIndexByColumnKey(M.columnKey);var z=this._getModelItemIndexByColumnKey(x.columnKey);this._moveModelItems(y,z);this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fireChangeDimMeasureItems();this._notifyChange();};
w.prototype._moveModelItems=function(a,b){var M=this._getInternalModel().getProperty("/items");if(a<0||b<0||a>M.length-1||b>M.length-1){return false;}this._removeStyleOfMarkedTableItem();var x=M.splice(a,1);M.splice(b,0,x[0]);this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());return true;};
w.prototype._getModelItemByColumnKey=function(a){var M=this._getInternalModel().getProperty("/items").filter(function(b){return b.columnKey===a;});return M[0];};
w.prototype._updateCounts=function(M){var a=0;var b=0;M.forEach(function(x){a++;if(x.persistentSelected){b++;}});this._getInternalModel().setProperty("/countOfItems",a);this._getInternalModel().setProperty("/countOfSelectedItems",b);};
w.prototype._sortModelItemsByPersistentIndex=function(M){var x;var y=sap.ui.getCore().getConfiguration().getLocale().toString();try{if(typeof window.Intl!=='undefined'){x=window.Intl.Collator(y,{numeric:true});}}catch(E){}M.forEach(function(a,b){a.localIndex=b;});M.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex>-1&&a.persistentIndex<b.persistentIndex){return-1;}else if(b.persistentIndex>-1&&a.persistentIndex>b.persistentIndex){return 1;}else{return a.localIndex-b.localIndex;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){return x?x.compare(a.text,b.text):a.text.localeCompare(b.text,y,{numeric:true});}});M.forEach(function(a){delete a.localIndex;});};
w.prototype._getColumnKeyByTableItem=function(a){var b=this._oTable.indexOfItem(a);if(b<0){return null;}return this._oTable.getBinding("items").getContexts(undefined,undefined,undefined,true)[b].getObject().columnKey;};
w.prototype._getModelItemIndexByColumnKey=function(a){var b=-1;this._getInternalModel().getData().items.some(function(M,x){if(M.columnKey===a){b=x;return true;}});return b;};
w.prototype._getSelectedModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return M.persistentSelected;});};
w.prototype._getVisibleTableItems=function(){return this._oTable.getItems().filter(function(a){return a.getVisible();});};
w.prototype._getTableItemByColumnKey=function(a){var b=this._oTable.getBinding("items").getContexts();var x=this._oTable.getItems().filter(function(y,z){return b[z].getObject().columnKey===a;});return x[0];};
w.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
w.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
w.prototype._getSearchText=function(){var a=this._getSearchField();return a?a.getValue():"";};
w.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
w.prototype._isFilteredByShowSelected=function(){return this._getInternalModel().getData().showOnlySelectedItems;};
w.prototype._updateControlLogic=function(){var b=this._isFilteredBySearchText();var a=this._isFilteredByShowSelected();var V=this._getVisibleTableItems();this._getInternalModel().setProperty("/isMoveUpButtonEnabled",V.indexOf(this._getMarkedTableItem())>0);this._getInternalModel().setProperty("/isMoveDownButtonEnabled",V.indexOf(this._getMarkedTableItem())>-1&&V.indexOf(this._getMarkedTableItem())<V.length-1);var x=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(x){x.setEnabled(!b&&!a);}};
w.prototype._updateModelItemsPersistentIndex=function(M){var a=-1;M.forEach(function(b){b.persistentIndex=-1;if(b.persistentSelected){a++;b.persistentIndex=a;}});};
w.prototype._fireChangeDimMeasureItems=function(){this._bIgnoreUpdateInternalModel=true;this.fireChangeDimMeasureItems({items:this._getInternalModel().getProperty("/items").map(function(M){return{columnKey:M.columnKey,visible:M.persistentSelected,index:M.persistentIndex===-1?undefined:M.persistentIndex,role:M.role};})});this._bIgnoreUpdateInternalModel=false;};
w.prototype._fireChangeChartType=function(){this._bIgnoreUpdateInternalModel=true;this.fireChangeChartType({chartTypeKey:this._getInternalModel().getProperty("/selectedChartTypeKey")});this._bIgnoreUpdateInternalModel=false;};
w.prototype._getDimMeasureItemByColumnKey=function(a){var D=this.getDimMeasureItems().filter(function(b){return b.getColumnKey()===a;});return D[0];};
w.prototype._getMarkedTableItem=function(){return this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem"));};
w.prototype._setColumnKeyOfMarkedItem=function(a){this._getInternalModel().setProperty("/columnKeyOfMarkedItem",a);};
w.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));this._updateControlLogic();};
w.prototype._onChartTypeChange=function(E){this._fireChangeChartType();this._notifyChange();};
w.prototype._onRoleChange=function(E){this._fireChangeDimMeasureItems();this._notifyChange();};
w.prototype._onSelectionChange=function(E){if(!E.getParameter("selectAll")&&E.getParameter("listItems").length===1){this._switchMarkedTableItemTo(E.getParameter("listItem"));}this._selectTableItem();};
w.prototype._selectTableItem=function(){this._updateControlLogic();var M=this._getInternalModel().getProperty("/items");this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._fireChangeDimMeasureItems();this._notifyChange();};
w.prototype._switchMarkedTableItemTo=function(a){this._removeStyleOfMarkedTableItem();var b=this._getColumnKeyByTableItem(a);if(b){this._setColumnKeyOfMarkedItem(b);a.addStyleClass("sapMP13nColumnsPanelItemSelected");}};
w.prototype._removeStyleOfMarkedTableItem=function(){if(this._getMarkedTableItem()){this._getMarkedTableItem().removeStyleClass("sapMP13nColumnsPanelItemSelected");}};
w.prototype._filterModelItemsBySearchText=function(){var a=this._getSearchText();a=a.replace(/(^\s+)|(\s+$)/g,'');a=a.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var b=new RegExp(a,'igm');if(!b){return;}this._getVisibleModelItems().forEach(function(M){var x=this._getTableItemByColumnKey(M.columnKey);var y=x.getCells();M.visible=false;if(y[0]&&y[0].getText().match(b)){M.visible=true;}if(y[1]&&y[1].getText().match(b)){M.visible=true;}if(y[2]&&y[2].getSelectedItem()&&y[2].getSelectedItem().getText().match(b)){M.visible=true;}if(M.tooltip&&M.tooltip.match(b)){M.visible=true;}},this);this._getInternalModel().refresh();};
w.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._removeStyleOfMarkedTableItem();this._getInternalModel().setProperty("/items",this.getItems().map(function(a){return{columnKey:a.getColumnKey(),visible:true,text:a.getText(),tooltip:a.getTooltip(),aggregationRole:a.getAggregationRole(),availableRoleTypes:this.oAvailableRoleTypes[a.getAggregationRole()],role:a.getRole(),persistentIndex:-1,persistentSelected:undefined};},this));this._getInternalModel().setProperty("/selectedChartTypeKey",this.getChartTypeKey());this._getInternalModel().setProperty("/availableChartTypes",this.getAvailableChartTypes().map(function(a){return{key:a.getKey(),text:a.getText()};},this));this.getDimMeasureItems().forEach(function(D){var a=this._getModelItemByColumnKey(D.getColumnKey());if(!a){return;}if(D.getIndex()!==undefined){a.persistentIndex=D.getIndex();}if(D.getVisible()!==undefined){a.persistentSelected=D.getVisible();}if(D.getRole()!==undefined){a.role=D.getRole();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var M=this._getInternalModel().getProperty("/items");this._sortModelItemsByPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());};
return w;});
sap.ui.predefine('sap/m/P13nFilterItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nFilterItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},value1:{type:"string",group:"Misc",defaultValue:null},value2:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null},exclude:{type:"boolean",group:"Misc",defaultValue:false}}}});
P.prototype.setOperation=function(o){return this.setProperty("operation",o,true);};
P.prototype.setColumnKey=function(k){return this.setProperty("columnKey",k,true);};
P.prototype.setValue1=function(v){return this.setProperty("value1",v,true);};
P.prototype.setValue2=function(v){return this.setProperty("value2",v,true);};
P.prototype.setExclude=function(e){return this.setProperty("exclude",e,true);};
return P;});
sap.ui.predefine('sap/m/P13nFilterPanel',['./P13nConditionPanel','./P13nPanel','./library','sap/m/Panel','./P13nFilterItem','./P13nOperationsHelper','sap/m/P13nFilterPanelRenderer'],function(P,a,l,b,c,d,e){"use strict";var f=l.P13nPanelType;var g=l.P13nConditionOperation;
var h=a.extend("sap.m.P13nFilterPanel",{
metadata:{library:"sap.m",properties:{maxIncludes:{type:"string",group:"Misc",defaultValue:'-1'},maxExcludes:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null},enableEmptyOperations:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},filterItems:{type:"sap.m.P13nFilterItem",multiple:true,singularName:"filterItem",bindable:"bindable"},messageStrip:{type:"sap.m.MessageStrip",multiple:false}},events:{addFilterItem:{},removeFilterItem:{},updateFilterItem:{},filterItemChanged:{parameters:{reason:{type:"string"},key:{type:"string"},index:{type:"int"},itemData:{type:"object"}}}}},
renderer:e.renderer
});
h.prototype.setConditions=function(C){var I=[];var E=[];if(C.length){for(var i=0;i<C.length;i++){var o=C[i];if(!o.exclude){I.push(o);}else{E.push(o);}}}this._oIncludeFilterPanel.setConditions(I);this._oExcludeFilterPanel.setConditions(E);if(E.length>0){this._oExcludePanel.setExpanded(true);}return this;};
h.prototype.getConditions=function(){var i=this._oIncludeFilterPanel.getConditions();var E=this._oExcludeFilterPanel.getConditions();return i.concat(E);};
h.prototype.setContainerQuery=function(C){this.setProperty("containerQuery",C);this._oIncludeFilterPanel.setContainerQuery(C);this._oExcludeFilterPanel.setContainerQuery(C);return this;};
h.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oIncludeFilterPanel.setLayoutMode(m);this._oExcludeFilterPanel.setLayoutMode(m);return this;};
h.prototype.validateConditions=function(){return this._oIncludeFilterPanel.validateConditions()&&this._oExcludeFilterPanel.validateConditions();};
h.prototype.removeInvalidConditions=function(){this._oIncludeFilterPanel.removeInvalidConditions();this._oExcludeFilterPanel.removeInvalidConditions();};
h.prototype.removeValidationErrors=function(){this._oIncludeFilterPanel.removeValidationErrors();this._oExcludeFilterPanel.removeValidationErrors();};
h.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
h.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
h.prototype.setIncludeOperations=function(o,t){t=t||"default";this._aIncludeOperations[t]=o;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}};
h.prototype.getIncludeOperations=function(t){if(this._oIncludeFilterPanel){return this._oIncludeFilterPanel.getOperations(t);}};
h.prototype.setExcludeOperations=function(o,t){t=t||"default";this._aExcludeOperations[t]=o;if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}};
h.prototype.getExcludeOperations=function(t){if(this._oExcludeFilterPanel){return this._oExcludeFilterPanel.getOperations(t);}};
h.prototype.setKeyFields=function(k,K){this._aKeyFields=k;if(this._oIncludeFilterPanel){k.some(function(o){if(o.isDefault){this._oIncludeFilterPanel.setAutoAddNewRow(true);}}.bind(this));this._oIncludeFilterPanel.setKeyFields(k);}if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setKeyFields((Array.isArray(K)&&K.length>0)?K:k);}};
h.prototype.getKeyFields=function(){return this._aKeyFields;};
h.prototype.setMaxIncludes=function(m){this.setProperty("maxIncludes",m);if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setMaxConditions(m);}this._updatePanel();return this;};
h.prototype.setMaxExcludes=function(m){this.setProperty("maxExcludes",m);if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setMaxConditions(m);}this._updatePanel();return this;};
h.prototype._updatePanel=function(){var m=this.getMaxIncludes()==="-1"?1000:parseInt(this.getMaxIncludes());var M=this.getMaxExcludes()==="-1"?1000:parseInt(this.getMaxExcludes());if(m>0){if(M<=0){this._oIncludePanel.setHeaderText(null);this._oIncludePanel.setExpandable(false);this._oIncludePanel.addStyleClass("panelTopMargin");this._oIncludePanel.addStyleClass("panelNoHeader");}}if(M===0){this._oExcludePanel.setHeaderText(null);this._oExcludePanel.setExpandable(false);this._oExcludePanel.addStyleClass("panelNoHeader");}};
h.prototype.init=function(){this.setType(f.filter);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FILTERPANEL_TITLE"));this._aKeyFields=[];this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._aIncludeOperations={};this._aExcludeOperations={};this._oIncludePanel=new b({expanded:true,expandable:true,headerText:this._oRb.getText("FILTERPANEL_INCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oIncludeFilterPanel=new P({maxConditions:this.getMaxIncludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oIncludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";this._oIncludePanel.addContent(this._oIncludeFilterPanel);this.addAggregation("content",this._oIncludePanel);this._oExcludePanel=new b({expanded:false,expandable:true,headerText:this._oRb.getText("FILTERPANEL_EXCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oExcludeFilterPanel=new P({exclude:true,maxConditions:this.getMaxExcludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oExcludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";if(!this._oOperationsHelper){this._oOperationsHelper=new d();}this._updateOperations();var t;for(t in this._aExcludeOperations){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}for(t in this._aIncludeOperations){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}this._oExcludePanel.addContent(this._oExcludeFilterPanel);this.addAggregation("content",this._oExcludePanel);this._updatePanel();};
h.prototype.exit=function(){var i=function(o){if(o&&o.destroy){o.destroy();}return null;};this._oOperationsHelper=i(this._oOperationsHelper);this._aKeyFields=i(this._aKeyFields);this._aIncludeOperations=i(this._aIncludeOperations);this._aExcludeOperations=i(this._aExcludeOperations);this._oRb=i(this._oRb);};
h.prototype.onBeforeRendering=function(){var k=[],K,m,E=this.getEnableEmptyOperations();if(this._bUpdateRequired){this._bUpdateRequired=false;var M=this.getMessageStrip();if(M){M.addStyleClass("sapUiResponsiveMargin");this.insertAggregation("content",M,0);}K=[];m=(this.getBindingInfo("items")||{}).model;var G=function(n,o,i){var B=i.getBinding(n),j=i.getMetadata(),p=j.hasProperty(n)?j.getProperty(n).get(i):j.getAggregation(n).get(i),v;if(B&&o){v=o.getObject()[B.getPath()];if(n==="text"){return v||v===""?v:p;}else{return v;}}return p;};this.getItems().forEach(function(i){var o=i.getBindingContext(m),F,n,j;if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}K.push(F={key:i.getColumnKey(),text:G("text",o,i),tooltip:G("tooltip",o,i),maxLength:G("maxLength",o,i),type:G("type",o,i),typeInstance:G("typeInstance",o,i),formatSettings:G("formatSettings",o,i),precision:G("precision",o,i),scale:G("scale",o,i),isDefault:G("isDefault",o,i),values:G("values",o,i)});if(E){n=i.getNullable();j={};Object.keys(F).forEach(function(s){j[s]=F[s];});k.push(j);this._enhanceFieldOperationsWithEmpty(j,n,true);this._enhanceFieldOperationsWithEmpty(F,n);this._modifyFieldOperationsBasedOnMaxLength(j);}this._modifyFieldOperationsBasedOnMaxLength(F);},this);this.setKeyFields(K,k);var C=[];m=(this.getBindingInfo("filterItems")||{}).model;this.getFilterItems().forEach(function(F){var o=F.getBindingContext(m);if(F.getBinding("key")&&o){o.getObject()[F.getBinding("key").getPath()]=F.getKey();}C.push({key:F.getKey(),keyField:G("columnKey",o,F),operation:G("operation",o,F),value1:G("value1",o,F),value2:G("value2",o,F),exclude:G("exclude",o,F)});});this.setConditions(C);}};
h.prototype._updateOperations=function(){this._oOperationsHelper.getIncludeTypes().forEach(function(t){this.setIncludeOperations(this._oOperationsHelper.getIncludeOperationsByType(t),t);}.bind(this));this._oOperationsHelper.getExcludeTypes().forEach(function(t){this.setExcludeOperations(this._oOperationsHelper.getExcludeOperationsByType(t),t);}.bind(this));};
h.prototype._enableEnhancedExcludeOperations=function(){if(this._oOperationsHelper){this._oOperationsHelper.setUseExcludeOperationsExtended();}this._updateOperations();};
h.prototype._modifyFieldOperationsBasedOnMaxLength=function(F){var o;if(F.maxLength===1||F.maxLength==="1"){o=F.operations?F.operations:this._oIncludeFilterPanel.getOperations(F.type);F.operations=[];o.forEach(function(O){if([g.Contains,g.StartsWith,g.EndsWith].indexOf(O)===-1){F.operations.push(O);}},this);}};
h.prototype._enhanceFieldOperationsWithEmpty=function(F,n,E){var o,O;if(["string","stringdate"].indexOf(F.type)>-1||(["date","datetime"].indexOf(F.type)>-1&&n)){o=this[E?"_oExcludeFilterPanel":"_oIncludeFilterPanel"];O=o.getOperations(F.type);if(!O){O=o.getOperations();}if(!Array.isArray(F.operations)){F.operations=[];}O.forEach(function(s){F.operations.push(s);});if(F.operations.indexOf(g.Empty)===-1){F.operations.push(g.Empty);}}};
h.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
h.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);this._bUpdateRequired=true;return r;};
h.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
h.prototype.addFilterItem=function(F){this.addAggregation("filterItems",F,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
h.prototype.insertFilterItem=function(F,i){this.insertAggregation("filterItems",F,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
h.prototype.updateFilterItems=function(r){this.updateAggregation("filterItems");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate();}};
h.prototype.setMessageStrip=function(m){this.setAggregation("messageStrip",m,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
h.prototype.updateMessageStrip=function(r){this.updateAggregation("messageStrip");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
h.prototype.removeFilterItem=function(F){F=this.removeAggregation("filterItems",F,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return F;};
h.prototype.removeAllFilterItems=function(){var F=this.removeAllAggregation("filterItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return F;};
h.prototype.destroyFilterItems=function(){this.destroyAggregation("filterItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
h.prototype._handleDataChange=function(){var t=this;return function(E){var n=E.getParameter("newData");var o=E.getParameter("operation");var k=E.getParameter("key");var C=E.getParameter("index");var F;var I=-1;var j=E.getSource()===t._oExcludeFilterPanel;t.getFilterItems().some(function(m,i){if((!m.getExclude()&&!j)||(m.getExclude()&&j)){C--;}I=i;return C<0;},this);switch(o){case"update":F=t.getFilterItems()[I];if(F){F.setExclude(n.exclude);F.setColumnKey(n.keyField);F.setOperation(n.operation);F.setValue1(n.value1);F.setValue2(n.value2);}t.fireUpdateFilterItem({key:k,index:I,filterItemData:F});t.fireFilterItemChanged({reason:"updated",key:k,index:I,itemData:{columnKey:n.keyField,operation:n.operation,exclude:n.exclude,value1:n.value1,value2:n.value2}});break;case"add":if(C>=0){I++;}F=new c({columnKey:n.keyField,exclude:n.exclude,operation:n.operation});F.setValue1(n.value1);F.setValue2(n.value2);t._bIgnoreBindCalls=true;t.fireAddFilterItem({key:k,index:I,filterItemData:F});t.fireFilterItemChanged({reason:"added",key:k,index:I,itemData:{columnKey:n.keyField,operation:n.operation,exclude:n.exclude,value1:n.value1,value2:n.value2}});t._bIgnoreBindCalls=false;break;case"remove":t._bIgnoreBindCalls=true;t.fireRemoveFilterItem({key:k,index:I});t.fireFilterItemChanged({reason:"removed",key:k,index:I});t._bIgnoreBindCalls=false;break;default:throw"Operation'"+o+"' is not supported yet";}t._notifyChange();};};
h.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return h;});
sap.ui.predefine('sap/m/P13nGroupItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nGroupItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null},showIfGrouped:{type:"boolean",group:"Misc",defaultValue:false}}}});
P.prototype.setColumnKey=function(v){return this.setProperty("columnKey",v,true);};
P.prototype.setOperation=function(v){return this.setProperty("operation",v,true);};
P.prototype.setShowIfGrouped=function(v){return this.setProperty("showIfGrouped",v,true);};
return P;});
sap.ui.predefine('sap/m/P13nGroupPanel',['./library','./P13nConditionPanel','./P13nPanel','./P13nGroupItem',"sap/ui/thirdparty/jquery"],function(l,P,a,c,q){"use strict";var d=l.P13nPanelType;var e=l.P13nConditionOperation;
var f=a.extend("sap.m.P13nGroupPanel",{
metadata:{deprecated:true,library:"sap.m",properties:{maxGroups:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},groupItems:{type:"sap.m.P13nGroupItem",multiple:true,singularName:"groupItem",bindable:"bindable"}},events:{addGroupItem:{parameters:{}},removeGroupItem:{},updateGroupItem:{}}},
renderer:{apiVersion:2,render:function(r,C){r.openStart("section",C);r.class("sapMGroupPanel");r.openEnd();r.openStart("div");r.class("sapMGroupPanelContent");r.class("sapMGroupPanelBG");r.openEnd();C.getAggregation("content").forEach(function(o){r.renderControl(o);});r.close("div");r.close("section");}}
});
f.prototype.setMaxGroups=function(m){this.setProperty("maxGroups",m);if(this._oGroupPanel){this._oGroupPanel.setMaxConditions(m);}return this;};
f.prototype._getConditions=function(){return this._oGroupPanel.getConditions();};
f.prototype.setContainerQuery=function(b){this.setProperty("containerQuery",b);this._oGroupPanel.setContainerQuery(b);return this;};
f.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oGroupPanel.setLayoutMode(m);return this;};
f.prototype.validateConditions=function(){return this._oGroupPanel.validateConditions();};
f.prototype.removeInvalidConditions=function(){this._oGroupPanel.removeInvalidConditions();};
f.prototype.removeValidationErrors=function(){this._oGroupPanel.removeValidationErrors();};
f.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
f.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
f.prototype.setOperations=function(o){this._aOperations=o;if(this._oGroupPanel){this._oGroupPanel.setOperations(this._aOperations);}};
f.prototype.init=function(){this.setType(d.group);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("GROUPPANEL_TITLE"));this._aKeyFields=[];if(!this._aOperations){this.setOperations([e.GroupAscending,e.GroupDescending]);}this._oGroupPanel=new P({maxConditions:this.getMaxGroups(),autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange(),validationExecutor:q.proxy(this._callValidationExecutor,this)});this._oGroupPanel.setOperations(this._aOperations);this._oGroupPanel._sAddRemoveIconTooltipKey="GROUP";this.addAggregation("content",this._oGroupPanel);};
f.prototype.exit=function(){var b=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=b(this._aKeyFields);this._aOperations=b(this._aOperations);};
f.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:i.getText(),tooltip:i.getTooltip()});});k.splice(0,0,{key:null,text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_SELECTION_NONE")});this._oGroupPanel.setKeyFields(k);var C=[];m=(this.getBindingInfo("groupItems")||{}).model;this.getGroupItems().forEach(function(g){var o=g.getBindingContext(m);if(g.getBinding("key")){o.getObject()[g.getBinding("key").getPath()]=g.getKey();}C.push({key:g.getKey(),keyField:g.getColumnKey(),operation:g.getOperation(),showIfGrouped:g.getShowIfGrouped()});});this._oGroupPanel.setConditions(C);}};
f.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return r;};
f.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.addGroupItem=function(g){this.addAggregation("groupItems",g,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.insertGroupItem=function(g,i){this.insertAggregation("groupItems",g,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.updateGroupItems=function(r){this.updateAggregation("groupItems");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate();}};
f.prototype.removeGroupItem=function(g){g=this.removeAggregation("groupItems",g,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return g;};
f.prototype.removeAllGroupItems=function(){var g=this.removeAllAggregation("groupItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return g;};
f.prototype.destroyGroupItems=function(){this.destroyAggregation("groupItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype._handleDataChange=function(){var t=this;return function(E){var n=E.getParameter("newData");var o=E.getParameter("operation");var k=E.getParameter("key");var i=E.getParameter("index");var g;if(o==="update"){g=t.getGroupItems()[i];if(g){g.setColumnKey(n.keyField);g.setOperation(n.operation);g.setShowIfGrouped(n.showIfGrouped);}t.fireUpdateGroupItem({key:k,index:i,groupItemData:g});t._notifyChange();}if(o==="add"){g=new c({key:k,columnKey:n.keyField,operation:n.operation,showIfGrouped:n.showIfGrouped});t._bIgnoreBindCalls=true;t.fireAddGroupItem({key:k,index:i,groupItemData:g});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveGroupItem({key:k,index:i});t._bIgnoreBindCalls=false;t._notifyChange();}};};
f.prototype.getOkPayload=function(){if(!this.getModel()){return null;}var s=[];this._oGroupPanel._oConditionsGrid.getContent().forEach(function(C){var o=C.keyField;s.push(o.getSelectedKey());});return{selectedColumnKeys:s};};
f.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v){v();}};
f.prototype._updateValidationResult=function(v){this._oGroupPanel._oConditionsGrid.getContent().forEach(function(C){var o=C.keyField;o.setValueStateText("");o.setValueState("None");var s=o.getSelectedKey();v.forEach(function(r){if(r.columnKey===s){o.setValueStateText(r.messageText);o.setValueState(r.messageType);}});});};
f.prototype.setValidationListener=function(L){this.setProperty("validationListener",L);if(L){L(this,q.proxy(this._updateValidationResult,this));}return this;};
f.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return f;});
sap.ui.predefine('sap/m/P13nItem',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var P=E.extend("sap.m.P13nItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:""},visible:{type:"boolean",group:"Misc",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:"text"},typeInstance:{type:"object",group:"Misc",defaultValue:null,since:"1.56"},precision:{type:"string",group:"Misc",defaultValue:null},formatSettings:{type:"object",group:"Misc",defaultValue:null,since:"1.52"},scale:{type:"string",group:"Misc",defaultValue:null},maxLength:{type:"string",group:"Misc",defaultValue:null},width:{type:"string",group:"Misc",defaultValue:null},isDefault:{type:"boolean",group:"Misc",defaultValue:false},values:{type:"string[]",group:"Misc",defaultValue:null},role:{type:"string",defaultValue:null},aggregationRole:{type:"string",defaultValue:null},href:{type:"string",defaultValue:null},target:{type:"string",defaultValue:null},press:{type:"object",defaultValue:null},description:{type:"string",defaultValue:null},nullable:{type:"boolean",group:"Misc",defaultValue:false}}}});
return P;});
sap.ui.predefine('sap/m/P13nOperationsHelper',["./library"],function(l){"use strict";var P=function(){this.init();};var O=l.P13nConditionOperation;P.prototype.oIncludeOperations={"default":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"string":[O.Contains,O.EQ,O.BT,O.StartsWith,O.EndsWith,O.LT,O.LE,O.GT,O.GE],"date":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"time":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"datetime":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"numeric":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"numc":[O.Contains,O.EQ,O.BT,O.EndsWith,O.LT,O.LE,O.GT,O.GE],"boolean":[O.EQ]};P.prototype.oExcludeOperationsDefault={"default":[O.EQ]};P.prototype.oExcludeOperationsExtended={"default":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"string":[O.Contains,O.EQ,O.BT,O.StartsWith,O.EndsWith,O.LT,O.LE,O.GT,O.GE],"date":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"time":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"datetime":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"numeric":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"numc":[O.Contains,O.EQ,O.BT,O.EndsWith,O.LT,O.LE,O.GT,O.GE],"boolean":[O.EQ]};
P.prototype.init=function(){this.oExcludeOperations=this.oExcludeOperationsDefault;};
P.prototype.setUseExcludeOperationsExtended=function(){this.oExcludeOperations=this.oExcludeOperationsExtended;};
P.prototype.getIncludeOperationsByType=function(t){if(!t){t="default";}return this.oIncludeOperations[t].map(function(o){return o;});};
P.prototype.getExcludeOperationsByType=function(t){if(!t){t="default";}return this.oExcludeOperations[t].map(function(o){return o;});};
P.prototype.getIncludeTypes=function(){return Object.keys(this.oIncludeOperations);};
P.prototype.getExcludeTypes=function(){return Object.keys(this.oExcludeOperations);};
return P;},true);
sap.ui.predefine('sap/m/P13nPanel',['./library','sap/ui/core/Control'],function(l,C){"use strict";
var P=C.extend("sap.m.P13nPanel",{
metadata:{"abstract":true,library:"sap.m",interfaces:["sap.m.p13n.IContent"],properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLarge:{type:"string",group:"Appearance",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:null},verticalScrolling:{type:"boolean",group:"Misc",defaultValue:true},validationExecutor:{type:"object",group:"Misc",defaultValue:null},validationListener:{type:"object",group:"Misc",defaultValue:null},changeNotifier:{type:"object",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.P13nItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{beforeNavigationTo:{}}},
renderer:{apiVersion:2,render:function(r,c){r.openStart("span",c);r.class("sapMP13nPanel");r.openEnd();r.close("span");}}
});
P.prototype.getOkPayload=function(){return{};};
P.prototype.getResetPayload=function(){return{};};
P.prototype.beforeNavigationTo=function(){this.fireBeforeNavigationTo();};
P.prototype.onBeforeNavigationFrom=function(){return true;};
P.prototype.onAfterNavigationFrom=function(){};
return P;});
sap.ui.predefine('sap/m/P13nSelectionItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nSelectionItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",defaultValue:undefined},selected:{type:"boolean",defaultValue:false}}}});
return P;});
sap.ui.predefine('sap/m/P13nSelectionPanel',['./library','./ColumnListItem','./P13nPanel','./SearchField','./Text','./Table','./Column','./ScrollContainer','./P13nSelectionItem','./VBox','./Link','./OverflowToolbar','./OverflowToolbarLayoutData','./ToolbarSpacer','sap/ui/core/library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/ResizeHandler',"sap/ui/thirdparty/jquery"],function(l,C,P,S,T,a,b,c,d,V,L,O,e,f,g,h,J,B,R,q){"use strict";var i=l.ToolbarDesign;var j=l.ListType;var k=l.ListMode;var m=l.P13nPanelType;
var n=P.extend("sap.m.P13nSelectionPanel",{
metadata:{library:"sap.m",aggregations:{selectionItems:{type:"sap.m.P13nSelectionItem",multiple:true,singularName:"selectionItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{changeSelectionItems:{parameters:{items:{type:"object[]"}}}}},
renderer:{apiVersion:2,render:function(r,o){r.openStart("div",o);r.class("sapMP13nColumnsPanel");r.openEnd();o.getAggregation("content").forEach(function(p){r.renderControl(p);});r.close("div");}}
});
n.prototype.init=function(){this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bOnAfterRenderingFirstTimeExecuted=false;var M=new J({items:[],countOfSelectedItems:0,countOfItems:0});M.setDefaultBindingMode(B.TwoWay);M.setSizeLimit(1000);this.setModel(M,"$sapmP13nSelectionPanel");this.setType(m.selection);this._createTable();this._createToolbar();this.setVerticalScrolling(false);var s=new c({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",s);var t=this;this._fnHandleResize=function(){var o=false,p,r;if(t.getParent){var $=null,u,H;var v=t.getParent();var w=t._getToolbar();if(v&&v.$){$=v.$("cont");if($.children().length>0&&w.$().length>0){p=s.$()[0].clientHeight;u=$.children()[0].clientHeight;H=w?w.$()[0].clientHeight:0;r=u-H;if(p!==r){s.setHeight(r+'px');o=true;}}}}return o;};this._sContainerResizeListener=R.register(s,this._fnHandleResize);};
n.prototype.onBeforeRendering=function(){this._updateInternalModel();};
n.prototype.onAfterRendering=function(){var t=this;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);this._iLiveChangeTimer=window.setTimeout(function(){t._fnHandleResize();},0);}};
n.prototype.getOkPayload=function(){this._updateInternalModel();var M=this._getInternalModel().getProperty("/items");return{selectionItems:M.map(function(o){return{columnKey:o.columnKey,selected:o.persistentSelected};})};};
n.prototype.exit=function(){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
n.prototype.addItem=function(I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",I);return this;};
n.prototype.insertItem=function(I,o){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",I,o);return this;};
n.prototype.removeItem=function(I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}I=this.removeAggregation("items",I);return I;};
n.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};
n.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};
n.prototype.addSelectionItem=function(s){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("selectionItems",s);return this;};
n.prototype.insertSelectionItem=function(s,I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("selectionItems",s,I);return this;};
n.prototype.updateSelectionItems=function(r){this.updateAggregation("selectionItems");if(r===h.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};
n.prototype.removeSelectionItem=function(s){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("selectionItems",s);};
n.prototype.removeAllSelectionItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("selectionItems");};
n.prototype.destroySelectionItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("selectionItems");return this;};
n.prototype.onBeforeNavigationFrom=function(){return true;};
n.prototype._notifyChange=function(){var o=this.getChangeNotifier();if(o){o(this);}};
n.prototype._getInternalModel=function(){return this.getModel("$sapmP13nSelectionPanel");};
n.prototype._createTable=function(){var t=this;this._oTable=new a({mode:k.MultiSelect,rememberSelections:false,selectionChange:q.proxy(this._onSelectionChange,this),columns:[new b({vAlign:g.VerticalAlign.Middle,header:new T({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(o,p){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[o,p]);}}})})],items:{path:"/items",templateShareable:false,template:new C({cells:new V({items:[new L({href:"{href}",text:"{text}",target:"{target}",wrapping:true,enabled:{path:'href',formatter:function(v){if(!v){this.addStyleClass("sapUiCompSmartLink");}return!!v;}},press:function(E){var H=E.getSource().getHref();var I=t.getItems().filter(function(o){return o.getHref()===H&&!!o.getPress();});if(!I.length){return;}var p=I[0].getPress();p(E);}}),new T({wrapping:true,visible:{path:'description',formatter:function(D){return!!D;}},text:"{description}"})]}),visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:j.Active})}});this._oTable.setModel(this._getInternalModel());};
n.prototype._createToolbar=function(){var t=this;var o=new O(this.getId()+"-toolbar",{design:i.Auto,content:[new f(),new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(t._iSearchTimer);if(D){t._iSearchTimer=window.setTimeout(function(){t._onExecuteSearch();},D);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new e({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})})]});o.setModel(this._getInternalModel());this.addAggregation("content",o);};
n.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};
n.prototype._switchVisibilityOfUnselectedModelItems=function(){var s=this._isFilteredByShowSelected();var M=this._getInternalModel().getProperty("/items");M.forEach(function(o){if(o.persistentSelected){o.visible=true;return;}o.visible=!s;});this._getInternalModel().setProperty("/items",M);};
n.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};
n.prototype._getModelItemByColumnKey=function(s){var M=this._getInternalModel().getProperty("/items").filter(function(o){return o.columnKey===s;});return M[0];};
n.prototype._updateCounts=function(M){var o=0;var p=0;M.forEach(function(r){o++;if(r.persistentSelected){p++;}});this._getInternalModel().setProperty("/countOfItems",o);this._getInternalModel().setProperty("/countOfSelectedItems",p);};
n.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
n.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
n.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};
n.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
n.prototype._isFilteredByShowSelected=function(){return false;};
n.prototype._updateControlLogic=function(){var I=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!I&&!s);}};
n.prototype._fireChangeSelectionItems=function(){this._bIgnoreUpdateInternalModel=true;var M=this._getInternalModel().getProperty("/items");this.fireChangeSelectionItems({items:M.map(function(o){return{columnKey:o.columnKey,selected:o.persistentSelected};})});this._bIgnoreUpdateInternalModel=false;};
n.prototype._onSelectionChange=function(){this._selectTableItem();};
n.prototype._selectTableItem=function(){var M=this._getInternalModel().getProperty("/items");this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._fireChangeSelectionItems();this._notifyChange();};
n.prototype._filterModelItemsBySearchText=function(){var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');this._getVisibleModelItems().forEach(function(M){M.visible=false;if(M.text&&M.text.match(r)){M.visible=true;}if(M.tooltip&&M.tooltip.match(r)){M.visible=true;}});this._getInternalModel().refresh();};
n.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._getInternalModel().setProperty("/items",this.getItems().map(function(I){return{columnKey:I.getColumnKey(),visible:true,text:I.getText(),tooltip:I.getTooltip(),href:I.getHref(),target:I.getTarget(),persistentSelected:I.getVisible(),description:I.getDescription()};},this));this.getSelectionItems().forEach(function(s){var o=this._getModelItemByColumnKey(s.getColumnKey());if(!o){return;}if(s.getSelected()!==undefined){o.persistentSelected=s.getSelected();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var M=this._getInternalModel().getProperty("/items");this._updateCounts(M);this._getInternalModel().setProperty("/items",M);};
return n;});
sap.ui.predefine('sap/m/P13nSortItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nSortItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null}}}});
P.prototype.setColumnKey=function(v){return this.setProperty("columnKey",v,true);};
P.prototype.setOperation=function(v){return this.setProperty("operation",v,true);};
return P;});
sap.ui.predefine('sap/m/P13nSortPanel',['./library','./P13nConditionPanel','./P13nPanel','./P13nSortItem'],function(l,P,a,c){"use strict";var d=l.P13nPanelType;var e=l.P13nConditionOperation;
var f=a.extend("sap.m.P13nSortPanel",{
metadata:{deprecated:true,library:"sap.m",properties:{containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},sortItems:{type:"sap.m.P13nSortItem",multiple:true,singularName:"sortItem",bindable:"bindable"}},events:{addSortItem:{},removeSortItem:{},updateSortItem:{}}},
renderer:{apiVersion:2,render:function(r,C){r.openStart("section",C);r.class("sapMSortPanel");r.openEnd();r.openStart("div");r.class("sapMSortPanelContent");r.class("sapMSortPanelBG");r.openEnd();C.getAggregation("content").forEach(function(o){r.renderControl(o);});r.close("div");r.close("section");}}
});
f.prototype._getConditions=function(){return this._oSortPanel.getConditions();};
f.prototype.setContainerQuery=function(b){this.setProperty("containerQuery",b);this._oSortPanel.setContainerQuery(b);return this;};
f.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oSortPanel.setLayoutMode(m);return this;};
f.prototype.validateConditions=function(){return this._oSortPanel.validateConditions();};
f.prototype.removeInvalidConditions=function(){this._oSortPanel.removeInvalidConditions();};
f.prototype.removeValidationErrors=function(){this._oSortPanel.removeValidationErrors();};
f.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
f.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
f.prototype.setOperations=function(o){this._aOperations=o;if(this._oSortPanel){this._oSortPanel.setOperations(this._aOperations);}return this;};
f.prototype.init=function(){this.setType(d.sort);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("SORTPANEL_TITLE"));this._aKeyFields=[];if(!this._aOperations){this.setOperations([e.Ascending,e.Descending]);}this._oSortPanel=new P({autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oSortPanel.setOperations(this._aOperations);this._oSortPanel._sAddRemoveIconTooltipKey="SORT";this.addAggregation("content",this._oSortPanel);};
f.prototype.exit=function(){var b=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=b(this._aKeyFields);this._aOperations=b(this._aOperations);};
f.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:i.getText(),tooltip:i.getTooltip()});});k.splice(0,0,{key:null,text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_SELECTION_NONE")});this._oSortPanel.setKeyFields(k);var C=[];m=(this.getBindingInfo("sortItems")||{}).model;this.getSortItems().forEach(function(s){var o=s.getBindingContext(m);if(s.getBinding("key")){o.getObject()[s.getBinding("key").getPath()]=s.getKey();}C.push({key:s.getKey(),keyField:s.getColumnKey(),operation:s.getOperation()});});this._oSortPanel.setConditions(C);}};
f.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return r;};
f.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.addSortItem=function(s){this.addAggregation("sortItems",s,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.insertSortItem=function(s,i){this.insertAggregation("sortItems",s,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.updateSortItems=function(r){this.updateAggregation("sortItems");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate();}};
f.prototype.removeSortItem=function(s){s=this.removeAggregation("sortItems",s,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return s;};
f.prototype.removeAllSortItems=function(){var s=this.removeAllAggregation("sortItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return s;};
f.prototype.destroySortItems=function(){this.destroyAggregation("sortItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype._handleDataChange=function(){var t=this;return function(E){var n=E.getParameter("newData");var o=E.getParameter("operation");var k=E.getParameter("key");var i=E.getParameter("index");var s;if(o==="update"){s=t.getSortItems()[i];if(s){s.setColumnKey(n.keyField);s.setOperation(n.operation);}t.fireUpdateSortItem({key:k,index:i,sortItemData:s});t._notifyChange();}if(o==="add"){s=new c({key:k,columnKey:n.keyField,operation:n.operation});t._bIgnoreBindCalls=true;t.fireAddSortItem({key:k,index:i,sortItemData:s});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveSortItem({key:k,index:i});t._bIgnoreBindCalls=false;t._notifyChange();}};};
f.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return f;});
sap.ui.predefine('sap/m/QuickView',["./library","sap/ui/Device","sap/ui/core/IconPool","./QuickViewBase","./ResponsivePopover","./NavContainer","./Page","./Bar","./Button"],function(l,D,I,Q,R,N,P,B,a){"use strict";var b=l.PlacementType;
var c=Q.extend("sap.m.QuickView",{
metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Misc",defaultValue:b.Right},width:{type:'sap.ui.core.CSSSize',group:'Dimension',defaultValue:'320px'}},aggregations:{},designtime:"sap/m/designtime/QuickView.designtime",events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}}}},
renderer:{apiVersion:2,render:function(){}}
});
c.prototype.init=function(){var n={pages:[new P()],navigate:this._navigate.bind(this),afterNavigate:this._afterNavigate.bind(this)};this._oNavContainer=new N(n);var t=this;this._oPopover=new R(this.getId()+'-quickView',{placement:this.getPlacement(),content:[this._oNavContainer],contentWidth:this.getWidth(),showHeader:false,showCloseButton:false,afterOpen:function(e){t._afterOpen(e);t.fireAfterOpen({openBy:e.getParameter("openBy")});},afterClose:function(e){t.fireAfterClose({openBy:e.getParameter("openBy"),origin:t.getCloseButton()});},beforeOpen:function(e){t.fireBeforeOpen({openBy:e.getParameter("openBy")});},beforeClose:function(e){t.fireBeforeClose({openBy:e.getParameter("openBy"),origin:t.getCloseButton()});t._bRendered=false;}});this._oPopover.addStyleClass("sapMQuickView");var p=this._oPopover.getAggregation("_popup");p.addEventDelegate({onBeforeRendering:this._initializeQuickView,onAfterRendering:this._setLinkWidth,onkeydown:this._onPopupKeyDown},this);var t=this;var s=p._fnAdjustPositionAndArrow;if(s){p._fnAdjustPositionAndArrow=function(){s.apply(p,arguments);t._adjustContainerHeight();};}this._bItemsChanged=true;};
c.prototype._initializeQuickView=function(){this._bRendered=true;if(this._bItemsChanged){this._clearContainerHeight();this._initPages();var p=this._oNavContainer.getCurrentPage();if(p){var h=p.getCustomHeader();if(h&&h.getContentMiddle()[0]){this._oPopover.addAriaLabelledBy(h.getContentMiddle()[0].getId());}}var d=this.getAggregation("pages");if(!d&&D.system.phone){this._addEmptyPage();}this._bItemsChanged=false;}};
c.prototype.exit=function(){this._bRendered=false;this._bItemsChanged=true;if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};
c.prototype.invalidate=function(){};
c.prototype._createPage=function(q){return q._createPage();};
c.prototype._onPopupKeyDown=function(e){this._processKeyboard(e);};
c.prototype._afterOpen=function(e){if(D.system.phone){this._restoreFocus();}};
c.prototype._addEmptyPage=function(){var p=new P({customHeader:new B().addStyleClass("sapMQuickViewHeader")});var t=this;var C=p.getCustomHeader();C.addContentRight(new a({icon:I.getIconURI("decline"),press:function(){t._oPopover.close();}}));p.addStyleClass('sapMQuickViewPage');this._oNavContainer.addPage(p);};
c.prototype._clearContainerHeight=function(){var p=this._oPopover.getAggregation("_popup");var $=p.$().find('.sapMPopoverCont');if($[0]&&$[0].style.height){$[0].style.height='';}};
c.prototype._adjustContainerHeight=function(){if(this.getPages().length<=1){return;}var p=this._oPopover.getAggregation("_popup");var $=p.$().find('.sapMPopoverCont');if($[0]&&!$[0].style.height){$[0].style.height=$.height()+'px';}};
c.prototype._setLinkWidth=function(){this._oPopover.$().find(".sapMLnk").css("width","auto");};
c.prototype.getCloseButton=function(){if(!D.system.phone){return undefined;}var p=this._oNavContainer.getCurrentPage();var o=p.getCustomHeader().getContentRight()[0];return o;};
c.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._oPopover.setPlacement(p);return this;};
c.prototype.setWidth=function(w){if(this._oPopover){this._oPopover.setContentWidth(w);this.setProperty('width',w,true);}return this;};
c.prototype.openBy=function(C){this._bItemsChanged=true;this._oPopover.openBy(C);return this;};
c.prototype.close=function(){this._oPopover.close();return this;};
c.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};
["addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getFieldGroupIds","setFieldGroupIds","getBusy","setBusy","setTooltip","getTooltip"].forEach(function(n){c.prototype[n]=function(){if(this._oPopover&&this._oPopover[n]){var r=this._oPopover.getAggregation("_popup")[n].apply(this._oPopover.getAggregation("_popup"),arguments);return r===this._oPopover.getAggregation("_popup")?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(f){c.prototype[f]=function(){var n=Array.prototype.slice.call(arguments),r;if(["setModel","bindAggregation"].indexOf(f)===-1){n.push(true);}r=Q.prototype[f].apply(this,n);this._bItemsChanged=true;if(this._oPopover){if(arguments[0]!=="pages"){this._oPopover[f].apply(this._oPopover,arguments);}if(this._bRendered){this._initializeQuickView();}}if(["removeAggregation","removeAllAggregation"].indexOf(f)!==-1){return r;}return this;};});return c;});
sap.ui.predefine('sap/m/QuickViewBase',["./library","sap/ui/core/Control","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Focusable"],function(l,C,K,q){"use strict";
var Q=C.extend("sap.m.QuickViewBase",{
metadata:{library:"sap.m",properties:{},defaultAggregation:"pages",aggregations:{pages:{type:"sap.m.QuickViewPage",multiple:true,singularName:"page",bindable:"bindable"}},events:{navigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"},navOrigin:{type:"sap.ui.core.Control"}}},afterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"},isTopPage:{type:"boolean"},navOrigin:{type:"sap.ui.core.Control"}}}}},
renderer:{apiVersion:2,render:function(){}}
});
Q.prototype.navigateBack=function(){if(!this._oNavContainer.currentPageIsTopPage()){this._setNavOrigin(null);this._oNavContainer.back();}};
Q.prototype.getNavContainer=function(){return this._oNavContainer;};
Q.prototype._initPages=function(){var n=this._oNavContainer;n.destroyPages();n.init();var p=this.getAggregation("pages");if(!p){return;}var I=this.getId();for(var i=0;i<p.length;i++){var o=p[i];o._oPage=null;var N={hasBackButton:i>0,popover:this._oPopover,navContainer:n,quickViewId:I,quickView:this};o.setNavContext(N);var P=this._createPage(o);this._oNavContainer.addPage(P);}};
Q.prototype._processKeyboard=function(e){if(e.shiftKey&&e.which===K.ENTER){this.navigateBack();e.preventDefault();}};
Q.prototype._createPage=function(o){return o;};
Q.prototype._navigate=function(e){var t=e.getParameter('to');var f=e.getParameter('from');var T=e.getParameter('toId');var F=e.getParameter('fromId');var i=q(document.getElementById(F)).index();var a=q(document.getElementById(T)).index();if(a==-1||a>i){t.addStyleClass('sapMNavItemOffset');}else{f.addStyleClass('sapMNavItemOffset');}f.$().parents('.sapMPanelContent').scrollTop(0);var p=e.getParameters();if(this._navOrigin){p.navOrigin=this._navOrigin;}this.fireNavigate(p);};
Q.prototype._afterNavigate=function(e){var t=e.getParameter('to');var f=e.getParameter('from');var T=e.getParameter('toId');var F=e.getParameter('fromId');var i=q(document.getElementById(F)).index();var a=q(document.getElementById(T)).index();if(a>i){t.removeStyleClass('sapMNavItemOffset');}else{f.removeStyleClass('sapMNavItemOffset');}var p=e.getParameters();p.isTopPage=this._oNavContainer.currentPageIsTopPage();if(this._navOrigin){p.navOrigin=this._navOrigin;}this.fireAfterNavigate(p);this._setLinkWidth();setTimeout(this._restoreFocus.bind(this),0);};
Q.prototype._restoreFocus=function(){var p=this._oNavContainer.getCurrentPage();var f=this._oNavContainer._mFocusObject[p.getId()];if(!f){var c=p.getContent();if(c&&c.length>1){f=c[1].$().firstFocusableDomRef();}}if(f){f.focus();}};
Q.prototype._setLinkWidth=function(){};
Q.prototype._setNavOrigin=function(c){this._navOrigin=c;};
return Q;});
sap.ui.predefine('sap/m/QuickViewCard',["./library","./QuickViewBase","./NavContainer","./Page","./ScrollContainer","./QuickViewCardRenderer"],function(l,Q,N,P,S,a){"use strict";
var b=Q.extend("sap.m.QuickViewCard",{metadata:{library:"sap.m",properties:{showVerticalScrollBar:{type:"boolean",group:"Behavior",defaultValue:true}},designtime:"sap/m/designtime/QuickViewCard.designtime"}});
b.prototype.init=function(){var n={pages:[new P()],navigate:this._navigate.bind(this),afterNavigate:this._afterNavigate.bind(this)};this._oNavContainer=new N(n);};
b.prototype.onBeforeRendering=function(){this._initPages();};
b.prototype.onAfterRendering=function(){this._setLinkWidth();};
b.prototype.exit=function(){if(this._oNavContainer){this._oNavContainer.destroy();}};
b.prototype.onkeydown=function(e){this._processKeyboard(e);};
b.prototype._createPage=function(q){var c=q._createPageContent();q._mPageContent=null;var C=new S(this.getId()+'-'+q.getPageId(),{horizontal:false,vertical:false});if(c.header){C.addContent(c.header);}C.addContent(c.form);C.addStyleClass('sapMQuickViewPage');return C;};
b.prototype._setLinkWidth=function(){this.$().find(".sapMLnk").css("width","auto");};
return b;});
sap.ui.predefine('sap/m/QuickViewGroupElement',["./library","sap/ui/core/Element","./Link","./Text","sap/ui/core/CustomData"],function(l,E,L,T,C){"use strict";var G=l.QuickViewGroupElementType;
var a=E.extend("sap.m.QuickViewGroupElement",{metadata:{library:"sap.m",properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true},label:{type:"string",group:"Misc",defaultValue:""},value:{type:"string",group:"Misc",defaultValue:""},url:{type:"string",group:"Misc",defaultValue:""},target:{type:"string",group:"Misc",defaultValue:"_blank"},type:{type:"sap.m.QuickViewGroupElementType",group:"Misc",defaultValue:G.text},pageLinkId:{type:"string",group:"Misc",defaultValue:""},emailSubject:{type:"string",group:"Misc",defaultValue:""}}}});
a.prototype._getGroupElementValue=function(q){if(!this.getValue()){return null;}switch(this.getType()){case G.email:var h="mailto:"+this.getValue();var s=this.getEmailSubject();if(s){h+='?subject='+s;}return new L({href:h,text:this.getValue(),wrapping:true});case G.phone:case G.mobile:return new L({href:"tel:"+this.getValue(),text:this.getValue()});case G.link:return new L({href:this.getUrl(),text:this.getValue(),target:this.getTarget()});case G.pageLink:var b=this.getPageLinkId();if(q){b=q+'-'+b;}return new L({text:this.getValue(),customData:[new C({key:"pageNumber",value:b})]});default:return new T({text:this.getValue()});}};
a.prototype.setProperty=function(){E.prototype.setProperty.apply(this,arguments);var g=this.getParent();if(!g){return this;}var p=g.getParent();if(p){p._updatePage();}return this;};
a.prototype.getQuickViewBase=function(){var p=this.getParent();if(p&&p.getQuickViewBase){return p.getQuickViewBase();}return null;};
return a;});
sap.ui.predefine('sap/m/QuickViewPage',["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/layout/form/SimpleForm","sap/ui/layout/VerticalLayout","sap/ui/layout/HorizontalLayout","sap/m/Avatar","sap/m/Page","sap/m/Button","sap/m/Bar","sap/m/Title","sap/m/Link","sap/m/Text","sap/m/Label","sap/m/HBox","sap/ui/core/Icon","sap/ui/core/Title","sap/ui/core/CustomData","sap/ui/core/library","sap/ui/layout/library","sap/ui/Device","sap/ui/layout/form/ResponsiveGridLayout","./QuickViewPageRenderer","sap/base/Log","sap/base/security/encodeURL","sap/ui/dom/jquery/Focusable"],function(l,C,a,I,S,V,H,A,P,B,b,T,L,c,d,e,f,g,h,i,m,D,R,Q,n,o){"use strict";var U=l.URLHelper;var p=m.form.SimpleFormLayout;var q=i.TitleLevel;var r=l.QuickViewGroupElementType;var s=l.ButtonType;var t=l.AvatarShape;var u=C.getLibraryResourceBundle('sap.m');
var v=a.extend("sap.m.QuickViewPage",{
metadata:{library:"sap.m",properties:{pageId:{type:"string",group:"Misc",defaultValue:""},header:{type:"string",group:"Misc",defaultValue:""},title:{type:"string",group:"Misc",defaultValue:""},titleUrl:{type:"string",group:"Misc",defaultValue:""},crossAppNavCallback:{type:"object",group:"Misc"},description:{type:"string",group:"Misc",defaultValue:""},icon:{type:"string",group:"Misc",defaultValue:"",deprecated:true},fallbackIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null,deprecated:true}},defaultAggregation:"groups",aggregations:{groups:{type:"sap.m.QuickViewGroup",multiple:true,singularName:"group",bindable:"bindable"},avatar:{type:"sap.m.Avatar",multiple:false,bindable:"bindable"}}},
renderer:Q
});
v.prototype.init=function(){var G=sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getService;if(G){this.oCrossAppNavigator=G("CrossApplicationNavigation");}};
v.prototype.exit=function(){if(this._oPage){this._oPage.destroy();this._oPage=null;}else{this._destroyPageContent();}this._mNavContext=null;};
v.prototype.onBeforeRendering=function(){this._destroyPageContent();this._createPageContent();};
v.prototype.getPageContent=function(){return this._mPageContent;};
v.prototype.setNavContext=function(j){this._mNavContext=j;};
v.prototype.getNavContext=function(){return this._mNavContext;};
v.prototype.setPageTitleControl=function(j){this._oPageTitle=j;};
v.prototype.getPageTitleControl=function(){return this._oPageTitle;};
v.prototype._createPage=function(){var j=this._createPageContent();var N=this.getNavContext();var k;if(this._oPage){k=this._oPage;k.destroyContent();k.setCustomHeader(new b());}else{k=this._oPage=new P(N.quickViewId+'-'+this.getPageId(),{customHeader:new b()});k.addEventDelegate({onAfterRendering:this.onAfterRenderingPage},this);}if(this.getHeader()===""&&N.quickView.getPages().length===1&&!D.system.phone){k.setShowHeader(false);k.addStyleClass('sapMQuickViewPageWithoutHeader');}if(j.header){k.addContent(j.header);}k.addContent(j.form);var w=k.getCustomHeader();w.addContentMiddle(new T({text:this.getHeader()}).addStyleClass("sapMQuickViewTitle"));if(N.hasBackButton){w.addContentLeft(new B({type:s.Back,tooltip:u.getText("PAGE_NAVBUTTON_TEXT"),press:function(){if(N.navContainer){N.quickView._setNavOrigin(null);N.navContainer.back();}}}));}if(N.popover&&D.system.phone){w.addContentRight(new B({icon:I.getIconURI("decline"),press:function(){N.popover.close();}}));}k.addStyleClass('sapMQuickViewPage');return k;};
v.prototype.onAfterRenderingPage=function(){var j=this.getParent(),k=j instanceof a&&j.isA('sap.m.QuickView');if(k&&!this._oPage.$().firstFocusableDomRef()){this._oPage.$('cont').attr('tabindex',0);}if(this._bItemsChanged){var N=this.getNavContext();if(N){N.quickView._restoreFocus();}this._bItemsChanged=false;}};
v.prototype._createPageContent=function(){var F=this._createForm();var j=this._getPageHeaderContent();var k=this.getPageTitleControl();if(j&&k){F.addAriaLabelledBy(k);}this._mPageContent={form:F,header:j};return this._mPageContent;};
v.prototype._createForm=function(){var G=this.getAggregation("groups"),F=new S({maxContainerCols:1,editable:false,layout:p.ResponsiveGridLayout});if(G){for(var j=0;j<G.length;j++){if(G[j].getVisible()){this._renderGroup(G[j],F);}}}return F;};
v.prototype._getPageHeaderContent=function(){var j=this._getAvatar(),k=new V(),w=new H(),x=this.getIcon(),y=this.getTitle(),z=this.getDescription(),E=this.getTitleUrl();if(!j&&!x&&!y&&!z){return null;}if(j){w.addContent(j);}var F;if(E){F=new L({text:y,href:E,target:"_blank"});}else if(this.getCrossAppNavCallback()){F=new L({text:y});F.attachPress(this._crossApplicationNavigation.bind(this));}else{F=new T({text:y,level:q.H3});}this.setPageTitleControl(F);var G=new c({text:z});k.addContent(F);k.addContent(G);w.addContent(k);return w;};
v.prototype._renderGroup=function(G,F){var E=G.getAggregation("elements");var j,w,x;if(G.getHeading()){F.addContent(new g({text:G.getHeading(),level:q.H4}));}if(!E){return;}var N=this.getNavContext();for(var k=0;k<E.length;k++){j=E[k];if(!j.getVisible()){continue;}x=new d({text:j.getLabel()});var y;if(N){y=N.quickViewId;}w=j._getGroupElementValue(y);F.addContent(x);if(!w){F.addContent(new c({text:""}));continue;}x.setLabelFor(w.getId());if(j.getType()==r.pageLink){w.attachPress(this._attachPressLink(this));}if(j.getType()==r.mobile&&!D.system.desktop){var z=new f({src:I.getIconURI("post"),tooltip:u.getText("QUICKVIEW_SEND_SMS"),decorative:false,customData:[new h({key:"phoneNumber",value:j.getValue()})],press:this._mobilePress});var J=new e({items:[w,z]});F.addContent(J);}else{F.addContent(w);}}};
v.prototype._crossApplicationNavigation=function(){if(this.getCrossAppNavCallback()&&this.oCrossAppNavigator){var j=this.getCrossAppNavCallback();if(typeof j=="function"){var k=j();var w=this.oCrossAppNavigator.hrefForExternal({target:{semanticObject:k.target.semanticObject,action:k.target.action},params:k.params});U.redirect(w);}}else if(this.getTitleUrl()){U.redirect(this.getTitleUrl(),true);}};
v.prototype._destroyPageContent=function(){if(!this._mPageContent){return;}if(this._mPageContent.form){this._mPageContent.form.destroy();}if(this._mPageContent.header){this._mPageContent.header.destroy();}this._mPageContent=null;};
v.prototype._attachPressLink=function(j){var N=j.getNavContext();return function(E){E.preventDefault();var k=this.getCustomData()[0].getValue();if(N.navContainer&&k){N.quickView._setNavOrigin(this);N.navContainer.to(k);}};};
v.prototype._mobilePress=function(){var j="sms://"+o(this.getCustomData()[0].getValue());window.location.replace(j);};
v.prototype._updatePage=function(){var N=this.getNavContext();if(N&&N.quickView._bRendered){this._bItemsChanged=true;N.popover.focus();if(N.quickView.indexOfPage(this)==0){N.quickView._clearContainerHeight();}this._createPage();N.popover.$().css('display','block');N.quickView._adjustContainerHeight();N.quickView._restoreFocus();}};
["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){v.prototype[F]=function(){var j=a.prototype[F].apply(this,arguments);this._updatePage();if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return j;}return this;};});
v.prototype.setProperty=function(){a.prototype.setProperty.apply(this,arguments);this._updatePage();return this;};
v.prototype.getQuickViewBase=function(){var j=this.getParent();if(j&&j.isA("sap.m.QuickViewBase")){return j;}return null;};
v.prototype._getAvatar=function(){var j=null,k=this.getIcon();if(this.getAvatar()){j=this.getAvatar().clone(null,null,{cloneBindings:false,cloneChildren:true});this._checkAvatarProperties(j);}else if(k){j=new A({displayShape:t.Square,fallbackIcon:this.getFallbackIcon(),src:k});}if(j){if(this.getTitleUrl()&&!j.hasListeners("press")){j.attachPress(this._crossApplicationNavigation.bind(this));}j.addStyleClass("sapMQuickViewThumbnail");}return j;};
v.prototype._checkAvatarProperties=function(j){var k=j.getMetadata().getPropertyDefaults();if(j.getDisplaySize()!==k["displaySize"]){n.warning("'displaySize' property of avatar shouldn't be used in sap.m.QuickViewPage");}if(j.getCustomDisplaySize()!==k["customDisplaySize"]){n.warning("'customDisplaySize' property of avatar shouldn't be used in sap.m.QuickViewPage");}if(j.getCustomFontSize()!==k["customFontSize"]){n.warning("'customFontSize' property of avatar shouldn't be used in sap.m.QuickViewPage");}if(j.getDetailBox()){n.warning("'detailBox' aggregation of avatar shouldn't be used in sap.m.QuickViewPage");}};
return v;});
sap.ui.predefine('sap/m/p13n/AbstractContainer',["sap/ui/core/Control","sap/m/Page"],function(C,P){"use strict";
var A=C.extend("sap.m.p13n.AbstractContainer",{
metadata:{library:"sap.m",defaultAggregation:"views",properties:{defaultView:{type:"string"}},aggregations:{header:{type:"sap.m.IBar",multiple:false,forwarding:{idSuffix:"-AbstractContainer",aggregation:"customHeader",forwardBinding:true}},subHeader:{type:"sap.m.IBar",multiple:false,forwarding:{idSuffix:"-AbstractContainer",aggregation:"subHeader",forwardBinding:true}},footer:{type:"sap.m.IBar",multiple:false,forwarding:{idSuffix:"-AbstractContainer",aggregation:"footer",forwardBinding:true}},views:{type:"sap.m.p13n.AbstractContainerItem",multiple:true},_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{beforeViewSwitch:{allowPreventDefault:true,parameters:{source:{type:"string"},target:{type:"string"}}},afterViewSwitch:{allowPreventDefault:true,parameters:{source:{type:"string"},target:{type:"string"}}}}},
renderer:{apiVersion:2,render:function(r,c){r.openStart("div",c);r.style("height","100%");r.openEnd();r.renderControl(c.getAggregation("_content"));r.close("div");}}
});
A.prototype.init=function(){C.prototype.init.apply(this,arguments);this.addStyleClass("sapMAbstractContainer");this._initializeContent();};
A.prototype.applySettings=function(){C.prototype.applySettings.apply(this,arguments);this.switchView(this.getDefaultView());return this;};
A.prototype._initializeContent=function(){this.oLayout=new P(this.getId()+"-AbstractContainer");this.setAggregation("_content",this.oLayout);};
A.prototype.removeView=function(c,s){var o=typeof c=="string"?this.getView(c):c;o=this.removeAggregation("views",o,s);if(o&&o.getKey()===this.getCurrentViewKey()){this.switchView();}return this;};
A.prototype.addView=function(c){if(c&&c.getContent()&&!c.getContent().hasStyleClass("sapUiMAbstractContainerContent")){c.getContent().addStyleClass("sapUiMAbstractContainerContent");}this.addAggregation("views",c);return this;};
A.prototype.getCurrentViewKey=function(){return this._sCurrentView?this._sCurrentView:this.getDefaultView();};
A.prototype.getCurrentViewContent=function(){return this.getView(this.getCurrentViewKey()).getContent();};
A.prototype.switchView=function(k){var n=this.getView(k);if(!n){n=this.getViews()[0];if(!n){return;}}if(!this.fireBeforeViewSwitch({source:c,target:k})){this._bPrevented=true;return;}this._bPrevented=false;var c=this.getCurrentViewKey();this._sCurrentView=n.getKey();this.oLayout.removeAllContent();this.oLayout.addContent(n.getContent());this.fireAfterViewSwitch({source:c,target:k});};
A.prototype.getView=function(k){return this.getViews().find(function(v){if(v.getKey()===k){return v;}});};
A.prototype.getViewMap=function(){return this.getViews().map(function(o){return{key:o.getKey(),content:o.getContent()};});};
A.prototype.exit=function(){C.prototype.exit.apply(this,arguments);this._sCurrentView=null;this.oResourceBundle=null;};
return A;});
sap.ui.predefine('sap/m/p13n/BasePanel',['sap/ui/model/json/JSONModel','sap/m/VBox','sap/ui/core/Control','sap/m/Column','sap/m/Text','sap/ui/model/Filter',"sap/m/Table","sap/m/OverflowToolbar","sap/m/SearchField","sap/m/ToolbarSpacer","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarLayoutData","sap/base/util/merge","sap/ui/core/dnd/DragDropInfo"],function(J,V,C,a,T,F,b,O,S,c,d,e,m,D){"use strict";
var B=C.extend("sap.m.p13n.BasePanel",{
metadata:{library:"sap.m",interfaces:["sap.m.p13n.IContent"],associations:{},properties:{title:{type:"string"},enableReorder:{type:"boolean",defaultValue:true}},aggregations:{messageStrip:{type:"sap.m.MessageStrip",multiple:false},_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_template:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{change:{reason:{type:"string"},item:{type:"object"}}}},
renderer:{apiVersion:2,render:function(r,o){r.openStart("div",o);r.style("height","100%");r.openEnd();r.renderControl(o.getAggregation("_content"));r.close("div");}}
});
B.prototype.P13N_MODEL="$p13n";B.prototype.CHANGE_REASON_ADD="Add";B.prototype.CHANGE_REASON_REMOVE="Remove";B.prototype.CHANGE_REASON_MOVE="Move";B.prototype.CHANGE_REASON_SELECTALL="SelectAll";B.prototype.CHANGE_REASON_DESELECTALL="DeselectAll";B.prototype.PRESENCE_ATTRIBUTE="visible";
B.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oP13nModel=new J({});this._oP13nModel.setSizeLimit(10000);this.setModel(this._oP13nModel,this.P13N_MODEL);this._oListControl=this._createInnerListControl();this._bFocusOnRearrange=true;this._setInnerLayout();this._oListControl.setMultiSelectMode("ClearAll");};
B.prototype._setInnerLayout=function(){this.setAggregation("_content",new V({items:[this._oListControl]}));};
B.prototype.setP13nData=function(p){this._getP13nModel().setProperty("/items",m([],p));return this;};
B.prototype.getP13nData=function(o){var i=m([],this._getP13nModel().getProperty("/items"));if(o){i=i.filter(function(I){return I[this.PRESENCE_ATTRIBUTE];}.bind(this));}return i;};
B.prototype.setMessageStrip=function(s){if(!s){this.getAggregation("_content").removeItem(this._oMessageStrip);this._oMessageStrip=null;}else{s.addStyleClass("sapUiSmallMargin");if(this._oMessageStrip){this._oMessageStrip.destroy();}this._oMessageStrip=s;this.getAggregation("_content").insertItem(s,0);}return this;};
B.prototype.getMessageStrip=function(){return this._oMessageStrip;};
B.prototype.setEnableReorder=function(E){var t=this.getAggregation("_template");if(E){this._addHover(t);}else if(t&&t.aDelegates&&t.aDelegates.length>0){t.removeEventDelegate(t.aDelegates[0].oDelegate);}this._getDragDropConfig().setEnabled(E);this._setMoveButtonVisibility(E);this.setProperty("enableReorder",E);return this;};
B.prototype._getDragDropConfig=function(){if(!this._oDragDropInfo){this._oDragDropInfo=new D({enabled:false,sourceAggregation:"items",targetAggregation:"items",dropPosition:"Between",drop:[this._onRearrange,this]});}return this._oDragDropInfo;};
B.prototype._getMoveTopButton=function(){if(!this._oMoveTopBtn){this._oMoveTopBtn=new d(this.getId()+"-moveTopBtn",{type:"Transparent",tooltip:this._getResourceText("p13n.MOVE_TO_TOP"),icon:"sap-icon://collapse-group",press:[this._onPressButtonMoveToTop,this],visible:false});this.addDependent(this._oMoveTopBtn);}return this._oMoveTopBtn;};
B.prototype._getMoveUpButton=function(){if(!this._oMoveUpButton){this._oMoveUpButton=new d(this.getId()+"-moveUpBtn",{type:"Transparent",tooltip:this._getResourceText("p13n.MOVE_UP"),icon:"sap-icon://navigation-up-arrow",press:[this._onPressButtonMoveUp,this],visible:false});this.addDependent(this._oMoveUpButton);}return this._oMoveUpButton;};
B.prototype._getMoveDownButton=function(){if(!this._oMoveDownButton){this._oMoveDownButton=new d(this.getId()+"-moveDownpBtn",{type:"Transparent",tooltip:this._getResourceText("p13n.MOVE_DOWN"),icon:"sap-icon://navigation-down-arrow",press:[this._onPressButtonMoveDown,this],visible:false});this.addDependent(this._oMoveDownButton);}return this._oMoveDownButton;};
B.prototype._getMoveBottomButton=function(){if(!this._oMoveBottomButton){this._oMoveBottomButton=new d(this.getId()+"-moveBottomBtn",{type:"Transparent",tooltip:this._getResourceText("p13n.MOVE_TO_BOTTOM"),icon:"sap-icon://expand-group",press:[this._onPressButtonMoveToBottom,this],visible:false});this.addDependent(this._oMoveBottomButton);}return this._oMoveBottomButton;};
B.prototype._createInnerListControl=function(){return new b(this.getId()+"-innerP13nList",Object.assign(this._getListControlConfig(),{headerToolbar:new O({content:[this._getSearchField(),new c(),this._getMoveTopButton(),this._getMoveUpButton(),this._getMoveDownButton(),this._getMoveBottomButton()]})}));};
B.prototype._addHover=function(r){if(r&&r.aDelegates.length<1){r.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onfocusin:this._focusHandler.bind(this)});}};
B.prototype._focusHandler=function(E){if(!this.getEnableReorder()){return;}var h=sap.ui.getCore().byId(E.currentTarget.id);this._handleActivated(h);};
B.prototype._hoverHandler=function(E){if(this._oSelectedItem&&!this._oSelectedItem.bIsDestroyed){return;}if(!this.getEnableReorder()){return;}var h=sap.ui.getCore().byId(E.currentTarget.id);this._handleActivated(h);};
B.prototype._handleActivated=function(h){this._oHoveredItem=h;};
B.prototype._getListControlConfig=function(){return{mode:"MultiSelect",rememberSelections:true,itemPress:[this._onItemPressed,this],selectionChange:[this._onSelectionChange,this],sticky:["HeaderToolbar","ColumnHeaders","InfoToolbar"],dragDropConfig:this._getDragDropConfig()};};
B.prototype._getSearchField=function(){if(!this._oSearchField){this._oSearchField=new S(this.getId()+"-searchField",{liveChange:[this._onSearchFieldLiveChange,this],width:"100%",layoutData:new e({shrinkable:true,moveToOverflow:true,priority:"High",maxWidth:"16rem"})});}return this._oSearchField;};
B.prototype._setTemplate=function(t){t.setType("Active");this.setAggregation("_template",t);if(t){if(this.getEnableReorder()){this._addHover(t);}this._oSelectionBindingInfo=t.getBindingInfo("selected");if(this._oSelectionBindingInfo&&this._oSelectionBindingInfo.parts){this._oSelectionBindingInfo={parts:this._oSelectionBindingInfo.parts};}}this._bindListItems();return this;};
B.prototype._setPanelColumns=function(v){var f;if(v instanceof Array){f=v;}else{f=[v];}this._addTableColumns(f);};
B.prototype._getP13nModel=function(){return this.getModel(this.P13N_MODEL);};
B.prototype._getResourceText=function(t,v){this.oResourceBundle=this.oResourceBundle?this.oResourceBundle:sap.ui.getCore().getLibraryResourceBundle("sap.m");return t?this.oResourceBundle.getText(t,v):this.oResourceBundle;};
B.prototype._addTableColumns=function(f){var r=this._oListControl.removeAllColumns();r.forEach(function(R){R.destroy();});f.forEach(function(v){var o;if(typeof v=="string"){o=new a({header:new T({text:v})});}else{o=v;}this._oListControl.addColumn(o);},this);};
B.prototype._bindListItems=function(f){var t=this.getAggregation("_template");if(t){this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/items",key:"name",templateShareable:false,template:this.getAggregation("_template").clone()},f));}};
B.prototype._onSelectionChange=function(E){var l=E.getParameter("listItems");var s=E.getParameter("selectAll");var f=!s&&l.length>1;l.forEach(function(t){this._selectTableItem(t,s||f);},this);if(s||f){this.fireChange({reason:s?this.CHANGE_REASON_SELECTALL:this.CHANGE_REASON_DESELECTALL,item:undefined});}if(f){this._getMoveTopButton().setEnabled(false);this._getMoveUpButton().setEnabled(false);this._getMoveDownButton().setEnabled(false);this._getMoveBottomButton().setEnabled(false);}};
B.prototype._onItemPressed=function(E){var t=E.getParameter('listItem');this._oSelectedItem=t;var o=t.getBindingContext(this.P13N_MODEL);if(this.getEnableReorder()&&o&&o.getProperty(this.PRESENCE_ATTRIBUTE)){this._handleActivated(t);this._updateEnableOfMoveButtons(t,true);}};
B.prototype._onSearchFieldLiveChange=function(E){this._oListControl.getBinding("items").filter(new F("label","Contains",E.getSource().getValue()));};
B.prototype._onPressButtonMoveToTop=function(){this._moveSelectedItem(0);};
B.prototype._onPressButtonMoveUp=function(){this._moveSelectedItem("Up");};
B.prototype._onPressButtonMoveDown=function(){this._moveSelectedItem("Down");};
B.prototype._onPressButtonMoveToBottom=function(){var i=this._oListControl.getItems().length-1;this._moveSelectedItem(i);};
B.prototype._setMoveButtonVisibility=function(v){this._getMoveTopButton().setVisible(v);this._getMoveUpButton().setVisible(v);this._getMoveDownButton().setVisible(v);this._getMoveBottomButton().setVisible(v);};
B.prototype._filterBySelected=function(s,l){l.getBinding("items").filter(s?new F(this.PRESENCE_ATTRIBUTE,"EQ",true):[]);};
B.prototype._selectTableItem=function(t,s){this._updateEnableOfMoveButtons(t,s?false:true);this._oSelectedItem=t;if(!s){var i=this._getP13nModel().getProperty(this._oSelectedItem.getBindingContext(this.P13N_MODEL).sPath);this.fireChange({reason:i[this.PRESENCE_ATTRIBUTE]?this.CHANGE_REASON_ADD:this.CHANGE_REASON_REMOVE,item:i});}};
B.prototype._moveSelectedItem=function(n){var s=this._oSelectedItem;var i=this._oListControl.indexOfItem(s);if(i<0){return;}var N=(typeof n=="number")?n:i+(n=="Up"?-1:1);this._moveTableItem(s,N);};
B.prototype._getModelEntry=function(i){return i.getBindingContext(this.P13N_MODEL).getObject();};
B.prototype._moveTableItem=function(i,n){var I=this._oListControl.getItems();var f=this._getP13nModel().getProperty("/items");var o=f.indexOf(this._getModelEntry(i));n=(n<=0)?0:Math.min(n,I.length-1);n=f.indexOf(this._getModelEntry(I[n]));if(n==o){return;}f.splice(n,0,f.splice(o,1)[0]);this._getP13nModel().setProperty("/items",f);this._oSelectedItem=this._oListControl.getItems()[n];this._updateEnableOfMoveButtons(this._oSelectedItem,this._bFocusOnRearrange);this._handleActivated(this._oSelectedItem);this.fireChange({reason:this.CHANGE_REASON_MOVE,item:this._getModelEntry(i)});};
B.prototype._onRearrange=function(E){var o=E.getParameter("draggedControl");var f=E.getParameter("droppedControl");var s=E.getParameter("dropPosition");var i=this._oListControl.indexOfItem(o);var g=this._oListControl.indexOfItem(f);var A=g+(s=="Before"?0:1)+(i<g?-1:0);this._moveTableItem(o,A);};
B.prototype._updateEnableOfMoveButtons=function(t,f){var i=this._oListControl.getItems().indexOf(t);var u=true,g=true;if(i==0){u=false;}if(i==this._oListControl.getItems().length-1){g=false;}this._getMoveTopButton().setEnabled(u);this._getMoveUpButton().setEnabled(u);this._getMoveDownButton().setEnabled(g);this._getMoveBottomButton().setEnabled(g);if(f){t.focus();}};
B.prototype.exit=function(){C.prototype.exit.apply(this,arguments);this._bFocusOnRearrange=null;this._oHoveredItem=null;this._oSelectionBindingInfo=null;this._oSelectedItem=null;this._oListControl=null;this._oMoveTopBtn=null;this._oMoveUpButton=null;this._oMoveDownButton=null;this._oMoveBottomButton=null;this._oSearchField=null;};
return B;});
sap.ui.predefine('sap/m/p13n/Container',["sap/m/p13n/AbstractContainer","sap/m/Bar","sap/m/Button","sap/m/List","sap/m/IconTabBar","sap/m/IconTabFilter","sap/m/p13n/AbstractContainerItem","sap/ui/Device","sap/m/library","sap/m/StandardListItem","sap/m/CustomListItem","sap/ui/core/Control"],function(A,B,a,L,I,b,C,D,l,S,c,d){"use strict";var e=l.ButtonType;var f=l.ListType;
var g=A.extend("sap.m.p13n.Container",{
metadata:{library:"sap.m",properties:{listLayout:{type:"boolean",defaultValue:false}}},
renderer:{apiVersion:2}
});
g.prototype.DEFAULT_KEY="$default";
g.prototype.init=function(){A.prototype.init.apply(this,arguments);this.addStyleClass("sapMP13nContainer");this.setListLayout(D.system.phone);};
g.prototype.setListLayout=function(h){this.setProperty("listLayout",h);this._getTabBar().removeAllItems();this._getNavigationList().removeAllItems();var H;if(h){this._getTabBar().setVisible(false);this._getNavigationList();this.switchView(this.DEFAULT_KEY);H=this._getNavBackBtn();}else{this._getTabBar().setVisible(true);var v=this.getViews();if(v.length>1){this.switchView(v[1].getKey());}H=this._getTabBar();}var o=this.getHeader();if(!o){var i=new B({contentLeft:[H]});this.setHeader(i);}else{o.removeAllContentLeft();o.addContentLeft(H);}this.getViews().forEach(function(V){this._addToNavigator(V);}.bind(this));return this;};
g.prototype.switchView=function(k){A.prototype.switchView.apply(this,arguments);if(this._bPrevented){return;}var p=this.getParent();if(p&&p.isA("sap.ui.core.Control")){p.focus();p.invalidate();var h=p.getDependents();if(h){h.forEach(function(o){if(o&&o.isA("sap.ui.core.Control")){o.invalidate();}});}}this.oLayout.setShowHeader(k!==this.DEFAULT_KEY);this._getTabBar().setSelectedKey(k);this._getNavBackBtn().setVisible(k!==this.DEFAULT_KEY);this._getNavBackBtn().setText((this.getView(k)&&this.getView(k).getText())||k);};
g.prototype.addView=function(o){A.prototype.addView.apply(this,arguments);this._addToNavigator(o);return this;};
g.prototype.removeView=function(o){A.prototype.removeView.apply(this,arguments);this._removeFromNavigator(o);};
g.prototype.addSeparator=function(){if(!this.getProperty("listLayout")){return;}var i=this._getNavigationList().getItems();var o=i[i.length-1];o.addStyleClass("sapMMenuDivider");return this;};
g.prototype._getTabBar=function(){if(!this._oTabBar){this._oTabBar=new I({expandable:false,expanded:true,select:function(E){this.switchView(E.getParameter("key"));}.bind(this)});this.addDependent(this._oTabBar);}return this._oTabBar;};
g.prototype._getNavigationList=function(){if(!this._oNavigationList){this._oNavigationList=new L({itemPress:function(E){var i=E.getParameter("listItem");this.switchView(i._key);}.bind(this)}).addStyleClass("p13nContainerDefaultList");this.addDependent(this._oNavigationList);}if(!this.getView(this.DEFAULT_KEY)){var o=new C({key:this.DEFAULT_KEY,content:this._oNavigationList});this.addView(o);}return this._oNavigationList;};
g.prototype._getNavBackBtn=function(){if(!this._oNavBackBtn){this._oNavBackBtn=new a({type:e.Back,press:function(E){this.switchView(this.DEFAULT_KEY);}.bind(this)});this.addDependent(this._oNavBackBtn);}return this._oNavBackBtn;};
g.prototype._addToNavigator=function(o){var k=o.getKey(),t=o.getText(),i=o.getIcon();if(k==this.DEFAULT_KEY){return;}if(this.getListLayout()){this.getView(this.DEFAULT_KEY);var h=new S({type:f.Navigation,icon:i,title:t});h._key=k;this._getNavigationList().addItem(h);}else{this._getTabBar().addItem(new b({key:k,text:t||k}));}};
g.prototype._removeFromNavigator=function(o){var k=o.getKey();if(k==this.DEFAULT_KEY){return;}if(this.getListLayout()){var i=this._getNavigationList().getItems().find(function(h){return h._key===k;});this._getNavigationList().removeItem(i);}else{var t=this._getTabBar().getItems().find(function(t){return t.getKey()===k;});this._getTabBar().removeItem(t);}};
g.prototype.exit=function(){A.prototype.exit.apply(this,arguments);if(this._oTabBar){this._oTabBar.destroy();this._oTabBar=null;}if(this._oNavigationList){this._oNavigationList.destroy();this._oNavigationList=null;}this._oNavBackBtn=null;};
return g;});
sap.ui.predefine('sap/m/p13n/GroupPanel',["./QueryPanel","sap/m/HBox","sap/m/CheckBox","sap/ui/layout/Grid"],function(Q,H,C,G){"use strict";
var a=Q.extend("sap.m.p13n.GroupPanel",{
metadata:{properties:{enableShowField:{type:"boolean",defaultValue:false}}},
renderer:{apiVersion:2}
});
a.prototype.PRESENCE_ATTRIBUTE="grouped";a.prototype.CHANGE_REASON_SHOWIFGROUPED="showifgrouped";
a.prototype._createQueryRowGrid=function(i){var k=i.name;var s=this._createKeySelect(k);var g=new G({containerQuery:true,defaultSpan:this.getEnableShowField()?"XL4 L4 M4 S4":"XL6 L6 M6 S6",content:[s]}).addStyleClass("sapUiTinyMargin");if(this.getEnableShowField()){var c=this._createCheckBox(i);g.addContent(c);}return g;};
a.prototype._createCheckBox=function(i){var k=i.name;var c=new H({alignItems:"Center",items:[new C({enabled:k?true:false,selected:i.hasOwnProperty("showIfGrouped")?i.showIfGrouped:true,select:function(e){var p=e.getSource().getParent().getParent().getParent().getParent().getParent().getParent();var k=e.oSource.getParent().getParent().getContent()[0].getSelectedItem().getKey();this._changeShowIfGrouped(k,e.getParameter("selected"));p.fireChange({reason:"change",item:{name:k,grouped:true,showIfGrouped:e.getParameter("selected")}});}.bind(this),text:this._getResourceText("p13n.GROUP_CHECKBOX")})]});return c;};
a.prototype._changeShowIfGrouped=function(k,s){var i=this._getP13nModel().getProperty("/items").filter(function(I){return I.name===k;});i[0].showIfGrouped=s;this.fireChange({reason:this.CHANGE_REASON_SHOWIFGROUPED,item:i[0]});};
a.prototype._selectKey=function(e){Q.prototype._selectKey.apply(this,arguments);var l=e.getSource().getParent().getParent();var n=e.getParameter("selectedItem").getKey();l.getContent()[0].getContent()[1].getItems()[0].setEnabled(n!==this.NONE_KEY);};
return a;});
sap.ui.predefine('sap/m/p13n/Popup',["sap/ui/core/Control","sap/m/Button","sap/m/Bar","sap/m/Title","sap/m/MessageBox","sap/ui/Device","sap/m/Dialog","sap/m/ResponsivePopover","sap/m/p13n/Container","sap/m/p13n/AbstractContainerItem","sap/m/library"],function(C,B,a,T,M,D,b,R,c,A,l){"use strict";var P=l.P13nPopupMode;
var d=C.extend("sap.m.p13n.Popup",{
metadata:{properties:{title:{type:"string"},mode:{type:"sap.m.P13nPopupMode",defaultValue:P.Dialog},warningText:{type:"string"},reset:{type:"function"}},aggregations:{panels:{type:"sap.m.p13n.IContent",multiple:true},additionalButtons:{type:"sap.m.Button",multiple:true}},events:{close:{reason:{type:"string"}}}},
renderer:{apiVersion:2,render:function(r,o){r.openStart("div",o);r.style("height","100%");r.openEnd();r.renderControl(o.getAggregation("_content"));r.close("div");}}
});
d.prototype.init=function(){C.prototype.init.apply(this,arguments);this._aPanels=[];};
d.prototype.isOpen=function(){return!!this._bIsOpen;};
d.prototype.setMode=function(m){this.setProperty("mode",m);if(this._oPopup){this._oPopup.removeAllContent();this._oPopup.destroy();var p=this._createContainer();this.addDependent(p);this._oPopup=p;}return this;};
d.prototype.open=function(s,S){if(!s){throw new Error("Please provide a source control!");}if(!this._oPopup){var p=this._createContainer(S);this.addDependent(p);this._oPopup=p;}if(this.getMode()==="Dialog"){this._oPopup.open();}else{this._oPopup.openBy(s);}this._bIsOpen=true;};
d.prototype.addPanel=function(p){this._getContainer().addView(new A({key:p.getId(),text:p.getTitle(),content:p}));this._aPanels.push(p);return this;};
d.prototype.removePanel=function(p){this._aPanels.splice(this._aPanels.indexOf(p),1);this._getContainer().removeView(this._getContainer().getView(p.getId()));return this;};
d.prototype.getPanels=function(){return this._aPanels;};
d.prototype._createContainer=function(m){m=m?m:{};return this["_create"+this.getMode()].call(this,m);};
d.prototype._createResponsivePopover=function(m){var p=new R(this.getId()+"-responsivePopover",{title:this.getTitle(),horizontalScrolling:m.hasOwnProperty("horizontalScrolling")?m.horizontalScrolling:false,verticalScrolling:false,contentWidth:m.contentWidth?m.contentWidth:"30rem",resizable:m.hasOwnProperty("resizable")?m.resizable:true,contentHeight:m.contentHeight?m.contentHeight:"35rem",placement:m.placement?m.placement:"Bottom",content:this._getContainer()});p.setCustomHeader(this._createTitle());return p;};
d.prototype._createDialog=function(m){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var o=new b(this.getId()+"-dialog",{title:this.getTitle(),horizontalScrolling:m.hasOwnProperty("horizontalScrolling")?m.horizontalScrolling:false,verticalScrolling:false,contentWidth:m.contentWidth?m.contentWidth:"40rem",contentHeight:m.contentHeight?m.contentHeight:"55rem",draggable:true,resizable:true,stretch:D.system.phone,content:this._getContainer(),buttons:[new B(this.getId()+"-confirmBtn",{text:m.confirm&&m.confirm.text?m.confirm.text:r.getText("p13n.POPUP_OK"),type:"Emphasized",press:function(){this._onClose(o,"Ok");}.bind(this)}),new B(this.getId()+"-cancelBtn",{text:r.getText("p13n.POPUP_CANCEL"),press:function(){this._onClose(o,"Cancel");}.bind(this)})]});o.setCustomHeader(this._createTitle());this.getAdditionalButtons().forEach(function(e){o.addButton(e);});return o;};
d.prototype._createTitle=function(){var r=this.getReset();var t=this.getTitle();var w=this.getWarningText();var o;if(r){o=new a({contentLeft:[new T({text:t})]});o.addContentRight(new B(this.getId()+"-resetBtn",{text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("p13n.POPUP_RESET"),press:function(e){var f=e.getSource().getParent().getParent();var g=f.getParent();var s=w;M.warning(s,{actions:[M.Action.OK,M.Action.CANCEL],emphasizedAction:M.Action.OK,onClose:function(h){if(h===M.Action.OK){f.getButtons()[0].focus();r(g);}}});}}));}return o;};
d.prototype._getContainer=function(s){if(!this._oContainer){this._oContainer=new c();}if(this._oContainer.getViews().length>1){this._oContainer.switchView(this._oContainer.getViews()[1].getKey());}return this._oContainer;};
d.prototype._onClose=function(o,r){o.close();this._bIsOpen=false;this.fireClose({reason:r});};
d.prototype.exit=function(){if(this._oPopup){this._oPopup.destroy();}this._aPanels=null;};
return d;});
sap.ui.predefine('sap/m/p13n/QueryPanel',["sap/ui/layout/Grid","./BasePanel","sap/ui/core/Item","sap/m/CustomListItem","sap/m/Select","sap/m/List","sap/m/HBox","sap/m/library","sap/m/Button"],function(G,B,I,C,S,L,H,l,a){"use strict";
var Q=B.extend("sap.m.p13n.QueryPanel",{
metadata:{library:"sap.m",properties:{queryLimit:{type:"int",defaultValue:-1}}},
renderer:{apiVersion:2}
});
var b=l.ListType;var F=l.FlexJustifyContent;var c=l.ButtonType;Q.prototype.NONE_KEY="$_none";
Q.prototype.init=function(){B.prototype.init.apply(this,arguments);this._bFocusOnRearrange=false;this.setEnableReorder(true);this.addStyleClass("sapMP13nQueryPanel");};
Q.prototype.setP13nData=function(p){B.prototype.setP13nData.apply(this,arguments);this._oListControl.removeAllItems();if(p instanceof Array){p.forEach(function(i){if(i[this.PRESENCE_ATTRIBUTE]){this._addQueryRow(i);}}.bind(this));this._addQueryRow();}return this;};
Q.prototype._moveTableItem=function(i,n){B.prototype._moveTableItem.apply(this,arguments);this._updateEnableOfMoveButtons(i,false);this._oListControl.removeItem(i);this._oListControl.insertItem(i,n);};
Q.prototype._updateEnableOfMoveButtons=function(t,f){B.prototype._updateEnableOfMoveButtons.apply(this,arguments);if(this._oListControl.getItems().indexOf(t)===(this._oListControl.getItems().length-2)){this._getMoveDownButton().setEnabled(false);}};
Q.prototype._createInnerListControl=function(){return new L(this.getId()+"-innerP13nList",{itemPress:[this._onItemPressed,this],dragDropConfig:this._getDragDropConfig()});};
Q.prototype._getModelEntry=function(r){var k=r.getContent()[0].getContent()[0]._key;var f=this._getP13nModel().getProperty("/items").find(function(o){return o.name==k;});return f;};
Q.prototype._getAvailableItems=function(k){var i=this._getP13nModel().getProperty("/items");var A=[new I({key:this.NONE_KEY,text:this._getResourceText("p13n.QUERY_NONE"),enabled:!k})];i.forEach(function(n,d){A.push(new I({key:n.name,text:n.label,enabled:{path:this.P13N_MODEL+">/items/"+d+"/"+this.PRESENCE_ATTRIBUTE,formatter:function(q){return!q;}}}));}.bind(this));return A;};
Q.prototype._getMoveDownButton=function(){var m=B.prototype._getMoveDownButton.apply(this,arguments);m.setIcon("sap-icon://navigation-down-arrow");return m;};
Q.prototype._getMoveUpButton=function(){var m=B.prototype._getMoveUpButton.apply(this,arguments);m.setIcon("sap-icon://navigation-up-arrow");return m;};
Q.prototype._addQueryRow=function(i){if(this.getQueryLimit()>-1&&this.getQueryLimit()===this._oListControl.getItems().length){return;}i=i?i:{name:null};var q=this._createQueryRowGrid(i);var r=new C({type:b.Active,content:[q]});if(this.getEnableReorder()&&(this.getQueryLimit()===-1||this.getQueryLimit()>1)){this._addHover(r);}r.getContent()[0].getContent()[0]._key=i.name;this._oListControl.addItem(r);var s=!!i.name;var R=this._createRemoveButton(s);r.getContent()[0].addContent(R);return r;};
Q.prototype._createQueryRowGrid=function(i){var s=this._createKeySelect(i.name);return new G({containerQuery:true,defaultSpan:"XL6 L6 M6 S6",content:[s]}).addStyleClass("sapUiTinyMargin");};
Q.prototype._handleActivated=function(h){var q=h.getContent()[0];if(q){var i=q.getContent().length-1;var o=h.getContent()[0].getContent()[i];if(h&&o.getItems().length<2){o.insertItem(this._getMoveUpButton(),0);o.insertItem(this._getMoveDownButton(),1);this._updateEnableOfMoveButtons(h,false);}}};
Q.prototype._createKeySelect=function(k){var K=new S({width:"14rem",items:this._getAvailableItems(k),selectedKey:k,change:this._selectKey.bind(this)});return K;};
Q.prototype._selectKey=function(e){var o=e.getSource().getParent().getParent();var i=this._oListControl.getItems().length-1==this._oListControl.getItems().indexOf(o);var n=e.getParameter("selectedItem").getKey();var O=e.getSource()._key;var d=o.getContent()[0].getContent()[o.getContent()[0].getContent().length-1];d.setVisible(n!==this.NONE_KEY);if(O){this._updatePresence(O,false,undefined);}e.getSource()._key=n;this._updatePresence(n,true,this._oListControl.getItems().indexOf(o));if(n!==this.NONE_KEY&&i){this._addQueryRow();var s=e.getSource();var N=s.getItemByKey(this.NONE_KEY);N.setEnabled(false);}};
Q.prototype._createRemoveButton=function(v){var r=new H({justifyContent:F.End,width:"100%",visible:v,items:[new a({type:c.Transparent,icon:"sap-icon://decline",press:function(e){var R=e.getSource().getParent().getParent().getParent();this._oListControl.removeItem(R);this._updatePresence(R.getContent()[0].getContent()[0]._key,false,undefined);if(this._oListControl.getItems().length===0){this._addQueryRow();}else{var i=this._oListControl.getItems().length-1;this._oListControl.getItems()[i].getContent()[0].getContent()[0].focus();}}.bind(this)})]});return r;};
Q.prototype._moveSelectedItem=function(){this._oSelectedItem=this._getMoveUpButton().getParent().getParent().getParent();B.prototype._moveSelectedItem.apply(this,arguments);};
Q.prototype._updatePresence=function(k,A,n){var i=this._getP13nModel().getProperty("/items");var r=i.filter(function(d){return d.name===k;});if(r[0]){r[0][this.PRESENCE_ATTRIBUTE]=A;}if(n!==undefined){var o=i.indexOf(r[0]);i.splice(n,0,i.splice(o,1)[0]);}this._getP13nModel().setProperty("/items",i);this.fireChange({reason:A?this.CHANGE_REASON_ADD:this.CHANGE_REASON_REMOVE,item:r[0]});};
return Q;});
sap.ui.predefine('sap/m/p13n/SelectionPanel',["./BasePanel","sap/m/Label","sap/m/ColumnListItem","sap/m/HBox","sap/m/VBox","sap/ui/core/Icon","sap/m/Text","sap/m/Column","sap/m/Table","sap/m/library","sap/m/ToolbarSpacer","sap/m/Button","sap/m/OverflowToolbar","sap/ui/model/Filter"],function(B,L,C,H,V,I,T,a,b,l,c,d,O,F){"use strict";var e=l.ListKeyboardMode;var f=l.FlexJustifyContent;var g=l.ListType;
var S=B.extend("sap.m.p13n.SelectionPanel",{
metadata:{library:"sap.m",properties:{showHeader:{type:"boolean",defaultValue:false},enableCount:{type:"boolean",defaultValue:false},fieldColumn:{type:"string",defaultValue:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("p13n.DEFAULT_DESCRIPTION")},activeColumn:{type:"string",defaultValue:""},itemFactory:{type:"function"}}},
renderer:{apiVersion:2}
});
S.prototype.applySettings=function(){B.prototype.applySettings.apply(this,arguments);this._setTemplate(this._getListTemplate());this.addStyleClass("sapMSelectionPanel");this._aInitializedFields=[];this._bShowFactory=false;this.addStyleClass("SelectionPanelHover");this._displayColumns();this.setEnableReorder(true);};
S.prototype.setItemFactory=function(i){this.setProperty("itemFactory",i);this._oListControl.setGrowing(!!i);return this;};
S.prototype._getListTemplate=function(){return new C({selected:"{"+this.P13N_MODEL+">"+this.PRESENCE_ATTRIBUTE+"}",type:g.Active,cells:[new V({items:[new L({wrapping:true,required:"{"+this.P13N_MODEL+">required}",tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">label}"})]}),new H({justifyContent:f.Center,items:[new I({src:"sap-icon://circle-task-2",size:"0.5rem",color:sap.ui.core.IconColor.Neutral,visible:{path:this.P13N_MODEL+">active",formatter:function(h){if(h){return true;}else{return false;}}}})]})]});};
S.prototype.setShowHeader=function(s){if(s){var h=this._getResourceText("p13n.SHOW_SELECTED");var i=this._getResourceText("p13n.SHOW_ALL");this._oListControl.setHeaderToolbar(new O({content:[this._getSearchField(),new c(),new d({press:function(E){this._bShowSelected=E.getSource().getText()==h;this._filterList(this._bShowSelected,this._sSearch);E.getSource().setText(this._bShowSelected?i:h);}.bind(this),text:h})]}));}this.setProperty("showHeader",s);return this;};
S.prototype.getSelectedFields=function(){var s=[];this._loopItems(this._oListControl,function(i,k){if(i.getSelected()){s.push(k);}});return s;};
S.prototype._filterList=function(s,h){var o=[],i=[];if(s){i=new F(this.PRESENCE_ATTRIBUTE,"EQ",true);}if(h){o=new F("label","Contains",h);}this._oListControl.getBinding("items").filter(new F([].concat(i,o),true));};
S.prototype._onSearchFieldLiveChange=function(E){this._sSearch=E.getSource().getValue();this._filterList(this._bShowSelected,this._sSearch);};
S.prototype._handleActivated=function(h){this._removeMoveButtons();if(this._oHoveredItem&&this._oHoveredItem.getBindingContextPath()){var v=!!this._getP13nModel().getProperty(this._oHoveredItem.getBindingContextPath()).active;var o=this._oHoveredItem.getCells()[1].getItems()[0];o.setVisible(v);}var i=h.getCells()[1].getItems()[0];i.setVisible(false);this._oHoveredItem=h;this._updateEnableOfMoveButtons(h,false);this._addMoveButtons(h);};
S.prototype._removeMoveButtons=function(){var m=this._getMoveButtonContainer();if(m){m.removeItem(this._getMoveTopButton());m.removeItem(this._getMoveUpButton());m.removeItem(this._getMoveDownButton());m.removeItem(this._getMoveBottomButton());}};
S.prototype._getMoveButtonContainer=function(){if(this._oMoveBottomButton&&this._oMoveBottomButton.getParent()&&this._oMoveBottomButton.getParent().isA("sap.m.FlexBox")){return this._oMoveBottomButton.getParent();}};
S.prototype.showFactory=function(s){this._bShowFactory=s;this._displayColumns();if(s){this.removeStyleClass("SelectionPanelHover");this._oListControl.setKeyboardMode(e.Edit);this._addFactoryControl();}else{this.addStyleClass("SelectionPanelHover");this._oListControl.setKeyboardMode(e.Navigation);this._removeFactoryControl();}};
S.prototype._loopItems=function(o,i){o.getItems().forEach(function(h){var p=h.getBindingContextPath();var k=this._getP13nModel().getProperty(p).name;i.call(this,h,k);}.bind(this));};
S.prototype.setP13nData=function(){this._oListControl.removeSelections();B.prototype.setP13nData.apply(this,arguments);this._updateCount();};
S.prototype._updateCount=function(){this._getP13nModel().setProperty("/selectedItems",this._oListControl.getSelectedContexts(true).length);};
S.prototype._selectTableItem=function(t,s){B.prototype._selectTableItem.apply(this,arguments);this._updateCount();};
S.prototype._removeFactoryControl=function(){this._oListControl.getItems().forEach(function(i){var o=i.getCells()[0];if(o.getItems().length>1){o.removeItem(o.getItems()[1]);}});this.removeStyleClass("sapUiMDCAFLabelMarkingList");return this._aInitializedFields;};
S.prototype._moveSelectedItem=function(){this._oSelectedItem=this._getMoveButtonContainer().getParent();B.prototype._moveSelectedItem.apply(this,arguments);};
S.prototype._getShowFactory=function(){return this._bShowFactory;};
S.prototype._displayColumns=function(){var h=[this.getFieldColumn()];if(!this._bShowFactory){h.push(new a({width:"30%",hAlign:"Center",vAlign:"Middle",header:new T({text:this.getActiveColumn()})}));}this._setPanelColumns(h);};
S.prototype._setPanelColumns=function(h){this._sText=h[0];var E=this.getEnableCount();if(E){var o=new a({header:new T({text:{parts:[{path:this.P13N_MODEL+'>/selectedItems'},{path:this.P13N_MODEL+'>/items'}],formatter:function(s,A){return this._sText+" "+this._getResourceText('p13n.HEADER_COUNT',[s,A instanceof Array?A.length:0]);}.bind(this)}})});h[0]=o;}B.prototype._setPanelColumns.apply(this,arguments);};
S.prototype._addFactoryControl=function(o){this._oListControl.getItems().forEach(function(i){var h=i.getBindingContext(this.P13N_MODEL);var j=this.getItemFactory().call(this,h);var k=i.getCells()[0];k.addItem(j);}.bind(this));this.addStyleClass("sapUiMDCAFLabelMarkingList");};
S.prototype._createInnerListControl=function(){return new b(this.getId()+"-innerSelectionPanelTable",Object.assign({growing:false,growingThreshold:25,growingScrollToLoad:true,updateStarted:function(){this._removeMoveButtons();this._removeFactoryControl();}.bind(this),updateFinished:function(){if(this._getShowFactory()){this._addFactoryControl();}}.bind(this)},this._getListControlConfig()));};
S.prototype.filterContent=function(h){if(this._oListControl.getBinding("items")){this._oListControl.getBinding("items").filter(h,true);}};
S.prototype._addMoveButtons=function(i){var t=i;if(!t){return;}var h=this._getP13nModel().getProperty(t.getBindingContextPath())[this.PRESENCE_ATTRIBUTE];if(h){t.getCells()[1].addItem(this._getMoveTopButton());t.getCells()[1].addItem(this._getMoveUpButton());t.getCells()[1].addItem(this._getMoveDownButton());t.getCells()[1].addItem(this._getMoveBottomButton());}};
S.prototype.exit=function(){B.prototype.exit.apply(this,arguments);this._aInitializedFields=null;this._oHoveredItem=null;this._bShowFactory=null;this._sSearch=null;this._bShowSelected=null;};
return S;});
sap.ui.predefine('sap/m/p13n/SortPanel',["./QueryPanel","sap/m/Text","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/ui/layout/Grid","sap/ui/layout/GridData"],function(Q,T,S,a,G,b){"use strict";
var c=Q.extend("sap.m.p13n.SortPanel",{renderer:{apiVersion:2}});
c.prototype.PRESENCE_ATTRIBUTE="sorted";c.prototype.CHANGE_REASON_SORTORDER="sortorder";
c.prototype._createRemoveButton=function(){var r=Q.prototype._createRemoveButton.apply(this,arguments);r.setLayoutData(new b({span:"XL3 L3 M3 S4"}));return r;};
c.prototype._createOrderSwitch=function(k,d){var s=new S({enabled:k?true:false,layoutData:new b({span:"XL2 L2 M2 S4"}),items:[new a({key:"asc",icon:"sap-icon://sort-ascending"}),new a({key:"desc",icon:"sap-icon://sort-descending"})],select:function(e){var f=e.getParameter("key");var t=e.getSource().getParent().getContent()[2];t.setText(this._getSortOrderText(f==="desc"));var k=e.oSource.getParent().getContent()[0].getSelectedItem().getKey();this._changeOrder(k,f=="desc");}.bind(this)});s.setSelectedItem(d?s.getItems()[1]:s.getItems()[0]);return s;};
c.prototype._createSortOrderText=function(d){return new T({layoutData:new b({span:"XL3 L3 M3 S3",visibleS:false}),text:this._getSortOrderText(d)}).addStyleClass("sapUiTinyMarginTop");};
c.prototype._createQueryRowGrid=function(i){var s=this._createKeySelect(i.name);var o=this._createOrderSwitch(i.name,i.descending);var d=this._createSortOrderText(i.descending);return new G({containerQuery:true,defaultSpan:"XL4 L4 M4 S4",content:[s,o,d]}).addStyleClass("sapUiTinyMargin");};
c.prototype._selectKey=function(e){Q.prototype._selectKey.apply(this,arguments);var l=e.getSource().getParent().getParent();var n=e.getParameter("selectedItem").getKey();l.getContent()[0].getContent()[1].setEnabled(n!==this.NONE_KEY);var d=l.getContent()[0].getContent()[1].getSelectedKey()==="desc";this._changeOrder(n,d);};
c.prototype._getSortOrderText=function(d){return d?this._getResourceText("p13n.SORT_DESCENDING"):this._getResourceText("p13n.SORT_ASCENDING");};
c.prototype._changeOrder=function(k,d){var i=this._getP13nModel().getProperty("/items").filter(function(I){return I.name===k;});i[0].descending=d;this.fireChange({reason:this.CHANGE_REASON_SORTORDER,item:i[0]});};
return c;});
/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/AccButton',['./Button','./AccButtonRenderer'],function(B,A){"use strict";
var a=B.extend("sap.m.AccButton",{metadata:{library:"sap.m",properties:{"tabIndex":{type:"string",defaultValue:null,bindable:"bindable"},"ariaHidden":{type:"string",defaultValue:null,bindable:"bindable"},"ariaHaspopup":{type:"string",defaultValue:null,bindable:"bindable"}}}});
return a;});
sap.ui.predefine('sap/m/AccButtonRenderer',["./ButtonRenderer","sap/ui/core/Renderer"],function(B,R){"use strict";var A=R.extend(B);A.apiVersion=2;
A.renderAccessibilityAttributes=function(r,c){if(c.getTabIndex()){r.attr("tabindex",c.getTabIndex());}if(c.getAriaHidden()){r.attr("aria-hidden",c.getAriaHidden());}if(c.getAriaHaspopup()){r.attr("aria-haspopup",c.getAriaHaspopup());}};
return A;},true);
sap.ui.predefine('sap/m/ActionListItem',['./ListItemBase','./library','./ActionListItemRenderer'],function(L,l,A){"use strict";var a=l.ListMode;var b=l.ListType;
var c=L.extend("sap.m.ActionListItem",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
c.prototype.init=function(){this.setType(b.Active);L.prototype.init.apply(this,arguments);};
c.prototype.getMode=function(){return a.None;};
c.prototype.onsapspace=c.prototype.onsapenter;
c.prototype.getContentAnnouncement=function(){return this.getText();};
return c;});
sap.ui.predefine('sap/m/ActionListItemRenderer',["./ListItemBaseRenderer","sap/ui/core/Renderer"],function(L,R){"use strict";var A=R.extend(L);A.apiVersion=2;
A.renderLIAttributes=function(r,l){r.class("sapMALI");};
A.renderLIContent=function(r,l){var t=l.getText();if(t){r.openStart("div").class("sapMALIText").openEnd();r.text(t);r.close("div");}};
return A;},true);
sap.ui.predefine('sap/m/ActionSelect',['./Select','sap/ui/core/InvisibleText','sap/ui/Device','sap/ui/core/Core','./ActionSelectRenderer'],function(S,I,D,C,A){"use strict";
var a=S.extend("sap.m.ActionSelect",{metadata:{library:"sap.m",associations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"}}}});
a.prototype.init=function(){S.prototype.init.call(this);this.getList().addEventDelegate({onfocusin:this.onfocusinList},this);};
a.prototype.hasContent=function(){return S.prototype.hasContent.call(this)||!!this.getButtons().length;};
a.prototype.addContentToFlex=function(){var s=this.getSimpleFixFlex();this.getButtons().forEach(function(b){s.addFlexContent(C.byId(b));});};
a.prototype._onBeforeRenderingPopover=function(){S.prototype._onBeforeRenderingPopover.call(this);var p=this.getPicker();p&&p._setAriaRoleApplication(true);this._updateTutorMessage();};
a.prototype.onAfterRenderingPicker=function(){S.prototype.onAfterRenderingPicker.call(this);var p=this.getPicker(),r=this.getRenderer();p.addStyleClass(r.CSS_CLASS+"Picker");p.addStyleClass(r.ACTION_SELECT_CSS_CLASS+"Picker");p.addStyleClass(r.ACTION_SELECT_CSS_CLASS+"Picker-CTX");};
a.prototype.createPickerCloseButton=function(){};
a.prototype.removeButton=function(b){var s=this.getSimpleFixFlex();if(s){if(typeof b==="number"){b=this.getButtons()[b];}s.removeFlexContent(b);}return this.removeAssociation("buttons",b);};
a.prototype.removeAllButtons=function(){var s=this.getSimpleFixFlex();if(s){this.getButtons().forEach(function(b){s.removeFlexContent(C.byId(b));});}return this.removeAllAssociation("buttons");};
a.prototype.onsaptabprevious=function(e){var b=this.getButtons(),p=this.getPicker(),i;this._bProcessChange=false;if(e.isMarked()||!this.getEnabled()){return;}e.setMarked();if(p&&p.isOpen()&&b.length>0){for(i=b.length-1;i>=0;i--){if(C.byId(b[i]).getEnabled()){C.byId(b[i]).focus();e.preventDefault();break;}}}};
a.prototype.onsaptabnext=function(e){var b=this.getButtons(),p=this.getPicker(),i;this._bProcessChange=false;if(e.isMarked()||!this.getEnabled()){return;}e.setMarked();if(p&&p.isOpen()&&b.length>0){for(i=0;i<b.length;i++){if(C.byId(b[i]).getEnabled()){C.byId(b[i]).focus();e.preventDefault();break;}}}};
a.prototype.onsapfocusleave=function(e){var b=this.getButtons();var k=(b.indexOf(e.relatedControlId)===-1);if(k){S.prototype.onsapfocusleave.apply(this,arguments);}this._toggleListFocusIndication(true);};
a.prototype.onfocusinList=function(e){if(document.activeElement!==this.getList().getDomRef()&&!D.system.phone){this.focus();}};
a.prototype.onfocusin=function(){S.prototype.onfocusin.apply(this,arguments);this._toggleListFocusIndication(false);};
a.prototype._toggleListFocusIndication=function(r){var s=this.getSelectedItem();if(this.isOpen()&&s){s.$().toggleClass("sapMActionSelectItemWithoutFocus",r);}};
a.prototype._updateTutorMessage=function(){var p=this.getPicker(),b=p.getAriaLabelledBy(),h=!!this.getButtons().length,t;if(!this._sTutorMessageId){this._sTutorMessageId=this._getTutorMessageId();this._oTutorMessageText=new I(this._sTutorMessageId,{text:C.getLibraryResourceBundle("sap.m").getText("ACTION_SELECT_TUTOR_MESSAGE")}).toStatic();}t=(b.indexOf(this._sTutorMessageId)===-1);if(t&&h){p.addAriaLabelledBy(this._sTutorMessageId);}else{if(!h){p.removeAriaLabelledBy(this._sTutorMessageId);}}};
a.prototype._getTutorMessageId=function(){return this.getId()+"-tutorMessage";};
a.prototype.exit=function(){S.prototype.exit.call(this);if(this._oTutorMessageText){this._oTutorMessageText.destroy();this._oTutorMessageText=null;}};
return a;});
sap.ui.predefine('sap/m/ActionSelectRenderer',['sap/ui/core/Renderer','./SelectRenderer'],function(R,S){"use strict";var A=R.extend(S);A.ACTION_SELECT_CSS_CLASS="sapMActionSelect";A.apiVersion=2;
A.addClass=function(r,a){r.class(A.ACTION_SELECT_CSS_CLASS);};
return A;},true);
sap.ui.predefine('sap/m/ActionSheet',['./Dialog','./Popover','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/Device','./ActionSheetRenderer','./Button',"sap/ui/thirdparty/jquery"],function(D,P,l,C,I,a,b,A,B,q){"use strict";var c=l.ButtonType;var d=l.DialogType;var e=l.PlacementType;
var f=C.extend("sap.m.ActionSheet",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:e.Bottom},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:true},cancelButtonText:{type:"string",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null}},aggregations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_cancelButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_invisibleAriaTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}},defaultAggregation:"buttons",events:{cancelButtonTap:{deprecated:true},beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}},cancelButtonPress:{}},designtime:"sap/m/designtime/ActionSheet.designtime"}});
f.prototype.init=function(){this._fnOrientationChange=this._orientationChange.bind(this);this._actionSelected=null;};
f.prototype.exit=function(){b.resize.detachHandler(this._fnOrientationChange);if(this._parent){this._parent.destroy();this._parent=null;}if(this._oCancelButton){this._oCancelButton.destroy();this._oCancelButton=null;}this._clearItemNavigation();};
f.prototype._clearItemNavigation=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};
f.prototype._setItemNavigation=function(){var g=this._getAllButtons(),h=[],o=this.getDomRef();if(o){this._oItemNavigation.setRootDomRef(o);for(var i=0;i<g.length;i++){if(g[i].getEnabled()&&g[i].getVisible()){h.push(g[i].getFocusDomRef());}}if(this._oCancelButton){h.push(this._oCancelButton.getFocusDomRef());}this._oItemNavigation.setItemDomRefs(h);this._oItemNavigation.setSelectedIndex(0);this._oItemNavigation.setPageSize(5);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});}};
f.prototype.onmousedown=function(E){if(E.srcControl.isA("sap.m.Button")&&this.getButtons().indexOf(E.srcControl)!==-1){this._actionSelected=E.srcControl;}};
f.prototype.onBeforeRendering=function(){var t,p;this._clearItemNavigation();t=this.getTitle();if(this._parent&&!this.isPropertyInitial("title")&&this._parent.getTitle()!==t){if(b.system.phone){this._parent.setTitle(t);this._parent.setShowHeader(!!t);}if(t){this._parent.addStyleClass("sapMActionSheetDialogWithTitle");}else{this._parent.removeStyleClass("sapMActionSheetDialogWithTitle");}}p=this.getPlacement();if(this._parent&&!b.system.phone&&!this.isPropertyInitial("placement")&&this._parent.setPlacement()!==p){this._parent.setPlacement(p);}};
f.prototype.onAfterRendering=function(){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._setItemNavigation();};
f.prototype.sapfocusleave=function(){this.close();};
f.prototype.openBy=function(o){var t=this;if(!this._parent){var O=this.getParent();if(O){this.setParent(null);}if(!b.system.phone){this._parent=new P({placement:this.getPlacement(),showHeader:false,content:[this],beforeOpen:function(){t.fireBeforeOpen();},afterOpen:function(){t.focus();t.fireAfterOpen();},beforeClose:function(){t.fireBeforeClose();},afterClose:function(){if(t.getShowCancelButton()){t.fireCancelButtonTap();t.fireCancelButtonPress();}t._onAfterClose(t._actionSelected);t._actionSelected=null;},ariaLabelledBy:this.getPopupHiddenLabelId()||undefined}).addStyleClass("sapMActionSheetPopover");this._parent._setAriaRoleApplication(true);}else{this._parent=new D({title:this.getTitle(),type:d.Standard,content:[this],beforeOpen:function(){t.fireBeforeOpen();},afterOpen:function(){t.focus();t.fireAfterOpen();},beforeClose:function(E){t.fireBeforeClose({origin:E.getParameter("origin")});},afterClose:function(E){t._actionSelected=E.getParameter("origin");t._onAfterClose(t._actionSelected);t._actionSelected=null;b.resize.detachHandler(t._fnOrientationChange);}}).addStyleClass("sapMActionSheetDialog");if(this.getTitle()){this._parent.addStyleClass("sapMActionSheetDialogWithTitle");}else{this._parent.addAriaLabelledBy(this.getPopupHiddenLabelId()||undefined);}if(!b.system.phone){this._parent.setBeginButton(this._getCancelButton());}if(b.system.phone){this._parent.oPopup.setModal(true);this._parent._setDimensions=function(){D.prototype._setDimensions.apply(this);this.$("cont").css("max-height","");};this._parent._adjustScrollingPane=function(){var h=this.$().height();this.$("cont").css("max-height",h);if(this._oScroller){this._oScroller.refresh();}};}}if(O){O.addDependent(this._parent);}}if(!b.system.phone){this._parent.openBy(o);}else{this._parent.open();b.resize.attachHandler(this._fnOrientationChange);}};
f.prototype.close=function(){if(this._parent){this._parent.close();}};
f.prototype.isOpen=function(){return!!this._parent&&this._parent.isOpen();};
f.prototype._createCancelButton=function(){if(!this._oCancelButton){var s=(this.getCancelButtonText())?this.getCancelButtonText():sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACTIONSHEET_CANCELBUTTON_TEXT"),t=this;this._oCancelButton=new B(this.getId()+'-cancelBtn',{text:s,type:c.Reject,press:function(){if(b.system.phone&&t._parent){t._parent._oCloseTrigger=this;}t.close();t.fireCancelButtonTap();t.fireCancelButtonPress();}}).addStyleClass("sapMActionSheetButton sapMActionSheetCancelButton sapMBtnTransparent sapMBtnInverted");if(b.system.phone){this.setAggregation("_cancelButton",this._oCancelButton,true);}}return this;};
f.prototype._getCancelButton=function(){if(b.system.phone&&this.getShowCancelButton()){this._createCancelButton();return this._oCancelButton;}return null;};
f.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,true);if(this._oCancelButton){this._oCancelButton.setText(t);}return this;};
f.prototype._preProcessActionButton=function(o){var t=o.getType();if(t!==c.Accept&&t!==c.Reject){o.setType(c.Transparent);}o.addStyleClass("sapMBtnInverted");if(!o.getIcon()){o.addStyleClass("sapMActionSheetButtonNoIcon");}o.addStyleClass("sapMActionSheetButton");this._parent&&this._parent.invalidate();return this;};
f.prototype._buttonSelected=function(){if(b.system.phone&&this._parent){this._parent._oCloseTrigger=this;}this.close();};
f.prototype._orientationChange=function(){this._parent._adjustScrollingPane();};
f.prototype._addAriaHiddenTexts=function(o){var s=o.getId(),i;if(sap.ui.getCore().getConfiguration().getAccessibility()){i=new a(s+"-actionSheetHiddenText");this.addAggregation("_invisibleAriaTexts",i,false);o.addAriaDescribedBy(i.getId());}};
f.prototype._removeAriaHiddenTexts=function(o){o.getAriaDescribedBy().forEach(function(i){var g=sap.ui.getCore().byId(i);if(g instanceof a&&i.indexOf("actionSheetHiddenText")>-1){this.removeAggregation("_invisibleAriaTexts",g,false);o.removeAriaDescribedBy(g);g.destroy();}},this);};
f.prototype.addButton=function(o){this.addAggregation("buttons",o,false);this._addAriaHiddenTexts(o);this._preProcessActionButton(o);o.attachPress(this._buttonSelected,this);return this;};
f.prototype.insertButton=function(o,i){this.insertAggregation("buttons",o,i,false);this._addAriaHiddenTexts(o);this._preProcessActionButton(o);o.attachPress(this._buttonSelected,this);return this;};
f.prototype.removeButton=function(o){var r=this.removeAggregation("buttons",o,false);if(r){r.detachPress(this._buttonSelected,this);this._removeAriaHiddenTexts(r);}return r;};
f.prototype.removeAllButtons=function(){var r=this.removeAllAggregation("buttons",false),t=this;q.each(r,function(i,o){o.detachPress(t._buttonSelected,t);t._removeAriaHiddenTexts(o);});return r;};
f.prototype.clone=function(){var g=this.getButtons();for(var i=0;i<g.length;i++){g[i].detachPress(this._buttonSelected,this);}var o=C.prototype.clone.apply(this,arguments);for(var j=0;j<g.length;j++){g[j].attachPress(this._buttonSelected,this);}return o;};
f.prototype._getAllButtons=function(){return this.getButtons();};
f.prototype.getPopupHiddenLabelId=function(){return a.getStaticId("sap.m","ACTIONSHEET_AVAILABLE_ACTIONS");};
f.prototype._applyContextualSettings=function(){C.prototype._applyContextualSettings.call(this);};
f.prototype._onAfterClose=function(o){this.fireAfterClose({origin:o});};
return f;});
sap.ui.predefine('sap/m/ActionSheetRenderer',["sap/ui/Device"],function(D){"use strict";var A={apiVersion:2};
A.render=function(r,c){var a=c._getAllButtons(),I=c.getAggregation("_invisibleAriaTexts"),R=sap.ui.getCore().getLibraryResourceBundle('sap.m'),b=a.length,d=sap.ui.getCore().getConfiguration().getAccessibility(),v=a.filter(function(B){return B.getVisible();}).length,C,i,m,B,V=1,g=function(o){return I.filter(function(e){return e.getId().indexOf(o.getId())>-1;})[0];};for(i=0;i<b;i++){B=a[i];if(B.getIcon()&&B.getVisible()){m=true;}}r.openStart("div",c);r.class("sapMActionSheet");if(m){r.class("sapMActionSheetMixedButtons");}var t=c.getTooltip_AsString();if(t){r.attr("title",t);}d&&r.attr("role","presentation");r.openEnd();for(i=0;i<b;i++){B=a[i];r.renderControl(a[i]);if(d&&B.getVisible()){C=g(B);if(C){C.setText(R.getText('ACTIONSHEET_BUTTON_INDEX',[V,v]));r.renderControl(C);}V++;}}if(D.system.phone&&c.getShowCancelButton()){r.renderControl(c._getCancelButton());}r.close("div");};
return A;},true);
sap.ui.predefine('sap/m/App',['./NavContainer','./library','./AppRenderer','sap/ui/base/DataType',"sap/ui/util/Mobile","sap/base/Log","sap/ui/thirdparty/jquery"],function(N,l,A,D,M,L,q){"use strict";
var a=N.extend("sap.m.App",{metadata:{library:"sap.m",properties:{homeIcon:{type:"any",group:"Misc",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},backgroundImage:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},backgroundRepeat:{type:"boolean",group:"Appearance",defaultValue:false},backgroundOpacity:{type:"float",group:"Appearance",defaultValue:1},mobileWebAppCapable:{type:"boolean",group:"Appearance",defaultValue:true},isTopLevel:{type:"boolean",group:"Behavior",defaultValue:true}},events:{orientationChange:{deprecated:true,parameters:{landscape:{type:"boolean"}}}}}});
a.prototype.init=function(){N.prototype.init.apply(this,arguments);this.addStyleClass("sapMApp");M.init({viewport:!this._debugZoomAndScroll,statusBar:"default",hideBrowser:true,preventScroll:!this._debugZoomAndScroll,rootId:this.getId()});q(window).on("resize",q.proxy(this._handleOrientationChange,this));};
a.prototype.onBeforeRendering=function(){if(N.prototype.onBeforeRendering){N.prototype.onBeforeRendering.apply(this,arguments);}M.init({homeIcon:this.getHomeIcon(),mobileWebAppCapable:this.getMobileWebAppCapable()});};
a.prototype.onAfterRendering=function(){if(N.prototype.onAfterRendering){N.prototype.onAfterRendering.apply(this,arguments);}if(this.getIsTopLevel()){this._adjustParentsHeight();}};
a.prototype._adjustParentsHeight=function(){if(!this.getDomRef()){return;}var r=this.getDomRef().parentNode;while(r&&r!==document.documentElement){var $=q(r);if($.attr("data-sap-ui-root-content")){break;}if(!r.style.height){r.style.height="100%";}r=r.parentNode;}};
a.prototype.exit=function(){q(window).off("resize",this._handleOrientationChange);if(this._sInitTimer){clearTimeout(this._sInitTimer);}};
a.prototype._handleOrientationChange=function(){var $=q(window);var i=$.width()>$.height();if(this._oldIsLandscape!==i){this.fireOrientationChange({landscape:i});this._oldIsLandscape=i;}};
a.prototype.setBackgroundOpacity=function(o){if(o>1||o<0){L.warning("Invalid value "+o+" for App.setBackgroundOpacity() ignored. Valid values are: floats between 0 and 1.");return this;}this.$("BG").css("opacity",o);return this.setProperty("backgroundOpacity",o,true);};
return a;});
sap.ui.predefine('sap/m/AppRenderer',['./NavContainerRenderer','sap/ui/core/Renderer','sap/m/library'],function(N,R,l){"use strict";var B=l.BackgroundHelper;var A=R.extend(N);A.apiVersion=2;
A.renderAttributes=function(r,c){B.addBackgroundColorStyles(r,c.getBackgroundColor(),c.getBackgroundImage());};
A.renderBeforeContent=function(r,c){B.renderBackgroundImageTag(r,c,"sapMAppBG",c.getBackgroundImage(),c.getBackgroundRepeat(),c.getBackgroundOpacity());};
return A;},true);
sap.ui.predefine('sap/m/AssociativeOverflowToolbar',['sap/base/Log','./OverflowToolbar','./OverflowToolbarRenderer','sap/ui/Device'],function(L,O,a,D){"use strict";
var A=O.extend("sap.m.AssociativeOverflowToolbar",{
metadata:{associations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}},
renderer:a
});
A.prototype.getContent=function(){var b=this.getAssociation("content")||[];var c=[];b.forEach(function(d){var C=sap.ui.getCore().byId(d);if(C){c.push(C);}});return c;};
A.prototype.insertContent=function(c,I){var s=c.getId(),b=this.getAssociation("content").filter(function(d){return d!==s;});var i;if(I<0){i=0;}else if(I>b.length){i=b.length;}else{i=I;}if(i!==I){L.warning("AssociativeOverflowToolbar.insertContent: index '"+I+"' out of range [0,"+b.length+"], forced to "+i);}b.splice(i,0,s);this.removeAllAssociation("content");b.forEach(function(d){this.addAssociation("content",d);},this);return this;};
A.prototype.exit=function(){O.prototype.exit.apply(this,arguments);return this._callToolbarMethod('destroyContent',[true]);};
A.prototype.indexOfContent=function(c){var b=this.getAssociation("content")||[];return b.indexOf(c.getId());};
A.prototype._handleResize=function(){if(D.system.phone){this._resetAndInvalidateToolbar();}else{this._bControlsInfoCached=false;O.prototype._handleResize.apply(this,arguments);}};
A.prototype._callToolbarMethod=function(f,b){switch(f){case'addContent':return this.addAssociation("content",b[0]);case'getContent':return this.getContent();case'insertContent':return this.insertContent(b[0],b[1]);case'removeContent':return sap.ui.getCore().byId(this.removeAssociation("content",b[0],b[1],b[2]))||null;case'destroyContent':this.removeAllAssociation("content",b[0]);return this;case'removeAllContent':return this.removeAllAssociation("content",b[0]).map(function(c){return sap.ui.getCore().byId(c);});default:return O.prototype._callToolbarMethod.call(this,f,b);}};
return A;});
sap.ui.predefine('sap/m/Avatar',["sap/ui/core/Control","sap/ui/core/IconPool","./AvatarRenderer","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/Icon","./library"],function(C,I,A,K,L,a,l){"use strict";var b=l.AvatarType;var c=l.AvatarImageFitType;var d=l.AvatarColor;var e=l.AvatarSize;var f=l.AvatarShape;var g=Object.keys(d).filter(function(s){return s.indexOf("Accent")!==-1;});
var h=C.extend("sap.m.Avatar",{metadata:{library:"sap.m",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},initials:{type:"string",group:"Data",defaultValue:null},displayShape:{type:"sap.m.AvatarShape",group:"Appearance",defaultValue:f.Circle},displaySize:{type:"sap.m.AvatarSize",group:"Appearance",defaultValue:e.S},customDisplaySize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"3rem"},customFontSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"1.125rem"},imageFitType:{type:"sap.m.AvatarImageFitType",group:"Appearance",defaultValue:c.Cover},fallbackIcon:{type:"string",group:"Data",defaultValue:null},backgroundColor:{type:"sap.m.AvatarColor",group:"Appearance",defaultValue:d.Accent6},showBorder:{type:"boolean",group:"Appearance",defaultValue:false},badgeIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},badgeTooltip:{type:"string",group:"Data",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:false}},aggregations:{detailBox:{type:'sap.m.LightBox',multiple:false,bindable:"bindable"},_badge:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}},dnd:{draggable:true,droppable:false},designtime:"sap/m/designtime/Avatar.designtime"}});
h.DEFAULT_CIRCLE_PLACEHOLDER="sap-icon://person-placeholder";h.DEFAULT_SQUARE_PLACEHOLDER="sap-icon://product";h.AVATAR_BADGE_TOOLTIP={"sap-icon://zoom-in":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_ZOOMIN"),"sap-icon://camera":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_CAMERA"),"sap-icon://edit":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_EDIT")};
h.prototype.init=function(){this._sActualType=null;this._bIsDefaultIcon=true;this._sImageFallbackType=null;this._sPickedRandomColor=null;this._badgeRef=null;};
h.prototype.exit=function(){if(this._fnLightBoxOpen){this._fnLightBoxOpen=null;}if(this._badgeRef){this._badgeRef.destroy();}this._sPickedRandomColor=null;};
h.prototype.setDetailBox=function(o){var i=this.getDetailBox();if(o){if(o===i){return this;}if(i){this.detachPress(this._fnLightBoxOpen,i);}this._fnLightBoxOpen=o.open;this.attachPress(this._fnLightBoxOpen,o);}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,i);this._fnLightBoxOpen=null;}return this.setAggregation("detailBox",o);};
h.prototype.clone=function(){var o=C.prototype.clone.apply(this,arguments),i=o.getDetailBox();if(i){o.detachPress(this._fnLightBoxOpen,this.getDetailBox());o._fnLightBoxOpen=i.open;o.attachPress(o._fnLightBoxOpen,i);}return o;};
h.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button");}return this;};
h.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");this.$().attr("role","img");}return this;};
h.prototype.ontap=function(){this.firePress({});};
h.prototype.onkeydown=function(E){if(E.which===K.SHIFT||E.which===K.ESCAPE){this._bShouldInterupt=this._bSpacePressed;}if(E.which===K.SPACE){this._bSpacePressed=true;E.preventDefault();}if(E.which===K.ENTER){this.firePress({});}};
h.prototype.onkeyup=function(E){if(E.which===K.SPACE){if(!this._bShouldInterupt){this.firePress({});}this._bShouldInterupt=false;this._bSpacePressed=false;E.stopPropagation();}};
h.prototype._areInitialsValid=function(i){var v=/^[a-zA-Z]{1,2}$/;if(!v.test(i)){L.warning("Initials should consist of only 1 or 2 latin letters",this);this._sActualType=b.Icon;this._bIsDefaultIcon=true;return false;}return true;};
h.prototype._validateSrc=function(s){if(I.isIconURI(s)){this._sActualType=b.Icon;this._bIsDefaultIcon=I.getIconInfo(s)?false:true;}else{this._bIsDefaultIcon=true;this._sActualType=b.Image;this.preloadedImage=new window.Image();this.preloadedImage.src=s;this.preloadedImage.onload=this._onImageLoad.bind(this);this.preloadedImage.onerror=this._onImageError.bind(this);}return this;};
h.prototype._getDisplayIcon=function(s){return I.isIconURI(s)&&I.getIconInfo(s)?I.createControlByURI({src:s}):null;};
h.prototype._getActualDisplayType=function(){var s=this.getSrc(),i=this.getInitials();if(s){this._validateSrc(s);}else if(i&&this._areInitialsValid(i)){this._sActualType=b.Initials;}else{L.warning("No src and initials were provided",this);this._sActualType=b.Icon;this._bIsDefaultIcon=true;}return this._sActualType;};
h.prototype._getImageFallbackType=function(){var i=this.getInitials();this._sImageFallbackType=i&&this._areInitialsValid(i)?b.Initials:b.Icon;return this._sImageFallbackType;};
h.prototype._getDefaultIconPath=function(D){var s=null,F=this.getFallbackIcon();if(F&&I.isIconURI(F)){s=F;}else if(D===f.Circle){s=h.DEFAULT_CIRCLE_PLACEHOLDER;}else if(D===f.Square){s=h.DEFAULT_SQUARE_PLACEHOLDER;}return s;};
h.prototype._getIcon=function(){var s=this.getSrc(),i=this.getAggregation("_icon"),D=this.getDisplayShape();if(this._bIsDefaultIcon){s=this._getDefaultIconPath(D);}if(!i){i=I.createControlByURI({alt:"Image placeholder",src:s});this.setAggregation("_icon",i);}else if(i.getSrc()!==s){i.setSrc(s);}return i;};
h.prototype._getDefaultTooltip=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP");};
h.prototype._getBadgeIconSource=function(){var B;if(this.getDetailBox()){B="sap-icon://zoom-in";}else if(this.getBadgeIcon()!==""){if(this._getDisplayIcon(this.getBadgeIcon())){B=this.getBadgeIcon();}else{L.warning("No valid Icon URI source for badge affordance was provided");}}return B;};
h.prototype._getBadgeTooltip=function(){var B=this._getDefaultTooltip(),s=this.getBadgeIcon();if(this.getBadgeTooltip()){B=this.getBadgeTooltip();}else if(s&&h.AVATAR_BADGE_TOOLTIP[this.getBadgeIcon()]){B=h.AVATAR_BADGE_TOOLTIP[s];}return B;};
h.prototype._getBadge=function(){var B=this._getBadgeIconSource(),s=this._getBadgeTooltip();if(!B){return;}if(!this._badgeRef){this.setAggregation("_badge",new a({src:B,tooltip:s}));}this._badgeRef=this.getAggregation("_badge");return this._badgeRef;};
h.prototype._onImageLoad=function(){delete this.preloadedImage;};
h.prototype._onImageError=function(){var F=this._getImageFallbackType();this.$().removeClass("sapFAvatarImage").addClass("sapFAvatar"+F);delete this.preloadedImage;};
h.prototype._getActualBackgroundColor=function(){var B=this.getBackgroundColor();if(B===d.Random){if(this._sPickedRandomColor){return this._sPickedRandomColor;}B=this._sPickedRandomColor=d[g[g.length*Math.random()<<0]];}else{this._sPickedRandomColor=null;}return B;};
return h;});
sap.ui.predefine('sap/m/AvatarColor',[],function(){"use strict";var A={Accent1:"Accent1",Accent2:"Accent2",Accent3:"Accent3",Accent4:"Accent4",Accent5:"Accent5",Accent6:"Accent6",Accent7:"Accent7",Accent8:"Accent8",Accent9:"Accent9",Accent10:"Accent10",Random:"Random",Transparent:"Transparent",TileIcon:"TileIcon",Placeholder:"Placeholder"};return A;});
sap.ui.predefine('sap/m/AvatarImageFitType',[],function(){"use strict";var A={Cover:"Cover",Contain:"Contain"};return A;});
sap.ui.predefine('sap/m/AvatarRenderer',["sap/m/library","sap/base/security/encodeCSS"],function(l,e){"use strict";var A=l.AvatarSize;var a=l.AvatarType;var b={apiVersion:2};
b.render=function(r,o){var i=o.getInitials(),s=o._getActualDisplayType(),I=o._getImageFallbackType(),d=o.getDisplaySize(),D=o.getDisplayShape(),c=o.getImageFitType(),C=o.getCustomDisplaySize(),f=o.getCustomFontSize(),S=o.getSrc(),g="sapFAvatar",t=o.getTooltip_AsString(),L=o.getAriaLabelledBy(),h=o.getAriaDescribedBy(),B=o.hasListeners("press")?o._getBadge():null,j=o._getDefaultTooltip();r.openStart("span",o);r.class(g);r.class("sapFAvatarColor"+o._getActualBackgroundColor());r.class(g+d);r.class(g+s);r.class(g+D);if(o.hasListeners("press")){r.class("sapMPointer");r.class(g+"Focusable");r.attr("role","button");r.attr("tabindex",0);}else if(o.getDecorative()){r.attr("role","presentation");r.attr("aria-hidden","true");}else{r.attr("role","img");}if(o.getShowBorder()){r.class("sapFAvatarBorder");}if(d===A.Custom){r.style("width",C);r.style("height",C);r.style("font-size",f);}if(t){r.attr("title",t);r.attr("aria-label",t);}else if(i){r.attr("aria-label",j+" "+i);}else{r.attr("aria-label",j);}if(L&&L.length>0){r.attr("aria-labelledby",L.join(" "));}if(h&&h.length>0){r.attr("aria-describedby",h.join(" "));}r.openEnd();if(s===a.Icon||I===a.Icon){r.renderControl(o._getIcon().addStyleClass(g+"TypeIcon"));}else if(s===a.Initials||I===a.Initials){r.openStart("span");r.class(g+"InitialsHolder");r.openEnd();r.text(i);r.close("span");}if(s===a.Image){r.openStart("span");r.class(g+"ImageHolder");r.class(g+s+c);r.style("background-image","url('"+e(S)+"')");r.openEnd();r.close("span");}if(B){r.openStart("div");r.class(g+"BadgeIconActiveArea");if(C){r.style("font-size",C);}r.openEnd();r.openStart("span");r.class(g+"BadgeIcon");r.openEnd();r.renderControl(B);r.close("span");r.close("div");}r.close("span");};
return b;},true);
sap.ui.predefine('sap/m/AvatarShape',[],function(){"use strict";var A={Circle:"Circle",Square:"Square"};return A;});
sap.ui.predefine('sap/m/AvatarSize',[],function(){"use strict";var A={XS:"XS",S:"S",M:"M",L:"L",XL:"XL",Custom:"Custom"};return A;});
sap.ui.predefine('sap/m/AvatarType',[],function(){"use strict";var A={Icon:"Icon",Image:"Image",Initials:"Initials"};return A;});
sap.ui.predefine('sap/m/BadgeCustomData',['sap/ui/core/CustomData','sap/base/Log','sap/m/library'],function(C,L,l){"use strict";var B=l.BadgeAnimationType;
var a=C.extend("sap.m.BadgeCustomData",{metadata:{properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true},animation:{type:"sap.m.BadgeAnimationType",group:"Appearance",defaultValue:B.Full}}}});
a.prototype.init=function(){var p=this.getParent();if(p&&!p.isA("sap.m.IBadge")){L.warning("BadgeCustomData must be attached only to controls, which implement sap.m.IBadge");}};
a.prototype.setValue=function(v){if(this.getValue()===v){return this;}if(v===null||v===undefined){v="";}var p=this.getParent();v=v.toString();C.prototype.setValue.call(this,v);if(p){p.updateBadgeValue(v);}return this;};
a.prototype.setVisible=function(v){if(this.getVisible()===v){return this;}this.setProperty("visible",v,true);var p=this.getParent();if(p){p.updateBadgeVisibility(v);}return this;};
a.prototype.setAnimation=function(A){if(this.getAnimation()===A){return this;}this.setProperty("animation",A,true);var p=this.getParent();if(p){p.updateBadgeAnimation(A);}return this;};
a.prototype.setKey=function(){return this;};
return a;});
sap.ui.predefine('sap/m/BadgeEnabler',['sap/m/BadgeCustomData','sap/base/Log','sap/m/library'],function(B,L,l){"use strict";var I="sapMBadge";var a={topLeft:"sapMBadgeTopLeft",topRight:"sapMBadgeTopRight",inline:"sapMBadgeInline"};var b=l.BadgeState;var c=l.BadgeStyle;var d=["","undefined","null",false];var e=function(){this.initBadgeEnablement=function(C,o){var D=o?o:this;this._oBadgeConfig=C||{};D.addEventDelegate({onAfterRendering:f},this);};function _(C,o){if(C.suffix){return o.$(C.suffix);}if(C.selector){return o.$().find(C.selector).first();}}function f(){this._isBadgeAttached=false;if(!this.getBadgeCustomData()||!this.getBadgeCustomData().getVisible()){return false;}j.call(this);if(!Object.keys(this._oBadgeConfig).length){return this;}return this;}function g(){var o=h.call(this);o.removeClass("sapMBadgeAnimationUpdate");o.removeClass("sapMBadgeAnimationAdd");o.width();o.addClass("sapMBadgeAnimationRemove");o.on("animationend",function(){o.css("display","none");o.off();});o.removeAttr("aria-label");this._isBadgeAttached=false;m.call(this,"",b["Disappear"]);return this;}function h(){return this.$(I);}function i(){return this.getId()+"-"+I;}function j(){var o,s=i.call(this),p=h.call(this),q=typeof this.badgeValueFormatter==="function"&&this.badgeValueFormatter,v=n(q?q.call(this,this.getBadgeCustomData().getValue()):this.getBadgeCustomData().getValue())||"",S=this._oBadgeConfig.style?this._oBadgeConfig.style:c.Default,A=this.getBadgeCustomData().getAnimation();this._oBadgeContainer=this._oBadgeConfig&&this._oBadgeConfig.selector?_(this._oBadgeConfig.selector,this):this.$();if(p.length){p.remove();}o=jQuery('<div></div>').addClass(I+"Indicator");o.addClass(I+S);o.attr("id",s);o.attr("data-badge",v);o.attr("aria-label",k.call(this));o.appendTo(this._oBadgeContainer);o.addClass("sapMBadgeAnimationAdd");this._isBadgeAttached=true;this._oBadgeContainer.addClass(I);if(this._oBadgeConfig.position){this._oBadgeContainer.addClass(a[this._oBadgeConfig.position]);}if(this._oBadgeConfig.accentColor){this._oBadgeContainer.addClass(I+this._oBadgeConfig.accentColor);}this._oBadgeContainer.addClass(this.getBadgeAnimationClass(this.getBadgeCustomData().getAnimation()));this._badgeAnimaionType=A;m.call(this,v,b["Appear"]);}this.updateBadgeValue=function(v){var o=typeof this.badgeValueFormatter==="function"&&this.badgeValueFormatter,p;v=n((o?o.call(this,v):v))||"";if(!this.getBadgeCustomData().getVisible()){return false;}p=h.call(this);p.removeClass("sapMBadgeAnimationUpdate");p.attr("data-badge",v);p.attr("aria-label",k.call(this));p.width();p.addClass("sapMBadgeAnimationUpdate");m.call(this,v,b["Updated"]);};function k(){var A=this.getAriaLabelBadgeText;return A&&typeof A==="function"&&A.call(this);}function m(v,s){if(this.onBadgeUpdate&&typeof this.onBadgeUpdate==="function"){var o=i.call(this);return this.onBadgeUpdate(v,s,o);}}function n(v){return d.indexOf(v)===-1&&v;}this.addCustomData=function(C){if(C.isA("sap.m.BadgeCustomData")){this.removeAggregation("customData",this._oBadgeCustomData,true);this._oBadgeCustomData=C;this.addAggregation("customData",C,true);return this.updateBadgeVisibility(C.getVisible());}return this.addAggregation("customData",C);};this.insertCustomData=function(C){if(C.isA("sap.m.BadgeCustomData")){this.removeAggregation("customData",this._oBadgeCustomData,true);this._oBadgeCustomData=C;this.addAggregation("customData",C,true);return this.updateBadgeVisibility(C.getVisible());}return this.insertAggregation("customData",C);};this.getBadgeCustomData=function(){var o=this.getCustomData().filter(function(p){return p instanceof B;});return o.length?o[0]:undefined;};this.getBadgeAnimationClass=function(A){return I+"AnimationType"+A;};this.removeBadgeCustomData=function(){var o;o=this._oBadgeCustomData;this._oBadgeCustomData=null;return this.removeAggregation("customData",o,true);};this.setBadgeAccentColor=function(v){if(!this._oBadgeContainer){return false;}this._oBadgeContainer.removeClass(I+this._oBadgeConfig.accentColor);this._oBadgeContainer.addClass(I+v);this._oBadgeConfig.accentColor=v;};this.setBadgePosition=function(v){if(!this._oBadgeContainer){return false;}this._oBadgeContainer.removeClass(I+this._oBadgeConfig.position);this._oBadgeContainer.addClass(a[v]);this._oBadgeConfig.position=v;};this.updateBadgeVisibility=function(v){return v?j.call(this):g.call(this);};this._renderBadge=function(){f.call(this);};this.updateBadgeAnimation=function(A){if(this._oBadgeContainer){this._badgeAnimaionType&&this._oBadgeContainer.removeClass(this.getBadgeAnimationClass(this._badgeAnimaionType));this._oBadgeContainer.addClass(this.getBadgeAnimationClass(A));}this._badgeAnimaionType=A;};};return e;});
sap.ui.predefine('sap/m/Bar',['./BarInPageEnabler','./library','sap/ui/core/Control','sap/ui/core/ResizeHandler','sap/ui/Device','./BarRenderer',"sap/ui/thirdparty/jquery"],function(B,l,C,R,D,a,q){"use strict";var b=l.BarDesign;var T=l.TitleAlignment;
var c=C.extend("sap.m.Bar",{metadata:{interfaces:["sap.m.IBar"],library:"sap.m",properties:{enableFlexBox:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},translucent:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},design:{type:"sap.m.BarDesign",group:"Appearance",defaultValue:b.Auto},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:T.None}},aggregations:{contentLeft:{type:"sap.ui.core.Control",multiple:true,singularName:"contentLeft"},contentMiddle:{type:"sap.ui.core.Control",multiple:true,singularName:"contentMiddle"},contentRight:{type:"sap.ui.core.Control",multiple:true,singularName:"contentRight"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/m/designtime/Bar.designtime",dnd:{draggable:false,droppable:true}}});
c.prototype.onBeforeRendering=function(){var s=this.getTitleAlignment(),A;this._removeAllListeners();for(A in T){if(A!==s){this.removeStyleClass("sapMBarTitleAlign"+A);}else{this.addStyleClass("sapMBarTitleAlign"+A);}}};
c.prototype.onAfterRendering=function(){this._handleResize();};
c.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);this._sPrevTitleAlignmentClass="";};
c.prototype.exit=function(){this._removeAllListeners();if(this._oflexBox){this._oflexBox.destroy();this._oflexBox=null;}this._$MidBarPlaceHolder=null;this._$RightBar=null;this._$LeftBar=null;};
c._aResizeHandlers=["_sResizeListenerId","_sResizeListenerIdMid","_sResizeListenerIdRight","_sResizeListenerIdLeft"];
c.prototype._removeAllListeners=function(){var t=this;c._aResizeHandlers.forEach(function(i){t._removeListenerFailsave(i);});};
c.prototype._removeListenerFailsave=function(L){if(this[L]){R.deregister(this[L]);this[L]=null;}};
c.prototype._handleResize=function(){this._removeAllListeners();var e=!!this.getContentLeft().length,f=!!this.getContentMiddle().length||(this._oflexBox&&!!this._oflexBox.getItems().length),g=!!this.getContentRight().length;if(!this.getVisible()){return;}if(!e&&!f&&!g){return;}this._$LeftBar=this.$("BarLeft");this._$RightBar=this.$("BarRight");this._$MidBarPlaceHolder=this.$("BarPH");this._updatePosition(e,f,g);this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._handleResize,this));if(this.getEnableFlexBox()){return;}if(e){this._sResizeListenerIdLeft=R.register(this._$LeftBar[0],q.proxy(this._handleResize,this));}if(f){this._sResizeListenerIdMid=R.register(this._$MidBarPlaceHolder[0],q.proxy(this._handleResize,this));}if(g){this._sResizeListenerIdRight=R.register(this._$RightBar[0],q.proxy(this._handleResize,this));}};
c.prototype._updatePosition=function(e,f,g){if(!e&&!g&&f){return;}if(e&&!f&&!g){return;}if(!e&&!f&&g){return;}var i=this.$().outerWidth(true);this._$RightBar.css({width:""});this._$LeftBar.css({width:""});this._$MidBarPlaceHolder.css({position:"",width:"",visibility:"hidden"});var r=this._$RightBar.outerWidth(true);if(r>i){if(e){this._$LeftBar.css({width:"0px"});}if(f){this._$MidBarPlaceHolder.css({width:"0px"});}this._$RightBar.css({width:i+"px"});return;}var L=this._getBarContainerWidth(this._$LeftBar);if(i<(L+r)){L=i-r;this._$LeftBar.css({width:L+"px"});this._$MidBarPlaceHolder.css({width:"0px"});return;}this._$MidBarPlaceHolder.css(this._getMidBarCss(r,i,L));};
c.prototype._getMidBarCss=function(r,i,L){var m=this._$MidBarPlaceHolder.outerWidth(true),e=sap.ui.getCore().getConfiguration().getRTL(),s=e?"right":"left",f=e?"left":"right",M={visibility:""},g=this.getContentLeft().filter(function(v){return v.getVisible();}),h=this.getContentRight().filter(function(v){return v.getVisible();}),j=g.length?0:parseInt(this._$LeftBar.css('padding-'+s)),k=h.length?0:parseInt(this._$RightBar.css('padding-'+f));if(this.getEnableFlexBox()){m=i-L-r-parseInt(this._$MidBarPlaceHolder.css('margin-left'))-parseInt(this._$MidBarPlaceHolder.css('margin-right'));M.position="absolute";M.width=m+j+k+"px";M[s]=L-j;return M;}var S=i-L-r,n=(i/2)-(m/2),o=L>n,p=(i/2)+(m/2),t=(i-r)<p,u=this.getTitleAlignment();if((u!==T.None&&u!==T.Center)||(S>0&&(o||t))){M.position="absolute";M.width=S+j+k+"px";M[s]=L-j;}return M;};
c.prototype._getBarContainerWidth=function($){var i,e=0,f=$.children(),g=0;if(D.browser.webkit||D.browser.firefox){for(i=0;i<f.length;i++){g+=q(f[i]).outerWidth(true);}e=$.outerWidth(true);}else{var o;for(i=0;i<f.length;i++){o=window.getComputedStyle(f[i]);if(o.width=="auto"){g+=q(f[i]).width()+1;}else{g+=parseFloat(o.width);}g+=parseFloat(o.marginLeft);g+=parseFloat(o.marginRight);g+=parseFloat(o.paddingLeft);g+=parseFloat(o.paddingRight);}var h=window.getComputedStyle($[0]);e+=parseFloat(h.width);e+=parseFloat(h.marginLeft);e+=parseFloat(h.marginRight);e+=parseFloat(h.paddingLeft);e+=parseFloat(h.paddingRight);}if(e<g){e=g;}return e;};
var d=B.extend("sap.m.BarInAnyContentEnabler",{});
d.mContexts={dialogFooter:{contextClass:"sapMFooter-CTX",tag:"Footer"}};
d.prototype.getContext=function(){var p=B.prototype.getContext.call();for(var k in d.mContexts){p[k]=d.mContexts[k];}return p;};
c.prototype.getContext=d.prototype.getContext;c.prototype.isContextSensitive=d.prototype.isContextSensitive;c.prototype.setHTMLTag=d.prototype.setHTMLTag;c.prototype.getHTMLTag=d.prototype.getHTMLTag;c.prototype.applyTagAndContextClassFor=d.prototype.applyTagAndContextClassFor;c.prototype._applyContextClassFor=d.prototype._applyContextClassFor;c.prototype._applyTag=d.prototype._applyTag;c.prototype._getContextOptions=d.prototype._getContextOptions;c.prototype._setRootAccessibilityRole=d.prototype._setRootAccessibilityRole;c.prototype._getRootAccessibilityRole=d.prototype._getRootAccessibilityRole;c.prototype._setRootAriaLevel=d.prototype._setRootAriaLevel;c.prototype._getRootAriaLevel=d.prototype._getRootAriaLevel;return c;});
sap.ui.predefine('sap/m/BarInPageEnabler',['sap/ui/base/Object','sap/m/library',"sap/base/Log"],function(O,l,L){"use strict";var I=l.IBarHTMLTag;var c={footer:{contextClass:"sapMFooter-CTX sapContrast sapContrastPlus",tag:"Footer",internalAriaLabel:"BAR_ARIA_DESCRIPTION_FOOTER"},header:{contextClass:"sapMHeader-CTX",tag:"Header",internalAriaLabel:"BAR_ARIA_DESCRIPTION_HEADER"},subheader:{contextClass:"sapMSubHeader-CTX",tag:"Header",internalAriaLabel:"BAR_ARIA_DESCRIPTION_SUBHEADER"}};var a="sapMIBar";
var B=O.extend("sap.m.BarInPageEnabler",{
isContextSensitive:function(){return this.getDesign&&this.getDesign()==="Auto";},
setHTMLTag:function(n){if(n===this.sTag){return this;}this.sTag=n;return this;},
getHTMLTag:function(){if(!this.hasOwnProperty("sTag")){this.sTag=I.Div;}return this.sTag;},
getContext:function(){return c;},
_getRootAccessibilityRole:function(){var r=this._sRootAccessibilityRole||"toolbar";return r;},
_setRootAccessibilityRole:function(r){this._sRootAccessibilityRole=r;return this;},
_getRootAriaLevel:function(){var A=this.sAriaLevel;return A;},
_setRootAriaLevel:function(s){this.sAriaLevel=s;return this;},
applyTagAndContextClassFor:function(C){this._applyTag(C);return this._applyContextClassFor(C);},
_applyContextClassFor:function(C){var o=this._getContextOptions(C);if(!o){return this;}if(!this.isContextSensitive){L.error("The bar control you are using does not implement all the members of the IBar interface",this);return this;}if(!this.getRenderer().shouldAddIBarContext()){this.addStyleClass(a+"-CTX");}if(this.isContextSensitive()){this.addStyleClass(o.contextClass);}return this;},
_applyTag:function(C){var o=this._getContextOptions(C);if(!o){return this;}if(!this.setHTMLTag){L.error("The bar control you are using does not implement all the members of the IBar interface",this);return this;}this.setHTMLTag(o.tag);return this;},
_getContextOptions:function(C){var o;if(this.getContext){o=this.getContext();}else{o=c;}var b=o[C];if(!b){L.error("The context "+C+" is not known",this);return null;}return b;},
render:function(r,C){var t=C.getHTMLTag().toLowerCase();r.openStart(t,C);r.class(a);if(this.shouldAddIBarContext(C)){r.class(a+"-CTX");}B.renderTooltip(r,C);this.decorateRootElement(r,C);r.openEnd();this.renderBarContent(r,C);r.close(t);}
});
B.renderTooltip=function(r,C){var t=C.getTooltip_AsString();if(t){r.attr("title",t);}};
B.addChildClassTo=function(C){C.addStyleClass("sapMBarChild");};
return B;});
sap.ui.predefine('sap/m/BarRenderer',['./BarInPageEnabler','sap/ui/Device',"sap/base/Log",'sap/m/HBox'],function(B,D,L,H){"use strict";var a={apiVersion:2};a.render=B.prototype.render;
a.decorateRootElement=function(r,c){r.class("sapMBar");r.class(this.getContext(c));r.accessibilityState(c,{"role":c._getRootAccessibilityRole(),"level":c._getRootAriaLevel()});if(c.getTranslucent()&&D.support.touch){r.class("sapMBarTranslucent");}r.class("sapMBar-CTX");};
a.shouldAddIBarContext=function(){return true;};
a.renderBarContent=function(r,c){r.openStart("div",c.getId()+"-BarLeft");r.class("sapMBarLeft");r.class("sapMBarContainer");w("left",r,c);r.openEnd();this.renderAllControls(c.getContentLeft(),r,c);r.close("div");r.openStart("div",c.getId()+"-BarMiddle");r.class("sapMBarMiddle");r.openEnd();if(c.getEnableFlexBox()){c._oflexBox=c._oflexBox||new H(c.getId()+"-BarPH",{alignItems:"Center"}).addStyleClass("sapMBarPH").setParent(c,null,true);var C=!!c.getContentLeft().length,b=!!c.getContentMiddle().length,d=!!c.getContentRight().length;if(b&&!C&&!d){c._oflexBox.addStyleClass("sapMBarFlexBoxWidth100");}c.getContentMiddle().forEach(function(m){c._oflexBox.addItem(m);});r.renderControl(c._oflexBox);}else{r.openStart("div",c.getId()+"-BarPH");r.class("sapMBarPH");r.class("sapMBarContainer");w("middle",r,c);r.openEnd();this.renderAllControls(c.getContentMiddle(),r,c);r.close("div");}r.close("div");r.openStart("div",c.getId()+"-BarRight");r.class("sapMBarRight");r.class("sapMBarContainer");if(sap.ui.getCore().getConfiguration().getRTL()){r.class("sapMRTL");}w("right",r,c);r.openEnd();this.renderAllControls(c.getContentRight(),r,c);r.close("div");};
a.renderAllControls=function(c,r,b){c.forEach(function(C){B.addChildClassTo(C,b);r.renderControl(C);});};
a._mContexts={Header:"sapMHeader-CTX",SubHeader:"sapMSubHeader-CTX",Footer:"sapMFooter-CTX",Default:"sapMContent-CTX"};
a.getContext=function(c){var d=c.getDesign(),C=a._mContexts;return C[d]||C.Default;};
function w(A,r,c){var C=!!c.getContentLeft().length,b=!!c.getContentMiddle().length,d=!!c.getContentRight().length;switch(A.toLowerCase()){case"left":if(C&&!b&&!d){r.style("width","100%");}break;case"middle":if(b&&!C&&!d){r.style("width","100%");}break;case"right":if(d&&!C&&!b){r.style("width","100%");}break;default:L.error("Cannot determine which of the three content aggregations is alone");}}
return a;},true);
sap.ui.predefine('sap/m/Breadcrumbs',["sap/ui/core/Control","sap/ui/util/openWindow","sap/m/Text","sap/m/Link","sap/m/Select","sap/ui/core/Item","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","sap/ui/core/IconPool","sap/ui/Device","sap/m/library","./BreadcrumbsRenderer",'sap/ui/base/ManagedObject','sap/ui/core/InvisibleText'],function(C,o,T,L,S,I,a,R,b,D,l,B,M,c){"use strict";var d=l.SelectType,e=l.BreadcrumbsSeparatorStyle;
var f=C.extend("sap.m.Breadcrumbs",{metadata:{library:"sap.m",interfaces:["sap.m.IBreadcrumbs"],designtime:"sap/m/designtime/Breadcrumbs.designtime",properties:{currentLocationText:{type:"string",group:"Behavior",defaultValue:null},separatorStyle:{type:"sap.m.BreadcrumbsSeparatorStyle",group:"Appearance",defaultValue:e.Slash}},aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},_currentLocation:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}},defaultAggregation:"links",associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
f.STYLE_MAPPER={Slash:"/",BackSlash:"\\",DoubleSlash:"//",DoubleBackSlash:"\\\\",GreaterThan:">",DoubleGreaterThan:">>"};
f.prototype.init=function(){this._sSeparatorSymbol=f.STYLE_MAPPER[this.getSeparatorStyle()];this._getInvisibleText();};
f.prototype.onBeforeRendering=function(){this.bRenderingPhase=true;if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._bControlsInfoCached){this._updateSelect(true);}};
f.prototype.onAfterRendering=function(){if(!this._sResizeListenerId){this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));}if(!this._bControlsInfoCached){this._updateSelect(true);return;}this._configureKeyboardHandling();this.bRenderingPhase=false;};
f.prototype.onThemeChanged=function(){this._resetControl();};
f.prototype.exit=function(){this._resetControl();this._destroyItemNavigation();if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null;}};
f.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
f.prototype._getAugmentedId=function(s){return this.getId()+"-"+s;};
f.prototype._getInvisibleText=function(){var A=B._getResourceBundleText("BREADCRUMB_LABEL");if(!this._oInvisibleText){this._oInvisibleText=new c({id:this.getId()+"-InvisibleText"});this._oInvisibleText.setText(A).toStatic();}return this._oInvisibleText;};
f.prototype._getSelect=function(){if(!this.getAggregation("_select")){this.setAggregation("_select",this._decorateSelect(new S({id:this._getAugmentedId("select"),change:this._selectChangeHandler.bind(this),forceSelection:false,autoAdjustWidth:true,icon:b.getIconURI("slim-arrow-down"),type:d.IconOnly,tooltip:B._getResourceBundleText("BREADCRUMB_SELECT_TOOLTIP")})),true);}return this.getAggregation("_select");};
f.prototype._getCurrentLocation=function(){if(!this.getAggregation("_currentLocation")){var i=new T({id:this._getAugmentedId("currentText"),text:this.getCurrentLocationText(),wrapping:false}).addStyleClass("sapMBreadcrumbsCurrentLocation");i.addEventDelegate({onAfterRendering:function(){i.$().attr("aria-current","page");i.$().attr("tabindex",0);}});this.setAggregation("_currentLocation",i).addStyleClass("sapMBreadcrumbsCurrentLocation");}return this.getAggregation("_currentLocation");};
function g(A,i){var j=Array.prototype.slice.apply(i);j.unshift(A);return j;}
f.prototype.insertLink=function(i,j){var r=this.insertAggregation.apply(this,g("links",arguments));this._registerControlListener(i);this._resetControl();return r;};
f.prototype.addLink=function(i){var r=this.addAggregation.apply(this,g("links",arguments));this._registerControlListener(i);this._resetControl();return r;};
f.prototype.removeLink=function(O){var r=this.removeAggregation.apply(this,g("links",arguments));this._deregisterControlListener(r);this._resetControl();return r;};
f.prototype.removeAllLinks=function(){var i=this.getAggregation("links",[]);var r=this.removeAllAggregation.apply(this,g("links",arguments));i.forEach(this._deregisterControlListener,this);this._resetControl();return r;};
f.prototype.destroyLinks=function(){var i=this.getAggregation("links",[]);var r=this.destroyAggregation.apply(this,g("links",arguments));i.forEach(this._deregisterControlListener,this);this._resetControl();return r;};
f.prototype._decorateSelect=function(s){s.getPicker().attachAfterOpen(this._removeItemNavigation,this).attachBeforeClose(this._restoreItemNavigation,this);s._onBeforeOpenDialog=this._onSelectBeforeOpenDialog.bind(this);s._onBeforeOpenPopover=this._onSelectBeforeOpenPopover.bind(this);s.onsapescape=this._onSelectEscPress.bind(this);return s;};
f.prototype._removeItemNavigation=function(){this.removeDelegate(this._getItemNavigation());};
f.prototype._onSelectBeforeOpenDialog=function(){var s=this._getSelect();if(this.getCurrentLocationText()&&D.system.phone){s.setSelectedIndex(0);}else{s.setSelectedItem(null);}S.prototype._onBeforeOpenDialog.call(s);this._removeItemNavigation();};
f.prototype._onSelectBeforeOpenPopover=function(){this._getSelect().setSelectedItem(null);this._removeItemNavigation();};
f.prototype._restoreItemNavigation=function(){this.addDelegate(this._getItemNavigation());};
f.prototype._onSelectEscPress=function(){this._getSelect().close();};
f.prototype._createSelectItem=function(i){return new I({key:i.getId(),text:M.escapeSettingsValue(i.getText())});};
f.prototype._selectChangeHandler=function(E){var i,s,j,k=E.getParameter("selectedItem");if(!k){return;}if(!this._getSelect().isOpen()){return;}i=sap.ui.getCore().byId(k.getKey());if(!(i instanceof L)){return;}s=i.getHref();j=i.getTarget();i.firePress();if(s){if(j){o(s,j);}else{window.location.href=s;}}};
f.prototype._getItemsForMobile=function(){var i=this.getLinks().filter(function(j){return j.getVisible();});if(this.getCurrentLocationText()){i.push(this._getCurrentLocation());}return i;};
f.prototype._updateSelect=function(i){var s=this._getSelect(),j,k=this._getControlDistribution();if(!this._bControlDistributionCached||i){s.destroyItems();j=D.system.phone?this._getItemsForMobile():k.aControlsForSelect;j.map(this._createSelectItem).reverse().forEach(s.insertItem,s);this._bControlDistributionCached=true;this.invalidate(this);}s.setVisible(!!k.aControlsForSelect.length);if(!this._sResizeListenerId&&!this.bRenderingPhase){this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));}};
f.prototype._getControlsForBreadcrumbTrail=function(){var v;if(this._bControlDistributionCached&&this._oDistributedControls){return this._oDistributedControls.aControlsForBreadcrumbTrail;}v=this.getLinks().filter(function(i){return i.getVisible();});if(this.getCurrentLocationText()){return v.concat([this._getCurrentLocation()]);}return v;};
f.prototype._getControlInfo=function(i){return{id:i.getId(),control:i,width:h(i.$().parent()),bCanOverflow:i instanceof L};};
f.prototype._getControlDistribution=function(m){m=m||this._iContainerSize;this._iContainerSize=m;this._oDistributedControls=this._determineControlDistribution(m);return this._oDistributedControls;};
f.prototype._getSelectWidth=function(){return this._getSelect().getVisible()&&this._iSelectWidth||0;};
f.prototype._determineControlDistribution=function(m){var i,j,k=this._getControlsInfo().aControlInfo,s=this._getSelectWidth(),n=[],p=[],u=s;for(i=k.length-1;i>=0;i--){j=k[i];u+=j.width;if(k.length-1===i){p.push(j.control);continue;}if(i===0){u-=s;}if(u>m&&j.bCanOverflow){n.unshift(j.control);}else{p.unshift(j.control);}}return{aControlsForBreadcrumbTrail:p,aControlsForSelect:n};};
f.prototype._getControlsInfo=function(){if(!this._bControlsInfoCached){this._iSelectWidth=h(this._getSelect().$().parent())||0;this._aControlInfo=this._getControlsForBreadcrumbTrail().map(this._getControlInfo);this._iContainerSize=Math.ceil(h(this.$()));this._bControlsInfoCached=true;}return{aControlInfo:this._aControlInfo,iSelectWidth:this._iSelectWidth,iContentSize:this._iContainerSize};};
f.prototype._handleScreenResize=function(E){var i,j,k;if(E.size.width===E.oldSize.width||E.size.width===0){return this;}i=this._oDistributedControls.aControlsForBreadcrumbTrail.length;j=this._getControlDistribution(Math.ceil(h(this.$())));k=j.aControlsForBreadcrumbTrail.length;if(i!==k){this._updateSelect(true);}return this;};
f.prototype._getItemsToNavigate=function(){var i=this._getControlsForBreadcrumbTrail().slice(),s=this._getSelect();if(s.getVisible()){i.unshift(s);}return i;};
f.prototype._getItemNavigation=function(){if(!this._itemNavigation){this._itemNavigation=new a();}return this._itemNavigation;};
f.prototype._destroyItemNavigation=function(){if(this._itemNavigation){this.removeEventDelegate(this._itemNavigation);this._itemNavigation.destroy();this._itemNavigation=null;}};
f.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),s=-1,j=this._getItemsToNavigate(),n=[];if(j.length===0){return;}j.forEach(function(k,m){if(m===0){k.$().attr("tabindex","0");}k.$().attr("tabindex","-1");n.push(k.getFocusDomRef());});this.addDelegate(i);i.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});i.setCycling(false);i.setPageSize(f.PAGEUP_AND_PAGEDOWN_JUMP_SIZE);i.setRootDomRef(this.getDomRef());i.setItemDomRefs(n);i.setSelectedIndex(s);return this;};
f.prototype._registerControlListener=function(i){if(i){i.attachEvent("_change",this._resetControl,this);}};
f.prototype._deregisterControlListener=function(i){if(i){i.detachEvent("_change",this._resetControl,this);}};
f.prototype.setCurrentLocationText=function(t){var i=this._getCurrentLocation(),r=this.setProperty("currentLocationText",t,true);if(i.getText()!==t){i.setText(t);this._resetControl();}return r;};
f.prototype.setSeparatorStyle=function(s){this.setProperty("separatorStyle",s);var i=f.STYLE_MAPPER[this.getSeparatorStyle()];if(i){this._sSeparatorSymbol=i;}return this;};
f.prototype._resetControl=function(){this._aControlInfo=null;this._iContainerSize=null;this._bControlsInfoCached=null;this._bControlDistributionCached=null;this._oDistributedControls=null;if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.removeDelegate(this._getItemNavigation());this.invalidate(this);return this;};
function h($){var m;if($.length){m=$.outerWidth(true)-$.outerWidth();return $.get(0).getBoundingClientRect().width+m;}}
return f;});
sap.ui.predefine('sap/m/BreadcrumbsRenderer',["sap/m/Text"],function(T){"use strict";var B={apiVersion:2};var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
B.render=function(R,c){var C=c._getControlsForBreadcrumbTrail(),s=c._getSelect(),S=c._sSeparatorSymbol,d=c._getInvisibleText().getId(),a=c.getAriaLabelledBy().slice();R.openStart("nav",c);R.class("sapMBreadcrumbs");a.push(d);R.accessibilityState(null,{labelledby:{value:a.join(" "),append:true}});R.openEnd();R.openStart("ol");R.openEnd();if(s.getVisible()){this._renderControlInListItem(R,s,S,false,"sapMBreadcrumbsSelectItem");}C.forEach(function(o){this._renderControlInListItem(R,o,S,o instanceof T);},this);R.close("ol");R.close("nav");};
B._renderControlInListItem=function(R,c,s,S,a){R.openStart("li");R.class("sapMBreadcrumbsItem");R.class(a);R.openEnd();R.renderControl(c);if(!S){R.openStart("span").class("sapMBreadcrumbsSeparator").openEnd().text(s).close("span");}R.close("li");};
B._getResourceBundleText=function(t){return r.getText(t);};
return B;},true);
sap.ui.predefine('sap/m/BusyDialog',['./library','sap/ui/core/Control','sap/m/Dialog','sap/m/BusyIndicator','sap/m/Label','sap/m/Button',"sap/base/Log",'sap/ui/core/Core','sap/ui/core/InvisibleText'],function(l,C,D,B,L,a,b,c,I){"use strict";var T=l.TitleAlignment;
var d=C.extend("sap.m.BusyDialog",{
metadata:{library:"sap.m",properties:{text:{type:"string",group:"Appearance",defaultValue:''},title:{type:"string",group:"Appearance",defaultValue:''},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1000},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},cancelButtonText:{type:"string",group:"Misc",defaultValue:''},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:false},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:T.Auto}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{close:{parameters:{cancelPressed:{type:"boolean"}}}},designtime:"sap/m/designtime/BusyDialog.designtime"},
renderer:{apiVersion:2,render:function(r,o){}}
});
d.prototype.init=function(){this._busyIndicator=new B(this.getId()+'-busyInd',{visible:true});this._oDialog=new D(this.getId()+'-Dialog',{content:this._busyIndicator,titleAlignment:this.getTitleAlignment(),showHeader:false,afterClose:this._fnCloseHandler.bind(this),initialFocus:this._busyIndicator.getId()+'-busyIndicator'}).addStyleClass('sapMBusyDialog');this._oDialog.close=function(){};this._oDialog.addEventDelegate({onBeforeRendering:function(){var t=this.getText(),e=this.getTitle(),s=this.getShowCancelButton()||this.getCancelButtonText();if(!t&&!e&&!s){this._oDialog.addStyleClass('sapMBusyDialog-Light');}else{this._oDialog.removeStyleClass('sapMBusyDialog-Light');}}},this);this._oDialog.oPopup.onsapescape=function(e){this.close(true);}.bind(this);};
d.prototype.exit=function(){if(this._iOpenTimer){clearTimeout(this._iOpenTimer);this._iOpenTimer=null;}this._busyIndicator.destroy();this._busyIndicator=null;if(this._cancelButton){this._cancelButton.destroy();this._cancelButton=null;}if(this._oLabel){this._oLabel.destroy();this._oLabel=null;}if(this._oDialog){this._oDialog.destroy();this._oDialog=null;}};
d.prototype.open=function(){var A=this.getAriaLabelledBy();b.debug("sap.m.BusyDialog.open called at "+new Date().getTime());if(A&&A.length){if(!this._oDialog._$dialog){var t=this;A.forEach(function(i){t._oDialog.addAriaLabelledBy(i);});}}else if(!this._oDialog.getShowHeader()){this._oDialog.addAriaLabelledBy(I.getStaticId("sap.m","BUSYDIALOG_TITLE"));}else{this._oDialog.removeAriaLabelledBy(I.getStaticId("sap.m","BUSYDIALOG_TITLE"));}if(!document.body||!c.isInitialized()){this._iOpenTimer=setTimeout(function(){this.open();}.bind(this),50);}else{this._oDialog.open();}return this;};
d.prototype.close=function(i){this._isClosedFromUserInteraction=i;if(this._iOpenTimer){clearTimeout(this._iOpenTimer);this._iOpenTimer=null;}D.prototype.close.call(this._oDialog);return this;};
d.prototype._fnCloseHandler=function(){this.fireClose({cancelPressed:this._isClosedFromUserInteraction||false});};
d.prototype.setTitle=function(t){this.setProperty('title',t,true);this._oDialog.setTitle(t).setShowHeader(!!t);return this;};
d.prototype.setTitleAlignment=function(A){this.setProperty("titleAlignment",A,true);if(this._oDialog){this._oDialog.setTitleAlignment(A);}return this;};
d.prototype.setTooltip=function(t){this._oDialog.setTooltip(t);return this;};
d.prototype.getTooltip=function(){return this._oDialog.getTooltip();};
d.prototype.setText=function(t){this.setProperty('text',t,true);if(!this._oLabel){if(t){this._oLabel=new L(this.getId()+'-TextLabel',{text:t}).addStyleClass('sapMBusyDialogLabel');this._oDialog.insertAggregation('content',this._oLabel,0);this._oDialog.addAriaLabelledBy(this._oLabel.getId());}}else{if(t){this._oLabel.setText(t).setVisible(true);}else{this._oLabel.setVisible(false);}}return this;};
d.prototype.setCustomIcon=function(i){this.setProperty("customIcon",i,true);this._busyIndicator.setCustomIcon(i);return this;};
d.prototype.setCustomIconRotationSpeed=function(s){this.setProperty("customIconRotationSpeed",s,true);this._busyIndicator.setCustomIconRotationSpeed(s);return this;};
d.prototype.setCustomIconDensityAware=function(i){this.setProperty("customIconDensityAware",i,true);this._busyIndicator.setCustomIconDensityAware(i);return this;};
d.prototype.setCustomIconWidth=function(w){this.setProperty("customIconWidth",w,true);this._busyIndicator.setCustomIconWidth(w);return this;};
d.prototype.setCustomIconHeight=function(h){this.setProperty("customIconHeight",h,true);this._busyIndicator.setCustomIconHeight(h);return this;};
d.prototype.setShowCancelButton=function(i){this.setProperty("showCancelButton",i,false);if(i){this._oDialog.setEndButton(this._getCancelButton());}else{this._destroyTheCancelButton();}return this;};
d.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,false);if(t){this._getCancelButton().setText(t);this._oDialog.setEndButton(this._getCancelButton());}else{this._destroyTheCancelButton();}return this;};
d.prototype.getDomRef=function(){return this._oDialog&&this._oDialog.getDomRef();};
["addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass"].forEach(function(A){d.prototype[A]=function(){if(this._oDialog&&this._oDialog[A]){this._oDialog[A].apply(this._oDialog,arguments);return this;}};});
d.prototype._destroyTheCancelButton=function(){this._oDialog.destroyEndButton();this._cancelButton=null;};
d.prototype._getCancelButton=function(){var e=this.getCancelButtonText();e=e?e:c.getLibraryResourceBundle("sap.m").getText("BUSYDIALOG_CANCELBUTTON_TEXT");return this._cancelButton?this._cancelButton:this._cancelButton=new a(this.getId()+'busyCancelBtn',{text:e,press:function(){this.close(true);}.bind(this)});};
return d;});
sap.ui.predefine('sap/m/BusyIndicator',['./library','sap/ui/core/Control','sap/ui/core/library','sap/m/Image','sap/m/Label',"./BusyIndicatorRenderer"],function(l,C,c,I,L,B){"use strict";var T=c.TextDirection;
var a=C.extend("sap.m.BusyIndicator",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Data",defaultValue:""},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},customIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1000},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},size:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"1rem"},design:{type:"string",group:"Appearance",defaultValue:"auto",deprecated:true}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
a.prototype.init=function(){this.setBusyIndicatorDelay(0);};
a.prototype.onBeforeRendering=function(){if(this.getCustomIcon()){this.setBusy(false);}else{this.setBusy(true,"busy-area");}if(this._busyLabel){this._busyLabel.setTextDirection(this.getTextDirection());}if(this._iconImage){this._iconImage.setDensityAware(this.getCustomIconDensityAware());this._iconImage.setSrc(this.getCustomIcon());this._iconImage.setWidth(this.getCustomIconWidth());this._iconImage.setHeight(this.getCustomIconHeight());}else if(!this._iconImage&&this.getCustomIcon()){this._createCustomIcon(this.getCustomIcon()).addStyleClass("sapMBsyIndIcon");}if(this._busyLabel){this._busyLabel.setText(this.getText());this._busyLabel.setTextDirection(this.getTextDirection());}else if(!this._busyLabel&&this.getText()){this._createLabel(this.getText());}};
a.prototype.onAfterRendering=function(){this._setRotationSpeed();};
a.prototype.exit=function(){if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._busyLabel){this._busyLabel.destroy();this._busyLabel=null;}};
a.prototype._createCustomIcon=function(i){this._iconImage=new I(this.getId()+"-icon",{src:i,width:this.getCustomIconWidth(),height:this.getCustomIconHeight(),densityAware:this.getCustomIconDensityAware()});return this._iconImage;};
a.prototype._createLabel=function(t){this._busyLabel=new L(this.getId()+"-label",{labelFor:this.getId(),text:t,textAlign:"Center",textDirection:this.getTextDirection()});return this._busyLabel;};
a.prototype._setRotationSpeed=function(){if(!this._iconImage){return;}var i=this.getCustomIconRotationSpeed();if(i===this.getMetadata().getProperty("customIconRotationSpeed").getDefaultValue()){return;}i=Math.max(0,i);var $=this._iconImage.$();var r=i+"ms";$.css("animation-duration",r);$.css("display","none");setTimeout(function(){$.css("display","inline");},0);};
return a;});
sap.ui.predefine('sap/m/BusyIndicatorRenderer',[],function(){"use strict";var B={apiVersion:2};
B.render=function(r,b){var t=b.getTooltip_AsString();r.openStart("div",b).class("sapMBusyIndicator");r.style("font-size",b.getSize());r.accessibilityState(b);if(t){r.attr("title",t);}r.openEnd();if(b.getCustomIcon()){r.renderControl(b._iconImage);}else{r.openStart("div",b.getId()+"-busy-area");r.class("sapMBusyIndicatorBusyArea").openEnd().close("div");}if(b._busyLabel){r.renderControl(b._busyLabel);}r.close("div");};
return B;},true);
sap.ui.predefine('sap/m/Button',["./library","sap/ui/core/Control","sap/ui/core/ShortcutHintsMixin","sap/ui/core/EnabledPropagator","sap/ui/core/IconPool","sap/ui/Device","sap/ui/core/ContextMenuSupport","sap/ui/core/library","./ButtonRenderer","sap/ui/events/KeyCodes","sap/ui/core/LabelEnablement","sap/m/BadgeEnabler","sap/ui/core/InvisibleText","sap/base/Log"],function(l,C,S,E,I,D,a,c,B,K,L,b,d,e){"use strict";var T=c.TextDirection;var f=l.ButtonType;var g=l.ButtonAccessibilityType;var h=l.BadgeState;var A=c.aria.HasPopup;var i=1,j=9999;
var k=C.extend("sap.m.Button",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:f.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:A.None}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},press:{}},designtime:"sap/m/designtime/Button.designtime",dnd:{draggable:true,droppable:false}}});
E.call(k.prototype);a.apply(k.prototype);b.call(k.prototype);
k.prototype.init=function(){this._onmouseenter=this._onmouseenter.bind(this);this._buttonPressed=false;S.addConfig(this,{event:"press",position:"0 0",addAccessibilityLabel:true},this);this.initBadgeEnablement({position:"topRight",selector:{suffix:"inner"}});this._oBadgeData={value:"",state:""};this._badgeMinValue=i;this._badgeMaxValue=j;};
k.prototype.badgeValueFormatter=function(v){var V=parseInt(v),o=this.getBadgeCustomData(),m=o.getVisible();if(isNaN(V)){return false;}if(V<this._badgeMinValue){m&&o.setVisible(false);}else{!m&&o.setVisible(true);if(V>this._badgeMaxValue&&v.indexOf("+")===-1){v=this._badgeMaxValue<1000?this._badgeMaxValue+"+":"999+";}}return v;};
k.prototype.setBadgeMinValue=function(m){var v=this.getBadgeCustomData().getValue();if(m&&!isNaN(m)&&m>=i&&m!=this._badgeMinValue&&m<=this._badgeMaxValue){this._badgeMinValue=m;this.badgeValueFormatter(v);this.invalidate();}else{e.warning("minValue is not valid (it is is less than minimum allowed badge value ["+i+"] or greater than maximum badge value ["+this._badgeMaxValue+"])",this);}return this;};
k.prototype.setBadgeMaxValue=function(m){if(m&&!isNaN(m)&&m<=j&&m!=this._badgeMaxValue&&m>=this._badgeMinValue){this._badgeMaxValue=m;this.invalidate();}else{e.warning("maxValue is not valid (it is is greater than than maximum allowed badge value ["+j+"] or less than minimum badge value ["+this._badgeMinValue+"])",this);}return this;};
k.prototype.onBadgeUpdate=function(v,s){if(this._oBadgeData.value!==v||this._oBadgeData.state!==s){if(s===h.Disappear){v="";}this._updateBadgeInvisibleText(v);this._oBadgeData={value:v,state:s};}};
k.prototype._updateBadgeInvisibleText=function(v){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s,p;v=v.toString().trim();p=v.indexOf("+");if(p!==-1){s=r.getText("BUTTON_BADGE_MORE_THAN_ITEMS",v.substr(0,p));}else{switch(v){case"":s="";break;case"1":s=r.getText("BUTTON_BADGE_ONE_ITEM",v);break;default:s=r.getText("BUTTON_BADGE_MANY_ITEMS",v);}}this._getBadgeInvisibleText().setText(s);};
k.prototype._getBadgeInvisibleText=function(){if(!this._oBadgeInvisibleText){this._oBadgeInvisibleText=new d(this.getId()+"-badge").toStatic();}return this._oBadgeInvisibleText;};
k.prototype.exit=function(){if(this._image){this._image.destroy();}if(this._iconBtn){this._iconBtn.destroy();}if(this._oBadgeInvisibleText){this._oBadgeInvisibleText.destroy();this._oBadgeData=null;}this._bFocused=null;this.$().off("mouseenter",this._onmouseenter);};
k.prototype.setType=function(s){this.setProperty("type",s,false);switch(s){case f.Critical:this._sTypeIconURI="sap-icon://alert";break;case f.Negative:this._sTypeIconURI="sap-icon://error";break;case f.Success:this._sTypeIconURI="sap-icon://sys-enter-2";break;case f.Neutral:this._sTypeIconURI="sap-icon://information";break;case f.Back:case f.Up:this._sTypeIconURI="sap-icon://nav-back";break;default:this._sTypeIconURI=null;}return this;};
k.prototype.onBeforeRendering=function(){this._bRenderActive=this._bActive;this.$().off("mouseenter",this._onmouseenter);};
k.prototype.onAfterRendering=function(){if(this._bRenderActive){this._activeButton();this._bRenderActive=this._bActive;}if(this._bFocused){this._toggleLiveChangeAnnouncement("polite");}this.$().on("mouseenter",this._onmouseenter);};
k.prototype.ontouchstart=function(o){o.setMarked();if(this._bRenderActive){delete this._bRenderActive;}if(o.targetTouches.length===1){this._buttonPressed=true;this._activeButton();}if(this.getEnabled()&&this.getVisible()){if((D.browser.safari||D.browser.firefox)&&(o.originalEvent&&o.originalEvent.type==="mousedown")){this._setButtonFocus();}this._sTouchStartTargetId=o.target.id.replace(this.getId(),'');}else{this._sTouchStartTargetId='';}};
k.prototype.ontouchend=function(o){var s;this._buttonPressed=o.originalEvent&&o.originalEvent.buttons&1;this._inactiveButton();if(this._bRenderActive){delete this._bRenderActive;this.ontap(o,true);}s=o.target.id.replace(this.getId(),'');if(this._buttonPressed===0&&((this._sTouchStartTargetId==="-BDI-content"&&(s==='-content'||s==='-inner'||s==='-img'))||(this._sTouchStartTargetId==="-content"&&(s==='-inner'||s==='-img'))||(this._sTouchStartTargetId==='-img'&&s!=='-img'))){this.ontap(o,true);}this._sTouchStartTargetId='';};
k.prototype.ontouchcancel=function(){this._buttonPressed=false;this._sTouchStartTargetId='';this._inactiveButton();};
k.prototype.ontap=function(o,F){o.setMarked();delete this._bRenderActive;if(this.bFromTouchEnd){return;}if(this.getEnabled()&&this.getVisible()){if((o.originalEvent&&o.originalEvent.type==="touchend")){this.focus();}this.fireTap({});this.firePress({});}this.bFromTouchEnd=F;if(this.bFromTouchEnd){setTimeout(function(){delete this.bFromTouchEnd;}.bind(this),0);}};
k.prototype.onkeydown=function(o){if(o.which===K.SPACE||o.which===K.ENTER||o.which===K.ESCAPE||o.which===K.SHIFT){if(o.which===K.SPACE||o.which===K.ENTER){o.setMarked();this._activeButton();}if(o.which===K.ENTER){this.firePress({});}if(o.which===K.SPACE){this._bPressedSpace=true;}if(this._bPressedSpace){if(o.which===K.SHIFT||o.which===K.ESCAPE){this._bPressedEscapeOrShift=true;this._inactiveButton();}}}else{if(this._bPressedSpace){o.preventDefault();}}};
k.prototype.onkeyup=function(o){if(o.which===K.ENTER){o.setMarked();this._inactiveButton();}if(o.which===K.SPACE){if(!this._bPressedEscapeOrShift){o.setMarked();this._inactiveButton();this.firePress({});}else{this._bPressedEscapeOrShift=false;}this._bPressedSpace=false;}if(o.which===K.ESCAPE){this._bPressedSpace=false;}};
k.prototype._onmouseenter=function(o){if(this._buttonPressed&&o.originalEvent&&o.originalEvent.buttons&1){this._activeButton();}};
k.prototype.onfocusin=function(){this._bFocused=true;this._toggleLiveChangeAnnouncement("polite");};
k.prototype.onfocusout=function(){this._buttonPressed=false;this._bFocused=false;this._sTouchStartTargetId='';this._inactiveButton();this._toggleLiveChangeAnnouncement("off");};
k.prototype._toggleLiveChangeAnnouncement=function(v){if(this._getText()){this.$("BDI-content").attr("aria-live",v);}else if(this._getAppliedIcon()){this.$("tooltip").attr("aria-live",v);}};
k.prototype._activeButton=function(){if(!this._isUnstyled()){this.$("inner").addClass("sapMBtnActive");}this._bActive=this.getEnabled();if(this._bActive){if(this._getAppliedIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this.getActiveIcon());}}};
k.prototype._inactiveButton=function(){if(!this._isUnstyled()){this.$("inner").removeClass("sapMBtnActive");}this._bActive=false;if(this.getEnabled()){if(this._getAppliedIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this._getAppliedIcon());}}};
k.prototype._isHoverable=function(){return this.getEnabled()&&D.system.desktop;};
k.prototype._getImage=function(s,m,n,o){var p=I.isIconURI(m),q;if(this._image instanceof sap.m.Image&&p||this._image instanceof sap.ui.core.Icon&&!p){this._image.destroy();this._image=undefined;}q=this.getIconFirst();if(this._image){this._image.setSrc(m);if(this._image instanceof sap.m.Image){this._image.setActiveSrc(n);this._image.setDensityAware(o);}}else{this._image=I.createControlByURI({id:s,src:m,activeSrc:n,densityAware:o,useIconTooltip:false},sap.m.Image).addStyleClass("sapMBtnCustomIcon").setParent(this,null,true);}this._image.addStyleClass("sapMBtnIcon");this._image.toggleStyleClass("sapMBtnIconLeft",q);this._image.toggleStyleClass("sapMBtnIconRight",!q);return this._image;};
k.prototype._getInternalIconBtn=function(s,m){var o=this._iconBtn;if(o){o.setSrc(m);}else{o=I.createControlByURI({id:s,src:m,useIconTooltip:false},sap.m.Image).setParent(this,null,true);}o.addStyleClass("sapMBtnIcon");o.addStyleClass("sapMBtnIconLeft");this._iconBtn=o;return this._iconBtn;};
k.prototype._isUnstyled=function(){var u=false;if(this.getType()===f.Unstyled){u=true;}return u;};
k.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("inner");};
k.prototype._getText=function(){return this.getText();};
k.prototype._getTooltip=function(){var t,o;t=this.getTooltip_AsString();if(!t&&!this._getText()){o=I.getIconInfo(this._getAppliedIcon());if(o){t=o.text?o.text:o.name;}}return t;};
k.prototype._getAppliedIcon=function(){return this.getIcon()||this._sTypeIconURI;};
k.prototype.getAccessibilityInfo=function(){var s=this._getText()||this.getTooltip_AsString();if(!s&&this._getAppliedIcon()){var o=I.getIconInfo(this._getAppliedIcon());if(o){s=o.text||o.name;}}return{role:"button",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_BUTTON"),description:s,focusable:this.getEnabled(),enabled:this.getEnabled()};};
k.prototype._setButtonFocus=function(){setTimeout(function(){this.focus();}.bind(this),0);};
k.prototype._determineSelfReferencePresence=function(){var m=this.getAriaLabelledBy(),n=m.indexOf(this.getId())!==-1,H=L.getReferencingLabels(this).length>0,p=this.getParent(),o=!!(p&&p.enhanceAccessibilityState);return!n&&this._getText()&&(m.length>0||H||o);};
k.prototype._determineAccessibilityType=function(){var H=this.getAriaLabelledBy().length>0,m=this.getAriaDescribedBy().length>0,n=L.getReferencingLabels(this).length>0,o=this.getType()!==f.Default,p=H||n,q=m||o||(this._oBadgeData&&this._oBadgeData.value!==""&&this._oBadgeData.State!==h.Disappear),s;if(!p&&!q){s=g.Default;}else if(p&&!q){s=g.Labelled;}else if(!p&&q){s=g.Described;}else if(p&&q){s=g.Combined;}return s;};
k.prototype._getTitleAttribute=function(s){return this.getTooltip();};
return k;});
sap.ui.predefine('sap/m/ButtonRenderer',['sap/ui/core/library','sap/ui/core/IconPool','sap/ui/core/ShortcutHintsMixin','sap/m/library','sap/ui/core/InvisibleText'],function(c,I,S,l,a){"use strict";var B=l.ButtonType;var b=l.ButtonAccessibilityType;var T=c.TextDirection;var d=l.BadgeState;var A=c.aria.HasPopup;var e={apiVersion:2};
e.render=function(R,o){var s=o.getId();var t=o.getType();var E=o.getEnabled();var w=o.getWidth();var f=o._getTooltip();var g=o._getText();var h=o.getTextDirection();var i=(h===T.Inherit);var j=I.getIconURI("nav-back");var M;R.openStart("button",o);R.class("sapMBtnBase");if(!o._isUnstyled()){R.class("sapMBtn");if((t===B.Back||t===B.Up)&&o._getAppliedIcon()&&!g){R.class("sapMBtnBack");}}var k=e.generateAccProps(o);if(this.renderAccessibilityAttributes){this.renderAccessibilityAttributes(R,o,k);}R.accessibilityState(o,k);if(!E){R.attr("disabled","disabled");if(!o._isUnstyled()){R.class("sapMBtnDisabled");}}else{switch(t){case B.Accept:case B.Reject:case B.Emphasized:case B.Attention:R.class("sapMBtnInverted");break;default:break;}}if(f&&!S.isDOMIDRegistered(s)){R.attr("title",f);}if(w!=""||w.toLowerCase()==="auto"){R.style("width",w);if(o._getAppliedIcon()&&g){M="4rem";}else{M="2.25rem";}R.style("min-width",M);}r(o,R);R.openEnd();R.openStart("span",s+"-inner");if(!o._isUnstyled()){R.class("sapMBtnInner");}if(o._isHoverable()){R.class("sapMBtnHoverable");}if(E){R.class("sapMFocusable");}if(!o._isUnstyled()){if(g){R.class("sapMBtnText");}if(t===B.Back||t===B.Up){R.class("sapMBtnBack");}if(o._getAppliedIcon()){if(o.getIconFirst()){R.class("sapMBtnIconFirst");}else{R.class("sapMBtnIconLast");}}}if(this.renderButtonAttributes){this.renderButtonAttributes(R,o);}if(!o._isUnstyled()&&t!==""){R.class("sapMBtn"+t);}r(o,R);R.openEnd();if(t===B.Back||t===B.Up){this.writeInternalIconPoolHtml(R,o,j);}if(o.getIconFirst()&&o._getAppliedIcon()){this.writeImgHtml(R,o);}if(g){R.openStart("span",s+"-content");R.class("sapMBtnContent");if(h!==T.Inherit){R.attr("dir",h.toLowerCase());}R.openEnd();if(i){R.openStart("bdi",s+"-BDI-content");R.openEnd();}R.text(g);if(i){R.close("bdi");}R.close("span");}if(!o.getIconFirst()&&o._getAppliedIcon()){this.writeImgHtml(R,o);}R.close("span");if(f){R.openStart("span",s+"-tooltip");R.class("sapUiInvisibleText");R.openEnd();R.text(f);R.close("span");}R.close("button");};
e.writeImgHtml=function(R,o){var t=o.getType(),h=o.getIcon(),i=(t===B.Back)||(t===B.Up);if(!h&&i){return;}R.renderControl(o._getImage(o.getId()+"-img",o._getAppliedIcon(),o.getActiveIcon(),o.getIconDensityAware()));};
e.writeInternalIconPoolHtml=function(R,o,u){R.renderControl(o._getInternalIconBtn((o.getId()+"-iconBtn"),u));};
function r(o,R){if(o._bExcludeFromTabChain){R.attr("tabindex",-1);}}
var m={Accept:"BUTTON_ARIA_TYPE_ACCEPT",Reject:"BUTTON_ARIA_TYPE_REJECT",Attention:"BUTTON_ARIA_TYPE_ATTENTION",Emphasized:"BUTTON_ARIA_TYPE_EMPHASIZED",Critical:"BUTTON_ARIA_TYPE_CRITICAL",Negative:"BUTTON_ARIA_TYPE_NEGATIVE",Success:"BUTTON_ARIA_TYPE_SUCCESS"};
e.getButtonTypeAriaLabelId=function(t){return a.getStaticId("sap.m",m[t]);};
e.getBadgeTextId=function(o){return o._oBadgeData&&o._oBadgeData.value!==""&&o._oBadgeData.state!==d.Disappear?o._getBadgeInvisibleText().getId():"";};
e.generateAccProps=function(o){var t=o._getText(),h=o.getAriaHasPopup(),f;if(t){f=e.generateTextButtonAccProps(o);}else{f=e.generateIconOnlyButtonAccProps(o);}f["disabled"]=null;f["haspopup"]=(h===A.None)?null:h.toLowerCase();return f;};
e.generateIconOnlyButtonAccProps=function(o){var t=e.getButtonTypeAriaLabelId(o.getType()),s=this.getBadgeTextId(o),f=o._getTooltip(),g=o.getId()+"-tooltip",h=o._determineAccessibilityType(),i={},D;switch(h){case b.Default:i["label"]={value:f,append:true};break;case b.Described:i["label"]={value:f,append:true};D=(t+" "+s).trim();D&&(i["describedby"]={value:D,append:true});break;case b.Labelled:i["describedby"]={value:g,append:true};break;case b.Combined:i["describedby"]={value:(g+" "+t+" "+s).trim(),append:true};break;default:break;}return i;};
e.generateTextButtonAccProps=function(o){var s=o.getId(),t=e.getButtonTypeAriaLabelId(o.getType()),f=this.getBadgeTextId(o),g=o._getTooltip()?s+"-tooltip":"",i=s+"-content",h=o._determineAccessibilityType(),p=o._determineSelfReferencePresence(),j={},D;switch(h){case b.Default:g&&(j["describedby"]={value:g,append:true});break;case b.Described:D=(g+" "+t+" "+f).trim();D&&(j["describedby"]={value:D,append:true});break;case b.Labelled:p&&(j["labelledby"]={value:i,append:true});g&&(j["describedby"]={value:g,append:true});break;case b.Combined:D=(g+" "+t+" "+f).trim();D&&(j["describedby"]={value:D,append:true});p&&(j["labelledby"]={value:i,append:true});break;default:break;}return j;};
return e;},true);
sap.ui.predefine('sap/m/Carousel',["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/library","sap/m/MessagePage","./CarouselRenderer","./CarouselLayout","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/events/F6Navigation","sap/ui/thirdparty/jquery","sap/ui/thirdparty/mobify-carousel","sap/ui/core/IconPool"],function(l,C,a,D,R,c,M,b,d,K,L,F,q){"use strict";var B=c.BusyIndicatorSize;var I=l.ImageHelper;var e=l.CarouselArrowsPlacement;var P=l.PlacementType;
var f=a.extend("sap.m.Carousel",{metadata:{library:"sap.m",designtime:"sap/m/designtime/Carousel.designtime",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},loop:{type:"boolean",group:"Misc",defaultValue:false},showPageIndicator:{type:"boolean",group:"Appearance",defaultValue:true},pageIndicatorPlacement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:P.Bottom},showBusyIndicator:{type:"boolean",group:"Appearance",defaultValue:true,deprecated:true},arrowsPlacement:{type:"sap.m.CarouselArrowsPlacement",group:"Appearance",defaultValue:e.Content}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"},customLayout:{type:"sap.m.CarouselLayout",multiple:false}},associations:{activePage:{type:"sap.ui.core.Control",multiple:false}},events:{loadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},unloadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},pageChanged:{parameters:{oldActivePageId:{type:"string"},newActivePageId:{type:"string"},activePages:{type:"array"}}},beforePageChanged:{parameters:{activePages:{type:"array"}}}}}});
f._INNER_SELECTOR=".sapMCrslInner";f._PAGE_INDICATOR_SELECTOR=".sapMCrslBulleted";f._PAGE_INDICATOR_ARROWS_SELECTOR=".sapMCrslIndicatorArrow";f._CONTROLS=".sapMCrslControls";f._ITEM_SELECTOR=".sapMCrslItem";f._LEFTMOST_CLASS="sapMCrslLeftmost";f._RIGHTMOST_CLASS="sapMCrslRightmost";f._LATERAL_CLASSES="sapMCrslLeftmost sapMCrslRightmost";f._MODIFIERNUMBERFORKEYBOARDHANDLING=10;f._BULLETS_TO_NUMBERS_THRESHOLD=9;f._PREVIOUS_CLASS_ARROW="sapMCrslPrev";f._NEXT_CLASS_ARROW="sapMCrslNext";
f.prototype.init=function(){this._fnAdjustAfterResize=function(){var $=this.$().find(f._INNER_SELECTOR);this._oMobifyCarousel.resize($);if(this.getPages().length>1){this._setWidthOfPages(this._getNumberOfItemsToShow());}}.bind(this);this._aOrderOfFocusedElements=[];this._aAllActivePages=[];this._aAllActivePagesIndexes=[];this._onBeforePageChangedRef=this._onBeforePageChanged.bind(this);this._onAfterPageChangedRef=this._onAfterPageChanged.bind(this);this.data("sap-ui-fastnavgroup","true",true);this._oRb=C.getLibraryResourceBundle("sap.m");};
f.prototype.exit=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.destroy();delete this._oMobifyCarousel;}if(this._oArrowLeft){this._oArrowLeft.destroy();delete this._oArrowLeft;}if(this._oArrowRight){this._oArrowRight.destroy();delete this._oArrowRight;}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this.oMessagePage){this.oMessagePage.destroy();this.oMessagePage=null;}this.$().off('afterSlide');this._fnAdjustAfterResize=null;this._$InnerDiv=null;this._aOrderOfFocusedElements=null;this._aAllActivePages=null;this._aAllActivePagesIndexes=null;};
f.prototype.ontouchstart=function(E){if(this._oMobifyCarousel){if(E.target instanceof HTMLImageElement){E.preventDefault();}this._oMobifyCarousel.touchstart(E);}};
f.prototype.ontouchmove=function(E){if(this._oMobifyCarousel){this._oMobifyCarousel.touchmove(E);}};
f.prototype.ontouchend=function(E){if(this._oMobifyCarousel){if(this._oMobifyCarousel.hasActiveTransition()){this._oMobifyCarousel.onTransitionComplete();}this._oMobifyCarousel.touchend(E);}};
f.prototype.onBeforeRendering=function(){var A=this.getActivePage();if(!A&&this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.$().off('beforeSlide',this._onBeforePageChangedRef);this.$().off('afterSlide',this._onAfterPageChangedRef);return this;};
f.prototype._getNumberOfItemsToShow=function(){var p=this.getPages().length,o=this.getCustomLayout(),n=1;if(o&&o.isA("sap.m.CarouselLayout")){n=Math.max(o.getVisiblePagesCount(),1);}if(n>1&&p<n){return p;}return n;};
f.prototype.onAfterRendering=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.unbind();setTimeout(function(){if(this._oMobifyCarousel){this._oMobifyCarousel.onTransitionComplete();}}.bind(this),0);}var n=this._getNumberOfItemsToShow();this.$().carousel(undefined,{numberOfItemsToShow:n});this._oMobifyCarousel=this.getDomRef()._carousel;this._oMobifyCarousel.setLoop(this.getLoop());this._oMobifyCarousel.setRTL(C.getConfiguration().getRTL());if(n>1){this._setWidthOfPages(n);}var A=this.getActivePage();if(A){this._updateActivePages(A);var i=this._getPageNumber(A);if(isNaN(i)||i==0){if(this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);this._adjustHUDVisibility(1);}}else{if(C.isThemeApplied()){this._moveToPage(i+1);}else{C.attachThemeChanged(this._handleThemeLoad,this);}if(this.getParent()&&this.getParent().isA("sap.zen.commons.layout.PositionContainer")){if(this._isCarouselUsedWithCommonsLayout===undefined){setTimeout(this["invalidate"].bind(this),0);this._isCarouselUsedWithCommonsLayout=true;}}}}this.$().on('beforeSlide',this._onBeforePageChangedRef);this.$().on('afterSlide',this._onAfterPageChangedRef);this._$InnerDiv=this.$().find(f._INNER_SELECTOR)[0];this._sResizeListenerId=R.register(this._$InnerDiv,this._fnAdjustAfterResize);var p=this.getParent();while(p){if(p.isA("sap.m.IconTabBar")){var t=this;p.attachExpand(function(E){var g=E.getParameter('expand');if(g&&i>0){t._moveToPage(i+1);}});break;}p=p.getParent();}};
f.prototype._onBeforePageChanged=function(E,p,n){if(E.target!==this.getDomRef()){return;}var N=this.getPages()[n-1].getId();this._updateActivePages(N);this.fireBeforePageChanged({activePages:this._aAllActivePagesIndexes});};
f.prototype._onAfterPageChanged=function(E,p,n){var h=this.getPages().length>0;if(E.target!==this.getDomRef()){return;}if(h&&n>0){this._changePage(p,n);}};
f.prototype._setWidthOfPages=function(n){var $=this.$().find(".sapMCrslItem"),i;if(!$.length){return;}i=this._calculatePagesWidth(n);$.each(function(g,p){p.style.width=i+"%";});};
f.prototype._calculatePagesWidth=function(n){var w=this.$().width(),s=this.getDomRef().querySelector(".sapMCrslFluid .sapMCrslItem"),m=parseFloat(window.getComputedStyle(s).marginRight),i=(w-(m*(n-1)))/n,g=(i/w)*100;return g;};
f.prototype._handleThemeLoad=function(){var A=this.getActivePage();if(A){var i=this._getPageNumber(A);if(i>0){this._moveToPage(i+1);}}C.detachThemeChanged(this._handleThemeLoad,this);};
f.prototype._moveToPage=function(i){this._oMobifyCarousel.changeAnimation('sapMCrslNoTransition');this._oMobifyCarousel.move(i);this._changePage(undefined,i);};
f.prototype._changePage=function(o,n){this._adjustHUDVisibility(n);var O=this.getActivePage();if(o){O=this.getPages()[o-1].getId();}var N=this.getPages()[n-1].getId();this.setAssociation("activePage",N,true);var t=this._getPageIndicatorText(n);L.debug("sap.m.Carousel: firing pageChanged event: old page: "+O+", new page: "+N);if(!D.system.desktop){q(document.activeElement).trigger("blur");}if(this._oMobifyCarousel&&this._oMobifyCarousel.getShouldFireEvent()){this.firePageChanged({oldActivePageId:O,newActivePageId:N,activePages:this._aAllActivePagesIndexes});}this.$('slide-number').text(t);};
f.prototype._getPageIndicatorText=function(n){return this._oRb.getText("CAROUSEL_PAGE_INDICATOR_TEXT",[n,this.getPages().length-this._getNumberOfItemsToShow()+1]);};
f.prototype._adjustHUDVisibility=function(n){var N=this._getNumberOfItemsToShow();if(D.system.desktop&&!this.getLoop()&&this.getPages().length>1){var h=this.$('hud');h.removeClass(f._LATERAL_CLASSES);if(n===1){h.addClass(f._LEFTMOST_CLASS);this._focusCarouselContainer(h,f._PREVIOUS_CLASS_ARROW);}if((n+N-1)===this.getPages().length){h.addClass(f._RIGHTMOST_CLASS);this._focusCarouselContainer(h,f._NEXT_CLASS_ARROW);}}};
f.prototype._focusCarouselContainer=function(h,A){if(h.find('.'+A)[0]===document.activeElement){this.focus();}};
f.prototype.setActivePage=function(p){var s=null;if(typeof(p)=='string'){s=p;}else if(p instanceof a){s=p.getId();}if(s){if(s===this.getActivePage()){return this;}var i=this._getPageNumber(s);if(!isNaN(i)){if(this._oMobifyCarousel){this._oMobifyCarousel.setShouldFireEvent(true);this._oMobifyCarousel.move(i+1);}}}this.setAssociation("activePage",s,true);return this;};
f.prototype._getNavigationArrow=function(s){if(!this["_oArrow"+s]){this["_oArrow"+s]=I.getImageControl(this.getId()+"-arrowScroll"+s,this["_oArrow"+s],this,{src:"sap-icon://slim-arrow-"+s.toLowerCase(),useIconTooltip:false});}return this["_oArrow"+s];};
f.prototype._getErrorPage=function(){if(!this.oMessagePage){this.oMessagePage=new M({text:this._oRb.getText("CAROUSEL_ERROR_MESSAGE"),description:"",icon:"sap-icon://document",showHeader:false});}return this.oMessagePage;};
f.prototype.previous=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.setShouldFireEvent(true);this._oMobifyCarousel.prev();}else{L.warning("Unable to execute sap.m.Carousel.previous: carousel must be rendered first.");}return this;};
f.prototype.next=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.setShouldFireEvent(true);this._oMobifyCarousel.next();}else{L.warning("Unable to execute sap.m.Carousel.next: carousel must be rendered first.");}return this;};
f.prototype._getPageNumber=function(p){var i,r;for(i=0;i<this.getPages().length;i++){if(this.getPages()[i].getId()==p){r=i;break;}}return r;};
f.prototype.onsaptabprevious=function(E){this._bDirection=false;this._fnOnTabPress(E);};
f.prototype.onsaptabnext=function(E){this._bDirection=true;this._fnOnTabPress(E);};
f.prototype.onfocusin=function(E){this.saveLastFocusReference(E);this._bDirection=undefined;};
f.prototype.onsapskipforward=function(E){E.preventDefault();this._handleGroupNavigation(E,false);};
f.prototype.onsapskipback=function(E){E.preventDefault();this._handleGroupNavigation(E,true);};
f.prototype.onkeydown=function(E){if(E.keyCode==K.F7){this._handleF7Key(E);return;}if(E.target!=this.getDomRef()){return;}switch(E.keyCode){case 189:case K.NUMPAD_MINUS:this._fnSkipToIndex(E,-1);break;case K.PLUS:case K.NUMPAD_PLUS:this._fnSkipToIndex(E,1);break;}};
f.prototype.onsapescape=function(E){var g;if(E.target===this.$()[0]&&this._lastActivePageNumber){g=this._lastActivePageNumber+1;this._oMobifyCarousel.move(g);this._changePage(undefined,g);}};
f.prototype.onsapright=function(E){this._fnSkipToIndex(E,1);};
f.prototype.onsapup=function(E){this._fnSkipToIndex(E,-1);};
f.prototype.onsapleft=function(E){this._fnSkipToIndex(E,-1);};
f.prototype.onsapdown=function(E){this._fnSkipToIndex(E,1);};
f.prototype.onsaphome=function(E){this._fnSkipToIndex(E,0);};
f.prototype.onsapend=function(E){this._fnSkipToIndex(E,this.getPages().length);};
f.prototype.onsaprightmodifiers=function(E){if(E.ctrlKey){this._fnSkipToIndex(E,f._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
f.prototype.onsapupmodifiers=function(E){if(E.ctrlKey){this._fnSkipToIndex(E,f._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
f.prototype.onsappageup=function(E){this._fnSkipToIndex(E,f._MODIFIERNUMBERFORKEYBOARDHANDLING);};
f.prototype.onsapleftmodifiers=function(E){if(E.ctrlKey){this._fnSkipToIndex(E,-f._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
f.prototype.onsapdownmodifiers=function(E){if(E.ctrlKey){this._fnSkipToIndex(E,-f._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
f.prototype.onsappagedown=function(E){this._fnSkipToIndex(E,-f._MODIFIERNUMBERFORKEYBOARDHANDLING);};
f.prototype._fnOnTabPress=function(E){if(E.target===this.$()[0]){this._lastActivePageNumber=this._getPageNumber(this.getActivePage());}};
f.prototype._handleGroupNavigation=function(E,s){var o=q.Event("keydown");E.preventDefault();this.$().trigger("focus");o.target=E.target;o.key='F6';o.shiftKey=s;F.handleF6GroupNavigation(o);};
f.prototype.saveLastFocusReference=function(E){var o=q(E.target).closest(".sapMCrsPage").control(0),s;if(this._bDirection===undefined){return;}if(this._lastFocusablePageElement===undefined){this._lastFocusablePageElement={};}if(o){s=o.getId();this._lastFocusablePageElement[s]=E.target;this._updateFocusedPagesOrder(s);}};
f.prototype._getActivePageLastFocusedElement=function(){if(this._lastFocusablePageElement){return this._lastFocusablePageElement[this._getLastFocusedActivePage()];}};
f.prototype._updateFocusedPagesOrder=function(s){var i=this._aOrderOfFocusedElements.indexOf(s);if(i>-1){this._aOrderOfFocusedElements.splice(0,0,this._aOrderOfFocusedElements.splice(i,1)[0]);}else{this._aOrderOfFocusedElements.unshift(s);}};
f.prototype._updateActivePages=function(n){var N=this._getPageNumber(n),g=this._getNumberOfItemsToShow(),h=N+g,A=this.getPages();if(h>A.length){h=A.length-g;}this._aAllActivePages=[];this._aAllActivePagesIndexes=[];for(var i=N;i<h;i++){this._aAllActivePages.push(A[i].getId());this._aAllActivePagesIndexes.push(i);}};
f.prototype._getLastFocusedActivePage=function(){for(var i=0;i<this._aOrderOfFocusedElements.length;i++){var p=this._aOrderOfFocusedElements[i];if(this._aAllActivePages.indexOf(p)>-1){return p;}}return this.getActivePage();};
f.prototype._fnSkipToIndex=function(E,n){var g=n;if(E.target!==this.getDomRef()){return;}E.preventDefault();if(this._oMobifyCarousel.hasActiveTransition()){this._oMobifyCarousel.onTransitionComplete();}this._oMobifyCarousel.setShouldFireEvent(true);if(n!==0){g=this._getPageNumber(this.getActivePage())+1+n;}this._oMobifyCarousel.move(g);};
f.prototype._handleF7Key=function(E){var A=this._getActivePageLastFocusedElement();if(E.target===this.$()[0]&&A){A.focus();}else{this.$().trigger("focus");}};
f.prototype.setShowBusyIndicator=function(){L.warning("sap.m.Carousel: Deprecated function 'setShowBusyIndicator' called. Does nothing.");return this;};
f.prototype.getShowBusyIndicator=function(){L.warning("sap.m.Carousel: Deprecated function 'getShowBusyIndicator' called. Does nothing.");return false;};
f.prototype.setBusyIndicatorSize=function(s){if(!(s in B)){s=B.Medium;}return a.prototype.setBusyIndicatorSize.call(this,s);};
return f;});
sap.ui.predefine('sap/m/CarouselLayout',["sap/ui/base/ManagedObject"],function(M){"use strict";
var C=M.extend("sap.m.CarouselLayout",{metadata:{library:"sap.m",properties:{visiblePagesCount:{type:"int",group:"Misc",defaultValue:1}}}});
return C;});
sap.ui.predefine('sap/m/CarouselRenderer',["sap/m/library","sap/base/strings/capitalize","sap/ui/core/Core","sap/ui/Device"],function(l,c,C,D){"use strict";var a=l.CarouselArrowsPlacement;var P=l.PlacementType;var r=C.getLibraryResourceBundle("sap.m");var b={apiVersion:2};b._BULLETS_TO_NUMBERS_THRESHOLD=9;
b.render=function(R,o){var p=o.getPages(),i=p.length,s=o.getPageIndicatorPlacement(),A=o.getArrowsPlacement(),I=o._getPageNumber(o.getActivePage());this._renderOpeningDiv(R,o);if(s===P.Top){this._renderPageIndicatorAndArrows(R,o,{iPageCount:i,iIndex:I,sArrowsPlacement:A,bBottom:false,bShowPageIndicator:o.getShowPageIndicator()});}this._renderInnerDiv(R,o,p,s);if(D.system.desktop&&i>o._getNumberOfItemsToShow()&&A===a.Content){this._renderHudArrows(R,o);}if(s===P.Bottom){this._renderPageIndicatorAndArrows(R,o,{iPageCount:i,iIndex:I,sArrowsPlacement:A,bBottom:true,bShowPageIndicator:o.getShowPageIndicator()});}R.close("div");};
b._renderOpeningDiv=function(R,o){var t=o.getTooltip_AsString();R.openStart("div",o).class("sapMCrsl").class("sapMCrslFluid").style("width",o.getWidth()).style("height",o.getHeight()).attr("data-sap-ui-customfastnavgroup",true).attr("tabindex",0).accessibilityState(o,{role:"listbox"});if(t){R.attr("title",t);}R.openEnd();};
b._renderInnerDiv=function(R,o,p,s){R.openStart("div").class("sapMCrslInner");if(p.length>1&&(o.getShowPageIndicator()||o.getArrowsPlacement()===a.PageIndicator)){if(s===P.Bottom){R.class("sapMCrslBottomOffset");if(o.getArrowsPlacement()===a.PageIndicator){R.class("sapMCrslBottomArrowsOffset");}}else{R.class("sapMCrslTopOffset");if(o.getArrowsPlacement()===a.PageIndicator){R.class("sapMCrslTopArrowsOffset");}}}R.openEnd();var f=function(d,i,A){R.openStart("div",o.getId()+"-"+d.getId()+"-slide").class("sapMCrslItem").accessibilityState(d,{role:"option",posinset:i+1,setsize:A.length}).openEnd();b._renderPageInScrollContainer(R,o,d);R.close("div");};if(p.length){p.forEach(f);}else{R.renderControl(o._getErrorPage());}R.close("div");};
b._renderPageIndicatorAndArrows=function(R,o,s){var p=s.iPageCount,S=D.system.desktop&&s.sArrowsPlacement===a.PageIndicator,I=o.getId(),O=[],n=o._getNumberOfItemsToShow(),d=1;if(p<=o._getNumberOfItemsToShow()){return;}if(!s.bShowPageIndicator&&!S){return;}if(s.bBottom){O.push("sapMCrslControlsBottom");}else{O.push("sapMCrslControlsTop");}if(S){R.openStart("div").class("sapMCrslControls");O.forEach(function(e){R.class(e);});R.openEnd();R.openStart("div").class("sapMCrslControlsContainer");O.forEach(function(e){R.class(e);});R.openEnd();}else{R.openStart("div").class("sapMCrslControlsNoArrows");O.forEach(function(e){R.class(e);});R.openEnd();}if(S){this._renderArrow(R,o,"previous");}R.openStart("div",I+"-pageIndicator");if(!s.bShowPageIndicator){R.style("opacity","0");}if(p<b._BULLETS_TO_NUMBERS_THRESHOLD){R.class("sapMCrslBulleted").openEnd();for(var i=1;i<=p-n+1;i++){R.openStart("span").attr("data-slide",d).accessibilityState({role:"img",label:r.getText("CAROUSEL_POSITION",[i,p])}).openEnd().text(i).close("span");d++;}}else{R.class("sapMCrslNumeric").openEnd();var t=r.getText("CAROUSEL_PAGE_INDICATOR_TEXT",[s.iIndex+1,p-n+1]);R.openStart("span",I+"-"+"slide-number").openEnd().text(t).close("span");}R.close("div");if(S){this._renderArrow(R,o,"next");}if(!S){R.close("div");}if(S){R.close("div").close("div");}};
b._renderHudArrows=function(R,o){var A;if(o.getShowPageIndicator()){if(o.getPageIndicatorPlacement()===P.Top){A="sapMCrslHudTop";}else if(o.getPageIndicatorPlacement()===P.Bottom){A="sapMCrslHudBottom";}}else{A="sapMCrslHudMiddle";}R.openStart("div",o.getId()+"-hud").class("sapMCrslHud").class(A).openEnd();this._renderArrow(R,o,"previous");this._renderArrow(R,o,"next");R.close("div");};
b._renderArrow=function(R,o,d){var s=d.slice(0,4);R.openStart("a").class("sapMCrsl"+c(s)).attr("tabindex","-1").attr("data-slide",s).attr("title",r.getText("PAGINGBUTTON_"+d.toUpperCase())).openEnd();R.openStart("div").class("sapMCrslArrowInner").openEnd();R.renderControl(o._getNavigationArrow(d==="previous"?"Left":"Right"));R.close("div").close("a");};
b._renderPageInScrollContainer=function(R,o,p){R.openStart("div").class("sapMScrollCont").class("sapMScrollContH").style("width","100%").style("height","100%").openEnd();R.openStart("div").class("sapMScrollContScroll").openEnd();R.openStart("div").class("sapMCrslItemTable").openEnd();R.openStart("div").class("sapMCrslItemTableCell");if(p.isA("sap.m.Image")){var i="sapMCrslImgNoArrows",s=D.system.desktop&&o.getArrowsPlacement()===a.PageIndicator;if(s){i="sapMCrslImg";}R.class(i);}R.openEnd();R.renderControl(p.addStyleClass("sapMCrsPage"));R.close("div");R.close("div");R.close("div");R.close("div");};
return b;},true);
sap.ui.predefine('sap/m/CheckBox',['./Label','./library','sap/ui/Device','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/library','./CheckBoxRenderer',"sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes",'sap/ui/core/LabelEnablement','sap/ui/core/message/MessageMixin'],function(L,l,D,C,E,c,a,q,K,b,M){"use strict";var V=c.ValueState;var T=c.TextAlign;var d=c.TextDirection;
var e=C.extend("sap.m.CheckBox",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.core.ISemanticFormContent"],library:"sap.m",properties:{selected:{type:"boolean",group:"Data",defaultValue:false},partiallySelected:{type:"boolean",group:"Data",defaultValue:false},enabled:{type:"boolean",group:"Behavior",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Appearance",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:d.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},useEntireWidth:{type:"boolean",group:"Appearance",defaultValue:false},activeHandling:{type:"boolean",group:"Misc",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},valueStateText:{type:"string",group:"Misc",defaultValue:null,visibility:"hidden"},displayOnly:{type:"boolean",group:"Behavior",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{_label:{type:"sap.m.Label",group:"Behavior",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{selected:{type:"boolean"}}}},dnd:{draggable:true,droppable:false},designtime:"sap/m/designtime/CheckBox.designtime"}});
E.call(e.prototype);M.call(e.prototype);
e.prototype.init=function(){this._handleReferencingLabels();};
e.prototype.exit=function(){this._oLabel=null;delete this._iTabIndex;};
e.prototype.setText=function(t){var o=this._getLabel();this.setProperty("text",t);o.setText(t);return this;};
e.prototype.setWidth=function(w){this.setProperty("width",w,true);this._setWidth();return this;};
e.prototype.setUseEntireWidth=function(u){this.setProperty("useEntireWidth",u,true);this._setWidth();return this;};
e.prototype.setTextDirection=function(s){var o=this._getLabel();this.setProperty("textDirection",s);o.setTextDirection(s);return this;};
e.prototype.setTextAlign=function(A){var o=this._getLabel();this.setProperty("textAlign",A);o.setTextAlign(A);return this;};
e.prototype.setValueStateText=function(t){return this.setProperty("valueStateText",t);};
e.prototype.setWrapping=function(w){var o=this._getLabel();this.setProperty("wrapping",w);o.setWrapping(w);return this;};
e.prototype.getFormattedState=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.m");return this.getSelected()?B.getText("ACC_CTR_STATE_CHECKED"):B.getText("ACC_CTR_STATE_NOT_CHECKED");};
e.prototype.getFormFormattedValue=function(){return this.getFormattedState();};
e.prototype.getFormValueProperty=function(){return"selected";};
e.prototype.ontouchstart=function(o){o.originalEvent._sapui_handledByControl=true;};
e.prototype.ontap=function(o){var s;if(this.getEnabled()&&this.getEditable()&&!this.getDisplayOnly()){this.$().trigger("focus");s=this._getSelectedState();this.setSelected(s);this.setPartiallySelected(false);this.fireSelect({selected:s});o&&o.setMarked();}};
e.prototype.onkeyup=function(o){if(o&&o.which===K.SPACE&&!o.shiftKey){this.ontap(o);o.preventDefault();}};
e.prototype.onsapspace=function(o){o.preventDefault();};
e.prototype.onsapenter=function(o){this.ontap(o);};
e.prototype.setTabIndex=function(t){this._iTabIndex=t;this.$("CbBg").attr("tabindex",t);return this;};
e.prototype.getTabIndex=function(){if(this.hasOwnProperty("_iTabIndex")){return this._iTabIndex;}return(this.getEnabled()&&!this.getDisplayOnly())?0:-1;};
e.prototype._getLabel=function(){if(!this._oLabel){this._oLabel=new L(this.getId()+"-label").addStyleClass("sapMCbLabel");this.setAggregation("_label",this._oLabel,true);}return this.getAggregation("_label");};
e.prototype._setWidth=function(){var o=this._getLabel(),$=this.$(),w=this.getWidth();if(this.getUseEntireWidth()){o.setWidth("");$.outerWidth(w);}else{$.outerWidth("");o.setWidth(w);}};
e.prototype._getSelectedState=function(){var s=this.getSelected(),p=this.getPartiallySelected();return(s===p)||(!s&&p);};
e.prototype._getAriaChecked=function(){var s=this.getSelected();if(this.getPartiallySelected()&&s){return"mixed";}return s;};
e.prototype._fnLabelTapHandler=function(){this.$().trigger("focus");};
e.prototype._handleReferencingLabels=function(){var f=b.getReferencingLabels(this),t=this;if(f.length>0){f.forEach(function(s){sap.ui.getCore().byId(s).addEventDelegate({ontap:function(){t._fnLabelTapHandler();}});});}};
e.prototype.getAccessibilityInfo=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.m"),t=this.getText();return{role:"checkbox",type:B.getText("ACC_CTR_TYPE_CHECKBOX"),description:(t?t+" ":"")+this.getFormattedState(),focusable:this.getEnabled()&&!this.getDisplayOnly(),enabled:this.getEnabled(),editable:this.getEditable()};};
e.prototype.getFormDoNotAdjustWidth=function(){return this.getText()?false:true;};
return e;});
sap.ui.predefine('sap/m/CheckBoxRenderer',['sap/ui/core/library','sap/ui/core/ValueStateSupport','sap/ui/Device'],function(c,V,D){"use strict";var a=c.ValueState;var C={apiVersion:2};
C.render=function(r,o){var i=o.getId(),e=o.getEnabled(),d=o.getDisplayOnly(),E=o.getEditable(),I=e&&!d,b=e&&d,f=o.getAggregation("_label"),v=o.getValueState(),g=a.Error===v,h=a.Warning===v,j=a.Success===v,k=a.Information===v,u=o.getUseEntireWidth(),l=E&&e;r.openStart("div",o);r.class("sapMCb");if(!E){r.class("sapMCbRo");}if(b){r.class("sapMCbDisplayOnly");}if(!e){r.class("sapMCbBgDis");}if(o.getText()){r.class("sapMCbHasLabel");}if(o.getWrapping()){r.class("sapMCbWrapped");}if(l){if(g){r.class("sapMCbErr");}else if(h){r.class("sapMCbWarn");}else if(j){r.class("sapMCbSucc");}else if(k){r.class("sapMCbInfo");}}if(u){r.style("width",o.getWidth());}var t=this.getTooltipText(o);if(t){r.attr("title",t);}if(I){r.attr("tabindex",o.getTabIndex());}r.accessibilityState(o,{role:"checkbox",selected:null,checked:o._getAriaChecked(),describedby:t&&l?i+"-Descr":undefined});if(b){r.attr("aria-readonly",true);}r.openEnd();r.openStart("div",o.getId()+"-CbBg");r.class("sapMCbBg");if(I&&E&&D.system.desktop){r.class("sapMCbHoverable");}if(!o.getActiveHandling()){r.class("sapMCbActiveStateOff");}r.class("sapMCbMark");if(o.getSelected()){r.class("sapMCbMarkChecked");}if(o.getPartiallySelected()){r.class("sapMCbMarkPartiallyChecked");}r.openEnd();r.voidStart("input",o.getId()+"-CB");r.attr("type","CheckBox");if(o.getSelected()){r.attr("checked","checked");}if(o.getName()){r.attr("name",o.getName());}if(!e){r.attr("disabled","disabled");}if(!E){r.attr("readonly","readonly");}r.voidEnd();r.close("div");r.renderControl(f);if(t&&sap.ui.getCore().getConfiguration().getAccessibility()&&l){r.openStart("span",i+"-Descr");r.class("sapUiHidden");r.openEnd();r.text(t);r.close("span");}r.close("div");};
C.getTooltipText=function(o){var v=o.getProperty("valueStateText"),t=o.getTooltip_AsString(),e=o.getEnabled(),E=o.getEditable();if(v){return(t?t+" - ":"")+v;}else if(E&&e){return V.enrichTooltip(o,t);}return t;};
return C;},true);
sap.ui.predefine('sap/m/ColorPalette',['sap/ui/core/Control','sap/ui/Device','sap/ui/base/DataType','sap/ui/core/library','sap/ui/core/delegate/ItemNavigation','./Button','./Dialog','./library','./ColorPaletteRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/unified/library","sap/ui/unified/ColorPickerDisplayMode","sap/ui/unified/ColorPicker"],function(C,D,a,c,I,B,b,l,d,e,K,q,u,f,g){"use strict";var h=c.CSSColor;var i=u.ColorPickerMode;var j=l.ButtonType;var k=a.getType("boolean");var m="sapMColorPaletteSquare";var S=5;var M=2;var n=15;var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");
var o=C.extend("sap.m.ColorPalette",{metadata:{library:"sap.m",properties:{colors:{type:"sap.ui.core.CSSColor[]",group:"Appearance",defaultValue:["gold","darkorange","indianred","darkmagenta","cornflowerblue","deepskyblue","darkcyan","olivedrab","darkslategray","azure","white","lightgray","darkgray","dimgray","black"]}},aggregations:{_defaultColorButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_moreColorsButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{colorSelect:{parameters:{"value":{type:"sap.ui.core.CSSColor"},"defaultAction":{type:"boolean"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}}});
o.prototype.init=function(){this._oDefaultColor=null;this._bShowDefaultColorButton=false;this._bShowMoreColorsButton=false;this._bShowRecentColorsSection=false;this._oDisplayMode=f.Default;this._oMoreColorsDialog=null;this._oPaletteColorItemNavigation=null;this._oRecentColorItemNavigation=null;this._recentColors=[];};
o.prototype.exit=function(){if(this._oMoreColorsDialog){this._oMoreColorsDialog.destroy();delete this._oMoreColorsDialog;}if(this._oPaletteColorItemNavigation){this.removeDelegate(this._oPaletteColorItemNavigation);this._oPaletteColorItemNavigation.destroy();delete this._oPaletteColorItemNavigation;}if(this._oRecentColorItemNavigation){this.removeDelegate(this._oRecentColorItemNavigation);this._oRecentColorItemNavigation.destroy();delete this._oRecentColorItemNavigation;}};
o.prototype.setColors=function(r){r=this.validateProperty("colors",r);if(r.length<M||r.length>n){throw new Error("Cannot set property 'colors' - array must has minimum 2 and maximum 15 elements");}return this.setProperty("colors",r);};
o.prototype._setDisplayMode=function(r){var s=this._getColorPicker();s.setDisplayMode(r);this._oDisplayMode=r;return this;};
o.prototype._getDisplayMode=function(){return this._oDisplayMode;};
o.prototype._getColorPicker=function(){return this._ensureMoreColorsDialog()._oColorPicker;};
o.prototype.ontap=function(E){var t=q(E.target),s,$;$=t.closest("."+m);if(!$.length){return;}s=$.attr("data-sap-ui-color");this._fireColorSelect(s,false,E);};
o.prototype.onsaptabnext=o.prototype.onsaptabprevious=function(E){var r=this._getElementInfo(E.target);if(r.bIsMoreColorsButton){this.fireEvent("_colorNotSelected",{_originalEvent:E});return;}if(r.bIsDefaultColorButton){this._fireColorSelect(this._getDefaultColor(),true,E);return;}o.prototype.ontap.apply(this,arguments);};o.prototype.onsapenter=o.prototype.ontap;
o.prototype.onsapspace=function(E){E.preventDefault();};
o.prototype.onkeyup=function(E){if(E.which===K.SPACE){E.preventDefault();o.prototype.ontap.apply(this,arguments);}};
o.prototype.onAfterRendering=function(){this._ensureItemNavigation();};
o.prototype.pushToRecentColors=function(s){var r=this._recentColors.indexOf(s);if(r>-1){this._recentColors.splice(r,1);}else if(this._recentColors.length===5){this._recentColors.pop();}this._recentColors.unshift(s);this.invalidate();};
o.prototype.setColorPickerSelectedColor=function(r){if(!h.isValid(r)){throw new Error("Cannot set the selected color - invalid value: "+r);}this._getColorPicker().setColorString(r);return this;};
o.prototype._createDefaultColorButton=function(){return new B(this.getId()+"-btnDefaultColor",{width:"100%",type:j.Transparent,text:L.getText("COLOR_PALETTE_DEFAULT_COLOR"),visible:this._getShowDefaultColorButton(),press:function(E){this._fireColorSelect(this._getDefaultColor(),true,E);}.bind(this)});};
o.prototype._getDefaultColor=function(){return this._oDefaultColor;};
o.prototype._setDefaultColor=function(r){if(!h.isValid(r)){throw new Error("Cannot set internal property '_defaultColor' - invalid value: "+r);}this._oDefaultColor=r;return this;};
o.prototype._getShowDefaultColorButton=function(){return this._bShowDefaultColorButton;};
o.prototype._setShowDefaultColorButton=function(v){if(!k.isValid(v)){throw new Error("Cannot set internal property 'showDefaultColorButton' - invalid value: "+v);}this._bShowDefaultColorButton=v;if(v&&!this._getDefaultColorButton()){this.setAggregation("_defaultColorButton",this._createDefaultColorButton());}if(this._getDefaultColorButton()){this._getDefaultColorButton().setVisible(v);}return this;};
o.prototype._getDefaultColorButton=function(){return this.getAggregation("_defaultColorButton");};
o.prototype._createMoreColorsButton=function(){return new B(this.getId()+"-btnMoreColors",{width:"100%",type:j.Transparent,text:L.getText("COLOR_PALETTE_MORE_COLORS"),visible:this._getShowMoreColorsButton(),press:this._openColorPicker.bind(this)});};
o.prototype._getShowMoreColorsButton=function(){return this._bShowMoreColorsButton;};
o.prototype._getShowRecentColorsSection=function(){return this._bShowRecentColorsSection;};
o.prototype._getRecentColors=function(){return this._recentColors;};
o.prototype._setShowRecentColorsSection=function(v){if(!k.isValid(v)){throw new Error("Cannot set internal property 'showRecentColorsSection' - invalid value: "+v);}this._bShowRecentColorsSection=v;return this;};
o.prototype._setShowMoreColorsButton=function(v){if(!k.isValid(v)){throw new Error("Cannot set internal property 'showMoreColorsButton' - invalid value: "+v);}this._bShowMoreColorsButton=v;if(v&&!this._getMoreColorsButton()){this.setAggregation("_moreColorsButton",this._createMoreColorsButton());}if(this._getMoreColorsButton()){this._getMoreColorsButton().setVisible(v);}return this;};
o.prototype._getMoreColorsButton=function(){return this.getAggregation("_moreColorsButton");};
o.prototype._openColorPicker=function(){this.fireEvent("_beforeOpenColorPicker");this._ensureMoreColorsDialog().open();};
o.prototype._ensureMoreColorsDialog=function(){if(!this._oMoreColorsDialog){this._oMoreColorsDialog=this._createMoreColorsDialog();}return this._oMoreColorsDialog;};
o.prototype._createMoreColorsDialog=function(){var r=new b(this.getId()+"-moreColorsDialog",{stretch:!!D.system.phone,title:L.getText("COLOR_PALETTE_MORE_COLORS_TITLE")}).addStyleClass("CPDialog");r.addContent(r._oColorPicker=new g({mode:i.HSL,displayMode:this._oDisplayMode,liveChange:function(E){this.fireLiveChange(E.getParameters());}.bind(this)}));r.setBeginButton(new B({text:L.getText("COLOR_PALETTE_MORE_COLORS_CONFIRM"),press:function(E){r.close();if(r._oColorPicker.getColorString()){this._fireColorSelect(r._oColorPicker.getColorString(),false,E);}}.bind(this)}));r.setEndButton(new B({text:L.getText("COLOR_PALETTE_MORE_COLORS_CANCEL"),press:function(){r.close();}}));return r;};
o.prototype._focusFirstElement=function(){var F=this._getShowDefaultColorButton()?this._getDefaultColorButton().getDomRef():this._getAllPaletteColorSwatches()[0];F.focus();};
o.prototype._fireColorSelect=function(r,s,O){this.fireColorSelect({value:r,defaultAction:s,_originalEvent:O});this.pushToRecentColors(r);};
o.prototype._ensureItemNavigation=function(){var P=[],r=[];if(!this._oPaletteColorItemNavigation){this._oPaletteColorItemNavigation=new p(this);this._oPaletteColorItemNavigation.setColumns(S);this._oPaletteColorItemNavigation.setCycling(false);this.addDelegate(this._oPaletteColorItemNavigation);this._oPaletteColorItemNavigation.attachEvent(I.Events.BorderReached,this._onSwatchContainerBorderReached,this);}if(!this._oRecentColorItemNavigation){this._oRecentColorItemNavigation=new p(this);this._oRecentColorItemNavigation.setColumns(S);this._oRecentColorItemNavigation.setCycling(false);this.addDelegate(this._oRecentColorItemNavigation);this._oRecentColorItemNavigation.attachEvent(I.Events.BorderReached,this._onSwatchContainerBorderReached,this);}P=P.concat(this._getAllPaletteColorSwatches());r=r.concat(this._getAllRecentColorSwatches());r=r.slice(0,this._getRecentColors().length);this._oPaletteColorItemNavigation.setRootDomRef(this.getDomRef("swatchCont-paletteColor"));this._oPaletteColorItemNavigation.setItemDomRefs(P);this._oRecentColorItemNavigation.setRootDomRef(this.getDomRef("swatchCont-recentColors"));this._oRecentColorItemNavigation.setItemDomRefs(r);};
o.prototype._onSwatchContainerBorderReached=function(E){var N,s,H=["saphome","sapend"].indexOf(E.getParameter("event").type)>-1,r=this._getAllRecentColorSwatches()[0]?this._getElementInfo(E.mParameters.event.target).bIsRecentColorSwatch:false;if(E.getParameter(p.BorderReachedDirection)===p.BorderReachedDirectionForward){if(this._getShowMoreColorsButton()&&!r){N=this._getMoreColorsButton();}else if(!H&&this._bShowRecentColorsSection&&!r&&this._getRecentColors().length>0){N=this._getAllRecentColorSwatches()[0];}else if(!H&&this._getShowDefaultColorButton()){N=this._getDefaultColorButton();}else if(!H){N=this._getAllPaletteColorSwatches()[0];}}else{if(this._getShowDefaultColorButton()&&!r){N=this._getDefaultColorButton();}else if(!H&&this._bShowRecentColorsSection&&!r&&this._getRecentColors().length>0){N=this._getAllRecentColorSwatches()[0];}else if(!H&&this._getShowMoreColorsButton()){N=this._getMoreColorsButton();}else if(!H&&!this._getShowDefaultColorButton()){s=this._getAllPaletteColorSwatches();N=s[s.length-1];}else if(!H){s=this._getAllPaletteColorSwatches();N=s[this._oPaletteColorItemNavigation._getIndexOfTheFirstItemInLastRow()];}}if(N){N.focus();}return N;};
o.prototype.onsapnext=function(E){var N,r=this._getElementInfo(E.target);if(!(r.bIsDefaultColorButton||r.bIsMoreColorsButton)){return;}E.preventDefault();E.stopImmediatePropagation(true);if(r.bIsDefaultColorButton){N=this._getAllPaletteColorSwatches()[0];}else if(this._getRecentColors().length>0&&!r.bIsRecentColorSwatch&&this._bShowRecentColorsSection){N=this._getAllRecentColorSwatches()[0];}else{N=this._getShowDefaultColorButton()?this._getDefaultColorButton():this._getAllPaletteColorSwatches()[0];}N.focus();};
o.prototype.onsapprevious=function(E){var N,F=this._getElementInfo(E.target),A;if(!(F.bIsDefaultColorButton||F.bIsMoreColorsButton||E.target===this._getAllRecentColorSwatches()[0])){return;}E.preventDefault();E.stopImmediatePropagation(true);A=this._getAllPaletteColorSwatches();if(F.bIsMoreColorsButton||(!F.bIsMoreColorsButton&&this.bIsRecentColorSwatch)){N=E.keyCode===K.ARROW_UP?A[this._oPaletteColorItemNavigation._getIndexOfTheFirstItemInLastRow()]:A[A.length-1];}else if(F.bIsRecentColorSwatch&&!this._bShowMoreColorsButton&&!this._bShowDefaultColorButton){A=this._getAllPaletteColorSwatches();N=A[this._oPaletteColorItemNavigation._getIndexOfTheFirstItemInLastRow()];}else if(this._getRecentColors().length>0&&!F.bIsRecentColorSwatch&&this._bShowRecentColorsSection){N=this._getAllRecentColorSwatches()[0];}else if(this._getShowMoreColorsButton()){N=this._getMoreColorsButton();}else{N=A[this._oPaletteColorItemNavigation._getIndexOfTheFirstItemInLastRow()];}N.focus();};
o.prototype.onsaphome=function(E){var r=this._getElementInfo(E.target);if(!r.bIsMoreColorsButton){return;}if(this._getShowDefaultColorButton()){this._getDefaultColorButton().focus();}E.preventDefault();E.stopImmediatePropagation(true);};
o.prototype.onsapend=function(E){var r=this._getElementInfo(E.target);if(!r.bIsDefaultColorButton){return;}if(this._getShowMoreColorsButton()){this._getMoreColorsButton().focus();}E.preventDefault();E.stopImmediatePropagation(true);};
o.prototype._getAllPaletteColorSwatches=function(){return this.$().find("."+m).get().slice(0,this.getColors().length);};
o.prototype._getAllRecentColorSwatches=function(){return this.$().find("."+m).get().slice(this.getColors().length);};
o.prototype._getElementInfo=function(E){var r=this._getShowDefaultColorButton()&&e(E,this._getDefaultColorButton().getDomRef()),s=!r&&this._getShowMoreColorsButton()&&e(E,this._getMoreColorsButton().getDomRef()),t=this._getAllRecentColorSwatches().indexOf(E)>-1,v=this._getAllPaletteColorSwatches().indexOf(E)>-1;return{bIsDefaultColorButton:r,bIsMoreColorsButton:s,bIsASwatch:v,bIsRecentColorSwatch:t};};
var p=I.extend("sap.m.ItemNavigationHomeEnd",{constructor:function(){I.apply(this,arguments);this.setHomeEndColumnMode(true);this.fireEvent=function(N,E){var s;if(N===I.Events.BorderReached){s=p.BorderReachedDirectionBackward;if(["sapnext","sapend"].indexOf(E.event.type)>-1){s=p.BorderReachedDirectionForward;}E[p.BorderReachedDirection]=s;}I.prototype.fireEvent.apply(this,arguments);};}});
p.BorderReachedDirection="direction";p.BorderReachedDirectionForward="BorderReachedDirectionForward";p.BorderReachedDirectionBackward="BorderReachedDirectionBackward";
p.prototype.getColumns=function(){return this.iColumns;};
p.prototype.onsapprevious=function(E){var r=e(this.getRootDomRef(),E.target),A=E.keyCode===K.ARROW_UP&&this.getFocusedIndex()===0;if(!r){return;}if(!A){I.prototype.onsapprevious.apply(this,arguments);return;}E.preventDefault();this.fireEvent(I.Events.BorderReached,{index:0,event:E});};
p.prototype.onsapnext=function(E){var r=e(this.getRootDomRef(),E.target),s,t,v;if(!r){return;}if(E.keyCode!==K.ARROW_DOWN){I.prototype.onsapnext.apply(this,arguments);return;}t=this.getFocusedIndex();v=this._getItemInfo(t);if(v.bIsLastItem&&v.bIsInTheLastColumn){E.preventDefault();this.fireEvent(I.Events.BorderReached,{index:t,event:E});return;}if(v.bNextRowExists&&!v.bItemSameColumnNextRowExists){E.preventDefault();s=this.getItemDomRefs();s[s.length-1].focus();return;}I.prototype.onsapnext.apply(this,arguments);};
p.prototype.onsaphome=function(E){var r=e(this.getRootDomRef(),E.target),s;if(!r){return;}s=this._getItemInfo(this.getFocusedIndex());if(!s.bIsInTheFirstColumn){I.prototype.onsaphome.apply(this,arguments);return;}E.preventDefault();if(s.bIsFirstItem){this.fireEvent(I.Events.BorderReached,{index:0,event:E});}else{this.getItemDomRefs()[0].focus();}};
p.prototype.onsapend=function(E){var r=e(this.getRootDomRef(),E.target),s;if(!r){return;}s=this._getItemInfo(this.getFocusedIndex());if(!(s.bIsLastItem||s.bIsInTheLastColumn)){I.prototype.onsapend.apply(this,arguments);return;}E.preventDefault();if(s.bIsLastItem){this.fireEvent(I.Events.BorderReached,{index:this.getItemDomRefs().length-1,event:E});}else{this.getItemDomRefs()[this.getItemDomRefs().length-1].focus();}};
p.prototype._getItemInfo=function(r){var s=this.getItemDomRefs().length,t=r===(s-1),v=s>this.getColumns()?this.getColumns():s,w=r%this.getColumns()===0,x=(r+1)%v===0,y=Math.floor(r/this.getColumns())+1,N,z;N=y*this.getColumns()<s;z=N&&(r+this.getColumns())<s;return{bIsFirstItem:r===0,bIsLastItem:t,bIsInTheLastColumn:x,bIsInTheFirstColumn:w,bNextRowExists:N,bItemSameColumnNextRowExists:z};};
p.prototype._getIndexOfTheFirstItemInLastRow=function(){return Math.floor((this.getItemDomRefs().length-1)/this.getColumns())*this.getColumns();};
o.prototype._ItemNavigation=p;o.prototype._ColorsHelper={RGB_TO_NAMED_COLORS_MAP:{"#FFB200":"gold","#FF8C00":"darkorange","#CD5C5C":"indianred","#8B008B":"darkmagenta","#6495ED":"cornflowerblue","#00BFFF":"deepskyblue","#008B8B":"darkcyan","#6B8E23":"olivedrab","#2F4F4F":"darkslategray","#F0FFFF":"azure","#FFFFFF":"white","#D3D3D3":"lightgray","#A9A9A9":"darkgray","#696969":"dimgray","#000000":"black"},NAME_COLORS_TO_RGB_MAP:{"gold":"#FFB200","darkorange":"#FF8C00","indianred":"#CD5C5C","darkmagenta":"#8B008B","cornflowerblue":"#6495ED","deepskyblue":"#00BFFF","darkcyan":"#008B8B","olivedrab":"#6B8E23","darkslategray":"#2F4F4F","azure":"#F0FFFF","white":"#FFFFFF","lightgray":"#D3D3D3","darkgray":"#A9A9A9","dimgray":"#696969","black":"#000000"},getNamedColor:function(s){var H="";if(!s||s.toLowerCase().indexOf("hsl")!==-1){return undefined;}if(s.indexOf("#")===-1){return this.NAME_COLORS_TO_RGB_MAP[s.toLowerCase()]?s.toLowerCase():undefined;}if(s.length===4){H=["#",s[1],s[1],s[2],s[2],s[3],s[3]].join("");}else{H=s;}H=H.toUpperCase();return this.RGB_TO_NAMED_COLORS_MAP[H];}};return o;});
sap.ui.predefine('sap/m/ColorPalettePopover',['sap/ui/core/Control','sap/ui/Device','sap/ui/unified/ColorPickerDisplayMode','./Button','./ResponsivePopover','./ColorPalette','./library'],function(C,D,a,B,R,b,l){"use strict";var P=l.PlacementType;
var c=C.extend("sap.m.ColorPalettePopover",{
metadata:{library:"sap.m",publicMethods:["openBy","close"],properties:{defaultColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},colors:{type:"sap.ui.core.CSSColor[]",group:"Appearance",defaultValue:["gold","darkorange","indianred","darkmagenta","cornflowerblue","deepskyblue","darkcyan","olivedrab","darkslategray","azure","white","lightgray","darkgray","dimgray","black"]},showDefaultColorButton:{type:"boolean",group:"Appearance",defaultValue:true},showMoreColorsButton:{type:"boolean",group:"Appearance",defaultValue:true},showRecentColorsSection:{type:"boolean",group:"Appearance",defaultValue:true},displayMode:{type:"sap.ui.unified.ColorPickerDisplayMode",group:"Appearance",defaultValue:a.Default}},events:{colorSelect:{parameters:{"value":{type:"sap.ui.core.CSSColor"},"defaultAction":{type:"boolean"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}},
renderer:{apiVersion:2}
});
var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");var F={COLOR_PALETTE_PROPS:{colors:"setColors",defaultColor:"_setDefaultColor",showDefaultColorButton:"_setShowDefaultColorButton",showMoreColorsButton:"_setShowMoreColorsButton",showRecentColorsSection:"_setShowRecentColorsSection",displayMode:"_setDisplayMode"},POPOVER_METHODS:{getDomRef:"",close:"",openBy:""}};
c.prototype.init=function(){this._oPopover=null;this._bPopoverDestroying=null;};
c.prototype.exit=function(){this._bPopoverDestroying=true;if(this._oPopover){this._oPopover.removeDelegate(this._oPopover._onAfterRenderingDelegate);this._oPopover.destroy();this._oPopover=null;}};
c.prototype.setColorPickerSelectedColor=function(d){this._getPalette().setColorPickerSelectedColor(d);return this;};
c.prototype._getPalette=function(){return this._ensurePopover().getContent()[0];};
c.prototype._ensurePopover=function(){if(!this._oPopover){this._oPopover=this._createPopover();}return this._oPopover;};
c.prototype._createPopover=function(){var p,o=this._createColorPalette(),d;p=new R(this.getId()+"-colorPalettePopover",{showHeader:D.system.phone,placement:P.VerticalPreferredBottom,showArrow:false,showCloseButton:false,title:L.getText("COLOR_PALETTE_TITLE"),content:o,afterOpen:o._focusFirstElement.bind(o)}).addStyleClass("sapMColorPaletteContainer");if(D.system.phone){p.setEndButton(new B({text:L.getText("COLOR_PALETTE_CANCEL"),press:function(){p.close();}}));}o.attachEvent("_beforeOpenColorPicker",function(){p.close();});o.attachEvent("_colorNotSelected",function(e){this._handleNextOrPreviousUponPaletteClose(e);p.close();}.bind(this));o.attachEvent("colorSelect",function(e){this._handleNextOrPreviousUponPaletteClose(e);p.close();this.fireColorSelect({"value":e.getParameter("value"),"defaultAction":e.getParameter("defaultAction")});}.bind(this));d={onAfterRendering:function(){var $=this.$();$.attr("aria-modal","true");$.attr("aria-label",this.getTitle());}};p.addEventDelegate(d,p);p._onAfterRenderingDelegate=d;return p;};
c.prototype._createColorPalette=function(){var o=new b(this.getId()+"-palette",{liveChange:function(e){this.fireLiveChange(e.getParameters());}.bind(this)});o._setShowDefaultColorButton(this.getShowDefaultColorButton());o._setShowMoreColorsButton(this.getShowMoreColorsButton());o._setShowRecentColorsSection(this.getShowRecentColorsSection());return o;};
c.prototype._handleNextOrPreviousUponPaletteClose=function(e){var o=e.getParameter("_originalEvent");if(!o){return;}if(o.type==="saptabnext"||o.type==="saptabprevious"){o.stopPropagation();o.preventDefault();}};
c.prototype.setProperty=function(p,v,s){var t;if(F.COLOR_PALETTE_PROPS[p]!==undefined){t=F.COLOR_PALETTE_PROPS[p]||p;b.prototype[t].call(this._getPalette(),v);}return C.prototype.setProperty.apply(this,arguments);};
Object.keys(F.POPOVER_METHODS).forEach(function(s){var t=F.COLOR_PALETTE_PROPS[s]||s;c.prototype[s]=function(){if(this._bPopoverDestroying){return null;}var p=this._ensurePopover();return p[t].apply(p,arguments);};});return c;});
sap.ui.predefine('sap/m/ColorPaletteRenderer',['sap/ui/Device'],function(D){"use strict";var C={apiVersion:2};var l=sap.ui.getCore().getLibraryResourceBundle("sap.m");
C.render=function(r,c){r.openStart("div",c);r.class("sapMColorPalette");r.openEnd();if(c._getShowDefaultColorButton()){this.renderDefaultColorButton(r,c);this.renderSeparator(r);}this.renderSwatches(r,c);if(c._getShowMoreColorsButton()){this.renderSeparator(r);this.renderMoreColorsButton(r,c);if(D.system.phone){this.renderSeparator(r);}}if(c._getShowRecentColorsSection()){if(!c._getShowMoreColorsButton()||!D.system.phone){this.renderSeparator(r);}this.renderRecentColorsSection(r,c);if(D.system.phone){this.renderSeparator(r);}}r.close("div");};
C.renderSwatches=function(r,c){var s=c.getColors();r.openStart("div",c.getId()+"-swatchCont-paletteColor");r.class("sapMColorPaletteContent");r.accessibilityState(c,{"role":"region","label":l.getText("COLOR_PALETTE_SWATCH_CONTAINER_TITLE")});r.openEnd();s.forEach(function(a,i){this.renderSquare(r,c,a,i,false);},this);r.close("div");};
C.renderSquare=function(r,c,s,i,I){var n=c._ColorsHelper.getNamedColor(s),a=(n===undefined)?l.getText("COLOR_PALETTE_PREDEFINED_COLOR_CUSTOM"):l.getText("COLOR_PALETTE_PREDEFINED_COLOR_"+n.toUpperCase()),b=I?l.getText("COLOR_PALETTE_RECENT_COLOR",[i+1,a]):l.getText("COLOR_PALETTE_PREDEFINED_COLOR",[i+1,a]);r.openStart("div");r.class("sapMColorPaletteSquare");if(I&&s===""){r.class("sapMRecentColorSquareDisabled");}r.attr("data-sap-ui-color",s);r.attr("tabindex","-1");r.attr("title",b);r.accessibilityState(c,{"role":"button","label":b});r.openEnd();r.openStart("div");r.style("background-color",s);r.openEnd();r.close("div");r.close("div");};
C.renderSeparator=function(r){r.openStart("div");r.class("sapMColorPaletteSeparator");r.openEnd();r.voidStart("hr");r.voidEnd();r.close("div");};
C.renderDefaultColorButton=function(r,c){r.renderControl(c._getDefaultColorButton());};
C.renderMoreColorsButton=function(r,c){r.renderControl(c._getMoreColorsButton());};
C.renderRecentColorsSection=function(r,c){var s,R=c._getRecentColors(),a=5,b=l.getText("COLOR_PALETTE_SWATCH_RECENT_COLOR_CONTAINER_TITLE");r.openStart("div",c.getId()+"-swatchCont-recentColors");r.class("sapMColorPaletteContent");r.attr("role","region");r.attr("aria-label",b);r.openEnd();for(var i=0;i<a;i++){if(R[i]){s=R[i];}else{s="";}this.renderSquare(r,c,s,i,true);}r.close("div");};
return C;},true);
sap.ui.predefine('sap/m/Column',['./library','sap/ui/core/Element','sap/ui/core/Renderer','sap/ui/core/library','sap/ui/Device',"sap/ui/thirdparty/jquery"],function(l,E,R,c,D,q){"use strict";var P=l.PopinDisplay;var V=c.VerticalAlign;var T=c.TextAlign;var S=c.SortOrder;
var C=E.extend("sap.m.Column",{metadata:{library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},hAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:V.Inherit},styleClass:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},minScreenWidth:{type:"string",group:"Behavior",defaultValue:null},demandPopin:{type:"boolean",group:"Behavior",defaultValue:false},popinHAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin,deprecated:true},popinDisplay:{type:"sap.m.PopinDisplay",group:"Appearance",defaultValue:P.Block},mergeDuplicates:{type:"boolean",group:"Behavior",defaultValue:false},mergeFunctionName:{type:"string",group:"Misc",defaultValue:'getText'},sortIndicator:{type:"sap.ui.core.SortOrder",group:"Appearance",defaultValue:S.None},importance:{type:"sap.ui.core.Priority",group:"Behavior",defaultValue:"None"},autoPopinWidth:{type:"float",group:"Behavior",defaultValue:8}},defaultAggregation:"header",aggregations:{header:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.ui.core.Control",multiple:false}},associations:{columnHeaderMenu:{type:"sap.ui.core.IColumnHeaderMenu",multiple:false,visibility:"hidden"}},designtime:"sap/m/designtime/Column.designtime"}});
C.prototype._index=-1;C.prototype._screen="";C.prototype._media=null;C.prototype._bForcedColumn=false;
C.prototype.exit=function(){this._clearMedia();};
C.prototype.getTable=function(){var p=this.getParent();if(p&&p.isA("sap.m.Table")){return p;}};
C.prototype.informTable=function(e,p,v){var t=this.getTable();if(t){var m="onColumn"+e;if(t[m]){t[m](this,p,v);}}};
C.prototype.ontouchstart=function(e){this._bTouchStartMarked=e.isMarked();};
C.prototype.ontap=function(e){if(!this._bTouchStartMarked&&!e.isMarked()){this.informTable("Press");}};
C.prototype.onsapspace=function(e){if(e.srcControl===this){this.informTable("Press");e.preventDefault();}};
C.prototype.onsapenter=C.prototype.onsapspace;
C.prototype.invalidate=function(){var p=this.getParent();if(!p||!p.bOutput){return;}E.prototype.invalidate.apply(this,arguments);};
C.prototype._clearMedia=function(){if(this._media&&this._minWidth){this._detachMediaContainerWidthChange(this._notifyResize,this,this.getId());D.media.removeRangeSet(this.getId());this._media=null;}};
C.prototype._addMedia=function(){delete this._bShouldAddMedia;if(this._minWidth){D.media.initRangeSet(this.getId(),[parseFloat(this._minWidth)]);this._attachMediaContainerWidthChange(this._notifyResize,this,this.getId());this._media=this._getCurrentMediaContainerRange(this.getId());if(this._media){this._media.matches=!!this._media.from;}}};
C.prototype._notifyResize=function(m){if(this._media.from===m.from){return;}this._media=m;this._media.matches=!!m.from;setTimeout(function(){if(!this.getVisible()){return;}this.fireEvent("media",this);this.informTable("Resize");}.bind(this),0);};
C.prototype._validateMinWidth=function(w){if(!w){return;}if(Object.prototype.toString.call(w)!="[object String]"){throw new Error('expected string for property "minScreenWidth" of '+this);}if(Object.keys(l.ScreenSizes).indexOf(w.toLowerCase())!=-1){return;}if(!/^\d+(\.\d+)?(px|em|rem)$/i.test(w)){throw new Error('invalid CSS size("px", "em", "rem" required) or sap.m.ScreenSize enumeration for property "minScreenWidth" of '+this);}};
C.prototype._isWidthPredefined=function(w){var t=this,u=w.replace(/[^a-z]/ig,""),b=parseFloat(l.BaseFontSize)||16;q.each(l.ScreenSizes,function(s,a){if(u!="px"){a/=b;}if(a+u==w){t._minWidth=this+"px";t._screen=s;return false;}});if(this._minWidth){return true;}if(u=="px"){this._minWidth=w;}else{this._minWidth=parseFloat(w)*b+"px";}};
C.prototype.getCssAlign=function(a){a=a||this.getHAlign();if(a===T.Begin||a===T.End||a===T.Initial){a=R.getTextAlign(a);}return a.toLowerCase();};
C.prototype.getStyleClass=function(r){var a=this.getProperty("styleClass");if(!r){return a;}if(this._screen&&(!this.getDemandPopin()||!window.matchMedia)){a+=" sapMSize-"+this._screen;}else if(this._media&&!this._media.matches){a+=" sapMListTblNone";}return a.trim();};
C.prototype.setIndex=function(n){this._index=+n;};
C.prototype.getIndex=function(){return this._index;};
C.prototype.setOrder=function(n){this._order=+n;};
C.prototype.getOrder=function(){return this.hasOwnProperty("_order")?this._order:this.getInitialOrder();};
C.prototype.setInitialOrder=function(n){this._initialOrder=+n;};
C.prototype.getInitialOrder=function(){if(this.hasOwnProperty("_initialOrder")){return this._initialOrder;}var t=this.getTable();if(!t){return-1;}return t.indexOfColumn(this);};
C.prototype.setDisplay=function(t,d){if(!t||this._index<0){return;}var i=this._index+1,p=this.getParent(),a=d&&!this.isHidden()?"table-cell":"none",h=t.querySelector("tr > th:nth-child("+i+")"),b=t.querySelectorAll("tr > td:nth-child("+i+")"),e=b.length;h.style.display=a;h.setAttribute("aria-hidden",!d);for(i=0;i<e;i++){b[i].style.display=a;b[i].setAttribute("aria-hidden",!d);}if(p&&p.setTableHeaderVisibility){setTimeout(function(){p.setTableHeaderVisibility(d);},0);}};
C.prototype.setVisible=function(v){if(v==this.getVisible()){return this;}var p=this.getParent(),t=p&&p.getTableDomRef&&p.getTableDomRef(),s=t&&this._index>=0&&!p.getAutoPopinMode()&&!this._bForcedColumn;if(s){this.setProperty("visible",v,s);this.setDisplay(t,v);}else{this.setProperty("visible",v);}return this;};
C.prototype._setMinScreenWidth=function(w){this._clearMedia();this._minWidth=0;this._screen="";if(w){w=w.toLowerCase();var a=l.ScreenSizes[w];if(a){this._screen=w;this._minWidth=a+"px";}else{this._isWidthPredefined(w);}var p=this.getTable();if(p&&p.isActive()){this._addMedia();}else{this._bShouldAddMedia=true;}}};
C.prototype.setMinScreenWidth=function(w){w=w||"";if(w==this.getMinScreenWidth()){return this;}this._validateMinWidth(w);this._setMinScreenWidth(w);return this.setProperty("minScreenWidth",w);};
C.prototype.setDemandPopin=function(v){if(v==this.getDemandPopin()){return this;}if(!this.getMinScreenWidth()){return this.setProperty("demandPopin",v,true);}return this.setProperty("demandPopin",v);};
C.prototype.setSortIndicator=function(s){this.setProperty("sortIndicator",s,true);this.$().attr("aria-sort",this.getSortIndicator().toLowerCase());return this;};
C.prototype.isPopin=function(){if(!this.getDemandPopin()){return false;}var t=this.getTable();if(t){var h=t.getHiddenInPopin()||[];var H=h.some(function(i){return this.getImportance()===i;},this);if(H){return false;}}if(this._media){return!this._media.matches;}return false;};
C.prototype.isHidden=function(){if(this._media){return!this._media.matches;}if(this._screen&&this._minWidth){return parseFloat(this._minWidth)>window.innerWidth;}return false;};
C.prototype.setLastValue=function(v){if(this.getMergeDuplicates()){this._lastValue=v;}return this;};
C.prototype.clearLastValue=function(){return this.setLastValue(NaN);};
C.prototype.getLastValue=function(){return this._lastValue;};
C.prototype.onItemsRemoved=function(){this.clearLastValue();};
C.prototype.getFocusDomRef=function(){var p=this.getParent();if(p&&(p.bActiveHeaders||p.bFocusableHeaders||this.getAssociation("columnHeaderMenu"))){var o=this.getDomRef();if(o){return o.firstChild;}}return E.prototype.getFocusDomRef.apply(this,arguments);};
C.prototype.getCalculatedMinScreenWidth=function(){return parseInt(this._minWidth)||0;};
C.prototype.setForcedColumn=function(f){if(this._bForcedColumn==f){return;}this._bForcedColumn=f;this._setMinScreenWidth(f?"":this.getMinScreenWidth());};
C.prototype.getColumnHeaderMenu=function(){return sap.ui.getCore().byId(this.getAssociation("columnHeaderMenu"));};
return C;});
sap.ui.predefine('sap/m/ColumnListItem',["sap/ui/core/Element","sap/ui/core/library","./library","./ListItemBase","./ColumnListItemRenderer","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Selectors"],function(E,c,l,L,C,q){"use strict";var a=l.ListType;var V=c.VerticalAlign;
var b=L.extend("sap.m.ColumnListItem",{metadata:{library:"sap.m",properties:{vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:V.Inherit}},defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell",bindable:"bindable"}}}});
var T=E.extend("sap.m.TablePopin",{
ontap:function(e){if(e.isMarked()||L.detectTextSelection(this.getDomRef())){return e.stopImmediatePropagation(true);}if(e.srcControl===this||!q(e.target).is(":sapFocusable")){this.getParent().focus();}},
_onMouseEnter:function(){var $=q(this),d=$.prev();if(!d.length||!d.hasClass("sapMLIBHoverable")||d.hasClass("sapMPopinHovered")){return;}d.addClass("sapMPopinHovered");},
_onMouseLeave:function(){var $=q(this),d=$.prev();if(!d.length||!d.hasClass("sapMLIBHoverable")||!d.hasClass("sapMPopinHovered")){return;}d.removeClass("sapMPopinHovered");}
});
b.prototype.TagName="tr";b.prototype._bAnnounceNotSelected=true;
b.prototype.init=function(){L.prototype.init.call(this);this._bNeedsTypeColumn=false;this._aClonedHeaders=[];};
b.prototype.onAfterRendering=function(){L.prototype.onAfterRendering.call(this);this._checkTypeColumn();var p=this.hasPopin();if(p){this.$Popin().on("mouseenter",p._onMouseEnter).on("mouseleave",p._onMouseLeave);}};
b.prototype.exit=function(){L.prototype.exit.call(this);this._checkTypeColumn(false);this._destroyClonedHeaders();if(this._oPopin){this._oPopin.destroy(true);this._oPopin=null;}};
b.prototype.setVisible=function(v){L.prototype.setVisible.call(this,v);if(!v&&this.hasPopin()){this.removePopin();}return this;};
b.prototype.getTable=function(){var p=this.getParent();if(p&&p.isA("sap.m.Table")){return p;}};
b.prototype.getPopin=function(){if(!this._oPopin){this._oPopin=new T({id:this.getId()+"-sub"}).addDelegate({ontouchstart:this.ontouchstart,ontouchmove:this.ontouchmove,ontap:this.ontap,ontouchend:this.ontouchend,ontouchcancel:this.ontouchcancel,onsaptabnext:this.onsaptabnext,onsaptabprevious:this.onsaptabprevious,onsapup:this.onsapup,onsapdown:this.onsapdown,oncontextmenu:this.oncontextmenu},this).setParent(this,null,true);}return this._oPopin;};
b.prototype.$Popin=function(){return this.$("sub");};
b.prototype.hasPopin=function(){return this._oPopin;};
b.prototype.removePopin=function(){this._oPopin&&this.$Popin().remove();};
b.prototype.getTabbables=function(){return this.$().add(this.$Popin()).find(":sapTabbable");};
b.prototype.getAccessibilityType=function(B){return B.getText("ACC_CTR_TYPE_ROW");};
b.prototype.getContentAnnouncement=function(B){var t=this.getTable();if(!t){return;}var o=[],d=this.getCells(),e=t.getColumns(true);e.sort(function(f,g){var i=f.getIndex(),h=g.getIndex(),I=i-h;if(I==0){return 0;}if(i<0){return 1;}if(h<0){return-1;}return I;}).forEach(function(f){var g=d[f.getInitialOrder()];if(!g||!f.getVisible()||(f.isHidden()&&!f.isPopin())){return;}var h=f.getHeader();if(h&&h.getVisible()){o.push(L.getAccessibilityText(h)+" "+L.getAccessibilityText(g,true));}else{o.push(L.getAccessibilityText(g,true));}});return o.join(" . ").trim();};
b.prototype.updateSelectedDOM=function(s,t){L.prototype.updateSelectedDOM.apply(this,arguments);if(this.hasPopin()){this.$Popin().attr("aria-selected",s);}};
b.prototype.onfocusin=function(e){if(e.isMarked()){return;}if(e.srcControl===this){this.$().children(".sapMListTblCellDup").find(":sapTabbable").attr("tabindex",-1);}L.prototype.onfocusin.apply(this,arguments);};
b.prototype._checkTypeColumn=function(n){if(n==undefined){n=this._needsTypeColumn();}if(this._bNeedsTypeColumn!=n){this._bNeedsTypeColumn=n;this.informList("TypeColumnChange",n);}};
b.prototype._needsTypeColumn=function(){var t=this.getType();return this.getVisible()&&(t==a.Detail||t==a.Navigation||t==a.DetailAndActive);};
b.prototype._addClonedHeader=function(h){return this._aClonedHeaders.push(h);};
b.prototype._destroyClonedHeaders=function(){if(this._aClonedHeaders.length){this._aClonedHeaders.forEach(function(o){o.destroy("KeepDom");});this._aClonedHeaders=[];}};
b.prototype._activeHandlingInheritor=function(){this._toggleActiveClass(true);};
b.prototype._inactiveHandlingInheritor=function(){this._toggleActiveClass(false);};
b.prototype._toggleActiveClass=function(s){if(this.hasPopin()){this.$Popin().toggleClass("sapMLIBActive",s);}};
return b;});
sap.ui.predefine('sap/m/ColumnListItemRenderer',["sap/ui/core/Renderer","sap/ui/core/library","sap/ui/core/Core","sap/ui/Device","sap/base/Log","./library","./ListItemBaseRenderer"],function(R,c,C,D,L,l,a){"use strict";var P=l.PopinDisplay;var V=c.VerticalAlign;var b=R.extend(a);b.apiVersion=2;
b.render=function(r,o){var t=o.getTable();if(!t){return;}a.render.apply(this,arguments);if(o.getVisible()&&t.hasPopin()){this.renderPopin(r,o,t);}};
b.renderHighlight=function(r,o){r.openStart("td");r.class("sapMListTblHighlightCell");r.attr("role","presentation");r.attr("aria-hidden","true");r.openEnd();a.renderHighlight.apply(this,arguments);r.close("td");};
b.renderNavigated=function(r,o){r.openStart("td");r.class("sapMListTblNavigatedCell");r.attr("role","presentation");r.attr("aria-hidden","true");r.openEnd();a.renderNavigated.apply(this,arguments);r.close("td");};
b.renderType=function(r,o){r.openStart("td");r.class("sapMListTblNavCol");r.attr("role","presentation");r.attr("aria-hidden","true");r.openEnd();a.renderType.apply(this,arguments);r.close("td");};
b.renderModeContent=function(r,o){r.openStart("td");r.class("sapMListTblSelCol");r.attr("role","presentation");r.attr("aria-hidden","true");r.openEnd();a.renderModeContent.apply(this,arguments);r.close("td");};
b.renderCounter=function(r,o){};
b.getAriaRole=function(o){return"";};
b.renderLIAttributes=function(r,o){r.class("sapMListTblRow");var A=o.getVAlign();if(A!=V.Inherit){r.class("sapMListTblRow"+A);}var t=o.getTable();if(t&&t.getAlternateRowColors()){var p=t.indexOfItem(o);if(p%2==0){r.class("sapMListTblRowAlternate");}}};
b.renderLIContentWrapper=function(r,o){var t=o.getTable();if(!t){return;}var d=t.getColumns(true),e=o.getCells();o._destroyClonedHeaders();d.forEach(function(f,i){var h,g=true,j=e[f.getInitialOrder()];if(!f.getVisible()||!j||f.isPopin()){f.setIndex(-1);return;}r.openStart("td",o.getId()+"_cell"+i);r.class("sapMListTblCell");r.attr("data-sap-ui-column",f.getId());if(f){var s=f.getStyleClass(true).split(" ");s&&s.forEach(function(u){r.class(u);});h=f.getHeader();if(h){r.attr("headers",f.getId());}if(!t.hasPopin()&&f.getMergeDuplicates()){var F=f.getMergeFunctionName(),k=F.split("#"),m=k[1],n=k[0];if(typeof j[n]!="function"){L.warning("mergeFunctionName property is defined on "+f+" but this is not function of "+j);}else if(t._bRendering||!j.bOutput){var p=f.getLastValue(),q=j[n](m);if(p===q){g=C.getConfiguration().getAccessibility();j.addStyleClass("sapMListTblCellDupCnt");r.class("sapMListTblCellDup");}else{f.setLastValue(q);}}else if(j.hasStyleClass("sapMListTblCellDupCnt")){r.class("sapMListTblCellDup");}}f.getVAlign()!="Inherit"&&r.style("vertical-align",f.getVAlign().toLowerCase());r.style("text-align",f.getCssAlign());if(f.isHidden()){r.style("display","none");r.attr("aria-hidden","true");}}r.openEnd();if(g){this.applyAriaLabelledBy(h,j);r.renderControl(j);}r.close("td");},this);};
b.renderDummyCell=function(r,t){r.openStart("td");r.class("sapMListTblDummyCell");r.attr("role","presentation");r.attr("aria-hidden","true");r.openEnd();r.close("td");};
b.applyAriaLabelledBy=function(h,o){if(h&&h.getText&&h.getVisible()&&o.getAriaLabelledBy&&(o.getAriaLabelledBy()||[]).indexOf(h.getId())==-1){o.addAriaLabelledBy(h);}};
b.renderPopin=function(r,o,t){o.removePopin();r.openStart("tr",o.getPopin());r.class("sapMListTblSubRow");r.attr("tabindex","-1");if(o.isSelectable()){r.attr("aria-selected",o.getSelected());}r.openEnd();this.renderHighlight(r,o);r.openStart("td",o.getId()+"-subcell");r.class("sapMListTblSubRowCell");r.attr("colspan",t.shouldRenderDummyColumn()?t.getColSpan()+1:t.getColSpan());var p=t.getPopinLayout();r.attr("aria-labelledby",this.getAriaAnnouncement(null,"TABLE_POPIN_ROLE_DESCRIPTION"));r.openEnd();r.openStart("div");r.class("sapMListTblSubCnt");r.class("sapMListTblSubCnt"+p);r.openEnd();var d=o.getCells(),e=t.getColumns(true);e.forEach(function(f){if(!f.getVisible()||!f.isPopin()){return;}var g=d[f.getInitialOrder()],h=f.getHeader();if(!h&&!g){return;}var s=f.getStyleClass().split(" "),i=f.getPopinDisplay();r.openStart("div");r.class("sapMListTblSubCntRow");if(i==P.Inline){r.class("sapMListTblSubCntRowInline");}s&&s.forEach(function(j){r.class(j);});r.openEnd();if(h&&i!=P.WithoutHeader){r.openStart("div").class("sapMListTblSubCntHdr").openEnd();h=h.clone();f.addDependent(h);o._addClonedHeader(h);r.renderControl(h);r.openStart("span").class("sapMListTblSubCntSpr");r.attr("data-popin-colon",C.getLibraryResourceBundle("sap.m").getText("TABLE_POPIN_LABEL_COLON"));r.openEnd().close("span");r.close("div");}if(g){r.openStart("div");r.class("sapMListTblSubCntVal");r.class("sapMListTblSubCntVal"+i);r.openEnd();this.applyAriaLabelledBy(h,g);r.renderControl(g);r.close("div");}r.close("div");},this);r.close("div");r.close("td");this.renderNavigated(r,o);r.close("tr");};
b.addLegacyOutlineClass=function(r,o){var t=o.isA("sap.m.Table")?o:o.getTable();if(t&&!t.hasPopin()&&t.shouldRenderDummyColumn()){r.class("sapMTableRowCustomFocus");}};
b.renderContentLatter=function(r,o){var t=o.getTable();if(t&&t.shouldRenderDummyColumn()){if(!t.hasPopin()){a.renderContentLatter.apply(this,arguments);b.renderDummyCell(r,t);}else{b.renderDummyCell(r,t);a.renderContentLatter.apply(this,arguments);}}else{a.renderContentLatter.apply(this,arguments);}};
return b;},true);
sap.ui.predefine('sap/m/ComboBox',['./ComboBoxTextField','./ComboBoxBase','./List','./library','sap/ui/Device','sap/ui/core/Item','./ComboBoxRenderer',"sap/ui/dom/containsOrEquals","sap/m/inputUtils/scrollToItem","sap/m/inputUtils/inputsDefaultFilter","sap/m/inputUtils/typeAhead","sap/m/inputUtils/filterItems","sap/m/inputUtils/ListHelpers","sap/m/inputUtils/itemsVisibilityHandler","sap/m/inputUtils/selectionRange","sap/m/inputUtils/calculateSelectionStart","sap/ui/events/KeyCodes","sap/ui/core/Core","sap/base/Log","sap/ui/dom/jquery/control"],function(C,a,L,l,D,I,b,c,s,i,t,f,d,g,h,j,K,k,m,q){"use strict";var n=l.ListMode;
var o=a.extend("sap.m.ComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ComboBox.designtime",properties:{selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},filterSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false}},events:{change:{parameters:{value:{type:"string"},itemPressed:{type:"boolean"}}},selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}},dnd:{draggable:false,droppable:true}}});
function S(e){var p=this.getSelectedItem(),r=d.getListItem(p),u=p&&r&&r.getDomRef(),v=u&&u.offsetTop,w=u&&u.offsetHeight,P=this.getPicker(),x=P.getDomRef("cont"),y=x.clientHeight;if(p&&((v+w)>(y))){if(!e){this._getList().$().css("visibility","hidden");}else{x.scrollTop=v-w/2;this._getList().$().css("visibility","visible");}}}
o.prototype._getSelectedItemText=function(v){v=v||this.getSelectedItem();if(!v){v=this.getDefaultSelectedItem();}if(v){return v.getText();}return"";};
o.prototype.setSelectedIndex=function(e,_){var p;_=_||this.getItems();e=(e>_.length-1)?_.length-1:Math.max(0,e);p=_[e];if(p){this.setSelection(p);}};
o.prototype.revertSelection=function(){var p,P=this.getPickerTextField();this.setSelectedItem(this._oSelectedItemBeforeOpen);this.setValue(this._sValueBeforeOpen);if(this.getSelectedItem()===null){p=this._sValueBeforeOpen;}else{p=this._oSelectedItemBeforeOpen.getText();}P&&P.setValue(p);};
o.prototype._filterStartsWithItems=function(e,M){var p=e.toLowerCase();var r=this.getItems(),F=r.filter(function(u){return u[M]&&u[M]().toLowerCase().startsWith(p);});return F;};
o.prototype.setSelection=function(v){var e=this._getList(),p,r;this.setAssociation("selectedItem",v);this._setPropertyProtected("selectedItemId",(v instanceof I)?v.getId():v,true);if(typeof v==="string"){v=k.byId(v);}if(e){p=d.getListItem(v);if(p){e.setSelectedItem(p,true);}else{e.removeSelections(true);}}r=v?v.getKey():"";this._setPropertyProtected("selectedKey",r);};
o.prototype.isSelectionSynchronized=function(){var v=this.getSelectedItem();return this.getSelectedKey()===(v&&v.getKey());};
o.prototype.isItemSelected=function(v){return v&&(v.getId()===this.getAssociation("selectedItem"));};
o.prototype.setAssociation=function(A,e,p){var r=this._getList();if(r&&(A==="selectedItem")){if(!(e instanceof I)){e=this.findItem("id",e);}r.setSelectedItem(d.getListItem(e),true);}return a.prototype.setAssociation.apply(this,arguments);};
o.prototype.removeAllAssociation=function(A,e){var p=this._getList();if(p&&(A==="selectedItem")){L.prototype.removeAllAssociation.apply(p,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};
o.prototype.init=function(){a.prototype.init.apply(this,arguments);this.bOpenValueStateMessage=true;this._sValueBeforeOpen="";this._sInputValueBeforeOpen="";this._oSelectedItemBeforeOpen=null;if(D.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}this.setLastFocusedListItem(null);};
o.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);var e=this.getItems();if(this.getRecreateItems()){d.fillList(e,this._getList(),this._mapItemToListItem.bind(this));this.setRecreateItems(false);}this.synchronizeSelection();if(!this.isOpen()&&document.activeElement===this.getFocusDomRef()&&this.getEnabled()){this.addStyleClass("sapMFocus");}if(this.getSelectedItem()&&e.indexOf(this.getSelectedItem())===-1){var v=this.getValue();this.clearSelection();this.setValue(v);}};
o.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._oSelectedItemBeforeOpen=null;this.setLastFocusedListItem(null);};
o.prototype.onBeforeRenderingPicker=function(){var O=this["onBeforeRendering"+this.getPickerType()];O&&O.call(this);};
o.prototype.onBeforeRenderingDropdown=function(){var p=this.getPicker(),w=(this.$().outerWidth()/parseFloat(l.BaseFontSize))+"rem";if(p){p.setContentMinWidth(w);}};
o.prototype.onBeforeRenderingList=function(){if(this.bProcessingLoadItemsEvent){var e=this._getList(),F=this.getFocusDomRef();if(e){e.setBusy(true);}if(F){F.setAttribute("aria-busy","true");}}};
o.prototype.onAfterRenderingPicker=function(){var O=this["onAfterRendering"+this.getPickerType()];O&&O.call(this);S.call(this,false);};
o.prototype.onAfterRenderingList=function(){var e=this.getSelectedItem(),p=d.getListItem(e);if(this.bProcessingLoadItemsEvent&&(this.getItems().length===0)){return;}var r=this._getList(),F=this.getFocusDomRef();this.highlightList(this._sInputValueBeforeOpen);if(e){r.setSelectedItem(p);this.setLastFocusedListItem(p);}if(r){r.setBusy(false);}if(F){F.removeAttribute("aria-busy");}};
o.prototype.filterItems=function(v){return f(this,this.getItems(),v,true,this.getFilterSecondaryValues(),this.fnFilter||i);};
o.prototype._mapItemToListItem=function(e){var p=d.createListItemFromCoreItem(e,this.getShowSecondaryValues());if(e.isA("sap.ui.core.Item")){this.setSelectable(e,e.getEnabled());}if(e.isA("sap.ui.core.SeparatorItem")){p.addAriaLabelledBy(this._getGroupHeaderInvisibleText().getId());}p.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"NonInteractiveItem");return p;};
o.prototype.oninput=function(e){a.prototype.oninput.apply(this,arguments);this.syncPickerContent();if(e.isMarked("invalid")){return;}this.loadItems(function(){this.handleInputValidation(e);},{name:"input",busyIndicator:false});if(this.bProcessingLoadItemsEvent&&(this.getPickerType()==="Dropdown")){this.open();}if(this.getLastFocusedListItem()){this.getLastFocusedListItem().removeStyleClass("sapMLIBFocused");this.setLastFocusedListItem(null);}this.addStyleClass("sapMFocus");this._getList().removeStyleClass("sapMListFocus");if(this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true);}};
o.prototype.handleInputValidation=function(e){var v,p,F,r,u=this.getSelectedItem(),V=e.target.value,E=V==="",w=e.srcControl,T=(this.getPickerType()==="Dropdown"),x=d.getListItem(u),y=this.filterItems(V);if(E&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){v=this.getItems();}else{v=y.items;g(this.getItems(),y);}F=v[0];r=v.some(function(z){return z.getKey()===this.getSelectedKey();},this);p=this.intersectItems(this._filterStartsWithItems(V,'getText'),v);if(F&&this.getSelectedKey()&&!r){this.setSelection(null);}if(!E&&w&&w._bDoTypeAhead){this.handleTypeAhead(w,v,V);}else if(!E&&p[0]&&V===p[0].getText()){this.setSelection(p[0]);}else{this.setSelection(null);}if(u!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});x=d.getListItem(this.getSelectedItem());}this._sInputValueBeforeOpen=V;if(this.isOpen()){setTimeout(function(){this.highlightList(V);}.bind(this));}if(F){if(E&&!this.bOpenedByKeyboardOrButton){this.close();}else if(T){this.open();s(x,this.getPicker());}}else if(this.isOpen()){if(T&&!this.bOpenedByKeyboardOrButton){this.close();}}else{this.clearFilter();}};
o.prototype.handleTypeAhead=function(e,p,v){var r,u=this.getFilterSecondaryValues(),M=t(v,e,p,function(w){r=[w.getText()];if(u){r.push(w.getAdditionalText());}return r;});this.setSelection(M[0]);this.addStyleClass("sapMFocus");this._getList().removeStyleClass("sapMListFocus");};
o.prototype.onSelectionChange=function(e){var p=d.getItemByListItem(this.getItems(),e.getParameter("listItem")),P=this.getChangeEventParams(),r=(p!==this.getSelectedItem());p&&this.updateDomValue(p.getText());this.setSelection(p);this.fireSelectionChange({selectedItem:this.getSelectedItem()});if(r){P.itemPressed=true;this.onChange(null,P);}};
o.prototype.onItemPress=function(e){var p=e.getParameter("listItem"),T=p.getTitle(),P=this.getChangeEventParams(),r=(p!==d.getListItem(this.getSelectedItem()));if(p.isA("sap.m.GroupHeaderListItem")){return;}this.setLastFocusedListItem(p);this.updateDomValue(T);if(!r){P.itemPressed=true;this.onChange(null,P);}this._setPropertyProtected("value",T,true);if(this.getPickerType()==="Dropdown"&&!this.isPlatformTablet()){this.selectText(this.getValue().length,this.getValue().length);}this.close();};
o.prototype.onBeforeOpen=function(){a.prototype.onBeforeOpen.apply(this,arguments);var p=this["onBeforeOpen"+this.getPickerType()],e=this.getFocusDomRef();this.setProperty("open",true);if(this.hasLoadItemsEventListeners()&&!this.bProcessingLoadItemsEvent){this.loadItems();}if(e){e.setAttribute("aria-controls",this.getPicker().getId());}this.addContent();p&&p.call(this);};
o.prototype.onBeforeOpenDialog=function(){var p=this.getPickerTextField();this._oSelectedItemBeforeOpen=this.getSelectedItem();this._sValueBeforeOpen=this.getValue();this.getSelectedItem()&&g(this.getItems(),this.filterItems(""));p.setValue(this._sValueBeforeOpen);};
o.prototype.onAfterOpen=function(){var e=this.getSelectedItem(),p=h(this.getFocusDomRef()),T=this.isPlatformTablet();this.closeValueStateMessage();S.call(this,true);if(!T&&e&&p.start===p.end&&p.start>1){setTimeout(function(){this.selectText(0,p.end);}.bind(this),0);}};
o.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);var e=this.getFocusDomRef();this.setProperty("open",false);if(e){e.removeAttribute("aria-controls");}if(document.activeElement===e){this.updateFocusOnClose();}this.toggleIconPressedStyle(false);};
o.prototype.onAfterClose=function(){this.clearFilter();this._sInputValueBeforeOpen="";if(this.isPickerDialog()){a.prototype.closeValueStateMessage.apply(this,arguments);}};
o.prototype.onItemChange=function(e){var p=this.getAssociation("selectedItem"),N=e.getParameter("newValue"),P=e.getParameter("name");if(p===e.getParameter("id")){switch(P){case"text":if(!this.isBound("value")){this.setValue(N);}break;case"key":if(!this.isBound("selectedKey")){this.setSelectedKey(N);}break;}}return a.prototype.onItemChange.call(this,e,this.getShowSecondaryValues());};
o.prototype.onkeydown=function(e){var p=e.srcControl;a.prototype.onkeydown.apply(p,arguments);if(!p.getEnabled()||!p.getEditable()){return;}var r=K;p._bDoTypeAhead=!D.os.android&&(e.which!==r.BACKSPACE)&&(e.which!==r.DELETE);};
o.prototype.oncut=function(e){var p=e.srcControl;a.prototype.oncut.apply(p,arguments);p._bDoTypeAhead=false;};
o.prototype.onsapenter=function(e){var p=e.srcControl,r=p.getSelectedItem();if(r&&this.getFilterSecondaryValues()){p.updateDomValue(r.getText());}a.prototype.onsapenter.apply(p,arguments);if(!p.getEnabled()||!p.getEditable()){return;}if(p.isOpen()&&!this.isComposingCharacter()){p.close();}};
["onsapup","onsapdown","onsappageup","onsappagedown","onsaphome","onsapend"].forEach(function(N){o.prototype[N]=function(e){this.handleListNavigation(e,N);};});
o.prototype.handleListNavigation=function(e,N){var p=e.srcControl;if(!p.getEnabled()||!p.getEditable()){return;}e.preventDefault();this.loadItems(function(){this.syncPickerContent();if(!this.isOpen()){this.handleInlineListNavigation(N);}else{var r=this._getSuggestionsPopover();r&&r.handleListNavigation(this,e,N);}e.setMarked();});};
o.prototype.handleInlineListNavigation=function(N){var e=this.getItems(),p=d.getSelectableItems(e),r=this.getSelectedItem(),u;switch(N){case"onsapdown":u=p.indexOf(r)+1;break;case"onsapup":u=r?p.indexOf(r)-1:p.length-1;break;case"onsapend":u=p.length-1;break;case"onsaphome":u=0;break;case"onsappagedown":u=Math.min(p.length-1,p.indexOf(r)+10);break;case"onsappageup":u=Math.max(0,p.indexOf(r)-10);break;}this.handleSelectionFromList(p[u]);};
o.prototype.handleSelectionFromList=function(e){if(!e){return;}var p=this.getFocusDomRef(),T=p.value.substring(0,p.selectionStart),r=this.getSelectedItem(),u=this.getLastFocusedListItem(),v,w,x,y;if(e.isA("sap.m.StandardListItem")||e.isA("sap.m.GroupHeaderListItem")){v=e;e=d.getItemByListItem(this.getItems(),e);}else{v=d.getListItem(e);}this.setSelection(e);this.setLastFocusedListItem(v);if(e.isA("sap.ui.core.SeparatorItem")){this.setSelectedItem(null);this.updateDomValue(T);this.fireSelectionChange({selectedItem:null});this._getGroupHeaderInvisibleText().setText(this._oRb.getText("LIST_ITEM_GROUP_HEADER")+" "+e.getText());return;}if(e!==r){w=e.getText();y=u&&u.isA("sap.m.GroupHeaderListItem");x=j(h(p,y),w,T,y);this.updateDomValue(w);this.fireSelectionChange({selectedItem:e});e=this.getSelectedItem();this.selectText(x,p.value.length);}};
o.prototype.setLastFocusedListItem=function(e){this._oLastFocusedListItem=e;};
o.prototype.getLastFocusedListItem=function(){return this._oLastFocusedListItem;};
o.prototype.onsapshow=function(e){var p,r,E=this.getEditable(),u;a.prototype.onsapshow.apply(this,arguments);this.syncPickerContent();if(!this.getValue()&&E){p=d.getSelectableItems(this.getItems());r=p[0];if(r){u=d.getListItem(r);if(this.isOpen()){this._getSuggestionsPopover().updateFocus(this,u);this.setLastFocusedListItem(u);}else{this.addStyleClass("sapMFocus");}this.setSelection(r);this.updateDomValue(r.getText());this.fireSelectionChange({selectedItem:r});setTimeout(function(){this.selectText(0,r.getText().length);}.bind(this),0);}}};
o.prototype.onsaphide=o.prototype.onsapshow;
o.prototype.ontap=function(e){if(!this.getEnabled()){return;}this.updateFocusOnClose();};
o.prototype.updateFocusOnClose=function(){var e=this.getFocusDomRef(),p=this._getSuggestionsPopover();this.setLastFocusedListItem(null);if(p){p.setValueStateActiveState(false);p.updateFocus(this);}e.removeAttribute("aria-activedescendant");};
o.prototype.onmouseup=function(){if(this.getPickerType()==="Dropdown"&&document.activeElement===this.getFocusDomRef()&&!this.getSelectedText()){this.selectText(0,this.getValue().length);}};
o.prototype.onfocusin=function(e){var p=this.getPickerType()==="Dropdown";if(this._bIsBeingDestroyed){return;}if(e.target===this.getOpenArea()){this.bOpenValueStateMessage=false;if(p&&!this.isPlatformTablet()){this.focus();}}else{if(!this.isOpen()&&this.bOpenValueStateMessage&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}this.bOpenValueStateMessage=true;}if(this.getEnabled()&&(!this.isOpen()||!this.getSelectedItem()||!this._getList().hasStyleClass("sapMListFocus"))){this.addStyleClass("sapMFocus");}};
o.prototype.onsapfocusleave=function(e){var T,p,r,F,u=this.getSelectedItem();if(u&&this.getFilterSecondaryValues()){this.updateDomValue(u.getText());}a.prototype.onsapfocusleave.apply(this,arguments);if(this.isPickerDialog()){return;}p=this.getPicker();if(!e.relatedControlId||!p){return;}T=this.isPlatformTablet();r=k.byId(e.relatedControlId);F=r&&r.getFocusDomRef();if(c(p.getFocusDomRef(),F)&&!T&&!(this._getSuggestionsPopover().getValueStateActiveState())){this.focus();}};
o.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return;}var e=this.getSelectedKey(),v=this.getItemByKey(""+e);if(v&&(e!=="")){this.setAssociation("selectedItem",v,true);this._setPropertyProtected("selectedItemId",v.getId(),true);this.setValue(v.getText());this._sValue=this.getValue();}};
o.prototype.configPicker=function(p){var r=this.getRenderer(),e=r.CSS_CLASS_COMBOBOXBASE;p.setHorizontalScrolling(false).addStyleClass(e+"Picker").addStyleClass(e+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this);};
o.prototype._configureList=function(e){var r=this.getRenderer();if(!e){return;}e.setMode(n.SingleSelectMaster).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_COMBOBOX+"List");e.attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this);e.addEventDelegate({onBeforeRendering:this.onBeforeRenderingList,onAfterRendering:this.onAfterRenderingList},this);};
o.prototype.getDefaultSelectedItem=function(){return null;};
o.prototype.getChangeEventParams=function(){return{itemPressed:false};};
o.prototype.clearSelection=function(){this.setAssociation("selectedItem",null);this.setSelectedItemId("");this.setSelectedKey("");};
o.prototype.selectText=function(e,p){a.prototype.selectText.apply(this,arguments);return this;};
o.prototype.clone=function(e){var p=a.prototype.clone.apply(this,arguments),r=this._getList();p.setAssociation("selectedItem",null);if(!this.isBound("items")&&r){p.syncPickerContent();p.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));}return p;};
o.prototype.open=function(){this.syncPickerContent();a.prototype.open.call(this);this._getSuggestionsPopover()&&this._getSuggestionsPopover().updateFocus(this,d.getListItem(this.getSelectedItem()));return this;};
o.prototype.syncPickerContent=function(){var p,P=this.getPicker(),e=this.getInputForwardableProperties();if(!P){var r,G;P=this.createPicker(this.getPickerType());p=this.getPickerTextField();d.fillList(this.getItems(),this._getList(),this._mapItemToListItem.bind(this));g(this.getItems(),this.filterItems(""));if(p){e.forEach(function(u){u=u.charAt(0).toUpperCase()+u.slice(1);r="set"+u;G="get"+u;if(p[r]){p[r](this[G]());}},this);}this._getSuggestionsPopover().updateValueState(this.getValueState(),this.getValueStateText(),this.getShowValueStateMessage());}this.synchronizeSelection();return P;};
o.prototype.findAggregatedObjects=function(){var e=this._getList();if(e){return L.prototype.findAggregatedObjects.apply(e,arguments);}return[];};
o.prototype.setSelectedItem=function(v){if(typeof v==="string"){this.setAssociation("selectedItem",v,true);v=k.byId(v);}if(!(v instanceof I)&&v!==null){return this;}if(!v){v=this.getDefaultSelectedItem();}this.setSelection(v);this.setValue(this._getSelectedItemText(v));return this;};
o.prototype.setSelectedItemId=function(v){v=this.validateProperty("selectedItemId",v);if(!v){v=this.getDefaultSelectedItem();}this.setSelection(v);v=this.getSelectedItem();this.setValue(this._getSelectedItemText(v));return this;};
o.prototype.setSelectedKey=function(e){e=this.validateProperty("selectedKey",e);var p=(e===""),r=this.isBound("selectedKey")&&this.isBound("value")&&this.getBindingInfo("selectedKey").skipModelUpdate;if(p){this.setSelection(null);if(!r){this.setValue("");}return this;}var u=this.getItemByKey(e);if(u){this.setSelection(u);if(!r){this.setValue(this._getSelectedItemText(u));}return this;}this._sValue=this.getValue();return this._setPropertyProtected("selectedKey",e);};
o.prototype._setPropertyProtected=function(p,v,r){try{return this.setProperty(p,v,r);}catch(e){m.warning("setSelectedKey update failed due to exception. Loggable in support mode log",null,null,function(){return{exception:e};});}};
o.prototype.getSelectedItem=function(){var v=this.getAssociation("selectedItem");return(v===null)?null:k.byId(v)||null;};
o.prototype._decoratePopupInput=function(e){a.prototype._decoratePopupInput.apply(this,arguments);if(!e||!e.isA(["sap.m.InputBase"])){return;}e.addEventDelegate({onsapenter:function(){var T=e.getValue();this.updateDomValue(T);this.onChange();if(T){this.updateDomValue(T);this.onChange();this.close();}}},this);e.attachChange(this._handleInnerInputChange.bind(this));return e;};
o.prototype._handleInnerInputChange=function(e){if(e.getParameter("value")===""){this.clearSelection();this.clearFilter();}};
o.prototype.applyShowItemsFilters=function(){var p,P;this.syncPickerContent();p=this.getPicker();P=function(){p.detachBeforeOpen(P,this);p=null;g(this.getItems(),this.filterItems(this.getValue()||"_"));};p.attachBeforeOpen(P,this);};
o.prototype.showItems=function(F){var e,p,r=Array.prototype.slice.call(arguments),u=this.fnFilter,v=function(){this.setFilterFunction(F||function(){return true;});p=this.filterItems(this.getValue()||"_");g(this.getItems(),p);this.setFilterFunction(u);e=p.items;if(e&&e.length){a.prototype.showItems.apply(this,r);}}.bind(this);this.attachLoadItems(v);this.loadItems(v);};
o.prototype._getFormattedValueStateText=function(){if(this.isOpen()){return this._getSuggestionsPopover()._getValueStateHeader().getFormattedText();}else{return C.prototype.getFormattedValueStateText.call(this);}};
o.prototype.handleClearIconPress=function(e){if(!(this.getEnabled()&&this.getEditable())){return;}if(this.getValue()!==""){this.clearSelection();this.setProperty("effectiveShowClearIcon",false);}};
return o;});
sap.ui.predefine('sap/m/ComboBoxBase',['./ComboBoxTextField','./ComboBoxBaseRenderer','./SuggestionsPopover','sap/ui/base/ManagedObjectObserver','sap/ui/core/SeparatorItem','sap/ui/core/InvisibleText','sap/ui/base/ManagedObject','sap/base/Log','./library','sap/ui/Device',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/security/encodeXML","sap/base/strings/escapeRegExp","sap/m/inputUtils/forwardItemProperties","sap/m/inputUtils/highlightDOMElements","sap/m/inputUtils/ListHelpers","sap/ui/core/IconPool","sap/ui/core/Core"],function(C,a,S,M,b,I,c,L,l,D,d,K,q,e,f,g,h,j,k,m){"use strict";var P=l.PlacementType;var n=["value","enabled","name","placeholder","editable","textAlign","textDirection","valueState","valueStateText"];
var o=C.extend("sap.m.ComboBoxBase",{
metadata:{library:"sap.m","abstract":true,defaultAggregation:"items",properties:{showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},open:{type:"boolean",defaultValue:false,hidden:true},showClearIcon:{type:"boolean",defaultValue:false},effectiveShowClearIcon:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}},dnd:{draggable:false,droppable:true}},
renderer:a
});
o.prototype.oncompositionend=function(E){C.prototype.oncompositionend.apply(this,arguments);if(!D.browser.firefox){this.handleInputValidation(E,this.isComposingCharacter());}};
o.prototype.shouldShowClearIcon=function(){return this.getProperty("effectiveShowClearIcon")&&!!this.getValue()&&this.getEditable()&&this.getEnabled();};
o.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){if(this.isOpen()){j.fillList(this.getItems(),this._getList(),this._mapItemToListItem.bind(this));this.setRecreateItems(false);}this.onItemsLoaded();}};
o.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this.fnFilter=null;return this;}if(typeof(F)!=="function"){L.warning("Passed filter is not a function and the default implementation will be used");}else{this.fnFilter=F;}return this;};
o.prototype.highlightList=function(v){var i=[];i=this._getList().$().find('.sapMSLIInfo, .sapMSLITitleOnly');h(i,v);};
o.prototype._decoratePopupInput=function(i){if(i){this.setTextFieldHandler(i);i.setShowClearIcon(this.getShowClearIcon());}return i;};
o.prototype.setTextFieldHandler=function(t){var i=this,T=t._handleEvent;t._handleEvent=function(E){T.apply(this,arguments);if(/keydown|keyup|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(E.type)){i._handleEvent(E);}};};
o.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};
o.prototype.loadItems=function(i,O){var p=typeof i==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(p){O=q.extend({action:i,busyIndicator:true,busyIndicatorDelay:300},O);this.aMessageQueue.push(O);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(O.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function r(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),O.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(p){i.call(this);}};
o.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,p,N,r;i<this.aMessageQueue.length;i++){p=this.aMessageQueue.shift();i--;r=(i+1)===this.aMessageQueue.length;N=r?null:this.aMessageQueue[i+1];if(typeof p.action==="function"){if((p.name==="input")&&!r&&(N.name==="input")){continue;}p.action.call(this);}}};
o.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};
o.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};
o.prototype.getPickerInvisibleTextId=function(){return I.getStaticId("sap.m","COMBOBOX_AVAILABLE_OPTIONS");};
o.prototype._getGroupHeaderInvisibleText=function(){if(!this._oGroupHeaderInvisibleText){this._oGroupHeaderInvisibleText=new I();this._oGroupHeaderInvisibleText.toStatic();}return this._oGroupHeaderInvisibleText;};
o.prototype._isListInSuggestMode=function(){return this._getList().getItems().some(function(i){return!i.getVisible()&&j.getItemByListItem(this.getItems(),i).getEnabled();},this);};
o.prototype.getSelectable=function(i){return i._bSelectable;};
o.prototype._setItemsShownWithFilter=function(v){this._bItemsShownWithFilter=v;};
o.prototype._getItemsShownWithFilter=function(){return this._bItemsShownWithFilter;};
o.prototype._getClearIcon=function(){if(this._oClearIcon){return this._oClearIcon;}this._oClearIcon=this.addEndIcon({src:k.getIconURI("decline"),noTabStop:true,visible:false,alt:this._oRb.getText("INPUT_CLEAR_ICON_ALT"),useIconTooltip:false,decorative:false,press:this.handleClearIconPress.bind(this)},0);this._oClearIcon.addStyleClass("sapMComboBoxBaseClearIcon");return this._oClearIcon;};
o.prototype.handleClearIconPress=function(E){};
o.prototype.onkeyup=function(E){if(!this.getEnabled()||!this.getEditable()){return;}this.getShowClearIcon()&&this.setProperty("effectiveShowClearIcon",!!this.getValue());};
o.prototype.setValue=function(v){C.prototype.setValue.apply(this,arguments);this.setProperty("effectiveShowClearIcon",!!v);return this;};
o.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oRb=m.getLibraryResourceBundle("sap.m");this.setPickerType(D.system.phone?"Dialog":"Dropdown");this._setItemsShownWithFilter(false);this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._bShouldClosePicker=false;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;this.getArrowIcon().addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=this.isOpen();}},this);this.getArrowIcon().attachPress(this._handlePopupOpenAndItemsLoad.bind(this,true,this));this.fnFilter=null;var i=new M(function(p){var s=p.mutation;var r=p.child;var E={"remove":"detachEvent","insert":"attachEvent"};var t={"remove":"handleItemRemoval","insert":"handleItemInsertion"};if(!r[E[s]]||!this[t[s]]){return;}r[E[s]]("_change",this.onItemChange,this);this.setRecreateItems(true);this[t[s]](r);}.bind(this));i.observe(this,{aggregations:["items"]});};
o.prototype.handleItemRemoval=function(i){};
o.prototype.handleItemInsertion=function(i){};
o.prototype.setRecreateItems=function(r){this._bRecreateItems=r;};
o.prototype.getRecreateItems=function(){return this._bRecreateItems;};
o.prototype.onBeforeRendering=function(){var s=this.isOpen(),v=s?this._getSuggestionsPopover()._getValueStateHeader().getText():null,V=s?this._getSuggestionsPopover()._getValueStateHeader().getValueState():null;C.prototype.onBeforeRendering.apply(this,arguments);if(s&&((this.getValueStateText()&&v!==this.getValueStateText())||(this.getValueState()!==V)||this.getFormattedValueStateText())){this._updateSuggestionsPopoverValueState();}if(this.getShowClearIcon()){this._getClearIcon().setVisible(this.shouldShowClearIcon());}else if(this._oClearIcon){this._getClearIcon().setVisible(false);}};
o.prototype._handlePopupOpenAndItemsLoad=function(O,i){var p;if(!this.getEnabled()||!this.getEditable()){return;}if(O&&this._getItemsShownWithFilter()){this._bShouldClosePicker=false;this.toggleIconPressedStyle(true);this.bOpenedByKeyboardOrButton=false;this.clearFilter();this._setItemsShownWithFilter(false);return;}if(this._bShouldClosePicker){this._bShouldClosePicker=false;this.close();return;}this.loadItems();this.bOpenedByKeyboardOrButton=O;if(this.isPlatformTablet()){this.syncPickerContent();p=this.getPicker();p.setInitialFocus(p);}if(i){p=this.getPicker();p&&p.setInitialFocus(i);}this.open();};
o.prototype.exit=function(){C.prototype.exit.apply(this,arguments);this._oRb=null;if(this._getGroupHeaderInvisibleText()){this._getGroupHeaderInvisibleText().destroy();this._oGroupHeaderInvisibleText=null;}if(this._oSuggestionPopover){this._oSuggestionPopover.destroy();this._oSuggestionPopover=null;}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;this.fnFilter=null;};
o.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(E.keyCode===K.F4){this.onF4(E);}if(this._getItemsShownWithFilter()){this.loadItems(this._handlePopupOpenAndItemsLoad.bind(this,true));return;}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};
o.prototype.onF4=function(E){E.preventDefault();};
o.prototype.onsapescape=function(E){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){E.setMarked();E.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};
o.prototype.onsaphide=o.prototype.onsapshow;
o.prototype.onsapfocusleave=function(E){if(!E.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(E.relatedControlId);if(r===this){return;}var p=this.getPicker(),F=r&&r.getFocusDomRef();if(p&&d(p.getFocusDomRef(),F)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};
o.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};
o.prototype.addContent=function(p){};
o.prototype.getList=function(){L.warning("[Warning]:","You are attempting to use deprecated method 'getList()', please refer to SAP note 2746748.",this);return this._getList();};
o.prototype._getList=function(){var i=this._oSuggestionPopover&&this._oSuggestionPopover.getItemsContainer();if(this.bIsDestroyed||!i){return null;}return i;};
o.prototype.setPickerType=function(p){this._sPickerType=p;};
o.prototype.getPickerType=function(){return this._sPickerType;};
o.prototype._updateSuggestionsPopoverValueState=function(){var s=this._getSuggestionsPopover();if(!s){return;}var v=this.getValueState(),N=this.getValueState()!==s._getValueStateHeader().getValueState(),i=this.getFormattedValueStateText(),V=this.getValueStateText(),p=i||N;if(s.isOpen()&&!p){this.setFormattedValueStateText(s._getValueStateHeader().getFormattedText());}s.updateValueState(v,(i||V),this.getShowValueStateMessage());};
o.prototype.shouldValueStateMessageBeOpened=function(){var s=C.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return(s&&!this.isOpen());};
o.prototype.onPropertyChange=function(i,p){var N=i.getParameter("newValue"),s=i.getParameter("name"),r="set"+s.charAt(0).toUpperCase()+s.slice(1),t=(p&&p.srcControl)||this.getPickerTextField();if(this.getInputForwardableProperties().indexOf(s)>-1&&t&&(typeof t[r]==="function")){t[r](N);}};
o.prototype.getInputForwardableProperties=function(){return n;};
o.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog";};
o.prototype.isPlatformTablet=function(){var N=!D.system.combi,t=D.system.tablet&&N;return t;};
o.prototype.getDropdownSettings=function(){return{showArrow:false,placement:P.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined};};
o.prototype._configureList=function(){};
o.prototype.createPicker=function(p){var i=this.getAggregation("picker");if(i){return i;}this._oSuggestionPopover=this._createSuggestionsPopover();i=this._oSuggestionPopover.getPopover();this.setAggregation("picker",i,true);this.configPicker(i);return i;};
o.prototype.configPicker=function(p){};
o.prototype._hasShowSelectedButton=function(){return false;};
o.prototype._createSuggestionsPopover=function(){var s=new S(this);s.decorateParent(this);s.createSuggestionPopup(this,{showSelectedButton:this._hasShowSelectedButton()});this._decoratePopupInput(s.getInput());s.initContent(this.getId());this.forwardEventHandlersToSuggPopover(s);this._configureList(s.getItemsContainer());return s;};
o.prototype.forwardEventHandlersToSuggPopover=function(s){s.setOkPressHandler(this._handleOkPress.bind(this));s.setCancelPressHandler(this._handleCancelPress.bind(this));s.setInputLabels(this.getLabels.bind(this));};
o.prototype._handleOkPress=function(){var t=this,T=t.getPickerTextField();t.updateDomValue(T.getValue());t.onChange();t.close();};
o.prototype._handleCancelPress=function(){this.close();this.revertSelection();};
o.prototype.setSelectable=function(i,s){if(this.indexOfItem(i)<0){return;}i._bSelectable=s;var p=j.getListItem(i);if(p){p.setVisible(s);}};
o.prototype.onBeforeOpen=function(){this._updateSuggestionsPopoverValueState();if(!this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true);}};
o.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;this._setItemsShownWithFilter(false);this._updateSuggestionsPopoverValueState();};
o.prototype.getPicker=function(){var p=this.getAggregation("picker");if(p&&!p.bIsDestroyed&&!this.bIsDestroyed){return p;}return null;};
o.prototype._getSuggestionsPopover=function(){return this._oSuggestionPopover;};
o.prototype.getValueStateLinks=function(){var H=this.getPicker()&&this.getPicker().getCustomHeader()&&typeof this.getPicker().getCustomHeader().getFormattedText==="function",F=H&&this.getPicker().getCustomHeader().getFormattedText(),v=F&&F.getControls();return v||[];};
o.prototype.getPickerTextField=function(){var s=this._getSuggestionsPopover();return s?s.getInput():null;};
o.prototype.getPickerTitle=function(){var p=this.getPicker(),H=p&&p.getCustomHeader();if(this.isPickerDialog()&&H){return H.getContentMiddle()[0];}return null;};
o.prototype.revertSelection=function(){};
o.prototype.hasContent=function(){return this.getItems().length>0;};
o.prototype.syncPickerContent=function(){};
o.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};
o.prototype.getVisibleItems=function(){return j.getVisibleItems(this.getItems());};
o.prototype.isItemSelected=function(){};
o.prototype.getKeys=function(p){p=p||this.getItems();for(var i=0,r=[];i<p.length;i++){r[i]=p[i].getKey();}return r;};
o.prototype.findItem=function(p,v){var s="get"+p.charAt(0).toUpperCase()+p.slice(1);for(var i=0,r=this.getItems();i<r.length;i++){if(r[i][s]()===v){return r[i];}}return null;};
o.prototype.getItemByText=function(t){return this.findItem("text",t);};
o.prototype.clearFilter=function(){this.getItems().forEach(function(i){var p=j.getListItem(i);if(p){p.setVisible(i.getEnabled()&&this.getSelectable(i));}},this);};
o.prototype.onItemChange=function(i,s){g({item:i.getSource(),propName:i.getParameter("name"),propValue:i.getParameter("newValue")},s);};
o.prototype.clearSelection=function(){};
o.prototype.setInternalBusyIndicator=function(B){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};
o.prototype.setInternalBusyIndicatorDelay=function(i){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};
o.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};
o.prototype.getFirstItem=function(){return this.getItems()[0]||null;};
o.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};
o.prototype.getEnabledItems=function(i){return j.getEnabledItems(i||this.getItems());};
o.prototype.getItemByKey=function(s){return this.findItem("key",s);};
o.prototype.addItemGroup=function(G,H,s){H=H||new b({text:c.escapeSettingsValue(G.text)||c.escapeSettingsValue(G.key)});this.addAggregation("items",H,s);if(this._getList()&&H.isA("sap.ui.core.SeparatorItem")){this._getList().addItem(this._mapItemToListItem(H));}return H;};
o.prototype.isOpen=function(){var p=this.getPicker();return!!(p&&p.isOpen());};
o.prototype.close=function(){var p=this.getPicker();if(p){p.close();}return this;};
o.prototype.intersectItems=function(i,O){return i.filter(function(p){return O.map(function(r){return r.getId();}).indexOf(p.getId())!==-1;});};
o.prototype.showItems=function(F){var i=this.fnFilter,p=function(){if(!this.getItems().length){return;}this.detachLoadItems(p);this.setFilterFunction(F||function(){return true;});this.applyShowItemsFilters();this._handlePopupOpenAndItemsLoad(false,this);this.setFilterFunction(i);}.bind(this);if(!this.getEnabled()||!this.getEditable()){return;}this._setItemsShownWithFilter(true);this.attachLoadItems(p);this.loadItems(p);};
o.prototype.applyShowItemsFilters=function(){};
return o;});
sap.ui.predefine('sap/m/ComboBoxBaseRenderer',['./ComboBoxTextFieldRenderer','sap/ui/core/Renderer','sap/ui/core/Core'],function(C,R,a){"use strict";var b=R.extend(C);b.apiVersion=2;b.CSS_CLASS_COMBOBOXBASE="sapMComboBoxBase";
b.getAccessibilityState=function(c){var A=C.getAccessibilityState.call(this,c),l=c._getList();if(l){A.controls=l.getId();}return A;};
b.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);var d=b.CSS_CLASS_COMBOBOXBASE;r.class(d);if(!c.getEnabled()){r.class(d+"Disabled");}if(!c.getEditable()){r.class(d+"Readonly");}};
b.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.class(b.CSS_CLASS_COMBOBOXBASE+"Arrow");};
return b;},true);
sap.ui.predefine('sap/m/ComboBoxRenderer',['./ComboBoxBaseRenderer','sap/ui/core/Renderer','sap/m/inputUtils/ListHelpers'],function(C,R,L){"use strict";var a=R.extend(C);a.apiVersion=2;a.CSS_CLASS_COMBOBOX="sapMComboBox";
a.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);r.class(a.CSS_CLASS_COMBOBOX);};
a.addInnerClasses=function(r,c){C.addInnerClasses.apply(this,arguments);r.class(a.CSS_CLASS_COMBOBOX+"Inner");};
a.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.class(a.CSS_CLASS_COMBOBOX+"Arrow");};
a.addPlaceholderClasses=function(r,c){C.addPlaceholderClasses.apply(this,arguments);r.class(a.CSS_CLASS_COMBOBOX+"Placeholder");};
a.writeInnerAttributes=function(r,c){var o=c.isOpen(),i,s,l;var S=c._getSuggestionsPopover();C.writeInnerAttributes.apply(this,arguments);r.attr("aria-expanded",o);if(!S){return;}var f=S.getFocusedListItem();var v=S.getValueStateActiveState();if(!o||(!f&&!v)){return;}if(v){r.attr("aria-activedescendant",c._getFormattedValueStateText().getId());return;}i=(f.isA("sap.m.GroupHeaderListItem")||f.isA("sap.ui.core.SeparatorItem"));s=c.getSelectedItem();l=s&&L.getListItem(s);f=i?f:l;if(f){r.attr("aria-activedescendant",f.getId());}};
return a;},true);
sap.ui.predefine('sap/m/ComboBoxTextField',['./InputBase','./library','sap/ui/core/InvisibleText','sap/ui/core/library','sap/ui/Device','sap/ui/core/LabelEnablement',"./ComboBoxTextFieldRenderer"],function(I,l,a,c,D,L,C){"use strict";
var b=I.extend("sap.m.ComboBoxTextField",{metadata:{library:"sap.m",properties:{maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},showButton:{type:"boolean",group:"Appearance",defaultValue:true}}}});
var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
b.prototype.init=function(){I.prototype.init.apply(this,arguments);this._oArrowIcon=this.addEndIcon({id:this.getId()+"-arrow",src:"sap-icon://slim-arrow-down",noTabStop:true,alt:r.getText("COMBOBOX_BUTTON"),decorative:false});};
b.prototype.getArrowIcon=function(){return this._oArrowIcon;};
b.prototype.getIcon=b.prototype.getArrowIcon;
b.prototype.toggleIconPressedStyle=function(s){this.toggleStyleClass(I.ICON_PRESSED_CSS_CLASS,s);};
b.prototype.onBeforeRendering=function(){I.prototype.onBeforeRendering.apply(this,arguments);var R=L.getReferencingLabels(this)||[],i=this.getArrowIcon();i.setVisible(this.getShowButton());R.forEach(function(s){if(i.getAriaLabelledBy().indexOf(s)===-1){i.addAssociation("ariaLabelledBy",s,true);}},this);};
b.prototype.getOpenArea=function(){var d=this.getArrowIcon().getDomRef();return d?d.parentNode:d;};
b.prototype.onsapenter=function(e){I.prototype.onsapenter.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}this._bCheckDomValue&&e.setMarked();var v=this.getValue(),V=v.length;this.setValue(v);this.selectText(V,V);};
b.prototype.getValue=function(){var d=this.getFocusDomRef();if(d){return d.value;}return this.getProperty("value");};
b.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef();};
b.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=r.getText("ACC_CTR_TYPE_COMBO");return i;};
b.prototype.exit=function(){I.prototype.exit.apply(this,arguments);this._oArrowIcon=null;};
return b;});
sap.ui.predefine('sap/m/ComboBoxTextFieldRenderer',['./InputBaseRenderer','sap/ui/core/Renderer','sap/ui/core/LabelEnablement','sap/ui/Device'],function(I,R,L,D){"use strict";var C=R.extend(I);C.apiVersion=2;C.CSS_CLASS_COMBOBOXTEXTFIELD="sapMComboBoxTextField";
C.writeInnerAttributes=function(r,c){r.attr("role","combobox");r.attr("aria-haspopup","listbox");r.attr("aria-autocomplete","both");r.attr("aria-expanded","false");r.attr("autocomplete","off");r.attr("autocorrect","off");r.attr("autocapitalize","off");r.attr("type","text");};
C.getAriaRole=function(){};
C.addOuterStyles=function(r,c){r.style("max-width",c.getMaxWidth());};
return C;},true);
sap.ui.predefine('sap/m/CustomDynamicDateOption',['sap/m/DynamicDateOption'],function(D){"use strict";
var C=D.extend("sap.m.CustomDynamicDateOption",{metadata:{library:"sap.m",properties:{getText:{type:"function"},getValueHelpUITypes:{type:"function"},createValueHelpUI:{type:"function"},validateValueHelpUI:{type:"function"},getValueHelpOutput:{type:"function"},getGroup:{type:"function"},getGroupHeader:{type:"function"},format:{type:"function"},parse:{type:"function"},toDates:{type:"function"},enhanceFormattedValue:{type:"function"}}}});
function c(s){return s.charAt(0).toUpperCase()+s.slice(1);}
["getText","getValueHelpUITypes","createValueHelpUI","getValueHelpOutput","validateValueHelpUI","getGroup","getGroupHeader","format","parse","toDates","enhanceFormattedValue"].forEach(function(f){C.prototype[f]=function(){var g="get"+c(f);var a=this[g]();return a?a.apply(this,arguments):D.prototype[f].apply(this,arguments);};});
C.prototype.getGroupHeader=function(){if((this.getGroup()<7&&this.getGroup()>-1)||!this.getGetGroupHeader()){return D.prototype.getGroupHeader.apply(this,arguments);}else{return this.getGetGroupHeader().apply(this,arguments);}};
return C;});
sap.ui.predefine('sap/m/CustomListItem',['./ListItemBase','./library','./CustomListItemRenderer'],function(L,l,C){"use strict";
var a=L.extend("sap.m.CustomListItem",{metadata:{library:"sap.m",defaultAggregation:"content",properties:{accDescription:{tpye:"string",group:"Behavior"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}},designtime:"sap/m/designtime/CustomListItem.designtime"}});
a.prototype.setAccDescription=function(A){this.setProperty("accDescription",A,true);return this;};
a.prototype.getContentAnnouncement=function(){var A=this.getAccDescription();if(A){return A;}return this.getContent().map(function(c){return L.getAccessibilityText(c);}).join(" ").trim();};
return a;});
sap.ui.predefine('sap/m/CustomListItemRenderer',["./ListItemBaseRenderer","sap/ui/core/Renderer"],function(L,R){"use strict";var C=R.extend(L);C.apiVersion=2;
C.renderLIAttributes=function(r,l){r.class("sapMCLI");};
C.renderLIContent=function(r,l){l.getContent().forEach(r.renderControl,r);};
return C;},true);
sap.ui.predefine('sap/m/CustomTile',['./Tile','./library','./CustomTileRenderer'],function(T,l,C){"use strict";
var a=T.extend("sap.m.CustomTile",{metadata:{library:"sap.m",deprecated:true,designtime:"sap/m/designtime/CustomTile.designtime",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false}}}});
return a;});
sap.ui.predefine('sap/m/CustomTileRenderer',['./TileRenderer','sap/ui/core/Renderer'],function(T,R){"use strict";var C=R.extend(T);C.apiVersion=2;
C.render=function(r,c){var t,v;r.openStart("div",c).attr("tabindex","0");r.class("sapMCustomTile");if(c._invisible){r.style("visibility","hidden");}if(c.getParent()instanceof sap.m.TileContainer){t=c.getParent();v=t._getVisibleTiles();r.accessibilityState(c,{role:"option",posinset:t._indexOfVisibleTile(c,v)+1,setsize:v.length});}r.openEnd();r.openStart("div",c.getId()+"-remove").class("sapMTCRemove").openEnd().close("div");r.openStart("div").class("sapMCustomTileContent").openEnd();this._renderContent(r,c);r.close("div").close("div");};
C._renderContent=function(r,t){r.renderControl(t.getContent());};
return C;},true);
sap.ui.predefine('sap/m/DatePicker',['sap/ui/thirdparty/jquery','sap/ui/Device',"sap/ui/core/Element",'./InputBase','./DateTimeField','./Button','./ResponsivePopover',"./ValueStateHeader",'sap/ui/core/date/UniversalDate','./library','sap/ui/core/Control','sap/ui/core/library',"./DatePickerRenderer","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/IconPool","./InstanceManager","sap/ui/unified/Calendar","sap/ui/unified/DateRange",'sap/ui/unified/DateTypeRange',"sap/ui/unified/calendar/CustomMonthPicker","sap/ui/unified/calendar/CustomYearPicker","sap/ui/core/LabelEnablement","sap/ui/unified/library","sap/ui/dom/jquery/cursorPos"],function(q,D,E,I,a,B,R,V,U,l,C,c,b,d,e,L,f,g,h,j,k,m,n,o,u){"use strict";var p=c.CalendarType;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
var s=a.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showFooter:{type:"boolean",group:"Misc",defaultValue:false},showCurrentDateButton:{type:"boolean",group:"Behavior",defaultValue:false},hideInput:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{specialDates:{type:"sap.ui.core.Element",multiple:true,singularName:"specialDate"},_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},associations:{legend:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{parameters:{dateRange:{type:"sap.ui.unified.DateRange"},afterPopupOpened:{type:"boolean"}}}},designtime:"sap/m/designtime/DatePicker.designtime",dnd:{draggable:false,droppable:true}}});
s.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bValid=true;this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,999);var i=this.addEndIcon({id:this.getId()+"-icon",src:this.getIconSrc(),noTabStop:true,tooltip:r.getText("OPEN_PICKER_TEXT")});this._bShouldClosePicker=false;i.addEventDelegate({onmousedown:function(A){this._bShouldClosePicker=!!this.isOpen();}},this);i.attachPress(function(){this.toggleOpen(this._bShouldClosePicker);},this);};
s.prototype.isValidValue=function(){return this._bValid;};
s.prototype.isOpen=function(){return this._oPopup&&this._oPopup.isOpen();};
s.prototype.toggleOpen=function(O){if(this.getEditable()&&this.getEnabled()){if(O){t.call(this);}else{_.call(this);}}};
s.prototype.getIconSrc=function(){return f.getIconURI("appointment-2");};
s.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._getCalendar()){if(this._oCalendarAfterRenderDelegate){this._getCalendar().removeDelegate(this._oCalendarAfterRenderDelegate);}this._getCalendar().destroy();delete this._getCalendar();}if(this._iInvalidateCalendar){clearTimeout(this._iInvalidateCalendar);}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined;};
s.prototype.invalidate=function(O){if(!O||O!=this._getCalendar()){C.prototype.invalidate.apply(this,arguments);this._iInvalidateCalendar=setTimeout(z.bind(this),0);}};
s.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();var i=this._getValueHelpIcon();if(i){i.setProperty("visible",this.getEditable(),true);}};
s.prototype.setDisplayFormat=function(i){this.setProperty("displayFormat",i);if(this._oCalendar){this._oCalendar.removeDelegate(this._oCalendarAfterRenderDelegate);this._oCalendar.destroy();this._oCalendar=null;this._createPopupContent();}return this;};
s.prototype.setWidth=function(W){return I.prototype.setWidth.call(this,W||"100%");};
s.prototype.getWidth=function(W){return this.getProperty("width")||"100%";};
s.prototype.applyFocusInfo=function(F){this._bFocusNoPopup=true;if(!D.support.touch||D.system.desktop){I.prototype.applyFocusInfo.apply(this,arguments);}};
s.prototype.onfocusin=function(i){if(!q(i.target).hasClass("sapUiIcon")){a.prototype.onfocusin.apply(this,arguments);}this._bFocusNoPopup=undefined;};
s.prototype.onsapshow=function(i){this.toggleOpen(this.isOpen());i.preventDefault();};
s.prototype.onsaphide=s.prototype.onsapshow;
s.prototype.onsappageup=function(i){var A=this._getCalendarConstructor().getMetadata().getName();i.preventDefault();if(A!="sap.ui.unified.Calendar"){return;}this._increaseDate(1,"day");};
s.prototype.onsappageupmodifiers=function(i){var A=this._getCalendarConstructor().getMetadata().getName();i.preventDefault();if(!i.ctrlKey&&i.shiftKey){if(A=="sap.ui.unified.internal.CustomYearPicker"){return;}this._increaseDate(1,"month");}else{this._increaseDate(1,"year");}};
s.prototype.onsappagedown=function(i){var A=this._getCalendarConstructor().getMetadata().getName();i.preventDefault();if(A!="sap.ui.unified.Calendar"){return;}this._increaseDate(-1,"day");};
s.prototype.onsappagedownmodifiers=function(i){var A=this._getCalendarConstructor().getMetadata().getName();i.preventDefault();if(!i.ctrlKey&&i.shiftKey){if(A=="sap.ui.unified.internal.CustomYearPicker"){return;}this._increaseDate(-1,"month");}else{this._increaseDate(-1,"year");}};
s.prototype.onkeypress=function(i){if(!i.charCode||i.metaKey||i.ctrlKey){return;}var F=this._getFormatter(true);var A=String.fromCharCode(i.charCode);if(A&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(A)<0){i.preventDefault();}};
s.prototype._getValueHelpIcon=function(){var i=this.getAggregation("_endIcon");return i&&i[0];};
s.prototype._dateValidation=function(i){this._bValid=true;if(i&&(i.getTime()<this._oMinDate.getTime()||i.getTime()>this._oMaxDate.getTime())){this._bValid=false;e(this._bValid,"Date must be in valid range");}this.setProperty("dateValue",i);return i;};
s.prototype.setMinDate=function(i){if(!this._isValidDate(i)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMinDate(),i)){return this;}if(i){var Y=i.getFullYear();if(Y<1||Y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMinDate=new Date(i.getTime());var A=this.getDateValue();if(A&&A.getTime()<i.getTime()){this._bValid=false;this._bOutOfAllowedRange=true;L.warning("DateValue not in valid date range",this);}}else{this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);}this.setProperty("minDate",i);if(this._getCalendar()){this._getCalendar().setMinDate(i);}this._oMinDate.setHours(0,0,0,0);return this;};
s.prototype.setMaxDate=function(i){if(!this._isValidDate(i)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMaxDate(),i)){return this;}if(i){var Y=i.getFullYear();if(Y<1||Y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMaxDate=new Date(i.getTime());var A=this.getDateValue();if(A&&A.getTime()>i.getTime()){this._bValid=false;this._bOutOfAllowedRange=true;L.warning("DateValue not in valid date",this);}}else{this._oMaxDate=new Date(9999,11,31,23,59,59,999);}this.setProperty("maxDate",i);if(this._getCalendar()){this._getCalendar().setMaxDate(i);}this._oMaxDate.setHours(23,59,59,999);return this;};
s.prototype.setCurrentDateButton=function(S){var i=this._getCalendar();i&&i.setCurrentDateButton(S);return this.setProperty("showCurrentDateButton",S);};
s.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){L.warning("minDate > MaxDate -> dates switched",this);var M=new Date(this._oMinDate.getTime());var i=new Date(this._oMaxDate.getTime());this._oMinDate=new Date(i.getTime());this._oMaxDate=new Date(M.getTime());this.setProperty("minDate",i,true);this.setProperty("maxDate",M,true);if(this._getCalendar()){this._getCalendar().setMinDate(i);this._getCalendar().setMaxDate(M);}}var A=this.getDateValue();if(A&&(A.getTime()<this._oMinDate.getTime()||A.getTime()>this._oMaxDate.getTime())){this._bValid=false;L.error("dateValue "+A.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain dateValue/value accordingly.",this);}};
s.prototype.getDisplayFormatType=function(){return this.getProperty("displayFormatType");};
s.prototype._handleDateValidation=function(i){this._bValid=true;if(!i||i.getTime()<this._oMinDate.getTime()||i.getTime()>this._oMaxDate.getTime()){this._bValid=false;L.warning("Value can not be converted to a valid date",this);}var A=this._formatValue(i,true);if(A!==this.getValue()){this.setLastValue(A);}this.setProperty("value",A);this.setProperty("dateValue",i);};
s.prototype.setDisplayFormatType=function(i){if(i){var F=false;for(var T in p){if(T==i){F=true;break;}}if(!F){throw new Error(i+" is not a valid calendar type"+this);}}this.setProperty("displayFormatType",i,true);this.setDisplayFormat(this.getDisplayFormat());return this;};
s.prototype.setSecondaryCalendarType=function(i){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",i,true);if(this._getCalendar()){this._getCalendar().setSecondaryCalendarType(i);}return this;};
s.prototype.setShowFooter=function(F){var P=this._oPopup,i=this._getCalendar();this.setProperty("showFooter",F);if(!P||!i){return this;}P._getButtonFooter().setVisible(F);return this;};
s.prototype.addSpecialDate=function(S){y.call(this,S);this.addAggregation("specialDates",S,true);z.call(this);return this;};
s.prototype.insertSpecialDate=function(S,i){y.call(this,S);this.insertAggregation("specialDates",S,i,true);z.call(this);return this;};
s.prototype.removeSpecialDate=function(S){var i=this.removeAggregation("specialDates",S,true);z.call(this);return i;};
s.prototype.removeAllSpecialDates=function(){var i=this.removeAllAggregation("specialDates",true);z.call(this);return i;};
s.prototype.destroySpecialDates=function(){this.destroyAggregation("specialDates",true);z.call(this);return this;};
s.prototype.setLegend=function(i){this.setAssociation("legend",i,true);var A=this.getLegend();if(A){var F=sap.ui.require("sap/ui/unified/CalendarLegend");i=sap.ui.getCore().byId(A);if(i&&!(typeof F=="function"&&i instanceof F)){throw new Error(i+" is not an sap.ui.unified.CalendarLegend. "+this);}}if(this._getCalendar()){this._getCalendar().setLegend(A);}return this;};
s.prototype.onChange=function(i){if(!this.getEditable()||!this.getEnabled()){return;}var A=this._$input.val(),O=this._formatValue(this.getDateValue()),F;if(A==O&&this._bValid){return;}if(this.getShowFooter()&&this._oPopup&&!A){this._oPopup.getBeginButton().setEnabled(false);}this._bValid=true;if(A!=""){F=this._parseValue(A,true);if(!F||F.getTime()<this._oMinDate.getTime()||F.getTime()>this._oMaxDate.getTime()){this._bValid=false;F=undefined;}else{A=this._formatValue(F);}}if(this.getDomRef()&&(this._$input.val()!==A)){this._$input.val(A);this._curpos=this._$input.cursorPos();}if(F){A=this._formatValue(F,true);}if(this.getLastValue()!==A||(F&&this.getDateValue()&&F.getFullYear()!==this.getDateValue().getFullYear())){this.setLastValue(A);this.setProperty("value",A,true);var N=this.getValue();if(this._bValid&&A==N){this.setProperty("dateValue",F,true);}A=N;if(this.isOpen()){if(this._bValid){F=this.getDateValue();}this._getCalendar().focusDate(F);var S=this._oDateRange.getStartDate();if((!S&&F)||(S&&F&&S.getTime()!=F.getTime())){this._oDateRange.setStartDate(new Date(F.getTime()));}else if(S&&!F){this._oDateRange.setStartDate(undefined);}}this.fireChangeEvent(A,{valid:this._bValid});}};
s.prototype._getInputValue=function(i){i=(typeof i=="undefined")?this._$input.val():i.toString();var A=this._parseValue(i,true);i=this._formatValue(A,true);return i;};
s.prototype.updateDomValue=function(i){if(this.isActive()&&(this._$input.val()!==i)){this._bCheckDomValue=true;i=(typeof i=="undefined")?this._$input.val():i.toString();this._curpos=this._$input.cursorPos();var A=this._parseValue(i,true);i=this._formatValue(A);this._$input.val(i);if(document.activeElement===this._$input[0]){this._$input.cursorPos(this._curpos);}}return this;};
function _(i){this._createPopup();this._createPopupContent();var A;var F=this.getBinding("value");if(F&&F.oType&&F.oType.oOutputFormat){A=F.oType.oOutputFormat.oFormatOptions.calendarType;}else if(F&&F.oType&&F.oType.oFormat){A=F.oType.oFormat.oFormatOptions.calendarType;}if(!A){A=this.getDisplayFormatType();}if(A){this._getCalendar().setPrimaryCalendarType(A);}var G=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(G!=this._$input.val()){this.onChange();}this._fillDateRange();this._openPopup(i);this.fireNavigate({dateRange:this._getVisibleDatesRange(this._getCalendar()),afterPopupOpened:true});}
s.prototype._createPopup=function(){var T="";if(!this._oPopup){this._oPopup=new R(this.getId()+"-RP",{showCloseButton:false,showArrow:false,showHeader:false,placement:l.PlacementType.VerticalPreferedBottom,contentWidth:this.$().closest(".sapUiSizeCompact").length>0?"18rem":"21rem",beginButton:new B({type:l.ButtonType.Emphasized,text:r.getText("DATEPICKER_SELECTION_CONFIRM"),press:this._handleOKButton.bind(this)}),afterOpen:v.bind(this),afterClose:w.bind(this)}).addStyleClass("sapMRPCalendar");if(this.getShowFooter()){this._oPopup.addStyleClass("sapMLandscapePadding");}this._oPopup._getPopup().setAutoClose(true);if(D.system.phone){T=o.getReferencingLabels(this).concat(this.getAriaLabelledBy()).reduce(function(A,i){var F=E.registry.get(i);return A+" "+(F.getText?F.getText():"");},"").trim();this._oPopup.setTitle(T);this._oPopup.setShowHeader(true);this._oPopup.setShowCloseButton(true);}else{this._oPopup._getPopup().setDurations(0,0);this._oPopup.setEndButton(new B({text:r.getText("DATEPICKER_SELECTION_CANCEL"),press:this._handleCancelButton.bind(this)}));}this.setAggregation("_popup",this._oPopup,true);}};
s.prototype._openPopup=function(i){if(!this._oPopup){return;}if(!i){i=this.getDomRef();}this._oPopup._getPopup().setAutoCloseAreas([i]);this._oPopup.openBy(i||this);};
s.prototype.openBy=function(i){_.call(this,i);};
s.prototype._getVisibleDatesRange=function(i){var A=i._getVisibleDays();return new j({startDate:A[0].toLocalJSDate(),endDate:A[A.length-1].toLocalJSDate()});};
s.prototype._createPopupContent=function(){var i=this._getCalendarConstructor();if(!this._getCalendar()){this._oCalendar=new i(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate(),legend:this.getLegend(),startDateChange:function(){this.fireNavigate({dateRange:this._getVisibleDatesRange(this._getCalendar())});}.bind(this)});this._oCalendar.setShowCurrentDateButton(this.getShowCurrentDateButton());this._oDateRange=new j();this._getCalendar().addSelectedDate(this._oDateRange);this._getCalendar()._setSpecialDatesControlOrigin(this);this._getCalendar().attachCancel(t,this);this._getCalendar().setPopupMode(true);if(this.$().closest(".sapUiSizeCompact").length>0){this._getCalendar().addStyleClass("sapUiSizeCompact");}if(this._bSecondaryCalendarTypeSet){this._getCalendar().setSecondaryCalendarType(this.getSecondaryCalendarType());}if(this._bOnlyCalendar){this._getCalendar().attachSelect(this._handleCalendarSelect,this);this._getCalendar().attachEvent("_renderMonth",x,this);this._oPopup._getButtonFooter().setVisible(this.getShowFooter());this._getCalendar()._bSkipCancelButtonRendering=true;if(!this._oPopup.getContent().length){var H=this._getValueStateHeader();this._oPopup.addContent(this._getValueStateHeader());H.setPopup(this._oPopup._oControl);}this._oPopup.addContent(this._getCalendar());if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false);}}this._attachAfterRenderingDelegate();}};
s.prototype._attachAfterRenderingDelegate=function(){this._oCalendarAfterRenderDelegate={onAfterRendering:function(){var P=this._oPopup&&this._oPopup._getPopup();P&&P._oLastPosition&&P._applyPosition(P._oLastPosition);if(this._oPopup.isOpen()){this._oCalendar.focus();}}.bind(this)};this._oCalendar.addDelegate(this._oCalendarAfterRenderDelegate);};
s.prototype._getCalendarConstructor=function(){var P=this._getFormatter(true).aFormatArray.map(function(A){return A.type.toLowerCase();}),i=P.indexOf("day")>=0,M=P.indexOf("month")>=0||P.indexOf("monthstandalone")>=0,Y=P.indexOf("year")>=0;if(i&&M&&Y){return h;}else if(M&&Y){return m;}else if(Y){return n;}else{L.warning("Not valid date pattern! Default Calendar constructor function is returned",this);return h;}};
s.prototype._fillDateRange=function(){var i=this.getDateValue();if(i&&i.getTime()>=this._oMinDate.getTime()&&i.getTime()<=this._oMaxDate.getTime()){this._getCalendar().focusDate(new Date(i.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=i.getTime()){this._oDateRange.setStartDate(new Date(i.getTime()));}}else{var A=this.getInitialFocusedDateValue();var F=A?A:new Date();var M=this._oMaxDate.getTime();if(F.getTime()<this._oMinDate.getTime()||F.getTime()>M){F=this._oMinDate;}this._getCalendar().focusDate(F);if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}};
s.prototype.getAccessibilityInfo=function(){var i=this.getRenderer();var A=I.prototype.getAccessibilityInfo.apply(this,arguments);var F=this.getValue()||"";if(this._bValid){var G=this.getDateValue();if(G){F=this._formatValue(G);}}A.type=r.getText("ACC_CTR_TYPE_DATEINPUT");A.description=[F,i.getLabelledByAnnouncement(this),i.getDescribedByAnnouncement(this)].join(" ").trim();return A;};
s.prototype._selectDate=function(){var i=this.getDateValue(),A=this._getSelectedDate(),F="";if(!d(A,i)){this.setDateValue(new Date(A.getTime()));F=this.getValue();this.fireChangeEvent(F,{valid:true});this._focusInput();}else if(!this._bValid){F=this._formatValue(A);if(F!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(F);this.setLastValue(F);}F=this._formatValue(A,true);this.setProperty("value",F,true);this.fireChangeEvent(F,{valid:true});this._focusInput();}}else if(D.system.desktop||!D.support.touch){this.focus();}this._oPopup.close();};
s.prototype._handleCalendarSelect=function(){if(this.getShowFooter()){this._oPopup.getBeginButton().setEnabled(true);return;}this._selectDate();};
s.prototype._focusInput=function(){if(this.getDomRef()&&(D.system.desktop||!D.support.touch)){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos);}return this;};
s.prototype._getCalendar=function(){return this._oCalendar;};
s.prototype._getSelectedDate=function(){var S=this._getCalendar().getSelectedDates(),i;if(S.length>0){i=S[0].getStartDate();}return i;};
s.prototype._handleOKButton=function(){this._selectDate();};
s.prototype._handleCancelButton=function(){if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false);}this._oPopup.close();};
function t(i){if(this.isOpen()){this._oPopup.close();if((D.system.desktop||!D.support.touch)){this.focus();}}}
s.prototype._increaseDate=function(N,i){var O=this.getDateValue();var A=this._$input.cursorPos();if(O&&this.getEditable()&&this.getEnabled()){var F;var G=this.getBinding("value");if(G&&G.oType&&G.oType.oOutputFormat){F=G.oType.oOutputFormat.oFormatOptions.calendarType;}else if(G&&G.oType&&G.oType.oFormat){F=G.oType.oFormat.oFormatOptions.calendarType;}if(!F){F=this.getDisplayFormatType();}var H=U.getInstance(new Date(O.getTime()),F);O=U.getInstance(new Date(O.getTime()),F);switch(i){case"day":H.setDate(H.getDate()+N);break;case"month":H.setMonth(H.getMonth()+N);var M=(O.getMonth()+N)%12;if(M<0){M=12+M;}while(H.getMonth()!=M){H.setDate(H.getDate()-1);}break;case"year":H.setFullYear(H.getFullYear()+N);while(H.getMonth()!=O.getMonth()){H.setDate(H.getDate()-1);}break;default:break;}if(H.getTime()<this._oMinDate.getTime()){H=new U(this._oMinDate.getTime());}else if(H.getTime()>this._oMaxDate.getTime()){H=new U(this._oMaxDate.getTime());}if(!d(this.getDateValue(),H.getJSDate())){this.setDateValue(new Date(H.getTime()));this._curpos=A;this._$input.cursorPos(this._curpos);var J=this.getValue();this.fireChangeEvent(J,{valid:true});}}};
s.prototype._getSpecialDates=function(){var A=this.getSpecialDates();for(var i=0;i<A.length;i++){var N=A[i].getSecondaryType()===u.CalendarDayType.NonWorking&&A[i].getType()!==u.CalendarDayType.NonWorking;if(N){var F=new k();F.setType(A[i].getSecondaryType());F.setStartDate(A[i].getStartDate());if(A[i].getEndDate()){F.setEndDate(A[i].getEndDate());}A.push(F);}}return A;};
function v(){this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);this._renderedDays=this._getCalendar().$("-Month0-days").find(".sapUiCalItem").length;this.$("inner").attr("aria-owns",this.getId()+"-cal");this.$("inner").attr("aria-expanded",true);g.addPopoverInstance(this._oPopup);this._oCalendar.focus();}
function w(){if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false);}this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.$("inner").attr("aria-expanded",false);this._getCalendar()._closePickers();g.removePopoverInstance(this._oPopup);}
function x(i){var A=i.getParameter("days"),P=this._oPopup._getPopup();if(A>this._renderedDays){this._renderedDays=A;P._applyPosition(P._oLastPosition);}}
function y(S){var k=sap.ui.require("sap/ui/unified/DateTypeRange");if(S&&!(k&&S instanceof k)){throw new Error(S+"is not valid for aggregation \"specialDates\" of "+this);}}
function z(){if(this.isOpen()){this._getCalendar()._bDateRangeChanged=false;this._getCalendar().invalidate();}}
return s;});
sap.ui.predefine('sap/m/DatePickerRenderer',['sap/ui/core/Renderer','./InputBaseRenderer','sap/ui/core/library'],function(R,I,c){"use strict";var D=R.extend(I);D.apiVersion=2;
D.writeInnerValue=function(r,d){if(d._bValid||d._bOutOfAllowedRange){r.attr("value",d._formatValue(d.getDateValue()));}else{r.attr("value",d.getValue());}};
D.writeInnerAttributes=function(r,d){r.attr("type","text");if(d._bMobile){r.attr("readonly","readonly");}};
D.getAriaRole=function(d){return"combobox";};
D.getAccessibilityState=function(d){var a=I.getAccessibilityState.apply(this,arguments);a["roledescription"]=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATEINPUT");a["autocomplete"]="none";a["haspopup"]=c.aria.HasPopup.Grid.toLowerCase();a["expanded"]=false;a["disabled"]=null;if(d._bMobile&&d.getEnabled()&&d.getEditable()){a["readonly"]=false;}return a;};
D.addOuterClasses=function(r,C){if(C.getHideInput()){r.class("sapMDatePickerHiddenInput");}I.addOuterClasses.apply(this,arguments);};
return D;},true);
sap.ui.predefine('sap/m/DateRangeSelection',['sap/ui/Device','./DatePicker','./library','sap/ui/core/LocaleData','sap/ui/core/format/DateFormat','sap/ui/core/date/UniversalDate','./DateRangeSelectionRenderer',"sap/ui/unified/calendar/CustomMonthPicker","sap/ui/unified/calendar/CustomYearPicker","sap/base/util/deepEqual","sap/base/Log","sap/base/assert","sap/ui/dom/jquery/cursorPos"],function(D,a,l,L,b,U,c,C,d,f,g,h){"use strict";
var j=a.extend("sap.m.DateRangeSelection",{metadata:{library:"sap.m",properties:{delimiter:{type:"string",group:"Misc",defaultValue:'-'},secondDateValue:{type:"object",group:"Data",defaultValue:null},from:{type:"object",group:"Misc",defaultValue:null,deprecated:true},to:{type:"object",group:"Misc",defaultValue:null,deprecated:true}},designtime:"sap/m/designtime/DateRangeSelection.designtime",dnd:{draggable:false,droppable:true}}});
var H=String.fromCharCode(45),E=String.fromCharCode(8211),k=String.fromCharCode(8212);
j.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=true;};
j.prototype._createPopupContent=function(){a.prototype._createPopupContent.apply(this,arguments);var e=this._getCalendar();if(e instanceof C){e._getMonthPicker().setIntervalSelection(true);}if(e instanceof d){e._getYearPicker().setIntervalSelection(true);}this._getCalendar().attachWeekNumberSelect(this._handleWeekSelect,this);this._getCalendar().getSelectedDates()[0].setStartDate(this._oDateRange.getStartDate());this._getCalendar().getSelectedDates()[0].setEndDate(this._oDateRange.getEndDate());};
j.prototype.onkeypress=function(e){if(!e.charCode||e.metaKey||e.ctrlKey){return;}var F=r.call(this);var i=q.call(this);var A=F.sAllowedCharacters+i+" ";var v=String.fromCharCode(e.charCode);if(v&&F.sAllowedCharacters&&A.indexOf(v)<0){e.preventDefault();}};
j.prototype._getPlaceholder=function(){var P=this.getPlaceholder(),B,e,i,v;if(!P){B=this.getBinding("value");i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();v=L.getInstance(i);if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){e=B.getType();if(e.oFormatOptions&&e.oFormatOptions.format){P=v.getCustomDateTimePattern(e.oFormatOptions.format);}else{P=v.getDatePattern("medium");}}else{P=this.getDisplayFormat();if(!P){P="medium";}if(this._checkStyle(P)){P=v.getDatePattern(P);}}var w=q.call(this);if(w&&w!==""){P=P+" "+w+" "+P;}}return P;};
j.prototype.setValue=function(v){if(v!==this.getValue()){this.setLastValue(v);}else{return this;}this.setProperty("value",v);this._bValid=true;var e=[undefined,undefined];if(v){e=this._parseValue(v);if(!o.call(this,e[0],e[1])[0]){this._bValid=false;g.warning("Value can not be converted to a valid dates",this);}}this.setProperty("dateValue",_(e[0]));this.setProperty("secondDateValue",_(e[1]));if(this.getDomRef()){var O=this._formatValue(e[0],e[1]);if(this._$input.val()!==O){this._$input.val(O);this._curpos=this._$input.cursorPos();}}return this;};
function _(B){return(typeof B==='number')?new Date(B):B;}
function m(B){return(B&&B.getTime)?B.getTime():B;}
j.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);g.warning("Property valueFormat is not supported in sap.m.DateRangeSelection control.",this);return this;};
j.prototype.setDisplayFormat=function(e){a.prototype.setDisplayFormat.apply(this,arguments);var O=this._formatValue(this.getDateValue(),this.getSecondDateValue());this.setProperty("value",O,true);if(this.getDomRef()&&(this._$input.val()!==O)){this._$input.val(O);this._curpos=this._$input.cursorPos();}return this;};
j.prototype.setFrom=function(F){this.setDateValue(F);return this;};
j.prototype.getFrom=function(){return this.getDateValue();};
j.prototype.setTo=function(T){this.setSecondDateValue(T);return this;};
j.prototype.getTo=function(){return this.getSecondDateValue();};
j.prototype.setDateValue=function(e){if(!this._isValidDate(e)){throw new Error("Date must be a JavaScript date object; "+this);}if(f(this.getDateValue(),e)){return this;}a.prototype._dateValidation.call(this,e);this._syncDateObjectsToValue(e,this.getSecondDateValue());return this;};
j.prototype.setSecondDateValue=function(S){if(!this._isValidDate(S)){throw new Error("Date must be a JavaScript date object; "+this);}if(f(this.getSecondDateValue(),S)){return this;}this._bValid=true;if(S&&(S.getTime()<this._oMinDate.getTime()||S.getTime()>this._oMaxDate.getTime())){this._bValid=false;h(this._bValid,"Date must be in valid range");}this.setProperty("secondDateValue",S);this._syncDateObjectsToValue(this.getDateValue(),S);return this;};
j.prototype.setMinDate=function(e){a.prototype.setMinDate.apply(this,arguments);if(e){var S=this.getSecondDateValue();if(S&&S.getTime()<this._oMinDate.getTime()){g.warning("SecondDateValue not in valid date range",this);}}return this;};
j.prototype.setMaxDate=function(e){a.prototype.setMaxDate.apply(this,arguments);if(e){var S=this.getSecondDateValue();if(S&&S.getTime()>this._oMaxDate.getTime()){g.warning("SecondDateValue not in valid date range",this);}}return this;};
j.prototype._checkMinMaxDate=function(){a.prototype._checkMinMaxDate.apply(this,arguments);var S=this.getSecondDateValue();if(S&&(S.getTime()<this._oMinDate.getTime()||S.getTime()>this._oMaxDate.getTime())){g.error("secondDateValue "+S.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain secondDateValue/value accordingly.",this);}};
j.prototype._parseValue=function(v){var F;var i=[];var w,x;var B=this.getBinding("value");if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){try{i=B.getType().parseValue(v,"string");}catch(e){return[undefined,undefined];}if(B.getType().oFormatOptions&&B.getType().oFormatOptions.UTC){i=i.map(function(A){return new Date(A.getUTCFullYear(),A.getUTCMonth(),A.getUTCDate(),A.getUTCHours(),A.getUTCMinutes(),A.getUTCSeconds());});}return i;}var y=q.call(this);if(y&&v){v=v.trim();v=u(v,[y," "]);i=this._splitValueByDelimiter(v,y);if(i.length===2){if(i[0].slice(i[0].length-1,i[0].length)==" "){i[0]=i[0].slice(0,i[0].length-1);}if(i[1].slice(0,1)==" "){i[1]=i[1].slice(1);}}else{i=v.split(" "+y+" ");}if(v.indexOf(y)===-1){var z=v.split(" ");if(z.length===2){i=z;}}}if(v&&i.length<=2){F=r.call(this);if((!y||y==="")||i.length===1){w=F.parse(v);}else if(i.length===2){w=F.parse(i[0]);x=F.parse(i[1]);if(!w||!x){w=undefined;x=undefined;}}}return[w,x];};
j.prototype._splitValueByDelimiter=function(v,e){var w=[H,E,k],i;if(e){if(w.indexOf(e)===-1){return v.split(e);}}for(i=0;i<w.length;i++){if(v.indexOf(w[i])>0){return v.split(w[i]);}}return v?v.split(" "):[];};
j.prototype._formatValue=function(e,S){var v="",i=q.call(this),F,B,w,x;w=e;x=S;if(w){B=this.getBinding("value");if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){if(B.getType().oFormatOptions&&B.getType().oFormatOptions.source&&B.getType().oFormatOptions.source.pattern==="timestamp"){v=B.getType().formatValue([m(e),m(S)],"string");}else{if(B.getType().oFormatOptions&&B.getType().oFormatOptions.UTC){w=new Date(Date.UTC(e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds()));if(S){x=new Date(Date.UTC(S.getFullYear(),S.getMonth(),S.getDate(),S.getHours(),S.getMinutes(),S.getSeconds()));}}v=B.getType().formatValue([w,x],"string");}}else{F=r.call(this);if(i&&i!==""&&x){v=F.format(w)+" "+i+" "+F.format(x);}else{v=F.format(w);}}}return v;};
j.prototype.onChange=function(){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var e=[undefined,undefined];if(this.getShowFooter()&&this._oPopup&&!v){this._oPopup.getBeginButton().setEnabled(false);}this._bValid=true;if(v!=""){e=this._parseValue(v);e[1]&&e[1].setHours(23,59,59,999);e=o.call(this,e[0],e[1]);if(e[0]){v=this._formatValue(e[0],e[1]);}else{this._bValid=false;}}if(v!==this.getLastValue()){if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}this.setLastValue(v);this.setProperty("value",v,true);if(this._bValid){this.setProperty("dateValue",_(e[0]),true);this.setProperty("secondDateValue",_(e[1]),true);}if(this._oPopup&&this._oPopup.isOpen()){var S=this.getDateValue();if(S){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!==S.getTime()){this._oDateRange.setStartDate(new Date(S.getTime()));this._getCalendar().focusDate(S);}}else{if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}var i=this.getSecondDateValue();if(i){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==i.getTime()){this._oDateRange.setEndDate(new Date(i.getTime()));this._getCalendar().focusDate(i);}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}}n.call(this,this._bValid);}};
j.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();if(!v){return"";}var e=this._parseValue(v);v=this._formatValue(e[0],e[1]);return v;};
j.prototype.updateDomValue=function(v){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var e=this._parseValue(v);v=this._formatValue(e[0],e[1]);if(this.isActive()&&(this._$input.val()!==v)){this._$input.val(v);this._$input.cursorPos(this._curpos);}return this;};
j.prototype._fillDateRange=function(){a.prototype._fillDateRange.apply(this,arguments);var e=this.getSecondDateValue();if(e&&e.getTime()>=this._oMinDate.getTime()&&e.getTime()<=this._oMaxDate.getTime()){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==e.getTime()){this._oDateRange.setEndDate(new Date(e.getTime()));}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}};
j.prototype._selectDate=function(){var S=this._getCalendar().getSelectedDates();if(S.length>0){var e=S[0].getStartDate();var i=S[0].getEndDate();if(e&&i){var v=this.getDateValue();var w=this.getSecondDateValue();i.setHours(23,59,59,999);var V;if(!f(e,v)||!f(i,w)){if(f(i,w)){this.setDateValue(e);}else{this.setProperty("dateValue",e,true);this.setSecondDateValue(i);}V=this.getValue();n.call(this,true);if(D.system.desktop||!D.support.touch){this._curpos=V.length;this._$input.cursorPos(this._curpos);}}else if(!this._bValid){V=this._formatValue(e,i);if(V!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(V);}n.call(this,true);}}this._oDateRange.setStartDate(this._getCalendar().getSelectedDates()[0].getStartDate());this._oDateRange.setEndDate(this._getCalendar().getSelectedDates()[0].getEndDate());this._oPopup.close();}}};
j.prototype._handleCalendarSelect=function(){var S=this._getCalendar().getSelectedDates(),e=S[0].getStartDate(),i=S[0].getEndDate();if(this.getShowFooter()){this._oPopup.getBeginButton().setEnabled(!!(e&&i));return;}this._selectDate();};
j.prototype._handleWeekSelect=function(e){var S=e.getParameter("weekDays"),i=S.getStartDate(),v=S.getEndDate();if(this.getShowFooter()){this._oPopup.getBeginButton().setEnabled(!!(i&&v));return;}this._getCalendar().getSelectedDates()[0].setStartDate(i);this._getCalendar().getSelectedDates()[0].setEndDate(v);this._oDateRange.setStartDate(i);this._oDateRange.setEndDate(v);this._selectDate();};
j.prototype.getAccessibilityInfo=function(){var R=this.getRenderer();var i=a.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var e=this.getDateValue();if(e){v=this._formatValue(e,this.getSecondDateValue());}}i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATERANGEINPUT");i.description=[v,R.getLabelledByAnnouncement(this),R.getDescribedByAnnouncement(this)].join(" ").trim();return i;};
j.prototype._syncDateObjectsToValue=function(e,S){var v=this._formatValue(e,S);if(v!==this.getValue()){this.setLastValue(v);}this.setProperty("value",v);if(this.getDomRef()){var O=this._formatValue(e,S);if(this._$input.val()!==O){this._$input.val(O);this._curpos=this._$input.cursorPos();}}};
function n(v){this.fireChangeEvent(this.getValue(),{from:this.getDateValue(),to:this.getSecondDateValue(),valid:v});}
function o(e,S){var F,i;if(e&&e.getTime){F=e.getTime();}else if(typeof e==='number'){F=e;}if(S&&S.getTime){i=S.getTime();}else if(typeof S==='number'){i=S;}if(e&&S&&F>i){var T=e;e=S;S=T;}if((e&&(F<this._oMinDate.getTime()||F>this._oMaxDate.getTime()))||(S&&(i<this._oMinDate.getTime()||i>this._oMaxDate.getTime()))){return[undefined,undefined];}else{return[e,S];}}
j.prototype._increaseDate=function(N,e){var v=this._$input.val(),i=this._parseValue(v),F=i[0],S=i[1],w=r.call(this),x=q.call(this),y,z,A,V,B,G,I;if(!F||!this.getEditable()||!this.getEnabled()){return;}if(!o.call(this,F,S)[0]){g.warning("Value can not be converted to a valid dates or dates are outside of the min/max range",this);this._bValid=false;n.call(this,this._bValid);return;}v=u(v,[x," "]);y=this._$input.cursorPos();z=F?w.format(F).length:0;A=S?w.format(S).length:0;V=v.length;B=y<=z+1;G=y>=V-A-1&&y<=V;if(B&&F){I=p.call(this,F,N,e);if(!f(this.getDateValue(),I.getJSDate())){this.setDateValue(new Date(I.getTime()));this._curpos=y;this._$input.cursorPos(this._curpos);this.fireChangeEvent(this.getValue(),{valid:this._bValid});}}else if(G&&S){I=p.call(this,S,N,e);if(!f(this.getSecondDateValue(),I.getJSDate())){this.setSecondDateValue(new Date(I.getTime()));this._curpos=y;this._$input.cursorPos(this._curpos);this.fireChangeEvent(this.getValue(),{valid:this._bValid});}}};
function p(O,N,e){var B=this.getBinding("value"),i,M,v,w;if(B&&B.oType&&B.oType.oOutputFormat){i=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){i=B.oType.oFormat.oFormatOptions.calendarType;}if(!i){i=this.getDisplayFormatType();}v=U.getInstance(new Date(O.getTime()),i);w=v.getMonth();switch(e){case"day":v.setDate(v.getDate()+N);break;case"month":v.setMonth(v.getMonth()+N);M=(w+N)%12;if(M<0){M=12+M;}while(v.getMonth()!=M){v.setDate(v.getDate()-1);}break;case"year":v.setFullYear(v.getFullYear()+N);while(v.getMonth()!=w){v.setDate(v.getDate()-1);}break;default:break;}if(v.getTime()<this._oMinDate.getTime()){v=new U(this._oMinDate.getTime());}else if(v.getTime()>this._oMaxDate.getTime()){v=new U(this._oMaxDate.getTime());}return v;}
function q(){var e=this.getDelimiter();if(!e){if(!this._sLocaleDelimiter){var i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var v=L.getInstance(i);var P=v.getIntervalPattern();var I=P.indexOf("{0}")+3;var w=P.indexOf("{1}");e=P.slice(I,w);if(e.length>1){if(e.slice(0,1)==" "){e=e.slice(1);}if(e.slice(e.length-1,e.length)==" "){e=e.slice(0,e.length-1);}}this._sLocaleDelimiter=e;}else{e=this._sLocaleDelimiter;}}return e;}
function r(){var P=(this.getDisplayFormat()||"medium");var F;var e=this.getDisplayFormatType();if(P==this._sUsedDisplayPattern&&e==this._sUsedDisplayCalendarType){F=this._oDisplayFormat;}else{if(this._checkStyle(P)){F=b.getInstance({style:P,strictParsing:true,calendarType:e});}else{F=b.getInstance({pattern:P,strictParsing:true,calendarType:e});}this._sUsedDisplayPattern=P;this._sUsedDisplayCalendarType=e;this._oDisplayFormat=F;}return F;}
function s(v,e){return v&&e&&v.lastIndexOf(e)===v.length-e.length;}
function t(v,S){return v&&S&&v.indexOf(S)===0;}
function u(v,P){var i=0,T=P;if(!T){T=[" "];}while(i<T.length){if(s(v,T[i])){v=v.substring(0,v.length-T[i].length);i=0;continue;}i++;}i=0;while(i<T.length){if(t(v,T[i])){v=v.substring(T[i].length);i=0;continue;}i++;}return v;}
return j;});
sap.ui.predefine('sap/m/DateRangeSelectionRenderer',['sap/ui/core/Renderer','./DatePickerRenderer'],function(R,D){"use strict";var a=R.extend(D);a.apiVersion=2;
a.writeInnerValue=function(r,c){if(c._bValid){r.attr("value",c._formatValue(c.getDateValue(),c.getSecondDateValue()));}else{r.attr("value",c.getValue());}};
a.getAccessibilityState=function(d){var A=D.getAccessibilityState.apply(this,arguments);A["roledescription"]=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATERANGEINPUT");return A;};
return a;},true);
sap.ui.predefine('sap/m/DateTimeField',['sap/ui/model/type/Date','sap/ui/model/odata/type/ODataType','sap/ui/model/odata/type/DateTimeBase','./InputBase','./ValueStateHeader','sap/ui/core/Core','sap/ui/core/LocaleData','sap/ui/core/library','sap/ui/core/format/DateFormat','./DateTimeFieldRenderer',"sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos"],function(S,O,D,I,V,C,L,c,a,b,d,f,q){"use strict";var g=c.CalendarType;var h=c.ValueState;
var i=I.extend("sap.m.DateTimeField",{metadata:{"abstract":true,library:"sap.m",properties:{displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null},initialFocusedDateValue:{type:"object",group:"Data",defaultValue:null}}}});
i.prototype.setValue=function(v){v=this.validateProperty("value",v);var o=this.getValue();if(v===o){return this;}else{this.setLastValue(v);}this.setProperty("value",v);this._bValid=true;var e;if(v){e=this._parseValue(v);if(!e||e.getTime()<this._oMinDate.getTime()||e.getTime()>this._oMaxDate.getTime()){this._bValid=false;f.warning("Value can not be converted to a valid date",this);}}this.setProperty("dateValue",e);if(this.getDomRef()){var s;if(e){s=this._formatValue(e);}else{s=v;}if(this._$input.val()!==s){this._$input.val(s);this._curpos=this._$input.cursorPos();}}return this;};
i.prototype.setDateValue=function(o){if(!this._isValidDate(o)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getDateValue(),o)){return this;}o=this._dateValidation(o);var v=this._formatValue(o,true);if(v!==this.getValue()){this.setLastValue(v);}this.setProperty("value",v);if(this.getDomRef()){var s=this._formatValue(o);if(this._$input.val()!==s){this._$input.val(s);this._curpos=this._$input.cursorPos();}}return this;};
i.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var s=this.getValue();if(s){this._handleDateValidation(this._parseValue(s));}return this;};
i.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);this.updateDomValue(this._formatValue(this.getDateValue()));this.setPlaceholder(this._getPlaceholder());return this;};
i.prototype.getDisplayFormatType=function(){return null;};
i.prototype.onfocusin=function(e){if(!q(e.target).hasClass("sapUiIcon")){this.addStyleClass("sapMFocus");}if(!q(e.target).hasClass("sapMInputBaseIconContainer")&&!(this._oPopup&&this._oPopup.isOpen())){this.openValueStateMessage();}else if(this._oValueStateHeader){this._oValueStateHeader.setVisible(this.getValueState()!==h.None);}};
i.prototype._getValueStateHeader=function(){var v;if(!this._oValueStateHeader){v=this.getValueState();this._oValueStateHeader=new V({text:this._getTextForPickerValueStateContent(),valueState:v,visible:v!==h.None});}return this._oValueStateHeader;};
i.prototype._dateValidation=function(o){this._bValid=true;this.setProperty("dateValue",o);return o;};
i.prototype._handleDateValidation=function(o){this._bValid=true;this.setProperty("dateValue",o);};
i.prototype._getPlaceholder=function(){var p=this.getPlaceholder();if(!p){p=this._getDisplayFormatPattern();if(!p){p=this._getDefaultDisplayStyle();}if(this._checkStyle(p)){p=this._getLocaleBasedPattern(p);}}return p;};
i.prototype._getLocaleBasedPattern=function(p){return L.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()).getDatePattern(p);};
i.prototype._parseValue=function(v,j){var B=this.getBinding("value"),o=B&&B.getType&&B.getType(),F=this._getFormatter(j),k,l,m;if(o&&this._isSupportedBindingType(o)){try{m=o.parseValue(v,"string");if(typeof(m)==="string"&&o instanceof D){m=D.prototype.parseValue.call(o,v,"string");}k=o.oFormatOptions;if(k&&k.source&&k.source.pattern=="timestamp"){m=new Date(m);}else if(k&&k.source&&typeof k.source.pattern==="string"){m=o.oInputFormat.parse(v);}}catch(e){}if(m&&((o.oFormatOptions&&this._isFormatOptionsUTC(o.oFormatOptions))||(o.oConstraints&&o.oConstraints.isDateOnly))){l=new Date(m.getUTCFullYear(),m.getUTCMonth(),m.getUTCDate(),m.getUTCHours(),m.getUTCMinutes(),m.getUTCSeconds(),m.getUTCMilliseconds());l.setFullYear(m.getUTCFullYear());m=l;}return m;}return F.parse(v);};
i.prototype._formatValue=function(o,v){if(!o){return"";}var B=this.getBinding("value"),e=B&&B.getType&&B.getType(),F,j;if(e&&this._isSupportedBindingType(e)){if((e.oFormatOptions&&e.oFormatOptions.UTC)||(e.oConstraints&&e.oConstraints.isDateOnly)){j=new Date(Date.UTC(o.getFullYear(),o.getMonth(),o.getDate(),o.getHours(),o.getMinutes(),o.getSeconds(),o.getMilliseconds()));j.setUTCFullYear(o.getFullYear());o=j;}F=e.oFormatOptions;if(F&&F.source&&F.source.pattern=="timestamp"){o=o.getTime();}else if(e.oOutputFormat){return e.oOutputFormat.format(o);}return e.formatValue(o,"string");}return this._getFormatter(!v).format(o);};
i.prototype._isSupportedBindingType=function(B){return B.isA(["sap.ui.model.type.Date","sap.ui.model.odata.type.DateTime","sap.ui.model.odata.type.DateTimeOffset"]);};
i.prototype._isFormatOptionsUTC=function(B){return(B.UTC||(B.source&&B.source.UTC));};
i.prototype._getDefaultDisplayStyle=function(){return"medium";};
i.prototype._getDefaultValueStyle=function(){return"short";};
i.prototype._getFormatter=function(e){var p=this._getBoundValueTypePattern(),r=false,F,B=this.getBinding("value"),s;if(B&&B.oType&&B.oType.oOutputFormat){r=!!B.oType.oOutputFormat.oFormatOptions.relative;s=B.oType.oOutputFormat.oFormatOptions.calendarType;}if(!p){if(e){p=(this.getDisplayFormat()||this._getDefaultDisplayStyle());s=this.getDisplayFormatType();}else{p=(this.getValueFormat()||this._getDefaultValueStyle());s=g.Gregorian;}}if(!s){s=sap.ui.getCore().getConfiguration().getCalendarType();}if(e){if(p===this._sUsedDisplayPattern&&s===this._sUsedDisplayCalendarType){F=this._oDisplayFormat;}}else{if(p===this._sUsedValuePattern&&s===this._sUsedValueCalendarType){F=this._oValueFormat;}}if(F){return F;}return this._getFormatterInstance(F,p,r,s,e);};
i.prototype._getFormatterInstance=function(F,p,r,s,e){if(this._checkStyle(p)){F=this._getFormatInstance({style:p,strictParsing:true,relative:r,calendarType:s},e);}else{F=this._getFormatInstance({pattern:p,strictParsing:true,relative:r,calendarType:s},e);}if(e){this._sUsedDisplayPattern=p;this._sUsedDisplayCalendarType=s;this._oDisplayFormat=F;}else{this._sUsedValuePattern=p;this._sUsedValueCalendarType=s;this._oValueFormat=F;}return F;};
i.prototype._getFormatInstance=function(A,e){return a.getInstance(A);};
i.prototype._checkStyle=function(p){return(p==="short"||p==="medium"||p==="long"||p==="full");};
i.prototype._getDisplayFormatPattern=function(){var p=this._getBoundValueTypePattern();if(p){return p;}p=this.getDisplayFormat();if(this._checkStyle(p)){p=this._getLocaleBasedPattern(p);}return p;};
i.prototype._getBoundValueTypePattern=function(){var B=this.getBinding("value"),o=B&&B.getType&&B.getType();if(o instanceof S){return o.getOutputPattern();}if(o instanceof O&&o.oFormat){return o.oFormat.oFormatOptions.pattern;}return undefined;};
i.prototype._isValidDate=function(o){return!o||Object.prototype.toString.call(o)==="[object Date]";};
i.prototype._getTextForPickerValueStateContent=function(){return this.getValueStateText()||this._getDefaultTextForPickerValueStateContent();};
i.prototype._getDefaultTextForPickerValueStateContent=function(){var v=this.getValueState(),r,t;if(v===h.None){t="";}else{r=C.getLibraryResourceBundle("sap.ui.core");t=r.getText("VALUE_STATE_"+v.toUpperCase());}return t;};
return i;});
sap.ui.predefine('sap/m/DateTimeFieldRenderer',['sap/ui/core/Renderer','./InputBaseRenderer'],function(R,I){"use strict";var D=R.extend(I);D.apiVersion=2;return D;},true);
sap.ui.predefine('sap/m/DateTimeInput',["sap/ui/thirdparty/jquery",'sap/ui/core/Control','./library','./DatePicker','./DateTimePicker','./TimePicker','sap/ui/model/type/Date','sap/ui/model/type/Time','sap/ui/model/type/DateTime','sap/ui/model/odata/type/ODataType','sap/ui/core/library','sap/ui/Device',"./DateTimeInputRenderer"],function(q,C,l,D,a,T,b,c,d,O,e,f,g){"use strict";var h=l.DateTimeInputType;var j=e.TextDirection;var k=e.TextAlign;var V=e.ValueState;
var m=C.extend("sap.m.DateTimeInput",{metadata:{library:"sap.m",deprecated:true,designtime:"sap/m/designtime/DateTimeInput.designtime",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:k.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:j.Inherit},type:{type:"sap.m.DateTimeInputType",group:"Data",defaultValue:h.Date},displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}},aggregations:{_picker:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"},dateValue:{type:"object"},valid:{type:"boolean"}}}}}});
!(function(P,$,i){var r=l.getLocaleData();q.extend(P,{_types:{Date:{valueFormat:r.getDatePattern("short"),displayFormat:r.getDatePattern("medium")},Time:{valueFormat:r.getTimePattern("short"),displayFormat:r.getTimePattern("short")},DateTime:{valueFormat:r.getDateTimePattern("short"),displayFormat:r.getDateTimePattern("short")}}});["Time","Date"].forEach(function(t,s){["valueFormat","displayFormat"].forEach(function(F){var u=P._types;u.DateTime[F]=u.DateTime[F].replace("{"+s+"}",u[t][F]);});});}(m.prototype,q,f));
m.prototype.init=function(){this.setType(h.Date);};
m.prototype.onBeforeRendering=function(){o.call(this);};
m.prototype.getFocusDomRef=function(){var P=_.call(this);return P.getFocusDomRef();};
m.prototype.getIdForLabel=function(){var P=_.call(this);return P.getIdForLabel();};
function n(t){var P;switch(t){case h.DateTime:P=new a(this.getId()+"-Picker");break;case h.Time:P=new T(this.getId()+"-Picker",{localeId:sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()});break;default:P=new D(this.getId()+"-Picker");break;}P.setDisplayFormat(this.getDisplayFormat()||this._types[t].displayFormat);P.setValueFormat(this.getValueFormat()||this._types[t].valueFormat);if(this.getDateValue()){P.setDateValue(this.getDateValue());}P.setEnabled(this.getEnabled());P.setEditable(this.getEditable());P.setValueState(this.getValueState());P.setValueStateText(this.getValueStateText());P.setShowValueStateMessage(this.getShowValueStateMessage());P.setName(this.getName());P.setPlaceholder(this.getPlaceholder());P.setTextAlign(this.getTextAlign());P.setTextDirection(this.getTextDirection());P.setWidth("100%");P.attachChange(p,this);var A=this.getAriaLabelledBy();for(var i=0;i<A.length;i++){P.addAriaLabelledBy(A[i]);}return P;}
m.prototype.setType=function(t){if(t==this.getType()&&_.call(this)){return this;}this.destroyAggregation("_picker");var P=n.call(this,t);this.setAggregation("_picker",P);this.setProperty("type",t);return this;};
m.prototype.setWidth=function(w){this.setProperty("width",w);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);}return this;};
m.prototype.setValue=function(v){o.call(this);v=this.validateProperty("value",v);if(v.toLowerCase()=="now"){return this.setDateValue(new Date());}if(v===this.getValue()){return this;}this.setProperty("value",v,true);var P=_.call(this);P.setValue(v);var i=P.getDateValue();this.setProperty("dateValue",i,true);return this;};
m.prototype.setDateValue=function(i){if(!this._isValidDate(i)){throw new Error("Date must be a JavaScript date object; "+this);}o.call(this);this.setProperty("dateValue",i,true);var P=_.call(this);P.setDateValue(i);var v=P.getValue();this.setProperty("value",v,true);return this;};
m.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var P=_.call(this);P.setDisplayFormat(s||this._types[this.getType()].displayFormat);return this;};
m.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var P=_.call(this);P.setValueFormat(v||this._types[this.getType()].ValueFormat);return this;};
m.prototype.setEnabled=function(E){this.setProperty("enabled",E,true);var P=_.call(this);P.setEnabled(E);return this;};
m.prototype.setEditable=function(E){this.setProperty("editable",E,true);var P=_.call(this);P.setEditable(E);return this;};
m.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var P=_.call(this);P.setValueState(v);return this;};
m.prototype.setValueStateText=function(v){this.setProperty("valueStateText",v,true);var P=_.call(this);P.setValueStateText(v);return this;};
m.prototype.setShowValueStateMessage=function(s){this.setProperty("showValueStateMessage",s,true);var P=_.call(this);P.setShowValueStateMessage(s);return this;};
m.prototype.setName=function(N){this.setProperty("name",N,true);var P=_.call(this);P.setName(N);return this;};
m.prototype.setPlaceholder=function(P){this.setProperty("placeholder",P,true);var i=_.call(this);i.setPlaceholder(P);return this;};
m.prototype.setTextAlign=function(t){this.setProperty("textAlign",t,true);var P=_.call(this);P.setTextAlign(t);return this;};
m.prototype.setTextDirection=function(t){this.setProperty("textDirection",t,true);var P=_.call(this);P.setTextDirection(t);return this;};
m.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var P=_.call(this);P.addAriaLabelledBy(i);return this;};
m.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var P=_.call(this);P.removeAriaLabelledBy(i);return this;};
m.prototype.removeAllAriaLabelledBy=function(){this.removeAssociation("ariaLabelledBy",true);var P=_.call(this);P.removeAllAriaLabelledBy();return this;};
m.prototype.getAccessibilityInfo=function(){var P=_.call(this);return P&&P.getAccessibilityInfo?P.getAccessibilityInfo():null;};
m.prototype._getPickerByTypeAndPattern=function(t,i,r){var R=/[DdYyMLWwGQUur]/,s=/[HhKkmsa]/,u=s.test(r),v=R.test(r),w=u&&!v,x=v&&!u,y=v&&u,N,z;switch(t){case h.Time:case h.Date:case h.DateTime:if(w&&i.getMetadata().getName()!=="sap.m.TimePicker"){N=h.Time;}else if(x&&i.getMetadata().getName()!=="sap.m.DatePicker"){N=h.Date;}else if(y&&i.getMetadata().getName()!=="sap.m.DateTimePicker"){N=h.DateTime;}break;default:{throw"Invalid type: "+t+". Expected is one of the sap.m.DateTimeInputType";}}if(N){this.destroyAggregation("_picker");z=n.call(this,N);this.setAggregation("_picker",z);}return z||i;};
m.prototype._getBoundValueTypePattern=function(){var B=this.getBinding("value"),i=B&&B.getType()&&B.getType();if(i instanceof b||i instanceof c||i instanceof d){return i.getOutputPattern();}if(i instanceof O&&i.oFormat){return i.oFormat.oFormatOptions.pattern;}return undefined;};
function _(){return this.getAggregation("_picker");}
m.prototype._isValidDate=function(i){return!i||Object.prototype.toString.call(i)==="[object Date]";};
function o(){if(this._getBoundValueTypePattern()){var P=this._getBoundValueTypePattern();var i=_.call(this);i=this._getPickerByTypeAndPattern(this.getType(),i,P);if(i.getValueFormat()!=P){i.setValueFormat(P);}if(i.getDisplayFormat()!=P){i.setDisplayFormat(P);}}}
function p(E){var v=E.getParameter("value");var i;var r=E.getParameter("valid");this.setProperty("value",v,true);if(r){i=E.oSource.getDateValue();this.setProperty("dateValue",i,true);}this.fireChange({value:v,newValue:v,valid:r,dateValue:i,newDateValue:i});}
return m;});
sap.ui.predefine('sap/m/DateTimeInputRenderer',[],function(){"use strict";var D={apiVersion:2};
D.render=function(r,c){r.openStart("div",c);r.class("sapMDTI");var w=c.getWidth();if(w){r.style("width",w);}r.openEnd();var p=c.getAggregation("_picker");if(p){r.renderControl(p);}r.close("div");};
return D;},true);
sap.ui.predefine('sap/m/DateTimePicker',["sap/ui/thirdparty/jquery",'./InputBase','./DatePicker','sap/ui/model/type/Date','sap/ui/unified/DateRange','./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/LocaleData','./TimePickerClocks','./DateTimePickerRenderer','./SegmentedButton','./SegmentedButtonItem','./ResponsivePopover','./Button',"sap/ui/events/KeyCodes","sap/ui/core/IconPool"],function(q,I,D,a,b,l,C,c,d,L,T,e,S,f,R,B,K,g){"use strict";var P=l.PlacementType,h=l.ButtonType,k="Phone";
var m=D.extend("sap.m.DateTimePicker",{metadata:{library:"sap.m",properties:{minutesStep:{type:"int",group:"Misc",defaultValue:1},secondsStep:{type:"int",group:"Misc",defaultValue:1},showCurrentTimeButton:{type:"boolean",group:"Behavior",defaultValue:false}},designtime:"sap/m/designtime/DateTimePicker.designtime",dnd:{draggable:false,droppable:true}}});
var n={Short:"short",Medium:"medium",Long:"long",Full:"full"};
var o=C.extend("sap.m.internal.DateTimePickerPopup",{
metadata:{library:"sap.m",aggregations:{_switcher:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},calendar:{type:"sap.ui.core.Control",multiple:false},clocks:{type:"sap.ui.core.Control",multiple:false}}},
renderer:{apiVersion:2,render:function(i,j){i.openStart("div",j);i.class("sapMDateTimePopupCont").class("sapMTimePickerDropDown");i.openEnd();var v=j.getAggregation("_switcher");if(v){i.openStart("div");i.class("sapMTimePickerSwitch");i.openEnd();i.renderControl(v);i.close("div");}var w=j.getCalendar();if(w){i.renderControl(w);}i.openStart("div");i.class("sapMTimePickerSep");i.openEnd();i.close("div");var x=j.getClocks();if(x){i.renderControl(x);}i.close("div");}},
init:function(){},
onBeforeRendering:function(){var i=this.getAggregation("_switcher");if(!i){var j=sap.ui.getCore().getLibraryResourceBundle("sap.m");var v=j.getText("DATETIMEPICKER_DATE");var w=j.getText("DATETIMEPICKER_TIME");i=new S(this.getId()+"-Switch",{selectedKey:"Cal",items:[new f(this.getId()+"-Switch-Cal",{key:"Cal",text:v}),new f(this.getId()+"-Switch-Clk",{key:"Clk",text:w})]});i.attachSelect(this._handleSelect,this);this.setAggregation("_switcher",i,true);}if(c.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){i.setVisible(true);i.setSelectedKey("Cal");}else{i.setVisible(false);}},
onAfterRendering:function(){if(c.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){var i=this.getAggregation("_switcher");var j=i.getSelectedKey();this._switchVisibility(j);}},
_handleSelect:function(E){var i=E.getParameter("key");this._switchVisibility(i);if(i==="Clk"){this.getClocks()._focusActiveButton();}},
_switchVisibility:function(i){var j=this.getCalendar(),v=this.getClocks();if(!j||!v){return;}if(i==="Cal"){j.$().css("display","");v.$().css("display","none");j.getFocusDomRef()&&j.getFocusDomRef().focus();}else{j.$().css("display","none");v.$().css("display","");}},
switchToTime:function(){var i=this.getAggregation("_switcher");if(i&&i.getVisible()){i.setSelectedKey("Clk");this._switchVisibility("Clk");}},
getSpecialDates:function(){return this._oDateTimePicker.getSpecialDates();},
onkeydown:function(E){var i=E.keyCode===K.TAB&&!E.shiftKey;var j=E.keyCode===K.TAB&&E.shiftKey;if(i){if(E.target.classList.contains('sapUiCalHeadToday')||(E.target.classList.contains('sapUiCalHeadBLast')&&!this._oDateTimePicker._oCalendar.getShowCurrentDateButton())){this.getAggregation('clocks').getDomRef().children[0].children[0].focus();}}if(j&&E.target.classList.contains('sapUiCalItem')){var v=this.oParent.getAggregation("footer").getAggregation("content").length-1;this.oParent.getAggregation("footer").getAggregation("content")[v].focus();}}
});
m.prototype.init=function(){D.prototype.init.apply(this,arguments);this._bOnlyCalendar=false;};
m.prototype.getIconSrc=function(){return g.getIconURI("date-time");};
m.prototype.exit=function(){D.prototype.exit.apply(this,arguments);if(this._oClocks){this._oClocks.destroy();delete this._oClocks;}this._oPopupContent=undefined;c.media.detachHandler(this._handleWindowResize,this);};
m.prototype.setDisplayFormat=function(i){D.prototype.setDisplayFormat.apply(this,arguments);if(this._oClocks){this._oClocks.setValueFormat(t.call(this));this._oClocks.setDisplayFormat(t.call(this));}return this;};
m.prototype.setMinutesStep=function(M){this.setProperty('minutesStep',M,true);if(this._oClocks){this._oClocks.setMinutesStep(M);}return this;};
m.prototype._getDefaultValueStyle=function(){return n.Medium;};
m.prototype.setMinDate=function(i){D.prototype.setMinDate.call(this,i);if(i){this._oMinDate.setHours(i.getHours(),i.getMinutes(),i.getSeconds());}return this;};
m.prototype.setMaxDate=function(i){D.prototype.setMaxDate.call(this,i);if(i){this._oMaxDate.setHours(i.getHours(),i.getMinutes(),i.getSeconds());}return this;};
m.prototype.setSecondsStep=function(i){this.setProperty('secondsStep',i,true);if(this._oClocks){this._oClocks.setSecondsStep(i);}return this;};
m.prototype.setShowCurrentTimeButton=function(i){var j=this._oClocks;j&&j.setShowCurrentTimeButton(i);return this.setProperty("showCurrentTimeButton",i);};
m.prototype._getFormatInstance=function(A,i){var M=q.extend({},A);var j=-1;if(M.style){j=M.style.indexOf("/");}if(i){var v=q.extend({},M);if(j>0){v.style=v.style.substr(0,j);}this._oDisplayFormatDate=d.getInstance(v);}return d.getDateTimeInstance(M);};
m.prototype._checkStyle=function(v){if(D.prototype._checkStyle.apply(this,arguments)){return true;}else if(v.indexOf("/")>0){var w=[n.Short,n.Medium,n.Long,n.Long];var x=false;for(var i=0;i<w.length;i++){var y=w[i];for(var j=0;j<w.length;j++){var z=w[j];if(v==y+"/"+z){x=true;break;}}if(x){break;}}return x;}return false;};
m.prototype._parseValue=function(v,i){var j=D.prototype._parseValue.apply(this,arguments);if(i&&!j){j=this._oDisplayFormatDate.parse(v);if(j){var O=this.getDateValue();if(!O){O=new Date();}j.setHours(O.getHours());j.setMinutes(O.getMinutes());j.setSeconds(O.getSeconds());j.setMilliseconds(O.getMilliseconds());}}return j;};
m.prototype._getLocaleBasedPattern=function(i){var j=L.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()),v=i.indexOf("/");if(v>0){return j.getCombinedDateTimePattern(i.substr(0,v),i.substr(v+1));}else{return j.getCombinedDateTimePattern(i,i);}};
m.prototype._createPopup=function(){var i,j,v,O,w,x;if(!this._oPopup){v=sap.ui.getCore().getLibraryResourceBundle("sap.m");O=v.getText("TIMEPICKER_SET");w=v.getText("TIMEPICKER_CANCEL");this._oPopupContent=new o(this.getId()+"-PC");this._oPopupContent._oDateTimePicker=this;this._oOKButton=new B(this.getId()+"-OK",{text:O,type:h.Emphasized,press:_.bind(this)});var H=this._getValueStateHeader();this._oPopup=new R(this.getId()+"-RP",{showCloseButton:false,showHeader:false,placement:P.VerticalPreferedBottom,beginButton:this._oOKButton,content:[H,this._oPopupContent],afterOpen:r.bind(this),afterClose:s.bind(this)});H.setPopup(this._oPopup._oControl);if(c.system.phone){i=this.$("inner").attr("aria-labelledby");j=i?document.getElementById(i).getAttribute("aria-label"):"";this._oPopup.setTitle(j);this._oPopup.setShowHeader(true);this._oPopup.setShowCloseButton(true);}else{this._oPopup._getPopup().setDurations(0,0);this._oPopup.setEndButton(new B(this.getId()+"-Cancel",{text:w,press:p.bind(this)}));}this._oPopup.addStyleClass("sapMDateTimePopup");x=this._oPopup.getAggregation("_popup");if(x.setShowArrow){x.setShowArrow(false);}this.setAggregation("_popup",this._oPopup,true);}};
m.prototype._openPopup=function(i){if(!this._oPopup){return;}if(!i){i=this.getDomRef();}this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);var j=this._oPopup.getAggregation("_popup");j.oPopup.setAutoCloseAreas([i]);this._oPopup.openBy(i||this);};
m.prototype._createPopupContent=function(){var N=!this._oCalendar;D.prototype._createPopupContent.apply(this,arguments);if(N){this._oPopupContent.setCalendar(this._oCalendar);this._oCalendar.attachSelect(u,this);}if(!this._oClocks){this._oClocks=new T(this.getId()+"-Clocks",{minutesStep:this.getMinutesStep(),secondsStep:this.getSecondsStep(),valueFormat:t.call(this),displayFormat:t.call(this),localeId:this.getLocaleId(),showCurrentTimeButton:this.getShowCurrentTimeButton()});this._oPopupContent.setClocks(this._oClocks);}};
m.prototype._attachAfterRenderingDelegate=function(){};
m.prototype._selectFocusedDateValue=function(i){var j=this._oCalendar;j.removeAllSelectedDates();j.addSelectedDate(i);return this;};
m.prototype._fillDateRange=function(){var i=this.getDateValue(),j=true;if(i){i=new Date(i.getTime());this._oOKButton.setEnabled(true);}else{j=false;i=this.getInitialFocusedDateValue();if(!i){i=new Date();this._oCalendar.removeAllSelectedDates();}var M=this._oMaxDate.getTime();if(i.getTime()<this._oMinDate.getTime()||i.getTime()>M){i=this._oMinDate;}this._oOKButton.setEnabled(false);}this._oCalendar.focusDate(i);if(j){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=i.getTime()){this._oDateRange.setStartDate(i);}}this._oClocks._setTimeValues(i);};
m.prototype._getSelectedDate=function(){var i=D.prototype._getSelectedDate.apply(this,arguments);if(i){var j=this._oClocks.getTimeValues();var v=this._oClocks._getDisplayFormatPattern();if(v.search("h")>=0||v.search("H")>=0){i.setHours(j.getHours());}if(v.search("m")>=0){i.setMinutes(j.getMinutes());}if(v.search("s")>=0){i.setSeconds(j.getSeconds());}if(i.getTime()<this._oMinDate.getTime()){i=new Date(this._oMinDate.getTime());}else if(i.getTime()>this._oMaxDate.getTime()){i=new Date(this._oMaxDate.getTime());}}return i;};
m.prototype.getLocaleId=function(){return sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();};
m.prototype.getAccessibilityInfo=function(){var i=D.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATETIMEINPUT");return i;};
function _(E){this._handleCalendarSelect();}
function p(E){this.onsaphide(E);if(!this.getDateValue()){this._oCalendar.removeAllSelectedDates();}}
m.prototype._handleWindowResize=function(i){var j=this.getAggregation("_popup").getContent()[1].getAggregation("_switcher"),v=this.getAggregation("_popup").getContent()[1].getCalendar(),w=this.getAggregation("_popup").getContent()[1].getClocks();if(i.name===k){j.setVisible(true);this.getAggregation("_popup").getContent()[1]._switchVisibility(j.getSelectedKey());}else{j.setVisible(false);w.$().css("display","");v.$().css("display","");}};
function r(E){this.$("inner").attr("aria-expanded",true);this._oCalendar.focus();c.media.attachHandler(this._handleWindowResize,this);}
function s(){this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.$("inner").attr("aria-expanded",false);this._oCalendar._closePickers();c.media.detachHandler(this._handleWindowResize,this);}
function t(){var i=this.getDisplayFormat();var j;var v=this.getBinding("value");if(v&&v.oType&&(v.oType instanceof a)){i=v.oType.getOutputPattern();}else if(v&&v.oType&&v.oType.oFormat){i=v.oType.oFormat.oFormatOptions.pattern;}else{i=this.getDisplayFormat();}if(!i){i=n.Medium;}var w=i.indexOf("/");if(w>0&&this._checkStyle(i)){i=i.substr(w+1);}if(i==n.Short||i==n.Medium||i==n.Long||i==n.Full){var x=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var y=L.getInstance(x);j=y.getTimePattern(i);}else{j=i;}return j;}
function u(E){var i={onAfterRendering:function(){this._oPopupContent.getCalendar().getAggregation("month")[0].removeEventDelegate(i,this);this._oOKButton.setEnabled(true);this._oPopupContent.switchToTime();this._oPopupContent.getClocks()._focusActiveButton();}};this._oPopupContent.getCalendar().getAggregation("month")[0].addEventDelegate(i,this);}
return m;});
sap.ui.predefine('sap/m/DateTimePickerRenderer',['sap/ui/core/Renderer','./DatePickerRenderer','./InputBaseRenderer','sap/ui/core/library'],function(R,D,I,c){"use strict";var a=R.extend(D);a.apiVersion=2;
a.getDescribedByAnnouncement=function(d){var b=I.getDescribedByAnnouncement.apply(this,arguments);return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DATETIMEPICKER_TYPE")+" "+b;};
a.getAccessibilityState=function(d){var A=D.getAccessibilityState.apply(this,arguments);A["haspopup"]=c.aria.HasPopup.Dialog.toLowerCase();return A;};
return a;},true);
sap.ui.predefine('sap/m/Dialog',["./Bar","./InstanceManager","./AssociativeOverflowToolbar","./ToolbarSpacer","./Title","./library","sap/m/Image","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/Popup","sap/ui/core/delegate/ScrollEnablement","sap/ui/core/RenderManager","sap/ui/core/InvisibleText","sap/ui/core/ResizeHandler","sap/ui/core/theming/Parameters","sap/ui/core/util/ResponsivePaddingsEnablement","sap/ui/Device","sap/ui/core/library","sap/ui/events/KeyCodes","./TitlePropagationSupport","./DialogRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/Configuration","sap/ui/dom/units/Rem","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable"],function(B,I,A,T,a,l,b,C,c,P,S,R,d,f,g,h,D,j,K,k,m,L,q,n,o,p){"use strict";var O=j.OpenState;var r=l.DialogType;var s=l.DialogRoleType;var V=j.ValueState;var t=j.TitleLevel;var u=l.TitleAlignment;var v=n.getConfiguration().getAnimationMode();var U=v!==o.AnimationMode.none&&v!==o.AnimationMode.minimal;var w=U?300:10;var x=17;var y=p.toPx(1);var H=5;var z=g.get({name:"_sap_m_Dialog_VerticalMargin",callback:function(e){z=parseFloat(e);}});if(z){z=parseFloat(z);}else{z=3;}
var E=C.extend("sap.m.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},type:{type:"sap.m.DialogType",group:"Appearance",defaultValue:r.Standard},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},stretchOnPhone:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},stretch:{type:"boolean",group:"Appearance",defaultValue:false},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},horizontalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},verticalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:false},draggable:{type:"boolean",group:"Behavior",defaultValue:false},escapeHandler:{type:"function",group:"Behavior",defaultValue:null},role:{type:"sap.m.DialogRoleType",group:"Data",defaultValue:s.Dialog,visibility:"hidden"},closeOnNavigation:{type:"boolean",group:"Behavior",defaultValue:true},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:u.Auto}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},subHeader:{type:"sap.m.IBar",multiple:false},customHeader:{type:"sap.m.IBar",multiple:false},beginButton:{type:"sap.m.Button",multiple:false},endButton:{type:"sap.m.Button",multiple:false},buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_toolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_valueState:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}}},designtime:"sap/m/designtime/Dialog.designtime"}});
h.call(E.prototype,{header:{suffix:"header"},subHeader:{selector:".sapMDialogSubHeader .sapMIBar"},content:{selector:".sapMDialogScrollCont"},footer:{suffix:"footer"}});k.call(E.prototype,"content",function(){return this._headerTitle?this._headerTitle.getId():false;});E._bPaddingByDefault=(n.getConfiguration().getCompatibilityVersion("sapMDialogWithPadding").compareTo("1.16")<0);
E._initIcons=function(){if(E._mIcons){return;}E._mIcons={};E._mIcons[V.Success]=c.getIconURI("sys-enter-2");E._mIcons[V.Warning]=c.getIconURI("alert");E._mIcons[V.Error]=c.getIconURI("error");E._mIcons[V.Information]=c.getIconURI("information");};
E.prototype.init=function(){var e=this;this._oManuallySetSize=null;this._oManuallySetPosition=null;this._bRTL=n.getConfiguration().getRTL();this._scrollContentList=["sap.m.NavContainer","sap.m.Page","sap.m.ScrollContainer","sap.m.SplitContainer","sap.m.MultiInput","sap.m.SimpleFixFlex"];this.oPopup=new P();this.oPopup.setShadow(true);this.oPopup.setNavigationMode("SCOPE");this.oPopup.setModal(true);this.oPopup.setAnimations(q.proxy(this._openAnimation,this),q.proxy(this._closeAnimation,this));this.oPopup._applyPosition=function(i,G){e._setDimensions();e._adjustScrollingPane();if(e._oManuallySetPosition){i.at={left:e._oManuallySetPosition.x,top:e._oManuallySetPosition.y};}else{i.at=e._calcPosition();}e._deregisterContentResizeHandler();P.prototype._applyPosition.call(this,i);e._registerContentResizeHandler();};if(E._bPaddingByDefault){this.addStyleClass("sapUiPopupWithPadding");}this._initTitlePropagationSupport();this._initResponsivePaddingsEnablement();};
E.prototype.onBeforeRendering=function(){var e=this._getAnyHeader();if(!E._bPaddingByDefault&&this.hasStyleClass("sapUiPopupWithPadding")){L.warning("Usage of CSS class 'sapUiPopupWithPadding' is deprecated. Use 'sapUiContentPadding' instead",null,"sap.m.Dialog");}if(this._hasSingleScrollableContent()){this.setVerticalScrolling(false);this.setHorizontalScrolling(false);L.info("VerticalScrolling and horizontalScrolling in sap.m.Dialog with ID "+this.getId()+" has been disabled because there's scrollable content inside");}else if(!this._oScroller){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:this.getHorizontalScrolling(),vertical:this.getVerticalScrolling()});}if(this._oScroller){this._oScroller.setVertical(this.getVerticalScrolling());this._oScroller.setHorizontal(this.getHorizontalScrolling());}this._createToolbarButtons();if(n.getConfiguration().getAccessibility()&&this.getState()!=V.None){var i=new d({text:this.getValueStateString(this.getState())});this.setAggregation("_valueState",i);this.addAriaLabelledBy(i.getId());}if(e&&e.setTitleAlignment){e.setProperty("titleAlignment",this.getTitleAlignment(),true);}if(e&&this._getTitles(e).length===0){e._setRootAccessibilityRole("heading");e._setRootAriaLevel("2");}};
E.prototype.onAfterRendering=function(){this._$scrollPane=this.$("scroll");this._$content=this.$("cont");this._$dialog=this.$();if(this.isOpen()){this._setInitialFocus();}};
E.prototype.exit=function(){I.removeDialogInstance(this);this._deregisterContentResizeHandler();this._deregisterResizeHandler();if(this.oPopup){this.oPopup.detachOpened(this._handleOpened,this);this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._header){this._header.destroy();this._header=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._toolbarSpacer){this._toolbarSpacer.destroy();this._toolbarSpacer=null;}};
E.prototype.open=function(){var e=this.oPopup;e.setInitialFocusId(this.getId());var i=e.getOpenState();switch(i){case O.OPEN:case O.OPENING:return this;case O.CLOSING:this._bOpenAfterClose=true;break;default:}this._oCloseTrigger=null;this.fireBeforeOpen();e.attachOpened(this._handleOpened,this);this._iLastWidthAndHeightWithScroll=null;e.setContent(this);e.open();this._registerResizeHandler();I.addDialogInstance(this);return this;};
E.prototype.close=function(){this._bOpenAfterClose=false;this.$().removeClass('sapDialogDisableTransition');this._deregisterResizeHandler();var e=this.oPopup;var i=this.oPopup.getOpenState();if(!(i===O.CLOSED||i===O.CLOSING)){l.closeKeyboard();this.fireBeforeClose({origin:this._oCloseTrigger});e.attachClosed(this._handleClosed,this);this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;e.close();this._deregisterContentResizeHandler();}return this;};
E.prototype.isOpen=function(){return!!this.oPopup&&this.oPopup.isOpen();};
E.prototype.setIcon=function(i){this._bHasCustomIcon=true;return this.setProperty("icon",i);};
E.prototype.setState=function(e){var i;this.setProperty("state",e);if(this._bHasCustomIcon){return this;}if(e===V.None){i="";}else{E._initIcons();i=E._mIcons[e];}this.setProperty("icon",i);return this;};
E.prototype._handleOpened=function(){this.oPopup.detachOpened(this._handleOpened,this);this._setInitialFocus();this.fireAfterOpen();};
E.prototype._handleClosed=function(){if(!this.oPopup){return;}this.oPopup.detachClosed(this._handleClosed,this);if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}I.removeDialogInstance(this);this.fireAfterClose({origin:this._oCloseTrigger});if(this._bOpenAfterClose){this._bOpenAfterClose=false;this.open();}};
E.prototype.onfocusin=function(e){var i=e.target;if(i.id===this.getId()+"-firstfe"){var G=this.$("footer").lastFocusableDomRef()||this.$("cont").lastFocusableDomRef()||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||(this._getAnyHeader()&&this._getAnyHeader().$().lastFocusableDomRef());if(G){G.focus();}}else if(i.id===this.getId()+"-lastfe"){var J=this._getFocusableHeader()||(this._getAnyHeader()&&this._getAnyHeader().$().firstFocusableDomRef())||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||this.$("cont").firstFocusableDomRef()||this.$("footer").firstFocusableDomRef();if(J){J.focus();}}};
E.prototype._getPromiseWrapper=function(){var e=this;return{reject:function(){e.currentPromise.reject();},resolve:function(){e.currentPromise.resolve();}};};
E.prototype.onsapescape=function(e){var i=this.getEscapeHandler(),G={},J=this;if(this._isSpaceOrEnterPressed){return;}if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return;}this._oCloseTrigger=null;if(typeof i==='function'){new Promise(function(M,N){G.resolve=M;G.reject=N;J.currentPromise=G;i(J._getPromiseWrapper());}).then(function(M){J.close();}).catch(function(){L.info("Disallow dialog closing");});}else{this.close();}e.stopPropagation();};
E.prototype.onkeyup=function(e){if(this._isSpaceOrEnter(e)){this._isSpaceOrEnterPressed=false;}};
E.prototype.onkeydown=function(e){if(this._isSpaceOrEnter(e)){this._isSpaceOrEnterPressed=true;}this._handleKeyboardDragResize(e);};
E.prototype._handleKeyboardDragResize=function(e){if(e.target!==this._getFocusableHeader()||[K.ARROW_LEFT,K.ARROW_RIGHT,K.ARROW_UP,K.ARROW_DOWN].indexOf(e.keyCode)===-1){return;}if((!this.getResizable()&&e.shiftKey)||(!this.getDraggable()&&!e.shiftKey)){return;}var $=this._$dialog,i=this.getDomRef().getBoundingClientRect(),G={left:i.x,top:i.y},J=this._getAreaDimensions(),M=$.width(),N=$.height(),Q=$.outerHeight(true),W=e.shiftKey,X,Y;this._bDisableRepositioning=true;$.addClass('sapDialogDisableTransition');if(W){this._oManuallySetSize=true;this.$('cont').height('').width('');}switch(e.keyCode){case K.ARROW_LEFT:if(W){M-=y;}else{G.left-=y;}break;case K.ARROW_RIGHT:if(W){M+=y;}else{G.left+=y;}break;case K.ARROW_UP:if(W){N-=y;}else{G.top-=y;}break;case K.ARROW_DOWN:if(W){N+=y;}else{G.top+=y;}break;}if(W){Y=J.bottom-G.top-Q+N;if(e.keyCode===K.ARROW_DOWN){Y-=y;}X={width:Math.min(M,J.right-G.left),height:Math.min(N,Y)};}else{X={left:Math.min(Math.max(J.left,G.left),J.right-M),top:Math.min(Math.max(J.top,G.top),J.bottom-Q)};}$.css(X);};
E.prototype._isSpaceOrEnter=function(e){var i=e.which||e.keyCode;return i==K.SPACE||i==K.ENTER;};
E.prototype._openAnimation=function($,i,e){$.addClass("sapMDialogOpen");setTimeout(e,w);};
E.prototype._closeAnimation=function($,i,e){$.removeClass("sapMDialogOpen");setTimeout(e,w);};
E.prototype._setDimensions=function(){var $=this.$(),e=this.getStretch(),i=this.getStretchOnPhone()&&D.system.phone,M=this.getType()===r.Message,G={};if(!e){if(!this._oManuallySetSize){G.width=this.getContentWidth()||undefined;G.height=this.getContentHeight()||undefined;}else{G.width=this._oManuallySetSize.width;G.height=this._oManuallySetSize.height;}}if(G.width=='auto'){G.width=undefined;}if(G.height=='auto'){G.height=undefined;}if((e&&!M)||(i)){this.$().addClass('sapMDialogStretched');}$.css(G);if(!this._oManuallySetSize&&!this._bDisableRepositioning){this._positionDialog();}if(window.navigator.userAgent.toLowerCase().indexOf("chrome")!==-1&&this.getStretch()){$.find('> footer').css({bottom:'0.001px'});}};
E.prototype._adjustScrollingPane=function(){if(this._oScroller){this._oScroller.refresh();}};
E.prototype._onResize=function(){var $=this.$(),e=this.$('cont'),i=this.getContentWidth(),M=this._calcMaxSizes().maxWidth;if(this._oManuallySetSize){e.css({width:'auto'});return;}if(D.system.desktop&&!D.browser.chrome){var G=e.width()+"x"+e.height(),J=$.css("min-width")!==$.css("width");if(G!==this._iLastWidthAndHeightWithScroll&&J){if(this._hasVerticalScrollbar()&&(!i||i=='auto')&&!this.getStretch()&&e.width()<M){$.addClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":x});this._iLastWidthAndHeightWithScroll=G;}else{$.removeClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":""});this._iLastWidthAndHeightWithScroll=null;}}}if(!this._oManuallySetSize&&!this._bDisableRepositioning){this._positionDialog();}};
E.prototype._hasVerticalScrollbar=function(){var $=this.$('cont');return $[0].clientHeight<$[0].scrollHeight;};
E.prototype._positionDialog=function(){var $=this.$();$.css(this._calcMaxSizes());$.css(this._calcPosition());};
E.prototype._calcPosition=function(){var e=this._getAreaDimensions(),$=this.$(),i,G,J;if(D.system.phone&&this.getStretch()){i=0;G=0;}else if(this.getStretch()){i=this._percentOfSize(e.width,H);G=this._percentOfSize(e.height,z);}else{i=(e.width-$.outerWidth())/2;G=(e.height-$.outerHeight())/2;}J={top:Math.round(e.top+G)};J[this._bRTL?"right":"left"]=Math.round(e.left+i);return J;};
E.prototype._calcMaxSizes=function(){var e=this._getAreaDimensions(),$=this.$(),i=$.find(".sapMDialogTitle").height()||0,G=$.find(".sapMDialogSubHeader").height()||0,J=$.find("footer").height()||0,M=i+G+J,N,Q;if(D.system.phone&&this.getStretch()){Q=e.width;N=e.height-M;}else{Q=this._percentOfSize(e.width,100-2*H);N=this._percentOfSize(e.height,100-2*z)-M;}if(N<parseInt($.css("min-height"))){L.error("Height of Within Area is not enough to fit dialog");}if(Q<parseInt($.css("min-width"))){L.error("Width of Within Area is not enough to fit dialog");}return{maxWidth:Math.floor(Q),maxHeight:Math.floor(N)};};
E.prototype._getAreaDimensions=function(){var W=P.getWithinAreaDomRef(),e;if(W===window){e={left:0,top:0,width:W.innerWidth,height:W.innerHeight};}else{var i=W.getBoundingClientRect(),$=q(W);e={left:i.left+parseFloat($.css("border-left-width")),top:i.top+parseFloat($.css("border-top-width")),width:W.clientWidth,height:W.clientHeight};}e.right=e.left+e.width;e.bottom=e.top+e.height;return e;};
E.prototype._percentOfSize=function(i,e){return Math.round(i*e/100);};
E.prototype._createHeader=function(){if(!this._header){this._header=new B(this.getId()+"-header",{titleAlignment:this.getTitleAlignment()});this.setAggregation("_header",this._header);}};
E.prototype._applyTitleToHeader=function(){var e=this.getProperty("title");if(this._headerTitle){this._headerTitle.setText(e);}else{this._headerTitle=new a(this.getId()+"-title",{text:e,level:t.H2}).addStyleClass("sapMDialogTitle");this._header.addContentMiddle(this._headerTitle);}};
E.prototype._hasSingleScrollableContent=function(){var e=this.getContent();while(e.length===1&&e[0]instanceof C&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent();}if(e.length===1&&e[0]instanceof C&&e[0].isA(this._scrollContentList)){return true;}return false;};
E.prototype._getFocusDomRef=function(){var i=this.getInitialFocus();if(i){return document.getElementById(i);}return this._getFocusableHeader()||this._getFirstFocusableContentSubHeader()||this._getFirstFocusableContentElement()||this._getFirstVisibleButtonDomRef()||this.getDomRef();};
E.prototype._getFirstVisibleButtonDomRef=function(){var e=this.getBeginButton(),G=this.getEndButton(),J=this.getButtons(),M;if(e&&e.getVisible()){M=e.getDomRef();}else if(G&&G.getVisible()){M=G.getDomRef();}else if(J&&J.length>0){for(var i=0;i<J.length;i++){if(J[i].getVisible()){M=J[i].getDomRef();break;}}}return M;};
E.prototype._getFocusableHeader=function(){if(!this._isDraggableOrResizable()){return null;}return this.$().find('header.sapMDialogTitle')[0];};
E.prototype._getFirstFocusableContentSubHeader=function(){var $=this.$().find('.sapMDialogSubHeader');return $.firstFocusableDomRef();};
E.prototype._getFirstFocusableContentElement=function(){var $=this.$("cont");return $.firstFocusableDomRef();};
E.prototype._setInitialFocus=function(){var e=this._getFocusDomRef(),i;if(e&&e.id){i=n.byId(e.id);}if(i){if(i.getVisible&&!i.getVisible()){this.focus();return;}e=i.getFocusDomRef();}if(!e){this.setInitialFocus("");e=this._getFocusDomRef();}if(!this.getInitialFocus()){this.setAssociation('initialFocus',e?e.id:this.getId(),true);}if(D.system.desktop||(e&&!/input|textarea|select/i.test(e.tagName))){if(e){e.focus();}}else{this.focus();}};
E.prototype.getScrollDelegate=function(){return this._oScroller;};
E.prototype._isToolbarEmpty=function(){var e=this._oToolbar.getContent().filter(function(i){return i.getMetadata().getName()!=='sap.m.ToolbarSpacer';});return e.length===0;};
E.prototype._getAnyHeader=function(){var e=this.getCustomHeader();if(e){return e;}else{var i=this.getShowHeader();if(!i){return null;}this._createHeader();this._applyTitleToHeader();this._applyIconToHeader();return this._header;}};
E.prototype._deregisterResizeHandler=function(){var W=P.getWithinAreaDomRef();if(W===window){D.resize.detachHandler(this._onResize,this);}else{f.deregister(this._withinResizeListenerId);this._withinResizeListenerId=null;}};
E.prototype._registerResizeHandler=function(){var W=P.getWithinAreaDomRef();if(W===window){D.resize.attachHandler(this._onResize,this);}else{this._withinResizeListenerId=f.register(W,this._onResize.bind(this));}this._onResize();};
E.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){f.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null;}};
E.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=f.register(this.getDomRef("scrollCont"),q.proxy(this._onResize,this));}this._onResize();};
E.prototype._attachHandler=function(e){var i=this;if(!this._oButtonDelegate){this._oButtonDelegate={ontap:function(){i._oCloseTrigger=this;},onkeyup:function(){i._oCloseTrigger=this;},onkeydown:function(){i._oCloseTrigger=this;}};}if(e){e.addDelegate(this._oButtonDelegate,true,e);}};
E.prototype._createToolbarButtons=function(){var e=this._getToolbar();var i=this.getButtons();var G=this.getBeginButton();var J=this.getEndButton(),M=this,N=[G,J];N.forEach(function(Q){if(Q&&M._oButtonDelegate){Q.removeDelegate(M._oButtonDelegate);}});e.removeAllContent();if(!("_toolbarSpacer"in this)){this._toolbarSpacer=new T();}e.addContent(this._toolbarSpacer);N.forEach(function(Q){M._attachHandler(Q);});if(i&&i.length){i.forEach(function(Q){e.addContent(Q);});}else{if(G){e.addContent(G);}if(J){e.addContent(J);}}};
E.prototype._getToolbar=function(){if(!this._oToolbar){this._oToolbar=new A(this.getId()+"-footer").addStyleClass("sapMTBNoBorders");this._oToolbar.addDelegate({onAfterRendering:function(){if(this.getType()===r.Message){this.$("footer").removeClass("sapContrast sapContrastPlus");}}},false,this);this.setAggregation("_toolbar",this._oToolbar);}return this._oToolbar;};
E.prototype.getValueStateString=function(e){var i=n.getLibraryResourceBundle("sap.m");switch(e){case(V.Success):return i.getText("LIST_ITEM_STATE_SUCCESS");case(V.Warning):return i.getText("LIST_ITEM_STATE_WARNING");case(V.Error):return i.getText("LIST_ITEM_STATE_ERROR");case(V.Information):return i.getText("LIST_ITEM_STATE_INFORMATION");default:return"";}};
E.prototype._isDraggableOrResizable=function(){return!this.getStretch()&&(this.getDraggable()||this.getResizable());};
E.prototype.setSubHeader=function(e){this.setAggregation("subHeader",e);if(e){e.setVisible=function(i){e.setProperty("visible",i);this.invalidate();}.bind(this);}return this;};
E.prototype.setLeftButton=function(e){if(typeof e==="string"){e=n.byId(e);}this.setBeginButton(e);return this.setAssociation("leftButton",e);};
E.prototype.setRightButton=function(e){if(typeof e==="string"){e=n.byId(e);}this.setEndButton(e);return this.setAssociation("rightButton",e);};
E.prototype.getLeftButton=function(){var e=this.getBeginButton();return e?e.getId():null;};
E.prototype.getRightButton=function(){var e=this.getEndButton();return e?e.getId():null;};
E.prototype.setBeginButton=function(e){if(e&&e.isA("sap.m.Button")){e.addStyleClass("sapMDialogBeginButton");}return this.setAggregation("beginButton",e);};
E.prototype.setEndButton=function(e){if(e&&e.isA("sap.m.Button")){e.addStyleClass("sapMDialogEndButton");}return this.setAggregation("endButton",e);};
E.prototype.getAggregation=function(e,i,G){var J=C.prototype.getAggregation.apply(this,Array.prototype.slice.call(arguments,0,2));if(e==='buttons'&&J&&J.length===0){this.getBeginButton()&&J.push(this.getBeginButton());this.getEndButton()&&J.push(this.getEndButton());}return J;};
E.prototype.getAriaLabelledBy=function(){var e=this._getAnyHeader(),i=this.getAssociation("ariaLabelledBy",[]).slice();var G=this.getSubHeader();if(G){var J=this._getTitles(G);if(J.length){i=J.map(function(N){return N.getId();}).concat(i);}}if(e){var M=this._getTitles(e);if(M.length){i=M.map(function(N){return N.getId();}).concat(i);}else{i.unshift(e.getId());}}return i;};
E.prototype._applyIconToHeader=function(){var i=this.getIcon();if(!i){if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}return;}if(!this._iconImage){this._iconImage=c.createControlByURI({id:this.getId()+"-icon",src:i,useIconTooltip:false},b).addStyleClass("sapMDialogIcon");this._header.insertAggregation("contentMiddle",this._iconImage,0);}this._iconImage.setSrc(i);};
E.prototype.setInitialFocus=function(i){return this.setAssociation("initialFocus",i,true);};
E.prototype.invalidate=function(e){if(this.isOpen()){C.prototype.invalidate.call(this,e);}};
function F(e){var $=q(e);var i=$.control(0);if($.parents('.sapMDialogSection').length){return false;}if(!i||i.getMetadata().getInterfaces().indexOf("sap.m.IBar")>-1){return true;}return $.hasClass('sapMDialogTitle');}
if(D.system.desktop){E.prototype.ondblclick=function(e){if(F(e.target)){var $=this.$('cont');this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;this.oPopup&&this.oPopup._applyPosition(this.oPopup._oLastPosition,true);$.css({height:'100%'});}};E.prototype.onmousedown=function(e){if(e.which===3){return;}if(!this._isDraggableOrResizable()){return;}var i;var G=this;var $=q(document);var J=q(e.target);var M=J.hasClass('sapMDialogResizeHandler')&&this.getResizable();var N=function(e1){i=i?clearTimeout(i):setTimeout(function(){e1();},0);};var Q=this._getAreaDimensions();var W=this.getDomRef().getBoundingClientRect();var X={x:e.clientX,y:e.clientY,width:G._$dialog.width(),height:G._$dialog.height(),outerHeight:G._$dialog.outerHeight(),position:{x:W.x,y:W.y}};var Y;function Z(){var e1=G.$(),f1=G.$('cont'),g1,h1;$.off("mouseup",Z);$.off("mousemove",Y);if(M){G._$dialog.removeClass('sapMDialogResizing');g1=parseInt(e1.height());h1=parseInt(e1.css("border-top-width"))+parseInt(e1.css("border-bottom-width"));f1.height(g1+h1);}}if(F(e.target)&&this.getDraggable()||M){G._bDisableRepositioning=true;G._$dialog.addClass('sapDialogDisableTransition');}if(F(e.target)&&this.getDraggable()){Y=function(e1){e1.preventDefault();if(e1.buttons===0){Z();return;}N(function(){G._bDisableRepositioning=true;G._oManuallySetPosition={x:Math.max(Q.left,Math.min(e1.clientX-e.clientX+X.position.x,Q.right-X.width)),y:Math.max(Q.top,Math.min(e1.clientY-e.clientY+X.position.y,Q.bottom-X.outerHeight))};G._$dialog.css({top:G._oManuallySetPosition.y,left:G._oManuallySetPosition.x,right:G._bRTL?"":undefined});});};}else if(M){G._$dialog.addClass('sapMDialogResizing');var _={};var a1=parseInt(G._$dialog.css('min-width'));var b1=X.x+X.width-a1;var c1=J.width()-e.offsetX;var d1=J.height()-e.offsetY;Y=function(e1){N(function(){G._bDisableRepositioning=true;G.$('cont').height('').width('');if(e1.clientY+d1>Q.bottom){e1.clientY=Q.bottom-d1;}if(e1.clientX+c1>Q.right){e1.clientX=Q.right-c1;}G._oManuallySetSize={width:X.width+e1.clientX-X.x,height:X.height+e1.clientY-X.y};if(G._bRTL){_.left=Math.min(Math.max(e1.clientX,0),b1);G._oManuallySetSize.width=X.width+X.x-Math.max(e1.clientX,0);}_.width=G._oManuallySetSize.width;_.height=G._oManuallySetSize.height;G._$dialog.css(_);});};}else{return;}$.on("mousemove",Y);$.on("mouseup",Z);e.stopPropagation();};}
E.prototype._applyContextualSettings=function(){C.prototype._applyContextualSettings.call(this);};
E.prototype._getTitles=function(e){return e.findAggregatedObjects(true,function(i){return i.isA("sap.m.Title");});};
return E;});
sap.ui.predefine('sap/m/DialogRenderer',["sap/m/library","sap/ui/Device","sap/ui/core/library"],function(l,D,c){"use strict";var a=l.DialogType;var b=l.DialogRoleType;var V=c.ValueState;var d={apiVersion:2};d._mStateClasses={};d._mStateClasses[V.None]="";d._mStateClasses[V.Success]="sapMDialogSuccess";d._mStateClasses[V.Warning]="sapMDialogWarning";d._mStateClasses[V.Error]="sapMDialogError";d._mStateClasses[V.Information]="sapMDialogInformation";
d.render=function(r,o){var i=o.getId(),h=o._getAnyHeader(),s=o.getSubHeader(),B=o.getBeginButton(),e=o.getEndButton(),S=o.getState(),f=o.getStretch(),g=o.getStretchOnPhone()&&D.system.phone,v=o.getAggregation("_valueState");r.openStart("div",o).style("width",o.getContentWidth()).style("height",o.getContentHeight()).class("sapMDialog").class("sapMDialog-CTX").class("sapMPopup-CTX");if(o.isOpen()){r.class("sapMDialogOpen");}if(window.devicePixelRatio>1){r.class("sapMDialogHighPixelDensity");}if(o._bDisableRepositioning){r.class("sapMDialogTouched");}if(f||g){r.class("sapMDialogStretched");}r.class(d._mStateClasses[S]);var n=!o._oToolbar&&!B&&!e;var E=o._oToolbar&&o._isToolbarEmpty()&&!B&&!e;var H=o._oToolbar&&!o._oToolbar.getVisible();if(n||E||H){r.class("sapMDialog-NoFooter");}if(!h){r.class("sapMDialog-NoHeader");}var R=o.getProperty("role");if(S===V.Error||S===V.Warning){R=b.AlertDialog;}r.accessibilityState(o,{role:R,modal:true});if(s&&s.getVisible()){r.class("sapMDialogWithSubHeader");if(s.getDesign()==l.ToolbarDesign.Info){r.class("sapMDialogSubHeaderInfoBar");}}if(o.getType()===a.Message){r.class("sapMMessageDialog");}if(!o.getVerticalScrolling()){r.class("sapMDialogVerScrollDisabled");}if(!o.getHorizontalScrolling()){r.class("sapMDialogHorScrollDisabled");}if(D.system.phone){r.class("sapMDialogPhone");}if(o.getDraggable()&&!f){r.class("sapMDialogDraggable");}if(l._bSizeCompact){r.class("sapUiSizeCompact");}var t=o.getTooltip_AsString();if(t){r.attr("title",t);}r.attr("tabindex","-1");r.openEnd();if(D.system.desktop){if(o.getResizable()&&!f){r.icon("sap-icon://resize-corner",["sapMDialogResizeHandler"],{"title":""});}r.openStart("span",i+"-firstfe").class("sapMDialogFirstFE").attr("tabindex","0").openEnd().close("span");}if(h){h._applyContextClassFor("header");r.openStart("header").class("sapMDialogTitle");if(o._isDraggableOrResizable()){r.attr("tabindex",0);}r.openEnd().renderControl(h).close("header");}if(s&&s.getVisible()){s._applyContextClassFor("subheader");r.openStart("header").class("sapMDialogSubHeader").openEnd().renderControl(s).close("header");}if(v){r.renderControl(v);}r.openStart("section",i+"-cont").class("sapMDialogSection").openEnd();r.openStart("div",i+"-scroll").class("sapMDialogScroll").openEnd();r.openStart("div",i+"-scrollCont").class("sapMDialogScrollCont");if(o.getStretch()||o.getContentHeight()){r.class("sapMDialogStretchContent");}r.openEnd();o.getContent().forEach(r.renderControl,r);r.close("div").close("div").close("section");if(!n&&!E&&!H){o._oToolbar._applyContextClassFor("footer");r.openStart("footer").class("sapMDialogFooter").openEnd().renderControl(o._oToolbar).close("footer");}if(D.system.desktop){r.openStart("span",i+"-lastfe").class("sapMDialogLastFE").attr("tabindex","0").openEnd().close("span");}r.close("div");};
return d;},true);
sap.ui.predefine('sap/m/DisplayListItem',["sap/ui/core/library","./library","./ListItemBase","./DisplayListItemRenderer"],function(c,l,L,D){"use strict";var T=c.TextDirection;
var a=L.extend("sap.m.DisplayListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null},valueTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}}}});
a.prototype.getContentAnnouncement=function(){return this.getLabel()+" "+this.getValue();};
return a;});
sap.ui.predefine('sap/m/DisplayListItemRenderer',["sap/ui/core/library","sap/ui/core/Renderer","./ListItemBaseRenderer"],function(c,R,L){"use strict";var T=c.TextDirection;var D=R.extend(L);D.apiVersion=2;
D.renderLIAttributes=function(r,l){r.class("sapMDLI");};
D.renderLIContent=function(r,l){var s=l.getLabel();if(s){r.openStart("label");r.attr("for",l.getId()+"-value");r.class("sapMDLILabel");r.openEnd();r.text(s);r.close("label");}var v=l.getValue();if(v){r.openStart("div",l.getId()+"-value");r.class("sapMDLIValue");var V=l.getValueTextDirection();if(V!=T.Inherit){r.attr("dir",V.toLowerCase());}r.openEnd();r.text(v);r.close("div");}};
return D;},true);
sap.ui.predefine('sap/m/DraftIndicator',["sap/ui/core/Control","sap/m/Label","sap/m/library","./DraftIndicatorRenderer"],function(C,L,l,D){"use strict";var a=l.DraftIndicatorState;
var b=C.extend("sap.m.DraftIndicator",{metadata:{library:"sap.m",designtime:"sap/m/designtime/DraftIndicator.designtime",properties:{state:{type:"sap.m.DraftIndicatorState",group:"Behavior",defaultValue:a.Clear},minDisplayTime:{type:"int",group:"Behavior",defaultValue:1500}},aggregations:{_label:{type:"sap.m.Label",multiple:false,visibility:"hidden"}}}});
var B=sap.ui.getCore().getLibraryResourceBundle("sap.m");b._oTEXTS={};b._oTEXTS[a.Saving]=B.getText("DRAFT_INDICATOR_SAVING_DRAFT");b._oTEXTS[a.Saved]=B.getText("DRAFT_INDICATOR_DRAFT_SAVED");b._oTEXTS[a.Clear]="";
b.prototype.init=function(){this.aQueue=[];this.iDelayedCallId=null;};
b.prototype.exit=function(){this._resetDraftTimer();};
b.prototype.setState=function(s){this.setProperty("state",s);this._addToQueue(s);if(s===a.Saving){this._addToQueue(a.Clear);}return this;};
b.prototype._getLabel=function(){var c=this.getAggregation('_label');if(!c){var c=new L({id:this.getId()+"-label"});this.setAggregation('_label',c,true);c=this.getAggregation('_label');}return c;};
b.prototype.showDraftSaving=function(){this._addToQueue(a.Saving);this._addToQueue(a.Clear);};
b.prototype.showDraftSaved=function(){this._addToQueue(a.Saved);};
b.prototype.clearDraftState=function(){this._addToQueue(a.Clear);};
b.prototype._addToQueue=function(s){this.aQueue.push(s);this._processQueue();};
b.prototype._processQueue=function(){if(this.iDelayedCallId){return;}var n=this.aQueue.shift();var t=this.getMinDisplayTime();if(!n){return;}this._applyState(n);if(n===a.Clear){this._proceed();return;}this.iDelayedCallId=setTimeout(this._proceed.bind(this),t);};
b.prototype._proceed=function(){this._resetDraftTimer();this._processQueue();};
b.prototype._applyState=function(s){this._getLabel().setText(b._oTEXTS[s]);};
b.prototype._resetDraftTimer=function(){clearTimeout(this.iDelayedCallId);this.iDelayedCallId=null;};
return b;});
sap.ui.predefine('sap/m/DraftIndicatorRenderer',[],function(){"use strict";var D={apiVersion:2};
D.render=function(r,c){r.openStart("div",c);r.class("sapMDraftIndicator");r.openEnd();var l=c._getLabel();r.renderControl(l);r.close("div");};
return D;},true);
sap.ui.predefine('sap/m/DynamicDate',['sap/m/DynamicDateUtil','sap/ui/model/SimpleType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/base/util/each'],function(D,S,F,P,V,e){"use strict";
var a=S.extend("sap.m.DynamicDate",{constructor:function(){this.sName="DynamicDate";S.apply(this,arguments);}});
a.prototype.formatValue=function(v){var r={};if(!v){return;}r.operator=v.operator;r.values=v.values.slice(0);var b=D.getOption(v.operator).getValueTypes();r.values=r.values.map(function(v,i){if(b[i]==="date"){return t.parse(v);}return v;},this);return r;};
a.prototype.parseValue=function(v){var r={},b;if(!v){return;}if(v.operator==="PARSEERROR"){throw new P(v.values[0]);}r.operator=v.operator;r.values=v.values.slice(0);b=D.getOption(v.operator).getValueTypes();r.values=r.values.map(function(v,i){if(b[i]==="date"){return t.format(v);}return v;},this);return r;};
a.prototype.validateValue=function(v){if(this.oConstraints){var b=sap.ui.getCore().getLibraryResourceBundle(),m=sap.ui.getCore().getLibraryResourceBundle("sap.m"),c=[],M=[],o=D.getOption(v.operator),d=o.toDates(this.formatValue(v)).map(function(u){return u.getTime();});if(d[0]===d[1]){d.length=1;}d.forEach(function(T,i){var E="DynamicDate.Invalid"+(i===0?"Start":"End");e(this.oConstraints,function(C,f){switch(C){case"minimum":if(T<f){c.push("minimum");M.push(m.getText(E,[new Date(T).toDateString()]));M.push(b.getText("Date.Minimum",[new Date(f).toDateString()]));}break;case"maximum":if(T>f){c.push("maximum");M.push(m.getText(E,[new Date(T).toDateString()]));M.push(b.getText("Date.Maximum",[new Date(f).toDateString()]));}break;}});},this);if(c.length>0){throw new V(this.combineMessages(M),c);}}};
var t={format:function(v){if(v instanceof Date){return v.getTime();}return null;},parse:function(v){if(isNaN(v)){throw new F("Cannot format date: "+v+" is not a valid Timestamp");}else if(typeof(v)!=="number"){v=parseInt(v);}v=new Date(v);return v;}};return a;});
sap.ui.predefine('sap/m/DynamicDateFormat',['sap/ui/core/format/DateFormat','sap/ui/core/format/NumberFormat','sap/ui/core/Locale','sap/ui/core/LocaleData',"sap/base/Log","sap/base/util/deepExtend","sap/base/util/isEmptyObject","sap/ui/core/date/UniversalDateUtils","./library"],function(D,N,L,a,b,d,c,U,l){"use strict";var e=function(){throw new Error();};var _=sap.ui.getCore().getLibraryResourceBundle("sap.m");var g={};var h={};var p={"DATE":["date"],"DATERANGE":["date","date"],"LASTDAYS":["int"],"LASTWEEKS":["int"],"LASTMONTHS":["int"],"LASTQUARTERS":["int"],"LASTYEARS":["int"],"NEXTDAYS":["int"],"NEXTWEEKS":["int"],"NEXTMONTHS":["int"],"NEXTQUARTERS":["int"],"NEXTYEARS":["int"],"FROM":["date"],"TO":["date"],"SPECIFICMONTH":["month"],"TODAYFROMTO":["int","int"]};var s=Object.keys(l.StandardDynamicDateRangeKeys);for(var i=0;i<s.length;i++){var k=s[i];var P=_.getText("DYNAMIC_DATE_"+k.toUpperCase()+"_FORMAT");var S=P.split('{').map(function(f){var C=f.indexOf('}');if(C!==-1){return f.slice(C+1);}return f;});g[k]=S;var m=[];var n=P.indexOf('{');var o=-1;var q=-1;while(n!==-1){o=P.indexOf('}');q=parseInt(P.slice(n+1,o-o-1));m.push(q);P=P.slice(o+1);n=P.indexOf('{');}h[k]=m;}
e.getInstance=function(f,j){return this.createInstance(f,j);};
e.oDefaultDynamicDateFormat={"date":{},"month":{pattern:"MMMM"},"int":{}};
e.createInstance=function(F,j){var r=Object.create(this.prototype);if(F instanceof L){j=F;F=undefined;}if(!j){j=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}r.oLocale=j;r.oLocaleData=a.getInstance(j);r.oOriginalFormatOptions=d({},e.oDefaultDynamicDateFormat,F);r._dateFormatter=D.getInstance(r.oOriginalFormatOptions["date"]);[r._dateFormatter].concat(r._dateFormatter.aFallbackFormats).forEach(function(f){f.parseRelative=function(){return null;};});r._monthFormatter=D.getInstance(r.oOriginalFormatOptions["month"]);r._numberFormatter=N.getInstance(r.oOriginalFormatOptions["int"]);r._resourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");return r;};
e.prototype.format=function(O){var k=O.operator;var m=O.values.slice(0);if(k==="SPECIFICMONTH"){var f=new Date();f.setMonth(m[0]);m[0]=this._monthFormatter.format(f);}else if(k==="LASTDAYS"&&m[0]===1){k="YESTERDAY";m=[];}else if(k==="NEXTDAYS"&&m[0]===1){k="TOMORROW";m=[];}else if((k==="LASTDAYS"||k==="NEXTDAYS")&&m[0]===0){k="TODAY";m=[];}var F=m.map(function(j){if(j instanceof Date){return this._dateFormatter.format(j);}if(typeof(j)==="number"){return this._numberFormatter.format(j);}else{return j.toString();}},this);return this._resourceBundle.getText("DYNAMIC_DATE_"+k.toUpperCase()+"_FORMAT",F);};
e.prototype.parse=function(v,k){var r;var S=g[k];var R="^"+S.join("(.*)")+"$";if(k==="TODAYFROMTO"){R=R.replace("+","\\+");}var f=new RegExp(R,"i");var t=v.match(f);if(t){r={};r.values=[];for(var j=0;j<h[k].length;j++){var I=h[k][j];var T=p[k][I];var V;var C=t[j+1];switch(T){case"date":V=this._dateFormatter.parse(C);break;case"month":var M=[0,1,2,3,4,5,6,7,8,9,10,11].map(function(i){var w=new Date();w.setMonth(i);return this._monthFormatter.format(w);},this);var u=M.indexOf(C);V=u!==-1?u:null;break;case"int":V=this._numberFormatter.parse(C);break;case"string":V=C;break;default:break;}if(!V){r=null;break;}r.values[I]=V;}if(r){r.operator=k;return r;}}};
return e;});
sap.ui.predefine('sap/m/DynamicDateOption',['sap/ui/core/Element','./Label','./StepInput','sap/ui/unified/Calendar','sap/ui/unified/DateRange','sap/ui/unified/calendar/MonthPicker'],function(E,L,S,C,D,M){"use strict";
var a=E.extend("sap.m.DynamicDateOption",{metadata:{library:"sap.m",properties:{key:{type:"string"},valueTypes:{type:"string[]",multiple:true}}}});
a.prototype.getText=function(c){return this.getKey();};
a.prototype.getValueHelpUITypes=function(c){throw new Error("Need implementation for method getValueHelpUITypes. Option: "+this.getKey());};
a.prototype.createValueHelpUI=function(c,f){var v=c.getValue();var p=this.getValueHelpUITypes(c);var b=[];var I;if(!c.aControlsByParameters){c.aControlsByParameters={};}c.aControlsByParameters[this.getKey()]=[];for(var i=0;i<p.length;i++){if(p[i].getText()){b.push(new L({text:p[i].getText(),width:"100%"}));}I=this._createControl(i,p[i].getType(),v,f);b.push(I);c.aControlsByParameters[this.getKey()].push(I);}return b;};
a.prototype.validateValueHelpUI=function(c){var p=this.getValueHelpUITypes();for(var i=0;i<p.length;i++){var I=c.aControlsByParameters[this.getKey()][i];switch(p[i].getType()){case"int":if(I._isLessThanMin(I.getValue())||I._isMoreThanMax(I.getValue())){return false;}break;case"month":case"date":case"daterange":if(!I.getSelectedDates()||I.getSelectedDates().length==0){return false;}break;}}return true;};
a.prototype.getValueHelpOutput=function(c){var p=this.getValueHelpUITypes(),r={},o;r.operator=this.getKey();r.values=[];for(var i=0;i<p.length;i++){var I=c.aControlsByParameters[this.getKey()][i];switch(p[i].getType()){case"int":o=I.getValue();break;case"month":case"date":if(!I.getSelectedDates().length){return null;}o=I.getSelectedDates()[0].getStartDate();break;case"daterange":if(!I.getSelectedDates().length){return null;}var e=I.getSelectedDates()[0].getEndDate()||I.getSelectedDates()[0].getStartDate();o=[I.getSelectedDates()[0].getStartDate(),e];break;}if(Array.isArray(o)){r.values=Array.prototype.concat.apply(r.values,o);}else{o&&r.values.push(o);}}return r;};
a.prototype.getGroup=function(){return 0;};
a.prototype.getGroupHeader=function(){var g=(this.getGroup()>-1&&this.getGroup()<7)?this.getGroup():0;return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DDR_OPTIONS_GROUP_"+g);};
a.prototype.format=function(v){throw new Error("Need implementation for method format. Option: "+this.getKey());};
a.prototype.parse=function(v){throw new Error("Need implementation for method parse. Option: "+this.getKey());};
a.prototype.toDates=function(v){throw new Error("Need implementation for method toDates. Option: "+this.getKey());};
a.prototype.enhanceFormattedValue=function(){return false;};
a.prototype._createControl=function(i,u,v,c){var I;switch(u){case"int":I=this._createIntegerControl(v,i,c);break;case"date":I=this._createDateControl(v,i,c);break;case"daterange":I=this._createDateRangeControl(v,i,c);break;case"month":I=this._createMonthControl(v,i,c);break;}return I;};
a.prototype._createIntegerControl=function(v,i,c){var o=new S({width:"120px"});if(v&&this.getKey()===v.operator){o.setValue(v.values[i]);}if(c instanceof Function){o.attachChange(function(){c(this);},this);}return o;};
a.prototype._createDateControl=function(v,i,c){var o=new C({width:"100%"});if(v&&this.getKey()===v.operator){o.addSelectedDate(new D({startDate:v.values[i]}));}if(c instanceof Function){o.attachSelect(function(){c(this);},this);}return o;};
a.prototype._createDateRangeControl=function(v,i,c){var o=new C({intervalSelection:true,width:"100%"});if(v&&this.getKey()===v.operator){o.addSelectedDate(new D({startDate:v.values[i],endDate:v.values[i+1]}));}if(c instanceof Function){o.attachSelect(function(){c(this);},this);}return o;};
a.prototype._createMonthControl=function(v,i,c){var o=new M(),d=new Date(),m=(v&&this.getKey()===v.operator)?v.values[i]:d.getMonth();o.setMonth(m);o.addSelectedDate(new D({startDate:d}));if(c instanceof Function){o.attachSelect(function(){c(this);},this);}return o;};
return a;});
sap.ui.predefine('sap/m/DynamicDateRange',['sap/ui/core/InvisibleText','sap/ui/core/Element','sap/ui/core/Control','sap/ui/core/ListItem','sap/ui/core/library',"sap/ui/core/Renderer",'sap/ui/core/message/MessageMixin','sap/m/DynamicDateFormat','sap/m/DynamicDateUtil','sap/ui/core/IconPool','sap/ui/core/Icon',"sap/ui/core/LabelEnablement",'sap/ui/core/format/DateFormat','sap/ui/base/ManagedObjectObserver','sap/ui/Device','./Label','./GroupHeaderListItem','./StandardListItem','./StandardListItemRenderer','./Button','./List','./Input','./InputRenderer','./Toolbar','./ResponsivePopover','./Page','./NavContainer','./DynamicDateRangeRenderer','./StandardDynamicDateOption','sap/ui/dom/jquery/Focusable','./library'],function(I,E,C,L,c,R,M,D,d,e,f,g,h,i,j,k,G,S,l,B,m,n,p,T,q,P,N,r,s,F,t){"use strict";var V=c.ValueState,u=t.ToolbarDesign,v=t.ToolbarStyle,w=t.ListType,x=t.ListMode,y=t.ListSeparators,z=sap.ui.getCore().getLibraryResourceBundle("sap.m");
var A=C.extend("sap.m.DynamicDateRange",{
metadata:{library:"sap.m",properties:{value:{type:"object"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},required:{type:"boolean",group:"Misc",defaultValue:false},enableGroupHeaders:{type:"boolean",group:"Behavior",defaultValue:true},formatter:{type:"object"},options:{type:"string[]",group:"Behavior",defaultValue:["DATE","TODAY","YESTERDAY","TOMORROW","FIRSTDAYWEEK","LASTDAYWEEK","FIRSTDAYMONTH","LASTDAYMONTH","FIRSTDAYQUARTER","LASTDAYQUARTER","FIRSTDAYYEAR","LASTDAYYEAR","DATERANGE","FROM","TO","YEARTODATE","DATETOYEAR","LASTDAYS","LASTWEEKS","LASTMONTHS","LASTQUARTERS","LASTYEARS","NEXTDAYS","NEXTWEEKS","NEXTMONTHS","NEXTQUARTERS","NEXTYEARS","TODAYFROMTO","THISWEEK","LASTWEEK","NEXTWEEK","SPECIFICMONTH","THISMONTH","LASTMONTH","NEXTMONTH","THISQUARTER","LASTQUARTER","NEXTQUARTER","QUARTER1","QUARTER2","QUARTER3","QUARTER4","THISYEAR","LASTYEAR","NEXTYEAR"]}},aggregations:{_input:{type:"sap.m.Input",multiple:false,visibility:"hidden"},_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{change:{parameters:{value:{type:"object"},valid:{type:"boolean"}}}}},
renderer:r
});
M.call(A.prototype);
A.prototype.init=function(){this._oInput=new J(this.getId()+"-input",{showValueHelp:true,valueHelpIconSrc:e.getIconURI("sap-icon://check-availability"),valueHelpRequest:this._toggleOpen.bind(this),showSuggestion:true,suggest:this._handleSuggest.bind(this)});this._oListItemDelegate=undefined;this._onBeforeInputRenderingDelegate={onBeforeRendering:function(){this._oInput._getValueHelpIcon().setVisible(true);}};this._oInput._getValueHelpIcon().setTooltip(z.getText("INPUT_VALUEHELP_BUTTON"));this._oInput.addDelegate(this._onBeforeInputRenderingDelegate,this);this.setAggregation("_input",this._oInput,false);this._oInput._setControlOrigin(this);this._oInput.attachChange(this._handleInputChange,this);this.oValueObserver=new i(function(){delete this.oBoundValueFormatter;}.bind(this));this.oValueObserver.observe(this,{bindings:["value"]});};
A.prototype.exit=function(){this._oInput.removeDelegate(this._onBeforeInputRenderingDelegate);this._onBeforeInputRenderingDelegate=undefined;this.oValueObserver.destroy();this._infoDatesFooter=undefined;this.aInputControls=undefined;this._removeAllListItemDelegates();};
A.prototype._removeAllListItemDelegates=function(){if(this._oOptionsList){this._oOptionsList.getItems().forEach(function(o){o.removeDelegate(this._oListItemDelegate);},this);}};
A.prototype.onBeforeRendering=function(){this._updateInputValue(this.getValue());this._oInput.setEditable(this.getEditable());this._oInput.setEnabled(this.getEnabled());this._oInput.setRequired(this.getRequired());this._oInput.setName(this.getName());this._oInput.setWidth(this.getWidth());this._oInput.setPlaceholder(this.getPlaceholder());this._oInput.setValueState(this.getValueState());this._oInput.setValueStateText(this.getValueStateText());};
A.prototype.setValue=function(o){o=this._substitudeValue(o);this.setProperty("value",o);this._updateInputValue(o);return this;};
A.prototype._toggleOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){this._closePopup();}else{this.open();}};
A.prototype.open=function(){if(this.getEditable()&&this.getEnabled()){this._createPopup();this._createPopupContent();if(!this._oListItemDelegate){this._oListItemDelegate={onsapshow:this._closePopup.bind(this),onsaphide:this._closePopup.bind(this)};}this._removeAllListItemDelegates();this._oOptionsList.destroyAggregation("items");this._collectValueHelpItems(this._getOptions(),true).map(function(o){if(typeof(o)==="string"){return this._createHeaderListItem(o);}return this._createListItem(o);},this).forEach(function(o){o.addDelegate(this._oListItemDelegate,this);this._oOptionsList.addItem(o);},this);this._oNavContainer.to(this._oNavContainer.getPages()[0]);this._openPopup();}};
A.prototype.addOption=function(a){var o=this.getOptions();if(o.indexOf(a)===-1){o.push(a);}this.setOptions(o);};
A.prototype.getFocusDomRef=function(){return this.getAggregation("_input")&&this.getAggregation("_input").getFocusDomRef();};
A.prototype._updateInputValue=function(o){var a;if(o&&o.operator!=="PARSEERROR"){a=this._enhanceInputValue(this._formatValue(o),o);this._oInput.setValue(a);}};
A.prototype._handleSuggest=function(o){if(this._oPopup&&this._oPopup.isOpen()){this._closePopup();}var Q=o.getParameter("suggestValue");this._oInput.removeAllSuggestionItems();var a=this._getOptions().filter(function(O){var U={operator:O.getKey(),values:[]},W=O.getValueHelpUITypes(this);if(W.length&&W[0].getType()){return false;}var X=d.getOption(U.operator).format(U,this._getFormatter()).toLowerCase();var Y=X.indexOf(Q.toLowerCase());return Y===0||(Y>0&&X[Y-1]===" ");},this);this._collectValueHelpItems(a,true).forEach(function(O){if(O.getKey){var U={operator:O.getKey(),values:[]};this._addSuggestionItem(U);}else{this._addSuggestionGroupItem(O);}},this);var b=Q.match(/\d+/);if(!b){return;}a=this._getOptions().filter(function(O){return O.getValueHelpUITypes(this).length===1&&O.getValueHelpUITypes(this)[0].getType()==="int";},this);this._collectValueHelpItems(a,false).forEach(function(O){if(O.getKey){var U={operator:O.getKey(),values:[parseInt(b[0])]};this._addSuggestionItem(U);}else{this._addSuggestionGroupItem(O);}},this);};
A.prototype._getOptions=function(){var O=this.getOptions();var a=O.map(function(b){return d.getOption(b);},this);return a.filter(function(o){return!!o;});};
A.prototype._getDatesLabelFormatter=function(){if(!this._oDatesLabelFormatter){var o=Object.create(this._getFormatter()._dateFormatter.oFormatOptions);o.interval=true;this._oDatesLabelFormatter=h.getInstance(o);}return this._oDatesLabelFormatter;};
A.prototype._destroyInputControls=function(){if(!this.aInputControls){return;}this.aInputControls.forEach(function(o){o.destroy();});this.aInputControls=undefined;};
A.prototype._addSuggestionItem=function(o){var a=d.toDates(o);var b=new L({text:d.getOption(o.operator).format(o,this._getFormatter()),additionalText:this._getDatesLabelFormatter().format(a)});this._oInput.addSuggestionItem(b);};
A.prototype._addSuggestionGroupItem=function(a){this._oInput.addSuggestionItemGroup({text:a});};
A.prototype._handleInputChange=function(o){var a=o.getParameter("value");var b=this._parseValue(this._stripValue(a));var O=this.getValue();var Q=a.trim()===""||!!b;if(!Q){this.setValue({operator:"PARSEERROR",values:[z.getText("DDR_WRONG_VALUE"),a]});}else{this.setValue(b);}this.fireChange({value:this.getValue(),prevValue:O,valid:Q});};
A.prototype._enhanceInputValue=function(a,o){if(d.getOption(o.operator).enhanceFormattedValue()||(o.operator==="LASTDAYS"&&o.values[0]<=1)||(o.operator==="NEXTDAYS"&&o.values[0]<=1)){return a+" ("+this._toDatesString(o)+")";}return a;};
A.prototype._stripValue=function(a){var o=a.indexOf("(");var b=a.lastIndexOf(")");var O=a;if(o!==-1&&b!==-1&&o<b){O=a.slice(0,o)+a.slice(b+1);O=O.trim();}return O;};
A.prototype._toDatesString=function(o){return this._getDatesLabelFormatter().format(d.toDates(o));};
A.prototype._createPopup=function(){if(!this._oPopup){this._oPopup=new q(this.getId()+"-RP",{contentHeight:'470px',contentWidth:_(this.getDomRef())?'272px':'320px',showCloseButton:false,showArrow:false,showHeader:false,placement:t.PlacementType.VerticalPreferedBottom,ariaLabelledBy:[I.getStaticId("sap.m","INPUT_AVALIABLE_VALUES")]});this._oPopup.addStyleClass("sapMDDRPopover");if(j.system.phone){this._oPopup.addStyleClass("sapUiNoContentPadding");}else{this._oPopup._oControl._getSingleNavContent=function(){return null;};}this._oPopup.attachAfterOpen(function(){var o=this._oNavContainer.getPages()[0];this._applyNavContainerPageFocus(o);this.invalidate();},this);this._oPopup.attachAfterClose(function(){this._setFooterVisibility(false);this.invalidate();},this);this._oPopup.setBeginButton(new B({type:t.ButtonType.Emphasized,text:z.getText("DYNAMIC_DATE_RANGE_CONFIRM"),press:this._applyValue.bind(this)}));this._oPopup.setEndButton(new B({text:z.getText("DYNAMIC_DATE_RANGE_CANCEL"),press:this._closePopup.bind(this)}));this._setFooterVisibility(false);this._oPopup._getPopup().setAutoClose(true);this.setAggregation("_popup",this._oPopup,true);}};
A.prototype._collectValueHelpItems=function(o,O){var Q;var U;var W=[];var X=o;var Y=d.getStandardKeys();X.sort(function(a,b){var Z=a.getGroup()-b.getGroup();if(Z){return Z;}return Y.indexOf(a.getKey())-Y.indexOf(b.getKey());});if(O){X=X.reduce(function(a,b){if(s.LastXKeys.indexOf(b.getKey())!==-1){if(Q){return a;}Q=true;}if(s.NextXKeys.indexOf(b.getKey())!==-1){if(U){return a;}U=true;}a.push(b);return a;},[]);}if(this.getEnableGroupHeaders()){X=X.reduce(function(a,b){var Z=b.getGroupHeader();if(W.indexOf(Z)===-1){W.push(Z);a.push(Z);}a.push(b);return a;},[]);}return X;};
A.prototype._createListItem=function(o){var b=this._isFixedOption(o);return new K(this.getId()+"-option-"+o.getKey(),{type:b?w.Active:w.Navigation,title:o.getText(this),wrapping:true,optionKey:o.getKey(),press:this._handleOptionPress.bind(this)});};
A.prototype._createHeaderListItem=function(a){var o=new G();o.setTitle(a);o._bGroupHeader=true;return o;};
A.prototype._handleOptionPress=function(o){var O=o.getSource().getOptionKey(),a=d.getOption(O);this._oSelectedOption=a;if(this._isFixedOption(a)){this._applyValue();}else{var b=this._createInfoDatesFooter();this._destroyInputControls();this.aInputControls=a.createValueHelpUI(this,this._updateInternalControls.bind(this));var Q=this._oNavContainer.getPages()[1];Q.removeAllContent();this.aInputControls.forEach(function(U){Q.addContent(U);});Q.setFooter(b);Q.setTitle(a.getText(this));this._setFooterVisibility(true);this._updateInternalControls(a);this._oNavContainer.to(Q);}};
A.prototype._isFixedOption=function(o){return!o.getValueHelpUITypes(this).length;};
A.prototype._createInfoDatesFooter=function(){this._infoDatesFooter=new T({design:u.Info,style:v.Clear,content:[new k({text:z.getText("DDR_INFO_DATES_EMPTY_HINT")})]});return this._infoDatesFooter;};
A.prototype._getDatesLabel=function(){return this._infoDatesFooter.getContent()[0];};
A.prototype._updateDatesLabel=function(){var o=this._oSelectedOption.getValueHelpOutput(this),a,b;if(!o||!o.operator||!d.getOption(o.operator)){return;}a=d.toDates(o);if(a){b=this._getDatesLabelFormatter().format(a);this._getDatesLabel().setText(z.getText("DDR_INFO_DATES",[b]));}};
A.prototype._setApplyButtonEnabled=function(b){if(!this._oPopup){return;}var a=this._oPopup.getBeginButton();if(a.getVisible()){a.setEnabled(b);}};
A.prototype._updateInternalControls=function(o){var b=o.validateValueHelpUI(this);if(b){this._updateDatesLabel();}this._setApplyButtonEnabled(b);};
A.prototype._setFooterVisibility=function(b){var o;if(!this._oPopup){return;}o=this._oPopup.getAggregation("_popup");if(j.system.phone){this._oPopup.getBeginButton().setVisible(b);}else{o.getFooter().setVisible(b);}o.invalidate();return this;};
A.prototype._createPopupContent=function(){var o=new P({showHeader:false,showNavButton:false}),a=new P({showHeader:true,showNavButton:true}).addStyleClass("sapMDynamicDateRangePopover");a.attachNavButtonPress(function(){this._setFooterVisibility(false);this._oNavContainer.back();},this);if(j.system.phone){o.setShowHeader(true);o.setTitle(this._getOptionsPageTitleText());}if(!this._oOptionsList){this._oOptionsList=new m({showSeparators:y.None,mode:x.None});}if(!this._oNavContainer){this._oNavContainer=new N({autoFocus:false});this._oNavContainer.addPage(o);this._oNavContainer.setInitialPage(o);this._oNavContainer.addPage(a);this._oNavContainer.attachAfterNavigate(this._navContainerAfterNavigate,this);this._oPopup.addContent(this._oNavContainer);}this._oNavContainer.getPages()[0].removeAllContent();this._oNavContainer.getPages()[0].addContent(this._oOptionsList);return this._oOptionsList;};
A.prototype._applyNavContainerPageFocus=function(o){var a=this.getValue(),O=this._oNavContainer.getPages()[0],b;if(o===O&&a){b=this._oOptionsList.getItems().find(function(Q){return Q.isA("sap.m.DynamicDateRangeListItem")&&(Q.getOptionKey()===a.operator);});}if(!b){b=jQuery(o.getDomRef().querySelector("section")).firstFocusableDomRef();}b.focus();this._reApplyFocusToElement(o,a);};
A.prototype._reApplyFocusToElement=function(o,a){};
A.prototype._getOptionsPageTitleText=function(){return g.getReferencingLabels(this).concat(this.getAriaLabelledBy()).reduce(function(a,b){var o=E.registry.get(b);return a+" "+(o.getText?o.getText():"");},"").trim();};
A.prototype._navContainerAfterNavigate=function(o){var O=this._oNavContainer.getPages()[1],a=o.getParameters()["to"];if(a===O){this.aInputControls.forEach(function(b){if(jQuery(b.getDomRef()).firstFocusableDomRef()){b.addAriaLabelledBy(a.getAggregation("_internalHeader"));if(!this._isCalendarBasedControl(b)&&b.addAriaDescribedBy){b.addAriaDescribedBy(a.getFooter().getContent()[0]);}}},this);}if(this._oPopup&&this._oPopup.isOpen()){this._applyNavContainerPageFocus(a);}else{this.focus();}};
A.prototype._isCalendarBasedControl=function(o){return o.isA("sap.ui.unified.Calendar")||o.isA("sap.ui.unified.calendar.CustomMonthPicker")||o.isA("sap.ui.unified.calendar.MonthPicker")||o.isA("sap.ui.unified.calendar.YearPicker")||o.isA("sap.ui.unified.calendar.YearRangePicker")||o.isA("sap.ui.unified.calendar.Month");};
A.prototype._openPopup=function(){if(!this._oPopup){return;}this._oPopup._getPopup().setAutoCloseAreas([this._oInput.getDomRef()]);this._oPopup.openBy(this._oInput);};
A.prototype._applyValue=function(){this._oOutput=this._oSelectedOption.getValueHelpOutput(this);var a=this.getValue();this.setValue(this._oOutput);this.fireChange({prevValue:a,value:this.getValue(),valid:true});this._closePopup();};
A.prototype._closePopup=function(){this._setFooterVisibility(false);this._oNavContainer.to(this._oNavContainer.getPages()[0]);this._oPopup.close();};
A.prototype._getFormatter=function(){var o=this.getFormatter(),b;if(o){return o;}if(this.oBoundValueFormatter){return this.oBoundValueFormatter;}b=this.getBinding("value");if(b&&b.getType()){this.oBoundValueFormatter=D.getInstance(b.getType().oFormatOptions);return this.oBoundValueFormatter;}if(!this.oDefaultFormatter){this.oDefaultFormatter=D.getInstance();}return this.oDefaultFormatter;};
A.prototype._formatValue=function(o){return d.getOption(o.operator).format(o,this._getFormatter());};
A.prototype._parseValue=function(a){var b=d.parse(a,this._getFormatter(),this.getOptions()).filter(function(o){return this.getOptions().indexOf(o.operator)!==-1;},this);return b.length?b[0]:null;};
A.prototype._substitudeValue=function(o){var a,b,O;if(!o||!o.operator||!o.values){return o;}a=o.operator;b=o.values;if(a==="LASTDAYS"&&b[0]===1){O={operator:"YESTERDAY",values:[]};}else if(a==="NEXTDAYS"&&b[0]===1){O={operator:"TOMORROW",values:[]};}else if((a==="LASTDAYS"||a==="NEXTDAYS")&&b[0]===0){O={operator:"TODAY",values:[]};}return O?O:o;};
var H=R.extend(p);H.apiVersion=2;
H.getAriaRole=function(o){return"combobox";};
H.writeInnerAttributes=function(o,a){o.attr("type","text");};
H.getAccessibilityState=function(o){var a=p.getAccessibilityState(o),b=o._getControlOrigin(),O=b.getAriaLabelledBy(),Q=g.getReferencingLabels(b),U=b.getAriaDescribedBy().join(" "),W;W=Q.concat(O).join(" ");if(U){a.describedby=U;}if(W){a.labelledby=W;}a.roledescription=z.getText("ACC_CTR_TYPE_DYNAMIC_DATE_RANGE");a.role=this.getAriaRole();a.expanded=b._oPopup?b._oPopup.isOpen():false;a.haspopup=c.aria.HasPopup.ListBox.toLowerCase();a.autocomplete="list";a.controls=b._oPopup&&b._oPopup.getDomRef()?b._oPopup.getDomRef().id:undefined;return a;};
var J=n.extend("sap.m.internal.DynamicDateRangeInput",{
metadata:{library:"sap.m"},
renderer:H
});
J.prototype._setControlOrigin=function(o){this._oOriginControl=o;return this._oOriginControl;};
J.prototype._getControlOrigin=function(){return this._oOriginControl;};
J.prototype.preventChangeOnFocusLeave=function(o){return this.bFocusoutDueRendering;};
J.prototype.shouldSuggetionsPopoverOpenOnMobile=function(o){var b=o.srcControl instanceof f;return this.isMobileDevice()&&this.getEditable()&&this.getEnabled()&&this.getShowSuggestion()&&!b&&(!this._bClearButtonPressed);};
var K=S.extend("sap.m.DynamicDateRangeListItem",{
metadata:{library:"sap.m",properties:{optionKey:{type:"string",group:"Misc",defaultValue:null}}},
renderer:l
});
K.prototype.getNavigationControl=function(){var o=S.prototype.getNavigationControl.apply(this,arguments),b=["SPECIFICMONTH","DATE","DATERANGE","FROM","TO"].includes(this.getOptionKey()),a=b?e.getIconURI("appointment-2"):e.getIconURI("slim-arrow-right");if(b){o.addStyleClass("sapMDDRDateOption");}o.setSrc(a);return o;};
function _(o){var a=o;while(a&&a.classList){if(a.classList.contains("sapUiSizeCompact")){return true;}a=a.parentNode;}return false;}
return A;});
sap.ui.predefine('sap/m/DynamicDateRangeRenderer',["sap/m/InputBaseRenderer",'sap/ui/core/Renderer'],function(I,R){"use strict";var D={apiVersion:2};
D.render=function(r,c){r.openStart("div",c);r.class("sapMDynamicDateRange");r.openEnd();r.renderControl(c._oInput);r.close("div");};
return D;});
sap.ui.predefine('sap/m/DynamicDateUtil',["./StandardDynamicDateOption","sap/base/Log","./library"],function(S,L,l){"use strict";var a=["DATE","TODAY","YESTERDAY","TOMORROW","FIRSTDAYWEEK","LASTDAYWEEK","FIRSTDAYMONTH","LASTDAYMONTH","FIRSTDAYQUARTER","LASTDAYQUARTER","FIRSTDAYYEAR","LASTDAYYEAR","DATERANGE","FROM","TO","YEARTODATE","DATETOYEAR","LASTDAYS","LASTWEEKS","LASTMONTHS","LASTQUARTERS","LASTYEARS","NEXTDAYS","NEXTWEEKS","NEXTMONTHS","NEXTQUARTERS","NEXTYEARS","TODAYFROMTO","THISWEEK","LASTWEEK","NEXTWEEK","SPECIFICMONTH","THISMONTH","LASTMONTH","NEXTMONTH","THISQUARTER","LASTQUARTER","NEXTQUARTER","QUARTER1","QUARTER2","QUARTER3","QUARTER4","THISYEAR","LASTYEAR","NEXTYEAR"];var D={_options:{"TODAY":new S({key:"TODAY",valueTypes:[]}),"YESTERDAY":new S({key:"YESTERDAY",valueTypes:[]}),"TOMORROW":new S({key:"TOMORROW",valueTypes:[]}),"FIRSTDAYWEEK":new S({key:"FIRSTDAYWEEK",valueTypes:[]}),"LASTDAYWEEK":new S({key:"LASTDAYWEEK",valueTypes:[]}),"FIRSTDAYMONTH":new S({key:"FIRSTDAYMONTH",valueTypes:[]}),"LASTDAYMONTH":new S({key:"LASTDAYMONTH",valueTypes:[]}),"FIRSTDAYQUARTER":new S({key:"FIRSTDAYQUARTER",valueTypes:[]}),"LASTDAYQUARTER":new S({key:"LASTDAYQUARTER",valueTypes:[]}),"FIRSTDAYYEAR":new S({key:"FIRSTDAYYEAR",valueTypes:[]}),"LASTDAYYEAR":new S({key:"LASTDAYYEAR",valueTypes:[]}),"THISWEEK":new S({key:"THISWEEK",valueTypes:[]}),"THISMONTH":new S({key:"THISMONTH",valueTypes:[]}),"THISQUARTER":new S({key:"THISQUARTER",valueTypes:[]}),"THISYEAR":new S({key:"THISYEAR",valueTypes:[]}),"LASTWEEK":new S({key:"LASTWEEK",valueTypes:[]}),"LASTMONTH":new S({key:"LASTMONTH",valueTypes:[]}),"LASTQUARTER":new S({key:"LASTQUARTER",valueTypes:[]}),"LASTYEAR":new S({key:"LASTYEAR",valueTypes:[]}),"NEXTWEEK":new S({key:"NEXTWEEK",valueTypes:[]}),"NEXTMONTH":new S({key:"NEXTMONTH",valueTypes:[]}),"NEXTQUARTER":new S({key:"NEXTQUARTER",valueTypes:[]}),"NEXTYEAR":new S({key:"NEXTYEAR",valueTypes:[]}),"LASTDAYS":new S({key:"LASTDAYS",valueTypes:["int"]}),"LASTWEEKS":new S({key:"LASTWEEKS",valueTypes:["int"]}),"LASTMONTHS":new S({key:"LASTMONTHS",valueTypes:["int"]}),"LASTQUARTERS":new S({key:"LASTQUARTERS",valueTypes:["int"]}),"LASTYEARS":new S({key:"LASTYEARS",valueTypes:["int"]}),"NEXTDAYS":new S({key:"NEXTDAYS",valueTypes:["int"]}),"NEXTWEEKS":new S({key:"NEXTWEEKS",valueTypes:["int"]}),"NEXTMONTHS":new S({key:"NEXTMONTHS",valueTypes:["int"]}),"NEXTQUARTERS":new S({key:"NEXTQUARTERS",valueTypes:["int"]}),"NEXTYEARS":new S({key:"NEXTYEARS",valueTypes:["int"]}),"FROM":new S({key:"FROM",valueTypes:["date"]}),"TO":new S({key:"TO",valueTypes:["date"]}),"YEARTODATE":new S({key:"YEARTODATE",valueTypes:[]}),"DATETOYEAR":new S({key:"DATETOYEAR",valueTypes:[]}),"TODAYFROMTO":new S({key:"TODAYFROMTO",valueTypes:["int","int"]}),"QUARTER1":new S({key:"QUARTER1",valueTypes:[]}),"QUARTER2":new S({key:"QUARTER2",valueTypes:[]}),"QUARTER3":new S({key:"QUARTER3",valueTypes:[]}),"QUARTER4":new S({key:"QUARTER4",valueTypes:[]}),"SPECIFICMONTH":new S({key:"SPECIFICMONTH",valueTypes:["int"]}),"DATERANGE":new S({key:"DATERANGE",valueTypes:["date","date"]}),"DATE":new S({key:"DATE",valueTypes:["date"]})},_allKeys:a.slice(0)};
D.addOption=function(o){if(!o||!o.getKey()){return;}var k=o.getKey();D._options[k]=o;if(D._allKeys.indexOf(k)===-1){D._allKeys.push(k);}};
D.getAllOptionKeys=function(){return D._allKeys.slice(0);};
D.getOption=function(k){return D._options[k];};
D.getStandardKeys=function(){return a.slice(0);};
D.parse=function(v,f,o){if(typeof v!=='string'){L.error("DynamicDateFormat can only parse a String.");return[];}var r=[],R,s=D.getStandardKeys();o=o||Object.keys(D._options);var O=o.sort(function(k,K){return s.indexOf(k)-s.indexOf(K);}).map(function(k){return D._options[k];});for(var i=0;i<O.length;i++){R=O[i]&&O[i].parse(v.trim(),f);if(R){R.operator=O[i].getKey();r.push(R);}}return r;};
D.toDates=function(v){var k=v.operator;return D._options[k].toDates(v);};
return D;},true);
sap.ui.predefine('sap/m/DynamicDateValueHelpUIType',['sap/ui/core/Element'],function(E){"use strict";
var D=E.extend("sap.m.DynamicDateValueHelpUIType",{metadata:{library:"sap.m",properties:{type:{type:"string"},text:{type:"string"},additionalText:{type:"string"},options:{type:"string[]",multiple:true,defaultValue:null}}}});
return D;});
sap.ui.predefine('sap/m/ExpandableText',['./library','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/library','sap/ui/Device','sap/ui/base/ManagedObject','sap/m/Link','sap/m/Text','sap/m/Button','sap/m/ResponsivePopover','sap/m/HyphenationSupport',"./ExpandableTextRenderer"],function(l,C,a,c,D,M,L,T,B,R,H,E){"use strict";var r=C.getLibraryResourceBundle("sap.m");var b=r.getText("EXPANDABLE_TEXT_SHOW_MORE");var d=r.getText("EXPANDABLE_TEXT_SHOW_LESS");var e=r.getText("MSGBOX_CLOSE");var f=c.TextAlign;var g=c.TextDirection;var A=c.aria.HasPopup;var W=l.WrappingType;var P=l.PlacementType;var h=l.ExpandableTextOverflowMode;var i=l.EmptyIndicatorMode;
function j(t){return t.replace(/ {2,}/g,' ').replace(/\t{2,}/g,' ');}
var k=a.extend("sap.m.ExpandableText",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.m.IHyphenation"],library:"sap.m",properties:{text:{type:"string",defaultValue:'',bindable:"bindable"},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:g.Inherit},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:W.Normal},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:f.Begin},renderWhitespace:{type:"boolean",group:"Appearance",defaultValue:false},overflowMode:{type:"sap.m.ExpandableTextOverflowMode",group:"Appearance",defaultValue:h.InPlace},maxCharacters:{type:"int",group:"Appearance",defaultValue:100},expanded:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:i.Off}},aggregations:{_showMoreLink:{type:'sap.m.Link',multiple:false,visibility:"hidden"}},designtime:"sap/m/designtime/ExpandableText.designtime"}});
k.prototype.getText=function(n){var t=this.getProperty("text");if(n){return t.replace(/\r\n|\n\r|\r/g,"\n");}return t;};
k.prototype.getTextDomRef=function(){if(!this.getVisible()){return null;}return this.getDomRef("string");};
k.prototype._isExpandable=function(){var t=this.getText();if(!this.getRenderWhitespace()){t=j(t);}return t.length>this._getMaxCharacters()+b.length;};
k.prototype._getMaxCharacters=function(){return Math.max(0,this.getMaxCharacters());};
k.prototype._getDisplayedText=function(){var t=this.getText(true);if(this.getProperty("expanded")||!this._isExpandable()){return t;}if(!this.getRenderWhitespace()){t=j(t);}return t.substring(0,this._getMaxCharacters());};
k.prototype._getShowMoreLink=function(){var s=this.getAggregation('_showMoreLink');if(!s){s=new L(this.getId()+'-showMoreLink',{text:this.getProperty("expanded")?d:b,press:function(o){var t,m,p;if(this.getOverflowMode()===h.InPlace){m=!this.getProperty("expanded");s.setText(m?d:b);this.setProperty("expanded",m);}else{t=new T({text:M.escapeSettingsValue(this.getText()),textDirection:this.getTextDirection(),wrappingType:this.getWrappingType(),textAlign:this.getTextAlign(),renderWhitespace:this.getRenderWhitespace()}).addStyleClass("sapUiSmallMargin").addStyleClass("sapMExTextPopover");p=this._oPopover;if(p&&p.isOpen()){p.close();return;}if(!p){p=this._oPopover=new R({showHeader:false,placement:P.HorizontalPreferredRight,beforeClose:this._onPopoverBeforeClose.bind(this)});if(D.system.phone){p.setEndButton(new B({text:e,press:function(){p.close();}}));}this.addDependent(p);}s.setText(d);s.rerender();p.removeAllAriaLabelledBy();p.destroyContent();p.addAriaLabelledBy(t);p.addContent(t);p.openBy(o.getSource());}}.bind(this)});this.setAggregation("_showMoreLink",s,true);}s.setAriaHasPopup(this.getOverflowMode()===h.InPlace?A.None:A.Dialog);return s;};
k.prototype._onPopoverBeforeClose=function(){this._getShowMoreLink().setText(b);};
k.prototype.exit=function(){if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};
k.prototype.getAccessibilityInfo=function(){return{description:this.getText()};};
k.prototype.getTextsToBeHyphenated=function(){return{"main":this._getDisplayedText(true)};};
k.prototype.getDomRefsForHyphenatedTexts=function(){return{"main":this.getTextDomRef()};};
H.mixInto(k.prototype);return k;});
sap.ui.predefine('sap/m/ExpandableTextRenderer',['sap/ui/core/Core','sap/ui/core/Renderer','sap/ui/core/library','sap/m/HyphenationSupport','./library'],function(C,R,c,H,m){"use strict";var T=c.TextDirection;var W=m.WrappingType;var E=m.EmptyIndicatorMode;var r=C.getLibraryResourceBundle("sap.m");var a={apiVersion:2};
a.render=function(o,t){var d=t._getDisplayedText(),s=t.getTextDirection(),b=t.getTooltip_AsString(),w=t.getWrappingType(),e=t.getTextAlign(),f=t.getRenderWhitespace(),g=t._isExpandable(),h=t.getProperty("expanded"),i=h?" ":"... ";o.openStart("div",t);o.class("sapMExText");o.class("sapUiSelectable");if(w!==W.Hyphenated){if(d&&d.length>0&&!/\s/.test(d)){o.class("sapMExTextBreakWord");}}o.attr("dir",s!==T.Inherit?s.toLowerCase():"auto");if(b){o.attr("title",b);}if(e){e=R.getTextAlign(e,s);if(e){o.style("text-align",e);}}if(f){o.class("sapMExTextRenderWhitespaceWrap");}H.writeHyphenationClass(o,t);o.openEnd();o.openStart("span",t.getId()+"-string");o.class("sapMExTextString");o.openEnd();a.renderText(o,t);o.close("span");if(g){o.openStart("span");o.class("sapMExTextEllipsis");o.openEnd();o.unsafeHtml(i);o.close("span");o.renderControl(t._getShowMoreLink());}o.close("div");};
a.renderText=function(o,t){if(t.getEmptyIndicatorMode()!==E.Off&&!t.getText()){this.renderEmptyIndicator(o,t);}else{o.text(H.getTextForRender(t,"main"));}};
a.renderEmptyIndicator=function(o,t){o.openStart("span");o.class("sapMEmptyIndicator");if(t.getEmptyIndicatorMode()===E.Auto){o.class("sapMEmptyIndicatorAuto");}o.openEnd();o.openStart("span");o.attr("aria-hidden",true);o.openEnd();o.text(r.getText("EMPTY_INDICATOR"));o.close("span");o.openStart("span");o.class("sapUiPseudoInvisibleText");o.openEnd();o.text(r.getText("EMPTY_INDICATOR_TEXT"));o.close("span");o.close("span");};
return a;},true);
sap.ui.predefine('sap/m/FacetFilter',['./NavContainer','./library','sap/ui/core/Control','sap/ui/core/CustomData','sap/ui/core/IconPool','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/core/IntervalTrigger','sap/ui/Device','sap/ui/core/Icon','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/json/JSONModel','./FacetFilterRenderer',"sap/ui/events/KeyCodes","sap/base/assert","sap/base/Log","sap/ui/events/jquery/EventSimulation","sap/ui/thirdparty/jquery","sap/m/Button","sap/m/ToolbarSpacer","sap/m/OverflowToolbar","sap/m/Text","sap/m/Toolbar","sap/m/Popover","sap/m/SearchField","sap/m/Bar","sap/m/Dialog","sap/m/List","sap/m/StandardListItem","sap/m/CheckBox","sap/m/Page","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/Selectors"],function(N,l,C,a,I,b,c,d,D,e,F,f,J,g,K,h,L,E,q,B,T,O,m,n,P,S,o,p,r,s,t,u){"use strict";var v=l.ToolbarDesign;var w=l.ListType;var x=l.ListMode;var y=l.FacetFilterListDataType;var z=l.ButtonType;var A=l.PlacementType;var G=l.FacetFilterType;var H=500;
var M=C.extend("sap.m.FacetFilter",{metadata:{interfaces:["sap.ui.core.IShrinkable"],library:"sap.m",properties:{showPersonalization:{type:"boolean",group:"Appearance",defaultValue:false},type:{type:"sap.m.FacetFilterType",group:"Appearance",defaultValue:G.Simple},liveSearch:{type:"boolean",group:"Behavior",defaultValue:true},showSummaryBar:{type:"boolean",group:"Behavior",defaultValue:false},showReset:{type:"boolean",group:"Behavior",defaultValue:true},showPopoverOKButton:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"lists",aggregations:{lists:{type:"sap.m.FacetFilterList",multiple:true,singularName:"list"},buttons:{type:"sap.m.Button",multiple:true,singularName:"button",visibility:"hidden"},removeFacetIcons:{type:"sap.ui.core.Icon",multiple:true,singularName:"removeFacetIcon",visibility:"hidden"},popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},addFacetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},summaryBar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},resetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},arrowLeft:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},arrowRight:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{reset:{},confirm:{}}}});
M.SCROLL_STEP=264;
M.prototype.setType=function(i){var j,k;if(D.system.phone){this.setProperty("type",G.Light);k=true;}else{this.setProperty("type",i);k=(i===G.Light);}j=this._getSummaryBar();j.setActive(k);if(i===G.Light){if(this.getShowReset()){this._addResetToSummary(j);}else{this._removeResetFromSummary(j);}}return this;};
M.prototype.setShowReset=function(V){this.setProperty("showReset",V);var i=this._getSummaryBar();if(V){if(this.getShowSummaryBar()||this.getType()===G.Light){this._addResetToSummary(i);}}else{if(this.getShowSummaryBar()||this.getType()===G.Light){this._removeResetFromSummary(i);}}return this;};
M.prototype.setShowSummaryBar=function(V){this.setProperty("showSummaryBar",V);if(V){var i=this._getSummaryBar();if(this.getShowReset()){this._addResetToSummary(i);}else{this._removeResetFromSummary(i);}i.setActive(this.getType()===G.Light);}return this;};
M.prototype.setLiveSearch=function(V){this.setProperty("liveSearch",V);if(this._displayedList){var i=this._displayedList;var j=sap.ui.getCore().byId(i.getAssociation("search"));j.detachLiveChange(i._handleSearchEvent,i);if(V){j.attachLiveChange(i._handleSearchEvent,i);}}return this;};
M.prototype.getLists=function(){var i=this.getAggregation("lists");if(!i){i=[];}if(this._displayedList){i.splice(this._listAggrIndex,0,this._displayedList);}i.forEach(function(j){if(!j.hasListeners("listItemsChange")){j.attachEvent("listItemsChange",_.bind(this));}}.bind(this));return i;};
function _(i){var j=i.getSource();if(this._oAllCheckBoxBar){this._oAllCheckBoxBar.setVisible(Boolean(j.getItems(true).length));}}
M.prototype.removeAggregation=function(){var i=C.prototype.removeAggregation.apply(this,arguments);if(arguments[0]==="lists"){this._removeList(i);}return i;};
M.prototype.openFilterDialog=function(){var i=this._getFacetDialog();var j=this._getFacetDialogNavContainer();i.addContent(j);this.getLists().forEach(function(k){if(k.getMode()===x.MultiSelect){k._preserveOriginalActiveState();}});i.setInitialFocus(j.getPages()[0].getContent()[0].getItems()[0]);i.open();return this;};
M.prototype.init=function(){this._pageSize=5;this._invalidateFlag=false;this._lastCategoryFocusIndex=0;this._aDomRefs=null;this._previousTarget=null;this._addTarget=null;this._aRows=null;this._bundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.data("sap-ui-fastnavgroup","true",true);this._buttons={};this._aOwnedLabels=[];this._removeFacetIcons={};this._listAggrIndex=-1;this._displayedList=null;this._lastScrolling=false;this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._popoverClosing=false;this._getAddFacetButton();this.setAggregation("resetButton",this._createResetButton());if(E.touchEventMode==="ON"&&!D.system.phone){this._enableTouchSupport();}if(D.system.phone){this.setType(G.Light);}};
M.prototype.exit=function(){var i;d.removeListener(this._checkOverflow,this);if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();}if(this._aOwnedLabels){this._aOwnedLabels.forEach(function(j){i=sap.ui.getCore().byId(j);if(i){i.destroy();}});this._aOwnedLabels=null;}if(this._oAllCheckBoxBar){this._oAllCheckBoxBar=undefined;}};
M.prototype.onBeforeRendering=function(){if(this.getShowSummaryBar()||this.getType()===G.Light){var i=this._getSummaryBar();var j=i.getContent()[0];j.setText(this._getSummaryText());}d.removeListener(this._checkOverflow,this);};
M.prototype.onAfterRendering=function(){var i=this.getShowSummaryBar(),j=this.getType(),k=this._getSummaryBar().$();if(j!==G.Light&&!D.system.phone){d.addListener(this._checkOverflow,this);}if(j!==G.Light){this._startItemNavigation();this.addDelegate(this.oItemNavigation);}if(j===G.Light){k.attr("aria-roledescription",this._bundle.getText("FACETFILTER_ACTIVE_TITLE"));k.attr("role","group");}else if(i){k.attr("aria-roledescription",this._bundle.getText("FACETFILTER_TITLE"));}};
M.prototype._startItemNavigation=function(){var j=this.getDomRef(),R=j.getElementsByClassName("sapMFFHead"),k=[];if(R.length>0){for(var i=0;i<R[0].childNodes.length;i++){if(R[0].childNodes[i].id.indexOf("ff")<0&&R[0].childNodes[i].id.indexOf("icon")<0&&R[0].childNodes[i].id.indexOf("add")<0){k.push(R[0].childNodes[i]);}if(R[0].childNodes[i].id.indexOf("add")>=0){k.push(R[0].childNodes[i]);}}}if(k!=""){this._aDomRefs=k;}if(!this.oItemNavigation){this.oItemNavigation=new b();}this._aRows=R;for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].id.indexOf("add")>=0){this._addTarget=this.$().find(":sapTabbable")[i];break;}}this.oItemNavigation.setRootDomRef(j);if(this._invalidateFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._invalidateFlag=false;}this.oItemNavigation.setItemDomRefs(k);this.oItemNavigation.setCycling(false);this.oItemNavigation.setPageSize(this._pageSize);};
M.prototype.onsapdelete=function(i){var j,Q;if(this.getType()===G.Light){return;}if(!this.getShowPersonalization()){return;}j=sap.ui.getCore().byId(i.target.id);if(!j){return;}Q=sap.ui.getCore().byId(j.getAssociation("list"));if(!Q){return;}if(!Q.getShowRemoveFacetIcon()){return;}Q.removeSelections(true);Q.setSelectedKeys();Q.setProperty("active",false,true);this.invalidate();var $=this.$().find(":sapTabbable");q($[$.length-1]).trigger("focus");var R=this.oItemNavigation.getFocusedIndex();q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(R+1);this.focus();if(this.oItemNavigation.getFocusedIndex()==0){for(var k=0;k<this.$().find(":sapTabbable").length-1;k++){if($[k].id.indexOf("add")>=0){q($[k]).trigger("focus");}}}};
M.prototype.onsaptabnext=function(j){if(this.getType()===G.Light){return;}this._previousTarget=j.target;if(j.target.parentNode.className=="sapMFFHead"){for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].parentNode.className=="sapMFFResetDiv"){q(this.$().find(":sapTabbable")[i]).trigger("focus");this._invalidateFlag=false;j.preventDefault();j.setMarked();return;}}}this._lastCategoryFocusIndex=this.oItemNavigation.getFocusedIndex();if(this._invalidateFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._invalidateFlag=false;}};
M.prototype.onsaptabprevious=function(i){if(this.getType()===G.Light){return;}if(i.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget==null){q(this.$().find(":sapTabbable")[0]).trigger("focus");i.preventDefault();i.setMarked();return;}if(i.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget!=null&&this._previousTarget.id!=i.target.id){q(this._previousTarget).trigger("focus");i.preventDefault();i.setMarked();return;}if(i.target.id.indexOf("add")>=0||i.target.parentNode.className=="sapMFFHead"){this._previousTarget=i.target;q(this.$().find(":sapTabbable")[0]).trigger("focus");}};
M.prototype.onsapend=function(i){if(this.getType()===G.Light){return;}if(this._addTarget!=null){q(this._addTarget).trigger("focus");i.preventDefault();i.setMarked();}else{q(this._aRows[this._aRows.length-1]).trigger("focus");i.preventDefault();i.setMarked();}this._previousTarget=i.target;};
M.prototype.onsaphome=function(i){if(this.getType()===G.Light){return;}q(this._aRows[0]).trigger("focus");i.preventDefault();i.setMarked();this._previousTarget=i.target;};
M.prototype.onsappageup=function(i){this._previousTarget=i.target;};
M.prototype.onsappagedown=function(i){this._previousTarget=i.target;};
M.prototype.onsapincreasemodifiers=function(i){if(this.getType()===G.Light){return;}if(i.which==K.ARROW_RIGHT){this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()-1;var k=j+this._pageSize;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(k);this.focus();}};
M.prototype.onsapdecreasemodifiers=function(i){if(this.getType()===G.Light){return;}var j=0;if(i.which==K.ARROW_LEFT){this._previousTarget=i.target;j=this.oItemNavigation.getFocusedIndex()+1;var k=j-this._pageSize;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(k);this.focus();}};
M.prototype.onsapdownmodifiers=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;var j=0;j=this.oItemNavigation.getFocusedIndex()-1;var k=j+this._pageSize;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(k);this.focus();};
M.prototype.onsapupmodifiers=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;var j=0;j=this.oItemNavigation.getFocusedIndex();if(j!=0){j=j+1;}var k=j-this._pageSize;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(k);this.focus();};
M.prototype.onsapexpand=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()+1;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(j);this.focus();};
M.prototype.onsapcollapse=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()-1;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(j);this.focus();};
M.prototype.onsapdown=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).trigger("focus");i.preventDefault();i.setMarked();return;}};
M.prototype.onsapup=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).trigger("focus");i.preventDefault();i.setMarked();}};
M.prototype.onsapleft=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).trigger("focus");i.preventDefault();i.setMarked();}var j=this.oItemNavigation.aItemDomRefs,k=this.oItemNavigation.getFocusedIndex(),Q=k-1>=0?k-1:k,R=q(j[Q]).control(0),U=this._calculateScrollIntoView(R);this._scroll(U,H);};
M.prototype.onsapright=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).trigger("focus");i.preventDefault();i.setMarked();}var j=this.oItemNavigation.aItemDomRefs,k=this.oItemNavigation.getFocusedIndex(),Q=j.length>k+1?k+1:k,R=q(j[Q]).control(0),U=this._calculateScrollIntoView(R);this._scroll(U,H);};
M.prototype.onsapescape=function(i){if(this.getType()===G.Light){return;}if(i.target.parentNode.className=="sapMFFResetDiv"){return;}var j=this._lastCategoryFocusIndex;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(j);this.focus();};
M.prototype._getPopover=function(){var i=this.getAggregation("popover");if(!i){var j=this;i=new P({placement:A.Bottom,beforeOpen:function(Q){if(j._displayedList){j._displayedList._bSearchEventDefaultBehavior&&j._displayedList._setSearchValue("");}this.setCustomHeader(j._createFilterItemsSearchFieldBar(j._displayedList));var R=this.getSubHeader();if(!R){this.setSubHeader(j._createSelectAllCheckboxBar(j._displayedList));}k(j._displayedList);},beforeClose:function(){j._popoverClosing=true;},afterClose:function(Q){this._popoverClosing=false;j._handlePopoverAfterClose();},horizontalScrolling:false});this.setAggregation("popover",i,true);i.setContentWidth("30%");i.addStyleClass("sapMFFPop");var k=function(Q){if(!Q){return;}var R=j._getFacetRemoveIcon(Q);if(R){R._bTouchStarted=false;}};}if(this.getShowPopoverOKButton()){this._addOKButtonToPopover(i);}else{i.destroyAggregation("footer");}return i;};
M.prototype._handlePopoverAfterClose=function(){var i=this.getAggregation("popover"),j=this._displayedList;if(!i){return;}var k=this._getFacetRemoveIcon(j);if(k&&k._bTouchStarted){return;}this._restoreListFromDisplayContainer(i);this._displayRemoveIcon(false,j);j._fireListCloseEvent();this._fireConfirmEvent();this.destroyAggregation("popover");if(this._oOpenPopoverDeferred){setTimeout(function(){this._oOpenPopoverDeferred.resolve();this._oOpenPopoverDeferred=undefined;}.bind(this),0);}};
M.prototype._fireConfirmEvent=function(){this.fireEvent('confirm');};
M.prototype._openPopover=function(i,j){var k;if(!i.isOpen()){var Q=sap.ui.getCore().byId(j.getAssociation("list"));h(Q,"The facet filter button should be associated with a list.");k=!Q.fireListOpen({});this._moveListToDisplayContainer(Q,i);i.openBy(j);if(Q.getShowRemoveFacetIcon()){this._displayRemoveIcon(true,Q);}if(Q.getWordWrap()){i.setContentWidth("30%");}if(!k){Q._applySearch();}}return this;};
M.prototype._getAddFacetButton=function(){var i=this.getAggregation("addFacetButton");if(!i){i=new B(this.getId()+"-add",{icon:I.getIconURI("add-filter"),type:z.Transparent,tooltip:this._bundle.getText("FACETFILTER_ADDFACET"),press:function(j){this.openFilterDialog();}.bind(this)});this.setAggregation("addFacetButton",i,true);}return i;};
M.prototype._getButtonForList=function(i){if(this._buttons[i.getId()]){this._setButtonText(i);return this._buttons[i.getId()];}var j=this;var k=new B({type:z.Transparent,press:function(Q){var R=this;var U=function(){var V=j._getPopover();j._openPopover(V,R);};if(i.getMode()===x.MultiSelect){i._preserveOriginalActiveState();}var V=j._getPopover();if(V.isOpen()){setTimeout(function(){if(V.isOpen()){return;}j._oOpenPopoverDeferred=q.Deferred();j._oOpenPopoverDeferred.promise().done(U);},100);}else{setTimeout(U.bind(this),100);}}});this._buttons[i.getId()]=k;this.addAggregation("buttons",k);k.setAssociation("list",i.getId(),true);this._setButtonText(i);return k;};
M.prototype._setButtonText=function(i){var j=this._buttons[i.getId()];if(i._iAllItemsCount===undefined&&i.getMaxItemsCount()||!i._bSearchEventDefaultBehavior){i._iAllItemsCount=i.getMaxItemsCount();}if(j){var k="";var Q=Object.getOwnPropertyNames(i._oSelectedKeys);var R=Q.length;if(R===1){var U=i._oSelectedKeys[Q[0]];k=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[i.getTitle(),U]);}else if(R>0&&R===(i._iAllItemsCount?i._iAllItemsCount:0)){k=this._bundle.getText("FACETFILTER_ALL_SELECTED",[i.getTitle()]);}else if(R>0){k=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[i.getTitle(),R]);}else{k=i.getTitle();}j.setText(k);}};
M.prototype._getFacetRemoveIcon=function(i){var j=this,k=this._removeFacetIcons[i.getId()];if(!k){k=new e({src:I.getIconURI("decline"),tooltip:this._bundle.getText("FACETFILTER_REMOVE"),press:function(){k._bPressed=true;}});k.addDelegate({ontouchstart:function(){k._bTouchStarted=true;k._bPressed=false;},ontouchend:function(){j._displayRemoveIcon(false,i);k._bTouchStarted=false;setTimeout(Q.bind(this),100);}},true);var Q=function(){if(k._bPressed){i.removeSelections(true);i.setSelectedKeys();i.setProperty("active",false,true);}j._handlePopoverAfterClose();};k.setAssociation("list",i.getId(),true);k.addStyleClass("sapMFFLRemoveIcon");this._removeFacetIcons[i.getId()]=k;this.addAggregation("removeFacetIcons",k);this._displayRemoveIcon(false,i);}return k;};
M.prototype._displayRemoveIcon=function(i,j){if(this.getShowPersonalization()){var k=this._removeFacetIcons[j.getId()];if(i){k.removeStyleClass("sapMFFLHiddenRemoveIcon");k.addStyleClass("sapMFFLVisibleRemoveIcon");}else{k.removeStyleClass("sapMFFLVisibleRemoveIcon");k.addStyleClass("sapMFFLHiddenRemoveIcon");}}};
M.prototype._getFacetDialogNavContainer=function(){var i=new N({autoFocus:false});var j=this._createFacetPage();i.addPage(j);i.setInitialPage(j);i.attachAfterNavigate(function(k){var Q=k.getParameters()["to"];var R=k.getParameters()['from'];if(R===j){var U=(this._displayedList.getMode()===x.MultiSelect)?Q.getContent(0)[1].getItems()[0]:Q.getContent(0)[0].getItems()[0];if(U){U.focus();}else if(Q.getContent()[1]){Q.getContent()[1].focus();}}if(Q===j){R.destroySubHeader();h(this._displayedList===null,"Filter items list should have been placed back in the FacetFilter aggregation before page content is destroyed.");R.destroyContent();this._selectedFacetItem.invalidate();Q.invalidate();this._selectedFacetItem.focus();this._selectedFacetItem=null;}}.bind(this));return i;};
M.prototype._createFacetPage=function(){var i=this._createFacetList();var j=new S({width:"100%",tooltip:this._bundle.getText("FACETFILTER_SEARCH"),liveChange:function(Q){var R=i.getBinding("items");if(R){var U=new F("text",f.Contains,Q.getParameters()["newValue"]);R.filter([U]);}}});var k=new u({enableScrolling:true,title:this._bundle.getText("FACETFILTER_TITLE"),subHeader:new o({contentMiddle:j}),content:[i]});return k;};
M.prototype._createFilterItemsPage=function(){var i=new u({showNavButton:true,enableScrolling:true,navButtonPress:function(j){var k=j.getSource().getParent();this._navFromFilterItemsPage(k);}.bind(this)});return i;};
M.prototype._getFilterItemsPage=function(i){var j=i.getPages()[1];if(j){i.removePage(j);j.destroy();}var k=this._createFilterItemsPage();i.addPage(k);return k;};
M.prototype._createFilterItemsSearchFieldBar=function(i){var j=true;if(i.getDataType()!=y.String){j=false;}var k=new S({value:i._getSearchValue(),width:"100%",enabled:j,tooltip:this._bundle.getText("FACETFILTER_SEARCH"),search:function(R){this._displayedList._handleSearchEvent(R);}.bind(this)});if(this.getLiveSearch()){k.attachLiveChange(i._handleSearchEvent,i);}var Q=new o({contentMiddle:k});i.setAssociation("search",k);return Q;};
M.prototype._getFacetDialog=function(){var i=this.getAggregation("dialog");if(!i){var j=this;i=new p({showHeader:false,stretch:D.system.phone?true:false,afterClose:function(){j._invalidateFlag=true;var k=this.getContent()[0];var Q=k.getPages()[1];if(k.getCurrentPage()===Q){var R=j._restoreListFromDisplayContainer(Q);if(R.getMode()===x.MultiSelect){R._updateActiveState();j._bCheckForAddListBtn=true;}R._fireListCloseEvent();R._bSearchEventDefaultBehavior&&R._search("");}this.destroyAggregation("content",true);j.invalidate();},beginButton:new B({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),press:function(){j._closeDialog();}}),contentHeight:"500px",ariaLabelledBy:[c.getStaticId("sap.m","FACETFILTER_AVAILABLE_FILTER_NAMES")]});i.addStyleClass("sapMFFDialog");i.onsapentermodifiers=function(k){if(k.shiftKey&&!k.ctrlKey&&!k.altKey){var Q=this.getContent()[0];j._navFromFilterItemsPage(Q);}};this.setAggregation("dialog",i,true);}return i;};
M.prototype._closeDialog=function(){var i=this.getAggregation("dialog");if(i&&i.isOpen()){i.close();this._fireConfirmEvent();}};
M.prototype._closePopover=function(){var i=this.getAggregation("popover");if(i&&i.isOpen()){i.close();}};
M.prototype._createFacetList=function(){var j=this._oFacetList=new r({mode:x.None,items:{path:"/items",template:new s({title:"{text}",counter:"{count}",type:w.Navigation,customData:[new a({key:"index",value:"{index}"})]})}});var k=this._getMapFacetLists();var Q=new J({items:k});if(k.length>100){Q.setSizeLimit(k.length);}var R=this;j.attachUpdateFinished(function(){for(var i=0;i<j.getItems().length;i++){var U=this.getItems()[i];U.detachPress(R._handleFacetListItemPress,R);U.attachPress(R._handleFacetListItemPress,R);}});j.setModel(Q);return j;};
M.prototype.refreshFacetList=function(){this._oFacetList.getModel().setData({items:this._getMapFacetLists()});return this;};
M.prototype._getMapFacetLists=function(){return this.getLists().map(function(i,j){return{text:i.getTitle(),count:i.getAllCount(),index:j};});};
M.prototype._createSelectAllCheckboxBar=function(i){if(!i.getMultiSelect()){return null;}var j=i.getActive()&&i.getItems().length>0&&Object.getOwnPropertyNames(i._oSelectedKeys).length===i.getItems().length;var k=new t(i.getId()+"-selectAll",{text:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),tooltip:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),selected:j,select:function(R){k.setSelected(R.getParameter("selected"));i._handleSelectAllClick(R.getParameter("selected"));}});i.setAssociation("allcheckbox",k);var Q=new o({visible:Boolean(i.getItems(true).length)});Q.addEventDelegate({ontap:function(R){if(R.srcControl===this){i._handleSelectAllClick(k.getSelected());}}},Q);Q.addContentLeft(k);Q.addStyleClass("sapMFFCheckbar");this._oAllCheckBoxBar=Q;return Q;};
M.prototype._handleFacetListItemPress=function(i){this._navToFilterItemsPage(i.getSource());};
M.prototype._navToFilterItemsPage=function(i){this._selectedFacetItem=i;var j=this.getAggregation("dialog").getContent()[0];var k=i.getCustomData();h(k.length===1,"There should be exactly one custom data for the original facet list item index");var Q=k[0].getValue();var R=this.getLists()[Q];this._listIndexAgg=this.indexOfAggregation("lists",R);if(this._listIndexAgg==Q){var U=this._getFilterItemsPage(j);R.fireListOpen({});this._moveListToDisplayContainer(R,U);U.setSubHeader(this._createFilterItemsSearchFieldBar(R));var V=this._createSelectAllCheckboxBar(R);if(V){U.insertContent(V,0);}U.setTitle(R.getTitle());j.to(U);}};
M.prototype._navFromFilterItemsPage=function(i){var j=i.getPages()[1];var k=this._restoreListFromDisplayContainer(j);if(k.getMode()===x.MultiSelect){k._updateActiveState();}k._fireListCloseEvent();k._bSearchEventDefaultBehavior&&k._search("");this._selectedFacetItem.setCounter(k.getAllCount());i.backToTop();};
M.prototype._moveListToDisplayContainer=function(i,j){this._listAggrIndex=this.indexOfAggregation("lists",i);h(this._listAggrIndex>-1,"The lists index should be valid.");C.prototype.removeAggregation.call(this,"lists",i,true);j.addAggregation("content",i,false);i.setAssociation("facetFilter",this,true);this._displayedList=i;};
M.prototype._restoreListFromDisplayContainer=function(i){var j=i.removeAggregation("content",this._displayedList,true);this.insertAggregation("lists",j,this._listAggrIndex,j.getActive());this._listAggrIndex=-1;this._displayedList=null;return j;};
M.prototype._getSequencedLists=function(){var k=-1;var Q=[];var R=this.getLists();if(R.length>0){for(var i=0;i<R.length;i++){if(R[i].getActive()){if(R[i].getSequence()<-1){R[i].setSequence(-1);}else if(R[i].getSequence()>k){k=R[i].getSequence();}Q.push(R[i]);}else if(!R[i].getRetainListSequence()){R[i].setSequence(-1);}}for(var j=0;j<Q.length;j++){if(Q[j].getSequence()<=-1){k+=1;Q[j].setSequence(k);}}if(Q.length>1){Q.sort(function(U,V){return U.getSequence()-V.getSequence();});}}return Q;};
M.prototype._getSummaryBar=function(){var i=this.getAggregation("summaryBar"),j=this.getType();if(!i){var k=new m({maxLines:1});i=new n({content:[k],active:j===G.Light?true:false,design:v.Info,ariaLabelledBy:k,press:function(Q){this.openFilterDialog();}.bind(this)});i._setRootAccessibilityRole("group");this.setAggregation("summaryBar",i);}return i;};
M.prototype._handleReset=function(){this.fireReset();this.invalidate();};
M.prototype._createResetButton=function(){var j=new B({type:z.Transparent,icon:I.getIconURI("undo"),tooltip:this._bundle.getText("FACETFILTER_RESET"),press:function(k){this._invalidateFlag=true;if(this._popoverClosing){setTimeout(this._handleReset.bind(this),P.prototype._getAnimationDuration());}else{this._handleReset();}var Q=this.getLists();for(var i=0;i<Q.length;i++){Q[i]._setSearchValue("");Q[i]._applySearch();var R=Q[i].getItems()[0];if(R){R.focus();}}}.bind(this)});return j;};
M.prototype._addOKButtonToPopover=function(i){var j=i.getFooter(),k;if(!j){k=new B({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),press:function(){this._closePopover();}.bind(this)});j=new O({content:[new T(),k]});i.setFooter(j);}};
M.prototype._getSummaryText=function(){var k=", ";var Q=" ";var R="";var U=true;var V=this.getLists();if(V.length>0){for(var i=0;i<V.length;i++){var W=V[i];if(W.getActive()){var X=this._getSelectedItemsText(W);var Y="";for(var j=0;j<X.length;j++){Y=Y+X[j]+k;}if(Y){Y=Y.substring(0,Y.lastIndexOf(k)).trim();if(U){R=this._bundle.getText("FACETFILTER_INFOBAR_FILTERED_BY",[W.getTitle(),Y]);U=false;}else{R=R+Q+this._bundle.getText("FACETFILTER_INFOBAR_AND")+Q+this._bundle.getText("FACETFILTER_INFOBAR_AFTER_AND",[W.getTitle(),Y]);}}}}}if(!R){R=this._bundle.getText("FACETFILTER_INFOBAR_NO_FILTERS");}return R;};
M.prototype._getSelectedItemsText=function(i){var j=i.getSelectedItems().map(function(k){return k.getText();});i._oSelectedKeys&&Object.getOwnPropertyNames(i._oSelectedKeys).forEach(function(k){j.indexOf(i._oSelectedKeys[k])===-1&&j.push(i._oSelectedKeys[k]);});return j;};
M.prototype._addResetToSummary=function(i){if(i.getContent().length===1){i.addContent(new T({width:""}));var j=this._createResetButton();i.addContent(j);j.addStyleClass("sapUiSizeCompact");j.addStyleClass("sapMFFRefresh");j.addStyleClass("sapMFFBtnHoverable");}};
M.prototype._removeResetFromSummary=function(i){if(i.getContent().length===3){var j=i.removeAggregation("content",1);j.destroy();var k=i.removeAggregation("content",1);k.destroy();}};
M.prototype._removeList=function(i){if(i){var j=this._buttons[i.getId()];if(j){this.removeAggregation("buttons",j);j.destroy();}var R=this._removeFacetIcons[i.getId()];if(R){this.removeAggregation("removeIcons",R);R.destroy();}delete this._buttons[i.getId()];delete this._removeFacetIcons[i.getId()];}};
M.prototype._calculateScrollIntoView=function(i){var j=this.$("head").width(),k=0;if(!j||!i){return k;}var $=i.$(),Q=$.outerWidth(true),R=$.position().left,U=R+Q;if(U>j){k=U-j;}else if(R<0){k=R;}return k;};
M.prototype._getScrollingArrow=function(j){var k=null;var Q={src:"sap-icon://navigation-"+j+"-arrow"};if(j==="left"){k=this.getAggregation("arrowLeft");if(!k){Q.id=this.getId()+"-arrowScrollLeft";k=I.createControlByURI(Q);var R=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollLeft"];for(var i=0;i<R.length;i++){k.addStyleClass(R[i]);k.setTooltip(this._bundle.getText("FACETFILTER_PREVIOUS"));}this.setAggregation("arrowLeft",k);}}else if(j==="right"){k=this.getAggregation("arrowRight");if(!k){Q.id=this.getId()+"-arrowScrollRight";k=I.createControlByURI(Q);var U=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollRight"];for(var i=0;i<U.length;i++){k.addStyleClass(U[i]);k.setTooltip(this._bundle.getText("FACETFILTER_NEXT"));}this.setAggregation("arrowRight",k);}}else{L.error("Scrolling arrow name "+j+" is not valid");}return k;};
M.prototype._checkOverflow=function(){var i=this.getDomRef("head"),$=q(i),j=this.$(),k=false,Q=false,R=false,U=null,V=null,W=null;if(i){U=i.scrollLeft;V=i.scrollWidth;W=i.clientWidth;if(V>W){if(V-W==1){V=W;}else{R=true;}}j.toggleClass("sapMFFScrolling",R);j.toggleClass("sapMFFNoScrolling",!R);this._lastScrolling=R;if(!this._bRtl){k=U>0;Q=(V>W)&&(V>U+W);}else{Q=$.scrollLeftRTL()>0;k=$.scrollRightRTL()>0;}if((Q!=this._bPreviousScrollForward)||(k!=this._bPreviousScrollBack)){j.toggleClass("sapMFFNoScrollBack",!k);j.toggleClass("sapMFFNoScrollForward",!Q);}}};
M.prototype.onclick=function(i){var j=i.target,k=this.getId();if(!j.id){j=j.parentElement;}if(!j.id){return;}i.preventDefault();if(j.id==k+"-arrowScrollLeft"){j.tabIndex=-1;j.focus();this._scroll(-M.SCROLL_STEP,H);}else if(j.id==k+"-arrowScrollRight"){j.tabIndex=-1;j.focus();this._scroll(M.SCROLL_STEP,H);}};
M.prototype._scroll=function(i,j){var k=this.getDomRef("head");var Q=k.scrollLeft;if(this._bRtl){i=-i;}var R=Q+i;q(k).stop(true,true).animate({scrollLeft:R},j);};
M.prototype._enableTouchSupport=function(){var i=function(Q){var R=this.getType();if(R===G.Light){return;}Q.preventDefault();if(this._iInertiaIntervalId){window.clearInterval(this._iInertiaIntervalId);}this.startScrollX=this.getDomRef("head").scrollLeft;this.startTouchX=Q.touches[0].pageX;this._bTouchNotMoved=true;this._lastMoveTime=new Date().getTime();}.bind(this);var j=function(Q){var R=this.getType();if(R===G.Light){return;}var U=Q.touches[0].pageX-this.startTouchX;var V=this.getDomRef("head");var W=V.scrollLeft;var X=this.startScrollX-U;V.scrollLeft=X;this._bTouchNotMoved=false;var Y=new Date().getTime()-this._lastMoveTime;this._lastMoveTime=new Date().getTime();if(Y>0){this._velocity=(X-W)/Y;}Q.preventDefault();}.bind(this);var k=function(Q){var R=this.getType();if(R===G.Light){return;}if(this._bTouchNotMoved===false){Q.preventDefault();var U=this.getDomRef("head");var V=50;var W=Math.abs(this._velocity/10);this._iInertiaIntervalId=window.setInterval(function(){this._velocity=this._velocity*0.80;var X=this._velocity*V;U.scrollLeft=U.scrollLeft+X;if(Math.abs(this._velocity)<W){window.clearInterval(this._iInertiaIntervalId);this._iInertiaIntervalId=undefined;}}.bind(this),V);}else if(this._bTouchNotMoved===true){this.onclick(Q);Q.preventDefault();}this._bTouchNotMoved=undefined;this._lastMoveTime=undefined;}.bind(this);this.addEventDelegate({ontouchstart:i},this);this.addEventDelegate({ontouchend:k},this);this.addEventDelegate({ontouchmove:j},this);};
return M;});
sap.ui.predefine('sap/m/FacetFilterItem',['./ListItemBase','./library','./FacetFilterItemRenderer'],function(L,l,F){"use strict";
var a=L.extend("sap.m.FacetFilterItem",{metadata:{library:"sap.m",properties:{key:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},count:{type:"int",group:"Misc",defaultValue:null,deprecated:true}}}});
a.prototype.setCount=function(c){this.setProperty("count",c);this.setProperty("counter",c);return this;};
a.prototype.setCounter=function(c){this.setProperty("count",c);this.setProperty("counter",c);return this;};
a.prototype.init=function(){this.attachEvent("_change",this._itemTextChange);L.prototype.init.apply(this);this.addStyleClass("sapMFFLI");};
a.prototype.exit=function(){L.prototype.exit.apply(this);this.detachEvent("_change",this._itemTextChange);};
a.prototype._itemTextChange=function(e){if(e.getParameter("name")==="text"){this.informList("TextChange",e.getParameter("newValue"));}};
return a;});
sap.ui.predefine('sap/m/FacetFilterItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer'],function(L,R){"use strict";var F=R.extend(L);F.apiVersion=2;
F.renderLIContent=function(r,c){r.openStart("div",c);if(c.getParent()&&c.getParent().getWordWrap()){r.class("sapMFFLITitleWrap");}else{r.class("sapMFFLITitle");}r.openEnd();r.text(c.getText());r.close("div");};
return F;},true);
sap.ui.predefine('sap/m/FacetFilterList',['./List','./library','sap/ui/model/ChangeReason','sap/ui/model/Filter','./FacetFilterListRenderer','./FacetFilterItem',"sap/base/Log","sap/ui/model/FilterOperator","sap/ui/model/FilterType"],function(L,l,C,F,a,b,c,d,e){"use strict";var f=l.ListMode;var g=l.FacetFilterListDataType;
var h=L.extend("sap.m.FacetFilterList",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},wordWrap:{type:"boolean",group:"Appearance",defaultValue:false},multiSelect:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},active:{type:"boolean",group:"Behavior",defaultValue:true},enableCaseInsensitiveSearch:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:false},allCount:{type:"int",group:"Appearance",defaultValue:null},sequence:{type:"int",group:"Behavior",defaultValue:-1},key:{type:"string",group:"Identification",defaultValue:null},showRemoveFacetIcon:{type:"boolean",group:"Misc",defaultValue:true},retainListSequence:{type:"boolean",group:"Misc",defaultValue:false},dataType:{type:"sap.m.FacetFilterListDataType",group:"Misc",defaultValue:g.String}},events:{listOpen:{allowPreventDefault:true},listClose:{parameters:{selectedItems:{type:"sap.m.FacetFilterItem[]"},allSelected:{type:"boolean"},selectedKeys:{type:"object"}}},search:{allowPreventDefault:true,parameters:{term:{type:"string"}}}}}});
h.prototype.setTitle=function(t){this.setProperty("title",t,true);this._updateFacetFilterButtonText();return this;};
h.prototype.setMultiSelect=function(v){this.setProperty("multiSelect",v,true);var m=v?f.MultiSelect:f.SingleSelectMaster;this.setMode(m);return this;};
h.prototype.setMode=function(m){if(m===f.MultiSelect||m===f.SingleSelectMaster){L.prototype.setMode.call(this,m);this.setProperty("multiSelect",m===f.MultiSelect?true:false,true);}return this;};
h.prototype._applySearch=function(){var s=this._getSearchValue();if(s===null){return;}this._bSearchEventDefaultBehavior&&this._search(s,true);this._updateSelectAllCheckBox();};
h.prototype.getSelectedItems=function(){var s=[];var o={};var i=L.prototype.getSelectedItems.apply(this,arguments);i.forEach(function(I){s.push(new b({text:I.getText(),key:I.getKey(),selected:true}));o[I.getKey()]=true;});var S=this.getSelectedKeys();var j=Object.getOwnPropertyNames(S);if(i.length<j.length){j.forEach(function(k){if(!o[k]){s.push(new b({text:S[k],key:k,selected:true}));}});}return s;};
h.prototype.getSelectedItem=function(){var i=L.prototype.getSelectedItem.apply(this,arguments);var s=Object.getOwnPropertyNames(this.getSelectedKeys());if(!i&&s.length>0){i=new b({text:this.getSelectedKeys()[s[0]],key:s[0],selected:true});}return i;};
h.prototype.removeSelections=function(A){if(this._allowRemoveSelections){A?this.setSelectedKeys():L.prototype.removeSelections.call(this,A);}return this;};
h.prototype.getSelectedKeys=function(){var r={};var k=this._oSelectedKeys;Object.getOwnPropertyNames(k).forEach(function(i){r[i]=k[i];});return r;};
h.prototype.setSelectedKeys=function(k){this._oSelectedKeys={};var K=false;k&&Object.getOwnPropertyNames(k).forEach(function(i){this._addSelectedKey(i,k[i]);K=true;},this);if(K){if(this.getMode()===f.MultiSelect){this.setActive(true);}this._selectItemsByKeys();}else{L.prototype.removeSelections.call(this);}};
h.prototype._getNonGroupItems=function(){var i=[];this.getItems().forEach(function(I){if(I.getMode()!==f.None){i.push(I);}});return i;};
h.prototype.removeSelectedKey=function(k,t){if(this._removeSelectedKey(k,t)){this._getNonGroupItems().forEach(function(i){var I=i.getKey()||i.getText();k===I&&i.setSelected(false);});}};
h.prototype.removeSelectedKeys=function(){this._oSelectedKeys={};L.prototype.removeSelections.call(this,true);};
h.prototype.removeItem=function(i){var I=L.prototype.removeItem.apply(this,arguments);if(!this._filtering){I&&I.getSelected()&&this.removeSelectedKey(I.getKey(),I.getText());return I;}};
h.prototype.init=function(){this._firstTime=true;this._bSearchEventDefaultBehavior=true;this._saveBindInfo;this._oSelectedKeys={};L.prototype.init.call(this);this.setMode(f.MultiSelect);this.setIncludeItemInSelection(true);this.setGrowing(true);this.setRememberSelections(false);this._searchValue="";this.attachUpdateFinished(function(E){var u=E.getParameter("reason");u=u?u.toLowerCase():u;if(u==="change"){var B=this.getBinding("items"),m=B?B.getModel():null;if(m&&m.getProperty(B.getPath())){this._iAllItemsCount=m.getProperty(B.getPath()).length||0;}this._oSelectedKeys={};this._getNonGroupItems().forEach(function(i){if(i.getSelected()){this._addSelectedKey(i.getKey(),i.getText());}},this);}if(u!==C.Filter.toLowerCase()){this._selectItemsByKeys();}this._updateFacetFilterButtonText();this._updateSelectAllCheckBox();});this._allowRemoveSelections=true;this._bOriginalActiveState;this._iAllItemsCount;};
h.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._setSearchValue("");this._allowRemoveSelections=false;L.prototype._resetItemsBinding.apply(this,arguments);this._allowRemoveSelections=true;}};
h.prototype._fireListCloseEvent=function(){var s=this.getSelectedItems();var S=this.getSelectedKeys();var A=this.isAllSelectableSelected();this._firstTime=true;this.fireListClose({selectedItems:s,selectedKeys:S,allSelected:A});};
h.prototype._updateActiveState=function(){var o=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));if(Object.getOwnPropertyNames(this._oSelectedKeys).length>0||(o&&o.getSelected())){this.setActive(true);}};
h.prototype._handleSearchEvent=function(E){var s=E.getParameters()["query"];if(s===undefined){s=E.getParameters()["newValue"];}this._bSearchEventDefaultBehavior=this.fireSearch({term:s,clearButtonPressed:E.getParameters()["clearButtonPressed"]});this._bSearchEventDefaultBehavior?this._search(s):this._setSearchValue(s);this._updateSelectAllCheckBox();};
h.prototype._search=function(s,i){var j,B,u,U,p,o,P,k,n=0,m=this.getBinding("items"),q=this.getBindingInfo("items");function r(M){return M instanceof sap.ui.model.odata.ODataModel||M instanceof sap.ui.model.odata.v2.ODataModel||M instanceof sap.ui.model.odata.v4.ODataModel;}if(i||(s!==this._searchValue)){this._searchValue=s;if(q&&q.binding){j=q.binding.aFilters;if(j.length>0){n=j[0].aFilters.length;if(this._firstTime){this._saveBindInfo=j[0].aFilters[0][0];this._firstTime=false;}}}if(m){if(s||n>0){k=q.template?q.template:q.factory();B=k.getBindingInfo("text").parts;p=B[0].path;if(p||p===""){u=[];B.forEach(function(t){u.push(new F(t.path,d.Contains,s));});if(this.getEnableCaseInsensitiveSearch()&&r(m.getModel())){u.forEach(function(t){t.bCaseSensitive=false;});}P=new F(u,false);if(n>1){o=new F([P,this._saveBindInfo],true);}else{if(this._saveBindInfo>""&&U.sPath!=this._saveBindInfo.sPath){o=new F([P,this._saveBindInfo],true);}else{if(s==""){o=[];}else{o=new F([P],true);}}}m.filter(o,e.Control);}}else{m.filter([],e.Control);}}else{c.warning("No filtering performed","The list must be defined with a binding for search to work",this);}}};
h.prototype._getSearchValue=function(){return this._searchValue;};
h.prototype._updateSelectAllCheckBox=function(){var i=this._getNonGroupItems(),I=i.length,o,A,s;function j(k){return k.getSelected();}if(this.getMultiSelect()){o=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));A=I>0&&I===i.filter(j).length;s=this.getActive()&&A;o&&o.setSelected(s);}};
h.prototype._addSelectedKey=function(k,t){if(!k&&!t){c.error("Both sKey and sText are not defined. At least one must be defined.");return;}if(this.getMode()===f.SingleSelectMaster){this.removeSelectedKeys();}if(!k){k=t;}this._oSelectedKeys[k]=t||k;};
h.prototype._removeSelectedKey=function(k,t){if(!k&&!t){c.error("Both sKey and sText are not defined. At least one must be defined.");return false;}if(!k){k=t;}delete this._oSelectedKeys[k];return true;};
h.prototype._setSearchValue=function(v){this._searchValue=v;};
h.prototype._isItemSelected=function(i){return!!(this._oSelectedKeys[i&&(i.getKey()||i.getText())]);};
h.prototype._updateFacetFilterButtonText=function(){if(this.getParent()&&this.getParent()._setButtonText){this.getParent()._setButtonText(this);}};
h.prototype._selectItemsByKeys=function(){this._getNonGroupItems().forEach(function(i){i.setSelected(this._isItemSelected(i));},this);this._updateFacetFilterButtonText();};
h.prototype._handleSelectAllClick=function(s){var A,i,I=this._getNonGroupItems(),j=I.length;I.forEach(function(o){if(s){this._addSelectedKey(o.getKey(),o.getText());}else{this._removeSelectedKey(o.getKey(),o.getText());}o.setSelected(s,true);},this);function k(o){return o.getSelected();}if(this.getMode()===f.MultiSelect){i=j>0&&j===I.filter(k).length;A=this._getOriginalActiveState()||(s&&i);this.setActive(A);}setTimeout(this._updateSelectAllCheckBox.bind(this),0);};
h.prototype.onItemTextChange=function(i,n){var k=i.getKey();if(this._oSelectedKeys[k]&&n&&!this._filtering){this._oSelectedKeys[k]=n;}};
h.prototype.onItemSelectedChange=function(i,s){var A;if(s){this._addSelectedKey(i.getKey(),i.getText());}else{this._removeSelectedKey(i.getKey(),i.getText());}L.prototype.onItemSelectedChange.apply(this,arguments);if(this.getMode()===f.MultiSelect){A=this._getOriginalActiveState()||s||this.getSelectedItems().length>1;this.setActive(A);}!this.getDomRef()&&this.getParent()&&this.getParent().getDomRef()&&this.getParent().invalidate();setTimeout(this._updateSelectAllCheckBox.bind(this),0);};
h.prototype.updateItems=function(r){var p=document.activeElement;this._filtering=r===C.Filter;L.prototype.updateItems.apply(this,arguments);this._filtering=false;if(p&&p.getAttribute("id")!==document.activeElement.getAttribute("id")){this.focus();}if(!this.getGrowing()||r===C.Filter){this._selectItemsByKeys();}};
h.prototype._getOriginalActiveState=function(){return this._bOriginalActiveState;};
h.prototype._preserveOriginalActiveState=function(){this._bOriginalActiveState=this.getActive();};
h.prototype._showBusyIndicator=function(){L.prototype._showBusyIndicator.apply(this,arguments);this.fireEvent("listItemsChange");};
h.prototype._hideBusyIndicator=function(){L.prototype._hideBusyIndicator.apply(this,arguments);this.fireEvent("listItemsChange");};
return h;});
sap.ui.predefine('sap/m/FacetFilterListRenderer',['./ListRenderer','sap/ui/core/Renderer'],function(L,R){"use strict";var F=R.extend(L);F.apiVersion=2;return F;},true);
sap.ui.predefine('sap/m/FacetFilterRenderer',["sap/m/library","sap/ui/Device","sap/ui/core/InvisibleText"],function(l,D,I){"use strict";var F=l.FacetFilterType;var a={apiVersion:2};
a.render=function(r,c){if(c.getType()===F.Light||c.getShowSummaryBar()){a.renderSummaryBar(r,c);}else{a.renderSimpleFlow(r,c);}};
a.renderSimpleFlow=function(r,c){r.openStart("div",c);r.class("sapMFF");r.accessibilityState({role:"toolbar",roledescription:c._bundle.getText("FACETFILTER_TITLE")});if(c._lastScrolling){r.class("sapMFFScrolling");}else{r.class("sapMFFNoScrolling");}if(c.getShowReset()){r.class("sapMFFResetSpacer");}r.openEnd();if(D.system.desktop){r.renderControl(c._getScrollingArrow("left"));}r.openStart("div",c.getId()+"-head");r.class("sapMFFHead");r.openEnd();a.renderFacetFilterListButtons(c,r);if(c.getShowPersonalization()){a.renderAddFilterButton(c,r);}r.close("div");if(D.system.desktop){r.renderControl(c._getScrollingArrow("right"));}if(c.getShowReset()){r.openStart("div");r.class("sapMFFResetDiv");r.openEnd();r.renderControl(c.getAggregation("resetButton"));r.close("div");}r.close("div");};
a.renderSummaryBar=function(r,c){r.openStart("div",c);r.class("sapMFF");r.openEnd();r.renderControl(c.getAggregation("summaryBar"));r.close("div");};
a.getAriaAnnouncement=function(k,b){return I.getStaticId("sap.m",b||"FACETFILTER_"+k.toUpperCase());};
a.renderFacetFilterListButtons=function(c,r){var L=c._getSequencedLists(),b=L.length,s=c.getShowPersonalization(),A=s&&(c.getType()===F.Simple),f=A?b+1:b,B,i;for(i=0;i<b;i++){var d=L[i].getItems().length>0,e=L[i].getActive(),g=c._bCheckForAddListBtn&&(d||e);if(!c._bCheckForAddListBtn||g){B=c._getButtonForList(L[i]);a.addPositionInfoForButton(c,B,i+1,f);if(s){B.addAriaDescribedBy(a.getAriaAnnouncement("ARIA_REMOVE"));}r.renderControl(B);if(s){r.renderControl(c._getFacetRemoveIcon(L[i]));}}}return this;};
a.renderAddFilterButton=function(c,r){var A=c.getAggregation("addFacetButton"),b=c._getSequencedLists().length+1;a.addPositionInfoForButton(c,A,b,b);r.renderControl(A);return this;};
a.addPositionInfoForButton=function(c,b,p,s){var S=a.createStaticPositioningLabel(c,p,s);a.clearOldPositioningLabels(c,b);b.addAriaDescribedBy(S);return this;};
a.clearOldPositioningLabels=function(c,b){var o=b.removeAllAriaDescribedBy(),r=this.getAriaAnnouncement("ARIA_REMOVE"),i;o.forEach(function(s){if(r===s){return;}i=sap.ui.getCore().byId(s);i&&i.destroy();});return this;};
a.createStaticPositioningLabel=function(c,p,s){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),f=r.getText("FACETFILTER_ARIA_FACET_FILTER"),P=r.getText("FACETFILTERLIST_ARIA_POSITION",[p,s]),S=new I({text:f+" "+P}).toStatic();c._aOwnedLabels.push(S.getId());return S;};
return a;},true);
sap.ui.predefine('sap/m/FeedContent',['./library','sap/ui/core/Control','sap/m/Text','sap/ui/Device','./FeedContentRenderer',"sap/ui/events/KeyCodes"],function(l,C,T,D,F,K){"use strict";var S=l.Size;
var a=C.extend("sap.m.FeedContent",{metadata:{library:"sap.m",properties:{"size":{type:"sap.m.Size",group:"Misc",defaultValue:S.Auto,deprecated:true},"contentText":{type:"string",group:"Misc",defaultValue:null},"subheader":{type:"string",group:"Misc",defaultValue:null},"value":{type:"string",group:"Misc",defaultValue:null},"valueColor":{type:"sap.m.ValueColor",group:"Misc",defaultValue:null},"truncateValueTo":{type:"int",group:"Misc",defaultValue:4}},defaultAggregation:"_contentTextAgr",aggregations:{"_contentTextAgr":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
a.prototype.init=function(){this._oContentText=new T(this.getId()+"-content-text",{maxLines:2});this._oContentText.cacheLineHeight=false;this.setAggregation("_contentTextAgr",this._oContentText,true);this.setTooltip("{AltText}");};
a.prototype.onBeforeRendering=function(){this.$().off("mouseenter");this.$().off("mouseleave");};
a.prototype.onAfterRendering=function(){this.$().on("mouseenter",this._addTooltip.bind(this));this.$().on("mouseleave",this._removeTooltip.bind(this));};
a.prototype.exit=function(){this._oContentText=null;};
a.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString());};
a.prototype._removeTooltip=function(){this.$().attr("title",null);};
a.prototype.getAltText=function(){var A="";var i=true;if(this.getAggregation("_contentTextAgr").getText()){A+=this.getAggregation("_contentTextAgr").getText();i=false;}if(this.getSubheader()){if(i){A+=""+this.getSubheader();}else{A+="\n"+this.getSubheader();}i=false;}if(this.getValue()){if(i){A+=""+this.getValue();}else{A+="\n"+this.getValue();}}return A;};
a.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var s=this.getAltText();if(typeof t==="string"||t instanceof String){s=t.split("{AltText}").join(s).split("((AltText))").join(s);return s;}if(t){return t;}else{return"";}};
a.prototype.setContentText=function(t){this._oContentText.setText(t);return this;};
a.prototype.ontap=function(e){if(D.browser.msie){this.$().trigger("focus");}this.firePress();};
a.prototype.onkeydown=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};
a.prototype.attachEvent=function(e,d,f,b){C.prototype.attachEvent.call(this,e,d,f,b);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");}return this;};
a.prototype.detachEvent=function(e,f,b){C.prototype.detachEvent.call(this,e,f,b);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");}return this;};
return a;});
sap.ui.predefine('sap/m/FeedContentRenderer',[],function(){"use strict";var F={apiVersion:2};
F.render=function(r,c){var s=c.getSubheader();var v=c.getValue();var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.openStart("div",c);r.attr("role","presentation");r.attr("aria-label",t);r.class("sapMFC");if(c.hasListeners("press")){r.attr("tabindex","0");r.class("sapMPointer");}r.openEnd();if(v){r.openStart("div",c.getId()+"-value");r.class("sapMFCValue");r.class(c.getValueColor());r.openEnd();var C=c.getTruncateValueTo();if(v.length>=C&&(v[C-1]==="."||v[C-1]===",")){r.text(v.substring(0,C-1));}else if(v){r.text(v.substring(0,C));}else{r.text("");}r.close("div");}r.openStart("div");r.class("sapMFCCTxt");r.openEnd();r.renderControl(c._oContentText);r.close("div");r.openStart("div",c.getId()+"-subheader");r.class("sapMFCSbh");r.openEnd();r.text(s);r.close("div");r.close("div");};
return F;},true);
sap.ui.predefine('sap/m/FeedInput',["./library","sap/ui/core/Control","sap/ui/core/IconPool","sap/m/TextArea","sap/m/Button","./FeedInputRenderer","sap/ui/thirdparty/jquery","sap/base/security/URLListValidator","sap/base/security/sanitizeHTML","sap/m/Avatar","sap/m/AvatarShape","sap/m/AvatarSize"],function(l,C,I,T,B,F,q,U,s,A,a,b){"use strict";var c=l.ButtonType;var M=15,d=2,e=0;
var f=C.extend("sap.m.FeedInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/FeedInput.designtime",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},rows:{type:"int",group:"Appearance",defaultValue:2},showExceededText:{type:"boolean",group:"Behavior",defaultValue:false},maxLength:{type:"int",group:"Behavior",defaultValue:0},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingMaxLines:{type:"int",group:"Behavior",defaultValue:0},placeholder:{type:"string",group:"Appearance",defaultValue:"Post something here"},value:{type:"string",group:"Data",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:a.Circle},iconInitials:{type:"string",defaultValue:""},iconSize:{type:"sap.m.AvatarSize",defaultValue:b.M},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},buttonTooltip:{type:"sap.ui.core.TooltipBase",group:"Accessibility",defaultValue:"Submit"},ariaLabelForPicture:{type:"string",group:"Accessibility",defaultValue:null}},aggregations:{_avatar:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"}},events:{post:{parameters:{value:{type:"string"}}}}}});
var _={ATTRIBS:{'style':1,'class':1,'a::href':1,'a::target':1},ELEMENTS:{'a':{cssClass:'sapMLnk'},'abbr':1,'blockquote':1,'br':1,'cite':1,'code':1,'em':1,'h1':{cssClass:'sapMTitle sapMTitleStyleH1'},'h2':{cssClass:'sapMTitle sapMTitleStyleH2'},'h3':{cssClass:'sapMTitle sapMTitleStyleH3'},'h4':{cssClass:'sapMTitle sapMTitleStyleH4'},'h5':{cssClass:'sapMTitle sapMTitleStyleH5'},'h6':{cssClass:'sapMTitle sapMTitleStyleH6'},'p':1,'pre':1,'strong':1,'span':1,'u':1,'dl':1,'dt':1,'dd':1,'ol':1,'ul':1,'li':1}};f.prototype._renderingRules=_;
function S(t,g){var h,v,j=t==="a";var k=this._renderingRules.ELEMENTS[t].cssClass||"";for(var i=0;i<g.length;i+=2){h=g[i];v=g[i+1];if(!this._renderingRules.ATTRIBS[h]&&!this._renderingRules.ATTRIBS[t+"::"+h]){g[i+1]=null;continue;}if(h=="href"){if(!U.validate(v)){g[i+1]="#";j=false;}}if(h=="target"){j=false;}if(k&&h.toLowerCase()=="class"){g[i+1]=k+" "+v;k="";}}if(j){g.push("target");g.push("_blank");}if(k){g.push("class");g.push(k);}return g;}
function p(t,g){return S.call(this,t,g);}
f.prototype._sanitizeHTML=function(t){return s(t,{tagPolicy:p.bind(this),uriRewriter:function(u){if(U.validate(u)){return u;}}});};
f.prototype.init=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setProperty("placeholder",o.getText("FEEDINPUT_PLACEHOLDER"),true);this.setProperty("buttonTooltip",o.getText("FEEDINPUT_SUBMIT"),true);};
f.prototype.exit=function(){if(this._oTextArea){this._oTextArea.destroy();}if(this._oButton){this._oButton.destroy();}if(this.oAvatar){this.oAvatar.destroy();}};
f.prototype.setRows=function(r){var m=this.getProperty("growingMaxLines");if(r>M){r=M;}else if(r<d){r=d;}if(r>m&&m!==0){this.setProperty("growingMaxLines",r,true);this._getTextArea().setGrowingMaxLines(r);}this.setProperty("rows",r,true);this._getTextArea().setRows(r);return this;};
f.prototype.setShowExceededText=function(v){this.setProperty("showExceededText",v,true);this._getTextArea().setShowExceededText(v);return this;};
f.prototype.setMaxLength=function(m){this.setProperty("maxLength",m,true);this._getTextArea().setMaxLength(m);return this;};
f.prototype.setGrowing=function(g){this.setProperty("growing",g,true);this._getTextArea().setGrowing(g);return this;};
f.prototype.setGrowingMaxLines=function(m){var r=this.getProperty("rows");if(m!==e){if(m<r){m=r;}else if(m>M){m=M;}}this.setProperty("growingMaxLines",m,true);this._getTextArea().setGrowingMaxLines(m);return this;};
f.prototype.setValue=function(v){this.setProperty("value",v,true);this._getTextArea().setValue(v);this._enablePostButton();return this;};
f.prototype.setPlaceholder=function(v){this.setProperty("placeholder",v,true);this._getTextArea().setPlaceholder(v);return this;};
f.prototype.setEnabled=function(E){this.setProperty("enabled",E,true);if(this.getDomRef("outerContainer")){if(E){this.getDomRef("outerContainer").classList.remove("sapMFeedInDisabled");}else{this.getDomRef("outerContainer").classList.add("sapMFeedInDisabled");}}this._getTextArea().setEnabled(E);this._enablePostButton();return this;};
f.prototype.setButtonTooltip=function(v){this.setProperty("buttonTooltip",v,true);this._getPostButton().setTooltip(v);return this;};
f.prototype._getTextArea=function(){var t=this;if(!this._oTextArea){this._oTextArea=new T(this.getId()+"-textArea",{value:this.getValue(),maxLength:this.getMaxLength(),placeholder:this.getPlaceholder(),growing:this.getGrowing(),growingMaxLines:this.getGrowingMaxLines(),showExceededText:this.getShowExceededText(),rows:this.getRows(),liveChange:q.proxy(function(E){var v=E.getParameter("value");this.setProperty("value",v,true);this._enablePostButton();},this)});this._oTextArea.setParent(this);this._oTextArea.addEventDelegate({onAfterRendering:function(){t.$("counterContainer").empty();t.$("counterContainer").html(t._oTextArea.getAggregation("_counter").$());}});}return this._oTextArea;};
f.prototype._getPostButton=function(){if(!this._oButton){this._oButton=new B(this.getId()+"-button",{enabled:false,type:c.Default,icon:"sap-icon://feeder-arrow",tooltip:this.getButtonTooltip(),press:q.proxy(function(){this._oTextArea.focus();this.firePost({value:this._sanitizeHTML(this.getValue())});this.setValue(null);},this)});this._oButton.setParent(this);}return this._oButton;};
f.prototype._enablePostButton=function(){var P=this._isControlEnabled();var o=this._getPostButton();o.setEnabled(P);};
f.prototype._isControlEnabled=function(){var v=this.getValue();return this.getEnabled()&&(typeof v==="string"||v instanceof String)&&v.trim().length>0;};
f.prototype._getAvatar=function(){var i=this.getIcon();var g=this.getId()+'-icon';this.oAvatar=this.getAggregation("_avatar");if(!this.oAvatar){this.oAvatar=new A({id:g,src:i,displayShape:this.getIconDisplayShape(),initials:this.getIconInitials(),displaySize:this.getIconSize()}).addStyleClass("sapMFeedInImage");if(i){this.oAvatar.addStyleClass("sapMFeedInImageBgColor");}}else{this.oAvatar.setSrc(i).setDisplayShape(this.getIconDisplayShape()).setInitials(this.getIconInitials()).setDisplaySize(this.getIconSize());}this.setAggregation("_avatar",this.oAvatar);return this.oAvatar;};
return f;});
sap.ui.predefine('sap/m/FeedInputRenderer',[],function(){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var F={apiVersion:2};
F.render=function(R,c){var m=c.getId();R.openStart("div",c);R.class("sapMFeedInBase");R.attr("role","group");R.attr("aria-label",r.getText("FEED_INPUT_ARIA_LABEL"));R.openEnd();R.openStart("div",m+"-outerContainer");R.class("sapMFeedIn");if(!c.getShowIcon()){R.class("sapMFeedInNoIcon");}if(!c.getEnabled()){R.class("sapMFeedInDisabled");}R.openEnd();if(c.getShowIcon()){this._addImage(R,c,m);}R.openStart("div",m+"-container");R.class("sapMFeedInContainer");R.openEnd();var t=c._getTextArea();R.renderControl(t);R.renderControl(c._getPostButton());R.close("div");R.close("div");R.openStart("div",m+"-counterContainer");R.class("sapMFeedInCounter");R.openEnd();R.close("div");R.close("div");};
F._addImage=function(R,c,m){R.openStart("figure",m+'-figure').class("sapMFeedInFigure");if(!c.getIcon()){R.class("sapMFeedListItemIsDefaultIcon");}R.openEnd();R.renderControl(c._getAvatar());R.close("figure");};
return F;},true);
sap.ui.predefine('sap/m/FeedListItem',["./ListItemBase","./Link","./library","./FormattedText","sap/ui/core/IconPool","sap/m/Button","sap/ui/Device","./FeedListItemRenderer","sap/m/Avatar","sap/m/AvatarShape","sap/m/AvatarSize"],function(L,a,l,F,I,B,D,b,A,c,d){"use strict";var e=l.ListType;var f=l.LinkConversion;var g=l.ButtonType;
var h=L.extend("sap.m.FeedListItem",{metadata:{library:"sap.m",designtime:"sap/m/designtime/FeedListItem.designtime",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:c.Circle},iconInitials:{type:"string",defaultValue:""},iconSize:{type:"sap.m.AvatarSize",defaultValue:d.S},activeIcon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},moreLabel:{type:"string",group:"Data",defaultValue:null},lessLabel:{type:"string",group:"Data",defaultValue:null},info:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},senderActive:{type:"boolean",group:"Behavior",defaultValue:true},iconActive:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",defaultValue:true},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:f.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},maxCharacters:{type:"int",group:"Behavior",defaultValue:null}},defaultAggregation:"actions",aggregations:{actions:{type:"sap.m.FeedListItemAction",multiple:true},_text:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_actionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_actionButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_avatar:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"}},events:{senderPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}},iconPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}}}}});
h._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");h._nMaxCharactersMobile=300;h._nMaxCharactersDesktop=500;h._sTextShowMore=h._oRb.getText("TEXT_SHOW_MORE");h._sTextShowLess=h._oRb.getText("TEXT_SHOW_LESS");
h.prototype.init=function(){L.prototype.init.apply(this);this.setAggregation("_text",new F(this.getId()+"-formattedText"),true);this.setAggregation("_actionButton",new B({id:this.getId()+"-actionButton",type:g.Transparent,icon:"sap-icon://overflow",press:[this._onActionButtonPress,this]}),true);};
h.prototype._onActionButtonPress=function(){sap.ui.require(["sap/m/ActionSheet"],this._openActionSheet.bind(this));};
h.prototype._openActionSheet=function(j){var o=this.getAggregation("_actionSheet");var k=this.getActions();var m;if(!(o&&o instanceof j)){o=new j({id:this.getId()+"-actionSheet",beforeOpen:[this._onBeforeOpenActionSheet,this]});this.setAggregation("_actionSheet",o,true);}o.destroyAggregation("buttons",true);for(var i=0;i<k.length;i++){m=k[i];o.addButton(new B({icon:m.getIcon(),text:m.getText(),visible:m.getVisible(),enabled:m.getEnabled(),press:m.firePress.bind(m,{"item":this})}));}o.openBy(this.getAggregation("_actionButton"));};
h.prototype._onBeforeOpenActionSheet=function(i){var o,t;if(D.system.phone){return;}t=sap.ui.getCore().getConfiguration().getTheme();o=i.getSource().getParent();o.removeStyleClass("sapContrast sapContrastPlus");if(t==="sap_belize"){o.addStyleClass("sapContrast");}else if(t==="sap_belize_plus"){o.addStyleClass("sapContrastPlus");}};
h.prototype.invalidate=function(){L.prototype.invalidate.apply(this,arguments);var m=h._sTextShowMore;if(this.getMoreLabel()){m=this.getMoreLabel();}delete this._bTextExpanded;if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.setProperty("text",m,true);}};
h.prototype.onBeforeRendering=function(){this.$("realtext").find('a[target="_blank"]').off("click");var o=this.getAggregation("_text");o.setProperty("convertLinksToAnchorTags",this.getConvertLinksToAnchorTags(),true);o.setProperty("convertedLinksDefaultTarget",this.getConvertedLinksDefaultTarget(),true);if(this.getConvertLinksToAnchorTags()===f.None){o.setHtmlText(this.getText());}else{o.setProperty("htmlText",this.getText(),true);}this._sFullText=o._getDisplayHtml().replace(/\n/g,"<br>");this._sShortText=this._getCollapsedText();if(this._sShortText){this._sShortText=this._sShortText.replace(/<br>/g," ");}this._bEmptyTagsInShortTextCleared=false;};
h.prototype.onAfterRendering=function(){if(document.getElementById(this.getAggregation("_actionButton"))){document.getElementById(this.getAggregation("_actionButton").getId()).setAttribute("aria-haspopup","menu");}if(this._checkTextIsExpandable()&&!this._bTextExpanded){this._clearEmptyTagsInCollapsedText();}var r=this.$("realtext");F.prototype.onAfterRendering.apply({$:function(){return r;}});};
h.prototype.exit=function(){this.$("realtext").find('a[target="_blank"]').off("click");if(this._oLinkControl){this._oLinkControl.destroy();}if(this.oAvatar){this.oAvatar.destroy();}if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.destroy();}L.prototype.exit.apply(this);};
h.prototype.ontap=function(E){if(E.srcControl){if((!this.getIconActive()&&this.oAvatar&&E.srcControl.getId()===this.oAvatar.getId())||(!this.getSenderActive()&&this._oLinkControl&&E.srcControl.getId()===this._oLinkControl.getId())||(!this.oAvatar||(E.srcControl.getId()!==this.oAvatar.getId())&&(!this._oLinkControl||(E.srcControl.getId()!==this._oLinkControl.getId()))&&(!this._oLinkExpandCollapse||(E.srcControl.getId()!==this._oLinkExpandCollapse.getId())))){L.prototype.ontap.apply(this,[E]);}}};
h.prototype.onfocusin=function(E){var i=E.srcControl,o=i.getDomRef(),p=this.getParent().getAccessbilityPosition(i);if(i instanceof sap.m.FeedListItem){o.setAttribute("aria-posinset",p.posInset);o.setAttribute("aria-setsize",p.setSize);}};
h.prototype._getAvatar=function(){var i=this.getIcon();var s=this.getId()+'-icon';this.oAvatar=this.getAggregation("_avatar");this.oAvatar=this.oAvatar||new A(s);this.oAvatar.applySettings({src:i,displayShape:this.getIconDisplayShape(),initials:this.getIconInitials(),displaySize:this.getIconSize(),ariaLabelledBy:this.getSender()});var t=this;if(this.getIconActive()){this.oAvatar.addStyleClass("sapMFeedListItemImage");if(!this.oAvatar.hasListeners("press")){this.oAvatar.attachPress(function(){t.fireIconPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});});}}else{this.oAvatar.addStyleClass("sapMFeedListItemImageInactive");}this.setAggregation("_avatar",this.oAvatar);return this.oAvatar;};
h.prototype._getLinkSender=function(w){if(!this._oLinkControl){var t=this;this._oLinkControl=new a({press:function(){t.fireSenderPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});}});this._oLinkControl.setParent(this,null,true);}if(w){this._oLinkControl.setProperty("text",this.getSender()+h._oRb.getText("COLON"),true);}else{this._oLinkControl.setProperty("text",this.getSender(),true);}this._oLinkControl.setProperty("enabled",this.getSenderActive(),true);return this._oLinkControl;};
h.prototype._activeHandlingInheritor=function(){var s=this.getActiveIcon();if(this.oAvatar&&s){this.oAvatar.setSrc(s);}};
h.prototype._inactiveHandlingInheritor=function(){var s=this.getIcon()?this.getIcon():I.getIconURI("person-placeholder");if(this.oAvatar){this.oAvatar.setSrc(s);}};
h.prototype._getCollapsedText=function(){this._nMaxCollapsedLength=this.getMaxCharacters();if(this._nMaxCollapsedLength===0){if(D.system.phone){this._nMaxCollapsedLength=h._nMaxCharactersMobile;}else{this._nMaxCollapsedLength=h._nMaxCharactersDesktop;}}var p=this._convertHtmlToPlainText(this._sFullText);var t=null;if(p&&p.length>this._nMaxCollapsedLength){var C=p.substring(0,this._nMaxCollapsedLength);var n=C.lastIndexOf(" ");if(n>0){C=C.substr(0,n);}if(p.length===this._sFullText.length){t=C;}else{t=this._convertPlainToHtmlText(C);}}return t;};
h.prototype._clearEmptyTagsInCollapsedText=function(){var r;if(this._bEmptyTagsInShortTextCleared){return;}this._bEmptyTagsInShortTextCleared=true;do{r=this.$("realtext").find(":empty").remove();}while(r.length>0);this._sShortText=this.$("realtext").html();};
h.prototype._toggleTextExpanded=function(){var $=this.$("realtext");var i=this.$("threeDots");var m=h._sTextShowMore;var s=h._sTextShowLess;if(this.getMoreLabel()){m=this.getMoreLabel();}if(this.getLessLabel()){s=this.getLessLabel();}if(this._bTextExpanded){$.html(this._sShortText.replace(/&#xa;/g,"<br>"));i.text(" ... ");this._oLinkExpandCollapse.setText(m);this._bTextExpanded=false;this._clearEmptyTagsInCollapsedText();}else{$.html(this._sFullText.replace(/&#xa;/g,"<br>"));i.text("  ");this._oLinkExpandCollapse.setText(s);this._bTextExpanded=true;}};
h.prototype._getLinkExpandCollapse=function(){var m=h._sTextShowMore;if(this.getMoreLabel()){m=this.getMoreLabel();}if(!this._oLinkExpandCollapse){this._oLinkExpandCollapse=new a({text:m,press:[this._toggleTextExpanded,this]});this._bTextExpanded=false;this._oLinkExpandCollapse.setParent(this,null,true);}return this._oLinkExpandCollapse;};
h.prototype._convertHtmlToPlainText=function(i){var r=/(<([^>]+)>)/ig;return i.replace(r,"");};
h.prototype._convertPlainToHtmlText=function(j){var s=this._sFullText;var r=/(<([^>]+)>)/ig;var E=s.split(r);var t="";for(var i=0;i<E.length;i++){if(E[i].length===0){continue;}if(j.length>0&&E[i].indexOf(j.trim())!==-1){E[i]=j;}if(/^<.+>$/.test(E[i])){t=t+E[i];E[i+1]="";continue;}if(j.indexOf(E[i].trim())===-1){continue;}else{j=j.replace(E[i],"");}t=t+E[i];}return t;};
h.prototype._checkTextIsExpandable=function(){return this._sShortText!==null;};
h.prototype.setType=function(t){if(this.getType()!==t){if(t===e.Navigation){this.setProperty("type",e.Active);}else{this.setProperty("type",t);}}return this;};
return h;});
sap.ui.predefine('sap/m/FeedListItemAction',["sap/ui/core/Element"],function(E){"use strict";
var F=E.extend("sap.m.FeedListItemAction",{metadata:{library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:""},key:{type:"string",group:"Misc",defaultValue:""},visible:{type:"boolean",group:"Appearance",defaultValue:true},enabled:{type:"boolean",group:"Appearance",defaultValue:true}},events:{press:{}}}});
return F;});
sap.ui.predefine('sap/m/FeedListItemRenderer',["./ListItemBaseRenderer","sap/ui/core/Renderer","sap/ui/Device"],function(L,R,D){"use strict";var F=R.extend(L);F.apiVersion=2;
F.renderLIAttributes=function(r,c){r.class("sapMFeedListItemTitleDiv");r.class("sapMFeedListShowSeparatorsAll");};
F.renderLIContent=function(r,c){var m=c.getId(),i=D.system.phone;r.openStart('div');r.class('sapMFeedListItem');r.openEnd();if(c.getShowIcon()){this._writeAvatarControl(r,c,m);}if(c.getActions().length>0){r.openStart("div",m+"-action-button");r.class('sapMFeedListItemActionButton');r.openEnd();r.renderControl(c.getAggregation("_actionButton"));r.close("div");}if(i){r.openStart('div').class("sapMFeedListItemHeader").class("sapUiSelectable");if(c.getShowIcon()){r.class("sapMFeedListItemHasFigure");}if(c.getSender()&&c.getTimestamp()){r.class('sapMFeedListItemFullHeight');}r.openEnd();if(c.getSender()){r.openStart('p',m+'-name').class("sapMFeedListItemTextName").class("sapUiSelectable").openEnd();r.renderControl(c._getLinkSender(false));r.close('p');}if(c.getTimestamp()){r.openStart('p',m+'-timestamp').class("sapMFeedListItemTimestamp").class("sapUiSelectable").openEnd();r.text(c.getTimestamp());r.close('p');}r.close('div');r.openStart('div').class("sapMFeedListItemText").class("sapUiSelectable").openEnd();this._writeText(r,c,m,i);if(c._checkTextIsExpandable()){this._writeCollapsedText(r,c,m);}else{r.unsafeHtml(c._sFullText);r.close('span');}r.close('div');if(c.getInfo()){r.openStart('p').class("sapMFeedListItemFooter").class("sapUiSelectable").openEnd();if(c.getInfo()){r.openStart('span',m+'-info').class("sapMFeedListItemInfo").class("sapUiSelectable").openEnd();r.text(c.getInfo());r.close('span');}r.close('p');}}else{r.openStart('div').class("sapMFeedListItemText");if(c.getShowIcon()){r.class('sapMFeedListItemHasFigure');}r.openEnd();r.openStart('div',m+'-text').class("sapMFeedListItemTextText").class("sapUiSelectable").openEnd();if(c.getSender()){r.openStart('span',m+'-name').class("sapMFeedListItemTextName").class("sapUiSelectable").openEnd();r.renderControl(c._getLinkSender(true));r.close('span');}this._writeText(r,c,m,i);if(c._checkTextIsExpandable()){this._writeCollapsedText(r,c,m);}else{r.unsafeHtml(c._sFullText);r.close('span');}r.close('div');if(c.getInfo()||c.getTimestamp()){r.openStart('p').class("sapMFeedListItemFooter").class("sapUiSelectable").openEnd();if(!sap.ui.getCore().getConfiguration().getRTL()){if(c.getInfo()){this._writeInfo(r,c,m);if(c.getTimestamp()){r.openStart("span").openEnd();r.text("\u00a0\u00a0\u00B7\u00a0\u00a0");r.close("span");}}if(c.getTimestamp()){this._writeTimestamp(r,c,m);}}else{if(c.getTimestamp()){this._writeTimestamp(r,c,m);}if(c.getInfo()){if(c.getTimestamp()){r.openStart("span").openEnd();r.text("\u00a0\u00a0\u00B7\u00a0\u00a0");r.close("span");}this._writeInfo(r,c,m);}}r.close('p');}r.close('div');}r.close('div');};
F._writeAvatarControl=function(r,c,i){r.openStart('figure',i+'-figure');r.class('sapMFeedListItemFigure');if(!c.getIcon()){r.class('sapMFeedListItemIsDefaultIcon');}r.openEnd();r.renderControl(c._getAvatar());r.close('figure');};
F._writeCollapsedText=function(r,c,i){if(c._bTextExpanded){r.unsafeHtml(c._sFullText);r.close('span');r.openStart('span',i+'-threeDots').class("sapMFeedListItemTextString").openEnd();r.text(" ");r.close('span');}else{r.unsafeHtml(c._sShortText);r.close('span');r.openStart('span',i+'-threeDots').class("sapMFeedListItemTextString").openEnd();r.text(" ... ");r.close('span');}var l=c._getLinkExpandCollapse();l.addStyleClass("sapMFeedListItemLinkExpandCollapse");r.renderControl(l);};
F._writeTimestamp=function(r,c,i){r.openStart('span',i+'-timestamp');r.class('sapMFeedListItemTimestampText');r.class('sapUiSelectable');if(c.getUnread()){r.class('sapMFeedListItem-Unread');}r.openEnd();r.text(c.getTimestamp());r.close('span');};
F._writeInfo=function(r,c,i){r.openStart('span',i+'-info');r.class('sapMFeedListItemInfoText');r.class('sapUiSelectable');if(c.getUnread()){r.class('sapMFeedListItem-Unread');}r.openEnd();r.text(c.getInfo());r.close('span');};
F._writeText=function(r,c,i,I){r.openStart('span',i+'-realtext');r.class(I?'sapMFeedListItemText':'sapMFeedListItemTextString');r.class('sapMFeedListItemText');r.class('sapUiSelectable');if(c.getUnread()){r.class('sapMFeedListItem-Unread');}r.openEnd();};
return F;},true);
sap.ui.predefine('sap/m/Fiori20Adapter',['sap/ui/base/Object','sap/ui/base/EventProvider','sap/ui/base/ManagedObjectObserver','sap/ui/Device',"sap/base/Log","sap/ui/thirdparty/jquery"],function(B,E,M,D,L,q){"use strict";var e=new E(),i,c,C;
var H=B.extend("HeaderAdapter",{constructor:function(o,A){if(!o||!A){L.error("Cannot initialize: Invalid arguments.");return;}this._oHeader=o;this._oStyledPage=null;this._oTitleInfo=null;this._oSubTitleInfo=null;this._oBackButtonInfo=null;this._oAdaptOptions=A;}});
H.prototype.adapt=function(){var s=this._oAdaptOptions.bStylePage,k=this._oAdaptOptions.bCollapseHeader;if(s){this._toggleStyle("sapF2Adapted",true,true);}this._adaptTitle();this._adaptBackButton();if(k){this._collapseHeader();}return this.getAdaptedContent();};
H.prototype.getAdaptedContent=function(){return{oTitleInfo:this._oTitleInfo,oSubTitleInfo:this._oSubTitleInfo,oBackButtonInfo:this._oBackButtonInfo,oStyledPage:this._oStyledPage};};
H.prototype._adaptTitle=function(){if(!H._isAdaptableHeader(this._oHeader)||this._oAdaptOptions.bMoveTitle!==true){return false;}this._oTitleInfo=this._detectTitle();this._oSubTitleInfo=this._detectSubTitle();var s=!!this._oTitleInfo||!!this._oSubTitleInfo;if(this._oTitleInfo){this._oTitleInfo.oControl.toggleStyleClass("sapF2AdaptedTitle",true);}return s;};
H.prototype._adaptBackButton=function(){if(!H._isAdaptableHeader(this._oHeader)||this._oAdaptOptions.bHideBackButton!==true){return false;}var k,l=false;this._oBackButtonInfo=this._detectBackButton();if(this._oBackButtonInfo){k=this._oBackButtonInfo.oControl.getVisible();this._oBackButtonInfo.oControl.toggleStyleClass("sapF2AdaptedNavigation",k);l=true;}return l;};
H.prototype._toggleStyle=function(s,A,S){var p=this._oHeader.getParent();if(!p){return;}this._oStyledPage=p;if(A===true){p.addStyleClass(s,S);}else if(A===false){p.removeStyleClass(s,S);}else if(A===undefined){p.hasStyleClass(s)?p.removeStyleClass(s,S):p.addStyleClass(s,S);}};
H._isAdaptableHeader=function(o){if(!o||!f(o,"sap/m/Bar")){return false;}var p=o.getParent();return p&&(f(p,"sap/m/Page")||f(p,"sap/m/MessagePage")||f(p,"sap/uxap/ObjectPageHeader"));};
H.prototype._detectTitle=function(){var t;if(H._isAdaptableHeader(this._oHeader)){var m=this._oHeader.getContentMiddle();if(m.length===1&&a(m[0])){var T=m[0];t={id:T.getId(),text:T.getText(),oControl:T,sChangeEventId:"_change",sPropertyName:"text"};}}return t;};
H.prototype._detectSubTitle=function(p){if(f(p,"sap/uxap/ObjectPageHeader")){var o=p.getHeaderTitle();if(o){return{id:o.getId(),text:o.getObjectTitle(),oControl:o,sChangeEventId:"_titleChange",sPropertyName:"objectTitle"};}}};
H.prototype._detectBackButton=function(){var k,o;if(H._isAdaptableHeader(this._oHeader)){k=this._oHeader.getContentLeft();if(k.length>0&&f(k[0],"sap/m/Button")&&(k[0].getType()==="Back"||k[0].getType()==="Up"||k[0].getIcon()==="sap-icon://nav-back")){o=k[0];return{id:o.getId(),oControl:o,sChangeEventId:"_change",sPropertyName:"visible"};}}};
H.prototype._collapseHeader=function(){var t=this._oTitleInfo,k=this._oBackButtonInfo,l,m,n,o,p,r,A;if(H._isAdaptableHeader(this._oHeader)){l=this._oHeader.getContentLeft();m=this._oHeader.getContentMiddle();n=this._oHeader.getContentRight();o=(l.length===1)&&(h(l[0])||k);p=(m.length===1)&&(h(m[0])||t);r=(n.length===1)&&h(n[0]);A=(l.length===0||o)&&(m.length===0||p)&&((n.length===0)||r);this._toggleStyle("sapF2CollapsedHeader",A,true);}};
var F=B.extend("sap.m.Fiori20Adapter",{});
F.attachViewChange=function(l,o){e.attachEvent("adaptedViewChange",l,o);};
F.detachViewChange=function(l,o){e.detachEvent("adaptedViewChange",l,o);};
F.traverse=function(o,A){i={aViewTitles:{},aViewSubTitles:{},aViewBackButtons:{}};c={};C=null;this._doBFS([{oNode:o,oAdaptOptions:A}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),A);}};
F._doBFS=function(Q){var n=Q.shift();if(!n){return;}var N=n.oNode,A=n.oAdaptOptions,s=A.iSearchDepth;A=this._applyRules(A,N);if(!this._isAdaptationRequired(N,A)||(s<=0)){return;}var I=this._isTopNavigableView(N);if(I){this._setAsCurrentlyAdaptedTopViewId(N.getId());}var o=this._processNode(N,A);var k=this._getNodeChildren(N),l=q.extend({},A,{iSearchDepth:this._updateSearchDepth(s,N)});if(o){var t=!!o.oTitleInfo,m=!!o.oBackButton,p=!!o.oStyledPage;l=q.extend(l,{bMoveTitle:A.bMoveTitle&&!t,bHideBackButton:A.bHideBackButton&&!m,bStylePage:A.bStylePage&&!p});}k.forEach(function(r){if(r){Q.push({oNode:r,oAdaptOptions:l});}});this._doBFS(Q);};
F._processNode=function(o,A){this._attachDefferedAdaptationListeners(o,A);if(H._isAdaptableHeader(o)){return this._adaptHeader(o,A);}if(o.getParent()&&f(o.getParent(),"sap/m/NavContainer")){return this._getCachedViewInfoToMerge(o.getId());}};
F._attachDefferedAdaptationListeners=function(o,A){this._attachAdaptableContentChange(o,A);this._attachNavigablePageChange(o,A);if(f(o,"sap/m/Page")||f(o,"sap/ui/core/mvc/XMLView")){this._observeAddAggregation(o,"content",A);}if(f(o,"sap/m/NavContainer")){this._observeRemoveAggregation(o,"pages",A);}if((A.bLateAdaptation===true)&&f(o,"sap/m/Bar")){this._observeAddAggregation(o,"contentLeft",A,o);this._observeAddAggregation(o,"contentMiddle",A,o);this._observeAddAggregation(o,"contentRight",A,o);}if(f(o,"sap/ui/core/ComponentContainer")){var k=o.getComponentInstance();if(!k&&o.getName()&&!o.getDomRef()){var t=this;var l={onBeforeRendering:function(){o.removeEventDelegate(l);t._doBFS([{oNode:o.getComponentInstance(),oAdaptOptions:A}]);if(t._getCurrentlyAdaptedTopViewId()){t._fireViewChange(t._getCurrentlyAdaptedTopViewId(),A);}}};o.addEventDelegate(l,this);}}};
F._checkHasListener=function(o,s){var k=c[o.getId()];return k&&k[s];};
F._setHasListener=function(o,s,l){var k=c[o.getId()];if(!k){k={};c[o.getId()]=k;}k[s]=l;};
F._attachAdaptableContentChange=function(o,A){if(typeof o._getAdaptableContent!=="function"){return;}if(this._checkHasListener(o,"_adaptableContentChange")){return;}var O=this._getCurrentlyAdaptedTopViewId();var k=function(l){var m=l.getParameter("adaptableContent");this._setAsCurrentlyAdaptedTopViewId(O);this._doBFS([{oNode:m,oAdaptOptions:A}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),A);}}.bind(this);o.attachEvent("_adaptableContentChange",k);this._setHasListener(o,"_adaptableContentChange",k);};
F._attachNavigablePageChange=function(o,A){if(!f(o,"sap/m/NavContainer")){return;}if(this._checkHasListener(o,"navigate")){return;}var O=function(k){var n=k.getParameter("to");A=this._applyRules(A,n);this._doBFS([{oNode:n,oAdaptOptions:A}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),A);}}.bind(this);o.attachNavigate(O);this._setHasListener(o,"navigate",O);};
F._observeAddAggregation=function(o,A,k,l){if(this._checkHasListener(o,A)){return;}var O=this._getCurrentlyAdaptedTopViewId(),m=function(p){var s=p.mutation,r=p.object;if((s==="add")||(s==="insert")){this._setAsCurrentlyAdaptedTopViewId(O);this._doBFS([{oNode:l?l:r,oAdaptOptions:k}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),k);}}}.bind(this),n=new M(m);n.observe(o,{aggregations:[A]});this._setHasListener(o,A,n);};
F._observeRemoveAggregation=function(o,A,k){if(this._checkHasListener(o,A)){return;}var O=new M(this._onRemoveAggregation.bind(this));O.observe(o,{aggregations:[A]});this._setHasListener(o,A,O);};
F._removeFromMergeInfo=function(m,o){Object.keys(m).forEach(function(k){var l=m[k];if((l.oControl===o)||j(l.oControl,o)){this._detachAllListeners(l.oControl);delete m[k];}},this);};
F._detachAllListeners=function(o){var k=c[o.getId()];if(!k){return;}Object.keys(k).forEach(function(s){var l=k[s];if(l instanceof M){l.disconnect();}else{o.detachEvent(s,l);}delete k[s];});};
F._onRemoveAggregation=function(o){var m=o.mutation,r;if(m==="remove"){r=o.child;this._detachAllListeners(r);this._removeFromMergeInfo(i.aViewTitles,r);this._removeFromMergeInfo(i.aViewSubTitles,r);this._removeFromMergeInfo(i.aViewBackButtons,r);}};
F._getNodeChildren=function(o){if(typeof o._getAdaptableContent==="function"){var k=[o._getAdaptableContent()];if(f(o,"sap/m/Page")){k=k.concat(o.getContent());}return k;}if(f(o,"sap/m/SplitContainer")){return[].concat(o.getAggregation("_navMaster"),o.getAggregation("_navDetail"));}if(f(o,"sap/uxap/ObjectPageLayout")){return[o.getHeaderTitle()];}if(f(o,"sap/ui/core/ComponentContainer")){return[o.getComponentInstance()];}if(f(o,"sap/ui/core/UIComponent")){return[o.getAggregation("rootControl")];}return o.findAggregatedObjects(false,g);};
F._updateSearchDepth=function(s,o){if(f(o,"sap/ui/core/mvc/View")||f(o,"sap/ui/core/Component")||f(o,"sap/ui/core/ComponentContainer")){return s;}return s-1;};
F._getTotalCachedInfoToMerge=function(v){var V=sap.ui.getCore().byId(v),o=this._getCachedViewInfoToMerge(v),k,l,s,S,m,p,n;if(!D.system.phone&&this._isTopSplitContainerSubView(V)){p=V.getParent();m=p&&p.getParent();if(m){k=m._oMasterNav&&(m._oMasterNav.getId()===p.getId());l=m._oDetailNav&&(m._oDetailNav.getId()===p.getId());}}if(k){s=m.getCurrentDetailPage();S=s&&s.getId();n=this._getCachedViewInfoToMerge(S);o=this._mergeSplitViewInfos(o,n);}if(l){s=m.getCurrentMasterPage();S=s&&s.getId();n=this._getCachedViewInfoToMerge(S);o=this._mergeSplitViewInfos(n,o);}o.sViewId=(k||l)?m.getId():v;return o;};
F._isTopSplitContainerSubView=function(o){var p=o&&o.getParent();return this._isTopmostNavContainer(p)&&f(p.getParent(),"sap/m/SplitContainer");};
F._mergeSplitViewInfos=function(m,o){q.each(m,function(k,v){m[k]=v||o[k];});return m;};
F._getCachedViewInfoToMerge=function(v){var o=(i.aViewBackButtons[v])?i.aViewBackButtons[v].oControl:undefined;return{oTitleInfo:i.aViewTitles[v],oSubTitleInfo:i.aViewSubTitles[v],oBackButton:o};};
F._applyRules=function(A,o){var p=o.getParent();if(f(p,"sap/m/SplitContainer")){var I=D.system.phone,m=A.bMoveTitle,k=A.bHideBackButton;if(m){m=I;}if(k&&!D.system.phone){k='initialPage';}return q.extend({},A,{bMoveTitle:m,bHideBackButton:k});}if(f(p,"sap/m/NavContainer")){if(A.bHideBackButton==='initialPage'){var l=p._getActualInitialPage()&&(p._getActualInitialPage().getId()===o.getId());return q.extend({},A,{bHideBackButton:l});}}if((A.bMoveTitle===false)||(A.bHideBackButton===false)){return q.extend({},A,{bCollapseHeader:false});}return A;};
F._getCurrentlyAdaptedTopViewId=function(){return C;};
F._setAsCurrentlyAdaptedTopViewId=function(v){C=v;};
F._isTopNavigableView=function(n){var p=n.getParent();return p&&this._isTopmostNavContainer(p);};
F._isTopmostNavContainer=function(o){var k,n=o;while(n){if(f(n,"sap/m/NavContainer")){k=n;}n=n.getParent();}return k&&(k.getId()===o.getId());};
F._adaptHeader=function(o,A){if(!o||!A){return;}var k=new H(o,A),l=k.adapt();var t=this._getCurrentlyAdaptedTopViewId();if(l.oTitleInfo){i.aViewTitles[t]=l.oTitleInfo;this._registerTextChangeListener(i.aViewTitles,t,A);}if(l.oSubTitleInfo){i.aViewSubTitles[t]=l.oSubTitleInfo;this._registerTextChangeListener(i.aViewSubTitles,t,A);}if(l.oBackButtonInfo){if(l.oBackButtonInfo.oControl.getVisible()){i.aViewBackButtons[t]=l.oBackButtonInfo;}this._registerVisibilityChangeListener(l.oBackButtonInfo,i.aViewBackButtons,t,A);}return l;};
F._registerTextChangeListener=function(t,v,A){var T=t[v];if(T&&T.oControl&&T.sChangeEventId){if(this._checkHasListener(T.oControl,T.sChangeEventId)){return;}var k=function(o){var T=t[v];if(o.getParameter("name")!==T.sPropertyName){return;}T.text=o.getParameter("newValue");this._fireViewChange(v,A);}.bind(this);T.oControl.attachEvent(T.sChangeEventId,k);this._setHasListener(T.oControl,T.sChangeEventId,k);}};
F._registerVisibilityChangeListener=function(o,k,v,A){var V;if(o&&o.oControl&&o.sChangeEventId){if(this._checkHasListener(o.oControl,o.sChangeEventId)){return;}var l=function(m){if(m.getParameter("name")!==o.sPropertyName){return;}V=m.getParameter("newValue");if(!V){q.each(k,function(I,n){if(n.oControl.getId()===o.oControl.getId()){delete k[I];}});}var p=o.oControl.getParent();if(H._isAdaptableHeader(p)){F._adaptHeader(p,A);this._fireViewChange(v,A);}}.bind(this);o.oControl.attachEvent(o.sChangeEventId,l);this._setHasListener(o.oControl,o.sChangeEventId,l);}};
F._fireViewChange=function(v,A){var t=this._getTotalCachedInfoToMerge(v);t.oAdaptOptions=A;e.fireEvent("adaptedViewChange",t);};
F._isAdaptationRequired=function(n,A){if(!n||this._isNonAdaptableControl(n)){return false;}for(var o in A){if(A.hasOwnProperty(o)&&((A[o]===true)||(A[o]==="initialPage"))){return true;}}return false;};
F._isNonAdaptableControl=function(o){return b(o);};
function a(o){return d(o,["sap/m/Label","sap/m/Text","sap/m/Title"]);}
function b(o){return d(o,["sap/m/List","sap/m/Table","sap/ui/table/Table","sap/ui/table/TreeTable"]);}
function d(o,t){if(!o||!t){return;}return t.some(function(T){return f(o,T);});}
function f(o,t){var T=sap.ui.require(t);return T&&(o instanceof T);}
function g(o){return o&&(o.sParentAggregationName!=="dependents");}
function h(o){return o&&(typeof o.getVisible==="function")&&(o.getVisible()===false);}
function j(o,r){var p=o&&o.getParent();while(p){if(p===r){return true;}p=p.getParent();}return false;}
return F;});
sap.ui.predefine('sap/m/FlexBox',['./FlexBoxStylingHelper','./FlexItemData','./library','sap/ui/base/ManagedObjectObserver','sap/ui/core/Control','sap/ui/core/InvisibleRenderer','./FlexBoxRenderer','sap/ui/thirdparty/jquery'],function(F,a,l,M,C,I,b,q){"use strict";var B=l.BackgroundDesign;var c=l.FlexAlignContent;var d=l.FlexWrap;var e=l.FlexAlignItems;var f=l.FlexJustifyContent;var g=l.FlexRendertype;var h=l.FlexDirection;
var i=C.extend("sap.m.FlexBox",{metadata:{library:"sap.m",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},displayInline:{type:"boolean",group:"Appearance",defaultValue:false},direction:{type:"sap.m.FlexDirection",group:"Appearance",defaultValue:h.Row},fitContainer:{type:"boolean",group:"Appearance",defaultValue:false},renderType:{type:"sap.m.FlexRendertype",group:"Misc",defaultValue:g.Div},justifyContent:{type:"sap.m.FlexJustifyContent",group:"Appearance",defaultValue:f.Start},alignItems:{type:"sap.m.FlexAlignItems",group:"Appearance",defaultValue:e.Stretch},wrap:{type:"sap.m.FlexWrap",group:"Appearance",defaultValue:d.NoWrap},alignContent:{type:"sap.m.FlexAlignContent",group:"Appearance",defaultValue:c.Stretch},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Transparent}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item"}},designtime:"sap/m/designtime/FlexBox.designtime",dnd:{draggable:false,droppable:true}}});
i.prototype.init=function(){this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};this._oItemsObserver=new M(this._onItemsChange.bind(this));this._oItemsObserver.observe(this,{aggregations:["items"]});};
i.prototype.exit=function(){if(this._oItemsObserver){this._oItemsObserver.disconnect();this._oItemsObserver=null;}};
i.prototype._onItemsChange=function(o){if(o.name==="items"&&o.child){if(o.mutation==="insert"){this._onItemInserted(o.child);}else if(o.mutation==="remove"){this._onItemRemoved(o.child);}}else if(o.name==="visible"){this._onItemVisibilityChange(o);}};
i.prototype._onItemInserted=function(o){if(o&&!(o instanceof i)){this._oItemsObserver.observe(o,{properties:["visible"]});if(this.getRenderType()===g.Bare){o.addEventDelegate(this._oItemDelegate,o);}}};
i.prototype._onItemRemoved=function(o){if(o&&!(o instanceof i)){this._oItemsObserver.unobserve(o,{properties:["visible"]});if(this.getRenderType()===g.Bare){o.removeEventDelegate(this._oItemDelegate,o);}}};
i.prototype._onItemVisibilityChange=function(o){var j=o.object,$;if(this.getRenderType()!==g.List&&this.getRenderType()!==g.Div){return;}if(j.getLayoutData()){$=q(document.getElementById(j.getLayoutData().getId()));}else{$=q(document.getElementById(I.createInvisiblePlaceholderId(j))).parent();}if(o.current){$.removeClass("sapUiHiddenPlaceholder").removeAttr("aria-hidden");}else{$.addClass("sapUiHiddenPlaceholder").attr("aria-hidden","true");}};
i.prototype._onAfterItemRendering=function(){var L=this.getLayoutData();if(L instanceof a){F.setFlexItemStyles(null,L);}};
i.prototype.setRenderType=function(v){var o=this.getRenderType(),j=this.getItems();if(v===o){return this;}this.setProperty("renderType",v);if(o==="Bare"){j.forEach(this._onItemRemoved,this);}if(v==="Bare"){j.forEach(this._onItemInserted,this);}return this;};
i.prototype.getAccessibilityInfo=function(){return{children:this.getItems()};};
return i;});
sap.ui.predefine('sap/m/FlexBoxRenderer',["./FlexBoxStylingHelper","sap/m/library","sap/base/Log","sap/m/FlexItemData"],function(F,l,L,a){"use strict";var b=l.FlexDirection;var c=l.FlexRendertype;var d={apiVersion:2};
d.render=function(r,f){var e=f.getRenderType()===c.List?"ul":"div";r.openStart(e,f);var p=f.getParent();if(p&&p.isA("sap.m.FlexBox")){if(!f.hasStyleClass("sapMFlexItem")){r.class("sapMFlexItem");}var o=f.getLayoutData();if(o&&o.isA("sap.m.FlexItemData")){F.setFlexItemStyles(r,o);}}else if(f.getFitContainer()){r.class("sapMFlexBoxFit");}r.class("sapMFlexBox");if(f.getDisplayInline()){r.class("sapMFlexBoxInline");}if(f.getDirection()===b.Column||f.getDirection()===b.ColumnReverse){r.class("sapMVBox");}else{r.class("sapMHBox");}if(f.getDirection()===b.RowReverse||f.getDirection()===b.ColumnReverse){r.class("sapMFlexBoxReverse");}r.class("sapMFlexBoxJustify"+f.getJustifyContent());r.class("sapMFlexBoxAlignItems"+f.getAlignItems());r.class("sapMFlexBoxWrap"+f.getWrap());r.class("sapMFlexBoxAlignContent"+f.getAlignContent());var B="sapMFlexBoxBG"+f.getBackgroundDesign();if(!f.hasStyleClass(B)){r.class(B);}r.style("height",f.getHeight());r.style("width",f.getWidth());var t=f.getTooltip_AsString();if(t){r.attr("title",t);}r.openEnd();d.renderItems(f,r);r.close(e);};
d.renderItems=function(f,r){var C=f.getItems(),w="";for(var i=0;i<C.length;i++){if(C[i].isA("sap.m.FlexBox")||f.getRenderType()===c.Bare){w="";}else if(f.getRenderType()===c.List){w="li";}else{w="div";}d.renderItem(C[i],w,r);}};
d.renderItem=function(i,w,r){var o=i.getLayoutData();if(w&&!o){i.setAggregation("layoutData",new a(),true);o=i.getLayoutData();}if(!(o instanceof a)){if(o){L.warning(o+" set on "+i+" is not of type sap.m.FlexItemData");}if(w){r.openStart(w);}}else{if(w){r.openStart(w,o.getId());}if(o.getStyleClass()){d.addItemClass(o.getStyleClass(),i,w,r);}d.addItemClass("sapMFlexItemAlign"+o.getAlignSelf(),i,w,r);d.addItemClass("sapMFlexBoxBG"+o.getBackgroundDesign(),i,w,r);if(w){F.setFlexItemStyles(r,o);}}d.addItemClass("sapMFlexItem",i,w,r);if(w){if(i.isA("sap.m.ScrollContainer")){r.class("sapMFlexBoxScroll");}if(!i.getVisible()){r.class("sapUiHiddenPlaceholder");}r.openEnd();}r.renderControl(i);if(w){r.close(w);}};
d.addItemClass=function(C,i,w,r){if(w){r.class(C);}else{i.addStyleClass(C);}};
return d;},true);
sap.ui.predefine('sap/m/FlexBoxStylingHelper',["sap/base/strings/hyphenate"],function(h){"use strict";var F={};
F.setFlexItemStyles=function(r,l){r=r||null;var o=''+l.getOrder(),g=''+l.getGrowFactor(),s=''+l.getShrinkFactor(),b=l.getBaseSize().toLowerCase(),m=l.getMinHeight(),M=l.getMaxHeight(),a=l.getMinWidth(),c=l.getMaxWidth();if(typeof o!=='undefined'){F.setStyle(r,l,"order",o);}if(typeof g!=='undefined'){F.setStyle(r,l,"flex-grow",g);}if(typeof s!=='undefined'){F.setStyle(r,l,"flex-shrink",s);}if(typeof b!=='undefined'){F.setStyle(r,l,"flex-basis",b);}if(typeof m!=='undefined'){F.setStyle(r,l,"min-height",m);}if(typeof M!=='undefined'){F.setStyle(r,l,"max-height",M);}if(typeof a!=='undefined'){F.setStyle(r,l,"min-width",a);}if(typeof c!=='undefined'){F.setStyle(r,l,"max-width",c);}};
F.setStyle=function(r,l,p,v){if(typeof(v)==="string"){v=h(v);}else if(typeof(v)==="number"){v=v.toString();}F.writeStyle(r,l,p,v);};
F.writeStyle=function(r,l,p,v){if(r){if(v==="0"||v){r.style(p,v);}}else{if(l.$().length){if(v!=="0"&&!v){l.$().css(p,null);}else{l.$().css(p,v);}}else{if(l.getParent()){if(v!=="0"&&!v){l.getParent().$().css(p,null);}else{l.getParent().$().css(p,v);}}}}};
return F;},true);
sap.ui.predefine('sap/m/FlexItemData',["./FlexBoxStylingHelper","./library","sap/ui/core/LayoutData"],function(F,l,L){"use strict";var B=l.BackgroundDesign;var a=l.FlexAlignSelf;
var b=L.extend("sap.m.FlexItemData",{metadata:{library:"sap.m",properties:{alignSelf:{type:"sap.m.FlexAlignSelf",group:"Misc",defaultValue:a.Auto},order:{type:"int",group:"Misc",defaultValue:0},growFactor:{type:"float",group:"Misc",defaultValue:0},shrinkFactor:{type:"float",group:"Misc",defaultValue:1},baseSize:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"auto"},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},maxHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},styleClass:{type:"string",group:"Misc",defaultValue:""},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Transparent}}}});
b.prototype.setAlignSelf=function(v){var o=this.getAlignSelf();this.setProperty("alignSelf",v,true);this.$().removeClass("sapMFlexItemAlign"+o).addClass("sapMFlexItemAlign"+this.getAlignSelf());return this;};
b.prototype.setOrder=function(v){this.setProperty("order",v,true);F.setStyle(null,this,"order",this.getOrder());return this;};
b.prototype.setGrowFactor=function(v){this.setProperty("growFactor",v,true);F.setStyle(null,this,"flex-grow",this.getGrowFactor());return this;};
b.prototype.setShrinkFactor=function(v){this.setProperty("shrinkFactor",v,true);F.setStyle(null,this,"flex-shrink",this.getShrinkFactor());return this;};
b.prototype.setBaseSize=function(v){this.setProperty("baseSize",v,true);F.setStyle(null,this,"flex-basis",this.getBaseSize());return this;};
b.prototype.setMinHeight=function(v){this.setProperty("minHeight",v,true);this.$().css("min-height",this.getMinHeight());return this;};
b.prototype.setMaxHeight=function(v){this.setProperty("maxHeight",v,true);this.$().css("max-height",this.getMaxHeight());return this;};
b.prototype.setMinWidth=function(v){this.setProperty("minWidth",v,true);this.$().css("min-width",this.getMinWidth());return this;};
b.prototype.setMaxWidth=function(v){this.setProperty("maxWidth",v,true);this.$().css("max-width",this.getMaxWidth());return this;};
b.prototype.setBackgroundDesign=function(v){var o=this.getBackgroundDesign();this.setProperty("backgroundDesign",v,true);this.$().removeClass("sapMFlexBoxBG"+o).addClass("sapMFlexBoxBG"+this.getBackgroundDesign());return this;};
b.prototype.setStyleClass=function(v){var o=this.getStyleClass();this.setProperty("styleClass",v,true);this.$().removeClass(o).addClass(this.getStyleClass());return this;};
b.prototype.getDomRef=function(s){var p,i=L.prototype.getDomRef.call(this,s);if(i){return i;}p=this.getParent();if(!p){return null;}return p.getDomRef(s);};
return b;});
sap.ui.predefine('sap/m/FormattedText',['./library','sap/ui/core/library','sap/ui/core/Control','./FormattedTextAnchorGenerator','./FormattedTextRenderer',"sap/base/Log","sap/base/security/URLListValidator","sap/base/security/sanitizeHTML"],function(l,c,C,F,a,L,U,s){"use strict";var b=l.LinkConversion,T=c.TextDirection,d=c.TextAlign;
var e=C.extend("sap.m.FormattedText",{metadata:{library:"sap.m",properties:{htmlText:{type:"string",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:b.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:d.Begin}},aggregations:{controls:{type:"sap.m.Link",multiple:true,singularName:"control"}}}});
var _={ATTRIBS:{'style':1,'class':1,'a::href':1,'a::target':1,'dir':1},ELEMENTS:{'a':{cssClass:'sapMLnk'},'abbr':1,'bdi':1,'blockquote':1,'br':1,'cite':1,'code':1,'em':1,'h1':{cssClass:'sapMTitle sapMTitleStyleH1'},'h2':{cssClass:'sapMTitle sapMTitleStyleH2'},'h3':{cssClass:'sapMTitle sapMTitleStyleH3'},'h4':{cssClass:'sapMTitle sapMTitleStyleH4'},'h5':{cssClass:'sapMTitle sapMTitleStyleH5'},'h6':{cssClass:'sapMTitle sapMTitleStyleH6'},'p':1,'pre':1,'strong':1,'span':1,'u':1,'dl':1,'dt':1,'dd':1,'ol':1,'ul':1,'li':1}},f={ATTRIBS:{'a::href':1,'a::target':1},ELEMENTS:{'a':{cssClass:'sapMLnk'},'br':1,'em':1,'strong':1,'u':1}};e.prototype._renderingRules=_;
e.prototype.init=function(){};
function S(t,h){var w;var j,v,k=t==="a";var m=this._renderingRules.ELEMENTS[t].cssClass||"";for(var i=0;i<h.length;i+=2){j=h[i];v=h[i+1];if(!this._renderingRules.ATTRIBS[j]&&!this._renderingRules.ATTRIBS[t+"::"+j]){w='FormattedText: <'+t+'> with attribute ['+j+'="'+v+'"] is not allowed';L.warning(w,this);h[i+1]=null;continue;}if(j=="href"){if(!U.validate(v)){L.warning("FormattedText: incorrect href attribute:"+v,this);h[i+1]="#";k=false;}}if(j=="target"){k=false;}if(m&&j.toLowerCase()=="class"){h[i+1]=m+" "+v;m="";}}if(k){h.push("target");h.push("_blank");}if(m){h.push("class");h.push(m);}return h;}
function p(t,h){if(this._renderingRules.ELEMENTS[t]){return S.call(this,t,h);}else{var w='<'+t+'> is not allowed';L.warning(w,this);}}
function g(t){return s(t,{tagPolicy:p.bind(this),uriRewriter:function(u){if(U.validate(u)){return u;}}});}
function o(E){var n=window.open();n.opener=null;n.location=E.currentTarget.href;E.preventDefault();}
e.prototype.onAfterRendering=function(){this.$().find('a[target="_blank"]').on("click",o);};
e.prototype.onBeforeRendering=function(){this.$().find('a[target="_blank"]').off("click",o);};
e.prototype._getDisplayHtml=function(){var t=this.getHtmlText(),A=this.getConvertLinksToAnchorTags();if(A===b.None){return t;}t=F.generateAnchors(t,A,this.getConvertedLinksDefaultTarget());return g.call(this,t);};
e.prototype.setHtmlText=function(t){return this.setProperty("htmlText",g.call(this,t));};
e.prototype._setUseLimitedRenderingRules=function(h){this._renderingRules=h?f:_;};
return e;});
sap.ui.predefine('sap/m/FormattedTextAnchorGenerator',["sap/ui/base/Object","sap/m/library","sap/base/security/URLListValidator"],function(B,l,U){"use strict";var L=l.LinkConversion;
var A=B.extend("sap.m.FormattedTextAnchorGenerator",{getInterface:function(){return this;}});
var c=/(\b(https?|ftp):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;()$]*[-A-Z0-9+&@#\/%=~_|])/gim;var W=/(www\.[^\s><]+(\b|$))/gim;var d="//";var D=/<(?:"[^"]*"['"]*|'[^']*'['"]*|[^'">])+(?!\/\s\*)>/gim;var E=/<a[^>]*>([^<]+)<\/a>/gim;var e=[D,E];
A.generateAnchors=function(t,s,T){if(s===L.ProtocolOnly){t=A._createAnchors(t,c,T);}if(s===L.All){t=A._createAnchors(t,c,T);t=A._createAnchors(t,W,T,d);}return t;};
A._createPositionObject=function(i,a){return{iStartPos:i,iEndPos:i+a};};
A._isNested=function(f,s){return f.iStartPos<s.iStartPos&&f.iEndPos>s.iEndPos;};
A._isAllowed=function(a,C){return a.some(function(o){return A._isNested(o,C);});};
A._shouldBeProcessed=function(u,C,a){return U.validate(u)&&!A._isAllowed(a,C);};
A._scanForEntitiesToSkip=function(r,t){var a=[],C;while((C=r.exec(t))!==null){a.push(A._createPositionObject(C.index,C[0].length));}return a;};
A._getEntitiesToSkipWhileSearchingForLinks=function(t){return e.map(function(s){return A._scanForEntitiesToSkip(s,t);}).reduce(function(a,b){return a.concat(b);});};
A._createAnchors=function(t,r,T,p){var a=A._getEntitiesToSkipWhileSearchingForLinks(t),C;p=p||'';C=function(P){var o=A._createPositionObject(arguments[3],P.length);if(!A._shouldBeProcessed(P,o,a)){return P;}return"<a href=\""+p+P+"\" target=\""+T+"\">"+P+"</a>";};return t.replace(r,C);};
return A;});
sap.ui.predefine('sap/m/FormattedTextRenderer',["sap/base/Log","sap/ui/core/library"],function(L,c){"use strict";var F={apiVersion:2};var T=c.TextDirection;var a=c.TextAlign;
F.render=function(r,C){var w=C.getWidth(),h=C.getHeight(),t=C.getTextDirection(),s=C.getTextAlign(),b=C.getAggregation("controls"),d=C._getDisplayHtml(),R=[],n='',S=0;r.openStart("div",C);r.class("sapMFT");if(w){r.class("sapMFTOverflowWidth");}if(h){r.class("sapMFTOverflowHeight");}if(t!==T.Inherit){r.attr("dir",t.toLowerCase());}if(s&&s!=a.Initial){r.style("text-align",s.toLowerCase());}if(C.getTooltip_AsString()){r.attr("title",C.getTooltip_AsString());}r.style("width",w||null);r.style("height",h||null);r.openEnd();while(d!==''&&d!==n){n=d.replace(/(?:\%\%(\d+))/,_);}if(d!==''){try{r.unsafeHtml(d);}catch(e){r.text(d);}}r.close("div");function _(m,i,p){var M=m.length;try{r.unsafeHtml(d.substr(0,p));}catch(e){r.text(d.substr(0,p));}S+=p;if(b&&b[i]!==undefined){if(R[i]===undefined){r.renderControl(b[i]);R[i]=S;}else{L.error("Control with index '"+i+"' ("+m+", htmlText@"+S+") is already rendered (htmlText@"+R[i]+")!",'sap.m.FormattedText:',C.getId());}}else{r.text(m);L.error("Missing control for placeholder '"+m+"' (htmlText@"+S+")!",'sap.m.FormattedText:',C.getId());}d=d.substr(p+M);S+=M;}};
return F;},true);
sap.ui.predefine('sap/m/GenericTag',["sap/ui/core/Control","sap/ui/events/KeyCodes",'./library',"sap/ui/core/library","sap/ui/core/Icon","./GenericTagRenderer"],function(C,K,l,c,I){"use strict";var G=l.GenericTagDesign,a=l.GenericTagValueState,V=c.ValueState,b={Error:"sap-icon://message-error",Warning:"sap-icon://message-warning",Success:"sap-icon://message-success",Information:"sap-icon://hint"};
var d=C.extend("sap.m.GenericTag",{metadata:{library:"sap.m",interfaces:["sap.m.IOverflowToolbarContent","sap.m.IOverflowToolbarFlexibleContent"],properties:{text:{type:"string",defaultValue:""},status:{type:"sap.ui.core.ValueState",defaultValue:V.None},design:{type:"sap.m.GenericTagDesign",defaultValue:G.Full},valueState:{type:"sap.m.GenericTagValueState",defaultValue:a.None}},defaultAggregation:"value",associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},aggregations:{value:{type:"sap.m.ObjectNumber",multiple:false},_statusIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_errorIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{press:{}}}});
d.CLASSNAME_OVERFLOW_TOOLBAR="sapMGenericTagOverflowToolbar";
d.prototype.setStatus=function(s){this.setProperty("status",s,false);this._getStatusIcon().setSrc(s!==V.None?b[s]:null);return this;};
d.prototype.setValue=function(v){var p=this.getValue();if(p){v.detachEvent("_change",this._fireValueChanged,this);}this.setAggregation("value",v);v.attachEvent("_change",this._fireValueChanged,this);this._fireValueChanged();return this;};
d.prototype._fireValueChanged=function(){this.fireEvent("_valueChanged");};
d.prototype._getStatusIcon=function(){var s=this.getAggregation("_statusIcon");if(!s){s=new I(this.getId()+"-statusIcon").addStyleClass("sapMGenericTagIcon");this.setAggregation("_statusIcon",s);}return s;};
d.prototype._getErrorIcon=function(){var e=this.getAggregation("_errorIcon");if(!e){e=new I(this.getId()+"-errorIcon",{src:b[V.Error]}).addStyleClass("sapMGenericTagErrorIcon");this.setAggregation("_errorIcon",e);}return e;};
d.prototype.ontouchstart=function(){this._toggleActiveGenericTag(true);};
d.prototype.ontouchend=function(){this._toggleActiveGenericTag(false);};
d.prototype.ontouchcancel=function(){this._toggleActiveGenericTag(false);};
d.prototype.onkeydown=function(e){if(e.which===K.SPACE||e.which===K.ENTER){this._toggleActiveGenericTag(true);}if(e.which===K.SHIFT||e.which===K.ESCAPE){this._bShouldInterupt=this._bSpacePressed;}if(e.which===K.SPACE){this._bSpacePressed=true;e.preventDefault();}if(e.which===K.ENTER){this.firePress();}};
d.prototype.onkeyup=function(e){if(e.which===K.SPACE||e.which===K.ENTER){this._toggleActiveGenericTag(false);}if(e.which===K.SPACE){if(!this._bShouldInterupt){this.firePress();}this._bShouldInterupt=false;this._bSpacePressed=false;}};
d.prototype.onclick=function(){this.firePress();};
d.prototype.onfocusout=function(){this._toggleActiveGenericTag(false);};
d.prototype._toggleActiveGenericTag=function(t){this.toggleStyleClass("sapMGenericTagActive",t);};
d.prototype._onBeforeEnterOverflow=function(o){o.addStyleClass(d.CLASSNAME_OVERFLOW_TOOLBAR);};
d.prototype._onAfterExitOverflow=function(o){o.removeStyleClass(d.CLASSNAME_OVERFLOW_TOOLBAR);};
d.prototype.getOverflowToolbarConfig=function(){var o={canOverflow:true,invalidationEvents:["_valueChanged"]};o.onBeforeEnterOverflow=this._onBeforeEnterOverflow;o.onAfterExitOverflow=this._onAfterExitOverflow;return o;};
return d;});
sap.ui.predefine('sap/m/GenericTagRenderer',["./library","sap/ui/core/library"],function(l,c){"use strict";var G=l.GenericTagDesign,a=l.GenericTagValueState,V=c.ValueState,C=sap.ui.getCore(),b={apiVersion:2};
b.render=function(r,o){var L=this._getAriaLabelledBy(o),R=C.getLibraryResourceBundle("sap.m"),t=o.getTooltip_AsString();r.openStart("div",o);r.class("sapMGenericTag");r.attr("tabindex",0);r.class("sapMGenericTag"+o.getStatus());r.accessibilityState(o,{role:"button",roledescription:R.getText("GENERICTAG_ROLEDESCRIPTION"),labelledby:L.join(" ")});if(t){r.attr("title",t);}r.openEnd();r.openStart("div");r.class("sapMGenericTagWrap");r.openEnd();this.renderElements(r,o);r.close("div");r.close("div");};
b.renderElements=function(r,o){var s=o.getDesign()===G.StatusIconHidden,S=o.getValueState()===a.Error,v=o.getValue();if(!s&&o.getStatus()!==V.None){r.renderControl(o._getStatusIcon());}this.renderText(r,o);if(S){r.renderControl(o._getErrorIcon());}else if(v){r.renderControl(v.addStyleClass("sapMGenericTagValue"));}this.renderHiddenARIAElement(r,o);};
b.renderText=function(r,o){r.openStart("span",o.getId()+"-text");r.class("sapMGenericTagText");r.openEnd();r.text(o.getText());r.close("span");};
b.renderHiddenARIAElement=function(r,o){if(o.getStatus()===V.None){return;}r.openStart("span",o.getId()+"-status");r.class("sapUiInvisibleText");r.attr("aria-hidden","true");r.openEnd();r.text(this._getGenericTagStatusText(o));r.close("span");};
b._getAriaLabelledBy=function(o){var L=o.getAriaLabelledBy().slice(),i=o.getId(),t=this._getTagValueId(o);if(o.getStatus()!==V.None){L.push(i+"-status");}L.push(i+"-text");L.push(o.getValueState()===a.Error?i+"-errorIcon":t);return L;};
b._getGenericTagStatusText=function(o){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),A;switch(o.getStatus()){case V.Error:A=r.getText("GENERICTAG_ARIA_VALUE_STATE_ERROR");break;case V.Warning:A=r.getText("GENERICTAG_ARIA_VALUE_STATE_WARNING");break;case V.Success:A=r.getText("GENERICTAG_ARIA_VALUE_STATE_SUCCESS");break;case V.Information:A=r.getText("GENERICTAG_ARIA_VALUE_STATE_INFORMATION");break;default:}return A;};
b._getTagValueId=function(o){var v=o.getValue();return v?v.getId():"";};
return b;},true);
sap.ui.predefine('sap/m/GenericTile',['./library','sap/ui/core/Control','sap/m/Text','sap/ui/core/HTML','sap/ui/core/Icon','sap/ui/core/IconPool','sap/m/Button','sap/m/GenericTileRenderer','sap/m/GenericTileLineModeRenderer','sap/m/Image','sap/ui/Device','sap/ui/core/ResizeHandler',"sap/base/strings/camelize","sap/base/util/deepEqual","sap/ui/events/PseudoEvents","sap/ui/thirdparty/jquery"],function(l,C,T,H,I,a,B,G,L,b,D,R,c,d,P,q){"use strict";var e=l.GenericTileScope,f=l.LoadState,F=l.FrameType,S=l.Size,g=l.GenericTileMode,h=l.TileSizeBehavior,W=l.WrappingType,U=l.URLHelper;var j="GenericTileDeviceSet";var m={};
var n=C.extend("sap.m.GenericTile",{
metadata:{library:"sap.m",properties:{mode:{type:"sap.m.GenericTileMode",group:"Appearance",defaultValue:g.ContentMode},header:{type:"string",group:"Appearance",defaultValue:null},subheader:{type:"string",group:"Appearance",defaultValue:null},failedText:{type:"string",group:"Appearance",defaultValue:null},size:{type:"sap.m.Size",group:"Misc",defaultValue:S.Auto,deprecated:true},frameType:{type:"sap.m.FrameType",group:"Misc",defaultValue:F.OneByOne},systemInfo:{type:"string",group:"Misc",defaultValue:null},appShortcut:{type:"string",group:"Misc",defaultValue:null},backgroundImage:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},headerImage:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},state:{type:"sap.m.LoadState",group:"Misc",defaultValue:f.Loaded},imageDescription:{type:"string",group:"Accessibility",defaultValue:null},scope:{type:"sap.m.GenericTileScope",group:"Misc",defaultValue:e.Display},sizeBehavior:{type:"sap.m.TileSizeBehavior",defaultValue:h.Responsive},ariaLabel:{type:"string",group:"Accessibility",defaultValue:null},ariaRole:{type:"string",group:"Accessibility",defaultValue:null},ariaRoleDescription:{type:"string",group:"Accessibility",defaultValue:null},url:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},enableNavigationButton:{type:"boolean",group:"Misc",defaultValue:false},pressEnabled:{type:"boolean",group:"Misc",defaultValue:true},navigationButtonText:{type:"string",group:"Misc",defaultValue:null},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:W.Normal},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},additionalTooltip:{type:"string",group:"Accessibility",defaultValue:null},tileIcon:{type:"sap.ui.core.URI",multiple:false},backgroundColor:{type:"sap.ui.core.CSSColor",group:"Appearance"},valueColor:{type:"sap.m.ValueColor",group:"Appearance",defaultValue:"None"}},defaultAggregation:"tileContent",aggregations:{tileContent:{type:"sap.m.TileContent",multiple:true,bindable:"bindable"},icon:{type:"sap.ui.core.Control",multiple:false,deprecated:true},actionButtons:{type:"sap.m.Button",multiple:true,bindable:"bindable"},_titleText:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_failedMessageText:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_tileIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_tileIconImage:{type:"sap.m.Image",multiple:false,visibility:"hidden"}},events:{press:{parameters:{scope:{type:"sap.m.GenericTileScope"},action:{type:"string"},domRef:{type:"any"}}}}},
renderer:{apiVersion:2,render:function(r,o){if(o.getMode()===g.LineMode){L.render(r,o);}else{G.render(r,o);}}}
});
n._Action={Press:"Press",Remove:"Remove"};n.LINEMODE_SIBLING_PROPERTIES=["state","subheader","header","scope"];
n.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!D.media.hasRangeSet(j)){D.media.initRangeSet(j,[450],"px",["small","large"]);}this._oTitle=new T(this.getId()+"-title");this._oTitle.addStyleClass("sapMGTTitle");this._oTitle.cacheLineHeight=false;this.setAggregation("_titleText",this._oTitle,true);this._oAppShortcut=new T(this.getId()+"-appShortcut");this._oAppShortcut.cacheLineHeight=false;this.addDependent(this._oAppShortcut);this._oSystemInfo=new T(this.getId()+"-systemInfo");this._oSystemInfo.cacheLineHeight=false;this.addDependent(this._oSystemInfo);this._oSubTitle=new T(this.getId()+"-subTitle");this._oSubTitle.cacheLineHeight=false;this.addDependent(this._oSubTitle);this._sFailedToLoad=this._oRb.getText("INFOTILE_CANNOT_LOAD_TILE");this._sLoading=this._oRb.getText("INFOTILE_LOADING");this._oFailedText=new T(this.getId()+"-failed-txt",{maxLines:2});this._oFailedText.cacheLineHeight=false;this._oFailedText.addStyleClass("sapMGTFailed");this.setAggregation("_failedMessageText",this._oFailedText,true);this._oWarningIcon=new I(this.getId()+"-warn-icon",{src:"sap-icon://notification",size:"1.375rem"});this._oWarningIcon.addStyleClass("sapMGTFtrFldIcnMrk");this._oBusy=new H(this.getId()+"-overlay");this._oBusy.setBusyIndicatorDelay(0);this._bTilePress=true;this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}this._oNavigateAction=new B(this.getId()+"-navigateAction");this._oNavigateAction._bExcludeFromTabChain=true;this.addDependent(this._oNavigateAction);};
n.prototype.setWrappingType=function(w){this.setProperty("wrappingType",w,true);this._oTitle.setWrappingType(w);this._oFailedText.setWrappingType(w);this._oSubTitle.setWrappingType(w);this._oAppShortcut.setWrappingType(w);this._oSystemInfo.setWrappingType(w);return this;};
n.prototype.setSubheader=function(s){this.setProperty("subheader",s);this._oSubTitle.setText(s);return this;};
n.prototype.setAppShortcut=function(A){this.setProperty("appShortcut",A);this._oAppShortcut.setText(A);return this;};
n.prototype.setSystemInfo=function(s){this.setProperty("systemInfo",s);this._oSystemInfo.setText(s);return this;};
n.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};
n.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this._oTitle.clampHeight();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};
n.prototype._initScopeContent=function(t){if(!this.getState||this.getState()!==f.Disabled){this._oMoreIcon=this._oMoreIcon||a.createControlByURI({id:this.getId()+"-action-more",size:"1rem",useIconTooltip:false,src:"sap-icon://overflow"}).addStyleClass("sapMPointer").addStyleClass(t+"MoreIcon");this._oRemoveButton=this._oRemoveButton||new B({id:this.getId()+"-action-remove",icon:"sap-icon://decline",tooltip:this._oRb.getText("GENERICTILE_REMOVEBUTTON_TEXT")}).addStyleClass("sapUiSizeCompact").addStyleClass(t+"RemoveButton");this._oRemoveButton._bExcludeFromTabChain=true;switch(this.getScope()){case e.Actions:this._oMoreIcon.setVisible(true);this._oRemoveButton.setVisible(true);break;case e.ActionMore:this._oMoreIcon.setVisible(true);this._oRemoveButton.setVisible(false);break;case e.ActionRemove:this._oRemoveButton.setVisible(true);this._oMoreIcon.setVisible(false);break;default:}}};
n.prototype._isSmall=function(){return this.getSizeBehavior()===h.Small||window.matchMedia("(max-width: 374px)").matches;};
n.prototype.exit=function(){if(this._sParentResizeListenerId){R.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null;}D.media.detachHandler(this._handleMediaChange,this,j);if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());this._$RootNode=null;}this._clearAnimationUpdateQueue();this._oWarningIcon.destroy();if(this._oImage){this._oImage.destroy();}this._oBusy.destroy();if(this._oMoreIcon){this._oMoreIcon.destroy();}if(this._oRemoveButton){this._oRemoveButton.destroy();}if(this._oNavigateAction){this._oNavigateAction.destroy();}};
n.prototype.onBeforeRendering=function(){var s=!!this.getSubheader();if(this.getMode()===g.HeaderMode||this.getMode()===g.IconMode){this._applyHeaderMode(s);}else{this._applyContentMode(s);}var t=this.getTileContent().length;for(var i=0;i<t;i++){this.getTileContent()[i].setProperty("disabled",this.getState()===f.Disabled,true);}this._initScopeContent("sapMGT");this._generateFailedText();this.$().off("mouseenter");this.$().off("mouseleave");if(this._sParentResizeListenerId){R.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null;}D.media.detachHandler(this._handleMediaChange,this,j);if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());}if(this.getFrameType()===F.Auto){this.setProperty("frameType",F.OneByOne,true);}if(this._isNavigateActionEnabled()){var k=this.getNavigationButtonText()?this.getNavigationButtonText():this._oRb.getText("ACTION_READ_MORE");this._oNavigateAction.setText(k);this._oNavigateAction.detachPress(this._navigateEventHandler,this);}};
n.prototype.onAfterRendering=function(){this._setupResizeClassHandler();this.$().on("mouseenter",this._updateAriaAndTitle.bind(this));this.$().on("mouseleave",this._removeTooltipFromControl.bind(this));var M=this.getMode();var s=this._isScreenLarge();if(M===g.LineMode){var $=this.$().parent();if(s){this._updateHoverStyle(true);if(this.getParent()instanceof C){this._sParentResizeListenerId=R.register(this.getParent(),this._handleResize.bind(this));}else{this._sParentResizeListenerId=R.register($,this._handleResize.bind(this));}}}if(M===g.LineMode&&this._bUpdateLineTileSiblings){this._updateLineTileSiblings();this._bUpdateLineTileSiblings=false;}if(M===g.LineMode){D.media.attachHandler(this._handleMediaChange,this,j);}if(this._isNavigateActionEnabled()){this._oNavigateAction.attachPress(this._navigateEventHandler,this);}this.onDragComplete();};
n.prototype.onDragComplete=function(){if(this.hasStyleClass("sapMGTPressActive")){this.removeStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}if(this.getMode()===g.LineMode){this.removeStyleClass("sapMGTLineModePress");}}};
n.prototype._handleResize=function(){if(this.getMode()===g.LineMode&&this._isScreenLarge()&&this.getParent()){this._queueAnimationEnd();}};
n.prototype._setupResizeClassHandler=function(){var i=function(){if(this.getSizeBehavior()===h.Small||window.matchMedia("(max-width: 374px)").matches){this.$().addClass("sapMTileSmallPhone");}else{this.$().removeClass("sapMTileSmallPhone");}}.bind(this);q(window).on("resize",i);i();};
n.prototype._isCompact=function(){return q("body").hasClass("sapUiSizeCompact")||this.$().is(".sapUiSizeCompact")||this.$().closest(".sapUiSizeCompact").length>0;};
n.prototype._calculateStyleData=function(){this.$("lineBreak").remove();if(!this._isScreenLarge()||!this.getDomRef()||this.$().is(":hidden")){return null;}var $=this.$(),E=this.$("endMarker"),s=this.$("startMarker");if(E.length===0||s.length===0){return null;}var k=this._getLineCount(),o,r,t=Math.ceil(L._getCSSPixelValue(this,"margin-top")),u,A=this.$().parent().innerWidth(),v=Math.ceil(L._getCSSPixelValue(this,"min-height")),w=L._getCSSPixelValue(this,"line-height"),x=this.$().is(":not(:first-child)")&&k>1,y=q("<span><br></span>"),i=0,z=sap.ui.getCore().getConfiguration().getRTL(),J=E.position();if(x){y.attr("id",this.getId()+"-lineBreak");$.prepend(y);k=this._getLineCount();J=E.position();}var K={rtl:z,lineBreak:x,startOffset:s.offset(),endOffset:E.offset(),availableWidth:A,lines:[]};var M;if(D.browser.msie||D.browser.edge){M=y.find("br").position();}else{M=y.position();}var N=M;if(!(D.browser.mozilla||D.browser.msie||D.browser.edge)&&M.left<J.left){N=J;}K.positionLeft=x?M.left:$.position().left;K.positionRight=x?$.width()-N.left:K.availableWidth-$.position().left;if(!x&&k>1){K.positionRight=s.parent().innerWidth()-(s.position().left+s.width());}for(i;i<k;i++){if(x&&i===0){continue;}if(k===1){o=z?K.availableWidth-K.positionLeft:K.positionLeft;u=$.width();}else if(i===k-1){o=0;u=z?$.width()-J.left:J.left;}else if(x&&i===1){o=0;u=A;}else{o=0;u=A;}r=i*w+t;K.lines.push({offset:{x:o,y:r},width:u,height:v});}return K;};
n.prototype._getStyleData=function(){var s=this._calculateStyleData();if(!d(this._oStyleData,s)){delete this._oStyleData;this._oStyleData=s;return true;}return false;};
n.prototype._getAnimationEvents=function(){return"transitionend.sapMGT$id animationend.sapMGT$id".replace(/\$id/g,c(this.getId()));};
n.prototype._updateHoverStyle=function(i){if(!this._getStyleData()&&!i){return;}this._clearAnimationUpdateQueue();this._cHoverStyleUpdates=-1;this._oAnimationEndCallIds={};if(this._oStyleData&&this._oStyleData.lineBreak&&this.getUIArea()){this._$RootNode=q(this.getUIArea().getRootNode());this._$RootNode.on(this._getAnimationEvents(),this._queueAnimationEnd.bind(this));}this._queueAnimationEnd();};
n.prototype._queueAnimationEnd=function(E){if(E){var t=q(E.target);if(t.is(".sapMGT, .sapMGT *")){return false;}}if(typeof this._cHoverStyleUpdates!=="number"){this._cHoverStyleUpdates=-1;}if(!this._oAnimationEndCallIds){this._oAnimationEndCallIds={};}this._cHoverStyleUpdates++;this._oAnimationEndCallIds[this._cHoverStyleUpdates]=setTimeout(this._handleAnimationEnd.bind(this,this._cHoverStyleUpdates),10);};
n.prototype._handleAnimationEnd=function(i){delete this._oAnimationEndCallIds[i];if(this._cHoverStyleUpdates===i){this._getStyleData();L._updateHoverStyle.call(this);}};
n.prototype._clearAnimationUpdateQueue=function(){for(var k in this._oAnimationEndCallIds){clearTimeout(this._oAnimationEndCallIds[k]);delete this._oAnimationEndCallIds[k];}};
n.prototype._getLineCount=function(){var o=this.getDomRef().getBoundingClientRect(),i=L._getCSSPixelValue(this,"line-height");return Math.round(o.height/i);};
n.prototype.getBoundingRects=function(){var o=this.$().offset();return[{offset:{x:o.left,y:o.top},width:this.$().outerWidth(),height:this.$().height()}];};
n.prototype._updateLineTileSiblings=function(){var o=this.getParent();if(this.getMode()===g.LineMode&&this._isScreenLarge()&&o){var i=o.indexOfAggregation(this.sParentAggregationName,this);var s=o.getAggregation(this.sParentAggregationName).splice(i+1);for(i=0;i<s.length;i++){var k=s[i];if(k instanceof n&&k.getMode()===g.LineMode){k._updateHoverStyle();}}}};
n.prototype.ontouchstart=function(){this.addStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}if(this.getMode()===g.LineMode){this.addStyleClass("sapMGTLineModePress");}};
n.prototype.ontouchcancel=function(){this.removeStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}};
n.prototype.ontouchend=function(){this.removeStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}if(this.getMode()===g.LineMode){this.removeStyleClass("sapMGTLineModePress");}};
n.prototype.ontap=function(i){if(!_(i,this)){var o;if(this._bTilePress&&this.getState()!==f.Disabled){this.$().trigger("focus");o=this._getEventParams(i);if(!(this.isInActionRemoveScope()&&o.action===n._Action.Press)){this.firePress(o);}i.preventDefault();}}};
var p=false;
n.prototype.onkeydown=function(i){if(!_(i,this)){p=(i.keyCode===16||i.keyCode===27)?true:false;var k=m[i.keyCode];if(!k){m[i.keyCode]=true;if(m[32]||m[13]){i.preventDefault();}}if(P.events.sapselect.fnCheck(i)&&this.getState()!==f.Disabled){this.addStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}i.preventDefault();}}};
n.prototype._updateAriaLabel=function(){var A=this._getAriaText(),t=this.$(),i=false;if(t.attr("aria-label")!==A){t.attr("aria-label",A);i=true;}return i;};
n.prototype.onkeyup=function(i){if(!_(i,this)){var k=m[i.keyCode];if(k){delete m[i.keyCode];}var o,r=false,s=this.getScope(),A=s===e.Actions||s===e.ActionRemove;if(A&&(P.events.sapdelete.fnCheck(i)||P.events.sapbackspace.fnCheck(i))){o={scope:s,action:n._Action.Remove,domRef:this._oRemoveButton.getPopupAnchorDomRef()};r=true;}if(m[16]&&i.keyCode!==16&&this.getState()!==f.Disabled){p===false;}if((P.events.sapselect.fnCheck(i)||p)&&this.getState()!==f.Disabled){this.removeStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}o=this._getEventParams(i);r=true;}if(!p&&r){this.firePress(o);i.preventDefault();}this._updateAriaLabel();}};
n.prototype.setProperty=function(s){C.prototype.setProperty.apply(this,arguments);if(this.getMode()===g.LineMode&&n.LINEMODE_SIBLING_PROPERTIES.indexOf(s)!==-1){this._bUpdateLineTileSiblings=true;}return this;};
n.prototype.getHeader=function(){return this._oTitle.getText();};
n.prototype.setHeader=function(t){this.setProperty("header",t);this._oTitle.setText(t);return this;};
n.prototype.setHeaderImage=function(u){var v=!d(this.getHeaderImage(),u);if(v){if(this._oImage){this._oImage.destroy();this._oImage=undefined;}if(u){this._oImage=a.createControlByURI({id:this.getId()+"-icon-image",src:u},b);this._oImage.addStyleClass("sapMGTHdrIconImage");}}return this.setProperty("headerImage",u);};
n.prototype._applyHeaderMode=function(s){var i=this.getFrameType();if(this._isIconMode()){this._oTitle.setProperty("maxLines",2,true);}else if(i===F.TwoByOne&&this.getMode()===g.ActionMode){this._oTitle.setProperty("maxLines",2,true);}else if(i===F.OneByHalf||i===F.TwoByHalf){this._oTitle.setProperty("maxLines",2,true);}else{if(s){this._oTitle.setProperty("maxLines",4,true);}else{this._oTitle.setProperty("maxLines",5,true);}}this._changeTileContentContentVisibility(false);};
n.prototype._applyContentMode=function(s){var k=this.getFrameType();var t=this.getTileContent();var o=false;if(k===F.TwoByHalf||k===F.OneByHalf){if(t.length){for(var i=0;i<t.length;i++){var r=t[i].getAggregation('content');if(r!==null){if((k===F.OneByHalf&&r.getMetadata().getName()==="sap.m.ImageContent")){o=true;this._oTitle.setProperty("maxLines",2,true);break;}else{this._oTitle.setProperty("maxLines",1,true);break;}}this._oTitle.setProperty("maxLines",2,true);}}else{this._oTitle.setProperty("maxLines",2,true);}}else if(k===F.TwoByOne&&this.getMode()===g.ActionMode){if(s){this._oTitle.setProperty("maxLines",1,true);}else{this._oTitle.setProperty("maxLines",2,true);}}else if(s){this._oTitle.setProperty("maxLines",2,true);}else{this._oTitle.setProperty("maxLines",3,true);}this._changeTileContentContentVisibility(true,k,o);};
n.prototype._changeTileContentContentVisibility=function(v,k,o){var t;t=this.getTileContent();for(var i=0;i<t.length;i++){if(k==F.OneByHalf&&o){t[i].setRenderContent(false);}else{t[i].setRenderContent(v);}}};
n.prototype._getHeaderAriaAndTooltipText=function(){var t="";var i=true;if(this.getHeader()){t+=this.getHeader();i=false;}if(this.getSubheader()){t+=(i?"":"\n")+this.getSubheader();i=false;}if(this.getImageDescription()){t+=(i?"":"\n")+this.getImageDescription();}return t;};
n.prototype._getContentAriaAndTooltipText=function(){var t="";var k=true;var o=this.getTileContent();var A=this.getAdditionalTooltip();if(!this._isInActionScope()&&this.getMode()===g.ContentMode){for(var i=0;i<o.length;i++){if(typeof o[i]._getAriaAndTooltipText==="function"){t+=(k?"":"\n")+o[i]._getAriaAndTooltipText();}else if(o[i].getTooltip_AsString()){t+=(k?"":"\n")+o[i].getTooltip_AsString();}k=false;}}if(A){t+=(k?"":"\n")+A;}return t;};
n.prototype._getAriaAndTooltipText=function(){var A=(this.getTooltip_AsString()&&!this._isTooltipSuppressed())?this.getTooltip_AsString():(this._getHeaderAriaAndTooltipText()+"\n"+this._getContentAriaAndTooltipText());switch(this.getState()){case f.Disabled:return"";case f.Loading:return A+"\n"+this._sLoading;case f.Failed:return A+"\n"+this._oFailedText.getText();default:if(A.trim().length===0){return"";}else{return A;}}};
n.prototype._getAriaText=function(){var A=this.getTooltip_Text();var s=this.getAriaLabel();if(!A||this._isTooltipSuppressed()){A=this._getAriaAndTooltipText();}if(this._isInActionScope()){A=this._oRb.getText("GENERICTILE_ACTIONS_ARIA_TEXT")+" "+A;}if(s){A=s+" "+A;}return A;};
n.prototype._getTooltipText=function(){var t=this.getTooltip_Text();if(this._isTooltipSuppressed()===true){t=null;}return t;};
n.prototype._checkFooter=function(t,i){var s=i.getState();var A=this._isInActionScope()||this._bShowActionsView===true;var k=this.getFrameType();var o=t.getAggregation('content');if(this._isIconMode()){t.setRenderFooter(false);}else if(s===f.Failed||A&&s!==f.Disabled){t.setRenderFooter(false);}else if(k===F.TwoByHalf&&(o!==null||this.getSubheader())){t.setRenderFooter(false);}else if(k===F.OneByHalf&&((o!==null&&o.getMetadata().getName()!=="sap.m.ImageContent")||this.getSubheader())){t.setRenderFooter(false);}else{t.setRenderFooter(true);return true;}};
n.prototype._isInActionScope=function(){return this.getScope()===e.Actions||this.getScope()===e.ActionMore||this.getScope()===e.ActionRemove;};
n.prototype.isInActionRemoveScope=function(){return this.getScope()===e.ActionRemove;};
n.prototype._generateFailedText=function(){var s=this.getFailedText();var i=s?s:this._sFailedToLoad;this._oFailedText.setProperty("text",i,true);this._oFailedText.setAggregation("tooltip",i,true);};
n.prototype._isTooltipSuppressed=function(){var t=this.getTooltip_Text();if(t&&t.length>0&&t.trim().length===0){return true;}else{return false;}};
n.prototype._isHeaderTextTruncated=function(){var o,M,$,w;if(this.getMode()===g.LineMode){$=this.$("hdr-text");if($.length>0){w=Math.ceil($[0].getBoundingClientRect().width);return($[0]&&w<$[0].scrollWidth);}else{return false;}}else{o=this.getAggregation("_titleText").getDomRef("inner");M=this.getAggregation("_titleText").getClampHeight(o);return(M<o.scrollHeight);}};
n.prototype._isSubheaderTextTruncated=function(){var s;if(this.getMode()===g.LineMode){s=this.$("subHdr-text");}else{s=this.$("subTitle");}if(s.length>0){var w=Math.ceil(s[0].getBoundingClientRect().width);return(s[0]&&w<s[0].scrollWidth);}else{return false;}};
n.prototype._setTooltipFromControl=function(){var t=this._getAriaAndTooltipText();if(t&&!this._getTooltipText()&&!this._isTooltipSuppressed()){this.$().attr("title",t.trim());this._bTooltipFromControl=true;}};
n.prototype._updateAriaAndTitle=function(){var A=this._getAriaAndTooltipText();var s=this._getAriaText();var t=this.$();if(t.attr("title")!==A){t.attr("aria-label",s);}if(this._isInActionScope()){t.find('*:not(.sapMGTRemoveButton)').removeAttr("aria-label").removeAttr("title").off("mouseenter");}else{t.find('*').removeAttr("aria-label").removeAttr("title").off("mouseenter");}this._setTooltipFromControl();};
n.prototype._removeTooltipFromControl=function(){if(this._bTooltipFromControl){this.$().removeAttr("title");this._bTooltipFromControl=false;}};
n.prototype._isScreenLarge=function(){return this._getCurrentMediaContainerRange(j).name==="large";};
n.prototype._getEventParams=function(E){var o,A=n._Action.Press,s=this.getScope(),i=this.getDomRef();if((s===e.Actions||e.ActionRemove)&&E.target.id.indexOf("-action-remove")>-1){A=n._Action.Remove;i=this._oRemoveButton.getPopupAnchorDomRef();}else if(s===e.Actions||s===e.ActionMore){i=this._oMoreIcon.getDomRef();}o={scope:s,action:A,domRef:i};return o;};
n.prototype._handleMediaChange=function(){this._bUpdateLineTileSiblings=true;this.invalidate();};
n.prototype.setPressEnabled=function(v){this._bTilePress=v;this.setProperty("pressEnabled",v);return this;};
n.prototype.showActionsView=function(v){if(this._bShowActionsView!==v){this._bShowActionsView=v;this.invalidate();}};
n.prototype._generateIconAggregation=function(i){var A="";this._oIcon=a.createControlByURI({size:this.getFrameType()===F.OneByOne?"2rem":"1.25rem",useIconTooltip:false,src:i});if(!this._oIcon){this._oIcon=a.createControlByURI({height:this.getFrameType()===F.OneByOne?"2rem":"1.25rem",width:this.getFrameType()===F.OneByOne?"2rem":"1.25rem",useIconTooltip:false,src:i},b).addStyleClass("sapMPointer").addStyleClass("sapMGTTileIcon");}this._oIcon.addStyleClass("sapMPointer").addStyleClass("sapMGTTileIcon");if(this._oIcon instanceof b){A="_tileIconImage";}else if(this._oIcon instanceof I){A="_tileIcon";}if(A){this.setAggregation(A,this._oIcon);}return A;};
n.prototype._isIconMode=function(){if(this.getMode()===g.IconMode&&(this.getFrameType()===F.OneByOne||this.getFrameType()===F.TwoByHalf)&&this.getBackgroundColor()&&this.getTileIcon()){return true;}else{return false;}};
n.prototype._isNavigateActionEnabled=function(){return this.getMode()===g.ArticleMode&&this.getUrl()&&this.getEnableNavigationButton();};
n.prototype._isActionMode=function(){return this.getFrameType()===F.TwoByOne&&this.getMode()===g.ActionMode&&this.getActionButtons().length;};
n.prototype._getNavigateAction=function(){return this._oNavigateAction;};
n.prototype._navigateEventHandler=function(E){E.preventDefault();var u=E.getSource().getParent().getUrl();U.redirect(u,true);};
function _(i,t){var k=false,o=false;if(t._isActionMode()){var A=document.querySelector("#"+t.getId()+"-actionButtons");k=A&&A!==i.target&&A.contains(i.target);}if(t._isNavigateActionEnabled()){var N=document.querySelector("#"+t.getId()+"-navigateActionContainer");o=N&&N!==i.target&&N.contains(i.target);}return k||o;}
return n;});
sap.ui.predefine('sap/m/GenericTileLineModeRenderer',["sap/m/library","sap/base/security/encodeCSS","sap/ui/thirdparty/jquery"],function(l,e,q){"use strict";var G=l.GenericTileScope;var L=l.LoadState;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var a={apiVersion:2};
a.render=function(R,c){var t=c._getTooltipText(),i=c._isScreenLarge(),A=c._getAriaText(),s=c.getScope(),S,I=false,h=c.hasListeners("press"),b=c.getState(),d=c.getAriaRoleDescription(),f=c.getAriaRole();var g=c.getUrl()&&!c._isInActionScope()&&b!==L.Disabled;this._bRTL=sap.ui.getCore().getConfiguration().getRTL();if(s===G.Actions){if(b!==L.Disabled){S=e("sapMGTScopeActions");}}else if(s===G.ActionMore||s===G.ActionRemove){I=true;if(b!==L.Disabled){S=e("sapMGTScopeSingleAction");}}else{S=e("sapMGTScopeDisplay");}if(g){R.openStart("a",c);R.attr("href",c.getUrl());R.attr("rel","noopener noreferrer");R.attr("draggable","false");}else{R.openStart("span",c);}R.attr("aria-label",A);if(d){R.attr("aria-roledescription",d);}else{R.attr("aria-roledescription",r.getText("GENERIC_TILE_ROLE_DESCRIPTION"));}if(f){R.attr("role",f);}else if(!g){R.attr("role",h?"button":"presentation");}else{R.attr("role","link");}R.class("sapMGT");R.class(S);if(s===G.ActionMore){R.style("padding-right","2.25rem");}R.class("sapMGTLineMode");this._writeDirection(R);if(t){R.attr("title",t);}if(b!==L.Disabled){if(!c.isInActionRemoveScope()){R.class("sapMPointer");R.style("pointer-events","auto");}R.attr("tabindex","0");}else{R.class("sapMGTDisabled");}if(b===L.Failed){R.class("sapMGTFailed");}R.openEnd();if(c.getState()!==L.Disabled){this._renderFocusDiv(R,c);}if(i){R.openStart("div",c.getId()+"-startMarker");R.class("sapMGTStartMarker");R.openEnd();R.close("div");this._renderFailedIcon(R,c);this._renderHeader(R,c);if(c.getSubheader()){this._renderSubheader(R,c);}R.openStart("div",c.getId()+"-endMarker");R.class("sapMGTEndMarker");R.openEnd();if(c._isInActionScope()){this._renderActionsScope(R,c,I);}R.close("div");R.openStart("div",c.getId()+"-styleHelper");R.class("sapMGTStyleHelper");R.openEnd();R.close("div");}else{R.openStart("div",c.getId()+"-touchArea");R.class("sapMGTTouchArea");R.openEnd();this._renderFailedIcon(R,c);R.openStart("span",c.getId()+"-lineModeHelpContainer");R.class("sapMGTLineModeHelpContainer");R.openEnd();this._renderHeader(R,c);if(c.getSubheader()){this._renderSubheader(R,c);}R.close("span");if(c._isInActionScope()){this._renderActionsScope(R,c,I);}R.close("div");}if(g){R.close("a");}else{R.close("span");}};
a._writeDirection=function(R){if(this._bRTL){R.attr("dir","rtl");}};
a._renderFailedIcon=function(R,c){if(c.getState()===L.Failed){if(c._isCompact()){c._oWarningIcon.setSize("1.25rem");}else{c._oWarningIcon.setSize("1.375rem");}R.renderControl(c._oWarningIcon.addStyleClass("sapMGTLineModeFailedIcon"));}};
a._renderHeader=function(R,c){R.openStart("span",c.getId()+"-hdr-text");this._writeDirection(R);R.class("sapMGTHdrTxt");R.openEnd();R.text(c._oTitle.getText());R.close("span");};
a._renderSubheader=function(R,c){R.openStart("span",c.getId()+"-subHdr-text");this._writeDirection(R);R.class("sapMGTSubHdrTxt");R.openEnd();R.text(c._oSubTitle.getText());R.close("span");};
a._renderActionsScope=function(R,c,i){if(c.getState()!==L.Disabled){R.openStart("span",c.getId()+"-actions");R.class("sapMGTActionsContainer");if(i){R.class("sapMGTScopeSingleActionContainer");}R.openEnd();R.renderControl(c._oMoreIcon);R.renderControl(c._oRemoveButton);R.close("span");}};
a._updateHoverStyle=function(){var s=this.$("styleHelper");s.empty();if(!this._oStyleData||this.$().is(":hidden")){return;}if(this._oStyleData.rtl){s.css("right",-this._oStyleData.positionRight);}else{s.css("left",-this._oStyleData.positionLeft);}this._oStyleData.lines.forEach(function(o){var R=q("<div class='sapMGTLineStyleHelper'><div class='sapMGTLineStyleHelperInner'></div></div>");if(this._oStyleData.rtl){R.css("right",o.offset.x+"px");}else{R.css("left",o.offset.x+"px");}R.css({top:o.offset.y+"px",width:o.width+"px"});s.append(R);},this);};
a._renderFocusDiv=function(R,c){R.openStart("div",c.getId()+"-focus");R.class("sapMGTFocusDiv");R.openEnd();R.close("div");};
a._getCSSPixelValue=function(o,p){var O=o instanceof q?o:o.$(),m=(O.css(p)||"").match(/([^a-zA-Z\%]*)(.*)/),v=parseFloat(m[1]),u=m[2];return(u==="px")?v:v*16;};
return a;},true);
sap.ui.predefine('sap/m/GenericTileRenderer',["sap/m/library","sap/base/security/encodeCSS"],function(l,e){"use strict";var G=l.GenericTileMode;var L=l.LoadState;var f=l.FrameType;var V=l.ValueColor;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var a={apiVersion:2};
a.render=function(R,c){var t=c._getTooltipText();var A=c._getAriaText();var h=c.getHeaderImage();var H=c.hasListeners("press");var s=c.getState();var S=e("sapMGTState"+s);var b;var d=c.getFrameType();var g=c.getAriaRoleDescription();var j=c.getAriaRole();var k=d===f.OneByHalf||d===f.TwoByHalf;var m=c.getUrl()&&!c._isInActionScope()&&s!==L.Disabled&&!c._isNavigateActionEnabled()&&!c._isActionMode();if(c._isInActionScope()){b=e("sapMGTScopeActions");}else{b=e("sapMGTScopeDisplay");}if(m){R.openStart("a",c);R.attr("href",c.getUrl());R.attr("rel","noopener noreferrer");R.attr("draggable","false");}else{R.openStart("div",c);}if(t&&s!==L.Loading){R.attr("title",t);}R.class("sapMGT");R.class(S);R.class(b);if(!c._isInActionScope()&&c._bShowActionsView){R.class("sapMGTScopeActions");}if(c._isIconMode()){if(d===f.OneByOne){var C="sapMGTOneByOne";}else if(d===f.TwoByHalf){var C="TwoByHalf";}}R.class(c._isIconMode()?C:d);var I=c.getMode()===G.ArticleMode,n=c.getMode()===G.ActionMode;if(n){R.class("sapMGTActionMode");}if(I){R.class("sapMGTArticleMode");}if(c._isIconMode()){R.class("sapMGTIconMode");}if(!I&&!n&&d===f.OneByOne&&c.getSystemInfo()||c.getAppShortcut()){R.class("tileWithAppInfo");}if(c._isIconMode()){if(d===f.TwoByHalf){R.class("sapMGTTwoByHalf");}else{R.style("background-color",c.getBackgroundColor());}}if(j){R.attr("role",j);}else if(!m){R.attr("role",H?"button":"presentation");}else{R.attr("role","link");}if(s===L.Loaded){R.attr("aria-label",A);}if(g){R.attr("aria-roledescription",g);}else{R.attr("aria-roledescription",r.getText("GENERIC_TILE_ROLE_DESCRIPTION"));}if(s!==L.Disabled){if(!c.isInActionRemoveScope()&&c.getPressEnabled()){R.class("sapMPointer");}if(!c.getPressEnabled()){R.class("sapMAutoPointer");}R.attr("tabindex","0");}if(c.getWidth()){R.style("width",c.getWidth());}if(c.getBackgroundImage()){R.style("background-image","url('"+e(c.getBackgroundImage())+"')");R.class("sapMGTBackgroundImage");}if(c.getMode()===G.HeaderMode){R.class("sapMGTHeaderMode");}R.openEnd();var T=c.getTileContent();var o=T.length;var p=false;var q=false;if(s===L.Loading){if(c._isIconMode()){if(d===f.OneByOne){R.openStart("div").class("sapMGTContentShimmerPlaceholderItemOneByOne");R.class("sapMGTContentShimmerPlaceholderWithDescriptionOneByOne");R.openEnd();R.openStart("div").class("sapMGTContentShimmerPlaceholderRowsOneByOne").openEnd();R.openStart("div").class("sapMGTContentShimmerPlaceholderIconOneByOne").class("sapMGTLoadingShimmer").openEnd().close("div");R.openStart("div").class("sapMGTContentShimmerPlaceholderItemTextOneByOne").class("sapMGTLoadingShimmer").openEnd().close("div");}else{R.openStart("div").class("sapMGTContentShimmerPlaceholderItemTwoByHalf");R.class("sapMGTContentShimmerPlaceholderWithDescriptionTwoByHalf");R.openEnd();R.openStart("div").class("sapMGTContentShimmerPlaceholderRowsTwoByHalf").openEnd();R.openStart("div").class("sapMGTContentShimmerPlaceholderIconTwoByHalf").class("sapMGTLoadingShimmer").openEnd().close("div");R.openStart("div").class("sapMGTContentShimmerPlaceholderItemTextTwoByHalf").class("sapMGTLoadingShimmer").openEnd().close("div");}R.close("div");R.close("div");}else{R.openStart("div").class("sapMGTContentShimmerPlaceholderItem");R.class("sapMGTContentShimmerPlaceholderWithDescription");R.openEnd();R.openStart("div").class("sapMGTContentShimmerPlaceholderRows").openEnd();R.openStart("div").class("sapMGTContentShimmerPlaceholderItemHeader").class("sapMGTLoadingShimmer").openEnd().close("div");R.openStart("div").class("sapMGTContentShimmerPlaceholderItemText").class("sapMGTLoadingShimmer").openEnd().close("div");if(!k){R.openStart("div").class("sapMGTContentShimmerPlaceholderItemBox").class("sapMGTLoadingShimmer").openEnd().close("div");R.openStart("div").class("sapMGTContentShimmerPlaceholderItemTextFooter").class("sapMGTLoadingShimmer").openEnd().close("div");}R.close("div");R.close("div");}}else{if(this._isValueColorValid(c.getValueColor())){R.openStart("div");R.class("sapMGTCriticalBorder");R.class(c.getValueColor());R.openEnd();R.close("div");}if(c._isIconMode()){R.openStart("div");if(d===f.OneByOne){R.class("sapMGTOneByOneIcon");}else{R.class("sapMGTTwoByHalfIcon");R.style("background-color",c.getBackgroundColor());}R.openEnd();if(c.getTileIcon()){var u=c._generateIconAggregation(c.getTileIcon());if(u){R.renderControl(c.getAggregation(u));}}R.close("div");}R.openStart("div");R.class("sapMGTHdrContent");if(c._isIconMode()){if(d===f.OneByOne){var C="sapMGTOneByOne";}else if(d===f.TwoByHalf){var C="TwoByHalf";}}R.class(c._isIconMode()?C:d);if(t){R.attr("title",t);}R.openEnd();if(h){c._oImage.removeStyleClass(V.None);if(this._sPreviousStyleClass){c._oImage.removeStyleClass(this._sPreviousStyleClass);}this._sPreviousStyleClass=this._isValueColorValid(c.getValueColor())?c.getValueColor():V.None;c._oImage.addStyleClass(this._sPreviousStyleClass);R.renderControl(c._oImage);}this._renderHeader(R,c);for(var i=0;i<o;i++){p=c._checkFooter(T[i],c)&&T[i].getFooter();if(T[i].getAggregation("content")!==null){if(d===f.OneByHalf&&T[i].getAggregation("content").getMetadata()._sClassName==="sap.m.ImageContent"){q=false;}else{q=true;break;}}}if(!(k&&q)){if(c.getSubheader()&&(!c._isIconMode())){this._renderSubheader(R,c);}}R.close("div");if(!c._isIconMode()){R.openStart("div",c.getId()+"-content");R.class("sapMGTContent");if(p&&d===f.OneByOne&&(c.getSystemInfo()||c.getAppShortcut())){R.class("appInfoWithFooter");}else{R.class("appInfoWithoutFooter");}R.openEnd();for(var i=0;i<o;i++){R.renderControl(T[i]);}R.close("div");}if(!I&&!n&&!c._isIconMode()&&(d===f.OneByOne&&(c.getSystemInfo()||c.getAppShortcut()))){R.openStart("div",c.getId()+"-tInfo");R.class("sapMGTTInfoContainer");R.openEnd();R.openStart("div");R.class("sapMGTTInfo");R.openEnd();if(c.getAppShortcut()){R.openStart("div",c.getId()+"-appShortcut");R.class("sapMGTAppShortcutText").openEnd();R.renderControl(c._oAppShortcut);R.close("div");}if(c.getSystemInfo()){R.openStart("div",c.getId()+"-sytemInfo");R.class("sapMGTSystemInfoText").openEnd();R.renderControl(c._oSystemInfo);R.close("div");}R.close("div");R.close("div");}}if(s!==L.Loaded&&s!==L.Loading){this._renderStateOverlay(R,c,t);}if(s!==L.Disabled){this._renderHoverOverlay(R,c);this._renderFocusDiv(R,c);}if(c._isInActionScope()){this._renderActionsScope(R,c);}if(m){R.close("a");}else{R.close("div");}};
a._renderFocusDiv=function(R,c){R.openStart("div",c.getId()+"-focus");R.class("sapMGTFocusDiv");if(c._isIconMode()){if(c.getFrameType()===f.OneByOne){R.style("border-radius","1rem");}else{R.style("border-radius","0.75rem");}}R.openEnd();R.close("div");};
a._renderStateOverlay=function(R,c,t){var s=c.getState();R.openStart("div",c.getId()+"-overlay");R.class("sapMGTOverlay");if(t){R.attr("title",t);}R.openEnd();switch(s){case L.Loading:c._oBusy.setBusy(s==L.Loading);R.renderControl(c._oBusy);break;case L.Failed:R.openStart("div",c.getId()+"-failed-ftr");R.class("sapMGenericTileFtrFld");R.openEnd();R.openStart("div",c.getId()+"-failed-icon");R.class("sapMGenericTileFtrFldIcn");R.openEnd();R.renderControl(c._oWarningIcon);R.close("div");if(!c._isInActionScope()&&!c._bShowActionsView){R.openStart("div",c.getId()+"-failed-text");R.class("sapMGenericTileFtrFldTxt");R.openEnd();R.renderControl(c.getAggregation("_failedMessageText"));R.close("div");}R.close("div");break;default:}R.close("div");};
a._renderActionsScope=function(R,c){if(c.getState()!==L.Disabled){R.renderControl(c._oRemoveButton);R.renderControl(c._oMoreIcon);}};
a._renderHoverOverlay=function(R,c){R.openStart("div",c.getId()+"-hover-overlay");if(c.getBackgroundImage()){R.class("sapMGTWithImageHoverOverlay");}else{R.class("sapMGTWithoutImageHoverOverlay");if(c._isIconMode()){if(c.getFrameType()===f.OneByOne){R.style("border-radius","1rem");}else{R.style("border-radius","0.75rem");}}}R.openEnd();R.close("div");};
a._renderHeader=function(R,c){R.openStart("div",c.getId()+"-hdr-text");R.class("sapMGTHdrTxt");if(c._isActionMode()&&this._isValueColorValid(c.getValueColor())){R.class("sapMGTCriticalHdrTxt");R.class(c.getValueColor());}R.openEnd();R.renderControl(c._oTitle);R.close("div");};
a._renderSubheader=function(R,c){R.openStart("div",c.getId()+"-subHdr-text");R.class("sapMGTSubHdrTxt");R.openEnd();R.renderControl(c._oSubTitle);R.close("div");};
a._isValueColorValid=function(v){if(v==V.Good||v==V.Error||v==V.Neutral||v==V.Critical){return true;}return false;};
return a;},true);
sap.ui.predefine('sap/m/GroupHeaderListItem',["sap/ui/core/library","./library","./ListItemBase","./GroupHeaderListItemRenderer"],function(c,l,L,G){"use strict";var a=l.ListMode;var T=c.TextDirection;
var b=L.extend("sap.m.GroupHeaderListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:null},count:{type:"string",group:"Data",defaultValue:null},upperCase:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}}}});
b.prototype.getMode=function(){return a.None;};
b.prototype.shouldClearLastValue=function(){return true;};
b.prototype.getTable=function(){var p=this.getParent();if(p&&p.isA("sap.m.Table")){return p;}};
b.prototype.onBeforeRendering=function(){var t=this.getTable();if(t){t.getColumns().forEach(function(C){C.clearLastValue();});this.TagName="tr";}};
b.prototype.getAccessibilityType=function(B){var t=this.getTable()?"ROW":"OPTION";return B.getText("LIST_ITEM_GROUP_HEADER")+" "+B.getText("ACC_CTR_TYPE_"+t);};
b.prototype.getContentAnnouncement=function(){return this.getTitle();};
b.prototype.getGroupAnnouncement=function(){};
return b;});
sap.ui.predefine('sap/m/GroupHeaderListItemRenderer',["sap/ui/core/library","sap/ui/core/Renderer","./ListItemBaseRenderer","./ColumnListItemRenderer"],function(c,R,L,C){"use strict";var T=c.TextDirection;var G=R.extend(L);G.apiVersion=2;
G.renderType=function(r,l){var b=l.getTable()?C:L;b.renderType.apply(this,arguments);};
G.renderNavigated=function(r,l){var b=l.getTable()?C:L;b.renderNavigated.apply(this,arguments);};
G.renderContentLatter=C.renderContentLatter;
G.renderCounter=function(r,l){};
G.renderLIAttributes=function(r,l){r.class("sapMGHLI");if(l.getUpperCase()){r.class("sapMGHLIUpperCase");}};
G.renderLIContentWrapper=function(r,l){var t=l.getTable();if(t){r.openStart("td");r.class("sapMGHLICell");r.attr("colspan",t.getColSpan());r.openEnd();}L.renderLIContentWrapper.apply(this,arguments);if(t){r.close("td");}};
G.renderLIContent=function(r,l){var t=l.getTitleTextDirection();r.openStart("span");r.class("sapMGHLITitle");if(t!=T.Inherit){r.attr("dir",t.toLowerCase());}r.openEnd();r.text(l.getTitle());r.close("span");var i=l.getCount()||l.getCounter();if(i){r.openStart("span");r.class("sapMGHLICounter");r.openEnd();r.text(" ("+i+")");r.close("span");}};
G.addLegacyOutlineClass=function(r,l){var b=l.getTable()?C:L;b.addLegacyOutlineClass.apply(this,arguments);};
G.getAriaRole=function(l){if(l.getTable()){return"row";}return L.getAriaRole.apply(this,arguments);};
return G;},true);
sap.ui.predefine('sap/m/GrowingEnablement',['sap/ui/base/Object','sap/ui/core/format/NumberFormat','sap/m/library','sap/ui/model/ChangeReason','sap/ui/base/ManagedObjectMetadata','sap/ui/core/HTML','sap/m/CustomListItem',"sap/base/security/encodeXML"],function(B,N,l,C,M,H,a,e){"use strict";var L=l.ListType;var b=l.ListGrowingDirection;
var G=B.extend("sap.m.GrowingEnablement",{
constructor:function(c){B.apply(this);this._oControl=c;this._oControl.bUseExtendedChangeDetection=true;this._oControl.addDelegate(this);var r=this._oControl.getItems(true).length;this._iRenderedDataItems=r;this._iLimit=r;this._bLoading=false;this._sGroupingPath="";this._bDataRequested=false;this._oContainerDomRef=null;this._iLastItemsCount=0;this._iTriggerTimer=0;this._aChunk=[];this._oRM=null;},
destroy:function(){if(this._oTrigger){this._oTrigger.destroy();this._oTrigger=null;}if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}if(this._oRM){this._oRM.destroy();this._oRM=null;}this._oControl.$("triggerList").remove();this._oControl.bUseExtendedChangeDetection=false;this._oControl.removeDelegate(this);this._oContainerDomRef=null;this._oControl=null;},
render:function(r){r.openStart("div",this._oControl.getId()+"-triggerList");r.class("sapMListUl").class("sapMGrowingList");r.style("display","none");r.openEnd();r.renderControl(this._getTrigger());r.close("div");},
onAfterRendering:function(){var c=this._oControl;if(c.getGrowingScrollToLoad()){var s=l.getScrollDelegate(c);if(s){this._oScrollDelegate=s;s.setGrowingList(this.onScrollToLoad.bind(this),c.getGrowingDirection(),this._updateTrigger.bind(this,false));}}else if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}if(!this._bLoading){this._updateTriggerDelayed(false);}},
setTriggerText:function(t){this._oControl.$("triggerText").text(t);},
reset:function(){this._iLimit=0;var o=this._oControl.getBindingInfo("items");this._oControl.oExtendedChangeDetectionConfig=(!o||!o.template)?null:{replace:true};},
shouldReset:function(c){var m=C;return c==m.Sort||c==m.Filter||c==m.Context;},
getInfo:function(){return{total:this._oControl.getMaxItemsCount(),actual:this._iRenderedDataItems};},
onScrollToLoad:function(){var t=this._oControl.getDomRef("triggerList");if(this._bLoading||!t||t.style.display!="none"){return;}if(this._oControl.getGrowingDirection()==b.Upwards){var s=this._oScrollDelegate;this._oScrollPosition={left:s.getScrollLeft(),top:s.getScrollHeight()};}this.requestNewPage();},
requestNewPage:function(){if(!this._oControl||this._bLoading){return;}var o=this._oControl.getBinding("items");if(o&&!o.isLengthFinal()||this._iLimit<this._oControl.getMaxItemsCount()){if(this._oControl.getMetadata().hasProperty("enableBusyIndicator")){this._bParentEnableBusyIndicator=this._oControl.getEnableBusyIndicator();this._oControl.setEnableBusyIndicator(false);}this._iLimit+=this._oControl.getGrowingThreshold();this._updateTriggerDelayed(true);this.updateItems("Growing");}},
_onBeforePageLoaded:function(c){this._bLoading=true;this._oControl.onBeforePageLoaded(this.getInfo(),c);},
_onAfterPageLoaded:function(c){this._bLoading=false;this._updateTriggerDelayed(false);this._oControl.onAfterPageLoaded(this.getInfo(),c);if(this._oControl.setEnableBusyIndicator){this._oControl.setEnableBusyIndicator(this._bParentEnableBusyIndicator);}},
_getTrigger:function(){var t=this._oControl.getId()+"-trigger",T=this._oControl.getGrowingTriggerText();T=T||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LOAD_MORE_DATA");this._oControl.addNavSection(t);if(this._oTrigger){this.setTriggerText(T);return this._oTrigger;}this._oTrigger=new a({id:t,busyIndicatorDelay:0,type:L.Active,content:new H({content:'<div class="sapMGrowingListTrigger">'+'<div class="sapMSLIDiv sapMGrowingListTriggerText">'+'<span class="sapMSLITitle" id="'+t+'Text">'+e(T)+'</span>'+'</div>'+'<div class="sapMGrowingListDescription sapMSLIDescription" id="'+t+'Info"></div>'+'</div>'})}).setParent(this._oControl,null,true).attachPress(this.requestNewPage,this).addDelegate({onsapenter:function(E){this.requestNewPage();E.preventDefault();},onsapspace:function(E){this.requestNewPage();E.preventDefault();},onAfterRendering:function(E){var $=this._oTrigger.$();$.removeAttr("aria-selected");$.attr({"tabindex":0,"role":"button","aria-labelledby":t+"Text"+" "+t+"Info"});}},this);this._oTrigger.getList=function(){};this._oTrigger.TagName="div";return this._oTrigger;},
_getListItemInfo:function(){return("[ "+this._iRenderedDataItems+" / "+N.getFloatInstance().format(this._oControl.getMaxItemsCount())+" ]");},
_getGroupingPath:function(o){var s=o.aSorters||[];var S=s[0]||{};return(S.fnGroup)?S.sPath||"":"";},
_getDomIndex:function(i){if(typeof i!="number"){return i;}if(this._oControl.hasPopin&&this._oControl.hasPopin()){return(i*2);}return i;},
_getHasScrollbars:function(){if(!this._oScrollDelegate){return false;}if(this._getDomIndex(this._iRenderedDataItems)>(window.innerHeight/32)){return true;}return this._oScrollDelegate.getMaxScrollTop()>this._oControl.getDomRef("triggerList").clientHeight;},
destroyListItems:function(s){this._oControl.destroyItems(s);this._iRenderedDataItems=0;this._aChunk=[];},
addListItem:function(c,o,s){var d=this._oControl,f=o.binding,i=this.createListItem(c,o);if(f.isGrouped()){var I=d.getItems(true),g=I[I.length-1],m=o.model,h=f.getGroup(i.getBindingContext(m));if(g&&g.isGroupHeader()){d.removeAggregation("items",g,true);this._fnAppendGroupItem=this.appendGroupItem.bind(this,h,g,s);g=I[I.length-1];}if(!g||h.key!==f.getGroup(g.getBindingContext(m)).key){var j=(o.groupHeaderFactory)?o.groupHeaderFactory(h):null;if(d.getGrowingDirection()==b.Upwards){this.applyPendingGroupItem();this._fnAppendGroupItem=this.appendGroupItem.bind(this,h,j,s);}else{this.appendGroupItem(h,j,s);}}}d.addAggregation("items",i,s);if(s){this._aChunk.push(i);}},
applyPendingGroupItem:function(){if(this._fnAppendGroupItem){this._fnAppendGroupItem();this._fnAppendGroupItem=undefined;}},
appendGroupItem:function(g,o,s){o=this._oControl.addItemGroup(g,o,s);if(s){this._aChunk.push(o);}},
createListItem:function(c,o){this._iRenderedDataItems++;return G.createItem(c,o);},
updateItemsBindingContext:function(d,m){if(!d.length){return;}var I=this._oControl.getItems(true);for(var i=0,c=0,o;i<I.length;i++){o=I[i];if(!o.isGroupHeader()){o.setBindingContext(d[c++],m);}}},
applyChunk:function(I,d){this.applyPendingGroupItem();var c=this._aChunk.length;if(!c||!this._oControl.shouldRenderItems()){return;}if(this._oControl.getGrowingDirection()==b.Upwards){this._aChunk.reverse();if(I===true){I=0;}else if(typeof I=="number"){I=this._iRenderedDataItems-c-I;}}d=d||this._oContainerDomRef;this._oRM=this._oRM||sap.ui.getCore().createRenderManager();for(var i=0;i<c;i++){this._oRM.renderControl(this._aChunk[i]);}this._oRM.flush(d,false,this._getDomIndex(I));this._aChunk=[];},
addListItems:function(c,o,s){for(var i=0;i<c.length;i++){this.addListItem(c[i],o,s);}},
rebuildListItems:function(c,o,s){this.destroyListItems(s);this.addListItems(c,o,s);if(s){var h=this._oContainerDomRef.contains(document.activeElement);this.applyChunk(false);h&&this._oControl.focus();}else{this.applyPendingGroupItem();}},
insertListItem:function(c,o,i){var I=this.createListItem(c,o);this._oControl.insertAggregation("items",I,i,true);this._aChunk.push(I);},
deleteListItem:function(i){this._oControl.getItems(true)[i].destroy(true);this._iRenderedDataItems--;},
refreshItems:function(c){if(!this._bDataRequested){this._bDataRequested=true;this._onBeforePageLoaded(c);}if(!this._iLimit||this.shouldReset(c)||!this._oControl.getItems(true).length){this._iLimit=this._oControl.getGrowingThreshold();}this._oControl.getBinding("items").getContexts(0,this._iLimit);},
updateItems:function(c){var o=this._oControl,d=o.getBinding("items"),f=o.getBindingInfo("items"),I=o.getItems(true);if(!this._iLimit||this.shouldReset(c)||!I.length){this._iLimit=o.getGrowingThreshold();}if(this._bDataRequested){this._bDataRequested=false;}else{this._onBeforePageLoaded(c);}var g=d.getContexts(0,this._iLimit)||[];if(g.dataRequested){this._bDataRequested=true;if(g.diff&&!g.diff.length){return;}}this._oContainerDomRef=o.getItemsContainerDomRef();var D=g.diff,F=false,v;if(!g.length){this.destroyListItems();}else if(!this._oContainerDomRef){this.rebuildListItems(g,f);}else if(!D||!I.length&&D.length){this.rebuildListItems(g,f,o.shouldGrowingSuppressInvalidation());}else if(d.isGrouped()||o.checkGrowingFromScratch()){if(this._sGroupingPath!=this._getGroupingPath(d)){F=true;}else{for(var i=0;i<D.length;i++){var h=D[i],j=g[h.index];if(h.type=="delete"||h.type=="replace"){F=true;break;}else if(h.index!=this._iRenderedDataItems){F=true;break;}else{this.addListItem(j,f,true);v=true;}}}}else{if(this._sGroupingPath){o.removeGroupHeaders(true);}v=-1;var k=-1;for(var i=0;i<D.length;i++){var h=D[i],m=h.index,j=g[m];if(h.type=="delete"){if(v!=-1){this.applyChunk(v);k=-1;v=-1;}this.deleteListItem(m);}else if(h.type=="insert"){if(v==-1){v=m;}else if(k>-1&&m!=k+1){this.applyChunk(v);v=m;}this.insertListItem(j,f,m);k=m;}}}if(F){this.rebuildListItems(g,f,true);}else if(this._oContainerDomRef&&D){this.updateItemsBindingContext(g,f.model);this.applyChunk(v);}this._oContainerDomRef=null;this._sGroupingPath=this._getGroupingPath(d);if(!this._bDataRequested){this._onAfterPageLoaded(c);}},
_updateTriggerDelayed:function(c){if(this._oControl.getGrowingScrollToLoad()){this._iTriggerTimer&&window.cancelAnimationFrame(this._iTriggerTimer);this._iTriggerTimer=window.requestAnimationFrame(this._updateTrigger.bind(this,c));}else{this._updateTrigger(c);}},
_updateTrigger:function(c){var t=this._oTrigger,o=this._oControl,v=o&&o.getVisibleItems().length>0;if(!t||!o||!v||!o.shouldRenderItems()||!o.getDomRef()){return;}var d=o.getBinding("items");if(!d){return;}t.setBusy(c);t.$().toggleClass("sapMGrowingListBusyIndicatorVisible",c);if(c){t.setActive(false);o.$("triggerList").css("display","");}else{var i=o.getItems(true),I=i.length,f=d.getLength()||0,g=d.isLengthFinal(),h=o.getGrowingScrollToLoad(),T=t.getDomRef();if(T&&T.contains(document.activeElement)){(i[this._iLastItemsCount]||o).focus();}if(!I||!this._iLimit||!f||(g&&this._iLimit>=f)||(h&&this._getHasScrollbars())){o.$("triggerList").css("display","none");o.$("listUl").removeClass("sapMListHasGrowing");}else{if(g){o.$("triggerInfo").css("display","block").text(this._getListItemInfo());}o.$("triggerList").css("display","");o.$("listUl").addClass("sapMListHasGrowing");t.$().removeClass("sapMGrowingListBusyIndicatorVisible");if(o.isA("sap.m.Table")&&!o.hasPopin()){this.adaptTriggerButtonWidth(o,T);}}this._iLastItemsCount=this._oControl.getItems(true).length;if(h&&this._oScrollPosition===undefined&&o.getGrowingDirection()==b.Upwards){this._oScrollPosition={left:0,top:0};}if(I>0&&this._oScrollPosition){var s=this._oScrollDelegate,S=this._oScrollPosition;s.scrollTo(S.left,s.getScrollHeight()-S.top);this._oScrollPosition=null;}}},
adaptTriggerButtonWidth:function(c,t){if(c.shouldRenderDummyColumn()&&c.$("listUl").hasClass("sapMListHasGrowing")){if(!t){t=this._oTrigger.getDomRef();}window.requestAnimationFrame(function(){if(c.bIsDestroyed){return;}var s=Array.from(c.getDomRef("tblHeader").childNodes).slice(0,-1).map(function(d){var w=d.getAttribute("data-sap-width");if(!w||!w.includes("%")){return d.getBoundingClientRect().width+"px";}else{return w;}}).join(" + ");t.style.width="calc("+s+" + 1px)";t.classList.add("sapMGrowingListDummyColumn");});}}
});
G.createItem=function(c,o,i){var I=o.factory(M.uid(i?i:"clone"),c);return I.setBindingContext(c,o.model);};
return G;});
sap.ui.predefine('sap/m/GrowingList',['./List','./library','./GrowingListRenderer'],function(L,l,G){"use strict";
var a=L.extend("sap.m.GrowingList",{metadata:{deprecated:true,library:"sap.m",properties:{threshold:{type:"int",group:"Misc",defaultValue:20},triggerText:{type:"string",group:"Appearance",defaultValue:null},scrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false}}}});
a.prototype._isIncompatible=function(){return sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMGrowingList").compareTo("1.16")>=0;};
a.prototype.init=function(){L.prototype.init.call(this);if(!this._isIncompatible()){this.setGrowing();}};
a.prototype.setGrowing=function(){return L.prototype.setGrowing.call(this,true);};
!(function(g,o){["Threshold","TriggerText","ScrollToLoad"].forEach(function(p){g["set"+p]=o["setGrowing"+p];g["get"+p]=o["getGrowing"+p];});}(a.prototype,L.prototype));return a;});
sap.ui.predefine('sap/m/GrowingListRenderer',['./ListRenderer','sap/ui/core/Renderer',"sap/base/Log"],function(L,R,a){"use strict";var G=R.extend(L);G.apiVersion=2;
G.render=function(r,c){if(c._isIncompatible()){a.warning("Does not render sap.m.GrowingList#"+c.getId()+" when compatibility version is 1.16 or higher. Instead use sap.m.List/Table control with growing feature!");}else{L.render.call(this,r,c);}};
return G;},true);
sap.ui.predefine('sap/m/HBox',['./FlexBox','./library','./HBoxRenderer'],function(F,l,H){"use strict";
var a=F.extend("sap.m.HBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/HBox.designtime"}});
return a;});
sap.ui.predefine('sap/m/HBoxRenderer',['./FlexBoxRenderer'],function(F){"use strict";var H={apiVersion:2};
H.render=function(r,c){F.render.apply(this,[r,c]);};
return H;},true);
sap.ui.predefine('sap/m/HeaderContainer',['./library','./Button','./ScrollContainer','sap/ui/core/Core','sap/ui/core/Control','sap/ui/Device','sap/m/HeaderContainerItemNavigator','sap/ui/core/delegate/ItemNavigation','sap/ui/core/library','sap/ui/core/IntervalTrigger','sap/ui/core/Icon','./HeaderContainerRenderer',"sap/base/Log","sap/ui/events/KeyCodes","sap/ui/events/PseudoEvents","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/Selectors"],function(l,B,S,C,a,D,H,I,c,b,d,e,L,K,P,q){"use strict";var O=c.Orientation;
var f=a.extend("sap.m.HeaderContainerItemContainer",{
metadata:{defaultAggregation:"item",properties:{position:{type:"int",defaultValue:null},setSize:{type:"int",defaultValue:null},ariaLabelledBy:{type:"string",defaultValue:null}},aggregations:{item:{type:"sap.ui.core.Control",multiple:false}}},
renderer:{apiVersion:2,render:function(r,o){var i=o.getAggregation("item");if(!i||!i.getVisible()){return;}r.openStart("div",o);r.class("sapMHdrCntrItemCntr");r.class("sapMHrdrCntrInner");r.attr("aria-setsize",o.getSetSize());r.attr("aria-posinset",o.getPosition());r.attr("role","listitem");if(o.getAriaLabelledBy()){r.attr("aria-labelledby",o.getAriaLabelledBy());}r.openEnd();r.renderControl(i);r.close("div");}}
});
var g=a.extend("sap.m.HeaderContainer",{metadata:{interfaces:["sap.m.ObjectHeaderContainer"],library:"sap.m",properties:{scrollStep:{type:"int",defaultValue:300,group:"Behavior"},scrollStepByItem:{type:"int",defaultValue:1,group:"Behavior"},scrollTime:{type:"int",defaultValue:500,group:"Behavior"},showOverflowItem:{type:"boolean",defaultValue:true,group:"Behavior"},showDividers:{type:"boolean",defaultValue:true,group:"Appearance"},orientation:{type:"sap.ui.core.Orientation",defaultValue:O.Horizontal,group:"Appearance"},backgroundDesign:{type:"sap.m.BackgroundDesign",defaultValue:l.BackgroundDesign.Transparent,group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_scrollContainer:{type:"sap.m.ScrollContainer",multiple:false,visibility:"hidden"},_prevButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_nextButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{scroll:{}}}});
g.prototype.init=function(){this._aItemEnd=[];this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oScrollCntr=new S(this.getId()+"-scrl-cntnr",{width:"100%",height:"100%",horizontal:!D.system.desktop});this.setAggregation("_scrollContainer",this._oScrollCntr,true);if(D.system.desktop){this._oArrowPrev=new B({id:this.getId()+"-scrl-prev-button",type:l.ButtonType.Transparent,tooltip:this._oRb.getText("HEADERCONTAINER_BUTTON_PREV_SECTION"),press:function(E){E.cancelBubble();this._scroll(this._getScrollValue(false),this.getScrollTime());}.bind(this)}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrLeft");this._oArrowPrev._bExcludeFromTabChain=true;this.setAggregation("_prevButton",this._oArrowPrev,true);this._oArrowNext=new B({id:this.getId()+"-scrl-next-button",type:l.ButtonType.Transparent,tooltip:this._oRb.getText("HEADERCONTAINER_BUTTON_NEXT_SECTION"),press:function(E){E.cancelBubble();this._scroll(this._getScrollValue(true),this.getScrollTime());}.bind(this)}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrRight");this._oArrowNext._bExcludeFromTabChain=true;this.setAggregation("_nextButton",this._oArrowNext,true);}else if(D.system.phone||D.system.tablet){this._oArrowPrev=new d({id:this.getId()+"-scrl-prev-button"}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrLeft");this.setAggregation("_prevButton",this._oArrowPrev,true);this._oArrowNext=new d({id:this.getId()+"-scrl-next-button"}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrRight");this.setAggregation("_nextButton",this._oArrowNext,true);}this._oScrollCntr.addDelegate({onAfterRendering:function(){if(D.system.desktop){var F=this._oScrollCntr.getDomRef("scroll");var o=this._oScrollCntr.$("scroll");var h=o.find(".sapMHrdrCntrInner").attr("tabindex","0");F.setAttribute("role","list");if(!this._oItemNavigation){this._oItemNavigation=new H();this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._handleBorderReached,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._handleAfterFocus,this);this._oItemNavigation.attachEvent(I.Events.BeforeFocus,this._handleBeforeFocus,this);if(D.browser.msie||D.browser.edge){this._oItemNavigation.attachEvent(I.Events.FocusAgain,this._handleFocusAgain,this);}}this._oItemNavigation.setRootDomRef(F);this._oItemNavigation.setItemDomRefs(h);this._oItemNavigation.setTabIndex0();this._oItemNavigation.setCycling(false);this._handleMobileScrolling();}}.bind(this)});b.addListener(this._checkOverflow,this);};
g.prototype.onBeforeRendering=function(){var i=this.getOrientation()===O.Horizontal,s=i?"sap-icon://slim-arrow-left":"sap-icon://slim-arrow-up",h=i?"sap-icon://slim-arrow-right":"sap-icon://slim-arrow-down";if(!this.getHeight()){L.warning("No height provided",this);}if(!this.getWidth()){L.warning("No width provided",this);}if(D.system.desktop){this._oArrowPrev.setProperty("icon",s,true);this._oArrowNext.setProperty("icon",h,true);}else if(D.system.phone||D.system.tablet){this._oArrowPrev.setProperty("src",s,true);this._oArrowNext.setProperty("src",h,true);}this.getContent();};
g.prototype.onAfterRendering=function(){this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._checkOverflow();};
g.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}b.removeListener(this._checkOverflow,this);};
g.prototype.onsaptabnext=function(E){var F=this.$().find(":focusable");var t=F.index(E.target);var n=F.eq(t+1).get(0);var o=this._getParentCell(E.target);var T;if(n){T=this._getParentCell(n);}if((o&&T&&o.id!==T.id)||(n&&n.id===this.getId()+"-after")||(n&&n.id===this.getId()+"-scrl-prev-button")||(n&&n.id===this.getId()+"-scrl-next-button")){var h=F.last().get(0);if(h){this._bIgnoreFocusIn=true;h.focus();}}};
g.prototype.onsaptabprevious=function(E){this.$().find(".sapMHdrCntrItemCntr").css("border-color","");var F=this.$().find(":focusable");var t=F.index(E.target);var p=F.eq(t-1).get(0);var o=this._getParentCell(E.target);var T;if(p){T=this._getParentCell(p);}if(!T||o&&o.id!==T.id){var s=this.$().attr("tabindex");this.$().attr("tabindex","0");this.$().trigger("focus");if(!s){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",s);}}};
g.prototype.setOrientation=function(v){this.setProperty("orientation",v);if(v===O.Horizontal&&!D.system.desktop){this._oScrollCntr.setHorizontal(true);this._oScrollCntr.setVertical(false);}else if(!D.system.desktop){this._oScrollCntr.setHorizontal(false);this._oScrollCntr.setVertical(true);}return this;};
g.prototype.validateAggregation=function(A,o,m){return this._callSuperMethod("validateAggregation",A,o,m);};
g.prototype.getAggregation=function(A,o,s){return this._callSuperMethod("getAggregation",A,o,s);};
g.prototype.setAggregation=function(A,o,s){return this._callSuperMethod("setAggregation",A,o,s);};
g.prototype.indexOfAggregation=function(A,o){return this._callSuperMethod("indexOfAggregation",A,o);};
g.prototype.insertAggregation=function(A,o,i,s){return this._callSuperMethod("insertAggregation",A,o,i,s);};
g.prototype.addAggregation=function(A,o,s){return this._callSuperMethod("addAggregation",A,o,s);};
g.prototype.removeAggregation=function(A,o,s){return this._callSuperMethod("removeAggregation",A,o,s);};
g.prototype.removeAllAggregation=function(A,s){return this._callSuperMethod("removeAllAggregation",A,s);};
g.prototype.destroyAggregation=function(A,s){return this._callSuperMethod("destroyAggregation",A,s);};
g.prototype.onkeydown=function(E){var h=this.getOrientation()===O.Horizontal,$=this.$("prev-button-container"),i=this.$("next-button-container"),s,j=0,k=this._filterVisibleItems();if(E.which===K.ARROW_RIGHT&&h){s=k[E.srcControl.mProperties.position-1].$().parent().outerWidth(true);if(s<this._getSize($.is(":visible"))){this._scroll((s-j),this.getScrollTime());}}else if(E.which===K.ARROW_LEFT&&h){s=k[E.srcControl.mProperties.position-1].$().parent().outerWidth(true);if(s<this._getSize(i.is(":visible"))){if(!i.is(":visible")){var m=10;if(s+m<this._getSize(true)){j=i.width()+m;}else{j=i.width();}}this._scroll(-(s-j),this.getScrollTime());}}if(E.which===K.ARROW_DOWN&&!h){s=k[E.srcControl.mProperties.position-1].$().parent().outerHeight(true);if(s<this._getSize($.is(":visible"))){this._scroll((s-j),this.getScrollTime());}}else if(E.which===K.ARROW_UP&&!h){s=k[E.srcControl.mProperties.position-1].$().parent().outerHeight(true);if(s<this._getSize(i.is(":visible"))){if(!i.is(":visible")){var m=10;if(s+m<this._getSize(true)){j=i.height()+m;}else{j=i.wheightidth();}}this._scroll(-(s-j),this.getScrollTime());}}};
g.prototype._setScrollInProcess=function(v){this.bScrollInProcess=v;};
g.prototype._scroll=function(i,h){this._setScrollInProcess(true);this.fireScroll();setTimeout(this._setScrollInProcess.bind(this,false),h+300);if(this.getOrientation()===O.Horizontal){this._hScroll(i,h);}else{this._vScroll(i,h);}};
g.prototype._vScroll=function(h,i){var o=this._oScrollCntr.getDomRef(),s=o.scrollTop,j=o.scrollHeight,k=s+h,m=o.clientHeight,p=parseFloat(this.$("scroll-area").css("padding-top")),r;if(k<=0){r=this._calculateRemainingScrolling(h,i,s);this.$("scroll-area").css("transition","padding "+r+"s");this.$().removeClass("sapMHrdrTopPadding");}else if(k+m+p>=j){r=this._calculateRemainingScrolling(h,i,j-m-s);this.$("scroll-area").css("transition","padding "+r+"s");if(m+h>j&&m!==j){this.$().removeClass("sapMHrdrBottomPadding");this.$().addClass("sapMHrdrTopPadding");}else{this.$().removeClass("sapMHrdrBottomPadding");}}else{this.$("scroll-area").css("transition","padding "+i/1000+"s");}this._oScrollCntr.scrollTo(0,k,i);};
g.prototype._hScroll=function(h,i){var o=this._oScrollCntr.getDomRef();var s,j,k,m,p,r;if(!this._bRtl){j=o.scrollLeft;m=o.scrollWidth;k=o.clientWidth+(D.browser.msie?1:0);s=j+h;p=parseFloat(this.$("scroll-area").css("padding-left"));if(s<=0){r=this._calculateRemainingScrolling(h,i,j);this.$("scroll-area").css("transition","padding "+r+"s");this.$().removeClass("sapMHrdrLeftPadding");}else if(s+o.clientWidth+p>=m){r=this._calculateRemainingScrolling(h,i,m-k-j);this.$("scroll-area").css("transition","padding "+r+"s");if(k+h>m&&k!==m){this.$().removeClass("sapMHrdrRightPadding");this.$().addClass("sapMHrdrLeftPadding");}else{this.$().removeClass("sapMHrdrRightPadding");}}else{this.$("scroll-area").css("transition","padding "+i/1000+"s");}this._oScrollCntr.scrollTo(s,0,i);}else{s=q(o).scrollRightRTL()+h;this._oScrollCntr.scrollTo((s>0)?s:0,0,i);}};
g.prototype._collectItemSize=function(){var s=0,h=this._filterVisibleItems(),F=this.getOrientation()===O.Horizontal?"outerWidth":"outerHeight";this._aItemEnd=[];h.forEach(function(o,i){s+=o.$().parent()[F](true);this._aItemEnd[i]=s;},this);};
g.prototype._getScrollValue=function(F){if(!this._oScrollCntr){return 0;}var h=this.getOrientation()===O.Horizontal,$=this._oScrollCntr.$(),j=this.$("prev-button-container"),m=this.$("next-button-container"),s=h?$[0].scrollLeft:$[0].scrollTop,t=0,n=0,o,p=this._filterVisibleItems();var G=function(k){var n=0,u=0;var v=10;if(this._bRtl&&h){if(!j.is(":visible")){u=j.width();}if(!m.is(":visible")){u=m.width();}}for(var i=0;i<p.length&&i<k;i++){n+=r(p[i]);}return n!==0?n+v-u:0;}.bind(this);var r=function(k){return h?k.$().parent().outerWidth(true):k.$().parent().outerHeight(true);};var E=function(){var n=this._getSize(true),M,A=0;for(var i=t;i<p.length;i++){if(!p[i].$().is(":visible")){M=r(p[i])+G(i)-n-s;for(var k=t;k<p.length&&k<i;k++){if(o+A>M){break;}t++;A+=r(p[k]);}o+=A;break;}}}.bind(this);if(this.getScrollStepByItem()>0){s=h&&this._bRtl?$.scrollRightRTL():s;for(var i=0;i<p.length;i++){n+=r(p[i]);if(n>=s){t=i;break;}}t=(F?1:-1)*this.getScrollStepByItem()+t;if(t<0){t=0;}if(t>=p.length){t=p.length-1;}o=G(t)-s;if(F&&!this.getShowOverflowItem()){E();}return o;}return F?this.getScrollStep():-this.getScrollStep();};
g.prototype._calculateRemainingScrolling=function(h,i,j){return Math.abs(j*i/(1000*h));};
g.prototype._checkOverflow=function(){if(this.getOrientation()===O.Horizontal){this._checkHOverflow();}else{this._checkVOverflow();}};
g.prototype._filterVisibleItems=function(){return this.getContent().filter(function(i){return i.getVisible();});};
g.prototype._getFirstItemOffset=function(t){var F=this._filterVisibleItems()[0],$=F&&F.$(),h=$&&$.parent(),i=h&&h[0]&&h[0][t];return i||0;};
g.prototype._checkVOverflow=function(){var o=this._oScrollCntr.getDomRef(),h,$;if(o){var F=this._getFirstItemOffset("offsetTop");var s=Math.ceil(o.scrollTop);var i=false;var j=false;var r=o.scrollHeight;var k=o.offsetHeight;if(Math.abs(r-k)===1){r=k;}if(s>F){i=true;}if((r>k)&&(s+k<r)){j=true;}j=this._checkForOverflowItem(j);$=this.$("prev-button-container");h=$.is(":visible");if(h&&!i){$.hide();this.$().removeClass("sapMHrdrTopPadding");}if(!h&&i){$.show();this.$().addClass("sapMHrdrTopPadding");}$=this.$("next-button-container");var m=$.is(":visible");if(m&&!j){$.hide();this.$().removeClass("sapMHrdrBottomPadding");}if(!m&&j){$.show();this.$().addClass("sapMHrdrBottomPadding");}}};
g.prototype._handleMobileScrolling=function(){if(C.isMobile()){var $=this.$("scrl-cntnr-scroll"),i=this.getOrientation()===O.Horizontal,p=i?"clientX":"clientY",h=0,t=this,s=false;$.on("touchstart",function(E){s=true;h=E.targetTouches[0][p];});$.on("touchmove",function(E){if(s){var j=E.targetTouches[0][p],k=h-j,o=t._oScrollCntr.getDomRef();i?o.scrollLeft+=k:o.scrollTop+=k;h=j;E.preventDefault();}});$.on("touchend",function(){s=false;});}};
g.prototype._checkHOverflow=function(){var o=this._oScrollCntr.getDomRef(),$;if(o){var F=this._getFirstItemOffset("offsetLeft");var s=Math.ceil(o.scrollLeft);var h=false;var i=false;var r=o.scrollWidth;var j=o.offsetWidth;if(Math.abs(r-j)===1){r=j;}if(this._bRtl){var k=q(o).scrollLeftRTL();if(k>((D.browser.msie||D.browser.edge)?1:0)){i=true;}}else if(s>F){h=true;}if(r-5>j){if(this._bRtl){if(q(o).scrollRightRTL()>1){h=true;}}else if(s+j<r){i=true;}}$=this.$("prev-button-container");i=this._checkForOverflowItem(i);var m=$.is(":visible");if(m&&!h){$.hide();this.$().removeClass("sapMHrdrLeftPadding");}if(!m&&h){$.show();this.$().addClass("sapMHrdrLeftPadding");}$=this.$("next-button-container");var n=$.is(":visible");if(n&&!i){$.hide();this.$().removeClass("sapMHrdrRightPadding");}if(!n&&i){$.show();this.$().addClass("sapMHrdrRightPadding");}}};
g.prototype._getSize=function(A){var $=this._oScrollCntr.$(),h=this.getOrientation()===O.Horizontal,i=this.$("next-button-container"),j=!i.is(":visible")&&A,F=h?"width":"height";return $[F]()-(j?i[F]():0);};
g.prototype._checkForOverflowItem=function(s){if(this._oScrollCntr&&!this.getShowOverflowItem()){var $=this._oScrollCntr.$(),h=this.getOrientation()===O.Horizontal,j=!h?$[0].scrollTop:(this._bRtl?$.scrollRightRTL():$[0].scrollLeft),F=h?"width":"height",k=this._getSize(s),m=this._filterVisibleItems();this._collectItemSize();this._aItemEnd.forEach(function(E,i){var n=m[i].$(),o=n.parent(),v=n.is(":visible");if(s&&E>j+k){if(i===0||this._aItemEnd[i-1]<=j){o.css(F,"auto");n.show();}else if(v){o[F](o[F]());n.hide();s=true;}}else{if(!v){o.css(F,"auto");n.show();}}},this);}return s;};
g.prototype._handleBorderReached=function(E){if(D.browser.msie&&this.bScrollInProcess){return;}var i=E.getParameter("index");if(i===0){this._scroll(this._getScrollValue(false),this.getScrollTime());}else if(i===this._filterVisibleItems().length-1){this._scroll(this._getScrollValue(true),this.getScrollTime());}};
g.prototype._handleAfterFocus=function(E){var s=E.getParameter("event");if((D.browser.msie||D.browser.edge)&&s.type==="mousedown"&&s.srcControl instanceof sap.m.Input){s.srcControl.focus();}if(D.browser.msie&&this.bScrollInProcess){return;}var i=E.getParameter("index");if(i===0){this._scroll(this._getScrollValue(false),this.getScrollTime());}else if(i===this._filterVisibleItems().length-1){this._scroll(this._getScrollValue(true),this.getScrollTime());}};
g.prototype._handleFocusAgain=function(E){var s=E.getParameter("event");if((D.browser.msie||D.browser.edge)&&s.type==="mousedown"&&s.srcControl instanceof sap.m.Input){s.srcControl.focus();}E.getParameter("event").preventDefault();};
g.prototype._handleBeforeFocus=function(E){var o=E.getParameter("event");if(q(o.target).hasClass("sapMHdrCntrItemCntr")||q(o.target).hasClass("sapMScrollContScroll")||P.events.sapprevious.fnCheck(o)||P.events.sapnext.fnCheck(o)){this.$().find(".sapMHdrCntrItemCntr").css("border-color","");}else{this.$().find(".sapMHdrCntrItemCntr").css("border-color","transparent");}};
g.prototype._unWrapHeaderContainerItemContainer=function(w){if(w instanceof f){w=w.getItem();}else if(Array.isArray(w)){for(var i=0;i<w.length;i++){if(w[i]instanceof f){w[i]=w[i].getItem();}}}return w;};
g._AGGREGATION_FUNCTIONS=["validateAggregation","getAggregation","setAggregation","indexOfAggregation","removeAggregation"];g._AGGREGATION_FUNCTIONS_FOR_INSERT=["insertAggregation","addAggregation"];
g.prototype._callSuperMethod=function(F,A){var h=Array.prototype.slice.call(arguments);if(A==="content"){var o=h[2];h[1]="content";if(o instanceof a){if(g._AGGREGATION_FUNCTIONS.indexOf(F)>-1&&o.getParent()instanceof f){h[2]=o.getParent();}else if(g._AGGREGATION_FUNCTIONS_FOR_INSERT.indexOf(F)>-1){h[2]=new f({item:o});}}var j=[];this._oScrollCntr.getContent().forEach(function(o,s){if(!o.getItem()){j.push(s);}});for(var i=0;i<j.length;i++){this._oScrollCntr.removeContent(j[i]);}var r=this._oScrollCntr[F].apply(this._oScrollCntr,h.slice(1));if(F!=="removeAllAggregation"){var k=this._oScrollCntr.getContent();var m=this.getAriaLabelledBy();var p=1;var v=k.filter(function(s){return s.getItem().getVisible();}).length;for(var i=0;i<k.length;i++){var n=k[i];if(n.getItem().getVisible()){n.setVisible(true);n.setPosition(p);n.setSetSize(v);n.setAriaLabelledBy(m[i]);p++;}else{n.setVisible(false);}}}return this._unWrapHeaderContainerItemContainer(r);}else{return a.prototype[F].apply(this,h.slice(1));}};
g.prototype._callMethodInManagedObject=function(){throw new TypeError("Method no longer exists: HeaderContainer.prototype._callMethodInManagedObject");};
g.prototype._getParentCell=function(o){return q(o).parents(".sapMHrdrCntrInner").andSelf(".sapMHrdrCntrInner").get(0);};
g.prototype.onfocusin=function(E){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;return;}if(E.target.id===this.getId()+"-after"){this._restoreLastFocused();}};
g.prototype._restoreLastFocused=function(){if(!this._oItemNavigation){return;}var n=this._oItemNavigation.getItemDomRefs();var i=this._oItemNavigation.getFocusedIndex();var $=q(n[i]);var r=$.control(0)||{};var t=r.getTabbables?r.getTabbables():$.find(":sapTabbable");t.eq(-1).add($).eq(-1).trigger("focus");};
return g;});
sap.ui.predefine('sap/m/HeaderContainerItemNavigator',["sap/ui/core/delegate/ItemNavigation","sap/base/assert","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes"],function(I,a,c,K){"use strict";
var H=I.extend("sap.m.HeaderContainerItemNavigator");
H.prototype.focusItem=function(i,e){if(e.type==="mousedown"){var f=this.aItemDomRefs[i].focus;this.aItemDomRefs[i].focus=function(){};this._callParent("focusItem",arguments);this.aItemDomRefs[i].focus=f;return;}this._callParent("focusItem",arguments);};
H.prototype._callParent=function(f,A){if(typeof I.prototype[f]==="function"){I.prototype[f].apply(this,A);}};
H.prototype.onsaphome=function(e){if(this._skipNavigation(e)){return;}this._callParent("onsaphome",arguments);};
H.prototype.onsapend=function(e){if(this._skipNavigation(e)){return;}this._callParent("onsapend",arguments);};
H.prototype.onsapnext=function(e){if(this._skipNavigation(e)){return;}this._callParent("onsapnext",arguments);};
H.prototype.onsapprevious=function(e){if(this._skipNavigation(e,true,false)){return;}this._callParent("onsapprevious",arguments);};
H.prototype._skipNavigation=function(e){return Array.prototype.indexOf.call(this.aItemDomRefs,e.target)===-1;};
return H;});
sap.ui.predefine('sap/m/HeaderContainerRenderer',['sap/ui/core/library'],function(c){"use strict";var O=c.Orientation;var H={apiVersion:2};
H.render=function(r,C){var t=C.getTooltip_AsString();var o=C.getOrientation();var b="sapMHdrCntrBG"+C.getBackgroundDesign();r.openStart("div",C);if(t){r.attr("title",t);}r.class("sapMHdrCntr");r.class(o);if(C.getShowDividers()){r.class("sapMHrdrCntrDvdrs");}if(C.getHeight()){r.style("height",C.getHeight());}else{r.style("height",(C.getOrientation()===O.Horizontal)?"auto":"100%");}if(C.getWidth()){r.style("width",C.getWidth());}else{r.style("width",(C.getOrientation()===O.Horizontal)?"100%":"auto");}r.openEnd();r.openStart("div",C.getId()+"-scroll-area");r.class("sapMHdrCntrCntr");r.class(o);r.class(b);r.openEnd();r.renderControl(C.getAggregation("_scrollContainer"));r.close("div");var B=C.getAggregation("_prevButton");if(B){r.openStart("div",C.getId()+"-prev-button-container");r.class("sapMHdrCntrBtnCntr");r.class("sapMHdrCntrLeft");r.class(o);r.openEnd();r.renderControl(B);r.close("div");}B=C.getAggregation("_nextButton");if(B){r.openStart("div",C.getId()+"-next-button-container");r.class("sapMHdrCntrBtnCntr");r.class("sapMHdrCntrRight");r.class(o);r.openEnd();r.renderControl(B);r.close("div");}r.openStart("div",C.getId()+"-after");r.attr("tabindex","0");r.openEnd().close("div");r.close("div");};
return H;},true);
sap.ui.predefine('sap/m/HyphenationSupport',["sap/ui/core/Core","./library","sap/ui/core/hyphenation/Hyphenation","sap/base/Log"],function(C,l,H,L){"use strict";var W=l.WrappingType;
function i(o){if(!o.isA("sap.m.IHyphenation")){L.error("[UI5 Hyphenation] The given control does not implement interface sap.m.IHyphenation and can not use HyphenationSupport mixin.");return false;}return true;}
function a(o,k){var t=o.getTextsToBeHyphenated();if(typeof t!=="object"){L.error("[UI5 Hyphenation] The result of getTextsToBeHyphenated method is not a map object.",o.getId());return false;}if(Object.keys(t).indexOf(k)<0){L.error("[UI5 Hyphenation] The key "+k+" is not found in the result of getTextsToBeHyphenated method.",o.getId());return false;}return true;}
function s(D,n){n=n||"";var f=D.childNodes;if(f.length===1&&f[0].nodeType===window.Node.TEXT_NODE){f[0].nodeValue=n;}else{D.textContent=n;}}
function d(t,T){var D=[];Object.keys(t).forEach(function(k){if(!(k in T&&t[k]===T[k])){D.push(k);}});return D;}
function b(){var f=C.getConfiguration().getHyphenation(),o=H.getInstance();if(f==="native"||f==="disable"){return false;}if(f==="thirdparty"){return true;}return o.isLanguageSupported()&&!o.canUseNativeHyphenation()&&o.canUseThirdPartyHyphenation();}
function c(o){var f=C.getConfiguration().getHyphenation();if(f==='disable'){return false;}if(o.getWrapping&&!o.getWrapping()&&o.getWrappingType()===W.Hyphenated){L.warning("[UI5 Hyphenation] The property wrappingType=Hyphenated will not take effect unless wrapping=true.",o.getId());}return(!o.getWrapping||o.getWrapping())&&o.getWrappingType()===W.Hyphenated;}
function h(o){if(!c(o)||!b()){o._mHyphenatedTexts={};o._mUnhyphenatedTexts={};return;}var t=o.getTextsToBeHyphenated(),f=d(t,o._mUnhyphenatedTexts);if(f.length>0){o._mUnhyphenatedTexts=t;f.forEach(function(k){delete o._mHyphenatedTexts[k];});var g=H.getInstance();if(!g.isLanguageInitialized()){g.initialize().then(function(){var D=o.isActive()?o.getDomRefsForHyphenatedTexts():null,n=false;f.forEach(function(k){o._mHyphenatedTexts[k]=g.hyphenate(t[k]);if(D&&k in D){s(D[k],o._mHyphenatedTexts[k]);}else{n=true;}});if(n){o.invalidate();}});}else{f.forEach(function(k){o._mHyphenatedTexts[k]=g.hyphenate(t[k]);});}}}
var e={};
e.mixInto=function(o){if(!i(o)){return;}var I=o.init;o.init=function(f){var r=I.apply(this,arguments);this._mHyphenatedTexts={};this._mUnhyphenatedTexts={};return r;};var O=o.onBeforeRendering;o.onBeforeRendering=function(){var r=O.apply(this,arguments);h(this);return r;};};
e.writeHyphenationClass=function(r,o){if(!i(o)){return;}if(c(o)&&!b()){r.class("sapUiHyphenation");}};
e.getTextForRender=function(o,k){if(!i(o)){return null;}if(!a(o,k)){return null;}var t=o.getTextsToBeHyphenated();if(c(o)&&b()){if(t[k]!==o._mUnhyphenatedTexts[k]){h(o);}if(k in o._mHyphenatedTexts){return o._mHyphenatedTexts[k];}}return t[k];};
return e;});
sap.ui.predefine('sap/m/IconTabBar',['./library',"sap/ui/core/Core",'sap/ui/core/Control','./IconTabBarRenderer','./IconTabHeader',"sap/ui/core/util/ResponsivePaddingsEnablement","sap/ui/thirdparty/jquery"],function(l,C,a,I,b,R,q){"use strict";var c=l.IconTabHeaderMode;var B=l.BackgroundDesign;var d=l.IconTabDensityMode;var T=l.TabsOverflowMode;
var e=a.extend("sap.m.IconTabBar",{metadata:{interfaces:["sap.m.ObjectHeaderContainer","sap.f.IDynamicPageStickyContent"],library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},expandable:{type:"boolean",group:"Misc",defaultValue:true},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data",defaultValue:null},upperCase:{type:"boolean",group:"Appearance",defaultValue:false},stretchContentHeight:{type:"boolean",group:"Appearance",defaultValue:false},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Solid},headerMode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:c.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},headerBackgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false},maxNestingLevel:{type:"int",group:"Behavior",defaultValue:0},tabDensityMode:{type:"sap.m.IconTabDensityMode",group:"Appearance",defaultValue:d.Cozy},ariaTexts:{type:"object",group:"Accessibility",defaultValue:null},tabsOverflowMode:{type:"sap.m.TabsOverflowMode",group:"Behavior",defaultValue:T.End}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",forwarding:{getter:"_getIconTabHeader",aggregation:"items",forwardBinding:true}},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_header:{type:"sap.m.IconTabHeader",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"},previousKey:{type:"string"},selectedItem:{type:"sap.m.IconTabFilter"},selectedKey:{type:"string"}}},expand:{parameters:{expand:{type:"boolean"},collapse:{type:"boolean"}}}},designtime:"sap/m/designtime/IconTabBar.designtime"}});
R.call(e.prototype,{header:{selector:".sapMITH"},content:{suffix:"content"}});e._CLASSES_TO_COPY=["sapUiResponsiveContentPadding","sapUiNoContentPadding","sapUiContentPadding"];
e.prototype.init=function(){this._initResponsivePaddingsEnablement();};
e.prototype.setExpanded=function(E){this.setProperty("expanded",E,true);if(this.$().length){this._toggleExpandCollapse(E);}return this;};
e.prototype.setHeaderMode=function(m){this.setProperty("headerMode",m,true);this._getIconTabHeader().setMode(m);return this;};
e.prototype.setTabDensityMode=function(m){this.setProperty("tabDensityMode",m);this._getIconTabHeader().setTabDensityMode(m);return this;};
e.prototype.setHeaderBackgroundDesign=function(h){this.setProperty("headerBackgroundDesign",h,true);this._getIconTabHeader().setBackgroundDesign(h);return this;};
e.prototype.setEnableTabReordering=function(v){this.setProperty("enableTabReordering",v,true);this._getIconTabHeader().setEnableTabReordering(v);return this;};
e.prototype.setAriaTexts=function(A){this.setProperty("ariaTexts",A,true);this._getIconTabHeader().setAriaTexts(A);return this;};
e.prototype.addStyleClass=function(s,S){var i=this._getIconTabHeader();if(e._CLASSES_TO_COPY.indexOf(s)!==-1){i.addStyleClass(s,true);}return a.prototype.addStyleClass.apply(this,arguments);};
e.prototype.removeStyleClass=function(s,S){var i=this._getIconTabHeader();if(e._CLASSES_TO_COPY.indexOf(s)!==-1){i.removeStyleClass(s,true);}return a.prototype.removeStyleClass.apply(this,arguments);};
e.prototype._rerenderContent=function(o){var $=this.$("content");if(o&&($.length>0)){var r=C.createRenderManager();for(var i=0;i<o.length;i++){r.renderControl(o[i]);}r.flush($[0]);r.destroy();}};
e.prototype._toggleExpandCollapse=function(E){var $=this.$("content");var s=this._getIconTabHeader().oSelectedItem;if(E===undefined){E=!this.getExpanded();}if(s){s.$().toggleClass("sapMITBSelected",E);s.$().attr({'aria-expanded':E});if(E){s.$().attr({'aria-selected':E});}else{s.$().removeAttr('aria-selected');}}this._iAnimationCounter=(this._iAnimationCounter===undefined?1:++this._iAnimationCounter);if(E){if(s){if(this.$("content").children().length===0){var S=s.getContent();if(S.length>0){this._rerenderContent(S);}else{this._rerenderContent(this.getContent());}}$.stop(true,true).slideDown('400',q.proxy(this.onTransitionEnded,this,E));this.$("containerContent").toggleClass("sapMITBContentClosed",!E);}}else{this.$("contentArrow").hide();$.stop(true,true).slideUp('400',q.proxy(this.onTransitionEnded,this,E));}if(!E||s){this.setProperty("expanded",E,true);}this.fireExpand({expand:E,collapse:!E});return this;};
e.prototype.onTransitionEnded=function(E){var $=this.$("content"),f=this.$("containerContent"),g=this.$("contentArrow");if(this._iAnimationCounter===1){f.toggleClass("sapMITBContentClosed",!E);if(E){g.show();$.css("display","block");}else{g.hide();$.css("display","none");}}this._iAnimationCounter=(this._iAnimationCounter>0?--this._iAnimationCounter:0);return this;};
e.prototype._getIconTabHeader=function(){var o=this.getAggregation("_header");if(!o){o=new b(this.getId()+"--header",{});this.setAggregation("_header",o,true);}return o;};
e.prototype._getStickyContent=function(){return this._getIconTabHeader();};
e.prototype._returnStickyContent=function(){if(this.bIsDestroyed){return;}this._getStickyContent().$().prependTo(this.$());};
e.prototype._setStickySubheaderSticked=function(i){this._bStickyContentSticked=i;};
e.prototype._getStickySubheaderSticked=function(){return this._bStickyContentSticked;};
e.prototype.onBeforeRendering=function(){var i=this._getIconTabHeader(),$=i.$();i.setMaxNestingLevel(this.getMaxNestingLevel());i.setTabsOverflowMode(this.getTabsOverflowMode());if(this._bStickyContentSticked&&$){delete this._bStickyContentSticked;this._getIconTabHeader().$().remove();}};
e.prototype.setShowSelection=function(v){this._getIconTabHeader().setShowSelection(v);return this;};
e.prototype.getShowSelection=function(){return this._getIconTabHeader().getShowSelection();};
e.prototype.setSelectedKey=function(v){this._getIconTabHeader().setSelectedKey(v);return this;};
e.prototype.getSelectedKey=function(){return this._getIconTabHeader().getSelectedKey();};
e.prototype.setSelectedItem=function(i,A){return this._getIconTabHeader().setSelectedItem(i,A);};
return e;});
sap.ui.predefine('sap/m/IconTabBarDragAndDropUtil',['sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo',"sap/ui/events/KeyCodes",'sap/ui/core/library'],function(D,a,K,c){"use strict";var b=c.dnd.DropPosition;var I="Before",d="insertBefore",e="insertAfter",i,f="IconTabReorder",g="Forward",h="Backward";var j={_insertControl:function(i,o,k,l){var $=o.$(),m=k.$(),n=[],p=[];if(o._getNestedLevel()>1&&k._getNestedLevel()>1){n=o._getRootTab()._getSelectList().getItems().filter(function(q){return o._getRealTab()._isParentOf(q._getRealTab());});p=k._getRootTab()._getSelectList().getItems().filter(function(q){return k._getRealTab()._isParentOf(q._getRealTab());});}if(l){var O=o._getRootTab().getParent()._getOverflow()._getSelectList().getItems();n=O.filter(function(q){return o._getRealTab()._isParentOf(q._getRealTab());});p=O.filter(function(q){return k._getRealTab()._isParentOf(q._getRealTab());});}if(i===e){$.insertAfter(m);}else{$.insertBefore(m);}n.reverse().forEach(function(C){C.$().insertAfter($);});p.reverse().forEach(function(C){C.$().insertAfter(m);});},handleDrop:function(C,s,o,k,l,m){var B=C.indexOfItem(o),n=C.indexOfItem(k),A=0,r=sap.ui.getCore().getConfiguration().getRTL(),p=s===I,q=k._getNestedLevel()-1;if(o._isParentOf(k)){return;}if(q===m&&s===b.On){return;}if(r&&!l){if(p){A=B<n?n:n+1;i=e;}else{A=B<n?n-1:n;i=d;}}else{if(p){A=B<n?n-1:n;i=d;}else{A=B<n?n:n+1;i=e;}}if(C.isA("sap.m.IconTabFilter")||!o.getParent().isA("sap.m.IconTabHeader")){if(p){A=n;}else{A=n+1;}}j._insertControl(i,o,k);if(s===b.On){if(k===o){return;}A=C.getAggregation("items").length;}j._handleConfigurationAfterDragAndDrop.call(C,o,A);},_updateAccessibilityInfo:function(){var o=this.getItems(),A=1,k;o.forEach(function(l){k=l.getDomRef();if(k&&k.getAttribute("aria-posinset")!==null){k.setAttribute("aria-posinset",A++);}});},_handleConfigurationAfterDragAndDrop:function(o,k){var l=[],m=this.isA("sap.m.IconTabHeader")?this:this._getIconTabHeader();if(this.isA("sap.m.IconTabBarSelectList")){l=this.getItems().filter(function(p){return o._getRealTab()._isParentOf(p._getRealTab());});}m._setPreserveSelection(true);this.removeAggregation('items',o,true);this.insertAggregation('items',o,k,true);l.forEach(function(p){this.removeAggregation('items',p,true);}.bind(this));var n=1+this.indexOfAggregation('items',o);l.reverse().forEach(function(p){this.insertAggregation('items',p,n,true);}.bind(this));m._setPreserveSelection(false);j._updateAccessibilityInfo.call(this);},_decreaseDropIndex:function(B,k){var p=B-1;while(p>=0&&(k[B]._getRealTab()._getNestedLevel()!==k[p]._getRealTab()._getNestedLevel()||!k[p].getVisible()||(!k[B].$().hasClass("sapMITBFilterHidden")&&k[p].$().hasClass("sapMITBFilterHidden")))){p--;}if(p<0){i=e;return B;}i=d;return p;},_increaseDropIndex:function(B,k,m){var n=B+1;while(n<k.length&&(k[B]._getRealTab()._getNestedLevel()!==k[n]._getRealTab()._getNestedLevel()||!k[n].getVisible())){n++;}if(n>m){i=d;return B;}i=e;return n;},moveItem:function(o,k,m){var l=this.getItems(),B=this.indexOfItem(o),r=sap.ui.getCore().getConfiguration().getRTL(),n,p;if(this.isA("sap.m.IconTabFilter")){l=this._getRealTab().getItems();}switch(k){case K.HOME:n=0;i=d;break;case K.END:n=l.length-1;i=e;break;case K.ARROW_LEFT:if(r){p=j.preventDragBetweenSubItems(o,g,this);n=j._increaseDropIndex(B,l,m);}else{p=j.preventDragBetweenSubItems(o,h,this);n=j._decreaseDropIndex(B,l);}break;case K.ARROW_RIGHT:if(r){p=j.preventDragBetweenSubItems(o,h,this);n=j._decreaseDropIndex(B,l);}else{p=j.preventDragBetweenSubItems(o,g,this);n=j._increaseDropIndex(B,l,m);}break;case K.ARROW_DOWN:p=j.preventDragBetweenSubItems(o,g,this);n=j._increaseDropIndex(B,l,m);break;case K.ARROW_UP:p=j.preventDragBetweenSubItems(o,h,this);n=j._decreaseDropIndex(B,l);break;default:return false;}if(p){return false;}if(!this.isA("sap.m.IconTabFilter")){var q=l[n];j._insertControl(i,o,q,this._oTabFilter&&this._oTabFilter._bIsOverflow);}j._handleConfigurationAfterDragAndDrop.call(this,o,n);return true;},setDragDropAggregations:function(k,s,o){var l=k._oIconTabHeader?k._oIconTabHeader:k;var m=l.getId();k.addDragDropConfig(new D({sourceAggregation:"items",groupName:f+m}));k.addDragDropConfig(new a({targetAggregation:"items",dropPosition:o,dropLayout:s,drop:k._handleDragAndDrop.bind(k),groupName:f+m}));},preventDragBetweenSubItems:function(o,s,C){var p=false;if(C.isA("sap.m.IconTabBarSelectList")){var r=o._getRealTab(),P=r.getParent(),k=P.getItems();if((k.indexOf(r)===0&&s===h)||(k.indexOf(r)+1===k.length&&s===g)||k.length===1){p=true;}}return p;}};return j;});
sap.ui.predefine('sap/m/IconTabBarRenderer',[],function(){"use strict";var I={apiVersion:2};I._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault'];
I.render=function(r,i){var c=i.getContent(),h=i._getIconTabHeader();r.openStart("div",i).class("sapMITB");if(i.getStretchContentHeight()){r.class("sapMITBStretch");}if(!i.getApplyContentPadding()){r.class("sapMITBNoContentPadding");}r.class("sapMITBBackgroundDesign"+i.getBackgroundDesign()).openEnd();if(!i._bHideHeader){r.renderControl(h);}r.openStart("div",i.getId()+"-containerContent").class("sapMITBContainerContent");if(!i.getExpanded()){r.class("sapMITBContentClosed");}r.openEnd();r.openStart("div",i.getId()+"-content").class("sapMITBContent").attr("role","tabpanel");if(!i.getExpanded()){r.style("display","none");}if(h.oSelectedItem){r.accessibilityState({labelledby:h.oSelectedItem.getId()});}r.openEnd();if(i.getExpanded()){if(h.oSelectedItem&&h.oSelectedItem.getContent()){var C=h.oSelectedItem.getContent();if(C.length>0){c=C;}}c.forEach(function(o){r.renderControl(o);});}r.close("div").close("div").close("div");};
return I;},true);
sap.ui.predefine('sap/m/IconTabBarSelectList',["./library","./IconTabBarDragAndDropUtil","./IconTabBarSelectListRenderer","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","sap/ui/core/theming/Parameters","sap/ui/core/library","sap/ui/thirdparty/jquery"],function(l,I,a,C,b,P,c,q){"use strict";var D=c.dnd.DropPosition;
var d=C.extend("sap.m.IconTabBarSelectList",{metadata:{library:"sap.m",aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",dnd:true}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.m.IconTabFilter"}}}}}});
d.prototype.init=function(){this._oItemNavigation=new b();this._oItemNavigation.setCycling(false);this.addEventDelegate(this._oItemNavigation);this._oItemNavigation.setPageSize(10);this._oIconTabHeader=null;this._oTabFilter=null;};
d.prototype.exit=function(){this._oItemNavigation.destroy();this._oItemNavigation=null;this._oIconTabHeader=null;this._oTabFilter=null;};
d.prototype.onBeforeRendering=function(){if(!this._oIconTabHeader){return;}this.destroyDragDropConfig();this._setsDragAndConfiguration();};
d.prototype.onAfterRendering=function(){this._initItemNavigation();this.getItems().forEach(function(i){if(i._onAfterParentRendering){i._onAfterParentRendering();}});};
d.prototype._setsDragAndConfiguration=function(){if(this._oIconTabHeader.getEnableTabReordering()&&!this.getDragDropConfig().length){I.setDragDropAggregations(this,"Vertical",this._oIconTabHeader._getDropPosition());}};
d.prototype._initItemNavigation=function(){var e=this.getItems(),f=[],p=this._oIconTabHeader.oSelectedItem,s=-1,o,i;for(i=0;i<e.length;i++){o=e[i];if(o.isA("sap.m.IconTabFilter")){var g=o._getAllSubFiltersDomRefs();f=f.concat(o.getDomRef(),g);}if(p&&this.getSelectedItem()&&this.getSelectedItem()._getRealTab()===p){s=i;}}if(p&&f.indexOf(p.getDomRef())!==-1){s=f.indexOf(p.getDomRef());}this._oItemNavigation.setRootDomRef(this.getDomRef()).setItemDomRefs(f).setSelectedIndex(s);};
d.prototype.getVisibleItems=function(){return this.getItems().filter(function(i){return i.getVisible();});};
d.prototype.getVisibleTabFilters=function(){return this.getVisibleItems().filter(function(i){return i.isA("sap.m.IconTabFilter");});};
d.prototype.setSelectedItem=function(i){this._selectedItem=i;};
d.prototype.getSelectedItem=function(){return this._selectedItem;};
d.prototype._getIconTabHeader=function(){return this._oIconTabHeader;};
d.prototype._getParams=function(){var p=Object.assign({"_sap_m_IconTabBar_SelectListItem_PaddingLeft":"0.5rem","_sap_m_IconTabBar_SelectListItem_PaddingLeftAdditional":"0"},P.get({name:["_sap_m_IconTabBar_SelectListItem_PaddingLeft","_sap_m_IconTabBar_SelectListItem_PaddingLeftAdditional"],callback:this.invalidate.bind(this)}));return{fNestedItemPaddingLeft:Number.parseFloat(p["_sap_m_IconTabBar_SelectListItem_PaddingLeft"]),fAdditionalPadding:Number.parseFloat(p["_sap_m_IconTabBar_SelectListItem_PaddingLeftAdditional"])};};
d.prototype._checkTextOnly=function(){return this.getItems().every(function(i){return i.isA('sap.m.IconTabSeparator')||!i.getIcon();});};
d.prototype.ontap=function(e){var t=e.srcControl;if(!t){return;}if(!t.isA("sap.m.IconTabFilter")){return;}if(this._oIconTabHeader._isUnselectable(t)){return;}e.preventDefault();if(t!=this.getSelectedItem()){this.fireSelectionChange({selectedItem:t});}};
d.prototype.onsapenter=d.prototype.ontap;d.prototype.onsapspace=d.prototype.ontap;
d.prototype.checkIconOnly=function(){this._bIconOnly=this.getVisibleTabFilters().every(function(i){return!i.getText()&&!i.getCount();});return this._bIconOnly;};
d.prototype._handleDragAndDrop=function(e){var s=e.getParameter("dropPosition"),o=e.getParameter("draggedControl"),f=e.getParameter("droppedControl"),g=f._getRealTab().getParent(),h=this._oIconTabHeader.getMaxNestingLevel();if(this._oTabFilter._isOverflow()){g=this._oIconTabHeader;}if(s===D.On){g=f._getRealTab();}I.handleDrop(g,s,o._getRealTab(),f._getRealTab(),true,h);this._oIconTabHeader._setItemsForStrip();this._oIconTabHeader._initItemNavigation();this._oTabFilter._setSelectListItems();this._initItemNavigation();f._getRealTab().getParent().$().trigger("focus");};
d.prototype.ondragrearranging=function(e){if(!this._oIconTabHeader.getEnableTabReordering()){return;}var t=e.srcControl,k=e.keyCode,i=this.indexOfItem(t),o=this;I.moveItem.call(o,t,k,o.getItems().length-1);this._initItemNavigation();t.$().trigger("focus");if(i===this.indexOfItem(t)){return;}o=t._getRealTab().getParent();if(this._oTabFilter._isOverflow()&&t._getRealTab()._getNestedLevel()===1){this._oIconTabHeader._moveTab(t._getRealTab(),k,this._oIconTabHeader.getItems().length-1);}else{I.moveItem.call(o,t._getRealTab(),k,o.getItems().length-1);}};
d.prototype.onsaphomemodifiers=d.prototype.ondragrearranging;d.prototype.onsapendmodifiers=d.prototype.ondragrearranging;d.prototype.onsapincreasemodifiers=d.prototype.ondragrearranging;d.prototype.onsapdecreasemodifiers=d.prototype.ondragrearranging;return d;});
sap.ui.predefine('sap/m/IconTabBarSelectListRenderer',["sap/ui/core/library"],function(c){"use strict";var I=c.IconColor;var a={apiVersion:2};
a.render=function(r,s){var p=s._getParams(),i=s.getVisibleItems(),o=s._oIconTabHeader,t=s._checkTextOnly(),T=o.getVisibleTabFilters().length,n=p.fNestedItemPaddingLeft,e=false;var h=i.filter(function(b){return b.isA("sap.m.IconTabFilter");}).some(function(b){return b.getIconColor()!==I.Default;});s.checkIconOnly();var A=p.fAdditionalPadding;if(h&&A){n+=A;e=true;}this.renderList(r,i,s,o,t,n,e,T);};
a.renderList=function(r,b,s,o,t,p,e,S){if(!b.length){return;}r.openStart("ul",s).attr("role","menu").class("sapMITBSelectList");if(t){r.class("sapMITBSelectListTextOnly");}r.openEnd();for(var i=0;i<b.length;i++){var d=b[i],f;if(o&&d.isA("sap.m.IconTabFilter")){f=o.getVisibleTabFilters().indexOf(d._getRealTab());}if(d.isA("sap.m.IconTabFilter")&&d._getRootTab()._getSelectList()===s){f=i;S=b.length;}var l=d._getNestedLevel()-2;if(e){l++;}if(s._bIsOverflow){l++;}d.renderInSelectList(r,s,f,S,p*l);}r.close("ul");};
return a;},true);
sap.ui.predefine('sap/m/IconTabFilter',["./library","./AccButton","./IconTabFilterExpandButtonBadge","sap/ui/core/library","sap/ui/core/Core","sap/ui/core/Item","sap/ui/core/Renderer","sap/ui/core/IconPool",'sap/ui/core/InvisibleMessage','sap/ui/Device',"sap/m/BadgeCustomData","sap/m/Button","sap/m/ResponsivePopover","sap/m/IconTabBarSelectList","sap/m/BadgeEnabler"],function(l,A,I,c,C,a,R,b,d,D,B,e,f,g,h){"use strict";var T=c.TextAlign;var j=c.TextDirection;var k=l.ButtonType;var P=l.PlacementType;var m=l.ImageHelper;var n=l.IconTabFilterDesign;var o=l.BadgeStyle;var p=l.BadgeState;var q=c.IconColor;var r=c.aria.HasPopup;var s=3000;var t=c.InvisibleMessageMode;var u=-8;
var v=a.extend("sap.m.IconTabFilter",{metadata:{interfaces:["sap.m.IconTab","sap.ui.core.PopupInterface","sap.m.IBadge"],library:"sap.m",designtime:"sap/m/designtime/IconTabFilter.designtime",properties:{count:{type:"string",group:"Data",defaultValue:''},showAll:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},iconColor:{type:"sap.ui.core.IconColor",group:"Appearance",defaultValue:q.Default},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},design:{type:"sap.m.IconTabFilterDesign",group:"Appearance",defaultValue:n.Vertical}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},items:{type:"sap.m.IconTab",multiple:true,singularName:"item"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButtonBadge:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
h.call(v.prototype);var w=C.getLibraryResourceBundle("sap.m");v._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault','sapMITBFilterNeutral'];
v.prototype._getImageControl=function(i,x,y){var z={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};if(z.src){this._oImageControl=m.getImageControl(this.getId()+"-icon",this._oImageControl,x,z,i,y);}else if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null;}return this._oImageControl;};
v.prototype.init=function(){this._oDragEventDelegate={onlongdragover:this._handleOnLongDragOver,ondragover:this._handleOnDragOver,ondragleave:this._handleOnDragLeave,ondrop:this._handleOnDrop};this.initBadgeEnablement({style:o.Attention,selector:{selector:".sapMITBBadgeHolder"}});this._oCloneInList=null;this.setAggregation("_expandButtonBadge",new I());};
v.prototype.exit=function(E){if(this._oImageControl){this._oImageControl.destroy();}if(a.prototype.exit){a.prototype.exit.call(this,E);}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}if(this._oExpandButton){this._oExpandButton.removeEventDelegate(this._oDragEventDelegate);this._oExpandButton.destroy();this._oExpandButton=null;}this.removeEventDelegate(this._oDragEventDelegate);this._oDragEventDelegate=null;if(this._iHideBadgeTimeout){clearTimeout(this._iHideBadgeTimeout);}};
v.prototype.invalidate=function(){var i=this.getParent(),x,O;if(!i){return;}x=i.getParent();if(!(x instanceof sap.m.IconTabBar)){i.invalidate();return;}O=x.getParent();if(O instanceof sap.m.ObjectHeader){O.invalidate();}else{x.invalidate();}};
v.prototype.setProperty=function(i,V,S){switch(i){case'textDirection':case'text':case'count':case'showAll':case'icon':case'iconColor':case'iconDensityAware':case'design':if(this.getProperty(i)===V){return this;}a.prototype.setProperty.call(this,i,V,true);if(!S){var x=this.getParent();if(x instanceof sap.m.IconTabHeader){x.invalidate();}}break;default:a.prototype.setProperty.apply(this,arguments);break;}return this;};
v.prototype._getNonEmptyKey=function(){var K=this.getKey();if(K){return K;}return this.getId();};
v.prototype._getRealTab=function(){return this._oRealItem||this;};
v.prototype._getRootTab=function(){var i=this._getRealTab(),x=i.getParent();while(x&&x.isA("sap.m.IconTabFilter")){i=x;x=x.getParent();}return i;};
v.prototype._getNestedLevel=function(){var i=this._getRealTab().getParent(),L;for(L=1;i&&i.isA("sap.m.IconTabFilter");L++){i=i.getParent();}return L;};
v.prototype.render=function(i,V,x){if(!this.getVisible()){return;}var y=this.getParent(),z=y.getParent();if(y.getEnableTabReordering()){this._prepareDragEventDelegate();}var H=y._isInsideIconTabBar(),E={role:"tab"},F=this.getId(),G=this.getCount(),J=this.getText(),K=this.getIcon(),L=this.getIconColor(),M=this.getEnabled(),S=this._shouldReadIconColor(),N=this.getDesign()===n.Horizontal,O=y._bTextOnly,Q=y._bInLine||y.isInlineMode(),U=this.getShowAll(),W=this.getTextDirection();if(this._isOverflow()){E.role="button";}if(H){E.controls=z.getId()+"-content";}if(this.getItems().length){E.roledescription=w.getText("ICONTABFILTER_SPLIT_TAB");}if(J.length||G!==""||K){var X=[];if(G!==""&&!Q){X.push(F+"-count");}if(J.length){X.push(F+"-text");}if(K){X.push(F+"-icon");}if(S){X.push(F+"-iconColor");}E.labelledby=X.join(" ");}if(V!==undefined&&x!==undefined){Object.assign(E,{posinset:V+1,setsize:x});}i.openStart("div",this).accessibilityState(E).class("sapMITBItem");if(!G){i.class("sapMITBItemNoCount");}if(N){i.class("sapMITBHorizontal");}else{i.class("sapMITBVertical");}if(U){i.class("sapMITBAll");}else{i.class("sapMITBFilter");}if(!U&&M){i.class("sapMITBFilter"+L);}if(y._isUnselectable(this)){i.class("sapMITHUnselectable");}if(this.getItems().length>0){i.class("sapMITBFilterWithItems");}if(!M){i.class("sapMITBDisabled").attr("aria-disabled",true);}if(!this._isOverflow()){i.attr("aria-selected",false);}var Y=this.getTooltip_AsString();if(Y){i.attr("title",Y);}if(this._isOverflow()||this.getItems().length){i.attr("aria-haspopup","menu");}i.openEnd();if(S){this._renderIconColorDescription(i);}i.openStart("div").class("sapMITBFilterWrapper").openEnd();if(!Q){i.openStart("div",F+"-tab").class("sapMITBTab").openEnd();if(!U||!K){var Z=["sapMITBFilterIcon","sapMITBBadgeHolder"];if(M){Z.push("sapMITBFilter"+L);}i.renderControl(this._getImageControl(Z,y,v._aAllIconColors));}if(!U&&!K&&!O){i.openStart("span").class("sapMITBFilterNoIcon").openEnd().close("span");}if(N&&!U){i.close("div");i.openStart("div").class("sapMITBHorizontalWrapper").openEnd();}i.openStart("span",F+"-count").class("sapMITBCount");if(U||(!K&&!J.length)){i.class("sapMITBBadgeHolder");}i.openEnd();if(G===""&&N){i.unsafeHtml("&nbsp;");}else{i.text(G);}i.close("span");if(!N){i.close("div");}}if(J.length){i.openStart("div",F+"-text").class("sapMITBText");if(!K&&!U){i.class("sapMITBBadgeHolder");}if(H&&z.getUpperCase()){i.class("sapMITBTextUpperCase");}i.openEnd();if(Q&&K){this._renderIcon(i);}i.openStart("span").class("sapMITHTextContent").attr("dir",W!==j.Inherit?W.toLowerCase():"auto");i.openEnd().text(y._getDisplayText(this)).close("span");if(this._isOverflow()||this.getItems().length&&y._isUnselectable(this)){i.openStart("span",this.getId()+"-expandButton").class("sapMITHShowSubItemsIcon").openEnd();i.icon(b.getIconURI("slim-arrow-down"),null,{"title":null,"aria-hidden":true});i.close("span");}i.close("div");}if(!Q&&N){i.close("div");}i.openStart("div").class("sapMITBContentArrow").openEnd().close("div");i.close("div");if(this.getItems().length&&!y._isUnselectable(this)){i.openStart("span").accessibilityState({role:"separator"}).openEnd().close("span");i.renderControl(this._getExpandButton());}i.renderControl(this.getAggregation("_expandButtonBadge"));if(this.getItems().length){this._updateExpandButtonBadge();}i.close("div");};
v.prototype.renderInSelectList=function(i,S,x,y,z){if(!this.getVisible()){return;}var E=S._bIconOnly,F=true,G=S._oIconTabHeader,H=this.getIconColor(),J=this.getEnabled();if(G){F=S._checkTextOnly();}i.openStart("li",this).class("sapMITBSelectItem").attr("tabindex","-1").attr("role","menuitem");if(z){i.style("padding-left",z+"rem");}if(x!==undefined&&y!==undefined){i.attr("aria-posinset",x+1);i.attr("aria-setsize",y);i.attr("aria-level",this._getNestedLevel());}var K=this.getTooltip_AsString();if(K){i.attr("title",K);}if(G._isUnselectable(this)){i.class("sapMITHUnselectable");}if(!J){i.class("sapMITBDisabled").attr("aria-disabled",true);}if(S.getSelectedItem()==this){i.class("sapMITBSelectItemSelected");i.attr("aria-selected",true);}if(J){i.class("sapMITBFilter"+H);}var L=this.getId(),M=this._shouldReadIconColor(),N=[];if(!E){N.push(L+"-text");}if(!F&&this.getIcon()){N.push(L+"-icon");}if(M){N.push(L+"-iconColor");}i.accessibilityState({labelledby:N.join(" ")}).openEnd();if(M){this._renderIconColorDescription(i);}if(!F){this._renderIcon(i,E);}if(!E){this._renderText(i);}i.close("li");};
v.prototype._onAfterParentRendering=function(){this._renderBadge();d.getInstance();};
v.prototype._renderIcon=function(i,x){var y=this.getIcon();if(y){var z=b.getIconInfo(y),E=["sapMITBSelectItemIcon"];if(z&&!z.suppressMirroring){E.push("sapUiIconMirrorInRTL");}if(x){E.push("sapMITBBadgeHolder");}if(this._getIconTabHeader().isInlineMode()){E.push("sapMITBInlineIcon");}i.icon(y,E,{id:this.getId()+"-icon","aria-hidden":true});}else{i.openStart("span").class("sapUiIcon").openEnd().close("span");}};
v.prototype._renderIconColorDescription=function(i){i.openStart("div",this.getId()+"-iconColor").style("display","none").openEnd().text(w.getText("ICONTABBAR_ICONCOLOR_"+this.getIconColor().toUpperCase())).close("div");};
v.prototype._renderText=function(i){var x=this.getText(),y=this.getCount(),z=C.getConfiguration().getRTL(),E=this.getTextDirection();i.openStart("span",this.getId()+"-text").attr("dir",E!==j.Inherit?E.toLowerCase():"auto").class("sapMText").class("sapMTextNoWrap").class("sapMITBText").class("sapMITBBadgeHolder");var F=R.getTextAlign(T.Begin,E);if(F){i.style("text-align",F);}if(y){if(z){x='('+y+') '+x;}else{x+=' ('+y+')';}}i.openEnd().text(x).close("span");};
v.prototype._getSelectList=function(){if(!this._oSelectList){this._oSelectList=new g({selectionChange:function(E){var i=E.getParameter("selectedItem");this._oIconTabHeader.setSelectedItem(i._getRealTab());this._oTabFilter._closePopover();}});this._oSelectList._oIconTabHeader=this.getParent();this._oSelectList._oTabFilter=this;this._oSelectList._bIsOverflow=this._isOverflow();}return this._oSelectList;};
v.prototype._prepareDragEventDelegate=function(){if(this.getEnabled()){this.addEventDelegate(this._oDragEventDelegate,this);}else{this.removeEventDelegate(this._oDragEventDelegate);}};
v.prototype._updateTabCountText=function(){if(!this._isOverflow()){return;}var i=this._getIconTabHeader()._getItemsForOverflow(this._bIsStartOverflow,true).filter(function(x){return x.isA("sap.m.IconTabFilter");}).length;this.setText("+"+i);};
v.prototype._getExpandButton=function(){this._oExpandButton=this.getAggregation("_expandButton");if(!this._oExpandButton){this._oExpandButton=new A(this.getId()+"-expandButton",{type:k.Transparent,icon:b.getIconURI("slim-arrow-down"),tooltip:w.getText("ICONTABHEADER_OVERFLOW_MORE"),tabIndex:"-1",ariaHasPopup:r.Menu,press:this._expandButtonPress.bind(this)}).addStyleClass("sapMITBFilterExpandBtn");this.setAggregation("_expandButton",this._oExpandButton);}return this._oExpandButton;};
v.prototype._updateExpandButtonBadge=function(){var E=this.getAggregation("_expandButtonBadge"),H=E.getBadgeCustomData()&&E.getBadgeCustomData().getVisible(),i=this._hasChildWithBadge();if(i&&!H){E.addCustomData(new B({visible:true}));}else if(!i&&H){E.getBadgeCustomData().setVisible(false);}};
v.prototype._hasChildWithBadge=function(){var i=this._isOverflow()?this._getIconTabHeader()._getItemsForOverflow(this._bIsStartOverflow):this._getAllSubItems();return i.some(function(x){return x.isA("sap.m.IBadge")&&x.getBadgeCustomData()&&x.getBadgeCustomData().getVisible();});};
v.prototype._expandButtonPress=function(){if(!this.getEnabled()){return;}this.$().trigger("focus");if(!this._oPopover){this._oPopover=new f({showArrow:false,showHeader:false,offsetY:0,offsetX:0,placement:P.VerticalPreferredBottom}).addStyleClass("sapMITBFilterPopover");this._oPopover.attachBeforeClose(function(){this._getSelectList().destroyItems();},this);if(D.system.phone){this._oPopover._oControl.addButton(this._createPopoverCloseButton());}if(this._getIconTabHeader()._isInsideToolHeader()){this._oPopover.addStyleClass("sapMITBFilterPopoverInToolHeader");this._oPopover.setOffsetY(u);if(!D.system.phone){this._oPopover.addEventDelegate({onAfterRendering:function(E){this._oPopover.getDomRef().style.minWidth=this.$().outerWidth(true)+"px";}.bind(this)});}}this.addDependent(this._oPopover);this._oPopover._oControl._adaptPositionParams=function(){var i=this.$().parents().hasClass("sapUiSizeCompact");this._arrowOffset=0;if(i){this._offsets=["0 0","0 0","0 4","0 0"];}else{this._offsets=["0 0","0 0","0 5","0 0"];}this._atPositions=["end top","end top","end bottom","begin top"];this._myPositions=["end bottom","begin top","end top","end top"];};}var H=this._setSelectListItems();var S=this._getSelectList();this._oPopover.removeAllContent();if(this.getItems().length||this._isOverflow()){this._oPopover.addContent(S);this._oPopover.setInitialFocus(H?S.getSelectedItem():S.getVisibleTabFilters()[0]);this._oPopover.openBy(this);}};
v.prototype._getAllSubItems=function(){var i=[];this._getRealTab().getItems().forEach(function(x){if(x.isA("sap.m.IconTabFilter")){i=i.concat(x,x._getAllSubItems());}else{i=i.concat(x);}});return i;};
v.prototype._getAllSubFilters=function(){return this._getAllSubItems().filter(function(i){return i.isA("sap.m.IconTabFilter");});};
v.prototype._getAllSubFiltersDomRefs=function(){return this._getAllSubFilters().filter(function(S){return Boolean(S._getRealTab().getDomRef());}).map(function(S){return S._getRealTab().getDomRef();});};
v.prototype._getFirstAvailableSubFilter=function(){var x=this._getAllSubFilters();for(var i=0;i<x.length;i++){var y=x[i];if(y.getContent().length&&y.getVisible()){return y;}}return this;};
v.prototype._isParentOf=function(x){var y=this._getAllSubFilters();for(var i=0;i<y.length;i++){if(y[i]._getRealTab()===x){return true;}}return false;};
v.prototype._createPopoverCloseButton=function(){return new e({text:w.getText("SELECT_CANCEL_BUTTON"),press:this._closePopover.bind(this)});};
v.prototype._closePopover=function(){if(this._oPopover){this._oPopover.close();this._oPopover.removeAllContent();}if(this._isOverflow()&&this.getParent().oSelectedItem){(this.getParent()._oSelectedRootItem||this.getParent().oSelectedItem._getRootTab()).$().trigger("focus");}};
v.prototype._handleOnDragOver=function(E){if(this._isDropPossible(E)){this.getDomRef().classList.add("sapMITHDragOver");E.preventDefault();}};
v.prototype._handleOnLongDragOver=function(E){if(this._isDropPossible(E)){if(this._oPopover&&this._oPopover.isOpen()){return;}this._expandButtonPress();}};
v.prototype._handleOnDrop=function(){this.getDomRef().classList.remove("sapMITHDragOver");};
v.prototype._handleOnDragLeave=function(){this.getDomRef().classList.remove("sapMITHDragOver");};
v.prototype._isDropPossible=function(E){var i=this._getIconTabHeader(),x=E.dragSession.getDragControl()._getRealTab(),S=i.oSelectedItem;if(i!==x._getIconTabHeader()){return false;}if(x===this||x._isParentOf(this)){return false;}if(!this._isOverflow()&&!i.getMaxNestingLevel()){return false;}if(this._isOverflow()&&S&&(S===x||S._getRootTab()===x)){return false;}return true;};
v.prototype._setSelectListItems=function(){var x=this.getParent(),S=this._getSelectList(),y=this._getAllSubItems(),z=x.oSelectedItem,H=false,E,L,F,i,G;if(this._isOverflow()){y=x._getItemsForOverflow(this._bIsStartOverflow);}S.destroyItems();S.setSelectedItem(null);for(i=0;i<y.length;i++){E=y[i];L=E.clone(undefined,undefined,{cloneChildren:false,cloneBindings:true});E._oCloneInList=L;F=E.getCustomData();for(G=0;G<F.length;G++){L.addCustomData(F[G].clone());}L._oRealItem=E;S.addItem(L);if(E.isA("sap.m.IconTabSeparator")){continue;}if(L._getRealTab()===z){S.setSelectedItem(L);H=true;continue;}if(L._getRealTab()._isParentOf(z)){S.setSelectedItem(z._getRealTab());H=true;}}return H;};
v.prototype._isOverflow=function(){return this._bIsOverflow||this._bIsStartOverflow;};
v.prototype._getIconTabHeader=function(){return this._getRootTab().getParent();};
v.prototype.onsapdown=function(E){if(!this.getEnabled()){return;}if(this._isOverflow()||((this._getNestedLevel()===1&&this._getRealTab()===this)&&this._getRealTab().getItems().length!==0)){E.stopImmediatePropagation();this._expandButtonPress();}};
v.prototype._startBadgeHiding=function(){if(this._iHideBadgeTimeout){return;}this._iHideBadgeTimeout=setTimeout(this._hideBadge.bind(this),s);if(this._getRootTab()!==this){this._getRootTab()._updateExpandButtonBadge();}};
v.prototype._hideBadge=function(){var i=this.getBadgeCustomData();if(!i){return;}i.setVisible(false);if(this._getRootTab()!==this){this._getRootTab()._updateExpandButtonBadge();}if(this._oCloneInList&&!this._oCloneInList.bIsDestroyed&&this._oCloneInList.getBadgeCustomData()){this._oCloneInList.getBadgeCustomData().setVisible(false);this._oCloneInList=null;}if(this._isInOverflow()){this._getIconTabHeader()._getOverflow()._updateExpandButtonBadge();}if(this._isInStartOverflow()){this._getIconTabHeader()._getStartOverflow()._updateExpandButtonBadge();}this._iHideBadgeTimeout=null;};
v.prototype._isInOverflow=function(){return!this._bIsOverflow&&this._getIconTabHeader()._getItemsInStrip().indexOf(this._getRealTab())===-1;};
v.prototype._isInStartOverflow=function(){return!this._bIsStartOverflow&&this._getIconTabHeader()._getItemsInStrip().indexOf(this._getRealTab())===-1;};
v.prototype.onBadgeUpdate=function(V,S,i){var x=this.getDomRef(),y=this._getIconTabHeader(),z,E,F,G,O,H,J,K;if(!y){return;}if(x){F=x.getAttribute("aria-labelledby")||"";switch(S){case p.Appear:F=i+" "+F;break;case p.Disappear:F=F.replace(i,"").trim();break;}x.setAttribute("aria-labelledby",F);}if(!y._isRendered()){return;}z=this._getRootTab();if(z._isInOverflow()){O=this._getIconTabHeader()._getOverflow();O._updateExpandButtonBadge();}if(z._isInStartOverflow()){H=this._getIconTabHeader()._getStartOverflow();H._updateExpandButtonBadge();}else if(z!==this){z._updateExpandButtonBadge();}if(S!==p.Appear){return;}this._enableMotion();if((this._isInOverflow()||this._isInStartOverflow())&&this._oCloneInList){this._oCloneInList.addCustomData(new B());}E=d.getInstance();G=this.getText();if(z._isInOverflow()){J="ICONTABFILTER_SUB_ITEM_BADGE";K=[G,O.getText()];}if(z._isInStartOverflow()){J="ICONTABFILTER_SUB_ITEM_BADGE";K=[G,H.getText()];}else{if(z!==this){J="ICONTABFILTER_SUB_ITEM_BADGE";K=[G,z.getText()];}else{J="ICONTABFILTER_BADGE_MSG";K=G;}}E.announce(w.getText(J,K),t.Assertive);};
v.prototype.getAriaLabelBadgeText=function(){return w.getText("ICONTABFILTER_BADGE");};
v.prototype._enableMotion=function(){if(this._getRealTab()._isInOverflow()||this._getRealTab()._isInStartOverflow()){if(this._oCloneInList&&this._oCloneInList.getDomRef()){this._oCloneInList.getDomRef().classList.add("sapMITBFilterBadgeMotion");}}else if(this.getDomRef()){this.getDomRef().classList.add("sapMITBFilterBadgeMotion");}};
v.prototype._shouldReadIconColor=function(){var i=this.getIconColor();return this.getEnabled()&&(i==="Positive"||i==="Critical"||i==="Negative"||i==="Neutral");};
return v;});
sap.ui.predefine('sap/m/IconTabFilterExpandButtonBadge',["./BadgeEnabler","sap/ui/core/Control","sap/ui/core/Core"],function(B,C,a){"use strict";var r=a.getLibraryResourceBundle("sap.m");
var I=C.extend("sap.m.IconTabFilterExpandButtonBadge",{
metadata:{library:"sap.m",interfaces:["sap.m.IBadge"]},
renderer:{apiVersion:2,render:function(R,c){R.openStart("div",c).class("sapMITFExpandButtonBadge").openEnd().close("div");}}
});
B.call(I.prototype);
I.prototype.init=function(){this.initBadgeEnablement({style:"Attention"});};
I.prototype.getAriaLabelBadgeText=function(){return r.getText("ICONTABFILTER_SUB_ITEMS_BADGES");};
I.prototype.onBadgeUpdate=function(){var p=this.getParent();p.onBadgeUpdate.apply(p,arguments);};
return I;});
sap.ui.predefine('sap/m/IconTabHeader',['./library','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation',"sap/ui/core/InvisibleText",'sap/ui/core/ResizeHandler','sap/ui/Device','sap/m/Button','sap/m/IconTabFilter','sap/m/IconTabSeparator','sap/m/IconTabBarDragAndDropUtil','sap/ui/core/library','sap/m/IconTabHeaderRenderer',"sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/events/KeyCodes"],function(l,C,a,E,I,b,R,D,B,c,d,e,f,g,q,L,K){"use strict";var h=f.dnd.DropPosition;var k=l.BackgroundDesign;var m=l.IconTabHeaderMode;var n=l.IconTabDensityMode;var T=l.TabsOverflowMode;
var o=a.extend("sap.m.IconTabHeader",{metadata:{library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},selectedKey:{type:"string",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Behavior",defaultValue:true},mode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:m.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:k.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false},maxNestingLevel:{type:"int",group:"Behavior",defaultValue:0},tabDensityMode:{type:"sap.m.IconTabDensityMode",group:"Appearance",defaultValue:n.Cozy},ariaTexts:{type:"object",group:"Accessibility",defaultValue:null},tabsOverflowMode:{type:"sap.m.TabsOverflowMode",group:"Behavior",defaultValue:T.End}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",dnd:{draggable:true,droppable:true,layout:"Horizontal"}},_overflow:{type:"sap.m.IconTabFilter",multiple:false,visibility:"hidden"},_startOverflow:{type:"sap.m.IconTabFilter",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"},previousKey:{type:"string"}}}}}});
var r=C.getLibraryResourceBundle("sap.m");E.apply(o.prototype,[true]);
o.prototype.init=function(){this._bFireSelectEvent=false;this._aTabKeys=[];this._oAriaHeadText=null;this._bIsRendered=false;};
o.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._aTabKeys){this._aTabKeys=null;}if(this._oOverflow){this._oOverflow.removeEventDelegate(this._oOverflowEventDelegate);this._oOverflowEventDelegate=null;this._oOverflow=null;}if(this._oStartOverflow){this._oStartOverflow.removeEventDelegate(this._oStartOverflowEventDelegate);this._oStartOverflowEventDelegate=null;this._oStartOverflow=null;}if(this._oAriaHeadText){this._oAriaHeadText.destroy();this._oAriaHeadText=null;}this._bRtl=null;};
o.prototype.onBeforeRendering=function(){this._bIsRendered=false;this._bRtl=C.getConfiguration().getRTL();if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this._updateSelection();this.destroyDragDropConfig();this._setsDragAndDropConfigurations();};
o.prototype.onAfterRendering=function(){this._applyTabDensityMode();if(this.oSelectedItem){this._applySelectionToFilters();this.oSelectedItem._hideBadge();}if(C.isThemeApplied()){this._setItemsForStrip();}else{C.attachThemeChanged(this._handleThemeLoad,this);}this._initItemNavigation();this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._fnResize,this));this.getItems().forEach(function(i){if(i._onAfterParentRendering){i._onAfterParentRendering();}});this._bIsRendered=true;};
o.prototype._isRendered=function(){return this._bIsRendered;};
o.prototype._getSelectList=function(){return this._getOverflow()._getSelectList();};
o.prototype._getOverflow=function(){var O=this.getAggregation("_overflow");if(!O){O=new c({id:this.getId()+'-overflow',text:r.getText("ICONTABHEADER_OVERFLOW_MORE")});O._bIsOverflow=true;this._oOverflowEventDelegate={onsapnext:O.onsapdown};O.addEventDelegate(this._oOverflowEventDelegate,O);this.setAggregation("_overflow",O);this._oOverflow=O;}return O;};
o.prototype._getStartOverflow=function(){var s=this.getAggregation("_startOverflow");if(!s){s=new c({id:this.getId()+'-startOverflow',text:r.getText("ICONTABHEADER_OVERFLOW_MORE")});s._bIsStartOverflow=true;this._oStartOverflowEventDelegate={onsapprevious:s.onsapdown};s.addEventDelegate(this._oStartOverflowEventDelegate,s);this.setAggregation("_startOverflow",s);this._oStartOverflow=s;}return s;};
o.prototype._getInvisibleHeadText=function(){var A=this.getAriaTexts()||{};if(!this._oAriaHeadText){this._oAriaHeadText=new b({id:this.getId()+"-ariaHeadText"});}this._oAriaHeadText.setText(A.headerDescription);return this._oAriaHeadText;};
o.prototype._onItemNavigationFocusLeave=function(){if(!this.oSelectedItem){return;}var j=this.getItems();var p=-1;var s;for(var i=0;i<j.length;i++){s=j[i];if(s instanceof c==false){continue;}p++;if((this.oSelectedItem._getRootTab()||this.oSelectedItem)===s){break;}}this._oItemNavigation.setFocusedIndex(p);};
o.prototype.getTabFilters=function(){var t=[];this.getItems().forEach(function(i){if(i instanceof c){t.push(i);}});return t;};
o.prototype._setsDragAndDropConfigurations=function(){if(this.getEnableTabReordering()&&!this.getDragDropConfig().length){e.setDragDropAggregations(this,"Horizontal",this._getDropPosition());}};
o.prototype._getDropPosition=function(){return this.getMaxNestingLevel()===0?h.Between:h.OnOrBetween;};
o.prototype.setSelectedKey=function(s){var j=this.getTabFilters(),p=this._isInsideIconTabBar(),S,A=true;if(j.length>0){s=s||j[0]._getNonEmptyKey();}if(this.$().length){for(var i=0;i<j.length;i++){if(j[i]._getNonEmptyKey()===s){this.setSelectedItem(j[i],A);S=true;break;}}if(!S&&!p&&s){this.setSelectedItem(null);}}this.setProperty("selectedKey",s,true);return this;};
o.prototype.setSelectedItem=function(i,A){if(!i){if(this.oSelectedItem){this._removeSelectionFromFilters();this.oSelectedItem=null;}return this;}if(this._isUnselectable(i)){return this;}var p=this.getParent();var j=this._isInsideIconTabBar();var P=this.getSelectedKey();var s=false;if(i.getContent().length===0&&this.oSelectedItem&&this.oSelectedItem.getContent().length===0){s=true;}if(this.oSelectedItem&&this.oSelectedItem.getVisible()&&(!A&&j&&p.getExpandable()||this.oSelectedItem!==i)){this._removeSelectionFromFilters();}if(i.getVisible()){if(this.oSelectedItem===i){if(!A&&j&&p.getExpandable()){p._toggleExpandCollapse();}}else{if(j){p.$("content").attr('aria-labelledby',i.sId);}this.oSelectedItem=i;this._applySelectionToFilters();this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);if(j&&(p.getExpandable()||p.getExpanded())){var S=this.oSelectedItem.getContent();if(S.length>0){p._rerenderContent(S);}else{if(!s){p._rerenderContent(p.getContent());}}if(!A&&p.getExpandable()&&!p.getExpanded()){p._toggleExpandCollapse(true);}}}}this.oSelectedItem=i;var t=this.oSelectedItem._getNonEmptyKey();this.setProperty("selectedKey",t,true);if(j){p.setProperty("selectedKey",t,true);}if(j){A=A&&!p._bFireSelectEvent;}else{A=A&&!this._bFireSelectEvent;}if(!A){if(j){p.fireSelect({selectedItem:this.oSelectedItem,selectedKey:t,item:this.oSelectedItem,key:t,previousKey:P});}else{this.fireSelect({selectedItem:this.oSelectedItem,selectedKey:t,item:this.oSelectedItem,key:t,previousKey:P});}}this.oSelectedItem._startBadgeHiding();var u=this.oSelectedItem._getRootTab().getDomRef();if(!u||u.classList.contains("sapMITBFilterHidden")||this.getTabsOverflowMode()===T.End){this._setItemsForStrip();}return this;};
o.prototype.getVisibleTabFilters=function(){return this.getTabFilters().filter(function(F){return F.getVisible();});};
o.prototype._initItemNavigation=function(){var t=[],s=-1,S=this.oSelectedItem&&this.oSelectedItem._getRootTab();if(this.$().hasClass("sapMITHStartOverflowList")){var i=this._getStartOverflow().getFocusDomRef();i.setAttribute("tabindex","-1");t.push(i);}this.getTabFilters().forEach(function(j){var p=this.getFocusDomRef(j);if(!p){return;}p.setAttribute("tabindex","-1");t.push(p);if(j===S||j===this.oSelectedItem){s=t.indexOf(p);}}.bind(this));if(this.$().hasClass("sapMITHEndOverflowList")){var O=this._getOverflow().getFocusDomRef();O.setAttribute("tabindex","-1");t.push(O);}if(!this._oItemNavigation){this._oItemNavigation=new I().setCycling(false).attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this).setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(this.getDomRef()).setItemDomRefs(t).setPageSize(t.length).setSelectedIndex(s);};
o.prototype.onThemeChanged=function(){this._applyTabDensityMode();};
o.prototype._applyTabDensityMode=function(){var t=this.getTabDensityMode();this.$().removeClass("sapUiSizeCompact");switch(t){case n.Compact:this.$().addClass("sapUiSizeCompact");break;case n.Inherit:if(this.$().closest(".sapUiSizeCompact").length){this.$().addClass("sapUiSizeCompact");}break;}};
o.prototype._handleThemeLoad=function(){setTimeout(this._setItemsForStrip.bind(this),350);C.detachThemeChanged(this._handleThemeLoad,this);};
o.prototype.destroyItems=function(){this.oSelectedItem=null;this._aTabKeys=[];this.destroyAggregation("items");return this;};
o.prototype.addItem=function(i){if(!(i instanceof d)){var s=i.getKey();if(this._aTabKeys.indexOf(s)!==-1){L.warning("sap.m.IconTabHeader: duplicate key '"+s+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(s);}this.addAggregation("items",i);this._invalidateParentIconTabBar();return this;};
o.prototype.insertItem=function(i,j){if(!(i instanceof d)){var s=i.getKey();if(this._aTabKeys.indexOf(s)!==-1){L.warning("sap.m.IconTabHeader: duplicate key '"+s+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(s);}this.insertAggregation("items",i,j);this._invalidateParentIconTabBar();};
o.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this._aTabKeys=[];this.oSelectedItem=null;this._invalidateParentIconTabBar();return i;};
o.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i&&!(i instanceof d)){var s=i.getKey();this._aTabKeys.splice(this._aTabKeys.indexOf(s),1);}if(this.oSelectedItem===i){this.oSelectedItem=null;}this._invalidateParentIconTabBar();return i;};
o.prototype.updateAggregation=function(){this.oSelectedItem=null;a.prototype.updateAggregation.apply(this,arguments);this.invalidate();};
o.prototype.removeAggregation=function(A,O,s){var i=this.getTabFilters();var j=a.prototype.removeAggregation.apply(this,arguments);if(s){return j;}if(!this._getPreserveSelection()&&j&&j==this.oSelectedItem&&A=='items'){var p=(i?Array.prototype.indexOf.call(i,j):-1);i=this.getTabFilters();p=Math.max(0,Math.min(p,i.length-1));var S=i[p];if(S){this.setSelectedItem(S,true);}else{var t=this.getParent();if(this._isInsideIconTabBar()&&t.getExpanded()){t.$("content").children().remove();}}}return j;};
o.prototype.removeAllAggregation=function(A,s){if(A=='items'){var i=this.getParent();if(this._isInsideIconTabBar()&&i.getExpanded()){i.$("content").children().remove();}}return a.prototype.removeAllAggregation.apply(this,arguments);};
o.prototype._getPreserveSelection=function(){return this._bPreserveSelection;};
o.prototype._setPreserveSelection=function(p){this._bPreserveSelection=p;};
o.prototype._getDisplayText=function(i){var t=i.getText();if(this.isInlineMode()){var s=i.getCount();if(s){if(this._bRtl){t='('+s+') '+t;}else{t+=' ('+s+')';}}}return t;};
o.prototype.isInlineMode=function(){return this.getMode()===m.Inline;};
o.prototype._checkTextOnly=function(){this._bTextOnly=this.getItems().every(function(i){return i instanceof d||!i.getIcon();});return this._bTextOnly;};
o.prototype._checkNoText=function(j){if(j.length>0){for(var i=0;i<j.length;i++){if(!(j[i]instanceof d)){if(j[i].getText().length>0){return false;}}}}return true;};
o.prototype._checkInLine=function(j){var p;if(j.length>0){for(var i=0;i<j.length;i++){p=j[i];if(!(p instanceof d)){if(p.getIcon()||p.getCount()){this._bInLine=false;return false;}}}}this._bInLine=true;return true;};
o.prototype._getItemsInStrip=function(){return this.getItems().filter(function(i){var j=i.getDomRef();return j&&!j.classList.contains("sapMITBFilterHidden");});};
o.prototype._setItemsForStrip=function(){var t=this.getVisibleTabFilters();if(!C.isThemeApplied()||!t.length){return;}var i=this.getDomRef("head");if(!i){return;}var s=this._getStartOverflow(),O=this._getOverflow(),j=this.getItems().filter(function(v){return v.getDomRef();}).map(function(v){return v.getDomRef();}),S=(this.oSelectedItem&&this.oSelectedItem.getVisible())?this.oSelectedItem:t[0],p=(S._getRootTab()||S).getDomRef();if(!j.length||!p){return;}s.$().removeClass("sapMITHOverflowVisible");O.$().removeClass("sapMITHOverflowVisible");this.$().removeClass("sapMITHStartOverflowList");this.$().removeClass("sapMITHEndOverflowList");j.forEach(function(v){v.classList.remove("sapMITBFilterHidden");});var u=j.reduce(function(v,w){return v+q(w).outerWidth(true);},0),H=u>i.offsetWidth;if(!H){return;}switch(this.getTabsOverflowMode()){case T.StartAndEnd:this._updateStartAndEndOverflow(j,p);break;case T.End:default:this._updateEndOverflow(j,p);break;}};
o.prototype._updateEndOverflow=function(j,s){var O=this._getOverflow(),t=this.getDomRef("head"),p,u,S,i;O.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHEndOverflowList");p=t.offsetWidth;S=this._getSelectedItemIndexAndSize(j,s);u=this._findLastVisibleItem(j,p,S.width);for(i=u+1;i<j.length;i++){j[i].classList.add("sapMITBFilterHidden");}O._updateExpandButtonBadge();};
o.prototype._updateStartAndEndOverflow=function(j,s){var S=this._getStartOverflow(),O=this._getOverflow(),t=this.getDomRef("head"),p=t.offsetWidth,u=this._getSelectedItemIndexAndSize(j,s),H=this._hasStartOverflow(p,j,u),v=this._hasEndOverflow(p,j,u),F,w,i;if(!H){O.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHEndOverflowList");p=t.offsetWidth;w=this._findLastVisibleItem(j,p,u.width);for(i=w+1;i<j.length;i++){j[i].classList.add("sapMITBFilterHidden");}O._updateTabCountText();O._updateExpandButtonBadge();return;}if(!v){S.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHStartOverflowList");p=t.offsetWidth;F=this._findFirstVisibleItem(j,p,u.width);for(i=F-1;i>=0;i--){j[i].classList.add("sapMITBFilterHidden");}S._updateTabCountText();S._updateExpandButtonBadge();return;}S.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHStartOverflowList");O.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHEndOverflowList");p=t.offsetWidth;F=this._findFirstVisibleItem(j,p,u.width,u.index-1);w=this._findLastVisibleItem(j,p,u.width,F);for(i=F-1;i>=0;i--){j[i].classList.add("sapMITBFilterHidden");}for(i=w+1;i<j.length;i++){j[i].classList.add("sapMITBFilterHidden");}S._updateExpandButtonBadge();S._updateTabCountText();O._updateTabCountText();O._updateExpandButtonBadge();};
o.prototype._hasStartOverflow=function(t,j,s){if(s.index===0){return false;}var i,p=0;for(i=s.index-1;i>=0;i--){p+=this._getItemSize(j[i]);}var H=t<p+s.width;if(!H){this._getOverflow().$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHEndOverflowList");t=this.getDomRef("head").offsetWidth;H=t<p+s.width;this._getOverflow().$().removeClass("sapMITHOverflowVisible");this.$().removeClass("sapMITHEndOverflowList");}return H;};
o.prototype._hasEndOverflow=function(t,j,s){if(s.index>=j.length){return false;}var i,p=0;for(i=s.index;i<j.length;i++){p+=this._getItemSize(j[i]);}var H=t<p+s.width;if(!H){this._getStartOverflow().$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHStartOverflowList");t=this.getDomRef("head").offsetWidth;H=t<p+s.width;this._getStartOverflow().$().removeClass("sapMITHOverflowVisible");this.$().removeClass("sapMITHStartOverflowList");}return H;};
o.prototype._getSelectedItemIndexAndSize=function(i,s){var S=i.indexOf(s),j=this._getItemSize(s),p;if(i[S-1]&&i[S-1].classList.contains("sapMITBSep")){p=i[S-1];j+=this._getItemSize(p);}i.splice(S,1);if(p){i.splice(S-1,1);S--;}return{index:S,width:j};};
o.prototype._findFirstVisibleItem=function(i,t,s,S){var j,p,u;if(S===undefined){S=i.length-1;}j=S+1;for(p=S;p>=0;p--){u=this._getItemSize(i[p]);if(t<s+u){break;}s+=u;j=p;}return j;};
o.prototype._findLastVisibleItem=function(i,t,s,S){var j,p,u;S=S||0;j=S-1;for(p=S;p<i.length;p++){u=this._getItemSize(i[p]);if(t<s+u){break;}s+=u;j=p;}var P=i[p-1];if(P&&P.classList.contains("sapMITBSep")){j-=1;}return j;};
o.prototype._getItemSize=function(i){var s=window.getComputedStyle(i),w=i.offsetWidth,M=Number.parseInt(s.marginLeft)+Number.parseInt(s.marginRight);return w+M;};
o.prototype._handleActivation=function(i){var t=i.target.id,j=i.srcControl,s,$=q(i.target);if(j instanceof B){return;}var p=q(document.getElementById(t));if(p.parents()&&Array.prototype.indexOf.call(p.parents(),this.$("content")[0])>-1){}else{if(t){i.preventDefault();if($.hasClass('sapMITBFilterIcon')||$.hasClass('sapMITBCount')||$.hasClass('sapMITBText')||$.hasClass('sapMITBTab')||$.hasClass('sapMITBContentArrow')||$.hasClass('sapMITBSep')||$.hasClass('sapMITBSepIcon')){s=i.srcControl.getId().replace(/-icon$/,"");j=C.byId(s);if(j.getMetadata().isInstanceOf("sap.m.IconTab")&&!(j instanceof d)){if(this._isUnselectable(j)){if(j.getItems().length||j._isOverflow()){j._expandButtonPress();}return;}if((j===this._getOverflow())||(j===this._getStartOverflow())){j._expandButtonPress();return;}this.setSelectedItem(j);}}else if(j.getMetadata().isInstanceOf("sap.m.IconTab")&&!(j instanceof d)){if(this._isUnselectable(j)){if(j.getItems().length||j._isOverflow()){j._expandButtonPress();}return;}if((j===this._getOverflow())||(j===this._getStartOverflow())){j._expandButtonPress();return;}this.setSelectedItem(j);}}else{if(j.getMetadata().isInstanceOf("sap.m.IconTab")&&!(j instanceof d)){if(this._isUnselectable(j)){if(j.getItems().length||j._isOverflow()){j._expandButtonPress();}return;}if((j===this._getOverflow())||(j===this._getStartOverflow())){j._expandButtonPress();return;}this.setSelectedItem(j);}}}};
o.prototype._fnResize=function(){if(this._getOverflow()._oPopover){this._getOverflow()._oPopover.close();}if(this._getStartOverflow()._oPopover){this._getStartOverflow()._oPopover.close();}this._setItemsForStrip();this._initItemNavigation();};
o.prototype._isUnselectable=function(i){var F=i._getRealTab();return!F.getEnabled()||(this._isInsideIconTabBar()&&!this.getParent().getContent().length&&F._getNestedLevel()===1&&F.getItems().length&&!F.getContent().length)||F._isOverflow();};
o.prototype._isInsideIconTabBar=function(){var p=this.getParent();return p instanceof a&&p.isA('sap.m.IconTabBar');};
o.prototype._isInsideToolHeader=function(){var p=this.getParent();return p instanceof a&&p.isA('sap.tnt.ToolHeader');};
o.prototype._invalidateParentIconTabBar=function(){if(this._isInsideIconTabBar()){this.getParent().invalidate();}};
o.prototype.getFocusDomRef=function(F){var t=F||this.oSelectedItem;if(!t){return null;}return t.getDomRef();};
o.prototype.applyFocusInfo=function(F){if(F.focusDomRef){q(F.focusDomRef).trigger("focus");}};
o.prototype._updateSelection=function(){var j=this.getItems(),s=this.getSelectedKey(),i=0,p=this._isInsideIconTabBar(),t=this._isInsideToolHeader();if(!j.length){return;}if(!this.oSelectedItem||s&&s!==this.oSelectedItem._getNonEmptyKey()){if(s){this.oSelectedItem=this._findItemByKey(s);}if(!this.oSelectedItem&&(p||!s)){for(i=0;i<j.length;i++){if(!(j[i]instanceof d)&&j[i].getVisible()){this.oSelectedItem=j[i];break;}}}}if(!t&&this.oSelectedItem&&!this.oSelectedItem.getVisible()){for(i=0;i<j.length;i++){if(!(j[i]instanceof d)&&j[i].getVisible()){this.oSelectedItem=j[i];break;}}}if(!this.oSelectedItem){return;}if(this._isUnselectable(this.oSelectedItem)){this.setSelectedItem(this.oSelectedItem._getFirstAvailableSubFilter(),true);return;}this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);};
o.prototype._findItemByKey=function(s){var t=this.getTabFilters(),S;for(var i=0;i<t.length;i++){if(t[i]._getNonEmptyKey()===s){return t[i];}S=t[i]._getAllSubFilters();for(var j=0;j<S.length;j++){if(S[j]._getNonEmptyKey()===s){return S[j];}}}};
o.prototype._applySelectionToFilters=function(){if(this._isInsideIconTabBar()&&!this.getParent().getExpanded()){return;}this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});if(this.oSelectedItem._getNestedLevel()!==1){var s=this.oSelectedItem._getRootTab();s.$().addClass("sapMITBSelected").attr({"aria-selected":true});}};
o.prototype._removeSelectionFromFilters=function(){this.oSelectedItem.$().removeClass("sapMITBSelected").attr({'aria-selected':false});if(this.oSelectedItem._getNestedLevel()!==1){var s=this.oSelectedItem._getRootTab();s.$().removeClass("sapMITBSelected").attr({"aria-selected":false});}};
o.prototype._getItemsForOverflow=function(i,t){var j=this._getItemsInStrip(),p=this.getTabsOverflowMode()===T.StartAndEnd,s,u=this.getItems(),v=[];if(p){s=u.indexOf(j[0]);u=i?u.slice(0,s):u.slice(s,u.length);}u.forEach(function(w){if(!D.system.phone&&j.indexOf(w)>-1){return;}v.push(w);if(w.isA("sap.m.IconTabFilter")&&!t){w._getAllSubItems().forEach(function(S){v.push(S);});}});return v;};
o.prototype.ontouchstart=function(i){var t=i.targetTouches[0];this._iActiveTouch=t.identifier;};
o.prototype.ontouchend=function(i){if(this._iActiveTouch===undefined){return;}var M=0;var j=1;var p;if(i.which===p||i.which===M||i.which===j){this._handleActivation(i);}this._iActiveTouch=undefined;};
o.prototype.ontouchcancel=o.prototype.ontouchend;
o.prototype.onkeydown=function(i){switch(i.which){case K.ENTER:this._handleActivation(i);i.preventDefault();break;case K.SPACE:i.preventDefault();break;}};
o.prototype.onkeyup=function(i){if(i.which===K.SPACE){this._handleActivation(i);}};
o.prototype._handleDragAndDrop=function(i){var j=i.getParameter("dropPosition"),p=i.getParameter("draggedControl"),s=i.getParameter("droppedControl"),t=this,u=this.getMaxNestingLevel();if(j===h.On){t=s._getRealTab();}e.handleDrop(t,j,p._getRealTab(),s,false,u);if(p._getNestedLevel()>1){p._getRootTab()._closePopover();}this._setItemsForStrip();this._initItemNavigation();this._getOverflow()._setSelectListItems();this._getStartOverflow()._setSelectListItems();this._getSelectList()._initItemNavigation();p._getRealTab().$().trigger("focus");if(j===h.On){s._getRealTab().$().trigger("focus");}};
o.prototype._moveTab=function(t,i,M){e.moveItem.call(this,t,i,M);this._setItemsForStrip();this._initItemNavigation();};
o.prototype.ondragrearranging=function(i){if(!this.getEnableTabReordering()){return;}var t=i.srcControl,j=this.indexOfItem(this._getItemsInStrip().pop());this._moveTab(t,i.keyCode,j);t.$().trigger("focus");};
o.prototype.onsaphomemodifiers=o.prototype.ondragrearranging;o.prototype.onsapendmodifiers=o.prototype.ondragrearranging;o.prototype.onsapincreasemodifiers=o.prototype.ondragrearranging;o.prototype.onsapdecreasemodifiers=o.prototype.ondragrearranging;return o;});
sap.ui.predefine('sap/m/IconTabHeaderRenderer',['./library'],function(l){"use strict";var I={apiVersion:2};var T=l.TabsOverflowMode;
I.render=function(r,c){if(!c.getVisible()){return;}var s=c.getId(),a=c.getItems(),v=c.getVisibleTabFilters().length,V=0,t=c._checkTextOnly(),n=c._checkNoText(a),b=c._checkInLine(a)||c.isInlineMode();var o=c.getParent(),u=o&&o.isA('sap.m.IconTabBar')&&o.getUpperCase(),A=c.getAriaTexts()||{};r.openStart("div",c).class("sapMITH").class("sapContrastPlus").class("sapMITHBackgroundDesign"+c.getBackgroundDesign());if(u){r.class("sapMITBTextUpperCase");}if(t){r.class("sapMITBTextOnly");}if(n){r.class("sapMITBNoText");}if(b){r.class("sapMITBInLine");r.class("sapMITBTextOnly");}r.accessibilityState(c,{role:"navigation"});if(A.headerLabel){r.accessibilityState(c,{label:A.headerLabel});}r.openEnd();if(a.length&&c.getTabsOverflowMode()===T.StartAndEnd){r.openStart("div").class("sapMITHStartOverflow").openEnd();c._getStartOverflow().render(r);r.close("div");}if(A.headerDescription){r.renderControl(c._getInvisibleHeadText());}r.openStart("div",s+"-head").class("sapMITBHead");r.accessibilityState({role:"tablist",orientation:"horizontal"});if(A.headerDescription){r.accessibilityState({describedby:c._getInvisibleHeadText().getId()});}r.openEnd();for(var i=0;i<a.length;i++){var d=a[i];d.render(r,V,v);if(d.isA("sap.m.IconTabFilter")){if(d.getVisible()){V++;}}}r.close("div");if(a.length){r.openStart("div").class("sapMITHEndOverflow").openEnd();c._getOverflow().render(r);r.close("div");}r.close("div");};
return I;},true);
sap.ui.predefine('sap/m/IconTabSeparator',["./library","sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/Item","sap/m/IconTabFilter"],function(l,C,E,I,a){"use strict";var b=l.ImageHelper;
var c=E.extend("sap.m.IconTabSeparator",{metadata:{interfaces:["sap.m.IconTab"],library:"sap.m",designtime:"sap/m/designtime/IconTabSeparator.designtime",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},visible:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true}}}});
c.prototype._getImageControl=function(d,p){var P={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};this._oImageControl=b.getImageControl(this.getId()+"-icon",this._oImageControl,p,P,d);return this._oImageControl;};
c.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy();}E.prototype.exit.call(this,e);};
c.prototype._getRealTab=function(){return a.prototype._getRealTab.call(this);};
c.prototype._getNestedLevel=function(){return a.prototype._getNestedLevel.call(this);};
c.prototype.render=function(r){if(!this.getVisible()){return;}var i=this.getIcon(),o=this.getParent(),R=C.getLibraryResourceBundle('sap.m'),A={};if(i){A.role="img";A.label=R.getText("ICONTABBAR_NEXTSTEP");}else{A.role="separator";}r.openStart("div",this).accessibilityState(A).class("sapMITBItem").class("sapMITBSep");if(!i){r.class("sapMITBSepLine");}r.openEnd();if(i){r.renderControl(this._getImageControl(["sapMITBSepIcon"],o));}r.close("div");};
c.prototype.renderInSelectList=function(r,s,i,S,p){if(!this.getVisible()){return;}var d=this.getIcon(),o=s._oIconTabHeader,R=C.getLibraryResourceBundle('sap.m'),A={};if(d){A.role="img";A.label=R.getText("ICONTABBAR_NEXTSTEP");}else{A.role="separator";}r.openStart("li",this).class("sapMITBSelectItem").class("sapMITBSep").accessibilityState(A);if(p&&!d){r.style("padding-left",p+"rem");}if(!d){r.class("sapMITBSepLine");}r.openEnd();if(d){r.renderControl(this._getImageControl(["sapMITBSepIcon"],o));}r.close("li");};
return c;});
sap.ui.predefine('sap/m/IllustratedMessage',["./library","sap/m/Text","sap/m/Title","sap/m/FormattedText","sap/m/Illustration","sap/ui/core/Control","sap/ui/core/Core",'sap/ui/core/library',"sap/ui/core/ResizeHandler","sap/ui/thirdparty/jquery","./IllustratedMessageRenderer"],function(l,T,a,F,I,C,b,c,R,q,d){"use strict";var e=l.IllustratedMessageSize;var f=l.IllustratedMessageType;var g=c.TextAlign;
var h=C.extend("sap.m.IllustratedMessage",{metadata:{library:"sap.m",properties:{description:{type:"string",group:"Misc",defaultValue:""},enableFormattedText:{type:"boolean",group:"Appearance",defaultValue:false},illustrationSize:{type:"sap.m.IllustratedMessageSize",group:"Appearance",defaultValue:e.Auto},illustrationType:{type:"string",group:"Appearance",defaultValue:f.NoSearchResults},title:{type:"string",group:"Misc",defaultValue:""}},aggregations:{additionalContent:{type:"sap.m.Button",multiple:true},_formattedText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_illustration:{type:"sap.m.Illustration",visibility:"hidden",multiple:false},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_title:{type:"sap.m.Title",multiple:false,visibility:"hidden"}},dnd:{draggable:false,droppable:true}}});
h.ORIGINAL_TEXTS={UnableToLoad:"UnableToLoad",UnableToUpload:"UnableToUpload",NoActivities:"NoActivities",BeforeSearch:"BeforeSearch",NoSearchResults:"NoSearchResults",NoEntries:"NoEntries",NoData:"NoData",NoNotifications:"NoNotifications",BalloonSky:"BalloonSky",SuccessScreen:"SuccessScreen",NoMail:"NoMail",NoSavedItems:"NoSavedItems",NoTasks:"NoTasks"};h.FALLBACK_TEXTS={ReloadScreen:h.ORIGINAL_TEXTS.UnableToLoad,Connection:h.ORIGINAL_TEXTS.UnableToLoad,ErrorScreen:h.ORIGINAL_TEXTS.UnableToUpload,EmptyCalendar:h.ORIGINAL_TEXTS.NoActivities,SearchEarth:h.ORIGINAL_TEXTS.BeforeSearch,SearchFolder:h.ORIGINAL_TEXTS.NoSearchResults,EmptyList:h.ORIGINAL_TEXTS.NoEntries,Tent:h.ORIGINAL_TEXTS.NoData,SleepingBell:h.ORIGINAL_TEXTS.NoNotifications,SimpleBalloon:h.ORIGINAL_TEXTS.BalloonSky,SimpleBell:h.ORIGINAL_TEXTS.NoNotifications,SimpleCalendar:h.ORIGINAL_TEXTS.NoActivities,SimpleCheckmark:h.ORIGINAL_TEXTS.SuccessScreen,SimpleConnection:h.ORIGINAL_TEXTS.UnableToLoad,SimpleEmptyDoc:h.ORIGINAL_TEXTS.NoData,SimpleEmptyList:h.ORIGINAL_TEXTS.NoEntries,SimpleError:h.ORIGINAL_TEXTS.UnableToUpload,SimpleMagnifier:h.ORIGINAL_TEXTS.BeforeSearch,SimpleMail:h.ORIGINAL_TEXTS.NoMail,SimpleNoSavedItems:h.ORIGINAL_TEXTS.NoSavedItems,SimpleNotFoundMagnifier:h.ORIGINAL_TEXTS.NoSearchResults,SimpleReload:h.ORIGINAL_TEXTS.UnableToLoad,SimpleTask:h.ORIGINAL_TEXTS.NoTasks};h.PREPENDS={DESCRIPTION:"IllustratedMessage_DESCRIPTION_",TITLE:"IllustratedMessage_TITLE_"};h.BREAK_POINTS={DIALOG:679,SPOT:319,BASE:259};h.MEDIA={BASE:"sapFIllustratedMessage-Base",SPOT:"sapFIllustratedMessage-Spot",DIALOG:"sapFIllustratedMessage-Dialog",SCENE:"sapFIllustratedMessage-Scene"};h.RESIZE_HANDLER_ID={CONTENT:"_sContentResizeHandlerId"};
h.prototype.init=function(){this._updateInternalIllustrationSetAndType(this.getIllustrationType());};
h.prototype.onBeforeRendering=function(){this._detachResizeHandlers();};
h.prototype.onAfterRendering=function(){this._updateDomSize();this._attachResizeHandlers();this._preventWidowWords(this._getTitle().getDomRef());this._preventWidowWords(this._getDescription().getDomRef());};
h.prototype.exit=function(){this._detachResizeHandlers();};
h.prototype.setIllustrationType=function(v){if(this.getIllustrationType()===v){return this;}this._updateInternalIllustrationSetAndType(v);return this.setProperty("illustrationType",v);};
h.prototype._getDefaultDescription=function(){return this._findDefaultText(h.PREPENDS.DESCRIPTION);};
h.prototype._getDefaultTitle=function(){return this._findDefaultText(h.PREPENDS.TITLE);};
h.prototype._findDefaultText=function(p){var B=this._getResourceBundle();return B.getText(p+this._sIllustrationType,null,true)||B.getText(p+this._sIllustrationType.substr(0,this._sIllustrationType.indexOf('_v')),null,true)||B.getText(p+h.FALLBACK_TEXTS[this._sIllustrationType],null,true);};
h.prototype._getDescription=function(){return this.getEnableFormattedText()?this._getFormattedText():this._getText();};
h.prototype._getFormattedText=function(){var D=this.getDescription(),o=this.getAggregation("_formattedText");if(!o){o=new F({textAlign:g.Center});this.setAggregation("_formattedText",o);}if(D){o.setHtmlText(D);}else{o.setHtmlText(this._getDefaultDescription());}return o;};
h.prototype._getIllustration=function(){var i=this.getAggregation("_illustration");if(!i){i=new I();this.setAggregation("_illustration",i);}return i;};
h.prototype._getResourceBundle=function(){return b.getLibraryResourceBundle("sap.m");};
h.prototype._getText=function(){var D=this.getDescription(),t=this.getAggregation("_text");if(!t){t=new T({textAlign:g.Center});this.setAggregation("_text",t);}if(D){t.setText(D);}else{t.setText(this._getDefaultDescription());}return t;};
h.prototype._getTitle=function(){var t=this.getTitle(),o=this.getAggregation("_title");if(!o){o=new a({wrapping:true});this.setAggregation("_title",o);}if(t){o.setText(t);}else{o.setText(this._getDefaultTitle());}return o;};
h.prototype._preventWidowWords=function(D){var $,s,H=window.HTMLElement;if(!(H&&D instanceof H)){return;}$=q(D);s=$.html();s=s.replace(/ ([^ ]*)$/,'&nbsp;$1');$.html(s);};
h.prototype._updateDomSize=function(){var D=this.getDomRef(),s;if(D){s=this.getIllustrationSize();if(s===e.Auto){this._updateMedia(D.getBoundingClientRect().width);}else{this._updateMediaStyle(h.MEDIA[s.toUpperCase()]);}}};
h.prototype._updateInternalIllustrationSetAndType=function(v){var V=v.split("-");this._sIllustrationSet=V[0];this._sIllustrationType=V[1];};
h.prototype._onResize=function(E){var i=E.size.width;this._updateMedia(i);};
h.prototype._updateMedia=function(w){if(!w){return;}if(w<=h.BREAK_POINTS.BASE){this._updateMediaStyle(h.MEDIA.BASE);}else if(w<=h.BREAK_POINTS.SPOT){this._updateMediaStyle(h.MEDIA.SPOT);}else if(w<=h.BREAK_POINTS.DIALOG){this._updateMediaStyle(h.MEDIA.DIALOG);}else{this._updateMediaStyle(h.MEDIA.SCENE);}};
h.prototype._updateMediaStyle=function(s){Object.keys(h.MEDIA).forEach(function(m){var E=s===h.MEDIA[m],i=m.charAt(0)+m.slice(1).toLowerCase();this.toggleStyleClass(h.MEDIA[m],E);if(E&&s!==h.MEDIA.BASE){this._getIllustration().setSet(this._sIllustrationSet,true).setMedia(i,true).setType(this._sIllustrationType);}},this);};
h.prototype._attachResizeHandlers=function(){var i=this.getIllustrationSize();if(this.getDomRef()&&i===e.Auto){this._registerResizeHandler(h.RESIZE_HANDLER_ID.CONTENT,this,this._onResize.bind(this));}};
h.prototype._detachResizeHandlers=function(){this._deRegisterResizeHandler(h.RESIZE_HANDLER_ID.CONTENT);};
h.prototype._registerResizeHandler=function(H,o,i){if(!this[H]){this[H]=R.register(o,i);}};
h.prototype._deRegisterResizeHandler=function(H){if(this[H]){R.deregister(this[H]);this[H]=null;}};
h.prototype.getAccessibilityReferences=function(){return{title:this._getTitle().getId(),description:this._getDescription().getId()};};
return h;});
sap.ui.predefine('sap/m/IllustratedMessageRenderer',[],function(){"use strict";var I={apiVersion:2};
I.render=function(r,i){var o=i._getIllustration(),a=i._getTitle(),b=i._getDescription(),c=i.getAdditionalContent();r.openStart("figure",i);r.class("sapFIllustratedMessage");r.openEnd();r.renderControl(o);r.openStart("figcaption").openEnd();r.renderControl(a);r.renderControl(b.addStyleClass("sapFIllustratedMessageDescription"));r.close("figcaption");r.openStart("div");r.class("sapFIllustratedMessageAdditionalContent");r.openEnd();c.forEach(function(C){r.renderControl(C);});r.close("div");r.close("figure");};
return I;},true);
sap.ui.predefine('sap/m/IllustratedMessageSize',[],function(){"use strict";var I={Auto:"Auto",Base:"Base",Spot:"Spot",Dialog:"Dialog",Scene:"Scene"};return I;});
sap.ui.predefine('sap/m/IllustratedMessageType',[],function(){"use strict";var I={BeforeSearch:"sapIllus-BeforeSearch",NoActivities:"sapIllus-NoActivities",NoData:"sapIllus-NoData",NoMail:"sapIllus-NoMail",NoMailV1:"sapIllus-NoMail_v1",NoEntries:"sapIllus-NoEntries",NoNotifications:"sapIllus-NoNotifications",NoSavedItems:"sapIllus-NoSavedItems",NoSavedItemsV1:"sapIllus-NoSavedItems_v1",NoSearchResults:"sapIllus-NoSearchResults",NoTasks:"sapIllus-NoTasks",NoTasksV1:"sapIllus-NoTasks_v1",UnableToLoad:"sapIllus-UnableToLoad",UnableToUpload:"sapIllus-UnableToUpload",AddColumn:"sapIllus-AddColumn",AddPeople:"sapIllus-AddPeople",BalloonSky:"sapIllus-BalloonSky",Connection:"sapIllus-Connection",EmptyCalendar:"sapIllus-EmptyCalendar",EmptyList:"sapIllus-EmptyList",EmptyPlanningCalendar:"sapIllus-EmptyPlanningCalendar",ErrorScreen:"sapIllus-ErrorScreen",FilterTable:"sapIllus-FilterTable",GroupTable:"sapIllus-GroupTable",NoFilterResults:"sapIllus-NoFilterResults",PageNotFound:"sapIllus-PageNotFound",ReloadScreen:"sapIllus-ReloadScreen",ResizeColumn:"sapIllus-ResizeColumn",SearchEarth:"sapIllus-SearchEarth",SearchFolder:"sapIllus-SearchFolder",SimpleBalloon:"sapIllus-SimpleBalloon",SimpleBell:"sapIllus-SimpleBell",SimpleCalendar:"sapIllus-SimpleCalendar",SimpleCheckmark:"sapIllus-SimpleCheckmark",SimpleConnection:"sapIllus-SimpleConnection",SimpleEmptyDoc:"sapIllus-SimpleEmptyDoc",SimpleEmptyList:"sapIllus-SimpleEmptyList",SimpleError:"sapIllus-SimpleError",SimpleMagnifier:"sapIllus-SimpleMagnifier",SimpleMail:"sapIllus-SimpleMail",SimpleNoSavedItems:"sapIllus-SimpleNoSavedItems",SimpleNotFoundMagnifier:"sapIllus-SimpleNotFoundMagnifier",SimpleReload:"sapIllus-SimpleReload",SimpleTask:"sapIllus-SimpleTask",SleepingBell:"sapIllus-SleepingBell",SortColumn:"sapIllus-SortColumn",SuccessScreen:"sapIllus-SuccessScreen",Tent:"sapIllus-Tent",UploadCollection:"sapIllus-UploadCollection"};return I;});
sap.ui.predefine('sap/m/Illustration',["sap/base/Log","sap/ui/core/Control","./IllustrationRenderer","./IllustrationPool"],function(L,C,I,a){"use strict";
var b=C.extend("sap.m.Illustration",{metadata:{library:"sap.m",properties:{set:{type:"string",defaultValue:null},media:{type:"string",defaultValue:null},type:{type:"string",defaultValue:null}},dnd:{draggable:true,droppable:false}}});
b.CAN_NOT_BUILD_SYMBOL_MSG="Some of the Control's properties are missing. Can't build Symbol ID. No SVG will be displayed.";
b.prototype.init=function(){this._sId=this.getId();};
b.prototype.onBeforeRendering=function(){this._buildSymbolId();if(this._sSymbolId){a.loadAsset(this._sSymbolId,this._sId);}else{L.warning(b.CAN_NOT_BUILD_SYMBOL_MSG);}};
b.prototype._buildSymbolId=function(){var s=this.getSet(),m=this.getMedia(),t=this.getType();this._sSymbolId="";if(s&&m&&t){this._sSymbolId=s+"-"+m+"-"+t;}};
return b;});
sap.ui.predefine('sap/m/IllustrationPool',["sap/base/Log","./library",'sap/ui/core/Core',"sap/ui/thirdparty/jquery"],function(L,l,C,q){"use strict";var S='sap-ui-illustration-pool',a='-Patterns',b='sapIllus',c=sap.ui.require.toUrl("sap/m/themes/base/illustrations/"),d=Object.keys(l.IllustratedMessageType);var s=Object.create(null);s[b]={sPath:c,aSymbols:d,bIsPending:false};var e=[],A=Object.create(null),o=Object.create(null),r=Object.create(null);var I={};
I.loadAsset=function(f,i){var g;if(f===""){L.error("ID of the asset can not be blank/empty.");return;}if(i){r[i]=f;}if(A[f]){L.info("The asset with ID '"+f+"' is either loaded or being loaded.");if(i&&o[f]){I._updateDOMPool();}return;}g=f.split("-")[0];if(!s[g]){L.error("The illustration set '"+g+"' is not registered. Please register it before requiring one of its assets.");return;}A[f]=true;I._requireSVG(g,f,i);};
I.loadRestOfTheAssets=function(i){var f;if(!s[i]){throw new Error("The illustration set '"+i+"' is not registered. Please register it before requiring rest of its assets.");}f=s[i].aSymbols;if(Array.isArray(f)){f.forEach(function(g){I.loadAsset(i+"-Spot-"+g);I.loadAsset(i+"-Dialog-"+g);I.loadAsset(i+"-Scene-"+g);});}};
I.registerIllustrationSet=function(f,g){var n=f.setFamily,p=f.setURI;if(s[n]){if(s[n].bIsPending){L.warning("Illustration Set is currently being loaded.");}else{L.warning("Illustration Set already registered.");}return;}if(p.substr(p.length-1)!=="/"){p+="/";}s[n]=Object.create(null);s[n].sPath=p;s[n].bIsPending=true;I._loadMetadata(n,p,g);};
I._addAssetToDOMPool=function(h,i){I._getDOMPool().insertAdjacentHTML("beforeend",h);if(i){e.push(i);}};
I._getDOMPool=function(){var D=document.getElementById(S);if(D===null){D=document.createElement("div");D.id=S;C.getStaticAreaRef().appendChild(D);I.loadAsset(b+a);}return D;};
I._loadMetadata=function(n,p,f){var m=p+"metadata.json";return new Promise(function(R){q.ajax(m,{type:"GET",dataType:"json",success:function(M){L.info("Metadata for illustration set ("+n+") successfully loaded");I._metadataLoaded(n,M,f);R(M);},error:function(j,g){if(g!=="abort"){L.error("Metadata from: "+m+" file path could not be loaded");delete s[n];R();}}});});};
I._metadataLoaded=function(n,m,f){var g=m.symbols,h=m.requireCustomPatterns;s[n].aSymbols=g;if(h){I.loadAsset(n+a);}if(f){I.loadRestOfTheAssets(n);}s[n].bIsPending=false;};
I._removeAssetFromDOMPool=function(i){var D=document.getElementById(S),f;if(D!==null){f=document.getElementById(i);if(f!==null){D.removeChild(f);e.splice(e.indexOf(i),1);}}};
I._requireSVG=function(f,i,g){return new Promise(function(R){q.ajax(s[f].sPath+i+".svg",{type:"GET",dataType:"html",success:function(h){if(i.indexOf(a)===-1){o[i]=h;if(g){I._updateDOMPool();}}else{I._addAssetToDOMPool(h);}R(h);},error:function(j,h){if(h!=="abort"){delete A[i];L.error(i+" asset could not be loaded");R();}}});});};
I._updateDOMPool=function(){var f=Object.create(null),g=Object.create(null),h,j;for(var k in r){h=r[k];j=e.indexOf(h);if(j===-1){g[h]=true;}else{f[h]=true;}}for(var i=0;i<e.length;i++){h=e[i];if(!f[h]){I._removeAssetFromDOMPool(h);i--;}}for(var m in g){h=o[m];if(h){I._addAssetToDOMPool(h,m);}}};
return I;},true);
sap.ui.predefine('sap/m/IllustrationRenderer',["sap/ui/Device"],function(D){"use strict";var I={apiVersion:2};
I.render=function(r,i){var s=i._sSymbolId;r.openStart("svg",i);r.class("sapFIllustration");r.openEnd();r.openStart("use");r.attr('href',"#"+s);r.openEnd();r.close("use");r.close("svg");};
return I;},true);
sap.ui.predefine('sap/m/Image',['./library','sap/ui/core/Control','sap/ui/base/DataType','./ImageRenderer',"sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/security/encodeCSS","sap/ui/core/library"],function(l,C,D,I,K,q,e,c){"use strict";var a=l.ImageMode;var A=c.aria.HasPopup;
var b=C.extend("sap.m.Image",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/Image.designtime",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},useMap:{type:"string",group:"Misc",defaultValue:null},densityAware:{type:"boolean",group:"Misc",defaultValue:false},activeSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:""},mode:{type:"sap.m.ImageMode",group:"Misc",defaultValue:"Image"},backgroundSize:{type:"string",group:"Appearance",defaultValue:"cover"},backgroundPosition:{type:"string",group:"Appearance",defaultValue:"initial"},backgroundRepeat:{type:"string",group:"Appearance",defaultValue:"no-repeat"},lazyLoading:{type:"boolean",defaultValue:false},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:A.None}},aggregations:{detailBox:{type:'sap.m.LightBox',multiple:false,bindable:"bindable"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDetails:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDetails"}},events:{tap:{},press:{},load:{},error:{}},dnd:{draggable:true,droppable:false}}});
b._currentDevicePixelRatio=(function(){var r=(window.devicePixelRatio===undefined?1:window.devicePixelRatio);if(r<=1){r=1;}else{r*=2;r=Math.round(r);r/=2;}if(r>2){r=2;}return r;}());
b.prototype.onload=function(E){var w,h;if(!this._defaultEventTriggered){this._defaultEventTriggered=true;}this._bVersion2Tried=false;var d=this.$(),o=d[0];if(this.getMode()===a.Background){d.css("background-image","url(\""+e(this._oImage.src)+"\")");}if(!this._isWidthOrHeightSet()){if(this._iLoadImageDensity>1){w=Math.round(o.getBoundingClientRect().width);h=Math.round(o.getBoundingClientRect().height);if((w===o.naturalWidth)&&(h===o.naturalHeight)){d.width(w/this._iLoadImageDensity);}}}d.removeClass("sapMNoImg");this.fireLoad();};
b.prototype.onerror=function(E){if(!this._defaultEventTriggered){this._defaultEventTriggered=true;}var $=this.$(),m=this.getMode(),s=(m===a.Image)?this._getDomImg().attr("src"):this._oImage.src,d=b._currentDevicePixelRatio,f=this._isActiveState?this.getActiveSrc():this.getSrc();$.addClass("sapMNoImg");if(!s||this._iLoadImageDensity===1){if(this.getAlt()&&!this.getDecorative()){$.removeClass("sapMNoImg");}this.fireError();return;}if(d===2||d<1){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(f,1));}else if(d===1.5){if(this._bVersion2Tried){setTimeout(q.proxy(function(){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(f,1));},this),0);}else{setTimeout(q.proxy(function(){this._iLoadImageDensity=2;this._updateDomSrc(this._generateSrcByDensity(f,2));this._bVersion2Tried=true;},this),0);}}};
b.prototype.setDetailBox=function(L){var o=this.getDetailBox();if(L){if(L===o){return this;}if(o){this.detachPress(this._fnLightBoxOpen,o);}this._fnLightBoxOpen=L.open;this.attachPress(this._fnLightBoxOpen,L);}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,o);this._fnLightBoxOpen=null;}return this.setAggregation("detailBox",L);};
b.prototype.clone=function(){var o=C.prototype.clone.apply(this,arguments),d=o.getDetailBox();if(d){o.detachPress(this._fnLightBoxOpen,this.getDetailBox());o._fnLightBoxOpen=d.open;o.attachPress(o._fnLightBoxOpen,d);}return o;};
b.prototype.onBeforeRendering=function(){this._defaultEventTriggered=false;if(this.getMode()==a.Image){var d=this.getDetailBox()?this.$().find(".sapMImg"):this.$();d.off("load").off("error");}};
b.prototype.onAfterRendering=function(){var d=this.getDetailBox()?this.$().find(".sapMImg"):this.$(),m=this.getMode(),o;if(m===a.Image){d.on("load",q.proxy(this.onload,this));d.on("error",q.proxy(this.onerror,this));o=d[0];}if(m===a.Background){o=this._oImage;}if(o&&o.complete&&!this._defaultEventTriggered){if(o.naturalWidth>0){this.onload({});}else{this.onerror({});}}};
b.prototype.exit=function(){if(this._oImage){q(this._oImage).off("load",this.onload).off("error",this.onerror);this._oImage=null;}else{this.$().off("load",this.onload).off("error",this.onerror);}if(this._fnLightBoxOpen){this._fnLightBoxOpen=null;}};
b.prototype.ontouchstart=function(E){if(E.srcControl.mEventRegistry["press"]||E.srcControl.mEventRegistry["tap"]){E.setMarked();}if(E.targetTouches.length===1&&this.getActiveSrc()){this._updateDomSrc(this._getDensityAwareActiveSrc());this._isActiveState=true;}};
b.prototype.ontouchend=function(E){if(E.targetTouches.length===0&&this.getActiveSrc()){this._isActiveState=false;this._updateDomSrc(this._getDensityAwareSrc());this.$().removeClass("sapMNoImg");}};
b.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button");}return this;};
b.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");if(this.getDecorative()){this.$().attr("role","presentation");}else{this.$().removeAttr("role");}}return this;};
b.prototype.ontap=function(E){this.fireTap({});this.firePress({});};
b.prototype.onkeyup=function(E){if(E.which===K.SPACE||E.which===K.ENTER){this.firePress({});E.stopPropagation();}};
b.prototype.onsapspace=function(E){E.preventDefault();};
b.prototype._updateDomSrc=function(s){var d=this.$(),m=this.getMode();if(d.length){if(m===a.Image){this._getDomImg().attr("src",s);}else{d.addClass("sapMNoImg");q(this._oImage).attr("src",s);}}};
b.prototype._getDomImg=function(){var d=this.$();return this.getDetailBox()?d.children("img"):d;};
b.prototype._preLoadImage=function(s){if(this.getMode()!==a.Background){return;}var $=q(this._oImage);if(!this._oImage){this._oImage=new window.Image();$=q(this._oImage);$.on("load",q.proxy(this.onload,this)).on("error",q.proxy(this.onerror,this));}this._oImage.src=s;};
b.prototype._isWidthOrHeightSet=function(){return(this.getWidth()&&this.getWidth()!=='')||(this.getHeight()&&this.getHeight()!=='');};
b.prototype._getDensityAwareSrc=function(){var s=this.getSrc(),f=this.getDensityAware(),d=f?b._currentDevicePixelRatio:1;this._iLoadImageDensity=d;return this._generateSrcByDensity(s,d);};
b.prototype._getDensityAwareActiveSrc=function(){var s=this.getActiveSrc(),f=this.getDensityAware(),d=f?b._currentDevicePixelRatio:1;this._iLoadImageDensity=d;return this._generateSrcByDensity(s,d);};
b.prototype._generateSrcByDensity=function(s,d){if(!s){return"";}if(this._isDataUri(s)){this._iLoadImageDensity=1;return s;}if(d===1){return s;}var L=s.lastIndexOf("."),f=s.lastIndexOf("/"),N=s.substring(0,L),E=s.substring(L);if(L===-1||(f>L)){return s+"@"+d;}N=N+"@"+d;return N+E;};
b.prototype._isDataUri=function(s){return s?s.indexOf("data:")===0:false;};
b.prototype._isValidBackgroundSizeValue=function(v){v=n(v);return i(v.split(" "),["auto","cover","contain","initial"])||D.getType("sap.ui.core.CSSSizeShortHand").isValid(v);};
b.prototype._isValidBackgroundPositionValue=function(v){v=n(v);return i(v.split(" "),["left","right","top","center","bottom","initial"])||D.getType("sap.ui.core.CSSSizeShortHand").isValid(v);};
b.prototype.getAccessibilityInfo=function(){var h=this.hasListeners("press");if(this.getDecorative()&&!this.getUseMap()&&!h){return null;}return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||"",focusable:h};};
b.prototype.getFocusDomRef=function(){return this.getDomRef("inner")||this.getDomRef();};
b.prototype.getFormDoNotAdjustWidth=function(){return true;};
function i(t,r){function d(T){return r.indexOf(T)<0;}return t&&r&&!t.some(d);}
function n(v){var w=/\s+/g;return v==null?"":String(v).trim().replace(w," ");}
return b;});
sap.ui.predefine('sap/m/ImageContent',['./library','sap/ui/core/Control','sap/m/Image','sap/ui/core/IconPool','sap/ui/Device','./ImageContentRenderer',"sap/ui/events/KeyCodes"],function(l,C,I,a,D,b,K){"use strict";
var c=C.extend("sap.m.ImageContent",{metadata:{library:"sap.m",properties:{src:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},description:{type:"string",group:"Accessibility",defaultValue:null}},defaultAggregation:"_content",aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{press:{}}}});
c.prototype.onBeforeRendering=function(){var i,u,d;i=this.getAggregation("_content");u=this.getSrc();d=this.getDescription();if(!i||u!==i.getSrc()||d!==i.getAlt()){if(i){i.destroy();i=null;}i=a.createControlByURI({id:this.getId()+"-icon-image",src:u,alt:d,decorative:true},I);this.setAggregation("_content",i,true);this._setPointerOnImage();}if(d){this.setTooltip(d.trim());}};
c.prototype._setPointerOnImage=function(){var i=this.getAggregation("_content");if(i&&this.hasListeners("press")){i.addStyleClass("sapMPointer");}else if(i&&i.hasStyleClass("sapMPointer")){i.removeStyleClass("sapMPointer");}};
c.prototype.ontap=function(e){if(D.browser.msie){this.$().trigger("focus");}this.firePress();};
c.prototype.onkeydown=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};
c.prototype.attachEvent=function(e,d,f,g){C.prototype.attachEvent.call(this,e,d,f,g);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnImage();}return this;};
c.prototype.detachEvent=function(e,f,d){C.prototype.detachEvent.call(this,e,f,d);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnImage();}return this;};
c.prototype.getAltText=function(){var o=this.getAggregation("_content");if(o&&o.getAlt()!==""){return o.getAlt();}else if(o&&o.getAccessibilityInfo()){return o.getAccessibilityInfo().description;}else{return"";}};
return c;});
sap.ui.predefine('sap/m/ImageContentRenderer',[],function(){"use strict";var I={apiVersion:2};
I.render=function(r,c){r.openStart("div",c);r.class("sapMImageContent");var t=c.getTooltip_AsString();if(t){r.attr("title",t);}if(c.hasListeners("press")){r.class("sapMPointer");r.attr("tabindex","0");}r.openEnd();var C=c.getAggregation("_content");if(C){C.addStyleClass("sapMImageContentImageIcon");r.renderControl(C);}r.close("div");};
return I;},true);
sap.ui.predefine('sap/m/ImageRenderer',['sap/m/library',"sap/base/security/encodeCSS","sap/ui/core/library"],function(l,e,c){"use strict";var I=l.ImageMode;var A=c.aria.HasPopup;var a={apiVersion:2};
a.render=function(r,i){var m=i.getMode(),b=i.getAlt(),t=i.getTooltip_AsString(),h=i.hasListeners("press"),L=i.getDetailBox(),u=i.getUseMap(),d=i.getAriaLabelledBy(),D=i.getAriaDescribedBy(),f=i.getAriaDetails(),g=m===I.Image,j=i.getLazyLoading(),s=i.getAriaHasPopup();if(L){r.openStart("span",i);r.class("sapMLightBoxImage");r.openEnd();r.openStart("span").class("sapMLightBoxMagnifyingGlass").openEnd().close("span");}if(g){r.voidStart("img",!L?i:i.getId()+"-inner");if(j){r.attr("loading","lazy");}}else{r.openStart("span",!L?i:i.getId()+"-inner");}if(!i.getDecorative()){if(d&&d.length>0){r.attr("aria-labelledby",d.join(" "));}if(D&&D.length>0){r.attr("aria-describedby",D.join(" "));}if(f&&f.length>0){r.attr("aria-details",f.join(" "));}}if(g){r.attr("src",i._getDensityAwareSrc());}else{i._preLoadImage(i._getDensityAwareSrc());if(i._isValidBackgroundSizeValue(i.getBackgroundSize())){r.style("background-size",i.getBackgroundSize());}if(i._isValidBackgroundPositionValue(i.getBackgroundPosition())){r.style("background-position",i.getBackgroundPosition());}r.style("background-repeat",e(i.getBackgroundRepeat()));}r.class("sapMImg");if(i.hasListeners("press")||i.hasListeners("tap")){r.class("sapMPointer");}if(u||!i.getDecorative()||h){r.class("sapMImgFocusable");}if(u){if(!(u.startsWith("#"))){u="#"+u;}r.attr("usemap",u);}if(i.getDecorative()&&!u&&!h){r.attr("role","presentation");r.attr("aria-hidden","true");r.attr("alt","");}else if(b||t){r.attr("alt",b||t);}if(b||t){r.attr("aria-label",b||t);}if(t){r.attr("title",t);}if(s!==A.None){r.attr("aria-haspopup",s.toLowerCase());}if(h){r.attr("role","button");r.attr("tabindex",0);}r.style("width",i.getWidth());r.style("height",i.getHeight());g?r.voidEnd():r.openEnd().close("span");if(L){r.close("span");}};
return a;},true);
sap.ui.predefine('sap/m/Input',['./InputBase','./Popover','sap/ui/core/Item','./ColumnListItem','./GroupHeaderListItem','./StandardListItem','sap/ui/core/SeparatorItem','./List','./Table','./library','sap/ui/core/IconPool','sap/ui/Device','./SuggestionsPopover','./Toolbar','./ToolbarSpacer','./Button',"sap/ui/core/ResizeHandler","sap/ui/dom/containsOrEquals","sap/base/assert","sap/base/util/deepEqual","sap/m/inputUtils/wordStartsWithValue","sap/m/inputUtils/inputsDefaultFilter","sap/m/inputUtils/highlightDOMElements","sap/m/inputUtils/typeAhead","sap/ui/events/KeyCodes","sap/m/inputUtils/filterItems","sap/m/inputUtils/ListHelpers","sap/m/inputUtils/calculateSelectionStart","sap/m/inputUtils/selectionRange","./InputRenderer","sap/ui/base/ManagedObject","sap/ui/base/ManagedObjectObserver","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/selectText"],function(I,P,a,C,G,S,b,L,T,l,c,D,d,e,f,B,R,g,h,j,w,k,m,t,K,n,o,p,s,q,M,r,Q){"use strict";var u=l.ListType;var v=l.InputTextFormatMode;var x=l.InputType;var y=l.ListMode;var z=l.ListSeparators;
var A=I.extend("sap.m.Input",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.InputType",group:"Data",defaultValue:x.Text},maxLength:{type:"int",group:"Behavior",defaultValue:0},dateFormat:{type:"string",group:"Misc",defaultValue:'YYYY-MM-dd',deprecated:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpIconSrc:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:"sap-icon://value-help"},showSuggestion:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpOnly:{type:"boolean",group:"Behavior",defaultValue:false},filterSuggests:{type:"boolean",group:"Behavior",defaultValue:true},maxSuggestionWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},startSuggestion:{type:"int",group:"Behavior",defaultValue:1},showTableSuggestionValueHelp:{type:"boolean",group:"Behavior",defaultValue:true},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'50%'},valueLiveUpdate:{type:"boolean",group:"Behavior",defaultValue:false},selectedKey:{type:"string",group:"Data",defaultValue:""},textFormatMode:{type:"sap.m.InputTextFormatMode",group:"Misc",defaultValue:v.Value},textFormatter:{type:"any",group:"Misc",defaultValue:""},suggestionRowValidator:{type:"any",group:"Misc",defaultValue:""},enableSuggestionsHighlighting:{type:"boolean",group:"Behavior",defaultValue:true},enableTableAutoPopinMode:{type:"boolean",group:"Behavior",defaultValue:false},autocomplete:{type:"boolean",group:"Behavior",defaultValue:true},showClearIcon:{type:"boolean",defaultValue:false},effectiveShowClearIcon:{type:"boolean",defaultValue:false,visibility:"hidden"},separateSuggestions:{type:"boolean",defaultValue:false,visibility:"hidden"}},defaultAggregation:"suggestionItems",aggregations:{suggestionItems:{type:"sap.ui.core.Item",multiple:true,singularName:"suggestionItem"},suggestionColumns:{type:"sap.m.Column",multiple:true,singularName:"suggestionColumn",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"columns"}},suggestionRows:{type:"sap.m.ColumnListItem",altTypes:["sap.m.GroupHeaderListItem"],multiple:true,singularName:"suggestionRow",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"items"}},_suggestionPopup:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_valueHelpIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},selectedRow:{type:"sap.m.ColumnListItem",multiple:false}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},valueHelpRequest:{parameters:{fromSuggestions:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"},suggestionColumns:{type:"sap.m.ListBase"}}},suggestionItemSelected:{parameters:{selectedItem:{type:"sap.ui.core.Item"},selectedRow:{type:"sap.m.ColumnListItem"}}},submit:{parameters:{value:{type:"string"}}}},designtime:"sap/m/designtime/Input.designtime"}});
c.insertFontFaceStyle();
A._DEFAULTFILTER_TABULAR=function(V,E){var F=E.getCells(),i=0;for(;i<F.length;i++){if(F[i].getText){if(w(F[i].getText(),V)){return true;}}}return false;};
A._DEFAULTRESULT_TABULAR=function(E){if(!E||E.isA("sap.m.GroupHeaderListItem")){return"";}var F=E.getCells(),i=0;for(;i<F.length;i++){if(F[i].getText){return F[i].getText();}}return"";};
A.prototype.init=function(){I.prototype.init.call(this);this._iSetCount=0;this._sProposedItemText=null;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(this.getId().indexOf("popup-input")===-1){this._createSuggestionsPopover();}this._setTypedInValue("");this._bClearButtonPressed=false;this._bAfterOpenFinisihed=false;};
A.prototype.exit=function(){I.prototype.exit.call(this);this._deregisterEvents();this.cancelPendingSuggest();if(this._iRefreshListTimeout){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=null;}this._destroySuggestionsTable();if(this._getSuggestionsPopover()){this._oSuggestionPopup=null;this._oSuggPopover.destroy();this._oSuggPopover=null;}this.$().off("click");};
A.prototype.onBeforeRendering=function(){var i=this.getSelectedKey(),E=this.getShowValueHelp()&&this.getEnabled()&&this.getEditable(),F=this.getProperty("effectiveShowClearIcon")&&this.getEnabled()&&this.getEditable(),H=this._oValueHelpIcon,J=this._getSuggestionsPopover(),N=J&&this._isSuggestionsPopoverOpen(),O=J&&J.getInput(),V=N?J._getValueStateHeader().getText():null,U=N?J._getValueStateHeader().getValueState():"";I.prototype.onBeforeRendering.call(this);if(this.getShowClearIcon()){this._getClearIcon().setProperty("visible",F);}else if(this._oClearButton){this._getClearIcon().setProperty("visible",false);}this._deregisterEvents();if(i&&!this.getSelectedItem()&&this.getSuggestionItemByKey(i)){this.setSelectedKey(i);}if(this.getShowSuggestion()){if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton();}else{this._removeShowMoreButton();}if(O){O.setType(this.getType());}}if(E){H=this._getValueHelpIcon();H.setProperty("visible",true,true);}else if(H){H.setProperty("visible",false,true);}if(!this.getWidth()){this.setProperty("width","100%",true);}if(this._hasTabularSuggestions()){this._getSuggestionsTable().setAutoPopinMode(this.getEnableTableAutoPopinMode());this._getSuggestionsTable().setContextualWidth(this.getEnableTableAutoPopinMode()?"Auto":"Inherit");}if(N&&((this.getValueStateText()&&V!==this.getValueStateText())||(this.getValueState()!==U)||(this.getFormattedValueStateText()))){this._updateSuggestionsPopoverValueState();}};
A.prototype._getDisplayText=function(i){var E=this.getTextFormatter();if(E){return E(i);}var F=i.getText(),H=i.getKey(),J=this.getTextFormatMode();switch(J){case v.Key:return H;case v.ValueKey:return F+' ('+H+')';case v.KeyValue:return'('+H+') '+F;default:return F;}};
A.prototype._onValueUpdated=function(i){if(this._bSelectingItem||i===this._sSelectedValue){return;}var E=this.getSelectedKey(),H,F=this._getSuggestionsPopover(),J=F&&F.getItemsContainer();if(E===''){return;}if(this._hasTabularSuggestions()){H=this._getSuggestionsTable()&&!!this._getSuggestionsTable().getSelectedItem();}else{H=J&&!!J.getSelectedItem();}if(H){return;}this.setProperty("selectedKey",'',true);this.setAssociation("selectedRow",null,true);this.setAssociation("selectedItem",null,true);this.fireSuggestionItemSelected({selectedItem:null,selectedRow:null});};
A.prototype.setSelectionItem=function(i,E){this._bSelectingItem=true;if(!i){this.setAssociation("selectedItem",null,true);this.setValue('');return;}var F=this._iSetCount,N;this.setAssociation("selectedItem",i,true);this.setProperty("selectedKey",i.getKey(),true);if(E){this.fireSuggestionItemSelected({selectedItem:i});}if(F!==this._iSetCount){N=this.getValue();}else{N=this._getDisplayText(i);}this._sSelectedValue=N;this.updateInputField(N);if(this.bIsDestroyed){return;}if(!(this.isMobileDevice()&&this instanceof sap.m.MultiInput)){this._closeSuggestionPopup();}this._bSelectingItem=false;this._resetTypeAhead();};
A.prototype.addSuggestionRowGroup=function(i,H,E){H=H||new G({title:M.escapeSettingsValue(i.text)||M.escapeSettingsValue(i.key)});this._createSuggestionPopupContent(true);this.addAggregation("suggestionRows",H,E);return H;};
A.prototype.addSuggestionItemGroup=function(i,H,E){H=H||new b({text:M.escapeSettingsValue(i.text)||M.escapeSettingsValue(i.key)});this._createSuggestionPopupContent(false);this.addAggregation("suggestionItems",H,E);return H;};
A.prototype.setSelectedItem=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof a)){return this;}this.setSelectionItem(i);return this;};
A.prototype.setSelectedKey=function(i){i=this.validateProperty("selectedKey",i);this.setProperty("selectedKey",i,true);if(this._hasTabularSuggestions()){return this;}if(!i){this.setSelectionItem();return this;}var E=this.getSuggestionItemByKey(i);this.setSelectionItem(E);return this;};
A.prototype.getSuggestionItemByKey=function(E){var F=this.getSuggestionItems()||[],H,i;for(i=0;i<F.length;i++){H=F[i];if(H.getKey()===E){return H;}}};
A.prototype._getFormattedValueStateText=function(){var i=this._isSuggestionsPopoverOpen(),V=i?this._getSuggestionsPopover()._getValueStateHeader().getFormattedText():null;if(i&&V){return V;}else{return I.prototype.getFormattedValueStateText.call(this);}};
A.prototype.setSelectionRow=function(i,E){if(!i){this.setAssociation("selectedRow",null,true);return;}this._bSelectingItem=true;var F,H=this.getSuggestionRowValidator();if(H){F=H(i);if(!(F instanceof a)){F=null;}}var J=this._iSetCount,N="",O;this.setAssociation("selectedRow",i,true);if(F){N=F.getKey();}this.setProperty("selectedKey",N,true);if(E){this.fireSuggestionItemSelected({selectedRow:i});}if(J!==this._iSetCount){O=this.getValue();}else{if(F){O=this._getDisplayText(F);}else{O=this._getRowResultFunction()(i);}}this._sSelectedValue=O;this.updateInputField(O);if(this.bIsDestroyed){return;}if(!(this.isMobileDevice()&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this.setSelectionUpdatedFromList(false);this._closeSuggestionPopup();}this._bSelectingItem=false;};
A.prototype.setSelectedRow=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof C)){return this;}this.setSelectionRow(i);return this;};
A.prototype._getValueHelpIcon=function(){var i=this,E=this.getValueHelpIconSrc();if(!this._oValueHelpIcon){this._oValueHelpIcon=this.addEndIcon({id:this.getId()+"-vhi",src:E,useIconTooltip:false,alt:this._oRb.getText("INPUT_VALUEHELP_BUTTON"),decorative:false,noTabStop:true,press:function(F){if(!i.getValueHelpOnly()){var H=this.getParent(),$;if(D.support.touch){$=H.$('inner');$.attr('readonly','readonly');H.focus();$.removeAttr('readonly');}else{H.focus();}i.bValueHelpRequested=true;i._fireValueHelpRequest(false);}}});}else if(this._oValueHelpIcon.getSrc()!==E){this._oValueHelpIcon.setSrc(E);}return this._oValueHelpIcon;};
A.prototype._getClearIcon=function(){var i=this;if(this._oClearButton){return this._oClearButton;}this._oClearButton=this.addEndIcon({src:c.getIconURI("decline"),noTabStop:true,visible:false,alt:this._oRb.getText("INPUT_CLEAR_ICON_ALT"),useIconTooltip:false,decorative:false,press:function(){if(i.getValue()!==""){i.fireChange({value:""});i.fireLiveChange({value:""});i.setValue("");i._bClearButtonPressed=true;setTimeout(function(){if(D.system.desktop){i.focus();i._closeSuggestionPopup();}},0);}}},0);return this._oClearButton;};
A.prototype._fireValueHelpRequest=function(F){var i="";if(this.getShowSuggestion()&&!this.isMobileDevice()){i=this._getTypedInValue()||"";}else{i=this.getDOMValue();}this.fireValueHelpRequest({fromSuggestions:F,_userInputValue:i});};
A.prototype._fireValueHelpRequestForValueHelpOnly=function(){if(this.getEnabled()&&this.getEditable()&&this.getShowValueHelp()&&this.getValueHelpOnly()){if(D.system.phone){this.focus();}this._fireValueHelpRequest(false);}};
A.prototype.ontap=function(E){I.prototype.ontap.call(this,E);if(this.isValueHelpOnlyOpener(E.target)){this._fireValueHelpRequestForValueHelpOnly();}if(this.shouldSuggetionsPopoverOpenOnMobile(E)){this._openSuggestionsPopover();}this._bClearButtonPressed=false;};
A.prototype.shouldSuggetionsPopoverOpenOnMobile=function(E){return this.isMobileDevice()&&this.getEditable()&&this.getEnabled()&&this.getShowSuggestion()&&(!this._bClearButtonPressed)&&E.target.id!==this.getId()+"-vhi";};
A.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this._fnFilter=k;return this;}h(typeof(F)==="function","Input.setFilterFunction: first argument fnFilter must be a function on "+this);this._fnFilter=F;return this;};
A.prototype._getFilterFunction=function(F){if(typeof this._fnFilter==="function"&&!F){return this._fnFilter;}return!this._hasTabularSuggestions()?k:A._DEFAULTFILTER_TABULAR;};
A.prototype.setRowResultFunction=function(F){var i;if(F===null||F===undefined){this._fnRowResultFilter=A._DEFAULTRESULT_TABULAR;return this;}h(typeof(F)==="function","Input.setRowResultFunction: first argument fnFilter must be a function on "+this);this._fnRowResultFilter=F;i=this.getSelectedRow();if(i){this.setSelectedRow(i);}return this;};
A.prototype._getRowResultFunction=function(F){if(typeof this._fnRowResultFilter==="function"&&!F){return this._fnRowResultFilter;}return A._DEFAULTRESULT_TABULAR;};
A.prototype.closeSuggestions=function(){this._closeSuggestionPopup();};
A.prototype._doSelect=function(i,E){if(D.support.touch){return;}var F=this._$input[0];if(F){var $=this._$input;F.focus();$.selectText(i?i:0,E?E:$.val().length);}return this;};
A.prototype._isIncrementalType=function(){var i=this.getType();if(i==="Number"||i==="Date"||i==="Datetime"||i==="Month"||i==="Time"||i==="Week"){return true;}return false;};
A.prototype.onsapescape=function(E){if(this._isSuggestionsPopoverOpen()){E.originalEvent._sapui_handledByControl=true;this.setSelectionUpdatedFromList(false);this._closeSuggestionPopup();if(this._getTypedInValue()!==this.getValue()){this.setValue(this._getTypedInValue());}return;}if(this.getValueLiveUpdate()){this.setProperty("value",this.getLastValue(),true);}if(I.prototype.onsapescape){I.prototype.onsapescape.apply(this,arguments);}};
A.prototype.onsapenter=function(E){var i=this._isSuggestionsPopoverOpen(),F=!this.hasStyleClass("sapMFocus")&&i,H=this._hasTabularSuggestions()?this.getSuggestionRows():this.getSuggestionItems(),V,J;this.cancelPendingSuggest();F&&this.setSelectionUpdatedFromList(true);if(this.getShowSuggestion()&&this._bDoTypeAhead&&i){J=this._getSuggestionsPopover().getItemsContainer().getSelectedItem();if(this._hasTabularSuggestions()){J&&this.setSelectionRow(J,true);}else{J&&this.setSelectionItem(o.getItemByListItem(H,J),true);}}if(i&&!this.isComposingCharacter()){this._closeSuggestionPopup();V=this.getDOMValue()?this.getDOMValue().length:null;this.selectText(V,V);}!F&&I.prototype.onsapenter.apply(this,arguments);if(this.getEnabled()&&this.getEditable()&&!(this.getValueHelpOnly()&&this.getShowValueHelp())){this.fireSubmit({value:this.getValue()});}if(!this.isMobileDevice()){this._resetTypeAhead();}};
A.prototype.onsapfocusleave=function(E){var i=this._getSuggestionsPopover(),F=i&&i.getPopover(),H=F&&F.isA("sap.m.Popover"),J=E.relatedControlId&&sap.ui.getCore().byId(E.relatedControlId),N=J&&J.getFocusDomRef(),O=F&&N&&g(F.getDomRef(),N);if(H){if(O&&!i.getValueStateActiveState()){this._bPopupHasFocus=true;if(D.system.desktop&&j(F.getFocusDomRef(),N)||J.isA("sap.m.GroupHeaderListItem")){this.focus();}}else{if(this.getDOMValue()===this._sSelectedSuggViaKeyboard){this._sSelectedSuggViaKeyboard=null;}}}if(!O){I.prototype.onsapfocusleave.apply(this,arguments);}this.bValueHelpRequested=false;};
A.prototype.onsaptabnext=function(){if(!this.isMobileDevice()&&this._sProposedItemText&&!this._bAfterOpenFinisihed){var i=this.getSuggestionItems().filter(function(E){return E.getText()===this._sProposedItemText;}.bind(this))[0];if(i){this.setSelectionItem(i,true);this.selectText(0,0);}}};
A.prototype.onmousedown=function(E){if(this._isSuggestionsPopoverOpen()){E.stopPropagation();}};
["onsapup","onsapdown","onsappageup","onsappagedown","onsaphome","onsapend"].forEach(function(N){A.prototype[N]=function(E){if((N==="onsapup"||N==="onsapdown")&&this.isComposingCharacter()){return;}if(this.getShowSuggestion()){this._getSuggestionsPopover().handleListNavigation(this,E);if(this._isIncrementalType()){E.setMarked();}this.setSelectionUpdatedFromList(true);}};});
A.prototype.setSelectionUpdatedFromList=function(U){this._bSelectionUpdatedFromList=U;};
A.prototype.getSelectionUpdatedFromList=function(){return this._bSelectionUpdatedFromList;};
A.prototype.updateSelectionFromList=function(i){if(this._hasTabularSuggestions()&&(this.getSelectedRow()!==i)){this.setSelectionRow(i,true);}else{var N=o.getItemByListItem(this.getSuggestionItems(),i);N&&(this.getSelectedItem()!==N.getId())&&this.setSelectionItem(N,true);}this.setSelectionUpdatedFromList(false);};
A.prototype._deregisterEvents=function(){this._deregisterPopupResize();if(this.isMobileDevice()&&this._getSuggestionsPopover()&&this._getSuggestionsPopover().getPopover()){this.$().off("click");}};
A.prototype.updateSuggestionItems=function(){this._bSuspendInvalidate=true;this.updateAggregation("suggestionItems");this._synchronizeSuggestions();this._bSuspendInvalidate=false;return this;};
A.prototype.invalidate=function(){if(!this._bSuspendInvalidate){I.prototype.invalidate.apply(this,arguments);}};
A.prototype.cancelPendingSuggest=function(){if(this._iSuggestDelay){clearTimeout(this._iSuggestDelay);this._iSuggestDelay=null;}};
A.prototype._triggerSuggest=function(V){var i=this._getSuggestionsPopover().getItemsContainer();this.cancelPendingSuggest();this._bShouldRefreshListItems=true;if(!V){V="";}if(V.length>=this.getStartSuggestion()){this._iSuggestDelay=setTimeout(function(){if(this._sPrevSuggValue!==V){this._bBindingUpdated=false;this.fireSuggest({suggestValue:V});if(!this._bBindingUpdated){this._refreshItemsDelayed();}this._sPrevSuggValue=V;}}.bind(this),300);}else if(this.isMobileDevice()){if(i instanceof T){i.addStyleClass("sapMInputSuggestionTableHidden");}else if(i&&i.destroyItems){i.destroyItems();}}else if(this._isSuggestionsPopoverOpen()){setTimeout(function(){var N=this.getDOMValue()||'';if(N.length<this.getStartSuggestion()){this._closeSuggestionPopup();}}.bind(this),0);}};
A.prototype._shouldTriggerSuggest=function(){return!this._bPopupHasFocus&&!this.getStartSuggestion()&&!this.getValue()&&this.getShowSuggestion();};
A.prototype.setShowTableSuggestionValueHelp=function(V){var i=this._getSuggestionsPopover();this.setProperty("showTableSuggestionValueHelp",V,true);if(!i.getPopover()){return this;}if(V){this._addShowMoreButton();}else{this._removeShowMoreButton();}return this;};
A.prototype.onchange=function(E){if(this.getShowValueHelp()||this.getShowSuggestion()||this.getProperty("effectiveShowClearIcon")){return;}this.onChange(E);};
A.prototype.oninput=function(E){I.prototype.oninput.call(this,E);if(E.isMarked("invalid")){return;}var V=this.getDOMValue(),i,F,H;if(this.getValueLiveUpdate()){this.setProperty("value",V,true);this._onValueUpdated(V);}this.fireLiveChange({value:V,newValue:V});this.addStyleClass("sapMFocus");if(this.getShowSuggestion()&&!this.isMobileDevice()){i=this._getSuggestionsPopover();F=i.getItemsContainer();this._triggerSuggest(V);if(F&&!i.getValueStateActiveState()){H=F&&F.getSelectedItem();F.removeStyleClass("sapMListFocus");H&&H.removeStyleClass("sapMLIBFocused");}else if(i.getValueStateActiveState()&&document.activeElement.tagName!=="A"){i._getValueStateHeader().removeStyleClass("sapMPseudoFocus");}}this._handleTypeAhead(this);};
A.prototype.onkeydown=function(E){this._bDoTypeAhead=!D.os.android&&this.getAutocomplete()&&(E.which!==K.BACKSPACE)&&(E.which!==K.DELETE);};
A.prototype.onkeyup=function(E){var V=this.getValue();var i=this.getLastValue();if([K.BACKSPACE,K.DELETE].indexOf(E.which)!==-1&&!V){this.getShowSuggestion()&&this.setSelectedKey(null);(i!==V)&&this.setLastValue(i);}this.getShowClearIcon()&&this.setProperty("effectiveShowClearIcon",!!V);};
A.prototype.getValue=function(){return this.getDomRef("inner")&&this._$input?this.getDOMValue():this.getProperty("value");};
A.prototype._refreshItemsDelayed=function(){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=setTimeout(this._refreshListItems.bind(this),0);};
A.prototype._clearSuggestionPopupItems=function(){var i=this._getSuggestionsPopover().getItemsContainer();if(!i){return;}if(i instanceof T){i.removeSelections(true);}else{i.destroyItems();}};
A.prototype._hideSuggestionPopup=function(){var i=this._getSuggestionsPopover(),E=i.getPopover(),F=i.getItemsContainer();if(!this.isMobileDevice()){if(this._isSuggestionsPopoverOpen()){this._sCloseTimer=setTimeout(function(){this.cancelPendingSuggest();if(this._getTypedInValue()){this.setDOMValue(this._getTypedInValue());}E.close();}.bind(this),0);}}else if(this._hasTabularSuggestions()&&F){F.addStyleClass("sapMInputSuggestionTableHidden");}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-activedescendant");};
A.prototype._openSuggestionPopup=function(O){if(!this.isMobileDevice()){if(this._sCloseTimer){clearTimeout(this._sCloseTimer);this._sCloseTimer=null;}if(!this._isSuggestionsPopoverOpen()&&!this._sOpenTimer&&O!==false&&this.getShowSuggestion()){this._sOpenTimer=setTimeout(function(){this._sOpenTimer=null;this._getSuggestionsPopover()&&this._openSuggestionsPopover();}.bind(this),0);}}};
A.prototype._applySuggestionAcc=function(N){var i="",E=this._oRb;setTimeout(function(){if(N===1){i=E.getText("INPUT_SUGGESTIONS_ONE_HIT");}else if(N>1){i=E.getText("INPUT_SUGGESTIONS_MORE_HITS",N);}else{i=E.getText("INPUT_SUGGESTIONS_NO_HIT");}this.$("SuggDescr").text(i);}.bind(this),0);};
A.prototype._refreshListItems=function(){var i=this.getShowSuggestion(),E=this._bDoTypeAhead?this._getTypedInValue():(this.getDOMValue()||""),F,H;if(!i||!this._bShouldRefreshListItems||!this.getDomRef()||(!this.isMobileDevice()&&!this.$().hasClass("sapMInputFocused"))){return null;}this._clearSuggestionPopupItems();if(E.length<this.getStartSuggestion()){this._hideSuggestionPopup();return false;}F=this._getFilteredSuggestionItems(E);H=F.items.length;if(H>0&&!this.getValueHelpOnly()){this._openSuggestionPopup(this.getValue().length>=this.getStartSuggestion());}else{this._hideSuggestionPopup();}this._applySuggestionAcc(H);};
A.prototype.addSuggestionItem=function(i){this.addAggregation("suggestionItems",i,true);this._synchronizeSuggestions();this._createSuggestionPopupContent();return this;};
A.prototype.insertSuggestionItem=function(i,E){this.insertAggregation("suggestionItems",E,i,true);this._synchronizeSuggestions();this._createSuggestionPopupContent();return this;};
A.prototype.removeSuggestionItem=function(i){var E=this.removeAggregation("suggestionItems",i,true);this._synchronizeSuggestions();return E;};
A.prototype.removeAllSuggestionItems=function(){var i=this.removeAllAggregation("suggestionItems",true);this._synchronizeSuggestions();return i;};
A.prototype.destroySuggestionItems=function(){this.destroyAggregation("suggestionItems",true);this._synchronizeSuggestions();return this;};
A.prototype.bindAggregation=function(){if(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns"||arguments[0]==="suggestionItems"){this._createSuggestionPopupContent(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns");this._bBindingUpdated=true;}return I.prototype.bindAggregation.apply(this,arguments);};
A.prototype._closeSuggestionPopup=function(){this._bShouldRefreshListItems=false;this.cancelPendingSuggest();this._isSuggestionsPopoverOpen()&&this._getSuggestionsPopover().getPopover().close();if(!this.isMobileDevice()&&this.$().hasClass("sapMInputFocused")){this.openValueStateMessage();}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-activedescendant");this._sPrevSuggValue=null;};
A.prototype._synchronizeSuggestions=function(){var i=this._getSuggestionsPopover(),E=i&&i.getInput(),F=E&&E.getFocusDomRef();if(document.activeElement===this.getFocusDomRef()||document.activeElement===F){this._bShouldRefreshListItems=true;this._refreshItemsDelayed();}if(!this.getDomRef()||this._isSuggestionsPopoverOpen()){return;}this._synchronizeSelection();};
A.prototype._synchronizeSelection=function(){var i=this.getSelectedKey();if(!i){return;}if(this.getValue()&&!this.getSelectedItem()&&!this.getSelectedRow()){return;}this.setSelectedKey(i);};
A.prototype.onfocusin=function(E){I.prototype.onfocusin.apply(this,arguments);this.addStyleClass("sapMInputFocused");if(!this.isMobileDevice()&&this._isSuggestionsPopoverOpen()){this.closeValueStateMessage();}if(this._shouldTriggerSuggest()){this._triggerSuggest(this.getValue());}this._bPopupHasFocus=undefined;this._sPrevSuggValue=null;};
A.prototype.oncompositionend=function(E){I.prototype.oncompositionend.apply(this,arguments);if(!D.browser.firefox){this._handleTypeAhead(this);}};
A.prototype._handleTypeAhead=function(i){var V=this.getValue();this._setTypedInValue(V);i._sProposedItemText=null;if(!this._bDoTypeAhead||V===""||V.length<this.getStartSuggestion()||document.activeElement!==this.getFocusDomRef()){return;}var H=i._hasTabularSuggestions(),E=H?i.getSuggestionRows():i.getSuggestionItems(),F=function(N){if(!N){return"";}return H?i._getRowResultFunction()(N):N.getText();};var J=t(V,this,E,function(N){return this._formatTypedAheadValue(F(N));}.bind(this));i._sProposedItemText=F(J[0]);};
A.prototype._resetTypeAhead=function(i){i=i||this;i._sProposedItemText=null;this._setTypedInValue('');};
A.prototype.onsapright=function(){var V=this.getValue();if(!this.getAutocomplete()){return;}if(this._getTypedInValue()!==V){this._setTypedInValue(V);this.fireLiveChange({value:V,newValue:V});}};
A.prototype._formatTypedAheadValue=function(N){var i=this._getTypedInValue();if(N.toLowerCase().indexOf(i.toLowerCase())===0){return i.concat(N.substring(i.length,N.length));}else{return N;}};
A.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()||!this.getShowValueHelp()){return;}this.bValueHelpRequested=true;this._fireValueHelpRequest(false);E.preventDefault();E.stopPropagation();};
A.prototype.onsaphide=A.prototype.onsapshow;
A.prototype.onsapselect=function(E){this._fireValueHelpRequestForValueHelpOnly();};
A.prototype.onfocusout=function(E){I.prototype.onfocusout.apply(this,arguments);this.removeStyleClass("sapMInputFocused");this.$("SuggDescr").text("");};
A.prototype._hasTabularSuggestions=function(){return!!(this.getAggregation("suggestionColumns")&&this.getAggregation("suggestionColumns").length);};
A.prototype._getSuggestionsTable=function(){if(this._bIsBeingDestroyed){return null;}if(!this._oSuggestionsTable){this._oSuggestionsTable=this._createSuggestionsTable();}return this._oSuggestionsTable;};
A.prototype._destroySuggestionsTable=function(){if(this._oSuggestionsTable){this._oSuggestionsTable.destroy();this._oSuggestionsTable=null;}};
A.prototype._createSuggestionsTable=function(){var i;var E=new T(this.getId()+"-popup-table",{mode:y.SingleSelectMaster,showNoData:false,showSeparators:this.getProperty("separateSuggestions")?z.Inner:z.None,width:"100%",enableBusyIndicator:false,rememberSelections:false,itemPress:function(F){if(D.system.desktop){this.focus();}var H=F.getParameter("listItem");this.setSelectionRow(H,true);}.bind(this),sticky:[l.Sticky.ColumnHeaders]});E.addEventDelegate({onAfterRendering:function(){var F;if(!this.getEnableSuggestionsHighlighting()){return;}F=E.$().find('tbody .sapMLabel');m(F,this._getTypedInValue());}},this);if(this.isMobileDevice()){E.addStyleClass("sapMInputSuggestionTableHidden");}E.updateItems=function(){T.prototype.updateItems.apply(this,arguments);this._refreshItemsDelayed();return this;};i=new r(function(F){var H=F.mutation;var J=F.child;var N=F.name==="items";switch(H){case"insert":if(N){J.setType(u.Active);this._createSuggestionPopupContent(true);this._synchronizeSuggestions();}break;case"remove":if(N){this._synchronizeSuggestions();}break;default:break;}}.bind(this));i.observe(E,{aggregations:["items","columns"]});return E;};
A.prototype.clone=function(){var i=I.prototype.clone.apply(this,arguments);i.setRowResultFunction(this._fnRowResultFilter);i.setValue(this.getValue());return i;};
A.prototype.setValue=function(V){this._iSetCount++;I.prototype.setValue.call(this,V);this._onValueUpdated(V);this._setTypedInValue("");this.setProperty("effectiveShowClearIcon",!!V);return this;};
A.prototype.setDOMValue=function(i){this._$input.val(i);};
A.prototype.getDOMValue=function(){return this._$input.val();};
A.prototype._getInputValue=function(){var V=I.prototype._getInputValue.apply(this,arguments);if(this.getMaxLength()>0){V=V.substring(0,this.getMaxLength());}return V;};
A.prototype.setMaxLength=function(i){i=this.validateProperty("maxLength",i);this.setProperty("maxLength",i);this.updateDomValue(this.getProperty("value"));return this;};
A.prototype.updateInputField=function(N){if(this._isSuggestionsPopoverOpen()&&this.isMobileDevice()){this._getSuggestionsPopover().getInput().setValue(N)._doSelect();}else{N=this._getInputValue(N);this.setDOMValue(N);this.onChange(null,null,N);}};
A.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.description=((i.description||"")+" "+this.getDescription()).trim();return i;};
A.prototype.preventChangeOnFocusLeave=function(E){return this.bFocusoutDueRendering||this.bValueHelpRequested;};
A.prototype._getShowMoreButton=function(){return this._getSuggestionsPopover().getShowMoreButton();};
A.prototype._getShowMoreButtonPress=function(){var i,E=this._getTypedInValue();if(this.getShowTableSuggestionValueHelp()){if(E){i=E;this.updateDomValue(i);this._resetTypeAhead();this._setTypedInValue(i);}this._fireValueHelpRequest(true);this._closeSuggestionPopup();}};
A.prototype._addShowMoreButton=function(){var i=this._getSuggestionsPopover();var E=i&&i.getPopover();if(!E||!this._hasTabularSuggestions()||this._getShowMoreButton()){return;}var F=new B({text:this._oRb.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:this._getShowMoreButtonPress.bind(this)});if(E.isA("sap.m.Dialog")){i.setShowMoreButton(F);}else{i.setShowMoreButton(new e({content:[new f(),F]}));}};
A.prototype._removeShowMoreButton=function(){var i=this._getSuggestionsPopover();var E=i&&i.getPopover();if(E&&this._hasTabularSuggestions()&&this._getShowMoreButton()){i.removeShowMoreButton();}};
A.prototype._hasShowSelectedButton=function(){return false;};
A.prototype._createSuggestionPopupContent=function(i){var E=this._getSuggestionsPopover();var F=E.getItemsContainer();if(F&&((F.isA("sap.m.Table")&&!i)||(F.isA("sap.m.List")&&i))){F.destroy();F=null;this._destroySuggestionsTable();}if(this._bIsBeingDestroyed||!E||F){return;}E.initContent(this.getId(),i?this._getSuggestionsTable():null);if(!this._hasTabularSuggestions()&&!i){this._decorateSuggestionsPopoverList(E.getItemsContainer());}else{this._decorateSuggestionsPopoverTable();}};
A.prototype._decorateSuggestionsPopoverList=function(i){if(!i||!i.isA("sap.m.List")){return;}i.addEventDelegate({onAfterRendering:function(){var E,F;if(!this.getEnableSuggestionsHighlighting()){return;}E=i.$().find('.sapMSLIInfo, .sapMSLITitleOnly');F=this._bDoTypeAhead?this._getTypedInValue():this.getValue();F=(F||"").toLowerCase();m(E,F);}},this);i.attachItemPress(function(E){if(D.system.desktop){this.focus();}var F=E.getParameter("listItem");if(!F.isA("sap.m.GroupHeaderListItem")){this.setSelectionItem(o.getItemByListItem(this.getSuggestionItems(),F),true);}},this);};
A.prototype._decorateSuggestionsPopoverTable=function(){if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton();}};
A.prototype._decoratePopupInput=function(i){if(!i){return;}i.setValueLiveUpdate(true);i.setValueState(this.getValueState());i.setShowValueHelp(this.getShowValueHelp());i.attachValueHelpRequest(function(){this.fireValueHelpRequest({fromSuggestions:true});this._getSuggestionsPopover().iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}.bind(this));i.attachLiveChange(function(E){var V=E.getParameter("newValue");this.setDOMValue(this._getInputValue(this._getSuggestionsPopover().getInput().getValue()));this._triggerSuggest(V);this.fireLiveChange({value:V,newValue:V});}.bind(this));i._handleTypeAhead=function(){A.prototype._handleTypeAhead.call(i,this);}.bind(this);i._resetTypeAhead=function(){A.prototype._resetTypeAhead.call(i,this);}.bind(this);i.addEventDelegate({onsapenter:function(){this.setValue(this._sProposedItemText);}},this);return i;};
A.prototype.forwardEventHandlersToSuggPopover=function(i){i.setOkPressHandler(this._closeSuggestionPopup.bind(this));i.setCancelPressHandler(this._closeSuggestionPopup.bind(this));};
A.prototype._getSuggestionsPopover=function(){return this._oSuggPopover;};
A.prototype._createSuggestionsPopover=function(){var i=this._oSuggPopover=new d(this);i.decorateParent(this);i.setInputLabels(this.getLabels.bind(this));this._createSuggestionsPopoverPopup();this.forwardEventHandlersToSuggPopover(i);i.attachEvent(d.M_EVENTS.SELECTION_CHANGE,function(E){var F=E.getParameter("newItem"),N=this.calculateNewValue(F),H=F&&F.isA("sap.m.GroupHeaderListItem"),J=this.getFocusDomRef(),O=J&&J.value.substring(0,J.selectionStart),U=E.getParameter("previousItem"),V=U&&U.isA("sap.m.GroupHeaderListItem"),W=p(s(J,V),N,O,V);if(!F||H){this.setDOMValue(O);}else{this.setDOMValue(N);W=(W===0&&N.indexOf(O)===0)?O.length:W;this._doSelect(W);}this._sSelectedSuggViaKeyboard=N;},this);if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton();}return this._oSuggPopover;};
A.prototype.calculateNewValue=function(i){if(!i||(i&&i.isA("sap.m.GroupHeaderListItem"))){return"";}if(i.isA("sap.m.ColumnListItem")){return this._getInputValue(this._getRowResultFunction()(i));}if(i.isA("sap.m.StandardListItem")){return this._getInputValue(i.getTitle());}};
A.prototype._createSuggestionsPopoverPopup=function(){var i=this._getSuggestionsPopover();var E;i.createSuggestionPopup(this,{showSelectedButton:this._hasShowSelectedButton()});this._decoratePopupInput(i.getInput());E=i.getPopover();E.attachBeforeOpen(function(){this._updateSuggestionsPopoverValueState();},this);E.attachBeforeClose(function(){this._updateSuggestionsPopoverValueState();},this);if(this.isMobileDevice()){E.attachBeforeClose(function(){this.setDOMValue(this._getInputValue(i.getInput().getValue()));this.onChange();},this).attachAfterClose(function(){var F=i.getItemsContainer();if(!F){return;}if(T&&!(F instanceof T)){F.destroyItems();}else{F.removeSelections(true);}}).attachAfterOpen(function(){this._triggerSuggest(this.getValue());this._refreshListItems();},this).attachBeforeOpen(function(){var F=i.getInput();["placeholder","maxLength","value","showClearIcon","effectiveShowClearIcon"].forEach(function(H){F.setProperty(H,this.getProperty(H));},this);},this);}else{E.attachAfterClose(function(){var F=this._getSuggestionsPopover().getItemsContainer();var H=F&&F.getSelectedItem();var J=this.getDomRef();if(this.getSelectionUpdatedFromList()){this.updateSelectionFromList(H);}if(!F){return;}this._bAfterOpenFinisihed=false;if(F instanceof T){H&&H.removeStyleClass("sapMLIBFocused");F.removeSelections(true);}else{F.destroyItems();}this._deregisterPopupResize();if(J&&J.contains(document.activeElement)){this.addStyleClass("sapMFocus");}},this).attachBeforeOpen(function(){i._sPopoverContentWidth=this.getMaxSuggestionWidth();i.resizePopup(this);this._registerPopupResize();this._bAfterOpenFinisihed=false;},this).attachAfterOpen(function(){this._bAfterOpenFinisihed=true;},this);}this.setAggregation("_suggestionPopup",E);this._oSuggestionPopup=E;};
A.prototype._registerPopupResize=function(){var i=this._getSuggestionsPopover();this._sPopupResizeHandler=R.register(this,i.resizePopup.bind(i,this));};
A.prototype._deregisterPopupResize=function(){if(this._sPopupResizeHandler){this._sPopupResizeHandler=R.deregister(this._sPopupResizeHandler);}};
A.prototype.showItems=function(F){var i,E,H=this._getFilterFunction();if(!this.getEnabled()||!this.getEditable()||this.getValueHelpOnly()){return;}this.setFilterFunction(F||function(){return true;});this._clearSuggestionPopupItems();i=this._getFilteredSuggestionItems(this.getDOMValue());E=i.items.length;if(E>0){this._openSuggestionPopup();}else{this._hideSuggestionPopup();}this._applySuggestionAcc(E);this.setFilterFunction(H);};
A.prototype.shouldValueStateMessageBeOpened=function(){var i=I.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);if(!i||this._isSuggestionsPopoverOpen()){return false;}return true;};
A.prototype._isSuggestionsPopoverOpen=function(){return this._getSuggestionsPopover()&&this._getSuggestionsPopover().isOpen();};
A.prototype.isMobileDevice=function(){return D.system.phone;};
A.prototype._openSuggestionsPopover=function(){this.closeValueStateMessage();this._updateSuggestionsPopoverValueState();this._getSuggestionsPopover().getPopover().open();};
A.prototype._updateSuggestionsPopoverValueState=function(){var i=this._getSuggestionsPopover(),V=this.getValueState(),N=this.getValueState()!==i._getValueStateHeader().getValueState(),E=this.getFormattedValueStateText(),F=this.getValueStateText();if(!i){return;}if(this._isSuggestionsPopoverOpen()&&!E&&!N){this.setFormattedValueStateText(i._getValueStateHeader().getFormattedText());}i.updateValueState(V,(E||F),this.getShowValueStateMessage());if(this.isMobileDevice()){i.getInput().setValueState(V);}};
A.prototype.setShowValueHelp=function(i){var E=this._getSuggestionsPopover()&&this._getSuggestionsPopover().getInput();this.setProperty("showValueHelp",i);if(E){E.setShowValueHelp(i);}return this;};
A.prototype.isValueHelpOnlyOpener=function(i){return true;};
A.prototype._getFilteredSuggestionItems=function(V){var F,i=this._getSuggestionsPopover().getItemsContainer();if(this._hasTabularSuggestions()){if(this.isMobileDevice()&&i){i.removeStyleClass("sapMInputSuggestionTableHidden");}F=this.filterTabularItems(this.getSuggestionRows(),V);}else{F=n(this,this.getSuggestionItems(),V,this.getFilterSuggests(),true,this._getFilterFunction());this._mapItems(F);}return F;};
A.prototype.filterTabularItems=function(i,V){var E,F=this.getFilterSuggests(),H=[],J=[],N=false,O=this._getFilterFunction();i.forEach(function(U){if(U.isA("sap.m.GroupHeaderListItem")){J.push({header:U,visible:false});}else{E=!F||O(V,U);U.setVisible(E);E&&H.push(U);if(!N&&E&&this._sProposedItemText===this._getRowResultFunction()(U)){U.setSelected(true);N=true;}if(J.length&&E){J[J.length-1].visible=true;}}},this);J.forEach(function(U){U.header.setVisible(U.visible);});this._getSuggestionsTable().invalidate();return{items:H,groups:J};};
A.prototype._mapItems=function(F){var i=this.getSuggestionItems(),E=F.items,H=F.groups,J=H.map(function(W){return W.header;}),N=false,O=this._getSuggestionsPopover().getItemsContainer(),U,V;i.filter(function(W){return(E.indexOf(W)>-1)||(J.indexOf(W)>-1);}).map(function(W){U=o.createListItemFromCoreItem(W,true);O.addItem(U);if(!N&&this._sProposedItemText===W.getText()){U.setSelected(true);N=true;}return W;},this).filter(function(W){return J.indexOf(W)>-1;}).forEach(function(W){V=J.indexOf(W);if(V>-1){U=o.getListItem(W);U&&U.setVisible(H[V].visible);}});};
A.prototype._setTypedInValue=function(V){this._sTypedInValue=V;return this;};
A.prototype._getTypedInValue=function(){return this._sTypedInValue;};
A.prototype._setSeparateSuggestions=function(V){var i=this._getSuggestionsTable();this.setProperty("separateSuggestions",V);if(i){i.setShowSeparators(V?z.Inner:z.None);}return this;};
return A;});
sap.ui.predefine('sap/m/InputBase',['./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','./delegate/ValueStateMessage','sap/ui/core/message/MessageMixin','sap/ui/core/InvisibleMessage','sap/ui/core/library','sap/ui/Device','./InputBaseRenderer','sap/base/Log',"sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/getSelectedText","sap/ui/dom/jquery/selectText"],function(l,C,E,I,V,M,a,c,D,b,d,K,q){"use strict";var T=c.TextDirection;var f=c.TextAlign;var g=c.ValueState;
var h=C.extend("sap.m.InputBase",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:g.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:f.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},required:{type:"boolean",group:"Misc",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{change:{parameters:{value:{type:"string"}}}},aggregations:{formattedValueStateText:{type:"sap.m.FormattedText",multiple:false,defaultValue:null},_invisibleFormattedValueStateText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden",defaultValue:null},_endIcon:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_beginIcon:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"}},designtime:"sap/m/designtime/InputBase.designtime"}});
E.call(h.prototype);I.insertFontFaceStyle();M.call(h.prototype);h.ICON_PRESSED_CSS_CLASS="sapMInputBaseIconPressed";h.ICON_CSS_CLASS="sapMInputBaseIcon";h.prototype.bShowLabelAsPlaceholder=!D.support.input.placeholder;
h.prototype._getPlaceholder=function(){return this.getPlaceholder()||"";};
h.prototype._getInputValue=function(v){return(v===undefined)?(this.$("inner").val()||""):v.toString();};
h.prototype._getInputElementTagName=function(){if(!this._sInputTagElementName){this._sInputTagElementName=this._$input&&this._$input.get(0)&&this._$input.get(0).tagName;}return this._sInputTagElementName;};
h.prototype.init=function(){this.setLastValue("");this.bRenderingPhase=false;this._oValueStateMessage=new V(this);this._bIsComposingCharacter=false;this.setLastValueStateText("");this.setErrorMessageAnnouncementState(false);this.fnCloseValueStateOnClick=function(){this.closeValueStateMessage();};};
h.prototype.oncompositionstart=function(){this._bIsComposingCharacter=true;};
h.prototype.oncompositionend=function(e){this._bIsComposingCharacter=false;if(!D.browser.firefox){this._bCheckDomValue=true;}};
h.prototype.isComposingCharacter=function(){return this._bIsComposingCharacter;};
h.prototype.onBeforeRendering=function(){var F=this.getFocusDomRef();var o=this.getFormattedValueStateText();var e;if(!this._oInvisibleMessage){this._oInvisibleMessage=a.getInstance();}if(this._bCheckDomValue&&!this.bRenderingPhase){if(this.isActive()){this._sDomValue=this._getInputValue();}else{this._bCheckDomValue=false;}}if(!o){e=false;}else{var i=this.getAggregation("_invisibleFormattedValueStateText");e=o.getHtmlText()!==(i&&i.getHtmlText());}if(this.getValueState()===g.Error&&F){var v=e||this.getValueStateText()!==this.getLastValueStateText();this.setErrorMessageAnnouncementState(!F.hasAttribute('aria-invalid')||v);}if(e){i&&i.destroy();this.setAggregation("_invisibleFormattedValueStateText",o.clone());}this.bRenderingPhase=true;};
h.prototype.onAfterRendering=function(){var v=this.getValueState();var i=this.getFocusDomRef()===document.activeElement;var e=v===g.None;var s=document.getElementById(this.getValueStateMessageId()+'-sr');if(this._bCheckDomValue&&this._sDomValue!==this._getInputValue()){this.$("inner").val(this._sDomValue);}if(this.getErrorMessageAnnouncementState()&&this.hasStyleClass("sapMFocus")){s&&this._oInvisibleMessage.announce(s.textContent);this.setErrorMessageAnnouncementState(false);}this.$("message").text(this.getValueStateText());this._bCheckDomValue=false;this.bRenderingPhase=false;if(i){this[e?"closeValueStateMessage":"openValueStateMessage"]();}if(this.getAggregation("_invisibleFormattedValueStateText")){this.getAggregation("_invisibleFormattedValueStateText").getControls().forEach(function(o){o.getDomRef()&&o.getDomRef().setAttribute("tabindex",-1);});}this.setLastValueStateText(this.getValueStateText());};
h.prototype.exit=function(){if(this._oValueStateMessage){this._oValueStateMessage.destroy();}if(this.oInvisibleMessage){this.oInvisibleMessage.destroy();this.oInvisibleMessage=null;}this._oValueStateMessage=null;};
h.prototype.ontouchstart=function(e){e.setMarked();};
h.prototype.onfocusin=function(e){this.addStyleClass("sapMFocus");this.openValueStateMessage();};
h.prototype.onfocusout=function(e){this.removeStyleClass("sapMFocus");if(!this._bClickOnValueStateLink(e)){this.closeValueStateMessage();}};
h.prototype.onsapfocusleave=function(e){if(!this.preventChangeOnFocusLeave(e)){this.onChange(e);}};
h.prototype.preventChangeOnFocusLeave=function(e){return this.bFocusoutDueRendering;};
h.prototype.getChangeEventParams=function(){return{};};
h.prototype.ontap=function(e){return;};
h.prototype.onChange=function(e,p,n){p=p||this.getChangeEventParams();if(this.getDomRef()&&(!this.getEditable()||!this.getEnabled())){return;}var v=this._getInputValue(n);if(v!==this.getLastValue()){this.setValue(v);v=this.getValue();this.setLastValue(v);this.fireChangeEvent(v,p);return true;}else{this._bCheckDomValue=false;}};
h.prototype.fireChangeEvent=function(v,p){var o=q.extend({value:v,newValue:v},p);this.fireChange(o);};
h.prototype.onValueRevertedByEscape=function(v,p){this.fireEvent("liveChange",{value:v,escPressed:true,previousValue:p,newValue:v});};
h.prototype.onsapenter=function(e){if(D.browser.safari&&this.isComposingCharacter()){e.setMarked("invalid");return;}this.onChange(e);};
h.prototype.onsapescape=function(e){var v=this._getInputValue();if(v!==this.getLastValue()){e.setMarked();e.preventDefault();this.updateDomValue(this.getLastValue());this.onValueRevertedByEscape(this.getLastValue(),v);}};
h.prototype.oninput=function(e){this._bCheckDomValue=true;};
h.prototype.onkeydown=function(e){if(this.getDomRef("inner")&&this.getDomRef("inner").getAttribute("readonly")&&e.keyCode==K.BACKSPACE){e.preventDefault();}};
h.prototype.oncut=function(e){};
h.prototype.selectText=function(s,S){this.$("inner").selectText(s,S);return this;};
h.prototype.getSelectedText=function(){return this.$("inner").getSelectedText();};
h.prototype.setProperty=function(p,v,s){if(p=="value"){this._bCheckDomValue=false;}return C.prototype.setProperty.apply(this,arguments);};
h.prototype.getFocusInfo=function(){var F=C.prototype.getFocusInfo.call(this),o=this.getFocusDomRef();q.extend(F,{cursorPos:0,selectionStart:0,selectionEnd:0});if(o){F.cursorPos=q(o).cursorPos();try{F.selectionStart=o.selectionStart;F.selectionEnd=o.selectionEnd;}catch(e){}}return F;};
h.prototype.applyFocusInfo=function(F){C.prototype.applyFocusInfo.call(this,F);this.$("inner").cursorPos(F.cursorPos);this.selectText(F.selectionStart,F.selectionEnd);return this;};
h.prototype.updateDomValue=function(v){var i=this.getFocusDomRef();if(!this.isActive()){return this;}v=this._getInputValue(v);this._bCheckDomValue=true;if(this._bPreferUserInteraction){this.handleInputValueConcurrency(v);}else{i.value=v;}return this;};
h.prototype._aValueStateLinks=function(){if(this.getFormattedValueStateText()&&this.getFormattedValueStateText().getHtmlText()&&this.getFormattedValueStateText().getControls().length){return this.getFormattedValueStateText().getControls();}else{return[];}};
h.prototype._bClickOnValueStateLink=function(e){var v=this._aValueStateLinks();return v.some(function(L){return e.relatedTarget===L.getDomRef();});};
h.prototype._attachValueStateLinkPress=function(){this._aValueStateLinks().forEach(function(L){L.attachPress(this.fnCloseValueStateOnClick,this);},this);};
h.prototype._detachValueStateLinkPress=function(){this._aValueStateLinks().forEach(function(L){L.detachPress(this.fnCloseValueStateOnClick,this);},this);};
h.prototype.handleInputValueConcurrency=function(v){var i=this.getFocusDomRef(),s=i&&this._getInputValue(),e=this.getProperty("value"),j=document.activeElement===i,B=this.isBound("value")&&this.getBindingInfo("value").skipModelUpdate;if(j&&B&&s&&(e!==s)){return this;}i.value=v;if(j&&B&&!s){i.select();}};
h.prototype._setPreferUserInteraction=function(p){this._bPreferUserInteraction=p;};
h.prototype.closeValueStateMessage=function(){setTimeout(function(){if(this._oValueStateMessage){this._detachValueStateLinkPress();this._oValueStateMessage.close();}}.bind(this),0);};
h.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef("content");};
h.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};
h.prototype.iOpenMessagePopupDuration=0;
h.prototype.getValueStateMessageId=function(){return this.getId()+"-message";};
h.prototype.getErrorMessageAnnouncementState=function(){return this._bErrorStateShouldBeAnnounced;};
h.prototype.setErrorMessageAnnouncementState=function(A){this._bErrorStateShouldBeAnnounced=A;};
h.prototype.setLastValueStateText=function(v){this._sLastValueStateText=v;};
h.prototype.getLastValueStateText=function(){return this._sLastValueStateText;};
h.prototype.getLabels=function(){var L=this.getAriaLabelledBy().map(function(s){return sap.ui.getCore().byId(s);});var o=sap.ui.require("sap/ui/core/LabelEnablement");if(o){L=L.concat(o.getReferencingLabels(this).map(function(s){return sap.ui.getCore().byId(s);}));}return L;};
h.prototype.openValueStateMessage=function(){if(this._oValueStateMessage&&this.shouldValueStateMessageBeOpened()){setTimeout(function(){if(!this.bIsDestroyed){this._detachValueStateLinkPress();this._attachValueStateLinkPress();this._oValueStateMessage.open();}}.bind(this),0);}};
h.prototype.shouldValueStateMessageBeOpened=function(){return(this.getValueState()!==g.None)&&this.getEditable()&&this.getEnabled()&&this.getShowValueStateMessage();};
h.prototype._calculateIconsSpace=function(){var e=this.getAggregation("_endIcon")||[],B=this.getAggregation("_beginIcon")||[],i=e.concat(B),j,k;return i.reduce(function(A,o){j=o&&o.getDomRef()?parseFloat(getComputedStyle(o.getDomRef()).marginRight):0;k=o&&o.getDomRef()?o.getDomRef().offsetWidth:0;return A+k+j;},0);};
h.prototype.setValue=function(v){v=this.validateProperty("value",v);v=this._getInputValue(v);this.updateDomValue(v);if(v!==this.getProperty("value")){this.setLastValue(v);}this.setProperty("value",v,true);return this;};
h.prototype.getFocusDomRef=function(){return this.getDomRef("inner");};
h.prototype.getIdForLabel=function(){return this.getId()+"-inner";};
h.prototype.getAccessibilityInfo=function(){var r=this.getRequired()?'Required':'',R=this.getRenderer();return{role:R.getAriaRole(this),type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_INPUT"),description:[this.getValueDescriptionInfo(),R.getLabelledByAnnouncement(this),R.getDescribedByAnnouncement(this),r].join(" ").trim(),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()};};
h.prototype.getValueDescriptionInfo=function(){return this.getValue()||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("INPUTBASE_VALUE_EMPTY");};
h.prototype._addIcon=function(i,o,p){if(["begin","end"].indexOf(i)===-1){d.error('icon position is not "begin", neither "end", please check again the passed setting');return null;}var e=I.createControlByURI(o).addStyleClass(h.ICON_CSS_CLASS);if(p!==undefined){this.insertAggregation("_"+i+"Icon",e,p);}else{this.addAggregation("_"+i+"Icon",e);}return e;};
h.prototype.addBeginIcon=function(i){return this._addIcon("begin",i);};
h.prototype.addEndIcon=function(i,p){return this._addIcon("end",i,p);};
Object.defineProperty(h.prototype,"_$input",{get:function(){return this.$("inner");}});
h.prototype.setLastValue=function(v){this._lastValue=v;return this;};
h.prototype.getLastValue=function(){return this._lastValue;};
return h;});
sap.ui.predefine('sap/m/InputBaseRenderer',['sap/ui/core/Renderer','sap/ui/core/Core','sap/ui/core/library','sap/ui/core/ValueStateSupport','sap/ui/core/LabelEnablement','sap/ui/Device'],function(R,C,c,V,L,D){"use strict";var T=c.TextDirection;var a=c.ValueState;var I={apiVersion:2};
I.render=function(r,o){var v=o.getValueState(),t=o.getTextDirection(),s=R.getTextAlign(o.getTextAlign(),t),A=sap.ui.getCore().getConfiguration().getAccessibility(),b=o.getAggregation("_beginIcon")||[],e=o.getAggregation("_endIcon")||[],d,f;r.openStart("div",o);this.addOuterStyles(r,o);this.addControlWidth(r,o);r.class("sapMInputBase");this.addPaddingClass(r,o);this.addCursorClass(r,o);this.addOuterClasses(r,o);if(!o.getEnabled()){r.class("sapMInputBaseDisabled");}if(!o.getEditable()){r.class("sapMInputBaseReadonly");}if(v!==a.None&&o.getEditable()&&o.getEnabled()){r.class("sapMInputBaseState");}if(b.length){d=b.filter(function(i){return i.getVisible();});d.length&&r.class("sapMInputBaseHasBeginIcons");}if(e.length){f=e.filter(function(i){return i.getVisible();});f.length&&r.class("sapMInputBaseHasEndIcons");}this.writeOuterAttributes(r,o);var g=o.getTooltip_AsString();if(g){r.attr("title",g);}r.openEnd();r.openStart("div",o.getId()+"-content");r.class("sapMInputBaseContentWrapper");if(!o.getEnabled()){r.class("sapMInputBaseDisabledWrapper");}else if(!o.getEditable()){r.class("sapMInputBaseReadonlyWrapper");}if(v!==a.None&&o.getEditable()&&o.getEnabled()){this.addValueStateClasses(r,o);}this.addWrapperStyles(r,o);r.openEnd();if(b.length){this.writeIcons(r,b);}this.prependInnerContent(r,o);this.openInputTag(r,o);if(o.getName()){r.attr("name",o.getName());}if(!o.bShowLabelAsPlaceholder&&o._getPlaceholder()){r.attr("placeholder",o._getPlaceholder());}if(o.getMaxLength&&o.getMaxLength()>0){r.attr("maxlength",o.getMaxLength());}if(!o.getEnabled()){r.attr("disabled","disabled");}else if(!o.getEditable()){r.attr("readonly","readonly");}if(t!=T.Inherit){r.attr("dir",t.toLowerCase());}this.writeInnerValue(r,o);if(A){this.writeAccessibilityState(r,o);}if(D.browser.mozilla){if(g){r.attr("x-moz-errormessage",g);}else{r.attr("x-moz-errormessage"," ");}}this.writeInnerAttributes(r,o);r.class("sapMInputBaseInner");this.addInnerClasses(r,o);r.style("text-align",s);this.addInnerStyles(r,o);this.endInputTag(r,o);this.writeInnerContent(r,o);this.closeInputTag(r,o);if(e.length){this.writeIcons(r,e);}r.close("div");this.writeDecorations(r,o);if(A){this.renderAriaLabelledBy(r,o);this.renderAriaDescribedBy(r,o);this.renderValueStateAccDom(r,o);}r.close("div");};
I.getAriaRole=function(o){return"textbox";};
I.getAriaLabelledBy=function(o){if(this.getLabelledByAnnouncement(o)){return o.getId()+"-labelledby";}};
I.getLabelledByAnnouncement=function(o){return"";};
I.renderAriaLabelledBy=function(r,o){var A=this.getLabelledByAnnouncement(o);if(A){r.openStart("span",o.getId()+"-labelledby").attr("aria-hidden","true").class("sapUiInvisibleText").openEnd().text(A.trim()).close("span");}};
I.getAriaDescribedBy=function(o){if(this.getDescribedByAnnouncement(o)){return o.getId()+"-describedby";}};
I.getDescribedByAnnouncement=function(o){return"";};
I.renderAriaDescribedBy=function(r,o){var A=this.getDescribedByAnnouncement(o);if(A){r.openStart("span",o.getId()+"-describedby").attr("aria-hidden","true").class("sapUiInvisibleText").openEnd().text(A.trim()).close("span");}};
I.renderValueStateAccDom=function(r,o){var v=o.getValueState();if(v===a.None||!o.getEditable()||!o.getEnabled()){return;}var f=o.getAggregation("_invisibleFormattedValueStateText");var s;s=C.getLibraryResourceBundle("sap.m").getText("INPUTBASE_VALUE_STATE_"+v.toUpperCase());r.openStart("div",o.getValueStateMessageId()+"-sr").class("sapUiPseudoInvisibleText");r.openEnd().text(s).text(" ");if(f){r.renderControl(f);}else{r.text(o.getValueStateText()||V.getAdditionalText(o));}r.close("div");};
I.getAccessibilityState=function(o){var A=this.getAriaLabelledBy(o),s=this.getAriaDescribedBy(o),r=this.getAriaRole(o),v=o.getValueStateMessageId()+"-sr",m={};if(r){m.role=r;}if(o.getValueState()===a.Error&&o.getEditable()&&o.getEnabled()){m.invalid=true;m.errormessage=v;}else if(o.getValueState()!==a.None&&o.getEditable()&&o.getEnabled()){s=s?v+" "+s:v;}if(A){m.labelledby={value:A.trim(),append:true};}if(s){m.describedby={value:s.trim(),append:true};}m.disabled=null;m.readonly=null;return m;};
I.writeAccessibilityState=function(r,o){r.accessibilityState(o,this.getAccessibilityState(o));};
I.openInputTag=function(r,o){r.voidStart("input",o.getId()+"-"+this.getInnerSuffix());};
I.endInputTag=function(r,o){r.voidEnd();};
I.writeInnerValue=function(r,o){r.attr("value",o.getValue());};
I.addCursorClass=function(r,o){};
I.addPaddingClass=function(r,o){r.class("sapMInputBaseHeightMargin");};
I.addOuterStyles=function(r,o){};
I.addControlWidth=function(r,o){if(!o.getProperty('width')){r.class("sapMInputBaseNoWidth");}r.style("width",o.getWidth());};
I.addOuterClasses=function(r,o){};
I.writeOuterAttributes=function(r,o){};
I.addInnerStyles=function(r,o){};
I.addWrapperStyles=function(r,o){r.style("width","100%");};
I.addInnerClasses=function(r,o){};
I.writeInnerAttributes=function(r,o){};
I.prependInnerContent=function(r,o){};
I.writeInnerContent=function(r,o){};
I.writeIcons=function(r,i){r.openStart("div").attr("tabindex","-1").class("sapMInputBaseIconContainer").openEnd();i.forEach(r.renderControl,r);r.close("div");};
I.writeDecorations=function(r,o){};
I.closeInputTag=function(r,o){};
I.addPlaceholderStyles=function(r,o){};
I.addPlaceholderClasses=function(r,o){};
I.addValueStateClasses=function(r,o){r.class("sapMInputBaseContentWrapperState");r.class("sapMInputBaseContentWrapper"+o.getValueState());};
I.getInnerSuffix=function(){return"inner";};
return I;},true);
sap.ui.predefine('sap/m/InputListItem',["sap/ui/core/library","./library","./ListItemBase","./InputListItemRenderer"],function(c,l,L,I){"use strict";var T=c.TextDirection;
var a=L.extend("sap.m.InputListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},labelTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}},designtime:"sap/m/designtime/InputListItem.designtime"}});
a.prototype.getContentAnnouncement=function(){var A=this.getLabel()+" . ";this.getContent().forEach(function(C){A+=L.getAccessibilityText(C)+" ";});return A.trim();};
return a;});
sap.ui.predefine('sap/m/InputListItemRenderer',["sap/ui/core/library","sap/ui/core/Renderer","./ListItemBaseRenderer"],function(c,R,L){"use strict";var T=c.TextDirection;var I=R.extend(L);I.apiVersion=2;
I.renderLIAttributes=function(r,l){r.class("sapMILI");};
I.renderLIContent=function(r,l){var s=l.getLabel();var i=l.getId()+"-label";if(s){r.openStart("span",i);r.class("sapMILILabel");var a=l.getLabelTextDirection();if(a!==T.Inherit){r.attr("dir",a.toLowerCase());}r.openEnd();r.text(s);r.close("span");}r.openStart("div").class("sapMILIDiv").class("sapMILI-CTX").openEnd();l.getContent().forEach(function(C){if(C.addAriaLabelledBy&&C.getAriaLabelledBy().indexOf(i)===-1){C.addAriaLabelledBy(i);}r.renderControl(C);});r.close("div");};
return I;},true);
sap.ui.predefine('sap/m/InputRenderer',['sap/ui/core/InvisibleText','sap/ui/core/Renderer','./InputBaseRenderer','sap/m/library'],function(I,R,a,l){"use strict";var b=l.InputType;var c=R.extend(a);c.apiVersion=2;
c.addOuterClasses=function(r,C){r.class("sapMInput");if(C.getDescription()){r.class("sapMInputWithDescription");}};
c.writeInnerAttributes=function(r,C){var s=C.getShowSuggestion();r.attr("type",C.getType().toLowerCase());if(C.getType()==b.Number){r.attr("step","any");}if(C.getType()==b.Number&&sap.ui.getCore().getConfiguration().getRTL()){r.attr("dir","ltr").style("text-align","right");}if(s||C.getShowValueStateMessage()){r.attr("autocomplete","off");}if((!C.getEnabled()&&C.getType()=="Password")||(C.getShowSuggestion()&&C.isMobileDevice())||(C.getValueHelpOnly()&&C.getEnabled()&&C.getEditable()&&C.getShowValueHelp())){r.attr("readonly","readonly");}};
c.addInnerClasses=function(r,C){};
c.writeDescription=function(r,C){r.openStart("div").class("sapMInputDescriptionWrapper").style("width","calc(100% - "+C.getFieldWidth()+")").openEnd();r.openStart("span",C.getId()+"-descr").class("sapMInputDescriptionText").openEnd().text(C.getDescription()).close("span");r.close("div");};
c.writeDecorations=function(r,C){if(C.getDescription()){this.writeDescription(r,C);}if(sap.ui.getCore().getConfiguration().getAccessibility()){if(C.getShowSuggestion()&&C.getEnabled()&&C.getEditable()){r.openStart("span",C.getId()+"-SuggDescr").class("sapUiPseudoInvisibleText").attr("role","status").attr("aria-live","polite").openEnd().close("span");}}};
c.addWrapperStyles=function(r,C){r.style("width",C.getDescription()?C.getFieldWidth():"100%");};
c.getAriaDescribedBy=function(C){var A=a.getAriaDescribedBy.apply(this,arguments);function d(s){A=A?A+" "+s:s;}if(C.getDescription()){d(C.getId()+"-descr");}if(C.getShowValueHelp()&&C.getEnabled()&&C.getEditable()){d(I.getStaticId("sap.m","INPUT_VALUEHELP"));if(C.getValueHelpOnly()){d(I.getStaticId("sap.m","INPUT_DISABLED"));}}return A;};
c.getAriaRole=function(C){return"";};
c.getAccessibilityState=function(C){var s=C.getShowSuggestion();var A=a.getAccessibilityState.apply(this,arguments);if(s){A["haspopup"]="listbox";}return A;};
return c;},true);
sap.ui.predefine('sap/m/InstanceManager',["sap/base/assert","sap/base/Log","sap/ui/thirdparty/jquery"],function(a,L,q){"use strict";var I={};var r={},e=[];var p="_POPOVER_",d="_DIALOG_",l="_LIGHTBOX_";
I.addInstance=function(c,i){a(c,"In sap.m.InstanceManager.addInstance method, the parameter sCategoryId can't be null or empty string");a(i instanceof Object,"In sap.m.InstanceManager.addInstance method, the parameter oInstance should be an object");if(!r[c]){r[c]=[];}if(r[c].indexOf(i)===-1){r[c].push(i);}return this;};
I.removeInstance=function(c,o){var C=r[c],i;a(c,"In sap.m.InstanceManager.removeInstance method, the parameter sCategoryId can't be null or empty string");a(o instanceof Object,"In sap.m.InstanceManager.removeInstance method, the parameter oInstance should be an object");if(!C){return null;}i=C.indexOf(o);return(i===-1)?null:C.splice(i,1);};
I.getInstancesByCategoryId=function(c){a(c,"In sap.m.InstanceManager.getInstancesByCategoryId method, the parameter sCategoryId can't be null or empty string");return r[c]||e;};
I.isInstanceManaged=function(c,i){a(c,"In sap.m.InstanceManager.isInstanceManaged method, the parameter sCategoryId can't be null or empty string");a(i instanceof Object,"In sap.m.InstanceManager.isInstanceManaged method, the parameter oInstance should be an object");var C=r[c];if(!C||!i){return false;}return C.indexOf(i)!==-1;};
I.isCategoryEmpty=function(c){a(c,"In sap.m.InstanceManager.isCategoryEmpty method, the parameter sCategoryId can't be null or empty string");var C=r[c];return!C||C.length===0;};
I.addPopoverInstance=function(P){if(typeof P.close==="function"){I.addInstance(p,P);}else{L.warning("In method addPopoverInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.addDialogInstance=function(D){if(typeof D.close==="function"){I.addInstance(d,D);}else{L.warning("In method addDialogInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.addLightBoxInstance=function(o){if(typeof o.close==="function"){I.addInstance(l,o);}else{L.warning("In method addLightBoxInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.removePopoverInstance=function(P){return I.removeInstance(p,P);};
I.removeDialogInstance=function(D){return I.removeInstance(d,D);};
I.removeLightBoxInstance=function(o){return I.removeInstance(l,o);};
I.hasOpenPopover=function(){return!I.isCategoryEmpty(p);};
I.hasOpenDialog=function(){return!I.isCategoryEmpty(d);};
I.hasOpenLightBox=function(){return!I.isCategoryEmpty(l);};
I.isDialogOpen=function(D){return I.isInstanceManaged(d,D);};
I.isPopoverOpen=function(P){return I.isInstanceManaged(p,P);};
I.isLightBoxOpen=function(o){return I.isInstanceManaged(l,o);};
I.getOpenPopovers=function(){return I.getInstancesByCategoryId(p);};
I.getOpenDialogs=function(){return I.getInstancesByCategoryId(d);};
I.getOpenLightBoxes=function(){return I.getInstancesByCategoryId(l);};
I.closeAllPopovers=function(){var b=I.getOpenPopovers(),i;for(i=0;i<b.length;i++){b[i].close();}return this;};
I.closeAllDialogs=function(c){var D,b=[],f=I.getOpenDialogs(),g,i;for(i=0;i<f.length;i++){g=f[i];if(!g.getCloseOnNavigation()){continue;}if(c){D=new q.Deferred().done();b.push(D);g.attachEvent("afterClose",(function(h){return function(){h.resolve();};}(D)));}g.close();}if(c){q.when.apply(this,b).then(c);}return this;};
I.closeAllLightBoxes=function(){var i=I.getOpenLightBoxes(),b=i.length,c;for(c=0;c<b;c+=1){i[c].close();}return this;};
return I;},true);
sap.ui.predefine('sap/m/Label',['./library','sap/ui/core/Control','sap/ui/core/LabelEnablement','sap/m/HyphenationSupport','sap/ui/core/library','./LabelRenderer'],function(l,C,L,H,c,a){"use strict";var T=c.TextDirection;var b=c.TextAlign;var d=l.LabelDesign;var V=c.VerticalAlign;var W=l.WrappingType;
var e=C.extend("sap.m.Label",{metadata:{interfaces:["sap.ui.core.Label","sap.ui.core.IShrinkable","sap.m.IOverflowToolbarContent","sap.m.IHyphenation"],library:"sap.m",properties:{design:{type:"sap.m.LabelDesign",group:"Appearance",defaultValue:d.Standard},text:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:b.Begin},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},required:{type:"boolean",group:"Misc",defaultValue:false},displayOnly:{type:"boolean",group:"Appearance",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:W.Normal},vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:V.Inherit},showColon:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{labelFor:{type:"sap.ui.core.Control",multiple:false}},designtime:"sap/m/designtime/Label.designtime"}});
e.prototype.getAccessibilityInfo=function(){var D=this.getText();if(this.isRequired()){D+=" *";}return{description:D};};
e.prototype.getOverflowToolbarConfig=function(){var o={canOverflow:true,propsUnrelatedToSize:["design","required","displayOnly"]};function g(f){var h=f&&f.getLayoutData();if(i(h,"sap/m/OverflowToolbarLayoutData")){return h.getGroup();}}o.onBeforeEnterOverflow=function(f){var I=false,t,s,h,j,k;t=f.getParent();if(!i(t,"sap/m/OverflowToolbar")){return;}s=f.getLabelFor();h=s&&sap.ui.getCore().byId(s);if(!h||(t.indexOfContent(h)<0)){return;}j=g(f);k=g(h);I=j&&(j===k);f.toggleStyleClass("sapMLabelMediumMarginTop",I,true);};o.onAfterExitOverflow=function(f){f.toggleStyleClass("sapMLabelMediumMarginTop",false,true);};return o;};
e.prototype.getTextsToBeHyphenated=function(){return{"main":this.getText()};};
e.prototype.getDomRefsForHyphenatedTexts=function(){return{"main":this.$("bdi")[0]};};
L.enrich(e.prototype);H.mixInto(e.prototype);
function i(o,m){if(o&&m){var f=sap.ui.require(m);return(typeof f==='function')&&(o instanceof f);}}
return e;});
sap.ui.predefine('sap/m/LabelRenderer',['sap/ui/core/Core','sap/ui/core/Renderer','sap/m/library','sap/ui/core/library','sap/m/HyphenationSupport',"sap/ui/core/LabelEnablement"],function(C,R,l,c,H,L){"use strict";var T=c.TextDirection;var V=c.VerticalAlign;var a=l.LabelDesign;var b={apiVersion:2};
b.render=function(d,o){var r=b,t=o.getTextDirection(),s=o.getTextAlign(),w=o.getWidth(),e=o.getText(),f=o.getTooltip_AsString(),g=o.getLabelForRendering(),h=g?"label":"span",D=o.isDisplayOnly(),v=o.getVAlign();d.openStart(h,o);d.class("sapMLabel");d.class("sapUiSelectable");if(o.isWrapping()){d.class("sapMLabelWrapped");}if(o.getDesign()==a.Bold){d.style("font-weight","bold");}if(o.isRequired()){d.class("sapMLabelRequired");}if(o.getShowColon()){d.class("sapMLabelShowColon");}if(g){L.writeLabelForAttribute(d,o);d.accessibilityState({label:o.getText()});}else if(o.getParent()instanceof sap.m.Toolbar){d.class("sapMLabelTBHeader");}if(t!==T.Inherit){d.attr("dir",t.toLowerCase());}if(w){d.style("width",w);}else{d.class("sapMLabelMaxWidth");}if(s){s=r.getTextAlign(s,t);if(s){d.style("text-align",s);}}if(e==""){d.class("sapMLabelNoText");}if(D){d.class("sapMLabelDisplayOnly");}if(v!=V.Inherit){d.style("vertical-align",v.toLowerCase());}H.writeHyphenationClass(d,o);if(f){d.attr("title",f);}d.openEnd();d.openStart("span",o.getId()+"-text");d.class("sapMLabelTextWrapper");d.openEnd();d.openStart("bdi",o.getId()+"-bdi");if(t!==T.Inherit){d.attr("dir",t.toLowerCase());}d.openEnd();if(e){e=H.getTextForRender(o,"main");d.text(e);}d.close("bdi");d.close("span");d.openStart("span");d.class("sapMLabelColonAndRequired");d.attr("data-colon",C.getLibraryResourceBundle("sap.m").getText("LABEL_COLON"));d.openEnd();d.close("span");d.close(h);};
b.getTextAlign=R.getTextAlign;return b;},true);
sap.ui.predefine('sap/m/LightBox',["./library","sap/ui/core/Control","sap/ui/core/Popup","sap/ui/core/Core","sap/m/Text","sap/m/Button","sap/ui/core/ResizeHandler","sap/ui/Device","sap/ui/core/Icon","sap/ui/layout/VerticalLayout","./InstanceManager","sap/ui/core/InvisibleText","sap/ui/core/library","./LightBoxRenderer","sap/m/BusyIndicator","sap/ui/thirdparty/jquery","sap/ui/dom/units/Rem"],function(l,C,P,a,T,B,R,D,I,V,b,c,d,L,e,q,f){"use strict";var g=l.ButtonType;var h=l.LightBoxLoadingStates;var O=d.OpenState;var i=d.TextAlign;
var j=C.extend("sap.m.LightBox",{metadata:{library:"sap.m",interfaces:["sap.ui.core.PopupInterface"],aggregations:{imageContent:{type:"sap.m.LightBoxItem",multiple:true,bindable:"bindable"},_closeButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_verticalLayout:{type:"sap.ui.layout.VerticalLayout",multiple:false,visibility:"hidden"},_invisiblePopupText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_busy:{type:"sap.m.BusyIndicator",multiple:false,visibility:"hidden"}},defaultAggregation:"imageContent",events:{},designtime:"sap/m/designtime/LightBox.designtime"}});
j.prototype.init=function(){this._createPopup();this._iWidth=0;this._iHeight=0;this._isRendering=true;this._iResizeListenerId=null;this._$lightBox=null;this._oRB=a.getLibraryResourceBundle("sap.m");this.setAggregation("_invisiblePopupText",new c());};
j.prototype.onBeforeRendering=function(){var o=this._getImageContent(),n=o._getNativeImage(),s=o.getImageSrc(),S=o._getImageState(),k=this._oRB.getText("LIGHTBOX_ARIA_ENLARGED",[o.getTitle(),o.getSubtitle()]),E=this._oRB.getText("LIGHTBOX_IMAGE_ERROR"),m=this._oRB.getText("LIGHTBOX_IMAGE_ERROR_DETAILS");this._createErrorControls();if(n.getAttribute("src")!==s){n.src=s;}if(this._iResizeListenerId){D.resize.detachHandler(this._fnResizeListener);R.deregister(this._iResizeListenerId);this._iResizeListenerId=null;}switch(S){case h.Loading:if(!this._iTimeoutId){this._iTimeoutId=setTimeout(function(){o._setImageState(h.TimeOutError);},10000);}break;case h.Loaded:clearTimeout(this._iTimeoutId);this._calculateSizes(n);break;case h.Error:clearTimeout(this._iTimeoutId);k+=" "+E+" "+m;break;default:break;}if(o){this.getAggregation("_invisiblePopupText").setText(k);}this._isRendering=true;};
j.prototype.onAfterRendering=function(){this._isRendering=false;this._$lightBox=this.$();if(!this._iResizeListenerId){this._fnResizeListener=this._onResize.bind(this);D.resize.attachHandler(this._fnResizeListener);this._iResizeListenerId=R.register(this,this._fnResizeListener);}};
j.prototype.forceInvalidate=C.prototype.invalidate;
j.prototype.invalidate=function(o){var k=this._getImageContent();if(this.isOpen()){if(k&&k.getImageSrc()){this.forceInvalidate(o);}else{this.close();}}return this;};
j.prototype.exit=function(){if(this._oPopup){this._oPopup.detachOpened(this._fnPopupOpened,this);this._oPopup.detachClosed(this._fnPopupClosed,this);this._oPopup.destroy();this._oPopup=null;}if(this._iResizeListenerId){D.resize.detachHandler(this._fnResizeListener);R.deregister(this._iResizeListenerId);this._iResizeListenerId=null;}b.removeLightBoxInstance(this);};
j.prototype.open=function(){var o=this._getImageContent();this._oPopup.setContent(this);if(o&&o.getImageSrc()){this._oPopup.open(300,"center center","center center",document.body,null);b.addLightBoxInstance(this);}return this;};
j.prototype.isOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){return true;}return false;};
j.prototype.close=function(){if(this._iResizeListenerId){D.resize.detachHandler(this._fnResizeListener);R.deregister(this._iResizeListenerId);this._iResizeListenerId=null;}this._oPopup.close();b.removeLightBoxInstance(this);return this;};
j.prototype._getCloseButton=function(){var o=this.getAggregation("_closeButton");if(!o){o=new B({id:this.getId()+"-closeButton",text:this._oRB.getText("LIGHTBOX_CLOSE_BUTTON"),type:g.Transparent,press:this.close.bind(this)});this.setAggregation("_closeButton",o,true);}return o;};
j.prototype._getBusyIndicator=function(){var o=this.getAggregation("_busy");if(!o){o=new e();this.setAggregation("_busy",o,true);}return o;};
j.prototype._imageStateChanged=function(n){var E=n===h.Loaded||n===h.Error;if(E&&!this._isRendering){this.rerender();}};
j.prototype._createPopup=function(){this._oPopup=new P(this,true,true);this._oPopup.attachOpened(this._fnPopupOpened,this);this._oPopup.attachClosed(this._fnPopupClosed,this);};
j.prototype._fnPopupOpened=function(){this._onResize();q("#sap-ui-blocklayer-popup").on("click",function(){this.close();}.bind(this));};
j.prototype._fnPopupClosed=function(){q("#sap-ui-blocklayer-popup").off("click");};
j.prototype._createErrorControls=function(){var E,s,t,S,o;if(this.getAggregation("_verticalLayout")){return;}if(this._getImageContent()._getImageState()===h.TimeOutError){E=this._oRB.getText("LIGHTBOX_IMAGE_TIMED_OUT");s=this._oRB.getText("LIGHTBOX_IMAGE_TIMED_OUT_DETAILS");}else{E=this._oRB.getText("LIGHTBOX_IMAGE_ERROR");s=this._oRB.getText("LIGHTBOX_IMAGE_ERROR_DETAILS");}t=new T({text:E,textAlign:i.Center}).addStyleClass("sapMLightBoxErrorTitle");S=new T({text:s,textAlign:i.Center}).addStyleClass("sapMLightBoxErrorSubtitle");o=new I({src:"sap-icon://picture"}).addStyleClass("sapMLightBoxErrorIcon");this.setAggregation("_verticalLayout",new V({content:[o,t,S]}).addStyleClass("sapMLightBoxVerticalLayout"));};
j.prototype._onResize=function(){var m=this._calculateOffset()/2+"px",t=m,v=m,M="",k="",o=this._getImageContent(),n=this.getDomRef(),p,r,s=this._calculateOffset();if(o._getImageState()===h.Loaded){this._calculateSizes(o._getNativeImage());p=this._iWidth;r=this._iHeight;this._$lightBox.width(p);this._$lightBox.height(r);}else{p=n.clientWidth;r=n.clientHeight;}if(window.innerWidth>p+s){v="50%";k=Math.round(-p/2);}if(window.innerHeight>r+s){t="50%";M=Math.round(-r/2);}this._$lightBox.css({"top":t,"margin-top":M,"left":v,"margin-left":k});};
j.prototype._calculateSizes=function(n){var F=this._calculateFooterHeightInPx(),k=288-F,o=this._getImageContent().getAggregation("_image"),H;this._setImageSize(o,n.naturalWidth,n.naturalHeight);this._calculateAndSetLightBoxSize(o);H=this._pxToNumber(o.getHeight());this.toggleStyleClass("sapMLightBoxMinSize",H<k);this._isBusy=false;};
j.prototype._calculateFooterHeightInPx=function(){var k=this.$().parents().hasClass("sapUiSizeCompact"),s=this._getImageContent().getSubtitle(),F=3;if(k&&!s){F-=0.5;}if(s){F+=0.5;}return f.toPx(F);};
j.prototype._calculateAndSetLightBoxSize=function(o){var k,m,n=20*16,p=18*16,F=this._calculateFooterHeightInPx();k=this._pxToNumber(o.getHeight());m=this._pxToNumber(o.getWidth());this._iWidth=Math.max(n,m);this._iHeight=Math.max(p,k+F);this._bIsLightBoxBiggerThanMinDimensions=(m>=n)&&(k>=(p-F));};
j.prototype._setImageSize=function(o,w,H){var F=this._calculateFooterHeightInPx(),k=this._getDimensions(w,H,F);o.setWidth(k.width+"px");o.setHeight(k.height+"px");};
j.prototype._getDimensions=function(k,m,F){var n=20*16,o=18*16,$=q(window),w=$.height(),W=$.width(),M=this._calculateOffset(),A=Math.max(W-M,n),p=Math.max(w-M,o),s;p-=F;if(m<=p){if(k<=A){}else{m*=A/k;k=A;}}else if(k<=A){k*=p/m;m=p;}else{s=Math.max(k/A,m/p);k/=s;m/=s;}return{width:Math.round(k),height:Math.round(m)};};
j.prototype._pxToNumber=function(s){return(s.substring(0,(s.length-2)))*1;};
j.prototype._getImageContent=function(){var k=this.getAggregation("imageContent");return k&&k[0];};
j.prototype._calculateOffset=function(){if(D.system.desktop){return 4*16;}if(D.system.tablet){return 2*16;}if(D.system.phone&&D.resize.width>320){return 1*16;}return 0;};
j.prototype.onsapescape=function(E){var o=this._oPopup.getOpenState();if(o!==O.CLOSED||o!==O.CLOSING){this.close();E.stopPropagation();}};
return j;});
sap.ui.predefine('sap/m/LightBoxItem',["./library","sap/ui/core/library","sap/ui/core/Element","sap/m/Image","sap/m/Title","sap/m/Label"],function(l,c,E,I,T,L){"use strict";var a=l.LightBoxLoadingStates;var O=c.OpenState;var b=c.TitleLevel;
var d=E.extend("sap.m.LightBoxItem",{metadata:{library:"sap.m",properties:{imageSrc:{type:"sap.ui.core.URI",group:"Appearance",multiple:false,defaultValue:""},alt:{type:"string",group:"Appearance",multiple:false,defaultValue:""},title:{type:"string",group:"Appearance",multiple:false,defaultValue:""},subtitle:{type:"string",group:"Appearance",multiple:false,defaultValue:""}},aggregations:{_image:{type:"sap.m.Image",multiple:false,visibility:"hidden"},_title:{type:"sap.m.Title",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Label",multiple:false,visibility:"hidden"}}}});
d.prototype.init=function(){this._createNativeImage();this.setAggregation("_image",new I({decorative:false,densityAware:false}),true);this.setAggregation("_title",new T({level:b.H2,wrapping:false}),true);this.setAggregation("_subtitle",new L({wrapping:false}),true);};
d.prototype._createNativeImage=function(){var t=this;this._sImageState=a.Loading;this._oImage=new window.Image();this._oImage.onload=function(){if(this.complete&&t._sImageState===a.Loading){t._setImageState(a.Loaded);}};this._oImage.onerror=function(){t._setImageState(a.Error);};};
d.prototype.exit=function(){this._oImage=null;};
d.prototype._setImageState=function(i){if(i!==this._sImageState){this._sImageState=i;if(this.getParent()){this.getParent()._imageStateChanged(i);}}};
d.prototype._getImageState=function(){return this._sImageState;};
d.prototype._getNativeImage=function(){return this._oImage;};
d.prototype.setImageSrc=function(i){var o=this.getAggregation("_image"),e=this.getParent();if(this.getImageSrc()===i){return this;}this._sImageState=a.Loading;if(e&&e._oPopup.getOpenState()===O.OPEN){this._oImage.src=i;}this.setProperty("imageSrc",i,false);o.setSrc(i);return this;};
d.prototype.setAlt=function(e){var i=this.getAggregation("_image");this.setProperty("alt",e,false);i.setAlt(e);return this;};
d.prototype.setTitle=function(t){var o=this.getAggregation("_title");this.setProperty("title",t,false);o.setText(t);return this;};
d.prototype.setSubtitle=function(s){var S=this.getAggregation("_subtitle");this.setProperty("subtitle",s,false);S.setText(s);return this;};
return d;});
sap.ui.predefine('sap/m/LightBoxRenderer',["sap/m/library"],function(l){"use strict";var L=l.LightBoxLoadingStates;var a={apiVersion:2};
a.render=function(r,c){var o=c._getImageContent();var i=o._getImageState();var I=c.getAggregation("_invisiblePopupText");r.openStart("div",c).class("sapMLightBox").attr("tabindex","-1").accessibilityState({role:"dialog",modal:true,labelledby:I&&I.getId()});if(o.getSubtitle()){r.class("sapMLightBoxTwoLines");}if(c._bIsLightBoxBiggerThanMinDimensions){r.class("sapMLightBoxTopCornersRadius");}if(i!==L.Error){r.style("width",c._iWidth+"px");r.style("height",c._iHeight+"px");}else{r.class("sapMLightBoxError");}r.openEnd();r.renderControl(I);if(i===L.Loading){this.renderBusyState(r,c);}else if(i===L.TimeOutError||i===L.Error){this.renderError(r,c);}else{this.renderImage(r,c);}this.renderFooter(r,c,o);r.close("div");c._isRendering=false;};
a.renderImage=function(r,c){var o=c._getImageContent();r.openStart("div",o);if(o.getSubtitle()){r.class("sapMLightBoxImageContainerTwoLines");}else{r.class("sapMLightBoxImageContainer");}r.openEnd();r.renderControl(o.getAggregation("_image"));r.close("div");};
a.renderError=function(r,c){var o=c._getImageContent();r.openStart("div");if(o&&o.getSubtitle()){r.class("sapMLightBoxErrorContainerTwoLines");}else{r.class("sapMLightBoxErrorContainer");}r.openEnd();r.renderControl(c.getAggregation("_verticalLayout"));r.close("div");};
a.renderBusyState=function(r,c){r.renderControl(c._getBusyIndicator());};
a.renderFooter=function(r,c,i){var t=i.getAggregation("_title"),s=i.getAggregation("_subtitle");r.openStart("div").class("sapMLightBoxFooter").class("sapContrast").class("sapContrastPlus");if(i.getSubtitle()){r.class("sapMLightBoxFooterTwoLines");}r.openEnd();r.openStart("div").class("sapMLightBoxTitleSection").openEnd();if(t){r.renderControl(t.addStyleClass("sapMLightBoxTitle"));}if(s&&s.getText()){r.renderControl(s.addStyleClass("sapMLightBoxSubtitle"));}r.close("div");r.renderControl(c._getCloseButton());r.close("div");};
return a;},true);
sap.ui.predefine('sap/m/Link',["./library","sap/ui/core/Control","sap/ui/core/InvisibleText","sap/ui/core/EnabledPropagator","sap/ui/core/LabelEnablement","sap/ui/core/library","sap/ui/Device","./LinkRenderer","sap/ui/events/KeyCodes","sap/base/Log","sap/base/security/URLListValidator"],function(l,C,I,E,L,c,D,a,K,b,U){"use strict";var T=c.TextDirection;var d=c.TextAlign;var A=c.aria.HasPopup;var e=l.EmptyIndicatorMode;
var f=C.extend("sap.m.Link",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.ui.core.IFormContent","sap.ui.core.ITitleContent"],library:"sap.m",designtime:"sap/m/designtime/Link.designtime",properties:{text:{type:"string",group:"Data",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},target:{type:"string",group:"Behavior",defaultValue:null},rel:{type:"string",group:"Behavior",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},validateUrl:{type:"boolean",group:"Data",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:d.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},subtle:{type:"boolean",group:"Behavior",defaultValue:false},emphasized:{type:"boolean",group:"Behavior",defaultValue:false},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:A.None},emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:e.Off}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{allowPreventDefault:true,parameters:{ctrlKey:{type:"boolean"},metaKey:{type:"boolean"}}}},dnd:{draggable:true,droppable:false}}});
E.call(f.prototype);
f.prototype.onBeforeRendering=function(){};
f.prototype.onkeydown=function(o){if(o.which===K.SPACE||o.which===K.SHIFT||o.which===K.ESCAPE){if(o.which===K.SPACE){if(this.getEnabled()||this.getHref()){o.setMarked();o.preventDefault();this._bPressedSpace=true;}}if(this._bPressedSpace&&(o.which===K.ESCAPE||o.which===K.SHIFT)){this._bPressedEscapeOrShift=true;}}else{if(this._bPressedSpace){o.preventDefault();}}};
f.prototype.onkeyup=function(o){if(o.which===K.SPACE){if(!this._bPressedEscapeOrShift){this._handlePress(o);if(this.getHref()&&!o.isDefaultPrevented()){o.preventDefault();o.setMarked();var g=document.createEvent('MouseEvents');g.initEvent('click',false,true);this.getDomRef().dispatchEvent(g);}}else{this._bPressedEscapeOrShift=false;}this._bPressedSpace=false;}};
f.prototype._handlePress=function(o){if(this.getEnabled()){o.setMarked();if(!this.firePress({ctrlKey:!!o.ctrlKey,metaKey:!!o.metaKey})||!this.getHref()){o.preventDefault();}}else{o.preventDefault();}};
f.prototype.onsapenter=f.prototype._handlePress;if(D.support.touch){f.prototype.ontap=f.prototype._handlePress;}else{f.prototype.onclick=f.prototype._handlePress;}
f.prototype.ontouchstart=function(o){if(this.getEnabled()){o.setMarked();}};
f.prototype.setSubtle=function(s){this.setProperty("subtle",s);if(s&&!f.prototype._sAriaLinkSubtleId){f.prototype._sAriaLinkSubtleId=I.getStaticId("sap.m","LINK_SUBTLE");}return this;};
f.prototype.setEmphasized=function(g){this.setProperty("emphasized",g);if(g&&!f.prototype._sAriaLinkEmphasizedId){f.prototype._sAriaLinkEmphasizedId=I.getStaticId("sap.m","LINK_EMPHASIZED");}return this;};
f.prototype._isHrefValid=function(u){return this.getValidateUrl()?U.validate(u):true;};
f.prototype.getAccessibilityInfo=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s=this.getEmphasized()?r.getText("LINK_EMPHASIZED"):"",S=this.getSubtle()?r.getText("LINK_SUBTLE"):"",t=this.getText(),g=t;if(t){s&&(g+=" "+s);S&&(g+=" "+S);}return{role:"link",type:t?r.getText("ACC_CTR_TYPE_LINK"):undefined,description:g,focusable:this.getEnabled(),enabled:this.getEnabled()};};
f.prototype.getFormDoNotAdjustWidth=function(){return true;};
f.prototype._getTabindex=function(){return(this.getText()&&this.getEnabled())?"0":"-1";};
f.prototype._determineSelfReferencePresence=function(){var g=this.getAriaLabelledBy(),h=g.indexOf(this.getId())!==-1,H=L.getReferencingLabels(this).length>0,p=this.getParent(),i=!!(p&&p.enhanceAccessibilityState);return!h&&(g.length>0||H||i);};
return f;});
sap.ui.predefine('sap/m/LinkRenderer',["sap/ui/core/Renderer","sap/ui/core/library","sap/ui/util/defaultLinkTypes",'./library','sap/ui/core/Core'],function(R,c,d,m,C){"use strict";var T=c.TextDirection;var A=c.aria.HasPopup;var L={apiVersion:2};var E=m.EmptyIndicatorMode;var r=C.getLibraryResourceBundle("sap.m");
L.render=function(o,a){var t=a.getTextDirection(),s=R.getTextAlign(a.getTextAlign(),t),S=a._determineSelfReferencePresence(),h=a.getAriaHasPopup(),H=a.getHref(),b=d(a.getRel(),a.getTarget()),e={labelledby:S?{value:a.getId(),append:true}:undefined,haspopup:(h===A.None)?null:h.toLowerCase()},i=H&&a._isHrefValid(H),f=a.getEnabled(),g="";o.openStart("a",a);o.class("sapMLnk");if(a.getSubtle()){o.class("sapMLnkSubtle");g+=a._sAriaLinkSubtleId;}if(a.getEmphasized()){o.class("sapMLnkEmphasized");g+=" "+a._sAriaLinkEmphasizedId;}e.describedby=g?{value:g.trim(),append:true}:undefined;if(!f){o.class("sapMLnkDsbl");o.attr("aria-disabled","true");}o.attr("tabindex",a._getTabindex());if(a.getWrapping()){o.class("sapMLnkWrapping");}if(a.getTooltip_AsString()){o.attr("title",a.getTooltip_AsString());}if(i&&f){o.attr("href",H);}else if(a.getText()){o.attr("href","");}if(a.getTarget()){o.attr("target",a.getTarget());}if(b){o.attr("rel",b);}if(a.getWidth()){o.style("width",a.getWidth());}else{o.class("sapMLnkMaxWidth");}if(s){o.style("text-align",s);}if(t!==T.Inherit){o.attr("dir",t.toLowerCase());}a.getDragDropConfig().forEach(function(D){if(!D.getEnabled()){o.attr("draggable",false);}});o.accessibilityState(a,e);o.openEnd();if(this.writeText){this.writeText(o,a);}else{this.renderText(o,a);}o.close("a");};
L.renderText=function(o,a){var t=a.getText();if(a.getEmptyIndicatorMode()!==E.Off&&!a.getText()){this.renderEmptyIndicator(o,a);}else{o.text(t);}};
L.renderEmptyIndicator=function(o,l){o.openStart("span");o.class("sapMEmptyIndicator");o.class("sapMLnkDsbl");if(l.getEmptyIndicatorMode()===E.Auto){o.class("sapMEmptyIndicatorAuto");}o.openEnd();o.openStart("span");o.attr("aria-hidden",true);o.openEnd();o.text(r.getText("EMPTY_INDICATOR"));o.close("span");o.openStart("span");o.class("sapUiPseudoInvisibleText");o.openEnd();o.text(r.getText("EMPTY_INDICATOR_TEXT"));o.close("span");o.close("span");};
return L;},true);
sap.ui.predefine('sap/m/List',["./library","./ListBase","./ListRenderer"],function(l,L,a){"use strict";var B=l.BackgroundDesign;
var b=L.extend("sap.m.List",{metadata:{library:"sap.m",properties:{backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Solid}}}});
return b;});
sap.ui.predefine('sap/m/ListBase',["sap/ui/events/KeyCodes","sap/ui/Device","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/InvisibleText","sap/ui/core/LabelEnablement","sap/ui/core/delegate/ItemNavigation","./library","./InstanceManager","./GrowingEnablement","./GroupHeaderListItem","./ListItemBase","./ListBaseRenderer","sap/base/strings/capitalize","sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Selectors","sap/ui/dom/jquery/Aria"],function(K,D,C,a,I,L,b,l,c,G,d,f,g,h,q,j){"use strict";var k=l.ListType;var m=l.ListKeyboardMode;var n=l.ListGrowingDirection;var S=l.SwipeDirection;var o=l.ListSeparators;var p=l.ListMode;var r=l.ListHeaderDesign;var s=l.Sticky;var M=l.MultiSelectMode;
var t=a.extend("sap.m.ListBase",{metadata:{library:"sap.m",dnd:true,properties:{inset:{type:"boolean",group:"Appearance",defaultValue:false},headerText:{type:"string",group:"Misc",defaultValue:null},headerDesign:{type:"sap.m.ListHeaderDesign",group:"Appearance",defaultValue:r.Standard,deprecated:true},footerText:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:p.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},includeItemInSelection:{type:"boolean",group:"Behavior",defaultValue:false},showUnread:{type:"boolean",group:"Misc",defaultValue:false},noDataText:{type:"string",group:"Misc",defaultValue:null},showNoData:{type:"boolean",group:"Misc",defaultValue:true},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:true},modeAnimationOn:{type:"boolean",group:"Misc",defaultValue:true},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:o.All},swipeDirection:{type:"sap.m.SwipeDirection",group:"Misc",defaultValue:S.Both},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingThreshold:{type:"int",group:"Misc",defaultValue:20},growingTriggerText:{type:"string",group:"Appearance",defaultValue:null},growingScrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false},growingDirection:{type:"sap.m.ListGrowingDirection",group:"Behavior",defaultValue:n.Downwards},rememberSelections:{type:"boolean",group:"Behavior",defaultValue:true},keyboardMode:{type:"sap.m.ListKeyboardMode",group:"Behavior",defaultValue:m.Navigation},sticky:{type:"sap.m.Sticky[]",group:"Appearance"},multiSelectMode:{type:"sap.m.MultiSelectMode",group:"Behavior",defaultValue:M.Default}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.ListItemBase",multiple:true,singularName:"item",bindable:"bindable",selector:"#{id} .sapMListItems",dnd:true},swipeContent:{type:"sap.ui.core.Control",multiple:false},headerToolbar:{type:"sap.m.Toolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},_messageStrip:{type:"sap.m.MessageStrip",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{deprecated:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}},selectionChange:{parameters:{listItem:{type:"sap.m.ListItemBase"},listItems:{type:"sap.m.ListItemBase[]"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},"delete":{parameters:{listItem:{type:"sap.m.ListItemBase"}}},swipe:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"},swipeContent:{type:"sap.ui.core.Control"},srcControl:{type:"sap.ui.core.Control"},swipeDirection:{type:"sap.m.SwipeDirection"}}},growingStarted:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},growingFinished:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},updateStarted:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},updateFinished:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},itemPress:{parameters:{listItem:{type:"sap.m.ListItemBase"},srcControl:{type:"sap.ui.core.Control"}}},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}}},designtime:"sap/m/designtime/ListBase.designtime"}});
t.prototype.bAnnounceDetails=true;
t.getInvisibleText=function(){if(!this.oInvisibleText){this.oInvisibleText=new I().toStatic();}return this.oInvisibleText;};
t.prototype.sNavItemClass="sapMLIB";
t.prototype.init=function(){this._aNavSections=[];this._aSelectedPaths=[];this._iItemNeedsHighlight=0;this._iItemNeedsNavigated=0;this._bItemsBeingBound=false;this._bSkippedInvalidationOnRebind=false;this.data("sap-ui-fastnavgroup","true",true);};
t.prototype.onBeforeRendering=function(){this._bRendering=true;this._bActiveItem=false;this._aNavSections=[];this._removeSwipeContent();};
t.prototype.onAfterRendering=function(){this._bRendering=false;this._sLastMode=this.getMode();if(D.system.desktop){this._startItemNavigation(true);}};
t.prototype.exit=function(){this._oSelectedItem=null;this._aNavSections=[];this._aSelectedPaths=[];this._destroyGrowingDelegate();this._destroyItemNavigation();};
t.prototype.refreshItems=function(R){if(this._oGrowingDelegate){this._oGrowingDelegate.refreshItems(R);}else{if(!this._bReceivingData){this._updateStarted(R);this._bReceivingData=true;}this.refreshAggregation("items");}};
t.prototype.updateItems=function(R,e){if(e&&e.detailedReason==="AddVirtualContext"){u(this);return;}else if(e&&e.detailedReason==="RemoveVirtualContext"){v(this);return;}if(this._bSkippedInvalidationOnRebind&&this.getBinding("items").getLength()===0){this.invalidate();}if(this._oGrowingDelegate){this._oGrowingDelegate.updateItems(R);}else{if(this._bReceivingData){this._bReceivingData=false;}else{this._updateStarted(R);}this.updateAggregation("items");this._updateFinished();}this._bSkippedInvalidationOnRebind=false;};
function u(e){var B=e.getBinding("items");var i=e.getBindingInfo("items");var x=e.getGrowing()?e.getGrowingThreshold():i.length;var y=e.getGrowing()||!i.startIndex?0:i.startIndex;var V=B.getContexts(y,x)[0];v(e);e._oVirtualItem=G.createItem(V,i,"virtual");e.addAggregation("dependents",e._oVirtualItem,true);}
function v(e){if(e._oVirtualItem){e._oVirtualItem.destroy();delete e._oVirtualItem;}}
t.prototype.setBindingContext=function(e,i){var x=(this.getBindingInfo("items")||{}).model;if(x===i){this._resetItemsBinding();}return a.prototype.setBindingContext.apply(this,arguments);};
t.prototype.bindAggregation=function(N){this._bItemsBeingBound=N==="items";v(this);a.prototype.bindAggregation.apply(this,arguments);this._bItemsBeingBound=false;return this;};
t.prototype._bindAggregation=function(N,B){function e(B,E,H){B.events=B.events||{};if(!B.events[E]){B.events[E]=H;}else{var O=B.events[E];B.events[E]=function(){H.apply(this,arguments);O.apply(this,arguments);};}}if(N==="items"){this._resetItemsBinding();e(B,"dataRequested",this._onBindingDataRequestedListener.bind(this));e(B,"dataReceived",this._onBindingDataReceivedListener.bind(this));}a.prototype._bindAggregation.call(this,N,B);};
t.prototype._onBindingDataRequestedListener=function(e){this._showBusyIndicator();if(this._dataReceivedHandlerId!=null){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};
t.prototype._onBindingDataReceivedListener=function(e){if(this._dataReceivedHandlerId!=null){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._dataReceivedHandlerId=setTimeout(function(){this._hideBusyIndicator();delete this._dataReceivedHandlerId;}.bind(this),0);};
t.prototype.destroyItems=function(e){if(!this.getItems(true).length){return this;}this._oSelectedItem=null;this.destroyAggregation("items","KeepDom");if(!e){if(this._bItemsBeingBound){this._bSkippedInvalidationOnRebind=true;}else{this.invalidate();}}return this;};
t.prototype.removeAllItems=function(A){this._oSelectedItem=null;return this.removeAllAggregation("items");};
t.prototype.removeItem=function(i){var e=this.removeAggregation("items",i);if(e&&e===this._oSelectedItem){this._oSelectedItem=null;}return e;};
t.prototype.getItems=function(R){if(R){return this.mAggregations["items"]||[];}return this.getAggregation("items",[]);};
t.prototype.getId=function(e){var i=this.sId;return e?i+"-"+e:i;};
t.prototype.setGrowing=function(e){e=!!e;if(this.getGrowing()!=e){this.setProperty("growing",e,!e);if(e){this._oGrowingDelegate=new G(this);}else if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}}return this;};
t.prototype.setGrowingThreshold=function(T){return this.setProperty("growingThreshold",T,true);};
t.prototype.setEnableBusyIndicator=function(e){this.setProperty("enableBusyIndicator",e,true);if(!this.getEnableBusyIndicator()){this._hideBusyIndicator();}return this;};
t.prototype.setNoDataText=function(N){this.setProperty("noDataText",N,true);this.$("nodata-text").text(this.getNoDataText());return this;};
t.prototype.getNoDataText=function(e){if(e&&this._bBusy){return"";}var N=this.getProperty("noDataText");N=N||C.getLibraryResourceBundle("sap.m").getText("LIST_NO_DATA");return N;};
t.prototype.getSelectedItem=function(){var e=this.getItems(true);for(var i=0;i<e.length;i++){if(e[i].getSelected()){return e[i];}}return null;};
t.prototype.setSelectedItem=function(e,i,F){if(this.indexOfItem(e)<0){j.warning("setSelectedItem is called without valid ListItem parameter on "+this);return;}if(this._bSelectionMode){e.setSelected((i===undefined)?true:!!i);F&&this._fireSelectionChangeEvent([e]);}};
t.prototype.getSelectedItems=function(){return this.getItems(true).filter(function(i){return i.getSelected();});};
t.prototype.setSelectedItemById=function(i,e){var x=C.byId(i);return this.setSelectedItem(x,e);};
t.prototype.getSelectedContexts=function(A){var B=this.getBindingInfo("items"),e=(B||{}).model,i=this.getModel(e);if(!B||!i){return[];}if(A&&this.getRememberSelections()){return this._aSelectedPaths.map(function(P){return i.getContext(P);});}return this.getSelectedItems().map(function(x){return x.getBindingContext(e);});};
t.prototype.removeSelections=function(A,F,e){var i=[];this._oSelectedItem=null;A&&(this._aSelectedPaths=[]);this.getItems(true).forEach(function(x){if(!x.getSelected()){return;}if(e&&x.isSelectedBoundTwoWay()){return;}x.setSelected(false,true);i.push(x);!A&&this._updateSelectedPaths(x);},this);if(F&&i.length){this._fireSelectionChangeEvent(i);}return this;};
t.prototype.selectAll=function(F){if(this.getMode()!="MultiSelect"||this.getMultiSelectMode()==M.ClearAll){return this;}var e=[];this.getItems(true).forEach(function(i){if(!i.getSelected()){i.setSelected(true,true);e.push(i);this._updateSelectedPaths(i);}},this);if(F&&e.length){this._fireSelectionChangeEvent(e,F);}return this;};
t.prototype.getLastMode=function(e){return this._sLastMode;};
t.prototype.setMode=function(e){e=this.validateProperty("mode",e);var O=this.getMode();if(O==e){return this;}this._bSelectionMode=e.indexOf("Select")>-1;if(!this._bSelectionMode){this.removeSelections(true);}else{var i=this.getSelectedItems();if(i.length>1){this.removeSelections(true);}else if(O===p.MultiSelect){this._oSelectedItem=i[0];}}return this.setProperty("mode",e);};
t.prototype.getGrowingInfo=function(){return this._oGrowingDelegate?this._oGrowingDelegate.getInfo():null;};
t.prototype.setRememberSelections=function(R){this.setProperty("rememberSelections",R,true);!this.getRememberSelections()&&(this._aSelectedPaths=[]);return this;};
t.prototype.setSelectedContextPaths=function(e){this._aSelectedPaths=e||[];};
t.prototype.getSelectedContextPaths=function(A){if(!A||(A&&this.getRememberSelections())){return this._aSelectedPaths.slice(0);}return this.getSelectedItems().map(function(i){return i.getBindingContextPath();});};
t.prototype.isAllSelectableSelected=function(){if(this.getMode()!=p.MultiSelect){return false;}var i=this.getItems(true),e=this.getSelectedItems().length,x=i.filter(function(y){return y.isSelectable();}).length;return(i.length>0)&&(e==x);};
t.prototype.getVisibleItems=function(){return this.getItems(true).filter(function(i){return i.getVisible();});};
t.prototype.getActiveItem=function(){return this._bActiveItem;};
t.prototype.onItemDOMUpdate=function(e){if(!this._bRendering&&this.bOutput){this._startItemNavigation(true);}var V=this.getVisibleItems().length>0;if(!V&&!this._bInvalidatedForNoData){this.invalidate();this._bInvalidatedForNoData=true;}else if(V&&this._bInvalidatedForNoData){this.invalidate();this._bInvalidatedForNoData=false;}};
t.prototype.onItemActiveChange=function(e,A){this._bActiveItem=A;};
t.prototype.onItemHighlightChange=function(i,N){this._iItemNeedsHighlight+=(N?1:-1);if(this._iItemNeedsHighlight==1&&N){this.$("listUl").addClass("sapMListHighlight");}else if(this._iItemNeedsHighlight==0){this.$("listUl").removeClass("sapMListHighlight");}};
t.prototype.onItemNavigatedChange=function(i,N){this._iItemNeedsNavigated+=(N?1:-1);if(this._iItemNeedsNavigated==1&&N){this.$("listUl").addClass("sapMListNavigated");}else if(this._iItemNeedsNavigated==0){this.$("listUl").removeClass("sapMListNavigated");}};
t.prototype.onItemSelectedChange=function(e,i){if(this.getMode()==p.MultiSelect){this._updateSelectedPaths(e,i);return;}if(i){this._aSelectedPaths=[];this._oSelectedItem&&this._oSelectedItem.setSelected(false,true);this._oSelectedItem=e;}else if(this._oSelectedItem===e){this._oSelectedItem=null;}this._updateSelectedPaths(e,i);};
t.prototype.getItemsContainerDomRef=function(){return this.getDomRef("listUl");};
t.prototype.getStickyFocusOffset=function(){return 0;};
t.prototype.checkGrowingFromScratch=function(){};
t.prototype.onBeforePageLoaded=function(e,i){this._fireUpdateStarted(i,e);this.fireGrowingStarted(e);};
t.prototype.onAfterPageLoaded=function(e,i){this._fireUpdateFinished(e);this.fireGrowingFinished(e);};
t.prototype.addNavSection=function(i){this._aNavSections.push(i);return i;};
t.prototype.getMaxItemsCount=function(){var B=this.getBinding("items");if(B&&B.getLength){return B.getLength()||0;}return this.getItems(true).length;};
t.prototype.shouldRenderItems=function(){return true;};
t.prototype.shouldGrowingSuppressInvalidation=function(){return true;};
t.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._bUpdating=false;this._bReceivingData=false;this.removeSelections(true,false,true);this._oGrowingDelegate&&this._oGrowingDelegate.reset();this._hideBusyIndicator();if(this._oItemNavigation){this._oItemNavigation.iFocusedIndex=-1;}}};
t.prototype._updateStarted=function(R){if(!this._bReceivingData&&!this._bUpdating){this._bUpdating=true;this._fireUpdateStarted(R);}};
t.prototype._fireUpdateStarted=function(R,i){this._sUpdateReason=h(R||"Refresh");this.fireUpdateStarted({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});};
t.prototype.onThemeChanged=function(){if(this._oGrowingDelegate){this._oGrowingDelegate._updateTrigger();}};
t.prototype._updateFinished=function(){if(!this._bReceivingData&&this._bUpdating){this._fireUpdateFinished();this._bUpdating=false;}};
t.prototype._fireUpdateFinished=function(i){this._hideBusyIndicator();setTimeout(function(){this._bItemNavigationInvalidated=true;this.fireUpdateFinished({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});}.bind(this),0);};
t.prototype._showBusyIndicator=function(){if(this.getEnableBusyIndicator()&&!this.getBusy()&&!this._bBusy){this._bBusy=true;this._sBusyTimer=setTimeout(function(){this.$("nodata-text").text("");}.bind(this),this.getBusyIndicatorDelay());this.setBusy(true,"listUl");}};
t.prototype._hideBusyIndicator=function(){if(this._bBusy){this._bBusy=false;this.setBusy(false,"listUl");clearTimeout(this._sBusyTimer);if(!this.getItems(true).length){this.$("nodata-text").text(this.getNoDataText());}}};
t.prototype.setBusy=function(B,e){if(this.getBusy()==B){return this;}a.prototype.setBusy.apply(this,arguments);if(!B||!window.IntersectionObserver){clearTimeout(this._iBusyTimer);return this;}this._iBusyTimer=setTimeout(function(){var i=this.getDomRef(e);var A=this.getDomRef("busyIndicator");var x=l.getScrollDelegate(this,true);if(!i||!A||!x){return;}var y=new window.IntersectionObserver(function(E){y.disconnect();var z=E.pop();var R=z.intersectionRatio;if(R<=0||R>=1){return;}var F=A.firstChild.style;if(z.intersectionRect.height>=z.rootBounds.height){F.position="sticky";}else{F.top=((z.boundingClientRect.top<0?1-R:0)+(R/2))*100+"%";}},{root:x.getContainerDomRef()});y.observe(i);}.bind(this),this.getBusyIndicatorDelay());return this;};
t.prototype.onItemBindingContextSet=function(i){if(!this._bSelectionMode||!this.getRememberSelections()||!this.isBound("items")){return;}if(i.isSelectedBoundTwoWay()){return;}var P=i.getBindingContextPath();if(P){var e=(this._aSelectedPaths.indexOf(P)>-1);i.setSelected(e);}};
t.prototype.onItemInserted=function(i,e){if(e){this.onItemSelectedChange(i,true);}if(!this._bSelectionMode||!this._aSelectedPaths.length||!this.getRememberSelections()||!this.isBound("items")||i.isSelectedBoundTwoWay()||i.getSelected()){return;}var P=i.getBindingContextPath();if(P&&this._aSelectedPaths.indexOf(P)>-1){i.setSelected(true);}};
t.prototype.onItemSelect=function(e,x){var y=this.getMode();if(this._mRangeSelection){if(!this._mRangeSelection.selected){this._fireSelectionChangeEvent([e]);this._mRangeSelection.index=this.getVisibleItems().indexOf(e);this._mRangeSelection.selected=x;return;}if(!x){e.setSelected(true);return;}var z=this.indexOfItem(e),A=this.getItems(),B,E,F=[],H;if(z<this._mRangeSelection.index){B=this._mRangeSelection.index-z;H=-1;}else{B=z-this._mRangeSelection.index;H=1;}for(var i=1;i<=B;i++){E=A[this._mRangeSelection.index+(i*H)];if(E.isSelectable()&&E.getVisible()&&!E.getSelected()){E.setSelected(true);F.push(E);}else if(E===e){F.push(E);}}this._fireSelectionChangeEvent(F);return;}if(y===p.MultiSelect){this._fireSelectionChangeEvent([e]);}else if(this._bSelectionMode&&x){this._fireSelectionChangeEvent([e]);}};
t.prototype._fireSelectionChangeEvent=function(e,i){var x=e&&e[0];if(!x){return;}this.fireSelectionChange({listItem:x,listItems:e,selected:x.getSelected(),selectAll:!!i});if(this.getGrowing()){this._bSelectAll=i;}this.fireSelect({listItem:x});};
t.prototype.onItemDelete=function(e){this.fireDelete({listItem:e});};
t.prototype.onItemPress=function(e,i){if(e.getType()==k.Inactive){return;}setTimeout(function(){this.fireItemPress({listItem:e,srcControl:i});}.bind(this),0);};
t.prototype.onItemKeyDown=function(i,e){if(!e.shiftKey||e.ctrlKey||e.altKey||e.metaKey||this.getMode()!==p.MultiSelect||!i.isSelectable()||e.which===K.F6){if(this._mRangeSelection){this._mRangeSelection=null;}return;}var V=this.getVisibleItems(),H=V.some(function(x){return!!x.getSelected();});if(!H){return;}if(!this._mRangeSelection){this._mRangeSelection={index:this.indexOfItem(i),selected:i.getSelected()};}};
t.prototype.onItemKeyUp=function(i,e){if(e.which===K.SHIFT){this._mRangeSelection=null;}};
t.prototype._updateSelectedPaths=function(i,e){if(!this.getRememberSelections()||!this.isBound("items")){return;}var P=i.getBindingContextPath();if(!P){return;}e=(e===undefined)?i.getSelected():e;var x=this._aSelectedPaths.indexOf(P);if(e){x<0&&this._aSelectedPaths.push(P);}else{x>-1&&this._aSelectedPaths.splice(x,1);}};
t.prototype._destroyGrowingDelegate=function(){if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}};
t.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}};
t.prototype._getTouchBlocker=function(){return this.$().children();};
t.prototype._getSwipeContainer=function(){if(!this._$swipeContainer){this._$swipeContainer=q("<div>",{"id":this.getId("swp"),"class":"sapMListSwp"});}return this._$swipeContainer;};
t.prototype._setSwipePosition=function(){if(this._isSwipeActive){return this._getSwipeContainer().css("top",this._swipedItem.$().position().top);}};
t.prototype._renderSwipeContent=function(){var $=this._swipedItem.$(),e=this._getSwipeContainer();this.$().prepend(e.css({top:$.position().top,height:$.outerHeight(true)}));if(this._bRerenderSwipeContent){this._bRerenderSwipeContent=false;var i=C.createRenderManager();i.render(this.getSwipeContent(),e.empty()[0]);i.destroy();}return this;};
t.prototype._swipeIn=function(){var i=this,$=i._getTouchBlocker(),x=i._getSwipeContainer();i._isSwipeActive=true;i._renderSwipeContent();c.addPopoverInstance(i);window.document.activeElement.blur();q(window).on("resize.swp",function(){i._setSwipePosition();});$.css("pointer-events","none").on("touchstart.swp mousedown.swp",function(e){if(!x[0].firstChild.contains(e.target)){e.preventDefault();e.stopPropagation();}});x.on("webkitAnimationEnd animationend",function(){q(this).off("webkitAnimationEnd animationend");x.css("opacity",1).trigger("focus");$.parent().on("touchend.swp touchcancel.swp mouseup.swp",function(e){if(!x[0].firstChild.contains(e.target)){i.swipeOut();}});}).removeClass("sapMListSwpOutAnim").addClass("sapMListSwpInAnim");};
t.prototype._onSwipeOut=function(e){this._getSwipeContainer().css("opacity",0).remove();q(window).off("resize.swp");this._getTouchBlocker().css("pointer-events","auto").off("touchstart.swp mousedown.swp");if(typeof e=="function"){e.call(this,this._swipedItem,this.getSwipeContent());}this._isSwipeActive=false;c.removePopoverInstance(this);};
t.prototype.swipeOut=function(e){if(!this._isSwipeActive){return this;}var i=this,$=this._getSwipeContainer();this._getTouchBlocker().parent().off("touchend.swp touchend.swp touchcancel.swp mouseup.swp");$.on("webkitAnimationEnd animationend",function(){q(this).off("webkitAnimationEnd animationend");i._onSwipeOut(e);}).removeClass("sapMListSwpInAnim").addClass("sapMListSwpOutAnim");return this;};
t.prototype._removeSwipeContent=function(){if(this._isSwipeActive){this.swipeOut()._onSwipeOut();}};
t.prototype.close=t.prototype._removeSwipeContent;
t.prototype._onSwipe=function(e,i){var x=this.getSwipeContent(),y=e.srcControl;if(x&&y&&!this._isSwipeActive&&this!==y&&!this._eventHandledByControl&&D.support.touch){for(var z=y;z&&!(z instanceof f);z=z.oParent);if(z instanceof f){this._swipedItem=z;this.fireSwipe({listItem:this._swipedItem,swipeContent:x,srcControl:y,swipeDirection:i},true)&&this._swipeIn();}}};
t.prototype.ontouchstart=function(e){this._eventHandledByControl=e.isMarked();};
t.prototype.onswipeleft=function(e){var R=C.getConfiguration().getRTL();var i=R?S.EndToBegin:S.BeginToEnd;var x=this.getSwipeDirection();if(x===S.LeftToRight){x=S.BeginToEnd;}else if(x===S.RightToLeft){x=S.EndToBegin;}if(x!=i){if(x==S.Both){x=R?S.BeginToEnd:S.EndToBegin;}this._onSwipe(e,x);}};
t.prototype.onswiperight=function(e){var R=C.getConfiguration().getRTL();var i=R?S.BeginToEnd:S.EndToBegin;var x=this.getSwipeDirection();if(x===S.LeftToRight){x=S.BeginToEnd;}else if(x===S.RightToLeft){x=S.EndToBegin;}if(x!=i){if(x==S.Both){x=R?S.EndToBegin:S.BeginToEnd;}this._onSwipe(e,x);}};
t.prototype.setSwipeDirection=function(e){return this.setProperty("swipeDirection",e,true);};
t.prototype.getSwipedItem=function(){return(this._isSwipeActive?this._swipedItem:null);};
t.prototype.setSwipeContent=function(e){this._bRerenderSwipeContent=true;this.toggleStyleClass("sapMListSwipable",!!e);return this.setAggregation("swipeContent",e,!this._isSwipeActive);};
t.prototype.invalidate=function(O){if(O&&O===this.getSwipeContent()){this._bRerenderSwipeContent=true;this._isSwipeActive&&this._renderSwipeContent();return;}return a.prototype.invalidate.apply(this,arguments);};
t.prototype.addItemGroup=function(e,H,i){if(!H){H=new d();H.setTitle(e.text||e.key);}H._bGroupHeader=true;this.addAggregation("items",H,i);return H;};
t.prototype.removeGroupHeaders=function(e){this.getItems(true).forEach(function(i){if(i.isGroupHeader()){i.destroy(e);}});};
t.prototype.getAccessibilityType=function(){return C.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LIST");};
t.prototype.getAccessibilityStates=function(){if(!this.getItems(true).length){return"";}var e="",i=p,x=this.getMode(),B=C.getLibraryResourceBundle("sap.m");if(L.isRequired(this)){e+=B.getText("LIST_REQUIRED")+" ";}if(x==i.MultiSelect){e+=B.getText("LIST_MULTISELECTABLE")+" . ";}else if(x==i.Delete){e+=B.getText("LIST_DELETABLE")+" . ";}else if(x!=i.None){e+=B.getText("LIST_SELECTABLE")+" . ";}if(this.isGrouped()){e+=B.getText("LIST_GROUPED")+" . ";}return e;};
t.prototype.getAccessibilityInfo=function(){return{description:this.getAccessibilityStates().trim(),focusable:true};};
t.prototype.getAccessbilityPosition=function(i){var e=0,x=this.getVisibleItems(),P=x.indexOf(i)+1,B=this.getBinding("items");if(this.getGrowing()&&this.getGrowingScrollToLoad()&&B&&B.isLengthFinal()){e=B.getLength();if(B.isGrouped()){e+=x.filter(function(i){return i.isGroupHeader()&&i.getVisible();}).length;}}else{e=x.length;}return{setSize:e,posInset:P};};
t.prototype.onItemFocusIn=function(i,F){this._handleStickyItemFocus(i.getDomRef());if(i!==F||!C.getConfiguration().getAccessibility()){return;}var e=i.getDomRef(),P=this.getAccessbilityPosition(i);if(!i.getContentAnnouncement){this.getNavigationRoot().setAttribute("aria-activedescendant",e.id);e.setAttribute("aria-posinset",P.posInset);e.setAttribute("aria-setsize",P.setSize);}else{var A=i.getAccessibilityInfo(),B=C.getLibraryResourceBundle("sap.m"),x=A.type+" . ";if(!D.browser.chrome||this.isA("sap.m.Table")){x+=B.getText("LIST_ITEM_POSITION",[P.posInset,P.setSize])+" . ";}else{e.setAttribute("aria-posinset",P.posInset);e.setAttribute("aria-setsize",P.setSize);}x+=A.description;this.updateInvisibleText(x,e);return x;}};
t.prototype.updateInvisibleText=function(T,i,P){var e=t.getInvisibleText(),F=q(i||document.activeElement);if(this.bAnnounceDetails){this.bAnnounceDetails=false;T=this.getAccessibilityInfo().description+" "+T;}e.setText(T.trim());F.addAriaLabelledBy(e.getId(),P);};
t.prototype.getNavigationRoot=function(){return this.getDomRef("listUl");};
t.prototype.getFocusDomRef=function(){return this.getNavigationRoot();};
t.prototype._startItemNavigation=function(i){if(!D.system.desktop){return;}var e=this.getDomRef();if(!this.getShowNoData()&&!this.getVisibleItems().length&&e){e.classList.add("sapMListPreventFocus");this._destroyItemNavigation();return;}if(e){e.classList.remove("sapMListPreventFocus");}var x=this.getKeyboardMode(),y=m;if(x==y.Edit&&!this.getItems(true).length){return;}var N=this.getNavigationRoot();var T=(x==y.Edit)?-1:0;if(i&&N&&!N.contains(document.activeElement)){this._bItemNavigationInvalidated=true;if(!N.getAttribute("tabindex")){N.tabIndex=T;}return;}if(!this._oItemNavigation){this._oItemNavigation=new b();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._setItemNavigationTabIndex(T);this._oItemNavigation.setTableMode(true,true).setColumns(1);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});}this._oItemNavigation.setPageSize(this.getGrowingThreshold());this._oItemNavigation.setRootDomRef(N);this.setNavigationItems(this._oItemNavigation,N);this._bItemNavigationInvalidated=false;};
t.prototype.setNavigationItems=function(i,N){var e=q(N).children(".sapMLIB").get();i.setItemDomRefs(e);if(i.getFocusedIndex()==-1){if(this.getGrowing()&&this.getGrowingDirection()==n.Upwards){i.setFocusedIndex(e.length-1);}else{i.setFocusedIndex(0);}}};
t.prototype.getItemNavigation=function(){return this._oItemNavigation;};
t.prototype._setItemNavigationTabIndex=function(T){if(this._oItemNavigation){this._oItemNavigation.iActiveTabIndex=T;this._oItemNavigation.iTabIndex=T;}};
t.prototype.setKeyboardMode=function(e){this.setProperty("keyboardMode",e,true);if(this.isActive()){var T=(e==m.Edit)?-1:0;this.$("nodata").prop("tabIndex",~T);this.$("listUl").prop("tabIndex",T);this.$("after").prop("tabIndex",T);this._setItemNavigationTabIndex(T);}return this;};
t.prototype.setItemFocusable=function(e){if(!this._oItemNavigation){return;}var i=this._oItemNavigation.getItemDomRefs();var x=i.indexOf(e.getDomRef());if(x>=0){this._oItemNavigation.setFocusedIndex(x);}};
t.prototype.forwardTab=function(F){this._bIgnoreFocusIn=true;this.$(F?"after":"before").trigger("focus");};
t.prototype.onsaptabnext=function(e){if(e.isMarked()||this.getKeyboardMode()==m.Edit){return;}if(e.target.id==this.getId("nodata")){this.forwardTab(true);e.setMarked();}};
t.prototype.onsaptabprevious=function(e){if(e.isMarked()||this.getKeyboardMode()==m.Edit){return;}var T=e.target.id;if(T==this.getId("nodata")){this.forwardTab(false);}else if(T==this.getId("trigger")){this.focusPrevious();e.preventDefault();}};
t.prototype._navToSection=function(F){var T;var i=0;var e=F?1:-1;var x=this._aNavSections.length;this._aNavSections.some(function(z,A){var B=(z?window.document.getElementById(z):null);if(B&&B.contains(document.activeElement)){i=A;return true;}});var y=this.getItemsContainerDomRef();var $=q(document.getElementById(this._aNavSections[i]));if($[0]===y&&this._oItemNavigation){$.data("redirect",this._oItemNavigation.getFocusedIndex());}this._aNavSections.some(function(){i=(i+e+x)%x;T=q(document.getElementById(this._aNavSections[i]));if(T[0]===y&&this._oItemNavigation){var R=T.data("redirect");var z=this._oItemNavigation.getItemDomRefs();var A=z[R]||y.children[0];T=q(A);}if(T.is(":focusable")){T.trigger("focus");return true;}},this);return T;};
t.prototype.onsapshow=function(e){if(e.isMarked()||e.which==K.F4||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(true)){e.preventDefault();e.setMarked();}};
t.prototype.onsaphide=function(e){if(e.isMarked()||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(false)){e.preventDefault();e.setMarked();}};
t.prototype.onkeydown=function(e){var i=(e.which==K.A)&&(e.metaKey||e.ctrlKey);if(e.isMarked()||!i||!q(e.target).hasClass(this.sNavItemClass)){return;}var x=this.getMultiSelectMode();var y=i&&e.shiftKey&&x==M.ClearAll;if(y){e.preventDefault();e.setMarked();this.removeSelections(false,true);return;}e.preventDefault();if(this.getMode()!==p.MultiSelect||x===M.ClearAll){return;}if(this.isAllSelectableSelected()){this.removeSelections(false,true);}else{this.selectAll(true);}e.setMarked();};
t.prototype.onmousedown=function(e){if(this._bItemNavigationInvalidated){this._startItemNavigation();}if(e.shiftKey&&this._mRangeSelection&&e.srcControl.getId().includes("-selectMulti")){e.preventDefault();}};
t.prototype.focusPrevious=function(){if(!this._oItemNavigation){return;}var N=this._oItemNavigation.getItemDomRefs();var i=this._oItemNavigation.getFocusedIndex();var $=q(N[i]);var R=$.control(0)||{};var T=R.getTabbables?R.getTabbables():$.find(":sapTabbable");var F=T.eq(-1).add($).eq(-1);this.bAnnounceDetails=true;F.trigger("focus");};
t.prototype.onfocusin=function(e){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;e.stopImmediatePropagation(true);return;}if(this._bItemNavigationInvalidated){this._startItemNavigation();}var T=e.target;if(T.id==this.getId("nodata")){this.updateInvisibleText(this.getNoDataText(),T);}if(e.isMarked()||!this._oItemNavigation||this.getKeyboardMode()==m.Edit||T.id!=this.getId("after")){return;}this.focusPrevious();e.setMarked();};
t.prototype.onsapfocusleave=function(e){if(this._oItemNavigation&&!this.bAnnounceDetails&&!this.getNavigationRoot().contains(document.activeElement)){this.bAnnounceDetails=true;}};
t.prototype.onItemArrowUpDown=function(e,E){var i=this.getItems(true),x=i.indexOf(e)+(E.type=="sapup"?-1:1),y=i[x];if(y&&y.isGroupHeader()){y=i[x+(E.type=="sapup"?-1:1)];}if(!y){return;}var T=y.getTabbables(),F=e.getTabbables().index(E.target),$=T.eq(T[F]?F:-1);$[0]?$.trigger("focus"):y.focus();E.preventDefault();E.setMarked();};
t.prototype.onItemContextMenu=function(e,E){var i=this.getContextMenu();if(!i){return;}var x=this.fireBeforeOpenContextMenu({listItem:e,column:C.byId(q(E.target).closest(".sapMListTblCell",this.getNavigationRoot()).attr("data-sap-ui-column"))});if(x){E.setMarked();E.preventDefault();var B,y=this.getBindingInfo("items");if(y){B=e.getBindingContext(y.model);i.setBindingContext(B,y.model);}i.openAsContextMenu(E,e);}};
t.prototype.onItemUpDownModifiers=function(i,e,x){if(!this._mRangeSelection){return;}var V=this.getVisibleItems(),y=V.indexOf(i),z=V[y+x];if(!z){if(this._mRangeSelection){this._mRangeSelection=null;}e.setMarked();return;}var A=z.getSelected();if(this._mRangeSelection.direction===undefined){this._mRangeSelection.direction=x;}else if(this._mRangeSelection.direction!==x){if(this._mRangeSelection.index!==V.indexOf(i)){z=i;A=z.getSelected();if(this._mRangeSelection.selected&&A){this.setSelectedItem(z,false,true);return;}}else{this._mRangeSelection.direction=x;}}if(this._mRangeSelection.selected!==A&&z.isSelectable()){this.setSelectedItem(z,this._mRangeSelection.selected,true);}};
t.prototype.isGrouped=function(){var B=this.getBinding("items");return B&&B.isGrouped();};
t.prototype.setContextMenu=function(e){this.setAggregation("contextMenu",e,true);return this;};
t.prototype.destroyContextMenu=function(){this.destroyAggregation("contextMenu",true);return this;};
t.prototype.getStickyStyleValue=function(){var e=this.getSticky();if(!e||!e.length){this._iStickyValue=0;return this._iStickyValue;}var i=0,H=this.getHeaderText(),x=this.getHeaderToolbar(),y=H||(x&&x.getVisible()),z=this.getInfoToolbar(),A=z&&z.getVisible(),B=false;if(this.isA("sap.m.Table")){B=this.getColumns().some(function(E){return E.getVisible()&&E.getHeader();});}e.forEach(function(E){if(E===s.HeaderToolbar&&y){i+=1;}else if(E===s.InfoToolbar&&A){i+=2;}else if(E===s.ColumnHeaders&&B){i+=4;}});this._iStickyValue=i;return this._iStickyValue;};
t.prototype._handleStickyItemFocus=function(i){if(!this._iStickyValue){return;}var e=l.getScrollDelegate(this,true);if(!e){return;}var T=0,x=0,y=0,z=0,H=0,A=0,B=this.getStickyFocusOffset();if(this._iStickyValue&4){var E=this.getDomRef("tblHeader").firstChild;var F=E.getBoundingClientRect();x=parseInt(F.bottom);T=parseInt(F.height);}if(this._iStickyValue&2){var J=this.getDomRef().querySelector(".sapMListInfoTBarContainer");if(J){var N=J.getBoundingClientRect();z=parseInt(N.bottom);y=parseInt(N.height);}}if(this._iStickyValue&1){var O=this.getDomRef().querySelector(".sapMListHdr");if(O){var P=O.getBoundingClientRect();A=parseInt(P.bottom);H=parseInt(P.height);}}var Q=Math.round(i.getBoundingClientRect().top);if(x>Q||z>Q||A>Q){window.requestAnimationFrame(function(){e.scrollToElement(i,0,[0,-T-y-H-B]);});}};
t.prototype.setHeaderToolbar=function(H){return this._setToolbar("headerToolbar",H);};
t.prototype.setInfoToolbar=function(i){return this._setToolbar("infoToolbar",i);};
t.prototype.scrollToIndex=function(i){return new Promise(function(e,x){var y,z;z=l.getScrollDelegate(this,true);if(!z){return x();}y=w(this,i);if(!y){return x();}setTimeout(function(){z.scrollToElement(y.getDomRef(),null,[0,this._getStickyAreaHeight()*-1]);return e();}.bind(this),0);}.bind(this));};
t.prototype.requestItems=function(i){if(i<=0||!this.getGrowing()||!this._oGrowingDelegate){throw new Error("The prerequisites to use 'requestItems' are not met. Please read the documentation for more details.");}if(i!=null){var O=this.getGrowingThreshold();this.setGrowingThreshold(i);this._oGrowingDelegate.requestNewPage();this.setGrowingThreshold(O);}else{this._oGrowingDelegate.requestNewPage();}};
function w(e,i){var x=e.getVisibleItems();var R=x.length;if(typeof i!=='number'||i<-1){i=0;}if(i>=R||i===-1){i=R-1;}return x[i];}
t.prototype._setFocus=function(i,F){return new Promise(function(e,x){var y=w(this,i);if(!y){return x();}if(F===true){var $=y.getTabbables();if($.length){$[0].focus();return e();}}y.focus();return e();}.bind(this));};
t.prototype._getStickyAreaHeight=function(){var e=this.getSticky();if(!(e&&e.length)){return 0;}return e.reduce(function(i,x){var y,z;switch(x){case s.HeaderToolbar:y=this.getHeaderToolbar();z=y&&y.getDomRef()||this.getDomRef("header");break;case s.InfoToolbar:y=this.getInfoToolbar();z=y&&y.getDomRef();break;case s.ColumnHeaders:z=this.getDomRef("tblHeader");break;default:}return i+(z?z.offsetHeight:0);}.bind(this),0);};
t.prototype._setToolbar=function(A,T){var O=this.getAggregation(A);if(O){O.detachEvent("_change",this._onToolbarPropertyChanged,this);}this.setAggregation(A,T);if(T){T.attachEvent("_change",this._onToolbarPropertyChanged,this);}return this;};
t.prototype._onToolbarPropertyChanged=function(e){if(e.getParameter("name")!=="visible"){return;}var O=this._iStickyValue,N=this.getStickyStyleValue();if(O!==N){var i=this.getDomRef();if(i){var x=i.classList;x.toggle("sapMSticky",!!N);x.remove("sapMSticky"+O);x.toggle("sapMSticky"+N,!!N);}}};
return t;});
sap.ui.predefine('sap/m/ListBaseRenderer',["sap/m/library","sap/ui/Device","sap/ui/core/InvisibleText","./ListItemBaseRenderer"],function(l,D,I,L){"use strict";var a=l.ListGrowingDirection;var b=l.ListKeyboardMode;var T=l.ToolbarDesign;var c={apiVersion:2};c.ModeOrder={None:0,Delete:1,MultiSelect:-1,SingleSelect:1,SingleSelectLeft:-1,SingleSelectMaster:0};
c.render=function(r,C){r.openStart("div",C);r.class("sapMList");if(C.getInset()){r.class("sapMListInsetBG");}r.style("width",C.getWidth());if(C.getBackgroundDesign){r.class("sapMListBG"+C.getBackgroundDesign());}var t=C.getTooltip_AsString();if(t){r.attr("title",t);}var s=C.getStickyStyleValue();if(s){r.class("sapMSticky");r.class("sapMSticky"+s);}this.renderContainerAttributes(r,C);r.openEnd();r.renderControl(C.getAggregation("_messageStrip"));var h=C.getHeaderText();var H=C.getHeaderToolbar();if(H){H.setDesign(T.Transparent,true);H.addStyleClass("sapMListHdr");H.addStyleClass("sapMListHdrTBar");H.addStyleClass("sapMTBHeader-CTX");r.renderControl(H);}else if(h){r.openStart("header",C.getId("header"));r.class("sapMListHdr").class("sapMListHdrText").openEnd();r.text(h);r.close("header");}var o=C.getInfoToolbar();if(o){o.setDesign(T.Info,true);o.addStyleClass("sapMListInfoTBar");r.openStart("div").class("sapMListInfoTBarContainer").openEnd();r.renderControl(o);r.close("div");}var d=C.getItems(),S=C.getShowNoData(),R=C.shouldRenderItems()&&d.length,e=C.getKeyboardMode()==b.Edit?-1:0,u=C.getGrowingDirection()==a.Upwards&&C.getGrowing();if(u){this.renderGrowing(r,C);}this.renderDummyArea(r,C,"before",-1);this.renderListStartAttributes(r,C);r.class("sapMListUl");if(C._iItemNeedsHighlight){r.class("sapMListHighlight");}if(R||S){r.attr("tabindex",e);}r.class("sapMListShowSeparators"+C.getShowSeparators());r.class("sapMListMode"+C.getMode());if(C._iItemNeedsNavigated){r.class("sapMListNavigated");}r.openEnd();this.renderListHeadAttributes(r,C);if(R){if(u){d.reverse();}for(var i=0;i<d.length;i++){r.renderControl(d[i]);}}var v=C.getVisibleItems().length>0;if(S&&(!R||!v)){this.renderNoData(r,C);}this.renderListEndAttributes(r,C);this.renderDummyArea(r,C,"after",e);if(!u){this.renderGrowing(r,C);}if(C.getFooterText()){r.openStart("footer",C.getId("footer")).class("sapMListFtr").openEnd();r.text(C.getFooterText());r.close("footer");}r.close("div");};
c.renderContainerAttributes=function(r,C){};
c.renderListHeadAttributes=function(r,C){};
c.renderListStartAttributes=function(r,C){r.openStart("ul",C.getId("listUl"));r.class("sapMListItems");C.addNavSection(C.getId("listUl"));r.accessibilityState(C,this.getAccessibilityState(C));};
c.getAriaRole=function(C){return"listbox";};
c.getNoDataAriaRole=function(){return null;};
c.getAriaLabelledBy=function(C){var h=C.getHeaderToolbar();if(h){var t=h.getTitleControl();if(t){var s=t.getId();if(C.getAriaLabelledBy().indexOf(s)===-1){return s;}}}else if(C.getHeaderText()){return C.getId("header");}};
c.getAriaDescribedBy=function(C){if(C.getFooterText()){return C.getId("footer");}};
c.getAccessibilityState=function(C){var r=this.getAriaRole(C);return{role:r,multiselectable:(r&&C._bSelectionMode)?C.getMode()=="MultiSelect":undefined,labelledby:{value:this.getAriaLabelledBy(C),append:true},describedby:{value:this.getAriaDescribedBy(C),append:true}};};
c.renderListEndAttributes=function(r,C){r.close("ul");};
c.renderNoData=function(r,C){r.openStart("li",C.getId("nodata"));r.attr("tabindex",C.getKeyboardMode()==b.Navigation?-1:0);var A=this.getNoDataAriaRole();if(A){r.attr("role",A);}r.class("sapMLIB").class("sapMListNoData").class("sapMLIBTypeInactive");L.addFocusableClasses.call(L,r);r.openEnd();r.openStart("div",C.getId("nodata-text")).class("sapMListNoDataText").openEnd();r.text(C.getNoDataText(true));r.close("div");r.close("li");};
c.renderDummyArea=function(r,C,A,t){r.openStart("div",C.getId(A)).attr("tabindex",t);if(D.system.desktop){r.class("sapMListDummyArea");if(A=="after"){r.class("sapMListDummyAreaSticky");}}r.openEnd().close("div");};
c.renderGrowing=function(r,C){var g=C._oGrowingDelegate;if(g){g.render(r);}};
c.getAriaAnnouncement=function(B){return I.getStaticId("sap.m",B);};
return c;},true);
sap.ui.predefine('sap/m/ListItemBase',["sap/ui/base/DataType","sap/ui/events/KeyCodes","sap/ui/model/BindingMode","sap/ui/Device","sap/ui/core/library","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/Icon","sap/ui/core/InvisibleText","sap/ui/core/theming/Parameters","./library","./Button","./CheckBox","./RadioButton","./ListItemBaseRenderer","sap/base/strings/capitalize","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Selectors"],function(D,K,B,a,c,C,I,b,d,T,l,e,f,R,L,g,q){"use strict";var h=l.ListKeyboardMode;var i=l.ListMode;var j=l.ListType;var k=l.ButtonType;var M=c.MessageType;
var m=C.extend("sap.m.ListItemBase",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ListType",group:"Misc",defaultValue:j.Inactive},visible:{type:"boolean",group:"Appearance",defaultValue:true},unread:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",defaultValue:false},counter:{type:"int",group:"Misc",defaultValue:null},highlight:{type:"string",group:"Appearance",defaultValue:"None"},highlightText:{type:"string",group:"Misc",defaultValue:""},navigated:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},detailTap:{deprecated:true},press:{},detailPress:{}},designtime:"sap/m/designtime/ListItemBase.designtime"}});
m.getAccessibilityText=function(o,n){var p=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!o||!o.getVisible||!o.getVisible()){return n?p.getText("CONTROL_EMPTY"):"";}var A;if(o.getAccessibilityInfo){A=o.getAccessibilityInfo();}if(!A||!o.getAccessibilityInfo){A=this.getDefaultAccessibilityInfo(o.getDomRef());}A=q.extend({type:"",description:"",children:[]},A);var t=A.type+" "+A.description+" ",s=o.getTooltip_AsString();if(A.enabled===false){t+=p.getText("CONTROL_DISABLED")+" ";}if(A.editable===false){t+=p.getText("CONTROL_READONLY")+" ";}if(!A.type&&s&&t.indexOf(s)==-1){t=s+" "+t;}A.children.forEach(function(r){t+=m.getAccessibilityText(r)+" ";});t=t.trim();if(n&&!t){t=p.getText("CONTROL_EMPTY");}return t;};
m.getDefaultAccessibilityInfo=function(o){if(!o){return null;}var t=[],N=window.Node,n=window.NodeFilter,p=document.createTreeWalker(o,n.SHOW_TEXT+n.SHOW_ELEMENT);while(p.nextNode()){var r=p.currentNode;if(r.nodeType===N.TEXT_NODE){var s=(r.nodeValue||"").trim();if(s){t.push(s);}}}return{description:t.join(" ")};};
m.prototype.DetailIconURI=I.getIconURI("edit");m.prototype.NavigationIconURI=I.getIconURI("slim-arrow-right");m.prototype.TagName="li";
m.prototype.init=function(){this._active=false;this._bGroupHeader=false;this._bNeedsHighlight=false;this._bNeedsNavigated=false;};
m.prototype.onAfterRendering=function(){this.informList("DOMUpdate",true);this._checkHighlight();this._checkNavigated();};
m.prototype.invalidate=function(){if(!this.bOutput){return;}C.prototype.invalidate.apply(this,arguments);};
m.prototype.getBindingContextPath=function(s){var o=this.getList();if(o&&!s){s=(o.getBindingInfo("items")||{}).model;}var n=this.getBindingContext(s);if(n){return n.getPath();}};
m.prototype.isSelectedBoundTwoWay=function(){var o=this.getBinding("selected");if(o&&o.getBindingMode()==B.TwoWay){return true;}};
m.prototype.getList=function(){var p=this.getParent();if(p&&p.isA("sap.m.ListBase")){return p;}};
m.prototype.getListProperty=function(p,F){var o=this.getList();if(o){p=g(p);return o["get"+p]();}return F;};
m.prototype.informList=function(E,p,P){var o=this.getList();if(o){var s="onItem"+E;if(o[s]){o[s](this,p,P);}}};
m.prototype.informSelectedChange=function(s){var o=this.getList();if(o){o.onItemSelectedChange(this,s);this.bSelectedDelayed=undefined;}else{this.bSelectedDelayed=s;}};
m.prototype.getAccessibilityType=function(o){return o.getText("ACC_CTR_TYPE_OPTION");};
m.prototype.getGroupAnnouncement=function(){return this.$().prevAll(".sapMGHLI:first").text();};
m.prototype.getAccessibilityDescription=function(o){var O=[],t=this.getType(),H=this.getHighlight(),s=this.getTooltip_AsString();if(this.getSelected()){O.push(o.getText("LIST_ITEM_SELECTED"));}if(H!==M.None){var n=this.getHighlightText();if(H in M&&!n){n=o.getText("LIST_ITEM_STATE_"+H.toUpperCase());}O.push(n);}if(this.getUnread()&&this.getListProperty("showUnread")){O.push(o.getText("LIST_ITEM_UNREAD"));}if(this.getCounter()){O.push(o.getText("LIST_ITEM_COUNTER",this.getCounter()));}if(t==j.Navigation){O.push(o.getText("LIST_ITEM_NAVIGATION"));}else{if(t==j.Detail||t==j.DetailAndActive){O.push(o.getText("LIST_ITEM_DETAIL"));}if(t==j.Active||t==j.DetailAndActive){O.push(o.getText("LIST_ITEM_ACTIVE"));}}var G=this.getGroupAnnouncement()||"";if(G){O.push(G);}if(this.getContentAnnouncement){O.push((this.getContentAnnouncement(o)||"").trim());}if(s){O.push(s);}if(this._bAnnounceNotSelected&&this.isSelectable()&&!this.getSelected()){O.push(o.getText("LIST_ITEM_NOT_SELECTED"));}return O.join(" . ");};
m.prototype.getAccessibilityInfo=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{type:this.getAccessibilityType(o),description:this.getAccessibilityDescription(o),focusable:true};};
m.prototype.getMode=function(){return this.getListProperty("mode","");};
m.prototype.updateAccessibilityState=function(A){var t=this.$();if(!t.length){return;}var $=t.parent().children(".sapMLIB");t.attr(q.extend({"aria-setsize":$.length,"aria-posinset":$.index(t)+1},A));};
m.prototype.getDeleteControl=function(n){if(!n||this._oDeleteControl){return this._oDeleteControl;}if(!this.DeleteIconURI){m.prototype.DeleteIconURI=I.getIconURI(T.get({name:"_sap_m_ListItemBase_DeleteIcon"})||"decline");}this._oDeleteControl=new e({id:this.getId()+"-imgDel",icon:this.DeleteIconURI,type:k.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_DELETE")}).addStyleClass("sapMLIBIconDel sapMLIBSelectD").setParent(this,null,true).attachPress(function(E){this.informList("Delete");},this);this._oDeleteControl._bExcludeFromTabChain=true;this._oDeleteControl.useEnabledPropagator(false);return this._oDeleteControl;};
m.prototype.onThemeChanged=function(){m.prototype.DeleteIconURI=I.getIconURI(T.get({name:"_sap_m_ListItemBase_DeleteIcon"}));if(this._oDeleteControl){this._oDeleteControl.setIcon(this.DeleteIconURI);}};
m.prototype.getDetailControl=function(n){if(!n||this._oDetailControl){return this._oDetailControl;}this._oDetailControl=new e({id:this.getId()+"-imgDet",icon:this.DetailIconURI,type:k.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_EDIT")}).addStyleClass("sapMLIBType sapMLIBIconDet").setParent(this,null,true).attachPress(function(){this.fireDetailTap();this.fireDetailPress();},this);this._oDetailControl._bExcludeFromTabChain=true;this._oDetailControl.useEnabledPropagator(false);return this._oDetailControl;};
m.prototype.getNavigationControl=function(n){if(!n||this._oNavigationControl){return this._oNavigationControl;}this._oNavigationControl=new b({id:this.getId()+"-imgNav",src:this.NavigationIconURI,useIconTooltip:false,noTabStop:true}).setParent(this,null,true).addStyleClass("sapMLIBType sapMLIBImgNav");return this._oNavigationControl;};
m.prototype.getSingleSelectControl=function(n){if(!n||this._oSingleSelectControl){n&&this._oSingleSelectControl.setSelected(this.getSelected());return this._oSingleSelectControl;}this._oSingleSelectControl=new R({id:this.getId()+"-selectSingle",groupName:this.getListProperty("id")+"_selectGroup",activeHandling:false,selected:this.getSelected(),ariaLabelledBy:d.getStaticId("sap.m","LIST_ITEM_SELECTION")}).addStyleClass("sapMLIBSelectS").setParent(this,null,true).setTabIndex(-1).attachSelect(function(E){var s=E.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);this._oSingleSelectControl.useEnabledPropagator(false);return this._oSingleSelectControl;};
m.prototype.getMultiSelectControl=function(n){if(!n||this._oMultiSelectControl){n&&this._oMultiSelectControl.setSelected(this.getSelected());return this._oMultiSelectControl;}this._oMultiSelectControl=new f({id:this.getId()+"-selectMulti",activeHandling:false,selected:this.getSelected(),ariaLabelledBy:d.getStaticId("sap.m","LIST_ITEM_SELECTION")}).addStyleClass("sapMLIBSelectM").setParent(this,null,true).setTabIndex(-1).addEventDelegate({onkeydown:function(E){this.informList("KeyDown",E);},onkeyup:function(E){this.informList("KeyUp",E);}},this).attachSelect(function(E){var s=E.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);this._oMultiSelectControl.useEnabledPropagator(false);return this._oMultiSelectControl;};
m.prototype.getModeControl=function(n){var s=this.getMode();if(!s||s==i.None){return;}if(s==i.Delete){return this.getDeleteControl(n);}if(s==i.MultiSelect){return this.getMultiSelectControl(n);}return this.getSingleSelectControl(n);};
m.prototype.getTypeControl=function(n){var t=this.getType();if(t==j.Detail||t==j.DetailAndActive){return this.getDetailControl(n);}if(t==j.Navigation){return this.getNavigationControl(n);}};
m.prototype.destroyControls=function(n){n.forEach(function(s){s="_o"+s+"Control";if(this[s]){this[s].destroy("KeepDom");this[s]=null;}},this);};
m.prototype.isActionable=function(){return this.isIncludedIntoSelection()||(this.getType()!=j.Inactive&&this.getType()!=j.Detail);};
m.prototype.exit=function(){this._oLastFocused=null;this._checkHighlight(false);this._checkNavigated(false);this.setActive(false);this.destroyControls(["Delete","SingleSelect","MultiSelect","Detail","Navigation"]);};
m.prototype.setHighlight=function(v){if(v==null){v=M.None;}else if(!D.getType("sap.ui.core.MessageType").isValid(v)&&!D.getType("sap.ui.core.IndicationColor").isValid(v)){throw new Error('"'+v+'" is not a value of the enums sap.ui.core.MessageType or sap.ui.core.IndicationColor for property "highlight" of '+this);}return this.setProperty("highlight",v);};
m.prototype.isSelectable=function(){var s=this.getMode();return!(s==i.None||s==i.Delete);};
m.prototype.getSelected=function(){if(this.isSelectable()){return this.getProperty("selected");}return false;};
m.prototype.isSelected=m.prototype.getSelected;
m.prototype.setSelected=function(s,n){s=this.validateProperty("selected",s);if(!this.isSelectable()||s==this.getSelected()){return this;}if(!n){this.informSelectedChange(s);}var S=this.getModeControl();if(S){S.setSelected(s);}this.updateSelectedDOM(s,this.$());this.setProperty("selected",s,true);return this;};
m.prototype.updateSelectedDOM=function(s,t){t.toggleClass("sapMLIBSelected",s);t.attr("aria-selected",s);};
m.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(!p){this._bGroupHeader=false;return;}this.informList("Inserted",this.bSelectedDelayed);return this;};
m.prototype.setBindingContext=function(){C.prototype.setBindingContext.apply(this,arguments);this.informList("BindingContextSet");return this;};
m.prototype.isGroupHeader=function(){return this._bGroupHeader;};
m.prototype.isIncludedIntoSelection=function(){if(!this.isSelectable()){return false;}var s=this.getMode();return s==i.SingleSelectMaster||(this.getListProperty("includeItemInSelection")&&(s==i.SingleSelectLeft||s==i.SingleSelect||s==i.MultiSelect));};
m.prototype._checkHighlight=function(n){if(n==undefined){n=(this.getVisible()&&this.getHighlight()!=M.None);}if(this._bNeedsHighlight!=n){this._bNeedsHighlight=n;this.informList("HighlightChange",n);}};
m.prototype._checkNavigated=function(n){if(n==undefined){n=(this.getVisible()&&this.getNavigated());}if(this._bNeedsNavigated!=n){this._bNeedsNavigated=n;this.informList("NavigatedChange",n);}};
m.prototype.hasActiveType=function(){var t=this.getType();return(t==j.Active||t==j.Navigation||t==j.DetailAndActive);};
m.prototype.setActive=function(A){if(A==this._active){return this;}if(A&&this.getListProperty("activeItem")){return this;}var t=this.$();this._active=A;this._activeHandling(t);if(this.getType()==j.Navigation){this._activeHandlingNav(t);}if(A){this._activeHandlingInheritor(t);}else{this._inactiveHandlingInheritor(t);}this.informList("ActiveChange",A);};
m.detectTextSelection=function(o){var s=window.getSelection(),t=s.toString().replace("\n","");return t&&q.contains(o,s.focusNode);};
m.prototype.ontap=function(E){if(this._eventHandledByControl){return E.setMarked();}if(m.detectTextSelection(this.getDomRef())){return;}if(this.isIncludedIntoSelection()){if(this.getMode()==i.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}}else if(this.hasActiveType()){window.clearTimeout(this._timeoutIdStart);window.clearTimeout(this._timeoutIdEnd);this.setActive(true);if(a.os.ios){this.focus();}setTimeout(function(){this.setActive(false);}.bind(this),180);setTimeout(function(){this.fireTap();this.firePress();}.bind(this),0);}this.informList("Press",E.srcControl);};
m.prototype.ontouchstart=function(E){this._eventHandledByControl=E.isMarked();var t=E.targetTouches[0];this._touchedY=t.clientY;this._touchedX=t.clientX;if(this._eventHandledByControl||E.touches.length!=1||!this.hasActiveType()){if(this.getListProperty("includeItemInSelection")&&this.getList()._mRangeSelection){E.preventDefault();}return;}this._timeoutIdStart=setTimeout(function(){this.setActive(true);}.bind(this),100);};
m.prototype.ontouchmove=function(E){if((this._active||this._timeoutIdStart)&&(Math.abs(this._touchedY-E.targetTouches[0].clientY)>10||Math.abs(this._touchedX-E.targetTouches[0].clientX)>10)){clearTimeout(this._timeoutIdStart);this._timeoutIdStart=null;this._timeoutIdEnd=null;this.setActive(false);}};
m.prototype.ontouchend=function(E){if(this.hasActiveType()){this._timeoutIdEnd=setTimeout(function(){this.setActive(false);}.bind(this),100);}};
m.prototype.ontouchcancel=m.prototype.ontouchend;m.prototype.ondragend=m.prototype.ontouchend;
m.prototype._activeHandlingNav=function(){};
m.prototype._activeHandlingInheritor=function(){};
m.prototype._inactiveHandlingInheritor=function(){};
m.prototype._activeHandling=function(t){t.toggleClass("sapMLIBActive",this._active);if(a.system.desktop&&this.isActionable()){t.toggleClass("sapMLIBHoverable",!this._active);}};
m.prototype.onsapspace=function(E){if(E.srcControl!==this){return;}E.preventDefault();if(E.isMarked()||!this.isSelectable()){return;}if(this.getMode()==i.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}E.setMarked();};
m.prototype.onsapenter=function(E){var o=this.getList();if(E.isMarked()||!o){return;}if(E.srcControl!==this&&o.getKeyboardMode()==h.Edit){o.setKeyboardMode(h.Navigation);this._switchFocus(E);return;}if(E.srcControl!==this){return;}if(this.isIncludedIntoSelection()){this.onsapspace(E);}else if(this.hasActiveType()){E.setMarked();this.setActive(true);setTimeout(function(){this.setActive(false);}.bind(this),180);setTimeout(function(){this.fireTap();this.firePress();}.bind(this),0);}o.onItemPress(this,E.srcControl);};
m.prototype.onsapdelete=function(E){if(E.isMarked()||E.srcControl!==this||this.getMode()!=i.Delete){return;}this.informList("Delete");E.preventDefault();E.setMarked();};
m.prototype._switchFocus=function(E){var o=this.getList();if(!o){return;}var t=this.getTabbables();if(E.srcControl!==this){o._iLastFocusPosOfItem=t.index(E.target);this.focus();}else if(t.length){var F=o._iLastFocusPosOfItem||0;F=t[F]?F:-1;t.eq(F).trigger("focus");}E.preventDefault();E.setMarked();};
m.prototype.onkeydown=function(E){if(E.isMarked()){return;}if(E.which==K.F7){this._switchFocus(E);return;}if(E.which==K.F2){if(E.srcControl===this&&this.getType().indexOf("Detail")==0&&this.hasListeners("detailPress")||this.hasListeners("detailTap")){this.fireDetailTap();this.fireDetailPress();E.preventDefault();E.setMarked();}else{var o=this.getList();if(o){this.$().prop("tabIndex",-1);o.setKeyboardMode(o.getKeyboardMode()==h.Edit?h.Navigation:h.Edit);this._switchFocus(E);}}}if(E.srcControl!==this){return;}this.informList("KeyDown",E);};
m.prototype.onkeyup=function(E){if(E.isMarked()||E.srcControl!==this){return;}this.informList("KeyUp",E);};
m.prototype.onsapupmodifiers=function(E){if(E.isMarked()||E.srcControl!==this){return;}this.informList("UpDownModifiers",E,-1);};
m.prototype.onsapdownmodifiers=function(E){if(E.isMarked()||E.srcControl!==this){return;}this.informList("UpDownModifiers",E,1);};
m.prototype.getTabbables=function(){return this.$().find(":sapTabbable");};
m.prototype.onsaptabnext=function(E){var o=this.getList();if(!o||E.isMarked()||o.getKeyboardMode()==h.Edit){return;}var n=this.getTabbables().get(-1)||this.getDomRef();if(E.target===n){o.forwardTab(true);E.setMarked();}};
m.prototype.onsaptabprevious=function(E){var o=this.getList();if(!o||E.isMarked()||o.getKeyboardMode()==h.Edit){return;}if(E.target===this.getDomRef()){o.forwardTab(false);E.setMarked();}};
m.prototype.onfocusin=function(E){var o=this.getList();if(!o||E.isMarked()){return;}this.informList("FocusIn",E.srcControl);E.setMarked();if(E.srcControl===this){return;}if(o.getKeyboardMode()==h.Edit||!q(E.target).is(":sapFocusable")){return;}setTimeout(o["setItemFocusable"].bind(o,this),0);};
m.prototype.onsapup=function(E){if(E.isMarked()||E.srcControl===this||this.getListProperty("keyboardMode")===h.Navigation){return;}this.informList("ArrowUpDown",E);};
m.prototype.oncontextmenu=function(E){if(this._bGroupHeader){return;}if(q(document.activeElement).is(":focusable")&&document.activeElement!==this.getDomRef()&&E.srcControl!==this.getModeControl()){return;}this.informList("ContextMenu",E);};
m.prototype.onsapdown=m.prototype.onsapup;return m;});
sap.ui.predefine('sap/m/ListItemBaseRenderer',["./library","sap/ui/core/Core","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/InvisibleRenderer"],function(l,C,D,I,a){"use strict";var L=l.ListType;var b=l.ListMode;var c={apiVersion:2};
c.renderInvisible=function(r,o){a.render(r,o,o.TagName);};
c.renderHighlight=function(r,o){var h=o.getHighlight();if(h=="None"){return;}r.openStart("div");r.class("sapMLIBHighlight");r.class("sapMLIBHighlight"+h);r.openEnd();r.close("div");};
c.isModeMatched=function(m,o){var O=(sap.ui.require("sap/m/ListBaseRenderer")||{}).ModeOrder||{};return O[m]==o;};
c.renderMode=function(r,o,O){var m=o.getMode();if(!this.isModeMatched(m,O)){return;}var M=o.getModeControl(true);if(M){this.renderModeContent(r,o,M);}};
c.renderModeContent=function(r,o,m){this.decorateMode(m,o);r.renderControl(m);};
c.decorateMode=function(m,o){m.removeStyleClass("sapMLIBSelectAnimation sapMLIBUnselectAnimation");if(!C.getConfiguration().getAnimation()||!o.getListProperty("modeAnimationOn")){return;}var M=o.getMode(),s=o.getListProperty("lastMode");if(!s||s==M){return;}if(M==b.None){m.addStyleClass("sapMLIBUnselectAnimation");}else{m.addStyleClass("sapMLIBSelectAnimation");}};
c.renderCounter=function(r,o){var i=o.getCounter();if(i){this.renderCounterContent(r,o,i);}};
c.renderCounterContent=function(r,o,i){r.openStart("div",o.getId()+"-counter");r.attr("aria-label",C.getLibraryResourceBundle("sap.m").getText("LIST_ITEM_COUNTER",i));r.class("sapMLIBCounter");r.openEnd();r.text(i);r.close("div");};
c.renderType=function(r,o){var t=o.getTypeControl(true);if(t){r.renderControl(t);}};
c.openItemTag=function(r,o){r.openStart(o.TagName,o);};
c.closeItemTag=function(r,o){r.close(o.TagName);};
c.renderTabIndex=function(r,o){r.attr("tabindex","-1");};
c.renderTooltip=function(r,o){var t=o.getTooltip_AsString();if(t){r.attr("title",t);}};
c.addFocusableClasses=function(r,o){if(D.system.desktop){r.class("sapMLIBFocusable");this.addLegacyOutlineClass(r,o);}};
c.addLegacyOutlineClass=function(r,o){};
c.getAriaAnnouncement=function(k,B){return I.getStaticId("sap.m",B||"LIST_ITEM_"+k.toUpperCase());};
c.getAriaRole=function(o){return"option";};
c.getAriaLabelledBy=function(o){if(!o.getContentAnnouncement&&o.getAriaLabelledBy().length){return o.getId();}};
c.getAriaDescribedBy=function(o){if(o.getContentAnnouncement){return"";}var d=[],t=o.getType();if(o.getListProperty("showUnread")&&o.getUnread()){d.push(this.getAriaAnnouncement("unread"));}if(o.getMode()==b.Delete){d.push(this.getAriaAnnouncement("delete"));}if(t==L.Navigation){d.push(this.getAriaAnnouncement("navigation"));}else{if(t==L.Detail||t==L.DetailAndActive){d.push(this.getAriaAnnouncement("detail"));}if(t==L.Active||t==L.DetailAndActive){d.push(this.getAriaAnnouncement("active"));}}return d.join(" ");};
c.getAccessibilityState=function(o){var A=this.getAriaLabelledBy(o),s=this.getAriaDescribedBy(o),m={role:this.getAriaRole(o)};if(o.isSelectable()){m.selected=o.getProperty("selected");}if(A){m.labelledby={value:A.trim(),append:true};}if(s){m.describedby={value:s.trim(),append:true};}if(o.getNavigated()){m.current=true;}return m;};
c.renderLIContent=function(r,o){};
c.renderLIAttributes=function(r,o){};
c.renderContentFormer=function(r,o){this.renderHighlight(r,o);this.renderMode(r,o,-1);};
c.renderContentLatter=function(r,o){this.renderCounter(r,o);this.renderType(r,o);this.renderMode(r,o,1);this.renderNavigated(r,o);};
c.renderLIContentWrapper=function(r,o){r.openStart("div",o.getId()+"-content").class("sapMLIBContent").openEnd();this.renderLIContent(r,o);r.close("div");};
c.renderNavigated=function(r,o){if(!o.getNavigated()){return;}r.openStart("div");r.class("sapMLIBNavigated");r.openEnd();r.close("div");};
c.render=function(r,o){if(!o.getVisible()){this.renderInvisible(r,o);return false;}this.openItemTag(r,o);r.class("sapMLIB");r.class("sapMLIB-CTX");r.class("sapMLIBShowSeparator");r.class("sapMLIBType"+o.getType());if(D.system.desktop&&o.isActionable()){r.class("sapMLIBActionable");r.class("sapMLIBHoverable");}if(o.getSelected()){r.class("sapMLIBSelected");}if(o.getListProperty("showUnread")&&o.getUnread()){r.class("sapMLIBUnread");}this.addFocusableClasses(r,o);this.renderTooltip(r,o);this.renderTabIndex(r,o);if(C.getConfiguration().getAccessibility()){r.accessibilityState(o,this.getAccessibilityState(o));}this.renderLIAttributes(r,o);r.openEnd();this.renderContentFormer(r,o);this.renderLIContentWrapper(r,o);this.renderContentLatter(r,o);this.closeItemTag(r,o);};
return c;},true);
sap.ui.predefine('sap/m/ListRenderer',["sap/ui/core/Renderer","./ListBaseRenderer"],function(R,L){"use strict";var a=R.extend(L);a.apiVersion=2;
a.getNoDataAriaRole=function(){return"option";};
return a;},true);
sap.ui.predefine('sap/m/MaskEnabler',['sap/ui/core/Control','./InputBase','sap/ui/Device','sap/ui/core/library','sap/ui/core/IconPool',"sap/ui/events/KeyCodes","sap/base/Log","sap/ui/thirdparty/jquery","sap/m/MaskInputRule","sap/ui/dom/jquery/cursorPos"],function(C,I,D,c,a,K,L,q,M){"use strict";var T=c.TextDirection;var b=function(){var E='^';this.init=b.init=function(){I.prototype.init.call(this);this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;this._bSkipSetupMaskVariables=null;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._setDefaultRules();this._setupMaskVariables();};this.exit=b.exit=function(){this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;this._bSkipSetupMaskVariables=null;};this.onBeforeRendering=function(){if(this._isMaskEnabled()){var v=this._validateDependencies();if(v){L.warning("Invalid mask input: "+v);}}I.prototype.onBeforeRendering.apply(this,arguments);this.getShowClearIcon&&this.getShowClearIcon()&&this._getClearIcon().setVisible(this.getProperty("effectiveShowClearIcon"));};this.onAfterRendering=function(){I.prototype.onAfterRendering.apply(this,arguments);};this.onfocusin=b.onfocusin=function(o){this._sOldInputValue=this._getInputValue();I.prototype.onfocusin.apply(this,arguments);if(this._isMaskEnabled()){if(!this._oTempValue.differsFromOriginal()||!this._isValidInput(this._sOldInputValue)){this._applyMask();}this._positionCaret(true);}};this.onfocusout=function(o){if(this._isMaskEnabled()){this.bFocusoutDueRendering=this.bRenderingPhase;this.removeStyleClass("sapMFocus");q(document).off('.sapMIBtouchstart');if(this.bRenderingPhase){return;}this.closeValueStateMessage();this._inputCompletedHandler();}else{this._inputCompletedHandlerNoMask();I.prototype.onfocusout.apply(this,arguments);}};this.oninput=function(o){if(this._isChromeOnAndroid()){this._onInputForAndroidHandler(o);return;}I.prototype.oninput.apply(this,arguments);if(this._isMaskEnabled()){this._applyMask();this._positionCaret(false);}};this.onkeypress=function(o){if(this._isMaskEnabled()){this._keyPressHandler(o);}if(this.getDOMValue()!==""){this._setClearIconVisibility();}};this.onkeydown=b.onkeydown=function(o){if(this._isMaskEnabled()){var k=this._parseKeyBoardEvent(o);I.prototype.onkeydown.apply(this,arguments);this._keyDownHandler(o,k);if(this.getDOMValue()!==""){this._setClearIconVisibility();}}else{var k=this._parseKeyBoardEvent(o);if(k.bEnter){this._inputCompletedHandlerNoMask();}I.prototype.onkeydown.apply(this,arguments);}};this.onsapenter=function(o){};this.onsapfocusleave=function(o){};this.onsapescape=function(o){if(this._oTempValue._aContent.join("")!==this._oTempValue._aInitial.join("")){I.prototype.onsapescape.call(this,o);}};this._setClearIconVisibility=function(s){var f=s!==undefined?s:!this._isValueEmpty();if(this.getShowClearIcon&&this.getShowClearIcon()){this.setProperty("effectiveShowClearIcon",f);this._getClearIcon().setVisible(this.getProperty("effectiveShowClearIcon"));}};this._getClearIcon=function(){if(this._oClearButton){return this._oClearButton;}this._oClearButton=this.addEndIcon({src:a.getIconURI("decline"),noTabStop:true,visible:false,alt:this._oRb.getText("INPUT_CLEAR_ICON_ALT"),useIconTooltip:false,press:function(){if(!this._isValueEmpty()){this.fireChange({value:""});this.setValue("");this.setProperty("effectiveShowClearIcon",false);this._getClearIcon().setVisible(false);setTimeout(function(){if(D.system.desktop){this.focus();}},0);}}.bind(this)});return this._oClearButton;};this._isValueEmpty=function(){var v=this.getDOMValue(),p=this._oTempValue._aInitial.join('');return v==p;};this.getDOMValue=function(){return this._$input.val();};this.setValue=b.setValue=function(v){v=this.validateProperty('value',v);I.prototype.setValue.call(this,v);this._sOldInputValue=v;if(this._isMaskEnabled()){if(!this._oTempValue){this._setupMaskVariables();}if(this._oTempValue._aInitial.join('')!==v){this._applyRules(v);}}this._setClearIconVisibility(v!=="");return this;};this.addAggregation=function(A,o,s){if(A==="rules"){if(!this._validateRegexAgainstPlaceHolderSymbol(o)){return this;}this._removeRuleWithSymbol(o.getMaskFormatSymbol());C.prototype.addAggregation.apply(this,arguments);if(!this._bSkipSetupMaskVariables){this._setupMaskVariables();}return this;}return C.prototype.addAggregation.apply(this,arguments);};this.insertAggregation=function(A,o,i,s){if(A==="rules"){if(!this._validateRegexAgainstPlaceHolderSymbol(o)){return this;}this._removeRuleWithSymbol(o.getMaskFormatSymbol());C.prototype.insertAggregation.apply(this,arguments);this._setupMaskVariables();return this;}return C.prototype.insertAggregation.apply(this,arguments);};this._validateRegexAgainstPlaceHolderSymbol=function(r){if(new RegExp(r.getRegex()).test(this.getPlaceholderSymbol())){L.error("Rejecting input mask rule because it includes the currently set placeholder symbol.");return false;}return true;};this.setPlaceholderSymbol=function(s){var S;if(!/^.$/i.test(s)){L.error("Invalid placeholder symbol string given");return this;}S=this.getRules().some(function(r){return new RegExp(r.getRegex()).test(s);});if(S){L.error("Rejecting placeholder symbol because it is included as a regex in an existing mask input rule.");}else{this.setProperty("placeholderSymbol",s);this._setupMaskVariables();}return this;};this.setMask=function(m){if(!m){var s="Setting an empty mask is pointless. Make sure you set it with a non-empty value.";L.warning(s);return this;}this.setProperty("mask",m,true);this._setupMaskVariables();return this;};this._isCharAllowed=function(s,i){return this._oRules.applyCharAt(s,i);};this._feedReplaceChar=function(s,p,f){return s;};this._inputCompletedHandlerNoMask=function(){var v=this._getInputValue();if(this._sOldInputValue!==v){I.prototype.setValue.call(this,this._getAlteredUserInputValue?this._getAlteredUserInputValue(v):v);this._sOldInputValue=v;if(this.onChange&&!this.onChange({value:v})){this.fireChangeEvent(v);}}};var d=function(f){this._aInitial=f.slice(0);this._aContent=f;};d.prototype.setCharAt=function(s,p){this._aContent[p]=s;};d.prototype.charAt=function(p){return this._aContent[p];};d.prototype.toString=function(){return this._aContent.join('');};d.prototype.differsFromOriginal=function(){return this.differsFrom(this._aInitial);};d.prototype.differsFrom=function(v){var i=0;if(v.length!==this._aContent.length){return true;}for(;i<v.length;i++){if(v[i]!==this._aContent[i]){return true;}}return false;};d.prototype.getSize=function(){return this._aContent.length;};var e=function(r){this._aRules=r;};e.prototype.nextTo=function(i){if(typeof i==="undefined"){i=-1;}do{i++;}while(i<this._aRules.length&&!this._aRules[i]);return i;};e.prototype.previousTo=function(i){do{i--;}while(!this._aRules[i]&&i>0);return i;};e.prototype.hasRuleAt=function(i){return!!this._aRules[i];};e.prototype.applyCharAt=function(s,i){return this._aRules[i].test(s);};this._setDefaultRules=function(){this._bSkipSetupMaskVariables=true;this.addRule(new M({maskFormatSymbol:"a",regex:"[A-Za-z]"}),true);this.addRule(new M({maskFormatSymbol:"9",regex:"[0-9]"}),true);this._bSkipSetupMaskVariables=false;};this._validateDependencies=function(){var p=this.getPlaceholderSymbol(),r=this.getRules(),m=[],f=[];if(!this.getMask()){f.push("Empty mask");}if(r.length){m=[];r.every(function(R){var s=R.getMaskFormatSymbol(),g=s!==p,h;h=!m.some(function(S){return s===S;});m.push(s);if(!g){f.push("Placeholder symbol is the  same as the existing rule's mask format symbol");}if(!h){f.push("Duplicated rule's maskFormatSymbol ["+s+"]");}return g&&h;});}return f.length?f.join(". "):null;};this._removeRuleWithSymbol=function(s){var S=this._findRuleBySymbol(s,this.getRules());if(S){this.removeAggregation('rules',S.oRule);S.oRule.destroy();}};this._findRuleBySymbol=function(m,r){var R=null;if(typeof m!=="string"||m.length!==1){L.error(m+" is not a valid mask rule symbol");return null;}q.each(r,function(i,o){if(o.getMaskFormatSymbol()===m){R={oRule:o,iIndex:i};return false;}});return R;};this._getTextSelection=function(){var _=q(this.getFocusDomRef());if(!_&&(_.length===0||_.is(":hidden"))){return{};}return{iFrom:_[0].selectionStart,iTo:_[0].selectionEnd,bHasSelection:(_[0].selectionEnd-_[0].selectionStart!==0)};};this._setCursorPosition=function(p){if(p<0){p=0;}q(this.getFocusDomRef()).cursorPos(p);return this;};this._getCursorPosition=function(){return q(this.getFocusDomRef()).cursorPos();};this._setupMaskVariables=function(){var r=this.getRules(),m=this.getMask(),s=this._getSkipIndexes(m),f=this._getMaskArray(m,s),p=this.getPlaceholderSymbol(),i=this._buildMaskValueArray(f,p,r,s),t=this._buildRules(f,r,s);this._oTempValue=new d(i);this._iMaskLength=t.length;this._oRules=new e(t);this._iUserInputStartPosition=this._oRules.nextTo();};this._getMaskArray=function(m,s){var l=Array.isArray(s)?s.length:0,f=(m)?m.split(""):[],i;for(i=0;i<l;i++){f.splice(s[i],1);}return f;};this._getSkipIndexes=function(m){var l=(m)?m.length:0,i,s=[],p=0,f=false;for(i=0;i<l;i++){if(m[i]===E&&!f){s.push(i-p);f=true;p++;}else{f=false;}}return s;};this._applyMask=function(){var m=this._getInputValue();if(!this.getEditable()){return;}this._applyAndUpdate(m);};this._resetTempValue=function(f,t){var i,p=this.getPlaceholderSymbol();if(typeof f==="undefined"||f===null){f=0;t=this._oTempValue.getSize()-1;}for(i=f;i<=t;i++){if(this._oRules.hasRuleAt(i)){this._oTempValue.setCharAt(p,i);}}};this._applyAndUpdate=function(m){this._applyRules(m);this.updateDomValue(this._oTempValue.toString());};this._findFirstPlaceholderPosition=function(){return this._oTempValue.toString().indexOf(this.getPlaceholderSymbol());};this._applyRules=function(i){var s,f=0,m,p=this.getPlaceholderSymbol(),g;if(this._oTempValue.toString()===i){return;}for(m=0;m<this._iMaskLength;m++){if(this._oRules.hasRuleAt(m)){this._oTempValue.setCharAt(p,m);g=false;if(i.length){do{s=i.charAt(f);f++;if(this._oRules.applyCharAt(s,m)){this._oTempValue.setCharAt(s,m);g=true;}}while(!g&&(f<i.length));}if(!g){this._resetTempValue(m+1,this._iMaskLength-1);break;}}else{if(this._oTempValue.charAt(m)===i.charAt(f)){f++;}}}};this._keyPressHandler=function(o,k){var s,p,f;if(!this.getEditable()){return;}k=k||this._parseKeyBoardEvent(o);if(k.bCtrlKey||k.bAltKey||k.bMetaKey||k.bBeforeSpace){return;}s=this._getTextSelection();if(!k.bEnter&&!k.bShiftLeftOrRightArrow&&!k.bHome&&!k.bEnd&&!(k.bShift&&k.bDelete)&&!(k.bCtrlKey&&k.bInsert)&&!(k.bShift&&k.bInsert)){if(s.bHasSelection){this._resetTempValue(s.iFrom,s.iTo-1);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,s.iFrom));}p=this._oRules.nextTo(s.iFrom-1);if(p<this._iMaskLength){f=this._feedReplaceChar(k.sChar,p,this._getInputValue());this._feedNextString(f,p);}o.preventDefault();}};this.oncut=function(o){var s=this._getTextSelection(),m=this._getMinBrowserDelay(),B=s.iFrom,i=s.iTo;I.prototype.oncut(o);if(!s.bHasSelection||!this._isMaskEnabled()){return;}i=i-1;this._resetTempValue(B,i);setTimeout(function u(v,p,O){this._oTempValue._aContent=O;this.updateDomValue(v);setTimeout(this._setCursorPosition.bind(this,p),m);}.bind(this,this._oTempValue.toString(),Math.max(this._iUserInputStartPosition,B),this._oTempValue._aContent.slice(0)),m);};this._keyDownHandler=function(o,k){var s,S,i,n,k=k||this._parseKeyBoardEvent(o);if(!this.getEditable()){return;}if(!k.bShift&&(k.bArrowRight||k.bArrowLeft)){i=this._getCursorPosition();S=this._getTextSelection();s=this._determineArrowKeyDirection(k,S);if(this._isRtlMode()&&S.bHasSelection){n=this._determineRtlCaretPositionFromSelection(s);}else{n=this._oRules[s](i);}if(this._isWebkitProblematicCase()){n=this._fixWebkitBorderPositions(n,s);}this._setCursorPosition(n);o.preventDefault();}else if(k.bEscape){this._applyAndUpdate(this._sOldInputValue);this._positionCaret(true);o.preventDefault();}else if(k.bEnter){this._inputCompletedHandler(o);}else if((k.bCtrlKey&&k.bInsert)||(k.bShift&&k.bInsert)){I.prototype.onkeydown.apply(this,arguments);}else if((!k.bShift&&k.bDelete)||k.bBackspace){this._revertKey(k);o.preventDefault();}else if(this._isChromeOnAndroid()){this._oKeyDownStateAndroid={sValue:this._oTempValue.toString(),iCursorPosition:this._getCursorPosition(),oSelection:this._getTextSelection()};}};this._revertKey=function(k,s){s=s||this._getTextSelection();var B=s.iFrom,i=s.iTo;if(!s.bHasSelection){if(k.bBackspace){B=this._oRules.previousTo(B);}}if(k.bBackspace||(k.bDelete&&s.bHasSelection)){i=i-1;}this._resetTempValue(B,i);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,B));};this._feedNextString=function(n,p){var N,A=false,f=n.split(""),s;while(f.length){s=f.splice(0,1)[0];if(this._oRules.applyCharAt(s,p)){A=true;this._oTempValue.setCharAt(s,p);p=this._oRules.nextTo(p);}}if(A){N=p;this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(N);}};this._inputCompletedHandler=function(){var n=this._getInputValue(),t,v,f,g;if(this._oTempValue.differsFrom(n)){this._applyAndUpdate(n);}t=this._oTempValue.differsFromOriginal();v=t?this._oTempValue.toString():"";f=!this._sOldInputValue||!this.getValue();g=!n;if(f&&(g||!t)){this.updateDomValue("");return;}if(this._sOldInputValue!==this._oTempValue.toString()){I.prototype.setValue.call(this,this._getAlteredUserInputValue?this._getAlteredUserInputValue(v):v);this._sOldInputValue=v;if(this.onChange&&!this.onChange({value:v})){this.fireChangeEvent(v);}}};this._buildMaskValueArray=function(m,p,r,s){return m.map(function(f,i){var n=s.indexOf(i)===-1,R=this._findRuleBySymbol(f,r);return(n&&R)?p:f;},this);};this._buildRules=function(m,r,s){var t=[],S,l=m.length,i=0;for(;i<l;i++){if(s.indexOf(i)===-1){S=this._findRuleBySymbol(m[i],r);t.push(S?new RegExp(S.oRule.getRegex()):null);}else{t.push(null);}}return t;};this._parseKeyBoardEvent=function(o){var p=o.which||o.keyCode,k=K,A=p===k.ARROW_RIGHT,f=p===k.ARROW_LEFT,s=o.shiftKey;return{iCode:p,sChar:String.fromCharCode(p),bCtrlKey:o.ctrlKey,bAltKey:o.altKey,bMetaKey:o.metaKey,bShift:s,bInsert:p===K.INSERT,bBackspace:p===k.BACKSPACE,bDelete:p===k.DELETE,bEscape:p===k.ESCAPE,bEnter:p===k.ENTER,bIphoneEscape:(D.system.phone&&D.os.ios&&p===127),bArrowRight:A,bArrowLeft:f,bHome:p===K.HOME,bEnd:p===K.END,bShiftLeftOrRightArrow:s&&(f||A),bBeforeSpace:p<k.SPACE};};this._positionCaret=function(s){var m=this.getMask(),i=this._getMinBrowserDelay(),f;clearTimeout(this._iCaretTimeoutId);f=this._findFirstPlaceholderPosition();if(f<0){f=m.length;}this._iCaretTimeoutId=setTimeout(function(){if(this.getFocusDomRef()!==document.activeElement){return;}if(s&&(f===(m.length))){this.selectText(0,f);}else{this._setCursorPosition(f);}}.bind(this),i);this._setClearIconVisibility();};this._getMinBrowserDelay=function(){return 4;};this._isValidInput=function(s){var l=s.length,i=0,f;for(;i<l;i++){f=s[i];if(this._oRules.hasRuleAt(i)&&(!this._oRules.applyCharAt(f,i)&&f!==this.getPlaceholderSymbol())){return false;}if(!this._oRules.hasRuleAt(i)&&f!==this._oTempValue.charAt(i)){return false;}}return true;};this._isRtlChar=function(s){var l='A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02B8\u0300-\u0590\u0800-\u1FFF'+'\u2C00-\uFB1C\uFDFE-\uFE6F\uFEFD-\uFFFF',r='\u0591-\u07FF\uFB1D-\uFDFD\uFE70-\uFEFC',f=new RegExp('^[^'+l+']*['+r+']');return f.test(s);};this._fixWebkitBorderPositions=function(i,s){var t=this._oTempValue.toString().length;if(s==='nextTo'){if(i===0||i===t||i===1){i=0;}else if(i===t+1){i=1;}}else{if(i===0||i===t-1){i=t;}else if(i===-1||i===t){i=t-1;}}return i;};this._containsRtlChars=function(){var t=this._oTempValue.toString(),f=false;for(var i=0;i<t.length;i++){f=this._isRtlChar(t[i]);}return f;};this._isRtlMode=function(){return sap.ui.getCore().getConfiguration().getRTL()||(this.getTextDirection()===T.RTL);};this._isWebkitProblematicCase=function(){return D.browser.webkit&&this._isRtlMode()&&!this._containsRtlChars();};this._determineArrowKeyDirection=function(k,s){var f;if(!this._isRtlMode()||!this._containsRtlChars()||s.bHasSelection){if(k.bArrowRight){f='nextTo';}else{f='previousTo';}}else{if(k.bArrowRight){f='previousTo';}else{f='nextTo';}}return f;};this._determineRtlCaretPositionFromSelection=function(s,w){var n,S=this._getTextSelection();if(w){if(s==='nextTo'){if(!this._containsRtlChars()){n=S.iFrom;}else{n=S.iTo;}}else{if(!this._containsRtlChars()){n=S.iTo;}else{n=S.iFrom;}}}else{if(s==='nextTo'){if(!this._containsRtlChars()){n=S.iTo;}else{n=S.iFrom;}}else{if(!this._containsRtlChars()){n=S.iFrom;}else{n=S.iTo;}}}return n;};this._onInputForAndroidHandler=function(o){var k;if(!this._oKeyDownStateAndroid){return;}k=this._buildKeyboardEventInfo(this._oKeyDownStateAndroid.sValue,this._getInputValue(),this._oKeyDownStateAndroid.oSelection);this.updateDomValue(this._oKeyDownStateAndroid.sValue);setTimeout(function(i,f,g){this._setCursorPosition(f.iCursorPosition);if(g.bBackspace){this._revertKey(g,f.oSelection);if(f.oSelection.bHasSelection&&g.sChar){this._keyPressHandler(i,g);}}else{this._keyPressHandler(i,g);}}.bind(this,o,this._oKeyDownStateAndroid,k),0);delete this._oKeyDownStateAndroid;o.preventDefault();};this._buildKeyboardEventInfo=function(o,n,O){var N="",i,r={},f;if(!o&&!n){return{};}if(o&&n&&n.length<o.length){r.bBackspace=true;}for(i=0;i<n.length;i++){f=O.bHasSelection&&O.iFrom===i;if(f||o[i]!==n[i]){N=n[i];break;}}r.sChar=N;return r;};this._isChromeOnAndroid=function(){return D.browser.chrome&&D.os.android;};};return b;},true);
sap.ui.predefine('sap/m/MaskInput',['./InputBase','./MaskEnabler','./MaskInputRenderer'],function(I,M,a){"use strict";
var b=I.extend("sap.m.MaskInput",{metadata:{library:"sap.m",properties:{placeholderSymbol:{type:"string",group:"Misc",defaultValue:"_"},mask:{type:"string",group:"Misc",defaultValue:null},showClearIcon:{type:"boolean",defaultValue:false},effectiveShowClearIcon:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{rules:{type:"sap.m.MaskInputRule",multiple:true,singularName:"rule"}},dnd:{draggable:false,droppable:true}}});
M.call(b.prototype);
b.prototype._isMaskEnabled=function(){return true