#!/bin/bash
. /usr/share/beakerlib/beakerlib.sh || exit 1

rlJournalStart
    rlPhaseStartSetup
        rlRun "tmp=\$(mktemp -d)" 0 "Create tmp directory"
        rlRun "pushd $tmp"
        rlRun "tmt init -t base"
    rlPhaseEnd

    rlPhaseStartTest
        rlRun -s "tmt run --id $(pwd) --rm discover" 2 "Invalid run command"
        rlAssertGrep "workdir .* must not be inside" $rlRun_LOG
    rlPhaseEnd

    rlPhaseStartCleanup
        rlRun "popd"
        rlRun "rm -r $tmp" 0 "Remove tmp directory"
    rlPhaseEnd
rlJournalEnd
