;; Test all the f32 operators on major boundary values and all special
;; values (except comparison and bitwise operators, which are tested in
;; f32_bitwise.wast and f32_cmp.wast).

(module
  (func (export "add") (param $x f32) (param $y f32) (result f32) (f32.add (local.get $x) (local.get $y)))
  (func (export "sub") (param $x f32) (param $y f32) (result f32) (f32.sub (local.get $x) (local.get $y)))
  (func (export "mul") (param $x f32) (param $y f32) (result f32) (f32.mul (local.get $x) (local.get $y)))
  (func (export "div") (param $x f32) (param $y f32) (result f32) (f32.div (local.get $x) (local.get $y)))
  (func (export "sqrt") (param $x f32) (result f32) (f32.sqrt (local.get $x)))
  (func (export "min") (param $x f32) (param $y f32) (result f32) (f32.min (local.get $x) (local.get $y)))
  (func (export "max") (param $x f32) (param $y f32) (result f32) (f32.max (local.get $x) (local.get $y)))
  (func (export "ceil") (param $x f32) (result f32) (f32.ceil (local.get $x)))
  (func (export "floor") (param $x f32) (result f32) (f32.floor (local.get $x)))
  (func (export "trunc") (param $x f32) (result f32) (f32.trunc (local.get $x)))
  (func (export "nearest") (param $x f32) (result f32) (f32.nearest (local.get $x)))
)

(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -0x0p+0)) (f32.const -0x1p-149))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const 0x0p+0)) (f32.const -0x1p-149))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -0x0p+0)) (f32.const 0x1p-149))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const 0x0p+0)) (f32.const 0x1p-149))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -0x1p-149)) (f32.const -0x1p-148))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const 0x1p-149)) (f32.const 0x1p-148))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -0x1p-126)) (f32.const -0x1.000002p-126))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const 0x1p-126)) (f32.const 0x1.fffffcp-127))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -0x1p-126)) (f32.const -0x1.fffffcp-127))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const 0x1p-126)) (f32.const 0x1.000002p-126))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -0x0p+0)) (f32.const -0x1p-126))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const 0x0p+0)) (f32.const -0x1p-126))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -0x0p+0)) (f32.const 0x1p-126))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const 0x0p+0)) (f32.const 0x1p-126))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -0x1p-149)) (f32.const -0x1.000002p-126))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const 0x1p-149)) (f32.const -0x1.fffffcp-127))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -0x1p-149)) (f32.const 0x1.fffffcp-127))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const 0x1p-149)) (f32.const 0x1.000002p-126))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -0x1p-126)) (f32.const -0x1p-125))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const 0x1p-126)) (f32.const 0x1p-125))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -0x0p+0)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const 0x0p+0)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -0x0p+0)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const 0x0p+0)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -0x1p-149)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const 0x1p-149)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -0x1p-149)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const 0x1p-149)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const 0x1p-126)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -0x1p-126)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const 0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1.8p+0))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1.8p+0))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.b21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.721fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.721fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.b21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -0x0p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const 0x0p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -0x0p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const 0x0p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const 0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const 0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const 0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1.8p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1.8p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -0x1p+0)) (f32.const -0x1p+1))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const 0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const 0x1p+0)) (f32.const 0x1p+1))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.d21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.521fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.521fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.d21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1.b21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const -0x1.721fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const 0x1.721fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1.b21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1.d21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const -0x1.521fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const 0x1.521fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1.d21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+3))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+3))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -inf) (f32.const -0x0p+0)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const 0x0p+0)) (f32.const -inf))
(assert_return (invoke "add" (f32.const inf) (f32.const -0x0p+0)) (f32.const inf))
(assert_return (invoke "add" (f32.const inf) (f32.const 0x0p+0)) (f32.const inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const -0x1p-149)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const 0x1p-149)) (f32.const -inf))
(assert_return (invoke "add" (f32.const inf) (f32.const -0x1p-149)) (f32.const inf))
(assert_return (invoke "add" (f32.const inf) (f32.const 0x1p-149)) (f32.const inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const -0x1p-126)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const 0x1p-126)) (f32.const -inf))
(assert_return (invoke "add" (f32.const inf) (f32.const -0x1p-126)) (f32.const inf))
(assert_return (invoke "add" (f32.const inf) (f32.const 0x1p-126)) (f32.const inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const -0x1p-1)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const 0x1p-1)) (f32.const -inf))
(assert_return (invoke "add" (f32.const inf) (f32.const -0x1p-1)) (f32.const inf))
(assert_return (invoke "add" (f32.const inf) (f32.const 0x1p-1)) (f32.const inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const -0x1p+0)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const 0x1p+0)) (f32.const -inf))
(assert_return (invoke "add" (f32.const inf) (f32.const -0x1p+0)) (f32.const inf))
(assert_return (invoke "add" (f32.const inf) (f32.const 0x1p+0)) (f32.const inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const -0x1.921fb6p+2)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const 0x1.921fb6p+2)) (f32.const -inf))
(assert_return (invoke "add" (f32.const inf) (f32.const -0x1.921fb6p+2)) (f32.const inf))
(assert_return (invoke "add" (f32.const inf) (f32.const 0x1.921fb6p+2)) (f32.const inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const -0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const 0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "add" (f32.const inf) (f32.const -0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "add" (f32.const inf) (f32.const 0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const inf) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const inf) (f32.const inf)) (f32.const inf))
(assert_return (invoke "add" (f32.const -inf) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -inf) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -inf) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -inf) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const inf) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const inf) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const inf) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const inf) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const -0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const 0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const -0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const 0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const -0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const -0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const 0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const 0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const -0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const -0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const 0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const 0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const -0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const -0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const 0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const 0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const -0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const -0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const 0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const 0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const -0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const -0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const 0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const 0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const -0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const -0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const 0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const 0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const -0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const -0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const 0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const 0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const -0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const -0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const 0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const 0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const -0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const 0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const -0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const -0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const 0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const 0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const -0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const -0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const 0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const 0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const -0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const -0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const 0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const 0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const -inf)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const inf)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const -inf)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const inf)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const -nan)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const nan)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const -nan:0x200000) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const -nan)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const nan)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "add" (f32.const nan:0x200000) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const 0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const 0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const 0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const 0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -0x0p+0)) (f32.const -0x1p-149))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const 0x0p+0)) (f32.const -0x1p-149))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -0x0p+0)) (f32.const 0x1p-149))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const 0x0p+0)) (f32.const 0x1p-149))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const 0x1p-149)) (f32.const -0x1p-148))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -0x1p-149)) (f32.const 0x1p-148))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -0x1p-126)) (f32.const 0x1.fffffcp-127))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const 0x1p-126)) (f32.const -0x1.000002p-126))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -0x1p-126)) (f32.const 0x1.000002p-126))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const 0x1p-126)) (f32.const -0x1.fffffcp-127))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -0x0p+0)) (f32.const -0x1p-126))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const 0x0p+0)) (f32.const -0x1p-126))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -0x0p+0)) (f32.const 0x1p-126))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const 0x0p+0)) (f32.const 0x1p-126))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -0x1p-149)) (f32.const -0x1.fffffcp-127))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const 0x1p-149)) (f32.const -0x1.000002p-126))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -0x1p-149)) (f32.const 0x1.000002p-126))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const 0x1p-149)) (f32.const 0x1.fffffcp-127))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const 0x1p-126)) (f32.const -0x1p-125))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -0x1p-126)) (f32.const 0x1p-125))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -0x0p+0)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const 0x0p+0)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -0x0p+0)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const 0x0p+0)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -0x1p-149)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const 0x1p-149)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -0x1p-149)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const 0x1p-149)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const 0x1p-126)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -0x1p-126)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const 0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const 0x1p+0)) (f32.const -0x1.8p+0))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -0x1p+0)) (f32.const 0x1.8p+0))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const 0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.721fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.b21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.b21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.721fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -0x0p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const 0x0p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -0x0p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const 0x0p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const 0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const 0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const 0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const 0x1p-1)) (f32.const -0x1.8p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -0x1p-1)) (f32.const 0x1.8p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const 0x1p+0)) (f32.const -0x1p+1))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -0x1p+0)) (f32.const 0x1p+1))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const 0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.521fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.d21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.d21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.521fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1.721fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const -0x1.b21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const 0x1.b21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1.721fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1.521fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const -0x1.d21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const 0x1.d21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1.521fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+3))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+3))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -inf) (f32.const -0x0p+0)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const -inf) (f32.const 0x0p+0)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const -0x0p+0)) (f32.const inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const 0x0p+0)) (f32.const inf))
(assert_return (invoke "sub" (f32.const -inf) (f32.const -0x1p-149)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const -inf) (f32.const 0x1p-149)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const -0x1p-149)) (f32.const inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const 0x1p-149)) (f32.const inf))
(assert_return (invoke "sub" (f32.const -inf) (f32.const -0x1p-126)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const -inf) (f32.const 0x1p-126)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const -0x1p-126)) (f32.const inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const 0x1p-126)) (f32.const inf))
(assert_return (invoke "sub" (f32.const -inf) (f32.const -0x1p-1)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const -inf) (f32.const 0x1p-1)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const -0x1p-1)) (f32.const inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const 0x1p-1)) (f32.const inf))
(assert_return (invoke "sub" (f32.const -inf) (f32.const -0x1p+0)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const -inf) (f32.const 0x1p+0)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const -0x1p+0)) (f32.const inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const 0x1p+0)) (f32.const inf))
(assert_return (invoke "sub" (f32.const -inf) (f32.const -0x1.921fb6p+2)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const -inf) (f32.const 0x1.921fb6p+2)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const -0x1.921fb6p+2)) (f32.const inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const 0x1.921fb6p+2)) (f32.const inf))
(assert_return (invoke "sub" (f32.const -inf) (f32.const -0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const -inf) (f32.const 0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const -0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const 0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "sub" (f32.const -inf) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -inf) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "sub" (f32.const inf) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -inf) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -inf) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -inf) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -inf) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const inf) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const inf) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const inf) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const inf) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const -0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const 0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const -0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const 0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const -0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const 0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const 0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const -0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const -0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const 0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const 0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const -0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const 0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const 0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const -0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const -0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const 0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const 0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const -0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const 0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const 0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const -0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const -0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const 0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const 0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const -0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const 0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const 0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const -0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const -0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const 0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const 0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const -0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const 0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const -0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const -0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const 0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const 0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const -0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const 0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const 0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const -0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const -0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const 0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const 0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const -inf)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const inf)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const -inf)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const inf)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const -nan)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const nan)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const -nan:0x200000) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const -nan)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const nan)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sub" (f32.const nan:0x200000) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const 0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const 0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const 0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const 0x1p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -0x1p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const 0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const 0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const 0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const 0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -0x1p+0)) (f32.const 0x1p-149))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const 0x1p+0)) (f32.const -0x1p-149))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p-149))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p-149))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.8p-147))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.8p-147))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.8p-147))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.8p-147))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const inf)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const 0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const 0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -0x1p-1)) (f32.const 0x1p-127))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const 0x1p-1)) (f32.const -0x1p-127))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-127))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-127))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -0x1p+0)) (f32.const 0x1p-126))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const 0x1p+0)) (f32.const -0x1p-126))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p-126))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p-126))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const inf)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const 0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -0x1p-126)) (f32.const 0x1p-127))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const 0x1p-126)) (f32.const -0x1p-127))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p-127))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p-127))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -0x1p-1)) (f32.const 0x1p-2))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const 0x1p-1)) (f32.const -0x1p-2))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -0x1p-1)) (f32.const -0x1p-2))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const 0x1p-1)) (f32.const 0x1p-2))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const 0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const inf)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const 0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const 0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const inf)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const 0x1.8p-147))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const -0x1.8p-147))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -0x1.8p-147))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const 0x1.8p-147))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const 0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const -0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const 0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const 0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const -0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.3bd3cep+5))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.3bd3cep+5))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.3bd3cep+5))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.3bd3cep+5))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const inf)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const 0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const -0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const 0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const 0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const -0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const 0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const 0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const -0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const 0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const inf)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -inf) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -inf) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const inf) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const inf) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -inf) (f32.const -0x1p-149)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -inf) (f32.const 0x1p-149)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const inf) (f32.const -0x1p-149)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const inf) (f32.const 0x1p-149)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -inf) (f32.const -0x1p-126)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -inf) (f32.const 0x1p-126)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const inf) (f32.const -0x1p-126)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const inf) (f32.const 0x1p-126)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -inf) (f32.const -0x1p-1)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -inf) (f32.const 0x1p-1)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const inf) (f32.const -0x1p-1)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const inf) (f32.const 0x1p-1)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -inf) (f32.const -0x1p+0)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -inf) (f32.const 0x1p+0)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const inf) (f32.const -0x1p+0)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const inf) (f32.const 0x1p+0)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -inf) (f32.const -0x1.921fb6p+2)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -inf) (f32.const 0x1.921fb6p+2)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const inf) (f32.const -0x1.921fb6p+2)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const inf) (f32.const 0x1.921fb6p+2)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -inf) (f32.const -0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -inf) (f32.const 0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const inf) (f32.const -0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const inf) (f32.const 0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -inf) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -inf) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const inf) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "mul" (f32.const inf) (f32.const inf)) (f32.const inf))
(assert_return (invoke "mul" (f32.const -inf) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -inf) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -inf) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -inf) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const inf) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const inf) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const inf) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const inf) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const -0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const 0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const -0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const 0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const -0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const 0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const 0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const -0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const -0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const 0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const 0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const -0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const 0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const 0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const -0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const -0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const 0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const 0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const -0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const 0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const 0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const -0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const -0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const 0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const 0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const -0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const 0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const 0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const -0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const -0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const 0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const 0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const -0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const 0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const -0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const -0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const 0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const 0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const -0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const 0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const 0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const -0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const -0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const 0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const 0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const -inf)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const inf)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const -inf)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const inf)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const -nan)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const nan)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const -nan:0x200000) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const -nan)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const nan)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "mul" (f32.const nan:0x200000) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const 0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const 0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const 0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const 0x1p+0)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -0x1p+0)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const 0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -inf)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const inf)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -inf)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const inf)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -0x0p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const 0x0p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -0x0p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const 0x0p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const 0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const 0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -0x1p-126)) (f32.const 0x1p-23))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const 0x1p-126)) (f32.const -0x1p-23))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -0x1p-126)) (f32.const -0x1p-23))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const 0x1p-126)) (f32.const 0x1p-23))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -0x1p-1)) (f32.const 0x1p-148))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const 0x1p-1)) (f32.const -0x1p-148))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -0x1p-1)) (f32.const -0x1p-148))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const 0x1p-1)) (f32.const 0x1p-148))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -0x1p+0)) (f32.const 0x1p-149))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const 0x1p+0)) (f32.const -0x1p-149))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p-149))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p-149))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -inf)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const inf)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -inf)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const inf)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -0x0p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const 0x0p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -0x0p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const 0x0p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -0x1p-149)) (f32.const 0x1p+23))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const 0x1p-149)) (f32.const -0x1p+23))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -0x1p-149)) (f32.const -0x1p+23))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const 0x1p-149)) (f32.const 0x1p+23))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const 0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const 0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -0x1p-1)) (f32.const 0x1p-125))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const 0x1p-1)) (f32.const -0x1p-125))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-125))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-125))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -0x1p+0)) (f32.const 0x1p-126))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const 0x1p+0)) (f32.const -0x1p-126))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p-126))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p-126))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.45f3p-129))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.45f3p-129))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.45f3p-129))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.45f3p-129))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -inf)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const inf)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -inf)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const inf)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -0x0p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const 0x0p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -0x0p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const 0x0p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -0x1p-149)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const 0x1p-149)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -0x1p-149)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const 0x1p-149)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -0x1p-126)) (f32.const 0x1p+125))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const 0x1p-126)) (f32.const -0x1p+125))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p+125))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p+125))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const 0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const 0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const 0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.45f306p-4))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.45f306p-4))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.45f306p-4))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.45f306p-4))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const 0x1p-129))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const -0x1p-129))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-129))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-129))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -inf)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const inf)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -inf)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const inf)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -0x0p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const 0x0p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -0x0p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const 0x0p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -0x1p-149)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const 0x1p-149)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -0x1p-149)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const 0x1p-149)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -0x1p-126)) (f32.const 0x1p+126))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const 0x1p-126)) (f32.const -0x1p+126))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p+126))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p+126))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -0x1p-1)) (f32.const 0x1p+1))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const 0x1p-1)) (f32.const -0x1p+1))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1p+1))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1p+1))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.45f306p-3))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.45f306p-3))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.45f306p-3))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.45f306p-3))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x1p-128))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x1p-128))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-128))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-128))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -inf)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const inf)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -inf)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const inf)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const 0x1.921fb6p+3))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const -0x1.921fb6p+3))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1.921fb6p+3))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1.921fb6p+3))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const 0x1.921fb8p-126))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const -0x1.921fb8p-126))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -0x1.921fb8p-126))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const 0x1.921fb8p-126))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -inf)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const inf)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -inf)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const inf)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -inf))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const inf))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.45f304p+125))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.45f304p+125))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.45f304p+125))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.45f304p+125))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -inf)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const inf)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -inf)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const inf)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -inf) (f32.const -0x0p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -inf) (f32.const 0x0p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const inf) (f32.const -0x0p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const inf) (f32.const 0x0p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -inf) (f32.const -0x1p-149)) (f32.const inf))
(assert_return (invoke "div" (f32.const -inf) (f32.const 0x1p-149)) (f32.const -inf))
(assert_return (invoke "div" (f32.const inf) (f32.const -0x1p-149)) (f32.const -inf))
(assert_return (invoke "div" (f32.const inf) (f32.const 0x1p-149)) (f32.const inf))
(assert_return (invoke "div" (f32.const -inf) (f32.const -0x1p-126)) (f32.const inf))
(assert_return (invoke "div" (f32.const -inf) (f32.const 0x1p-126)) (f32.const -inf))
(assert_return (invoke "div" (f32.const inf) (f32.const -0x1p-126)) (f32.const -inf))
(assert_return (invoke "div" (f32.const inf) (f32.const 0x1p-126)) (f32.const inf))
(assert_return (invoke "div" (f32.const -inf) (f32.const -0x1p-1)) (f32.const inf))
(assert_return (invoke "div" (f32.const -inf) (f32.const 0x1p-1)) (f32.const -inf))
(assert_return (invoke "div" (f32.const inf) (f32.const -0x1p-1)) (f32.const -inf))
(assert_return (invoke "div" (f32.const inf) (f32.const 0x1p-1)) (f32.const inf))
(assert_return (invoke "div" (f32.const -inf) (f32.const -0x1p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -inf) (f32.const 0x1p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const inf) (f32.const -0x1p+0)) (f32.const -inf))
(assert_return (invoke "div" (f32.const inf) (f32.const 0x1p+0)) (f32.const inf))
(assert_return (invoke "div" (f32.const -inf) (f32.const -0x1.921fb6p+2)) (f32.const inf))
(assert_return (invoke "div" (f32.const -inf) (f32.const 0x1.921fb6p+2)) (f32.const -inf))
(assert_return (invoke "div" (f32.const inf) (f32.const -0x1.921fb6p+2)) (f32.const -inf))
(assert_return (invoke "div" (f32.const inf) (f32.const 0x1.921fb6p+2)) (f32.const inf))
(assert_return (invoke "div" (f32.const -inf) (f32.const -0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "div" (f32.const -inf) (f32.const 0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "div" (f32.const inf) (f32.const -0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "div" (f32.const inf) (f32.const 0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "div" (f32.const -inf) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -inf) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const inf) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const inf) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -inf) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -inf) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -inf) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -inf) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const inf) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const inf) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const inf) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const inf) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const -0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const 0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const -0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const 0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const -0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const -0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const 0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const 0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const -0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const -0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const 0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const 0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const -0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const -0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const 0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const 0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const -0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const -0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const 0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const 0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const -0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const -0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const 0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const 0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const -0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const -0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const 0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const 0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const -0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const -0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const 0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const 0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const -0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const -0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const 0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const 0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const -0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const 0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const -0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const -0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const 0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const 0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const -0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const -0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const 0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const 0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const -0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const -0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const 0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const 0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const -inf)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const inf)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const -inf)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const inf)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const -nan)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const nan)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const -nan:0x200000) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const -nan)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const nan)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "div" (f32.const nan:0x200000) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const 0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const 0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const 0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const 0x1p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const 0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const inf)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const inf)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -0x0p+0)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const 0x0p+0)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const 0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const 0x1p-126)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const 0x1p-126)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const 0x1p-1)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const 0x1p-1)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const 0x1p+0)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const inf)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const inf)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -0x0p+0)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const 0x0p+0)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -0x1p-149)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const 0x1p-149)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const 0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const 0x1p-1)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const 0x1p+0)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const inf)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const inf)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -0x0p+0)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const 0x0p+0)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -0x1p-149)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const 0x1p-149)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const 0x1p-126)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const 0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const inf)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const inf)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -0x0p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const 0x0p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const 0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const 0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const 0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const inf)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const inf)) (f32.const 0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const inf)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const inf)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const inf)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const inf)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -inf) (f32.const -0x0p+0)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -inf) (f32.const 0x0p+0)) (f32.const -inf))
(assert_return (invoke "min" (f32.const inf) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const inf) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -inf) (f32.const -0x1p-149)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -inf) (f32.const 0x1p-149)) (f32.const -inf))
(assert_return (invoke "min" (f32.const inf) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const inf) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -inf) (f32.const -0x1p-126)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -inf) (f32.const 0x1p-126)) (f32.const -inf))
(assert_return (invoke "min" (f32.const inf) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const inf) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -inf) (f32.const -0x1p-1)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -inf) (f32.const 0x1p-1)) (f32.const -inf))
(assert_return (invoke "min" (f32.const inf) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const inf) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -inf) (f32.const -0x1p+0)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -inf) (f32.const 0x1p+0)) (f32.const -inf))
(assert_return (invoke "min" (f32.const inf) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const inf) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "min" (f32.const -inf) (f32.const -0x1.921fb6p+2)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -inf) (f32.const 0x1.921fb6p+2)) (f32.const -inf))
(assert_return (invoke "min" (f32.const inf) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const inf) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -inf) (f32.const -0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -inf) (f32.const 0x1.fffffep+127)) (f32.const -inf))
(assert_return (invoke "min" (f32.const inf) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const inf) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -inf) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const -inf) (f32.const inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const inf) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "min" (f32.const inf) (f32.const inf)) (f32.const inf))
(assert_return (invoke "min" (f32.const -inf) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -inf) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -inf) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -inf) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const inf) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const inf) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const inf) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const inf) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const -0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const 0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const -0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const 0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const -0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const -0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const 0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const 0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const -0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const -0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const 0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const 0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const -0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const -0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const 0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const 0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const -0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const -0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const 0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const 0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const -0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const -0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const 0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const 0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const -0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const -0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const 0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const 0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const -0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const -0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const 0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const 0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const -0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const -0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const 0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const 0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const -0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const 0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const -0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const -0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const 0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const 0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const -0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const -0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const 0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const 0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const -0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const -0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const 0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const 0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const -inf)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const inf)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const -inf)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const inf)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const -nan)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const nan)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const -nan:0x200000) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const -nan)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const nan)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "min" (f32.const nan:0x200000) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -0x1p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -inf)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -inf)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -0x0p+0)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const 0x0p+0)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -0x1p-126)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -0x1p-126)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -0x1p-1)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -0x1p-1)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -0x1p+0)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -inf)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -inf)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -0x0p+0)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const 0x0p+0)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -0x1p-149)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const 0x1p-149)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -0x1p-1)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -0x1p+0)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -inf)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -inf)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -0x0p+0)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const 0x0p+0)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -0x1p-149)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const 0x1p-149)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -0x1p-126)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -inf)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -inf)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -0x0p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const 0x0p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const 0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -inf)) (f32.const -0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -inf)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -inf)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -inf)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -inf)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -inf)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -inf) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -inf) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const inf) (f32.const -0x0p+0)) (f32.const inf))
(assert_return (invoke "max" (f32.const inf) (f32.const 0x0p+0)) (f32.const inf))
(assert_return (invoke "max" (f32.const -inf) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -inf) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const inf) (f32.const -0x1p-149)) (f32.const inf))
(assert_return (invoke "max" (f32.const inf) (f32.const 0x1p-149)) (f32.const inf))
(assert_return (invoke "max" (f32.const -inf) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -inf) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const inf) (f32.const -0x1p-126)) (f32.const inf))
(assert_return (invoke "max" (f32.const inf) (f32.const 0x1p-126)) (f32.const inf))
(assert_return (invoke "max" (f32.const -inf) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -inf) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const inf) (f32.const -0x1p-1)) (f32.const inf))
(assert_return (invoke "max" (f32.const inf) (f32.const 0x1p-1)) (f32.const inf))
(assert_return (invoke "max" (f32.const -inf) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "max" (f32.const -inf) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const inf) (f32.const -0x1p+0)) (f32.const inf))
(assert_return (invoke "max" (f32.const inf) (f32.const 0x1p+0)) (f32.const inf))
(assert_return (invoke "max" (f32.const -inf) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -inf) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const inf) (f32.const -0x1.921fb6p+2)) (f32.const inf))
(assert_return (invoke "max" (f32.const inf) (f32.const 0x1.921fb6p+2)) (f32.const inf))
(assert_return (invoke "max" (f32.const -inf) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -inf) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const inf) (f32.const -0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "max" (f32.const inf) (f32.const 0x1.fffffep+127)) (f32.const inf))
(assert_return (invoke "max" (f32.const -inf) (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "max" (f32.const -inf) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const inf) (f32.const -inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const inf) (f32.const inf)) (f32.const inf))
(assert_return (invoke "max" (f32.const -inf) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -inf) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -inf) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -inf) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const inf) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const inf) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const inf) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const inf) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const -0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const 0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const -0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const -0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const 0x0p+0)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const 0x0p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const -0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const -0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const 0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const 0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const -0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const -0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const 0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const 0x1p-149)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const -0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const -0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const 0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const 0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const -0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const -0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const 0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const 0x1p-126)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const -0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const -0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const 0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const 0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const -0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const -0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const 0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const 0x1p-1)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const -0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const -0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const 0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const 0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const -0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const -0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const 0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const 0x1p+0)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const -0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const 0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const -0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const -0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const 0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const 0x1.921fb6p+2)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const -0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const -0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const 0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const 0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const -0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const -0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const 0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const 0x1.fffffep+127)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const -inf)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const inf)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const -inf)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const inf)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const inf)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const -nan)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const nan)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const -nan:0x200000) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const -nan)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const nan)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "max" (f32.const nan:0x200000) (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sqrt" (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "sqrt" (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "sqrt" (f32.const -0x1p-149)) (f32.const nan:canonical))
(assert_return (invoke "sqrt" (f32.const 0x1p-149)) (f32.const 0x1.6a09e6p-75))
(assert_return (invoke "sqrt" (f32.const -0x1p-126)) (f32.const nan:canonical))
(assert_return (invoke "sqrt" (f32.const 0x1p-126)) (f32.const 0x1p-63))
(assert_return (invoke "sqrt" (f32.const -0x1p-1)) (f32.const nan:canonical))
(assert_return (invoke "sqrt" (f32.const 0x1p-1)) (f32.const 0x1.6a09e6p-1))
(assert_return (invoke "sqrt" (f32.const -0x1p+0)) (f32.const nan:canonical))
(assert_return (invoke "sqrt" (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sqrt" (f32.const -0x1.921fb6p+2)) (f32.const nan:canonical))
(assert_return (invoke "sqrt" (f32.const 0x1.921fb6p+2)) (f32.const 0x1.40d932p+1))
(assert_return (invoke "sqrt" (f32.const -0x1.fffffep+127)) (f32.const nan:canonical))
(assert_return (invoke "sqrt" (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+63))
(assert_return (invoke "sqrt" (f32.const -inf)) (f32.const nan:canonical))
(assert_return (invoke "sqrt" (f32.const inf)) (f32.const inf))
(assert_return (invoke "sqrt" (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "sqrt" (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "sqrt" (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "sqrt" (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "floor" (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "floor" (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "floor" (f32.const -0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "floor" (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "floor" (f32.const -0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "floor" (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "floor" (f32.const -0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "floor" (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "floor" (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "floor" (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "floor" (f32.const -0x1.921fb6p+2)) (f32.const -0x1.cp+2))
(assert_return (invoke "floor" (f32.const 0x1.921fb6p+2)) (f32.const 0x1.8p+2))
(assert_return (invoke "floor" (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "floor" (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "floor" (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "floor" (f32.const inf)) (f32.const inf))
(assert_return (invoke "floor" (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "floor" (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "floor" (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "floor" (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "ceil" (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "ceil" (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "ceil" (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "ceil" (f32.const 0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "ceil" (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "ceil" (f32.const 0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "ceil" (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "ceil" (f32.const 0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "ceil" (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "ceil" (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "ceil" (f32.const -0x1.921fb6p+2)) (f32.const -0x1.8p+2))
(assert_return (invoke "ceil" (f32.const 0x1.921fb6p+2)) (f32.const 0x1.cp+2))
(assert_return (invoke "ceil" (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "ceil" (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "ceil" (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "ceil" (f32.const inf)) (f32.const inf))
(assert_return (invoke "ceil" (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "ceil" (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "ceil" (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "ceil" (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "trunc" (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "trunc" (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "trunc" (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "trunc" (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "trunc" (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "trunc" (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "trunc" (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "trunc" (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "trunc" (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "trunc" (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "trunc" (f32.const -0x1.921fb6p+2)) (f32.const -0x1.8p+2))
(assert_return (invoke "trunc" (f32.const 0x1.921fb6p+2)) (f32.const 0x1.8p+2))
(assert_return (invoke "trunc" (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "trunc" (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "trunc" (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "trunc" (f32.const inf)) (f32.const inf))
(assert_return (invoke "trunc" (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "trunc" (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "trunc" (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "trunc" (f32.const nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "nearest" (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "nearest" (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "nearest" (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "nearest" (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "nearest" (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "nearest" (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "nearest" (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "nearest" (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "nearest" (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "nearest" (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "nearest" (f32.const -0x1.921fb6p+2)) (f32.const -0x1.8p+2))
(assert_return (invoke "nearest" (f32.const 0x1.921fb6p+2)) (f32.const 0x1.8p+2))
(assert_return (invoke "nearest" (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "nearest" (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "nearest" (f32.const -inf)) (f32.const -inf))
(assert_return (invoke "nearest" (f32.const inf)) (f32.const inf))
(assert_return (invoke "nearest" (f32.const -nan)) (f32.const nan:canonical))
(assert_return (invoke "nearest" (f32.const -nan:0x200000)) (f32.const nan:arithmetic))
(assert_return (invoke "nearest" (f32.const nan)) (f32.const nan:canonical))
(assert_return (invoke "nearest" (f32.const nan:0x200000)) (f32.const nan:arithmetic))


;; Type check

(assert_invalid (module (func (result f32) (f32.add (i64.const 0) (f64.const 0)))) "type mismatch")
(assert_invalid (module (func (result f32) (f32.div (i64.const 0) (f64.const 0)))) "type mismatch")
(assert_invalid (module (func (result f32) (f32.max (i64.const 0) (f64.const 0)))) "type mismatch")
(assert_invalid (module (func (result f32) (f32.min (i64.const 0) (f64.const 0)))) "type mismatch")
(assert_invalid (module (func (result f32) (f32.mul (i64.const 0) (f64.const 0)))) "type mismatch")
(assert_invalid (module (func (result f32) (f32.sub (i64.const 0) (f64.const 0)))) "type mismatch")
(assert_invalid (module (func (result f32) (f32.ceil (i64.const 0)))) "type mismatch")
(assert_invalid (module (func (result f32) (f32.floor (i64.const 0)))) "type mismatch")
(assert_invalid (module (func (result f32) (f32.nearest (i64.const 0)))) "type mismatch")
(assert_invalid (module (func (result f32) (f32.sqrt (i64.const 0)))) "type mismatch")
(assert_invalid (module (func (result f32) (f32.trunc (i64.const 0)))) "type mismatch")

;; These float literal patterns are only allowed in scripts, not in text format.
(assert_malformed
  (module quote "(func (result f32) (f32.const nan:arithmetic))")
  "unexpected token"
)
(assert_malformed
  (module quote "(func (result f32) (f32.const nan:canonical))")
  "unexpected token"
)
