/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "sw_CD" locale.
 */
public class LocalizedNamesImpl_sw_CD extends LocalizedNamesImpl_sw {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "ZA",
        "AF",
        "IS",
        "AR",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AM",
        "AW",
        "AU",
        "AT",
        "IE",
        "AZ",
        "BB",
        "BS",
        "BH",
        "BD",
        "BY",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BF",
        "BG",
        "BI",
        "CV",
        "EA",
        "TD",
        "CZ",
        "CL",
        "CU",
        "CW",
        "DK",
        "DG",
        "DM",
        "EC",
        "SV",
        "IO",
        "ER",
        "EE",
        "ET",
        "EZ",
        "AE",
        "FJ",
        "GA",
        "GM",
        "GH",
        "GI",
        "GN",
        "GW",
        "GL",
        "GD",
        "GP",
        "GU",
        "GT",
        "GG",
        "GF",
        "GQ",
        "GY",
        "HT",
        "TF",
        "HN",
        "HK",
        "HU",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IL",
        "IT",
        "JM",
        "CF",
        "DO",
        "CD",
        "JP",
        "JE",
        "DJ",
        "GE",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "KI",
        "KG",
        "AC",
        "BV",
        "CX",
        "CP",
        "HM",
        "IM",
        "NF",
        "CI",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "XK",
        "CR",
        "HR",
        "KW",
        "LA",
        "LU",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "MO",
        "MK",
        "MG",
        "PS",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "US",
        "MQ",
        "YT",
        "MX",
        "FM",
        "EG",
        "VA",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MU",
        "MR",
        "MA",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NC",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "NZ",
        "QO",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PL",
        "PF",
        "PR",
        "RE",
        "RO",
        "RW",
        "EH",
        "CY",
        "WS",
        "AS",
        "SM",
        "PM",
        "ST",
        "SA",
        "SN",
        "RS",
        "SL",
        "SG",
        "SX",
        "SK",
        "SI",
        "SO",
        "LK",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "VC",
        "SD",
        "SS",
        "SR",
        "SJ",
        "SY",
        "TH",
        "TW",
        "TJ",
        "TZ",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TV",
        "BE",
        "CN",
        "GB",
        "FR",
        "PH",
        "FI",
        "UG",
        "GR",
        "ES",
        "NL",
        "BQ",
        "DE",
        "UA",
        "UN",
        "EU",
        "PT",
        "UY",
        "RU",
        "SC",
        "SZ",
        "SE",
        "CH",
        "TR",
        "UZ",
        "VU",
        "VE",
        "VN",
        "UM",
        "AX",
        "KY",
        "CC",
        "CK",
        "FK",
        "FO",
        "GS",
        "IC",
        "MP",
        "MH",
        "PN",
        "SB",
        "TC",
        "VI",
        "VG",
        "WF",
        "XA",
        "XB",
        "YE",
        "JO",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("030", "Asia Mashariki");
    namesMap.put("AF", "Afuganistani");
    namesMap.put("AZ", "Azabajani");
    namesMap.put("BJ", "Benini");
    namesMap.put("CI", "Kodivaa");
    namesMap.put("CX", "Kisiwa cha Christmas");
    namesMap.put("CY", "Saiprasi");
    namesMap.put("DK", "Denmaki");
    namesMap.put("HR", "Kroeshia");
    namesMap.put("JO", "Yordani");
    namesMap.put("LB", "Lebanoni");
    namesMap.put("LI", "Lishenteni");
    namesMap.put("LU", "Lasembagi");
    namesMap.put("LV", "Lativia");
    namesMap.put("MA", "Moroko");
    namesMap.put("MM", "Myama");
    namesMap.put("MV", "Maldivi");
    namesMap.put("NE", "Nijeri");
    namesMap.put("NG", "Nijeria");
    namesMap.put("NO", "Norwe");
    namesMap.put("NP", "Nepali");
    namesMap.put("OM", "Omani");
    namesMap.put("PR", "Puetoriko");
    namesMap.put("QA", "Katari");
    namesMap.put("SD", "Sudani");
    namesMap.put("ST", "Sao Tome na Prinsipe");
    namesMap.put("TD", "Chadi");
    namesMap.put("TL", "Timori ya Mashariki");
    namesMap.put("VN", "Vietnamu");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "030": "Asia Mashariki",
        "AF": "Afuganistani",
        "AZ": "Azabajani",
        "BJ": "Benini",
        "CI": "Kodivaa",
        "CX": "Kisiwa cha Christmas",
        "CY": "Saiprasi",
        "DK": "Denmaki",
        "HR": "Kroeshia",
        "JO": "Yordani",
        "LB": "Lebanoni",
        "LI": "Lishenteni",
        "LU": "Lasembagi",
        "LV": "Lativia",
        "MA": "Moroko",
        "MM": "Myama",
        "MV": "Maldivi",
        "NE": "Nijeri",
        "NG": "Nijeria",
        "NO": "Norwe",
        "NP": "Nepali",
        "OM": "Omani",
        "PR": "Puetoriko",
        "QA": "Katari",
        "SD": "Sudani",
        "ST": "Sao Tome na Prinsipe",
        "TD": "Chadi",
        "TL": "Timori ya Mashariki",
        "VN": "Vietnamu"
    };
  }-*/;
}
