vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO chenjunfu2/NBT_CPP
    REF "v${VERSION}"
    HEAD_REF master
    SHA512 94a9966c713b46d848111e73aaf062dee770c585810f9b985038e7987c114859776d8537c120a1002b89e559f4087a3964e13ea29f508ce125a36bb5927dda21
)

# install
file(INSTALL "${SOURCE_PATH}/include/nbt_cpp/"
     DESTINATION "${CURRENT_PACKAGES_DIR}/include/nbt_cpp"
     FILES_MATCHING
     PATTERN "*.hpp"
     PATTERN "*.h"
     PATTERN "vcpkg_config.h" EXCLUDE
)

# vcpkg_config
set(CONFIG_HEADER_CONTENT "#pragma once\n\n")
set(CONFIG_HEADER_CONTENT "${CONFIG_HEADER_CONTENT}//Auto-generated by vcpkg - DO NOT EDIT\n\n")

if("zlib" IN_LIST FEATURES)
    set(CONFIG_HEADER_CONTENT "${CONFIG_HEADER_CONTENT}//use zlib\n")
    set(CONFIG_HEADER_CONTENT "${CONFIG_HEADER_CONTENT}#define CJF2_NBT_CPP_USE_ZLIB\n\n")
endif()

if("xxhash" IN_LIST FEATURES)
    set(CONFIG_HEADER_CONTENT "${CONFIG_HEADER_CONTENT}//use xxhash\n")
    set(CONFIG_HEADER_CONTENT "${CONFIG_HEADER_CONTENT}#define CJF2_NBT_CPP_USE_XXHASH\n\n")
endif()

file(WRITE "${CURRENT_PACKAGES_DIR}/include/nbt_cpp/vcpkg_config.h" "${CONFIG_HEADER_CONTENT}")

# copyright
file(INSTALL "${SOURCE_PATH}/LICENSE" DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}" RENAME copyright)
